#!/bin/sh

delete_groups_if_necessary() {

  groups=$1

  for group in $groups; do
    if [ "$group" = "users" ]; then continue; fi
    
    users_of_group=`grep -e "^$group:" /etc/group | cut -d: -f4`
    if [ "$users_of_group" = "" ]; then
      echo "No body in this group \"$group\".."
      echo -n "Do you want to delete the group \"$group\" [Y|n]? "
      read -t 5 ANS
      if [ "$ANS" = "" -o "$ANS" = "Y" -o "$ANS" = "y" ]; then
        groupdel $group
      fi
    fi
  done
}

delete_range_user() {

  prefix=$1
  start=$2
  end=$3

  # Blake, 2004/02/03
  nnum=`echo -n "$end" | wc -c`
  i=$start
  while [ $i -le $end ] ; do
    label="$i"
    #if [ $i -lt 10 ] ; then 
    #  label="00$i"
    #elif [ $i -lt 100 ] ; then
    #  label="0$i"
    #fi
    n=`echo -n "$label" | wc -c`
    while [ $n -lt $nnum ]; do
      label="0$label"
      n=`echo -n "$label" | wc -c`
    done

    # Blake, 2004/02/04, check group
    groups=`/usr/bin/groups $prefix$label | cut -d: -f2`   

    userdel $prefix$label
    rm -rf /home/$prefix$label

    delete_groups_if_necessary "$groups"

    i=`expr $i + 1`
  done
}

## main
case "$1" in
  '--single'|'-s')
    username="$2"
    if [ "$username" != "" ]; then
      userdel $username
      rm -rf /home/$username
    fi
    ;;

  '--range'|'-r')
    prefix=$2
    start=$3
    end=$4
    delete_range_user $prefix $start $end

    ;;

  '--file'|'-f')
    filename=$2
    # Blake, 2004/02/04
    if [ ! -f $filename ]; then exit; fi
    while read line; do
      if [ "$(echo $line | grep -e "^#")" != "" ]; then continue; fi
      echo $line | \
      while read prefix start end  password_opt group; do
         delete_range_user $prefix $start $end
      done
    done < $filename
    #while read username x
    #do
    #  if [ "$username" != "" ]; then
    #    userdel $username
    #    rm -rf /home/$username
    #  fi
    #done < $file
    ;;

  '--group'|'-g')
    if [ "$2" = "users" ]; then exit; fi
    users_of_group=$(grep "^$2:" /etc/group | cut -d: -f4)
    OLDIFS=$IFS
    IFS=","
    for username in $users_of_group; do
      if [ "$username" != "" ]; then
        userdel $username
        rm -rf /home/$username
      fi
    done
    groupdel $2
    IFS=$OLDIFS
    ;;

  '--list'|'-l')

     filename=$2
     while read line; do
       if [ "$(echo $line | grep -e "^#")" != "" ]; then continue; fi
       echo $line | \
       while read username password_opt groupname; do
         groups=`/usr/bin/groups $username | cut -d: -f2`
         userdel $username
         rm -rf /home/$username
         delete_groups_if_necessary "$groups"
       done
     done < $filename
     ;;

   *)
    echo "Usage: "
    echo "  deluser.sh --single|-s <username>"
    echo "  deluser.sh --range|-r <prefix> <start> <end>"
    echo "  deluser.sh --file|-f <filename>"
    echo "  deluser.sh --group|-g"
    ;;
esac
