#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <signal.h>
#include <fcntl.h>

#define PIDDIR "/var/run"

int readline(int fd, char* ptr, int maxlen)
{
  int n, rc;
  char c;

  for(n = 1; n < maxlen; n++)
  {
    if( (rc = read(fd,&c,1)) == 1 )
    {
      *ptr++ = c;
      if( c=='\n' ) break;
    }
    else if( rc==0 )
    {
      if( n==1 ) return EOF; // EOF, no data read
      else break; // EOF, some data was read
    }
    else 
    {
      printf("line 41: read line error");
      return rc;
    } 
  }

  *ptr = 0;
  return n;
}

int main(int argc, char** argv) {

  int fd, pid;
  char buf[BUFSIZ];
  struct stat pid_stat;
  
  if(argc!=2) { printf("Usage: %s vpn_name\n",argv[0]); exit(0); }

  sprintf(buf,"%s/ppp-%s.pid",PIDDIR,argv[1]);

  fd=open(buf,O_RDONLY);
  if(fd<0) { printf("Cannot open the file: %s\n", buf); exit(0); }
  // Get file information
  stat(buf, &pid_stat);
  if(!(pid_stat.st_mode & S_IFREG) || 
     pid_stat.st_uid!=0 || 
	 pid_stat.st_gid!=0) {
	 close(fd);
     printf("Incorrect file owner/group\n"); 
	 exit(0);
  }
  // Get pid from file and send SIGTERM signal 
  if(readline(fd, buf, BUFSIZ)!=EOF) {
     pid=atoi(buf);
	 printf("pid: %d\n", pid);
	 kill(pid,SIGTERM);
  }
  close(fd);

  // remove itself
  unlink(argv[0]);
}
