/*
 * Decompiled with CFR 0.152.
 */
package dvi;

import dvi.util.Canonicalizer;
import dvi.util.SimpleCanonicalizer;

public final class DviFontName {
    private final int al;
    private final int nl;
    private final String name;
    private final int hash;
    private static final Canonicalizer<DviFontName> canonicalizer = new SimpleCanonicalizer<DviFontName>();
    private volatile String string = null;

    private DviFontName(int al, int nl, String name) {
        if (name == null) {
            throw new NullPointerException("name can't be null");
        }
        if (al < 0 || 255 < al) {
            throw new IllegalArgumentException("illegal value of area length: " + al);
        }
        if (nl < 0 || 255 < nl) {
            throw new IllegalArgumentException("illegal value of name length: " + nl);
        }
        if (name.length() != al + nl) {
            throw new IllegalArgumentException("name size mismatch: name.length()=" + name.length() + " al=" + al + " nl=" + nl);
        }
        this.al = al;
        this.nl = nl;
        this.name = name;
        this.hash = al + 33 * (nl + 33 * name.hashCode());
    }

    public int areaLength() {
        return this.al;
    }

    public int nameLength() {
        return this.nl;
    }

    public String name() {
        return this.name;
    }

    public static DviFontName getInstance(int al, int nl, String name) {
        return canonicalizer.canonicalize(new DviFontName(al, nl, name));
    }

    public static DviFontName getInstance(int nl, String name) {
        return DviFontName.getInstance(0, nl, name);
    }

    public static DviFontName getInstance(String name) {
        return DviFontName.getInstance(0, name.length(), name);
    }

    public String toString() {
        if (this.string == null) {
            this.string = String.valueOf(this.getClass().getName()) + "[al=" + this.al + " nl=" + this.nl + " name=" + this.name + "]";
        }
        return this.string;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof DviFontName) {
            DviFontName fn = (DviFontName)obj;
            return this.name.equals(fn.name) && this.al == fn.al && this.nl == fn.nl;
        }
        return false;
    }

    public int hashCode() {
        return this.hash;
    }
}

