/*
 * Decompiled with CFR 0.152.
 */
package dvi;

import java.io.Serializable;

public final class DviResolution
implements Serializable {
    private static final long serialVersionUID = -8353020586758660972L;
    public static final int MAX_SHRINK_FACTOR = 1024;
    private final int dpi;
    private final int shrinkFactor;
    private final double actualDpi;

    public DviResolution(int dpi, int shrinkFactor) {
        this.dpi = dpi;
        this.shrinkFactor = shrinkFactor;
        this.checkVars();
        this.actualDpi = (double)dpi / (double)shrinkFactor;
    }

    private void checkVars() {
        if (this.shrinkFactor <= 0 || 1024 < this.shrinkFactor) {
            throw new IllegalArgumentException("Illegal value of shrinkFactor: " + this.shrinkFactor);
        }
    }

    public double actualDpi() {
        return this.actualDpi;
    }

    public int dpi() {
        return this.dpi;
    }

    public int shrinkFactor() {
        return this.shrinkFactor;
    }

    public DviResolution approximate(double approximateDpi) {
        int sf = (int)Math.floor((double)this.dpi / approximateDpi);
        sf = Math.min(sf, 1024);
        sf = Math.max(sf, 1);
        return new DviResolution(this.dpi, sf);
    }

    public String toString() {
        return String.format(String.valueOf(this.getClass().getName()) + "[dpi=%d,shrinkFactor=%d,actualDpi=%.1f]", this.dpi, this.shrinkFactor, this.actualDpi());
    }

    public boolean equals(Object obj) {
        if (obj instanceof DviResolution) {
            DviResolution a = (DviResolution)obj;
            return a.dpi == this.dpi && a.shrinkFactor == this.shrinkFactor;
        }
        return false;
    }

    public int hashCode() {
        return this.dpi + 33 * this.shrinkFactor;
    }
}

