/*
 * Decompiled with CFR 0.152.
 */
package dvi;

import dvi.DviResolution;
import dvi.util.Canonicalizer;
import dvi.util.SimpleCanonicalizer;
import java.io.Serializable;

public final class DviUnit
implements Serializable {
    private static final long serialVersionUID = -3040236351321035760L;
    public static final DviUnit DEFAULT;
    private static final Canonicalizer<DviUnit> canonicalizer;
    private final int num;
    private final int den;
    private final int mag;
    private final double inchPerDvi;
    private final double pointPerDvi;
    private final int hash;
    private volatile String string = null;

    static {
        canonicalizer = new SimpleCanonicalizer<DviUnit>();
        DEFAULT = canonicalizer.canonicalize(new DviUnit());
    }

    private DviUnit() {
        this.num = 25400000;
        this.den = 473628672;
        this.mag = 1000;
        this.inchPerDvi = (double)this.num / 254000.0 / (double)this.den * ((double)this.mag / 1000.0);
        this.pointPerDvi = (double)this.num / 254000.0 / ((double)this.den / 72.27) * ((double)this.mag / 1000.0);
        this.hash = this.hashCodeInternal();
    }

    private DviUnit(int num, int den, int mag) {
        this.num = num;
        this.den = den;
        this.mag = mag;
        this.checkVars();
        this.inchPerDvi = (double)num / 254000.0 / (double)den * ((double)mag / 1000.0);
        this.pointPerDvi = (double)num / 254000.0 / ((double)den / 72.27) * ((double)mag / 1000.0);
        this.hash = this.hashCodeInternal();
    }

    public static DviUnit getInstance(int num, int den, int mag) {
        return canonicalizer.canonicalize(new DviUnit(num, den, mag));
    }

    private int hashCodeInternal() {
        return this.num + 33 * (this.den + 33 * this.mag);
    }

    public int numerator() {
        return this.num;
    }

    public int denominator() {
        return this.den;
    }

    public int magnification() {
        return this.mag;
    }

    public double inchPerDvi() {
        return this.inchPerDvi;
    }

    public double pointPerDvi() {
        return this.pointPerDvi;
    }

    public double dotPerDvi(int dpi) {
        return this.inchPerDvi * (double)dpi;
    }

    public double mmPerDvi(int dpi) {
        return this.inchPerDvi * 25.4;
    }

    public int mapToPixel(int a, int dpi) {
        return (int)this.mapToPixelDouble(a, dpi);
    }

    public int mapToPixel(int a, DviResolution res) {
        return (int)this.mapToPixelDouble(a, res);
    }

    public double factorDouble(int dpi) {
        return (double)dpi * this.inchPerDvi;
    }

    public double factorDouble(DviResolution res) {
        return res.actualDpi() * this.inchPerDvi;
    }

    public double mapToPixelDouble(int a, int dpi) {
        return (double)dpi * this.inchPerDvi * (double)a + 0.5;
    }

    public double mapToPixelDouble(int a, DviResolution res) {
        return res.actualDpi() * this.inchPerDvi * (double)a + 0.5;
    }

    private void checkVars() {
        if (this.num <= 0 || this.den <= 0 || this.mag <= 0) {
            throw new IllegalArgumentException("Invalid values of num/den*mag");
        }
    }

    public String toString() {
        if (this.string == null) {
            this.string = String.valueOf(this.getClass().getName()) + "[" + this.num + "/" + this.den + "*" + this.mag + "]";
        }
        return this.string;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DviUnit) {
            DviUnit a = (DviUnit)obj;
            return a.num == this.num && a.den == this.den && a.mag == this.mag;
        }
        return false;
    }

    public int hashCode() {
        return this.hash;
    }
}

