/*
 * Decompiled with CFR 0.152.
 */
package dvi.browser;

import dvi.DviException;
import dvi.api.DviContext;
import dvi.api.DviContextSupport;
import dvi.browser.DviAddressBar;
import dvi.browser.DviBrowserPage;
import dvi.browser.DviBrowserStatusBar;
import dvi.browser.DviDirectoryIndexCellRenderer;
import dvi.browser.DviFileListModel;
import dvi.browser.DviURLHistory;
import dvi.browser.DviURLHistoryRecord;
import dvi.event.TEvent;
import dvi.event.TEventListener;
import dvi.util.DviDesktop;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DviBrowserMain
extends JFrame
implements ActionListener,
TEventListener,
DviContextSupport {
    private static final Logger LOGGER = Logger.getLogger(DviBrowserMain.class.getName());
    private static final long serialVersionUID = -970130861572045308L;
    private JList listView;
    private DviAddressBar addressBar;
    private DviFileListModel model;
    private DviBrowserStatusBar statusBar;
    private JTabbedPane tabs = new JTabbedPane();
    private DviURLHistory history;
    private final DviContextSupport dcs;
    private static final Pattern dviFilenamePat = Pattern.compile("^.*(\\.dvi)$", 2);

    public DviContext getDviContext() {
        return this.dcs.getDviContext();
    }

    public DviBrowserMain(DviContextSupport dcs) {
        super("dvibrowser");
        this.dcs = dcs;
        this.initializeCompontents();
        this.open("file:///");
    }

    private void initializeCompontents() {
        this.initializeMenuBar();
        this.history = new DviURLHistory(this);
        this.model = new DviFileListModel();
        this.listView = new JList(this.model);
        this.listView.setCellRenderer(new DviDirectoryIndexCellRenderer(this));
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BorderLayout());
        leftPanel.add(new JScrollPane(this.listView));
        this.tabs = new JTabbedPane();
        JSplitPane split = new JSplitPane(1);
        split.setDividerLocation(192);
        split.setLeftComponent(leftPanel);
        split.setRightComponent(this.tabs);
        this.addressBar = new DviAddressBar(this);
        this.statusBar = new DviBrowserStatusBar(this);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.addressBar, "North");
        panel.add((Component)split, "Center");
        panel.add((Component)this.statusBar, "South");
        this.getContentPane().add(panel);
        this.addressBar.getAddressEdit().addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    DviBrowserMain.this.openURLOfAddressBar();
                }
            }
        });
        this.listView.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    DviBrowserMain.this.openBySelection();
                }
            }
        });
        this.listView.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    DviBrowserMain.this.openBySelection();
                } else if (e.getKeyCode() == 39) {
                    DviBrowserMain.this.openBySelectionIfFolder();
                } else if (e.getKeyCode() == 8) {
                    DviBrowserMain.this.goBack();
                } else if (e.getKeyCode() == 37) {
                    DviBrowserMain.this.goUp();
                }
            }
        });
        this.tabs.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                DviBrowserMain.this.updateTabInfo();
            }
        });
    }

    private void initializeMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        menuBar.add(fileMenu);
        this.setJMenuBar(menuBar);
        JMenuItem fileOpen = new JMenuItem("Open");
        JMenuItem fileReload = new JMenuItem("Reload");
        JMenuItem fileExit = new JMenuItem("Exit");
        fileOpen.setMnemonic(79);
        fileOpen.setActionCommand("Open");
        fileOpen.addActionListener(this);
        fileOpen.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        fileMenu.add(fileOpen);
        fileReload.setMnemonic(82);
        fileReload.setActionCommand("Reload");
        fileReload.addActionListener(this);
        fileReload.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        fileMenu.add(fileReload);
        fileMenu.addSeparator();
        fileExit.setMnemonic(69);
        fileExit.addActionListener(this);
        fileExit.setActionCommand("Exit");
        fileMenu.add(fileExit);
        fileMenu.addSeparator();
    }

    public void goBack() {
        DviURLHistoryRecord rec = this.history.goBack();
        if (rec != null) {
            this.open(rec.getURL());
        }
    }

    public void goUp() {
        DviURLHistoryRecord rec = this.history.getCurrentRecord();
        if (rec != null) {
            URL url = this.getParentURL(rec.getURL());
            this.open(url);
        }
    }

    private URL getParentURL(URL url) {
        if (url == null) {
            return null;
        }
        if ("file".equals(url.getProtocol())) {
            try {
                File f = new File(url.getPath());
                if (!f.isDirectory()) {
                    f = f.getParentFile();
                }
                return f.getParentFile().toURL();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void openBySelection() {
        File f = (File)this.listView.getSelectedValue();
        if (f != null) {
            try {
                this.open(f.toURL());
            }
            catch (MalformedURLException e1) {
                e1.printStackTrace();
            }
        }
    }

    public void openBySelectionIfFolder() {
        File f = (File)this.listView.getSelectedValue();
        if (f != null && f.isDirectory()) {
            try {
                this.open(f.toURL());
            }
            catch (MalformedURLException e1) {
                e1.printStackTrace();
            }
        }
    }

    public void open(String[] args) {
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String url = stringArray[n2];
            this.open(url);
            ++n2;
        }
    }

    public void open(URL[] urls) {
        URL[] uRLArray = urls;
        int n = urls.length;
        int n2 = 0;
        while (n2 < n) {
            URL url = uRLArray[n2];
            this.open(url);
            ++n2;
        }
    }

    public void open(String s) {
        try {
            this.open(this.toURL(s));
        }
        catch (DviException e) {
            e.printStackTrace();
        }
    }

    public void open(File f) throws DviException {
        try {
            this.open(f.toURL());
        }
        catch (MalformedURLException e) {
            throw new DviException(e);
        }
    }

    protected URL toURL(String s) throws DviException {
        try {
            URL url = new URL(s);
            return url;
        }
        catch (MalformedURLException url) {
            try {
                File file = new File(s);
                return file.toURL();
            }
            catch (MalformedURLException e) {
                throw new DviException(e);
            }
        }
    }

    public void open(URL url) {
        boolean success = false;
        if ("file".equals(url.getProtocol())) {
            File file = new File(url.getPath());
            if (file.isDirectory()) {
                this.openDirectoryIndex(file);
                this.listView.requestFocusInWindow();
                this.listView.setSelectedIndex(0);
                success = true;
            } else if (this.isDviFile(file)) {
                this.openLocalFile(file);
                success = true;
            } else if (DviDesktop.isDesktopSupported()) {
                try {
                    DviDesktop.getDesktop().open(file);
                    success = true;
                }
                catch (IOException e) {
                    LOGGER.warning(e.toString());
                }
            } else {
                LOGGER.fine("File type not supported: " + file);
            }
        }
        if (success) {
            this.addressBar.getAddressEdit().setText(url.toExternalForm());
            this.recordURL(url);
        }
    }

    private void openDirectoryIndex(File dir) {
        this.model.setDirectory(dir);
    }

    private boolean isDviFile(File file) {
        if (file == null) {
            return false;
        }
        Matcher mat = dviFilenamePat.matcher(file.getPath());
        if (mat.matches()) {
            String ext = mat.group(1);
            LOGGER.fine("filename extension=" + ext);
            return ".dvi".equals(ext.toLowerCase());
        }
        return false;
    }

    private void openLocalFile(File file) {
        try {
            File dir = file.getParentFile();
            this.openDirectoryIndex(dir);
            final DviBrowserPage bp = new DviBrowserPage(this);
            bp.open(file.toURL());
            this.tabs.addTab(file.getName(), null, bp, file.getAbsolutePath());
            this.tabs.setSelectedComponent(bp);
            bp.getCloseButton().addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LOGGER.fine("Closing tab: " + bp);
                    DviBrowserMain.this.tabs.remove(bp);
                }
            });
            this.selectFileInListView(file);
        }
        catch (MalformedURLException e) {
            LOGGER.warning(e.toString());
        }
        catch (DviException e) {
            LOGGER.warning(e.toString());
        }
    }

    private void selectFileInListView(File file) {
        if (file == null) {
            return;
        }
        int len = this.model.getSize();
        int i = 0;
        while (i < len) {
            File f = (File)this.model.getElementAt(i);
            if (file.equals(f)) {
                this.listView.setSelectedIndex(i);
                this.listView.ensureIndexIsVisible(i);
                return;
            }
            ++i;
        }
    }

    public void updateTabInfo() {
        Component c = this.tabs.getSelectedComponent();
        if (c instanceof DviBrowserPage) {
            DviBrowserPage bp = (DviBrowserPage)c;
            this.statusBar.getDviProgressView().setProgressReporter(bp.getProgressReporter());
        }
    }

    protected void recordURL(URL url) {
        this.history.moveTo(url);
    }

    public void reload() {
        Component c = this.tabs.getSelectedComponent();
        if (c instanceof DviBrowserPage) {
            DviBrowserPage bp = (DviBrowserPage)c;
            try {
                bp.reload();
            }
            catch (DviException e) {
                e.printStackTrace();
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if ("Exit".equals(cmd)) {
            this.dispose();
        } else if ("Open".equals(cmd)) {
            this.openByFileDialog();
        } else if ("Reload".equals(cmd)) {
            this.reload();
        }
    }

    protected void openByFileDialog() {
        JFileChooser chooser = new JFileChooser();
        int r = chooser.showOpenDialog(this);
        if (r == 0) {
            File dir = chooser.getSelectedFile();
            try {
                this.open(dir);
            }
            catch (DviException e) {
                e.printStackTrace();
            }
        }
    }

    public void handleEvent(TEvent e) {
    }

    public DviFileListModel getDviFileListModel() {
        return this.model;
    }

    public void setDviFileListModel(DviFileListModel model) {
        this.model = model;
    }

    public JList getListView() {
        return this.listView;
    }

    public DviAddressBar getAddressBar() {
        return this.addressBar;
    }

    public DviURLHistory getHistory() {
        return this.history;
    }

    public void openURLOfAddressBar() {
        try {
            URL url = new URL(this.addressBar.getAddressEdit().getText());
            this.open(url);
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
    }

    public DviBrowserStatusBar getStatusBar() {
        return this.statusBar;
    }
}

