/*
 * Decompiled with CFR 0.152.
 */
package dvi.browser;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class DviLoadIndicator
implements Icon {
    private static final Logger LOGGER = Logger.getLogger(DviLoadIndicator.class.getName());
    private final EventListenerList listenerList = new EventListenerList();
    private int period = 16;
    private int count = 0;
    private TimerTask task;
    private final Timer timer = new Timer();

    public void addChangeListener(ChangeListener listener) {
        this.listenerList.add(ChangeListener.class, listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listenerList.remove(ChangeListener.class, listener);
    }

    public void fireUpdateEvent() {
        ChangeEvent event = null;
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ChangeListener.class) {
                if (event == null) {
                    event = new ChangeEvent(this);
                }
                ((ChangeListener)listeners[i + 1]).stateChanged(event);
            }
            i -= 2;
        }
    }

    public synchronized void start() {
        if (this.task != null) {
            LOGGER.warning("Load indicator already started.");
            return;
        }
        this.task = new TimerTask(){

            public void run() {
                DviLoadIndicator.this.increment();
                DviLoadIndicator.this.fireUpdateEvent();
            }
        };
        this.timer.scheduleAtFixedRate(this.task, 0L, 100L);
        this.fireUpdateEvent();
    }

    public synchronized boolean isActive() {
        return this.task != null;
    }

    public synchronized void stop() {
        if (this.task == null) {
            return;
        }
        this.task.cancel();
        this.task = null;
        this.fireUpdateEvent();
    }

    protected synchronized void increment() {
        ++this.count;
    }

    public int getIconHeight() {
        return 16;
    }

    public int getIconWidth() {
        return 16;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.isActive()) {
            double r = 7.0;
            int N = 16;
            int i = 0;
            while (i < N) {
                double theta = Math.PI * 2 * (double)(this.count * N + i) / (double)(this.period * N);
                int f = i * 255 / N;
                this.drawRadial(g, new Color(f / 3, f / 2, f), x, y, theta, r);
                ++i;
            }
        } else {
            g.drawRoundRect(x, y, 15, 15, 1, 1);
        }
    }

    public void drawRadial(Graphics g, Color c, int x, int y, double theta, double r) {
        double dx = Math.cos(theta);
        double dy = Math.sin(theta);
        g.setColor(c);
        g.drawLine((int)((double)x + r * (1.0 - dx)), (int)((double)y + r * (1.0 - dy)), (int)((double)x + r * (1.0 + dx)), (int)((double)y + r * (1.0 + dy)));
    }
}

