/*
 * Decompiled with CFR 0.152.
 */
package dvi.browser.util;

import dvi.DviException;
import dvi.api.DviContext;
import dvi.api.DviContextSupport;
import dvi.api.DviDocument;
import dvi.browser.util.FileWatch;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;

public class DviFileWatchTarget
extends FileWatch.Target
implements DviContextSupport {
    private static final Logger LOGGER = Logger.getLogger(DviFileWatchTarget.class.getName());
    private final DviContext ctx;

    public DviFileWatchTarget(DviContextSupport dcs, File file) throws IOException {
        super(file);
        this.ctx = dcs.getDviContext();
    }

    protected boolean isContentReady(File file) {
        try {
            DviDocument doc = this.ctx.openDviDocument(file);
            LOGGER.config("Checking modified file: " + file);
            if (doc == null) {
                LOGGER.config("Unable to parse document.  We will retry later.");
                return false;
            }
        }
        catch (DviException ex) {
            LOGGER.config("File seems to be under modification.  We will retry later.");
            return false;
        }
        LOGGER.config("File is ready: " + file);
        return true;
    }

    public DviContext getDviContext() {
        return this.ctx;
    }
}

