/*
 * Decompiled with CFR 0.152.
 */
package dvi.font;

import dvi.DviFontSpec;
import dvi.DviResolution;
import dvi.DviUnit;
import dvi.util.Canonicalizer;
import dvi.util.SimpleCanonicalizer;
import java.io.Serializable;

public final class LogicalFont
implements Serializable {
    private static final long serialVersionUID = -8543173850765210687L;
    private final DviFontSpec fs;
    private final DviUnit dviUnit;
    private final DviResolution res;
    private static final Canonicalizer<LogicalFont> canonicalizer = new SimpleCanonicalizer<LogicalFont>();
    private String string = null;

    private LogicalFont(DviFontSpec fs, DviUnit dviUnit, DviResolution res) {
        this.fs = fs;
        this.dviUnit = dviUnit;
        this.res = res;
        if (fs == null) {
            throw new IllegalArgumentException("font spec cannot be null");
        }
        if (dviUnit == null) {
            throw new IllegalArgumentException("DVI unit cannot be null");
        }
        if (res == null) {
            throw new IllegalArgumentException("resolution cannot be null");
        }
    }

    public static LogicalFont getInstance(DviFontSpec fs, DviUnit dviUnit, DviResolution res) {
        return canonicalizer.canonicalize(new LogicalFont(fs, dviUnit, res));
    }

    public DviFontSpec fontSpec() {
        return this.fs;
    }

    public DviUnit dviUnit() {
        return this.dviUnit;
    }

    public DviResolution resolution() {
        return this.res;
    }

    public String toString() {
        if (this.string == null) {
            this.string = String.valueOf(this.getClass().getName()) + "[" + this.fs + "," + this.dviUnit + "," + this.res + "]";
        }
        return this.string;
    }

    public LogicalFont renameTo(String newName) {
        return LogicalFont.getInstance(this.fs.rename(newName), this.dviUnit, this.res);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof LogicalFont) {
            LogicalFont lf = (LogicalFont)obj;
            return this.fs.equals(lf.fs) && this.dviUnit.equals(lf.dviUnit) && this.res.equals(lf.res);
        }
        return false;
    }

    public int hashCode() {
        return this.fs.hashCode() + 33 * (this.dviUnit.hashCode() + 33 * this.res.hashCode());
    }
}

