/*
 * Decompiled with CFR 0.152.
 */
package dvi.font;

import dvi.DviException;
import dvi.api.BinaryDevice;
import dvi.font.PkGlyph;

public final class PackedGlyphRasterizer {
    private PkGlyph glyph;
    private byte[] buf;
    private int dynF;
    private int dynG;
    private int dynH;
    private boolean highNyb;
    private int offset;
    private int repeat = 0;

    public void begin(PkGlyph glyph) {
        this.glyph = glyph;
        this.buf = glyph.raster();
        this.dynF = glyph.dynF();
        this.dynG = (13 - this.dynF << 4) + this.dynF + 1;
        this.dynH = (this.dynF + 1 << 4) - this.dynF - 1;
        this.offset = 0;
        this.highNyb = true;
    }

    public void end() {
        this.glyph = null;
        this.buf = null;
    }

    protected int getNybble() throws DviException {
        if (this.highNyb) {
            this.highNyb = false;
            return this.buf[this.offset] >> 4 & 0xF;
        }
        this.highNyb = true;
        return this.buf[this.offset++] & 0xF;
    }

    private int getPackedNumInternal(boolean recursed) throws DviException {
        int i = this.getNybble();
        if (i == 0) {
            int j;
            do {
                j = this.getNybble();
                ++i;
            } while (j == 0);
            while (i-- > 0) {
                j = j << 4 | this.getNybble();
            }
            return j - 16 + this.dynG;
        }
        if (i <= this.dynF) {
            return i;
        }
        if (i < 14) {
            return (i << 4) + this.getNybble() - this.dynH;
        }
        if (recursed) {
            throw new IllegalStateException("too many levels of recursion");
        }
        this.repeat = i == 14 ? this.getPackedNumInternal(true) : 1;
        return this.getPackedNumInternal(true);
    }

    public int getPackedNum() throws DviException {
        return this.getPackedNumInternal(false);
    }

    public void rasterizeTo(BinaryDevice out) throws DviException {
        boolean paintFlag = this.glyph.turnOn();
        int w = this.glyph.width();
        int h = this.glyph.height();
        if (w <= 0 || h <= 0) {
            return;
        }
        if (out.beginRaster(w, h)) {
            out.beginLine();
            while (h > 0) {
                int count = this.getPackedNum();
                while (count > 0) {
                    if (count < w) {
                        out.putBits(count, paintFlag);
                        w -= count;
                        break;
                    }
                    out.putBits(w, paintFlag);
                    out.endLine(this.repeat);
                    count -= w;
                    h -= this.repeat + 1;
                    w = this.glyph.width();
                    this.repeat = 0;
                    out.beginLine();
                }
                boolean bl = paintFlag = !paintFlag;
            }
        }
        out.endRaster();
    }
}

