/*
 * Decompiled with CFR 0.152.
 */
package dvi.font;

import dvi.DviException;
import dvi.DviPoint;
import dvi.DviRect;
import dvi.DviResolution;
import dvi.api.BinaryDevice;
import dvi.font.PackedSequence;
import dvi.font.PkGlyph;
import dvi.font.RunLengthEncodedLine;
import dvi.font.SequencePacker;
import dvi.render.AbstractDevice;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;

public final class RunLengthEncodedGlyph {
    private static final int DEFAULT_ARRAY_SIZE = 256;
    private int width;
    private int height;
    private int xOffset;
    private int yOffset;
    private ArrayList<RunLengthEncodedLine> lines;

    public RunLengthEncodedGlyph() {
        this(0, 0, 0, 0);
    }

    private RunLengthEncodedGlyph(int width, int height, int xOffset, int yOffset) {
        this.width = width;
        this.height = height;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.lines = new ArrayList(256);
    }

    public static RunLengthEncodedGlyph readByteBinary(byte[] buf, int width, int height, int xOffset, int yOffset) {
        RunLengthEncodedGlyph rlg = new RunLengthEncodedGlyph(width, height, xOffset, yOffset);
        RunLengthEncodedLine prev = null;
        int pitch = width + 7 >>> 3 << 3;
        int bitOffset = 0;
        int i = 0;
        while (i < height) {
            RunLengthEncodedLine line = new RunLengthEncodedLine();
            line.append(buf, bitOffset, width);
            if (line.equals(prev)) {
                rlg.lines.add(prev);
            } else {
                rlg.lines.add(line);
                prev = line;
            }
            bitOffset += pitch;
            ++i;
        }
        rlg.compact();
        return rlg;
    }

    public static RunLengthEncodedGlyph readRasterByBits(byte[] buf, int width, int height, int xOffset, int yOffset) {
        RunLengthEncodedGlyph rlg = new RunLengthEncodedGlyph(width, height, xOffset, yOffset);
        int bitOffset = 0;
        RunLengthEncodedLine prev = null;
        int i = 0;
        while (i < height) {
            RunLengthEncodedLine line = new RunLengthEncodedLine();
            line.append(buf, bitOffset, width);
            bitOffset += width;
            if (line.equals(prev)) {
                rlg.lines.add(prev);
            } else {
                rlg.lines.add(line);
                prev = line;
            }
            ++i;
        }
        rlg.compact();
        return rlg;
    }

    public static RunLengthEncodedGlyph readByteGray(byte[] buf, int width, int height, int xOffset, int yOffset) {
        RunLengthEncodedGlyph rlg = new RunLengthEncodedGlyph(width, height, xOffset, yOffset);
        int ptr = 0;
        RunLengthEncodedLine prev = null;
        int i = 0;
        while (i < height) {
            RunLengthEncodedLine line = new RunLengthEncodedLine();
            byte by = 314;
            int count = 0;
            int j = 0;
            while (j < width) {
                byte c;
                if ((c = buf[ptr++]) == by) {
                    ++count;
                } else {
                    if (by != 314) {
                        line.append(count, by != 0);
                    }
                    count = 1;
                    by = c;
                }
                ++j;
            }
            if (count > 0) {
                line.append(count, by != 0);
            }
            if (line.equals(prev)) {
                rlg.lines.add(prev);
            } else {
                rlg.lines.add(line);
                prev = line;
            }
            ++i;
        }
        rlg.compact();
        return rlg;
    }

    public DviRect getBounds() {
        return new DviRect(-this.xOffset, -this.yOffset, this.width, this.height);
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public int xOffset() {
        return this.xOffset;
    }

    public int yOffset() {
        return this.yOffset;
    }

    public boolean isEmpty() {
        return this.width <= 0 || this.height <= 0 || this.lines.size() == 0;
    }

    public void rasterizeTo(BinaryDevice out) throws DviException {
        out.save();
        try {
            out.translate(-this.xOffset, -this.yOffset);
            if (out.beginRaster(this.width, this.height)) {
                int i = 0;
                while (i < this.height) {
                    RunLengthEncodedLine line = this.lines.get(i);
                    out.beginLine();
                    line.rasterizeTo(out);
                    out.endLine(0);
                    ++i;
                }
            }
            out.endRaster();
        }
        finally {
            out.restore();
        }
    }

    public void compact() {
        RunLengthEncodedLine line;
        RunLengthEncodedLine line2;
        int lskip = Integer.MAX_VALUE;
        int rskip = Integer.MAX_VALUE;
        RunLengthEncodedLine prev = null;
        int i = 0;
        while (i < this.height) {
            line2 = this.lines.get(i);
            if (prev != line2 && lskip > 0) {
                lskip = line2.headOn() ? 0 : Math.min(lskip, line2.head());
            }
            ++i;
        }
        prev = null;
        i = 0;
        while (i < this.height) {
            line2 = this.lines.get(i);
            if (prev != line2) {
                line2.cropHead(lskip);
                prev = line2;
            }
            ++i;
        }
        this.width -= lskip;
        this.xOffset -= lskip;
        if (this.width <= 0) {
            this.height = 0;
            this.width = 0;
            this.lines.clear();
            this.yOffset = 0;
            this.xOffset = 0;
            return;
        }
        prev = null;
        i = 0;
        while (i < this.height) {
            line2 = this.lines.get(i);
            if (prev != line2) {
                if (rskip > 0) {
                    rskip = line2.tailOn() ? 0 : Math.min(rskip, line2.tail());
                }
                prev = line2;
            }
            ++i;
        }
        prev = null;
        i = 0;
        while (i < this.height) {
            line2 = this.lines.get(i);
            if (prev != line2) {
                line2.cropTail(rskip);
                prev = line2;
            }
            ++i;
        }
        this.width -= rskip;
        if (this.width <= 0) {
            this.height = 0;
            this.width = 0;
            this.lines.clear();
            this.yOffset = 0;
            this.xOffset = 0;
            return;
        }
        int tskip = 0;
        int bskip = 0;
        while (this.height > 0) {
            line = this.lines.get(0);
            if (!line.allOff()) break;
            this.lines.remove(0);
            --this.height;
            --this.yOffset;
            ++tskip;
        }
        while (this.height > 0) {
            line = this.lines.get(this.height - 1);
            if (!line.allOff()) break;
            this.lines.remove(this.height - 1);
            --this.height;
            ++bskip;
        }
        int i2 = 0;
        while (i2 < this.height) {
            RunLengthEncodedLine line3 = this.lines.get(i2);
            if (line3.isEmpty()) {
                throw new IllegalStateException("width=" + this.width + " height=" + this.height);
            }
            ++i2;
        }
        if (this.width <= 0 || this.height <= 0) {
            throw new IllegalStateException("width=" + this.width + " height=" + this.height);
        }
    }

    public String dump() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        int i = 0;
        while (i < this.height) {
            RunLengthEncodedLine line = this.lines.get(i);
            boolean duplicate = i > 0 && this.lines.get(i - 1) == line;
            pw.println(String.valueOf(duplicate ? "+ " : "  ") + line.dump());
            ++i;
        }
        return sw.toString();
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[width=" + this.width + " height=" + this.height + "]";
    }

    public PkGlyph toPkGlyph() {
        if (this.isEmpty()) {
            return PkGlyph.EMPTY;
        }
        ArrayList<Integer> counts = new ArrayList<Integer>(256);
        int count = 0;
        int repeat = 0;
        RunLengthEncodedLine line = this.lines.get(0);
        boolean turnOn = line.headOn();
        int i = 0;
        while (line != null) {
            ArrayList<Integer> data = line.getData();
            int ds = data.size();
            int j = 0;
            while (j < ds) {
                int c = data.get(j);
                boolean needFlush = true;
                if (j == ds - 1) {
                    int r = 0;
                    RunLengthEncodedLine next = null;
                    while (++i < this.height) {
                        next = this.lines.get(i);
                        if (next != line) break;
                        ++r;
                    }
                    needFlush = next == null || next.headOn() != line.tailOn();
                    line = next;
                    if (count > 0) {
                        count += data.get(j) + r * this.width;
                    } else {
                        count = data.get(j);
                        repeat = r;
                    }
                } else {
                    count += c;
                }
                if (needFlush) {
                    if (repeat > 0) {
                        counts.add(-repeat);
                        repeat = 0;
                    }
                    counts.add(count);
                    count = 0;
                }
                ++j;
            }
        }
        PackedSequence ps = new SequencePacker(counts).pack();
        return new PkGlyph(this.width, this.height, ps.data(), ps.dynF(), turnOn, this.xOffset, this.yOffset);
    }

    public DviRect bounds() throws DviException {
        if (this.isEmpty()) {
            return DviRect.EMPTY;
        }
        return new DviRect(-this.xOffset, -this.yOffset, this.width, this.height);
    }

    public void unite(RunLengthEncodedGlyph rlg) {
        DviRect u = rlg.getBounds().union(this.getBounds());
        ArrayList<RunLengthEncodedLine> newLines = new ArrayList<RunLengthEncodedLine>(256);
        RunLengthEncodedLine last = null;
        int ey = u.bottom();
        int y = u.top();
        while (y <= ey) {
            int lpad;
            int w;
            RunLengthEncodedLine a = new RunLengthEncodedLine();
            RunLengthEncodedLine b = new RunLengthEncodedLine();
            int ia = y + this.yOffset;
            int ib = y + rlg.yOffset;
            if (ia >= 0 && ia < this.height) {
                w = u.width();
                lpad = -this.xOffset - u.left();
                if (lpad > 0) {
                    a.append(lpad, false);
                    w -= lpad;
                }
                a.append(this.lines.get(ia));
                a.append(w -= this.width, false);
            } else {
                a.append(u.width(), false);
            }
            if (ib >= 0 && ib < rlg.height) {
                w = u.width();
                lpad = -rlg.xOffset - u.left();
                if (lpad > 0) {
                    b.append(lpad, false);
                    w -= lpad;
                }
                b.append(rlg.lines.get(ib));
                b.append(w -= rlg.width, false);
            } else {
                b.append(u.width(), false);
            }
            a = RunLengthEncodedLine.union(a, b);
            if (a.equals(last)) {
                newLines.add(last);
            } else {
                newLines.add(a);
                last = a;
            }
            ++y;
        }
        this.width = u.width();
        this.height = u.height();
        this.xOffset = -u.x();
        this.yOffset = -u.y();
        this.lines = newLines;
        this.compact();
    }

    public BinaryDevice getBinaryDevice(DviResolution res) throws DviException {
        return new BinaryDeviceImpl(res);
    }

    private class BinaryDeviceImpl
    extends AbstractDevice
    implements BinaryDevice {
        private RunLengthEncodedGlyph rlg;
        private RunLengthEncodedLine line;

        private BinaryDeviceImpl(DviResolution res) {
            super(res);
            this.rlg = null;
            this.line = null;
        }

        public void begin() throws DviException {
        }

        public void end() throws DviException {
        }

        public boolean beginRaster(int w, int h) throws DviException {
            this.rlg = new RunLengthEncodedGlyph();
            this.rlg.width = w;
            this.rlg.height = h;
            return true;
        }

        public void endRaster() throws DviException {
            DviPoint p = this.getReferencePoint();
            this.rlg.xOffset = -p.x;
            this.rlg.yOffset = -p.y;
            this.rlg.compact();
            RunLengthEncodedGlyph.this.unite(this.rlg);
            this.rlg = null;
        }

        public void beginLine() throws DviException {
            this.line = new RunLengthEncodedLine();
        }

        public void endLine(int repeat) throws DviException {
            int i = 0;
            while (i <= repeat) {
                this.rlg.lines.add(this.line);
                ++i;
            }
            this.line = null;
        }

        public void putBits(int count, boolean paintFlag) {
            this.line.append(count, paintFlag);
        }
    }
}

