/*
 * Decompiled with CFR 0.152.
 */
package dvi.render;

import dvi.DviRect;
import dvi.DviResolution;
import dvi.api.BinaryDevice;
import dvi.render.AbstractDevice;

public class BinaryImage {
    private final byte[] buf;
    private final int pitch;
    private final int width;
    private final int height;

    public BinaryImage(int width, int height) {
        this.width = width;
        this.height = height;
        this.pitch = width + 7 >>> 3;
        this.buf = new byte[this.pitch * height];
    }

    public BinaryImage(byte[] buf, int width, int height) {
        this.width = width;
        this.height = height;
        this.pitch = width + 7 >>> 3;
        this.buf = buf;
        if (buf.length != this.pitch * height) {
            throw new IllegalArgumentException("buffer size mismatch.");
        }
    }

    public byte[] getBuffer() {
        return this.buf;
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public int pitch() {
        return this.pitch;
    }

    public void fill(int c) {
        int i = 0;
        while (i < this.buf.length) {
            this.buf[i] = (byte)c;
            ++i;
        }
    }

    public int getPixel(int x, int y) {
        if (x < 0 || this.width <= x) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(x));
        }
        if (y < 0 || this.height <= y) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(y));
        }
        int bytePos = x >>> 3;
        byte bitMask = (byte)(1 << 7 - (x & 7));
        return (this.buf[bytePos + y * this.pitch] & bitMask) != 0 ? 1 : 0;
    }

    public void setPixel(int x, int y, int val) {
        if (x < 0 || this.width <= x) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(x));
        }
        if (y < 0 || this.height <= y) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(y));
        }
        int bytePos = x >>> 3;
        int bitMask = 1 << 7 - (x & 7);
        byte c = (byte)(this.buf[bytePos + y * this.pitch] & (0xFF ^ bitMask));
        if (val != 0) {
            c = (byte)(c | bitMask);
        }
        this.buf[bytePos + y * this.pitch] = c;
    }

    public void dump() {
        int i = 0;
        while (i < this.height) {
            String line = "";
            int j = 0;
            while (j < this.width) {
                line = this.getPixel(j, i) != 0 ? String.valueOf(line) + "*" : String.valueOf(line) + ".";
                ++j;
            }
            System.out.println(line);
            ++i;
        }
    }

    public BinaryDevice getBinaryDevice(DviResolution res) {
        return new BinaryDeviceImpl(res);
    }

    public final class BinaryDeviceImpl
    extends AbstractDevice
    implements BinaryDevice {
        private int w;
        private int y;
        private byte[] l_buf;
        private int xx;

        private BinaryDeviceImpl(DviResolution res) {
            super(res);
        }

        public DviRect getBounds() {
            return new DviRect(-this.point.x, -this.point.y, BinaryImage.this.width, BinaryImage.this.height);
        }

        public void begin() {
        }

        public void end() {
        }

        public boolean beginRaster(int w, int h) {
            this.w = w;
            this.l_buf = new byte[w + 7 >>> 3];
            this.y = 0;
            return true;
        }

        public void endRaster() {
        }

        public void beginLine() {
            int i = 0;
            while (i < this.l_buf.length) {
                this.l_buf[i] = 0;
                ++i;
            }
            this.xx = 0;
        }

        public void endLine(int repeat) {
            int i = 0;
            while (i <= repeat) {
                int j = 0;
                while (j < this.w) {
                    int bit = this.l_buf[j >>> 3] & 1 << 7 - (j & 7);
                    if (bit != 0) {
                        BinaryImage.this.setPixel(this.point.x + j, this.point.y + this.y, 1);
                    }
                    ++j;
                }
                ++this.y;
                ++i;
            }
        }

        public void putBits(int count, boolean paintFlag) {
            if (paintFlag) {
                while (count-- > 0) {
                    int n = this.xx >>> 3;
                    this.l_buf[n] = (byte)(this.l_buf[n] | 1 << 7 - (this.xx & 7));
                    ++this.xx;
                }
            } else {
                this.xx += count;
            }
        }
    }
}

