/*
 * Decompiled with CFR 0.152.
 */
package dvi.render;

import dvi.DviException;
import dvi.DviRect;
import dvi.DviResolution;
import dvi.api.ImageDevice;
import dvi.render.AbstractDevice;

public class ByteRGBImage {
    private final byte[] buf;
    private final int width;
    private final int height;
    private final int pitch;

    public ByteRGBImage(int width, int height) {
        this.width = width;
        this.height = height;
        this.pitch = width * 3;
        this.buf = new byte[this.pitch * height];
    }

    public ByteRGBImage(byte[] buf, int width, int height, int pitch) {
        this.buf = buf;
        this.width = width;
        this.height = height;
        this.pitch = pitch;
    }

    public ByteRGBImage(byte[] buf, int width, int height) {
        this(buf, width, height, 3 * width);
    }

    public byte[] getBuffer() {
        return this.buf;
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public void fill(int rgb) {
        byte r = (byte)(rgb >>> 16);
        byte g = (byte)(rgb >>> 8);
        byte b = (byte)(rgb >>> 0);
        int p0 = 0;
        int i = 0;
        while (i < this.height) {
            int p = p0;
            int j = 0;
            while (j < this.width) {
                this.buf[p++] = r;
                this.buf[p++] = g;
                this.buf[p++] = b;
                ++j;
            }
            p0 += this.pitch;
            ++i;
        }
    }

    public ImageDevice getImageDevice(DviResolution res) {
        return new ImageDeviceImpl(res);
    }

    private static byte blend(byte _c1, byte _c2, int alpha10) {
        int c1 = _c1 & 0xFF;
        int c2 = _c2 & 0xFF;
        return (byte)(c1 + (alpha10 * (c2 - c1) >>> 10));
    }

    private static class AlphaCache {
        private final int[] table = new int[1024];
        private int maxval;
        private boolean canLookUp;
        private double gamma = 0.9;

        private AlphaCache() {
        }

        private void setMaxValue(int maxval) {
            if (this.maxval == maxval) {
                return;
            }
            this.maxval = maxval;
            if (maxval < 1024) {
                int i = 0;
                while (i <= maxval) {
                    this.table[i] = this.alpha10Internal(i);
                    ++i;
                }
                this.canLookUp = true;
            } else {
                this.canLookUp = false;
            }
        }

        private int get(int c) {
            if (!this.canLookUp || c < 0 || this.maxval < c) {
                return this.alpha10Internal(c);
            }
            return this.table[c];
        }

        private int alpha10Internal(int c) {
            return (int)(1024.0 * Math.pow((double)c / (double)this.maxval, this.gamma) + 0.5);
        }
    }

    private class ImageDeviceImpl
    extends AbstractDevice
    implements ImageDevice {
        private final AlphaCache alphaCache;
        private int ptr;

        protected ImageDeviceImpl(DviResolution res) {
            super(res);
            this.alphaCache = new AlphaCache();
            this.ptr = 0;
        }

        public DviRect getBounds() {
            return new DviRect(-this.point.x, -this.point.y, ByteRGBImage.this.width, ByteRGBImage.this.height);
        }

        public void begin(int maxval) {
            this.alphaCache.setMaxValue(maxval);
        }

        public void end() {
        }

        public boolean beginImage(int w, int h) throws DviException {
            this.ptr = 3 * this.point.x + this.point.y * ByteRGBImage.this.pitch;
            return true;
        }

        public void endImage() {
        }

        public void putLine(int[] l_buf, int off, int len) throws DviException {
            int color = this.getColor().toIntRGB();
            byte r = (byte)(color >>> 16);
            byte g = (byte)(color >>> 8);
            byte b = (byte)(color >>> 0);
            int p = this.ptr;
            int i = 0;
            while (i < len) {
                int alpha10 = this.alphaCache.get(l_buf[off + i]);
                if (alpha10 != 0) {
                    ((ByteRGBImage)ByteRGBImage.this).buf[p + 0] = ByteRGBImage.blend(ByteRGBImage.this.buf[p + 0], r, alpha10);
                    ((ByteRGBImage)ByteRGBImage.this).buf[p + 1] = ByteRGBImage.blend(ByteRGBImage.this.buf[p + 1], g, alpha10);
                    ((ByteRGBImage)ByteRGBImage.this).buf[p + 2] = ByteRGBImage.blend(ByteRGBImage.this.buf[p + 2], b, alpha10);
                }
                p += 3;
                ++i;
            }
            this.ptr += ByteRGBImage.this.pitch;
        }
    }
}

