/*
 * Decompiled with CFR 0.152.
 */
package dvi.render;

import dvi.DviByteRange;
import dvi.DviException;
import dvi.DviRect;
import dvi.DviResolution;
import dvi.api.BinaryDevice;
import dvi.api.DviContextSupport;
import dvi.api.DviExecutorContext;
import dvi.api.DviFont;
import dvi.api.Glyph;
import dvi.font.LogicalFont;
import dvi.render.DefaultDevicePainter;
import dvi.render.EmptyBinaryDevice;

public class ByteRangeComputer
extends DefaultDevicePainter {
    private DviByteRange range = DviByteRange.EMPTY;
    private final DviRect rect;
    private final BinaryDevice out;
    private DviRect bbox = DviRect.EMPTY;
    private DviResolution res;

    public ByteRangeComputer(DviContextSupport dcs, DviResolution res, DviRect rect) throws DviException {
        super(dcs);
        this.rect = rect;
        this.res = res;
        this.out = new EmptyBinaryDevice(res);
        this.setOutput(this.out);
    }

    public DviByteRange getByteRange() {
        return this.range;
    }

    public DviRect getBounds() {
        return this.bbox;
    }

    protected void realDrawChar(LogicalFont lf, int code) throws DviException {
        Glyph glyph;
        DviFont font = this.getFont();
        if (font != null && (glyph = font.getGlyph(lf, code)) != null) {
            this.shipOutBOX(glyph.bounds().translate(this.out.getReferencePoint()));
        }
    }

    protected void realDrawRule(int w, int h) throws DviException {
        this.shipOutBOX(new DviRect(0, 0, w, h).translate(this.out.getReferencePoint()));
    }

    private void shipOutBOX(DviRect box) throws DviException {
        if (box.intersects(this.rect)) {
            this.bbox = this.bbox.union(box);
            DviExecutorContext ctx = this.getGeometerContext().getExecuterContext();
            this.range = this.range.union(ctx.getCommandRange());
        }
    }

    public void drawSpecial(byte[] _xxx) throws DviException {
    }

    public DviResolution getResolution() {
        return this.res;
    }
}

