/*
 * Decompiled with CFR 0.152.
 */
package dvi.render;

import dvi.DviException;
import dvi.DviFontSpec;
import dvi.api.DviContextSupport;
import dvi.render.BasicGeometer;

public class VirtualFontGeometer
extends BasicGeometer {
    private final DviFontSpec fs;
    private final double factor;

    public VirtualFontGeometer(DviContextSupport dcs, DviFontSpec fs) {
        super(dcs);
        this.fs = fs;
        this.factor = (double)fs.spaceSize() / 1048576.0;
    }

    public DviFontSpec getFontSpec() {
        return this.fs;
    }

    private int scale(int a) {
        return (int)((double)a * this.factor);
    }

    public void doSetRule(int width, int height) throws DviException {
        super.doSetRule(this.scale(width), this.scale(height));
    }

    public void doPutRule(int width, int height) throws DviException {
        super.doPutRule(this.scale(width), this.scale(height));
    }

    public void doRight(int by) throws DviException {
        super.doRight(this.scale(by));
    }

    public void doW(int by) throws DviException {
        super.doW(this.scale(by));
    }

    public void doX(int by) throws DviException {
        super.doX(this.scale(by));
    }

    public void doDown(int by) throws DviException {
        super.doDown(this.scale(by));
    }

    public void doY(int by) throws DviException {
        super.doY(this.scale(by));
    }

    public void doZ(int by) throws DviException {
        super.doZ(this.scale(by));
    }
}

