/*
 * Decompiled with CFR 0.152.
 */
package dvi.special;

import dvi.DviException;
import dvi.DviObject;
import dvi.api.DviContextSupport;
import dvi.api.DviDocument;
import dvi.render.BasicExecutor;
import dvi.special.AbstractDviSpecialExecutor;
import dvi.special.Anchor;
import dvi.special.AnchorSet;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HtmlSpecialParser
extends DviObject {
    private final AnchorSet anchorSet = new AnchorSet();
    private final PrivateExecuter exe;
    private static final Pattern hrefPat = Pattern.compile("\\s*html:\\s*<a\\s*href\\s*=\\s*\"(.*)\"\\s*>", 2);
    private static final Pattern namePat = Pattern.compile("\\s*html:\\s*<a\\s*name\\s*=\\s*\"(.*)\"\\s*>", 2);
    private static final Pattern endPat = Pattern.compile("\\s*html:\\s*</a>", 2);

    public HtmlSpecialParser(DviContextSupport dcs) {
        super(dcs);
        this.exe = new PrivateExecuter(dcs, this.anchorSet);
    }

    public void execute(DviDocument doc) throws DviException {
        int p = 0;
        while (p < doc.getTotalPages()) {
            this.exe.execute(doc.getPage(p));
            ++p;
        }
    }

    public AnchorSet getAnchorSet() {
        return this.anchorSet;
    }

    private static class PrivateExecuter
    extends AbstractDviSpecialExecutor {
        private final AnchorSet anchorSet;
        private final Stack<StackItem> stack = new Stack();

        public PrivateExecuter(DviContextSupport dcs, AnchorSet anchorSet) {
            super(dcs);
            this.anchorSet = anchorSet;
        }

        public void doSpecial(byte[] _xxx) throws DviException {
            String xxx = new String(_xxx);
            BasicExecutor.DviExecutorContextImpl ctx = this.getExecutorContext();
            Matcher mat = hrefPat.matcher(xxx);
            if (mat.matches()) {
                this.stack.push(new StackItem(ctx.getCommandRange().begin(), "href", mat.group(1)));
            } else {
                mat = namePat.matcher(xxx);
                if (mat.matches()) {
                    this.stack.push(new StackItem(ctx.getCommandRange().begin(), "name", mat.group(1)));
                } else {
                    mat = endPat.matcher(xxx);
                    if (mat.matches()) {
                        Anchor.StringValued el = null;
                        if (!this.stack.empty()) {
                            StackItem it = this.stack.pop();
                            if ("href".equals(it.tag)) {
                                el = new Anchor.Href(it.start, ctx.getCommandRange().end(), it.data);
                            } else if ("name".equals(it.tag)) {
                                el = new Anchor.Name(it.start, ctx.getCommandRange().end(), it.data);
                            }
                        }
                        if (el != null) {
                            this.anchorSet.add(el);
                        }
                    }
                }
            }
        }

        private static class StackItem {
            private final long start;
            private final String tag;
            private final String data;

            public StackItem(long start, String tag, String data) {
                this.start = start;
                this.tag = tag;
                this.data = data;
            }
        }
    }
}

