/*
 * Decompiled with CFR 0.152.
 */
package dvi.util;

import dvi.DviException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class DviUtils {
    private DviUtils() {
    }

    public static boolean isFile(URL url) {
        if (url == null) {
            return false;
        }
        return "file".equals(url.getProtocol());
    }

    public static void writeStringToFile(File psFile, String postScriptData) throws IOException {
        FileOutputStream fos = new FileOutputStream(psFile);
        try {
            byte[] buf = postScriptData.getBytes();
            fos.write(buf);
        }
        finally {
            fos.flush();
            fos.close();
        }
    }

    public static File toLocalFile(URL url) throws DviException {
        if (url == null) {
            return null;
        }
        if ("file".equals(url.getProtocol())) {
            return new File(url.getPath());
        }
        throw new DviException("URL does not point to a local file. " + url);
    }

    public static String md5Hex(String ps) {
        if (ps == null) {
            return null;
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] digest = md.digest(ps.getBytes());
            StringBuilder sb = new StringBuilder();
            byte[] byArray = digest;
            int n = digest.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                sb.append(String.format("%02x", b));
                ++n2;
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return "0";
        }
    }
}

