/*
 * Decompiled with CFR 0.152.
 */
package dvi.browser;

import dvi.DviException;
import dvi.DviResolution;
import dvi.api.DviContext;
import dvi.api.DviContextSupport;
import dvi.api.DviDocument;
import dvi.browser.DviBoxBrowserPageLayout;
import dvi.browser.DviBrowserPageLayout;
import dvi.browser.DviEmptyBrowserPageLayout;
import dvi.browser.DviLoadIndicator;
import dvi.browser.ZoomConfig;
import dvi.browser.util.DviFileWatchTarget;
import dvi.browser.util.FileWatch;
import dvi.ctx.DviToolkit;
import dvi.event.TEvent;
import dvi.event.TEventListener;
import dvi.gui.swing.DefaultDviLayoutManager;
import dvi.gui.swing.DragToScroll;
import dvi.gui.swing.DviLayoutManager;
import dvi.gui.swing.TDviDocument;
import dvi.gui.swing.TexLogViewer;
import dvi.gui.swing.ViewSpec;
import dvi.util.progress.ManagedProgressItem;
import dvi.util.progress.ProgressItem;
import dvi.util.progress.ProgressRecorder;
import dvi.util.progress.ProgressReporter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DviBrowserPage
extends JPanel
implements DviContextSupport,
TEventListener,
ActionListener {
    public static final String CMD_CLOSE_PAGE = "CMD_CLOSE_PAGE";
    public static final String CMD_OPEN_PDF = "CMD_OPEN_PDF";
    public static final String CMD_SET_LAYOUT = "CMD_SET_LAYOUT";
    public static final String CMD_CROP_MARGINS = "CMD_CROP_MARGINS";
    public static final String CMD_TWO_IN_ONE = "CMD_TWO_IN_ONE";
    private static final Logger LOGGER = Logger.getLogger(DviBrowserPage.class.getName());
    private JScrollPane scroll = new JScrollPane();
    protected DragToScroll dragToScroll = new DragToScroll(this.getScrollPane());
    protected TDviDocument tdd;
    private ViewSpec viewSpec = new ViewSpec((DviContextSupport)this);
    private static final long serialVersionUID = 1L;
    private final DviContextSupport dcs;
    protected TexLogViewer logViewer = new TexLogViewer(5, 64);
    private FileWatch.Target watchTarget = null;
    private final ProgressRecorder recorder = new ProgressRecorder(this){

        protected boolean removeEldestElement(ManagedProgressItem item) {
            List list = this.getProgressItems();
            if (list.size() > 100) {
                LOGGER.finer("Remove progress item: " + item);
                return true;
            }
            return false;
        }
    };
    private final ProgressReporter reporter = new ProgressReporter((DviContextSupport)this);
    private static ExecutorService exe = Executors.newFixedThreadPool(1, new ThreadFactory(){

        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setPriority(1);
            t.setDaemon(true);
            return t;
        }
    });
    private final DviLoadIndicator loadIndicator = new DviLoadIndicator();
    private URL url;
    private JComboBox layoutSelector;
    private JCheckBox checkBoxCrop;
    private JCheckBox checkBoxTwoInOne;
    private JButton closeButton;
    private DviBrowserPageLayout freeLayout;

    public DviContext getDviContext() {
        return this.dcs.getDviContext();
    }

    public DviBrowserPage(DviContextSupport dcs) {
        this.dcs = dcs;
        this.initializeCompontents();
        this.reporter.addProgressRecorder(this.getDviContext().getProgressRecorder());
        this.reporter.addProgressRecorder(this.recorder);
    }

    public void open(final URL url) throws DviException {
        this.loadIndicator.start();
        try {
            final DviToolkit utils = this.getDviContext().getDviToolkit();
            final DviDocument doc = this.getDviContext().openDviDocument(url);
            FileWatch.getInstance().removeTarget(this.watchTarget);
            if ("file".equals(url.getProtocol())) {
                File file = new File(url.getPath());
                this.watchTarget = new DviFileWatchTarget(this, file);
                FileWatch.getInstance().addTarget(this.watchTarget);
                this.watchTarget.getEventModel().addListener((TEventListener)this);
            }
            final ViewSpec viewSpecCopy = (ViewSpec)this.getViewSpec().clone();
            final ProgressItem progress = this.recorder.open("loading " + url);
            exe.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        ProgressItem item = DviBrowserPage.this.recorder.open("preparing fonts");
                        LOGGER.fine("Begin preparing fonts");
                        try {
                            utils.prepareForRendering(doc, viewSpecCopy);
                        }
                        catch (DviException e1) {
                            LOGGER.warning(e1.toString());
                            try {
                                DviBrowserPage.this.recorder.append("Failed to load" + url);
                            }
                            catch (DviException e) {
                                LOGGER.warning(e.toString());
                            }
                        }
                        finally {
                            item.close();
                        }
                        LOGGER.fine("End preparing fonts");
                    }
                    catch (DviException e1) {
                        LOGGER.warning(e1.getMessage());
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            try {
                                DviBrowserPage.this.updateSize(doc);
                                LOGGER.fine("Setting DVI document to " + doc);
                                DviBrowserPage.this.tdd.setDviDocument(doc);
                                DviBrowserPage.this.url = url;
                                progress.close();
                            }
                            catch (DviException e) {
                                e.printStackTrace();
                            }
                            finally {
                                DviBrowserPage.this.loadIndicator.stop();
                            }
                        }
                    });
                }
            });
        }
        catch (IOException e) {
            this.loadIndicator.stop();
            throw new DviException((Throwable)e);
        }
    }

    public void reload() throws DviException {
        if (this.url == null) {
            return;
        }
        if ("file".equals(this.url.getProtocol())) {
            File file = new File(this.url.getPath());
            this.logViewer.setDviFile(file);
            if (null != this.tdd.getDviDocument() && this.logViewer.hasError()) {
                this.logViewer.setVisible(true);
                LOGGER.fine("Compilation error detected: " + this.url);
                return;
            }
            this.logViewer.setVisible(false);
        } else {
            this.logViewer.setDviFile(null);
            LOGGER.warning("Unsupported protocol: " + this.url);
        }
        this.open(this.url);
    }

    protected JButton createButton(String name, Icon icon, String tooltip, String command) {
        return (JButton)this.decorateButton(new JButton(), name, icon, tooltip, command);
    }

    protected AbstractButton decorateButton(AbstractButton o, String name, Icon icon, String tooltip, String command) {
        if (icon == null) {
            o.setText(name);
        } else {
            o.setIcon(icon);
        }
        o.setToolTipText(tooltip);
        o.setActionCommand(command);
        o.addActionListener(this);
        return o;
    }

    protected JCheckBox createCheckBox(String name, Icon icon, String tooltip, String command) {
        return (JCheckBox)this.decorateButton(new JCheckBox(), name, icon, tooltip, command);
    }

    protected JComboBox createLayoutSelector() {
        JComboBox<DviBrowserPageLayout> combo = new JComboBox<DviBrowserPageLayout>();
        combo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                LOGGER.fine("layout setting changed");
                DviBrowserPage.this.updateSize(null);
                try {
                    DviBrowserPage.this.tdd.reload();
                }
                catch (DviException e1) {
                    LOGGER.warning(e1.toString());
                }
            }
        });
        ArrayList<DviBrowserPageLayout> layouts = new ArrayList<DviBrowserPageLayout>();
        this.populateLayoutSelector(layouts);
        combo.setModel(new DefaultComboBoxModel<DviBrowserPageLayout>(layouts.toArray(new DviBrowserPageLayout[0])));
        return combo;
    }

    protected JComboBox createZoomSelector() {
        JComboBox<ZoomConfig> combo = new JComboBox<ZoomConfig>();
        combo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                ZoomConfig conf = (ZoomConfig)e.getItem();
                LOGGER.fine("zoom setting changed to " + conf);
                DviBrowserPage.this.getViewSpec().setResolution(conf.getResolution());
                LOGGER.fine("new view spec " + DviBrowserPage.this.getViewSpec());
                DviBrowserPage.this.layoutSelector.setSelectedItem(DviBrowserPage.this.freeLayout);
            }
        });
        ArrayList<ZoomConfig> list = new ArrayList<ZoomConfig>();
        this.populateZoomConfigs(list);
        combo.setModel(new DefaultComboBoxModel<ZoomConfig>(list.toArray(new ZoomConfig[0])));
        return combo;
    }

    protected void populateZoomConfigs(List<ZoomConfig> list) {
        int[] sfs = new int[]{64, 33, 18, 12, 10, 8, 4};
        DviResolution res = this.getViewSpec().getResolution();
        for (int sf : sfs) {
            DviResolution res2 = new DviResolution(res.dpi(), sf);
            double screenDpi = 72.72727272727273;
            int ratio = (int)(res2.actualDpi() * 100.0 / screenDpi);
            String desc = String.format("%d%% (%ddpi)", ratio, (int)res2.actualDpi());
            list.add(new ZoomConfig(desc, res2));
        }
    }

    protected void populateLayoutSelector(List<DviBrowserPageLayout> layouts) {
        layouts.add(new DviBoxBrowserPageLayout(this, "Fit to width", true, false));
        layouts.add(new DviBoxBrowserPageLayout(this, "Fit to height", false, true));
        layouts.add(new DviBoxBrowserPageLayout(this, "Fit to both", true, true));
        this.freeLayout = new DviEmptyBrowserPageLayout(this, "Free");
        layouts.add(this.freeLayout);
    }

    private void initializeCompontents() {
        this.tdd = new TDviDocument((DviContextSupport)this);
        this.layoutSelector = this.createLayoutSelector();
        this.checkBoxCrop = this.createCheckBox("Crop", null, "Crop margins", CMD_CROP_MARGINS);
        this.checkBoxCrop.setSelected(true);
        this.checkBoxTwoInOne = this.createCheckBox("2in1", null, "Display two pages horizontally", CMD_TWO_IN_ONE);
        this.closeButton = this.createButton("Close", null, "Close this page", CMD_CLOSE_PAGE);
        JToolBar toolbar = new JToolBar("Navigator");
        toolbar.add(this.checkBoxCrop);
        toolbar.add(this.checkBoxTwoInOne);
        toolbar.add(this.layoutSelector);
        toolbar.add(new JPanel());
        toolbar.add(this.getCloseButton());
        toolbar.setRollover(true);
        toolbar.setFloatable(false);
        this.tdd = new TDviDocument((DviContextSupport)this);
        this.dragToScroll.add((Component)this.tdd);
        this.getScrollPane().setViewportView((Component)this.tdd);
        this.getScrollPane().getVerticalScrollBar().setUnitIncrement(32);
        this.getScrollPane().addComponentListener(new ComponentListener(){

            public void componentHidden(ComponentEvent e) {
            }

            public void componentMoved(ComponentEvent e) {
            }

            public void componentResized(ComponentEvent e) {
                DviBrowserPage.this.updateSize(null);
                try {
                    DviBrowserPage.this.tdd.reload();
                }
                catch (DviException e1) {
                    LOGGER.warning(e1.toString());
                }
            }

            public void componentShown(ComponentEvent e) {
            }
        });
        this.setLayout(new BorderLayout());
        this.logViewer.setVisible(false);
        this.add((Component)this.logViewer, "South");
        this.add((Component)this.getScrollPane(), "Center");
        this.add((Component)toolbar, "North");
        try {
            this.tdd.setViewSpec(this.viewSpec);
        }
        catch (DviException e2) {
            LOGGER.severe(e2.toString());
        }
        this.tdd.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (DviBrowserPage.this.tdd.isBusy()) {
                    DviBrowserPage.this.loadIndicator.start();
                } else {
                    DviBrowserPage.this.loadIndicator.stop();
                }
            }
        });
        this.updateLayout();
    }

    public DviBrowserPageLayout getDviBrowserPageLayout() {
        Object o = this.layoutSelector.getSelectedItem();
        if (o instanceof DviBrowserPageLayout) {
            DviBrowserPageLayout layout = (DviBrowserPageLayout)o;
            return layout;
        }
        LOGGER.warning("Invalid browser page layout: " + o);
        return null;
    }

    public void updateSize(DviDocument doc) {
        if (doc == null) {
            doc = this.tdd.getDviDocument();
        }
        if (doc == null) {
            return;
        }
        try {
            DviBrowserPageLayout layout = this.getDviBrowserPageLayout();
            if (layout != null) {
                layout.layoutDviBrowserPage(this, doc);
            } else {
                LOGGER.warning("No browser page layout available.");
            }
        }
        catch (DviException ex) {
            LOGGER.warning(ex.toString());
        }
    }

    public void handleEvent(TEvent e) {
        if (e instanceof FileWatch.Modified) {
            LOGGER.fine("received event: " + e);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        LOGGER.fine("reloading document: " + DviBrowserPage.this.url);
                        DviBrowserPage.this.getProgressRecorder().append("Reloaded: " + DviBrowserPage.this.url);
                        DviBrowserPage.this.reload();
                    }
                    catch (DviException e) {
                        LOGGER.warning(e.toString());
                    }
                }
            });
            LOGGER.fine("Scheduled reload() to the EDT");
        }
    }

    public Dimension getViewportSize() {
        JScrollPane scroll = this.getScrollPane();
        int w = scroll.getViewport().getWidth();
        int h = scroll.getViewport().getHeight();
        if (!scroll.getVerticalScrollBar().isVisible()) {
            Dimension vs = scroll.getVerticalScrollBar().getPreferredSize();
            w -= vs.width;
        }
        if (!scroll.getHorizontalScrollBar().isVisible()) {
            Dimension hs = scroll.getHorizontalScrollBar().getPreferredSize();
            h -= hs.width;
        }
        return new Dimension(w, h);
    }

    public ViewSpec getViewSpec() {
        return this.viewSpec;
    }

    public TDviDocument getTDviDocument() {
        return this.tdd;
    }

    public ExecutorService getExecutorService() {
        return exe;
    }

    public ProgressRecorder getProgressRecorder() {
        return this.recorder;
    }

    public ProgressReporter getProgressReporter() {
        return this.reporter;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (!(CMD_OPEN_PDF.equals(cmd) || CMD_CLOSE_PAGE.equals(cmd) || CMD_SET_LAYOUT.equals(cmd))) {
            if (CMD_CROP_MARGINS.equals(cmd)) {
                this.updateLayout();
            } else if (CMD_TWO_IN_ONE.equals(cmd)) {
                this.updateLayout();
            } else {
                LOGGER.warning("Unrecognized action command: " + cmd);
            }
        }
    }

    protected void updateLayout() {
        try {
            int cols = 1;
            if (this.checkBoxTwoInOne.isSelected()) {
                cols = 2;
            }
            boolean crop = false;
            if (this.checkBoxCrop.isSelected()) {
                crop = true;
            }
            DefaultDviLayoutManager dlm = new DefaultDviLayoutManager((DviContextSupport)this, cols, 16);
            dlm.setEnableCrop(crop);
            this.tdd.setDviLayout((DviLayoutManager)dlm);
            this.updateSize(null);
            this.tdd.reload();
        }
        catch (DviException e1) {
            LOGGER.warning(e1.toString());
        }
    }

    public JScrollPane getScrollPane() {
        return this.scroll;
    }

    public JButton getCloseButton() {
        return this.closeButton;
    }

    public DviLoadIndicator getLoadIndicator() {
        return this.loadIndicator;
    }

    public void setViewSpec(ViewSpec viewSpec) throws DviException {
        this.viewSpec = viewSpec;
        this.tdd.setViewSpec(viewSpec);
    }
}

