/*
 * Decompiled with CFR 0.152.
 */
package dvi.browser;

import dvi.DviObject;
import dvi.api.DviContextSupport;
import dvi.browser.DviURLHistoryRecord;
import java.net.URL;
import java.util.LinkedList;

public class DviURLHistory
extends DviObject {
    private final LinkedList<DviURLHistoryRecord> list = new LinkedList();

    public DviURLHistory(DviContextSupport dcs) {
        super(dcs);
    }

    public synchronized DviURLHistoryRecord moveTo(URL url) {
        if (this.getCurrentURL() != url) {
            this.recordURL(url);
        }
        return this.getCurrentRecord();
    }

    public synchronized DviURLHistoryRecord goBack() {
        if (this.list.size() <= 1) {
            return null;
        }
        this.list.removeLast();
        return this.getCurrentRecord();
    }

    public synchronized DviURLHistoryRecord getCurrentRecord() {
        if (this.list.size() > 0) {
            return this.list.getLast();
        }
        return null;
    }

    public synchronized URL getCurrentURL() {
        DviURLHistoryRecord rec = this.getCurrentRecord();
        if (rec == null) {
            return null;
        }
        return rec.getURL();
    }

    public synchronized DviURLHistoryRecord[] listRecords() {
        return this.list.toArray(new DviURLHistoryRecord[0]);
    }

    protected synchronized DviURLHistoryRecord recordURL(URL url) {
        long timestamp = this.getTimestamp();
        DviURLHistoryRecord rec = new DviURLHistoryRecord((DviContextSupport)this, url, timestamp);
        this.list.add(rec);
        return rec;
    }

    protected long getTimestamp() {
        return System.currentTimeMillis();
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder();
        for (DviURLHistoryRecord rec : this.list) {
            sb.append((Object)rec);
            sb.append("\n");
        }
        return sb.toString();
    }
}

