/*
 * Decompiled with CFR 0.152.
 */
package dvi.browser.util;

import dvi.event.TDefaultEventModel;
import dvi.event.TEvent;
import dvi.event.TEventModel;
import dvi.event.TEventProcessor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileWatch {
    private static final Logger LOGGER = Logger.getLogger(FileWatch.class.getName());
    private static final FileWatch instance = new FileWatch();
    private static final ScheduledExecutorService exe = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setDaemon(true);
            return t;
        }
    });
    private static final Set<Target> targets;

    private FileWatch() {
    }

    public static FileWatch getInstance() {
        return instance;
    }

    public synchronized void addTarget(Target target) throws IOException {
        if (target == null) {
            return;
        }
        targets.add(target);
    }

    public synchronized void removeTarget(Target target) throws IOException {
        if (target == null) {
            return;
        }
        targets.remove(target);
    }

    protected void checkTargets() {
        for (Target target : this.list()) {
            try {
                target.check();
            }
            catch (Exception ex) {
                LOGGER.warning(ex.toString());
            }
        }
    }

    public synchronized List<Target> list() {
        ArrayList<Target> list = new ArrayList<Target>();
        list.addAll(targets);
        return list;
    }

    static {
        exe.scheduleWithFixedDelay(new Worker(), 0L, 500L, TimeUnit.MILLISECONDS);
        LOGGER.config("Started FileWatch worker.");
        targets = new HashSet<Target>();
    }

    public static class Removed
    extends TEvent {
        private static final long serialVersionUID = -5052791614994332506L;

        public Removed(Object source) {
            super(source);
        }
    }

    public static class Created
    extends TEvent {
        private static final long serialVersionUID = 1617336492784766920L;

        public Created(Object source) {
            super(source);
        }
    }

    public static class Modified
    extends TEvent {
        private static final long serialVersionUID = -740289683404400167L;

        public Modified(Object source) {
            super(source);
        }
    }

    public static class Target
    implements TEventProcessor {
        private final TEventModel em = new TDefaultEventModel();
        private final long startTimestamp;
        private final long startTime;
        private long lastTimestamp;
        private long lastChecked;
        private boolean lastExists;
        private int count = 0;
        private boolean initial = true;
        private final File file;

        public TEventModel getEventModel() {
            return this.em;
        }

        public Target(File file) throws IOException {
            this.file = this.canonicalize(file);
            if (this.file == null) {
                throw new IllegalArgumentException("invalid file: " + file.getPath());
            }
            this.lastChecked = this.startTime = System.currentTimeMillis();
            this.lastTimestamp = this.startTimestamp = file.lastModified();
            this.lastExists = file.exists();
        }

        public File file() {
            return this.file;
        }

        protected File canonicalize(File file) throws IOException {
            return new File(file.getCanonicalPath());
        }

        protected void check() {
            try {
                boolean exists = this.file.exists();
                if (this.lastExists && !exists) {
                    this.handleRemoval();
                    this.lastExists = exists;
                } else if (!this.lastExists && exists) {
                    this.handleCreation();
                    this.lastExists = exists;
                }
                long ts = this.file.lastModified();
                if (ts != this.lastTimestamp && this.isContentReady(this.file)) {
                    this.lastTimestamp = ts;
                    ++this.count;
                    this.handleModification();
                }
                this.lastChecked = System.currentTimeMillis();
                this.initial = false;
            }
            catch (Exception ex) {
                LOGGER.warning(ex.toString());
            }
        }

        protected boolean isContentReady(File file) {
            return true;
        }

        protected void handleModification() {
            try {
                this.getEventModel().processEvent((TEvent)new Modified(this));
            }
            catch (Exception ex) {
                LOGGER.warning(ex.toString());
            }
        }

        protected void handleRemoval() {
            try {
                this.getEventModel().processEvent((TEvent)new Removed(this));
            }
            catch (Exception ex) {
                LOGGER.warning(ex.toString());
            }
        }

        protected void handleCreation() {
            try {
                this.getEventModel().processEvent((TEvent)new Created(this));
            }
            catch (Exception ex) {
                LOGGER.warning(ex.toString());
            }
        }

        public String toString() {
            return this.getClass().getName() + "[file=" + this.file.getPath() + " timestamp=" + this.lastTimestamp + " count=" + this.count + "]";
        }
    }

    private static class Worker
    implements Runnable {
        private Worker() {
        }

        public void run() {
            try {
                LOGGER.finer("Checking file modification.");
                FileWatch instance = FileWatch.getInstance();
                instance.checkTargets();
            }
            catch (Exception ex) {
                LOGGER.warning(ex.toString());
            }
        }
    }
}

