/*
 * Decompiled with CFR 0.152.
 */
package dvi;

import dvi.DviFontName;
import dvi.util.Canonicalizer;
import dvi.util.SimpleCanonicalizer;
import java.io.Serializable;

public final class DviFontSpec
implements Serializable {
    private static final long serialVersionUID = 2374998771511821276L;
    private final int cs;
    private final int ss;
    private final int ds;
    private final DviFontName fontName;
    private final double dviPerTfmw;
    private final int hash;
    private static final Canonicalizer<DviFontSpec> canonicalizer = new SimpleCanonicalizer<DviFontSpec>();
    private volatile String string = null;

    private DviFontSpec(int cs, int ss, int ds, DviFontName fontName) {
        this.cs = cs;
        this.ss = ss;
        this.ds = ds;
        this.fontName = fontName;
        this.hash = cs + 33 * (ss + 33 * (ds + 33 * fontName.hashCode()));
        this.dviPerTfmw = (double)ss / 1048576.0;
    }

    public static DviFontSpec getInstance(int cs, int ss, int ds, DviFontName fontName) {
        return canonicalizer.canonicalize(new DviFontSpec(cs, ss, ds, fontName));
    }

    public static DviFontSpec getInstance(int cs, int ss, int ds, int al, int nl, byte[] name) {
        return DviFontSpec.getInstance(cs, ss, ds, DviFontName.getInstance(al, nl, new String(name)));
    }

    public static DviFontSpec getInstance(int cs, int ss, int ds, int al, int nl, String name) {
        return DviFontSpec.getInstance(cs, ss, ds, DviFontName.getInstance(al, nl, name));
    }

    public int checkSum() {
        return this.cs;
    }

    public int spaceSize() {
        return this.ss;
    }

    public int designSize() {
        return this.ds;
    }

    public int areaLength() {
        return this.fontName.areaLength();
    }

    public int nameLength() {
        return this.fontName.nameLength();
    }

    public DviFontName fontName() {
        return this.fontName;
    }

    public String name() {
        return this.fontName.name();
    }

    public int tfmToDvi(int tfmw) {
        return (int)(this.dviPerTfmw * (double)tfmw);
    }

    public String toString() {
        if (this.string == null) {
            this.string = "FontSpec[cs=" + this.cs + " ss=" + this.ss + " ds=" + this.ds + " fontName=\"" + this.fontName + "\"]";
        }
        return this.string;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DviFontSpec) {
            DviFontSpec fs = (DviFontSpec)obj;
            return this.isCompatibleWith(fs) && this.cs == fs.cs;
        }
        return false;
    }

    public boolean isCompatibleWith(DviFontSpec fs) {
        return fs != null && this.ss == fs.ss && this.ds == fs.ds && this.fontName.equals(fs.fontName);
    }

    public int hashCode() {
        return this.hash;
    }

    public DviFontSpec rename(String newName) {
        return DviFontSpec.getInstance(this.cs, this.ss, this.ds, DviFontName.getInstance(newName));
    }
}

