/*
 * Decompiled with CFR 0.152.
 */
package dvi.cmd;

import java.io.Serializable;

public class DviBop
implements Serializable {
    private static final long serialVersionUID = 1326126283946043078L;
    private final int[] count;
    private final int backPointer;

    public DviBop(int[] count, int backPointer) {
        this.count = (int[])count.clone();
        this.backPointer = backPointer;
        this.checkValues();
    }

    public void checkValues() {
        if (this.count.length != 10) {
            throw new IllegalArgumentException("count must be of type int [10].");
        }
    }

    public String countAsString() {
        int i;
        String str = String.valueOf(this.count[0]);
        for (i = this.count.length - 1; i > 0 && this.count[i] == 0; --i) {
        }
        for (int j = 1; j <= i; ++j) {
            str = str + ":" + this.count[j];
        }
        return str;
    }

    public int[] count() {
        return (int[])this.count.clone();
    }

    public int backPointer() {
        return this.backPointer;
    }

    public String toString() {
        return this.getClass().getName() + "[count=" + this.countAsString() + ",backPointer=" + this.backPointer + "]";
    }

    public boolean equals(Object o) {
        if (o instanceof DviBop) {
            DviBop a = (DviBop)o;
            if (a.backPointer != this.backPointer || a.count.length != this.count.length || this.count.length != 10) {
                return false;
            }
            for (int i = 0; i < 10; ++i) {
                if (a.count[i] == this.count[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hash = this.backPointer;
        for (int a : this.count) {
            hash = a + 33 * hash;
        }
        return hash;
    }
}

