/*
 * Decompiled with CFR 0.152.
 */
package dvi.ctx;

import dvi.DviException;
import dvi.DviObject;
import dvi.api.DviContextSupport;
import dvi.util.concurrent.Computation;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDviResourceResolver<S, T>
extends DviObject
implements Computation<String, Collection<T>> {
    private final S spec;

    public AbstractDviResourceResolver(DviContextSupport dcs, S spec) {
        super(dcs);
        this.spec = spec;
    }

    @Override
    public Collection<T> call() throws Exception {
        T item;
        ArrayList<T> list = new ArrayList<T>();
        String filename = this.mapToDviResourceName(this.getSpec());
        URL url = this.getDviContext().getDviResource(filename);
        if (url != null && (item = this.createInstanceFromURL(url)) != null) {
            list.add(item);
        }
        return list;
    }

    @Override
    public String getCacheKey() {
        return this.mapToDviResourceName(this.getSpec());
    }

    protected T createInstanceFromURL(URL url) throws DviException, IOException {
        if (url == null) {
            return null;
        }
        return this.createInstanceFromStream(url.openStream());
    }

    protected abstract T createInstanceFromStream(InputStream var1) throws DviException;

    protected abstract String mapToDviResourceName(S var1);

    public S getSpec() {
        return this.spec;
    }
}

