/*
 * Decompiled with CFR 0.152.
 */
package dvi.font;

import dvi.DviException;
import dvi.DviObject;
import dvi.api.DviContextSupport;
import dvi.api.DviFont;
import dvi.api.Glyph;
import dvi.font.GlyphCache;
import dvi.font.LogicalFont;
import dvi.font.PkGlyph;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public abstract class AbstractDynamicPkFont
extends DviObject
implements DviFont,
Serializable {
    private static final long serialVersionUID = -7653383398207050528L;

    public AbstractDynamicPkFont(DviContextSupport dcs) throws DviException {
        super(dcs);
    }

    public Glyph getGlyph(LogicalFont lf, int code) throws DviException {
        String key = lf.fontSpec().toString() + "--" + lf.dviUnit().toString() + "--" + lf.resolution().dpi() + "--" + code;
        GlyphCache cache = this.getDviContext().getGlyphCache();
        Glyph glyph = (Glyph)cache.get(key);
        if (glyph != null) {
            return glyph;
        }
        glyph = this.generatePkGlyph(lf, code);
        cache.put(key, glyph);
        return glyph;
    }

    protected abstract PkGlyph generatePkGlyph(LogicalFont var1, int var2) throws DviException;

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }
}

