/*
 * Decompiled with CFR 0.152.
 */
package dvi.font;

import dvi.DviException;
import dvi.api.BinaryDevice;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RunLengthEncodedLine
implements Cloneable {
    private int hash = 0;
    private int width = 0;
    private boolean headOn = false;
    private boolean tailOn = false;
    private ArrayList<Integer> data = new ArrayList();

    public ArrayList<Integer> getData() {
        return this.data;
    }

    public boolean headOn() {
        return this.headOn;
    }

    public boolean tailOn() {
        return this.tailOn;
    }

    public int width() {
        return this.width;
    }

    public boolean allOn() {
        return this.headOn && this.data.size() == 1;
    }

    public boolean allOff() {
        return !this.headOn && this.data.size() == 1;
    }

    public int head() {
        return this.isEmpty() ? 0 : this.data.get(0);
    }

    public int tail() {
        return this.isEmpty() ? 0 : this.data.get(this.data.size() - 1);
    }

    public void rasterizeTo(BinaryDevice out) throws DviException {
        boolean flag = this.headOn;
        int ds = this.data.size();
        for (int i = 0; i < ds; ++i) {
            out.putBits(this.data.get(i), flag);
            flag = !flag;
        }
    }

    public void prepend(int count, boolean isOn) {
        if (count <= 0) {
            return;
        }
        if (this.width == 0) {
            this.headOn = this.tailOn = isOn;
            this.data.add(count);
            this.width = count;
        } else {
            if (this.headOn == isOn) {
                this.data.set(0, this.data.get(0) + count);
            } else {
                this.data.add(0, count);
                this.headOn = isOn;
            }
            this.width += count;
        }
        this.hash += isOn ? count : -count;
    }

    public void append(int count, boolean isOn) {
        if (count <= 0) {
            return;
        }
        if (this.width == 0) {
            this.headOn = this.tailOn = isOn;
            this.data.add(count);
            this.width = count;
        } else {
            int last = this.data.size() - 1;
            if (this.tailOn == isOn) {
                this.data.set(last, this.data.get(last) + count);
            } else {
                this.data.add(count);
                this.tailOn = isOn;
            }
            this.width += count;
        }
        this.hash += isOn ? count : -count;
    }

    public void cropHead(int count) {
        if (this.width == 0) {
            return;
        }
        while (count > 0) {
            int c = this.data.get(0);
            if (c > count) {
                this.data.set(0, c - count);
                this.width -= count;
                this.hash -= this.headOn ? count : -count;
                break;
            }
            this.data.remove(0);
            this.hash -= this.headOn ? c : -c;
            this.headOn = !this.headOn;
            count -= c;
            this.width -= c;
            if (this.width > 0) continue;
            this.clear();
            break;
        }
    }

    public void cropTail(int count) {
        if (this.width == 0) {
            return;
        }
        while (count > 0) {
            int last = this.data.size() - 1;
            int c = this.data.get(last);
            if (c > count) {
                this.data.set(last, c - count);
                this.hash -= this.tailOn ? count : -count;
                this.width -= count;
                break;
            }
            this.data.remove(last);
            this.hash -= this.tailOn ? c : -c;
            this.tailOn = !this.tailOn;
            count -= c;
            this.width -= c;
            if (this.width > 0) continue;
            this.clear();
            break;
        }
    }

    public void prepend(RunLengthEncodedLine rll) {
        if (rll.isEmpty()) {
            return;
        }
        if (rll == this) {
            rll = (RunLengthEncodedLine)this.clone();
        }
        boolean flag = rll.tailOn;
        for (int i = rll.data.size() - 1; i >= 0; --i) {
            this.prepend(rll.data.get(i), flag);
            flag = !flag;
        }
    }

    public void append(RunLengthEncodedLine rll) {
        if (rll.isEmpty()) {
            return;
        }
        if (rll == this) {
            rll = (RunLengthEncodedLine)this.clone();
        }
        boolean flag = rll.headOn;
        int ds = rll.data.size();
        for (int i = 0; i < ds; ++i) {
            this.append(rll.data.get(i), flag);
            flag = !flag;
        }
    }

    public void prepend(byte[] buf) {
        this.prepend(buf, 0, buf.length * 8, false);
    }

    public void append(byte[] buf) {
        this.append(buf, 0, buf.length * 8, false);
    }

    public void prepend(byte[] buf, int bitOffset, int bitLen) {
        this.prepend(buf, bitOffset, bitLen, false);
    }

    public void append(byte[] buf, int bitOffset, int bitLen) {
        this.append(buf, bitOffset, bitLen, false);
    }

    public void prepend(byte[] buf, int bitOffset, int bitLen, boolean revert) {
        if (bitOffset < 0) {
            throw new IllegalArgumentException("bit offset can't be negative");
        }
        if (bitLen <= 0) {
            return;
        }
        for (int i = bitOffset + bitLen - 1; i >= bitOffset; --i) {
            boolean flag;
            boolean bl = flag = 0 != (buf[i >>> 3] & 1 << 7 - (i & 7));
            this.prepend(1, revert ? !flag : flag);
        }
    }

    public void append(byte[] buf, int bitOffset, int bitLen, boolean revert) {
        if (bitOffset < 0) {
            throw new IllegalArgumentException("bit offset can't be negative");
        }
        if (bitLen <= 0) {
            return;
        }
        for (int i = 0; i < bitLen; ++i) {
            boolean flag;
            int p = i + bitOffset;
            boolean bl = flag = 0 != (buf[p >>> 3] & 1 << 7 - (p & 7));
            this.append(1, revert ? !flag : flag);
        }
    }

    public static RunLengthEncodedLine union(RunLengthEncodedLine a, RunLengthEncodedLine b) {
        if (a == null || b == null) {
            throw new NullPointerException();
        }
        if (a.isEmpty()) {
            return (RunLengthEncodedLine)b.clone();
        }
        if (b.isEmpty()) {
            return (RunLengthEncodedLine)a.clone();
        }
        RunLengthEncodedLine rll = new RunLengthEncodedLine();
        boolean a_flag = a.headOn;
        boolean b_flag = b.headOn;
        int a_ptr = 0;
        int b_ptr = 0;
        int a_size = a.data.size();
        int b_size = b.data.size();
        int a_count = a.data.get(0);
        int b_count = b.data.get(0);
        while (a_count != Integer.MAX_VALUE || b_count != Integer.MAX_VALUE) {
            int c;
            boolean flag;
            boolean bl = flag = a_flag || b_flag;
            int count = a_flag && b_flag ? Math.max(a_count, b_count) : (a_flag ? a_count : (b_flag ? b_count : Math.min(a_count, b_count)));
            rll.append(count, flag);
            for (c = count; a_count <= c; c -= a_count) {
                if (++a_ptr >= a_size) {
                    a_count = Integer.MAX_VALUE;
                    a_flag = false;
                    continue;
                }
                a_count = a.data.get(a_ptr);
                a_flag = !a_flag;
            }
            if (a_count < Integer.MAX_VALUE) {
                a_count -= c;
            }
            for (c = count; b_count <= c; c -= b_count) {
                if (++b_ptr >= b_size) {
                    b_count = Integer.MAX_VALUE;
                    b_flag = false;
                    continue;
                }
                b_count = b.data.get(b_ptr);
                b_flag = !b_flag;
            }
            if (b_count >= Integer.MAX_VALUE) continue;
            b_count -= c;
        }
        return rll;
    }

    public void clear() {
        this.hash = 0;
        this.width = 0;
        this.tailOn = false;
        this.headOn = false;
        this.data.clear();
    }

    public boolean isEmpty() {
        return this.width == 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RunLengthEncodedLine) {
            RunLengthEncodedLine rll = (RunLengthEncodedLine)obj;
            return rll.hash == this.hash && rll.width == this.width && rll.headOn == this.headOn && rll.tailOn == this.tailOn && rll.data.equals(this.data);
        }
        return false;
    }

    public int hashCode() {
        return this.hash;
    }

    public Object clone() {
        try {
            RunLengthEncodedLine rll = (RunLengthEncodedLine)super.clone();
            rll.data = (ArrayList)rll.data.clone();
            return rll;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }

    public String toString() {
        String str = "";
        boolean flag = this.headOn;
        int s = this.data.size();
        for (int i = 0; i < s; ++i) {
            int count = this.data.get(i);
            str = flag ? str + String.valueOf(count) : str + "(" + String.valueOf(count) + ")";
            flag = !flag;
        }
        return this.getClass().getName() + "[width=" + this.width + " hash=" + this.hash + " headOn=" + this.headOn + " tailOn=" + this.tailOn + " dataSize=" + this.data.size() + " data=[" + str + "]";
    }

    public String dump() {
        String str = "";
        boolean flag = this.headOn;
        int s = this.data.size();
        for (int i = 0; i < s; ++i) {
            int count = this.data.get(i);
            if (flag) {
                while (count-- > 0) {
                    str = str + "*";
                }
            } else {
                while (count-- > 0) {
                    str = str + "-";
                }
            }
            flag = !flag;
        }
        return str;
    }
}

