/*
 * Decompiled with CFR 0.152.
 */
package dvi.render;

import dvi.DviObject;
import dvi.DviResolution;
import dvi.api.DviContextSupport;
import dvi.api.DviPage;
import dvi.ctx.DviToolkit;
import dvi.gui.swing.ViewSpec;
import dvi.util.concurrent.Computation;
import dvi.util.progress.ProgressItem;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DviPagePreparator
extends DviObject
implements Computation<String, Long> {
    private static final Logger LOGGER = Logger.getLogger(DviPagePreparator.class.getName());
    private final DviPage page;
    private final ViewSpec viewSpec;

    public DviPagePreparator(DviContextSupport dcs, DviPage page, ViewSpec viewSpec) {
        super(dcs);
        this.page = page;
        this.viewSpec = viewSpec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long call() throws Exception {
        if (this.page == null) {
            return -1L;
        }
        ProgressItem progress = this.getDviContext().getProgressRecorder().open("loading page " + this.page);
        try {
            long start = System.currentTimeMillis();
            LOGGER.finer("Start preparation of page " + this.page);
            ViewSpec dummyViewSpec = (ViewSpec)this.viewSpec.clone();
            DviResolution res = this.viewSpec.getResolution();
            dummyViewSpec.setResolution(res.approximate(10.0));
            DviToolkit utils = this.getDviContext().getDviToolkit();
            utils.renderToBufferedImage(this.page, null, dummyViewSpec);
            long end = System.currentTimeMillis();
            LOGGER.finer("Finished preparation of page " + this.page);
            LOGGER.finer("  Elapsed time = " + (end - start));
            Long l = end - start;
            return l;
        }
        finally {
            progress.close();
        }
    }

    @Override
    public String getCacheKey() {
        return this.page.getCacheKey();
    }

    public DviPage getPage() {
        return this.page;
    }

    public ViewSpec getViewSpec() {
        return this.viewSpec;
    }
}

