/*
 * Decompiled with CFR 0.152.
 */
package dvi.render;

import dvi.api.GammaCorrector;

public class GammaCorrectorCache
implements GammaCorrector {
    private final int[] table;
    private int maxval;
    private boolean canLookUp;
    private final GammaCorrector gammaCorrector;

    public GammaCorrectorCache(GammaCorrector gammaCorrector) {
        this(gammaCorrector, 65536);
    }

    public GammaCorrectorCache(GammaCorrector gammaCorrector, int tableSize) {
        this.table = new int[tableSize];
        this.gammaCorrector = gammaCorrector;
    }

    public void setMaxValue(int maxval) {
        this.maxval = maxval;
        if (maxval < this.table.length) {
            for (int i = 0; i <= maxval; ++i) {
                this.table[i] = this.doCorrectGamma(i, maxval);
            }
            this.canLookUp = true;
        } else {
            this.canLookUp = false;
        }
    }

    public int correctGamma(int c, int maxval) {
        if (c < 0) {
            throw new IllegalArgumentException("c is negative");
        }
        if (maxval < 0) {
            throw new IllegalArgumentException("maxval is negative");
        }
        if (this.gammaCorrector == null) {
            return 0;
        }
        if (maxval != this.maxval) {
            this.setMaxValue(maxval);
        }
        if (this.canLookUp && c <= maxval) {
            return this.table[c];
        }
        return this.doCorrectGamma(c, maxval);
    }

    private int doCorrectGamma(int c, int maxval) {
        return this.gammaCorrector.correctGamma(c, maxval);
    }

    public GammaCorrector getGammaCorrector() {
        return this.gammaCorrector;
    }
}

