/*
 * Decompiled with CFR 0.152.
 */
package dvi.special;

import dvi.DviObject;
import dvi.DviResolution;
import dvi.api.DviContextSupport;
import dvi.api.DviDocument;
import dvi.api.HasURL;
import dvi.gui.swing.ViewSpec;
import dvi.render.BasicGeometer;
import dvi.render.EmptyBinaryDevice;
import dvi.special.EmbeddedPostScript;
import dvi.special.PostScriptSpecialParser;
import dvi.util.DviUtils;
import dvi.util.concurrent.Computation;
import dvi.util.progress.ProgressItem;
import java.io.File;
import java.net.URL;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbeddedPostScriptPreparator
extends DviObject
implements Computation<String, EmbeddedPostScript> {
    private static final Logger LOGGER = Logger.getLogger(EmbeddedPostScriptPreparator.class.getName());
    private final DviDocument doc;
    private final ViewSpec viewSpec;

    public EmbeddedPostScriptPreparator(DviContextSupport dcs, DviDocument doc, ViewSpec viewSpec) {
        super(dcs);
        this.doc = doc;
        this.viewSpec = viewSpec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EmbeddedPostScript call() throws Exception {
        if (this.doc == null) {
            return null;
        }
        ProgressItem progress = this.getDviContext().getProgressRecorder().open("extracting EPS data from " + this.doc);
        try {
            EmbeddedPostScript eps;
            PostScriptSpecialParser pse = new PostScriptSpecialParser(this);
            if (this.doc instanceof HasURL) {
                URL url = ((HasURL)((Object)this.doc)).getURL();
                if (DviUtils.isFile(url)) {
                    File file = new File(url.getPath());
                    File dir = file.getParentFile();
                    LOGGER.finer("working dir=" + dir);
                    pse.setWorkDirectory(dir);
                } else {
                    LOGGER.finer("Using default working dir");
                }
            } else {
                LOGGER.finer("No URL is available for doc " + this.doc);
            }
            pse.getEmbeddedPostScript().add(new EmbeddedPostScript.PrologueFile(this, "texc.pro"));
            pse.getEmbeddedPostScript().add(new EmbeddedPostScript.PrologueFile(this, "special.pro"));
            pse.setOutput(new EmptyBinaryDevice(new DviResolution(600, 4)));
            BasicGeometer gm = new BasicGeometer(this);
            gm.setPainter(pse);
            this.getDviContext().execute(this.doc, gm);
            EmbeddedPostScript embeddedPostScript = eps = pse.getEmbeddedPostScript();
            return embeddedPostScript;
        }
        finally {
            progress.close();
        }
    }

    @Override
    public String getCacheKey() {
        return "EPS--" + this.doc.getCacheKey();
    }

    public DviDocument getDocument() {
        return this.doc;
    }

    public ViewSpec getViewSpec() {
        return this.viewSpec;
    }
}

