/*
 * Decompiled with CFR 0.152.
 */
package dvi.special;

import dvi.DviException;
import dvi.DviObject;
import dvi.api.DviContextSupport;
import dvi.api.DviDocument;
import dvi.render.BasicExecutor;
import dvi.special.AbstractDviSpecialExecutor;
import dvi.special.Anchor;
import dvi.special.AnchorSet;
import java.util.Stack;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SourceSpecialParser
extends DviObject {
    private static final Logger LOGGER = Logger.getLogger(SourceSpecialParser.class.getName());
    private final AnchorSet anchorSet = new AnchorSet();
    private final PrivateExecuter exe;
    private static final Pattern srcPat = Pattern.compile("\\s*src:\\s*([-0-9]*)\\s\\s*(.*)\\s*", 2);

    public SourceSpecialParser(DviContextSupport dcs) {
        super(dcs);
        this.exe = new PrivateExecuter(dcs, this.anchorSet);
    }

    public void execute(DviDocument doc) throws DviException {
        for (int p = 0; p < doc.getTotalPages(); ++p) {
            this.exe.execute(doc.getPage(p));
        }
    }

    public AnchorSet getAnchorSet() {
        return this.anchorSet;
    }

    private static class PrivateExecuter
    extends AbstractDviSpecialExecutor {
        private final AnchorSet anchorSet;
        private final Stack<StackItem> stack = new Stack();

        public PrivateExecuter(DviContextSupport dcs, AnchorSet anchorSet) {
            super(dcs);
            this.anchorSet = anchorSet;
        }

        public void end() throws DviException {
            this.flushStack();
            super.end();
        }

        private void flushStack() {
            if (!this.stack.empty()) {
                StackItem it = this.stack.pop();
                BasicExecutor.DviExecutorContextImpl ctx = this.getExecutorContext();
                Anchor.Source a = null;
                if ("src".equals(it.tag)) {
                    a = new Anchor.Source(it.start, ctx.getCommandRange().end(), it.data, it.lineNumber);
                }
                this.anchorSet.add(a);
            }
        }

        public void doSpecial(byte[] _xxx) throws DviException {
            String xxx = new String(_xxx);
            BasicExecutor.DviExecutorContextImpl ctx = this.getExecutorContext();
            Matcher mat = srcPat.matcher(xxx);
            if (mat.matches()) {
                this.flushStack();
                try {
                    this.stack.push(new StackItem(ctx.getCommandRange().begin(), "src", mat.group(2), Integer.parseInt(mat.group(1))));
                }
                catch (NumberFormatException e) {
                    LOGGER.warning(e.getMessage());
                }
            }
        }

        private static class StackItem {
            private final long start;
            private final String tag;
            private final String data;
            private final int lineNumber;

            public StackItem(long start, String tag, String data, int lineNumber) {
                this.start = start;
                this.tag = tag;
                this.data = data;
                this.lineNumber = lineNumber;
            }
        }
    }
}

