/*
 * Decompiled with CFR 0.152.
 */
package dvi.util;

import java.text.MessageFormat;

public class Benchmark {
    private long start = 0L;
    private long lapsed = 0L;
    private long samples = 0L;
    private String name;

    public void begin(String name) {
        this.start = System.currentTimeMillis();
        this.name = name;
    }

    public void addSample() {
        ++this.samples;
    }

    public void end() {
        this.lapsed = System.currentTimeMillis() - this.start;
        if (this.lapsed == 0L) {
            this.lapsed = 1L;
        }
    }

    public long lapsedTime() {
        return this.lapsed;
    }

    public double samplesPerSecond() {
        return (double)this.samples * 1000.0 / (double)this.lapsed;
    }

    public String format(String fmt) {
        return MessageFormat.format(fmt, this.samples, (double)this.lapsed / 1000.0, this.samplesPerSecond(), 1.0 / this.samplesPerSecond() * 1000.0);
    }

    public String format() {
        return this.format("Bench: " + this.name + ": " + "{0,number} samples in {1,number} sec." + " {2,number} samples/sec. " + " {3,number,##.###} msec./sample.");
    }

    public String toString() {
        return this.format();
    }
}

