/*
 * Decompiled with CFR 0.152.
 */
package dvi.util;

import dvi.DviException;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TeXMessageParser {
    public static final String STATE_INITIAL = "INITIAL";

    public void parse(Reader r, Handler handler) throws DviException, IOException {
        if (handler == null) {
            throw new NullPointerException("handler can't be null");
        }
        Env env = new Env();
        env.reader = new BufferedReader(r);
        env.handler = handler;
        env.state = STATE_INITIAL;
        env.stop = false;
        env.firstLine = env.reader.readLine();
        if (env.firstLine == null) {
            throw new EOFException("input stream ended while reading the first line.");
        }
        env.handler.begin(env);
        while (!env.stop) {
            String line = env.reader.readLine();
            this.parseLine(env, line);
        }
    }

    protected void parseLine(Env env, String line) throws DviException, IOException {
        if (line == null) {
            if (!env.stop) {
                env.handler.end(env);
            }
            env.stop = true;
            return;
        }
        env.handler.onEachLine(env, line);
        if (!STATE_INITIAL.equals(env.state)) {
            throw new IllegalStateException();
        }
        this.parseLineInitial(env, line);
    }

    protected void parseLineInitial(Env env, String line) throws DviException, IOException {
        env.unrecognized = "";
        int pos = 0;
        while (pos < line.length()) {
            int next = -1;
            if (line.charAt(pos) == '(') {
                int p = -1;
                int p1 = line.indexOf("(", pos + 1);
                int p2 = line.indexOf(")", pos + 1);
                p = p1 == -1 ? p2 : (p2 == -1 ? p1 : Math.min(p1, p2));
                if (p == -1) {
                    p = line.length();
                }
                String filename = line.substring(pos + 1, p);
                boolean success = env.handler.isSupportedFileName(env, filename);
                if (success) {
                    env.handler.beginInput(env, filename);
                    next = p;
                }
            } else if (line.charAt(pos) == ')') {
                this.flushUnrecognized(env);
                env.handler.endInput(env);
                next = pos + 1;
            } else if (line.charAt(pos) == '[') {
                String a = line.substring(pos + 1);
                Matcher mat = Pattern.compile("^(\\d+)").matcher(a);
                if (mat.find()) {
                    int count = -1;
                    try {
                        count = Integer.parseInt(mat.group(1));
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    this.flushUnrecognized(env);
                    env.handler.setCounter(env, count);
                    next = pos + 1 + mat.group(1).length();
                }
            } else if (line.charAt(pos) == ']') {
                next = pos + 1;
            }
            if (next == -1) {
                env.unrecognized = env.unrecognized + String.valueOf(line.charAt(pos));
                ++pos;
                continue;
            }
            pos = next;
        }
        this.flushUnrecognized(env);
    }

    protected void flushUnrecognized(Env env) {
        String str = env.unrecognized.trim();
        env.unrecognized = "";
        if (str != null && str.length() > 0) {
            env.handler.handleUnrecognized(env, str);
        }
    }

    public static class Dumper
    extends Adaptor {
        protected final PrintStream out;

        public Dumper(PrintStream out) {
            this.out = out;
        }

        public boolean isSupportedFileName(Env env, String str) {
            return new File(str).exists();
        }

        public void onEachLine(Env env, String line) {
            this.out.println("############" + line + "########");
        }

        public void beginInput(Env env, String filename) {
            this.out.println("<input filename=\"" + filename + "\">");
        }

        public void endInput(Env env) {
            this.out.println("</input>");
        }

        public void handleUnrecognized(Env env, String str) {
            this.out.println("<unrecognized>" + str + "</unrecognized>");
        }
    }

    public static abstract class Adaptor
    implements Handler {
        public boolean isSupportedFileName(Env env, String str) {
            return false;
        }

        public void begin(Env env) {
        }

        public void end(Env env) {
        }

        public void beginInput(Env env, String filename) {
        }

        public void endInput(Env env) {
        }

        public void setCounter(Env env, int count) {
        }

        public void onEachLine(Env env, String line) {
        }

        public void handleUnrecognized(Env env, String line) {
        }
    }

    public static interface Handler {
        public boolean isSupportedFileName(Env var1, String var2);

        public void begin(Env var1);

        public void end(Env var1);

        public void beginInput(Env var1, String var2);

        public void endInput(Env var1);

        public void setCounter(Env var1, int var2);

        public void onEachLine(Env var1, String var2);

        public void handleUnrecognized(Env var1, String var2);
    }

    public static class Env {
        private boolean stop;
        private String state;
        private String unrecognized;
        private BufferedReader reader;
        private Handler handler;
        private String firstLine;
    }
}

