/*
*	DXCuPortable	摜ǂݍ݁Aϊ	Ver1.10
*		FJ
*	l	FFXƏ܂BSwizzleVRAMւ̓]͂ōsĂ܂B
*	
*/

#include <pspgu.h>
#include <malloc.h>
#include <stdio.h>
#include <string.h>
#include <png.h>
#include "dxlibp.h"
#include "dxpstatic.h"
#include <pspjpeg.h>
/*
摜̑傫
ۂɓǂݏö
sb`̌vZ
m
ǂݏo
o^

*/
#define GU_PSM_5650		(0) /* Display, Texture, Palette */
#define GU_PSM_5551		(1) /* Display, Texture, Palette */
#define GU_PSM_4444		(2) /* Display, Texture, Palette */
#define GU_PSM_8888		(3) /* Display, Texture, Palette */

int LoadGraph(const char *FileName)
{
	int res = -1;

	if(res == -1)res = LoadPngImage(FileName);
	if(res == -1)res = LoadJpegImage(FileName);

	if(res != -1)
	{
		if(gusettings.flags[0] & GPUSETTINGFLAGS_0_CREATESWIZZLEDGRAPH)
			SwizzleGraph(res);
		if(gusettings.flags[0] & GPUSETTINGFLAGS_0_CREATEVRAMGRAPH)
			MoveGraphToVRAM(res);
		texarray[res].flags |= TEXTUREFLAGS_RELOAD;
	}
	return res;
}




int PSM2BYTEx2(int psm)
{
	switch(psm)
	{
	case GU_PSM_T4:
		return 1;
	case GU_PSM_T8:
		return 2;
	case GU_PSM_4444:
	case GU_PSM_5551:
	case GU_PSM_5650:
		return 4;
	case GU_PSM_8888:
		return 8;
	default:
		return 0;
	}
}

void swizzle_fast(u8* out, const u8* in, unsigned int width, unsigned int height)
{
   unsigned int blockx, blocky;
   unsigned int j;
 
   unsigned int width_blocks = (width / 16);
   unsigned int height_blocks = (height / 8);
 
   unsigned int src_pitch = (width-16)/4;
   unsigned int src_row = width * 8;
 
   const u8* ysrc = in;
   u32* dst = (u32*)out;
 
   for (blocky = 0; blocky < height_blocks; ++blocky)
   {
      const u8* xsrc = ysrc;
      for (blockx = 0; blockx < width_blocks; ++blockx)
      {
         const u32* src = (u32*)xsrc;
         for (j = 0; j < 8; ++j)
         {
            *(dst++) = *(src++);
            *(dst++) = *(src++);
            *(dst++) = *(src++);
            *(dst++) = *(src++);
            src += src_pitch;
         }
         xsrc += 16;
     }
     ysrc += src_row;
   }
}
void unswizzle_fast(u8* out, const u8* in, unsigned int width, unsigned int height)
{
   unsigned int blockx, blocky;
   unsigned int j;
 
   unsigned int width_blocks = (width / 16);
   unsigned int height_blocks = (height / 8);
 
   unsigned int src_pitch = (width-16)/4;
   unsigned int src_row = width * 8;
 
   u8* ysrc = out;
   u32* dst = (u32*)in;
 
   for (blocky = 0; blocky < height_blocks; ++blocky)
   {
      u8* xsrc = ysrc;
      for (blockx = 0; blockx < width_blocks; ++blockx)
      {
         u32* src = (u32*)xsrc;
         for (j = 0; j < 8; ++j)
         {
            *(src++) = *(dst++);
            *(src++) = *(dst++);
            *(src++) = *(dst++);
            *(src++) = *(dst++);
            src += src_pitch;
         }
         xsrc += 16;
     }
     ysrc += src_row;
   }
}

int SwizzleGraph(int gh)	/*w肳ꂽOtBbNSwizzleB*/
{
	sceKernelDcacheWritebackAll();
	void *buf;
	s32 size;
	if(GraphicHandleCheck(gh) == -1){return -1;}
	if(texarray[gh].flags & TEXTUREFLAGS_SWIZZLED){return 0;}
	if((size = GraphSize2DataSize(texarray[gh].pitch,texarray[gh].height,texarray[gh].psm)) <= 0){return -1;}
	if((buf = memalign(16,size)) == NULL){return -1;}
	if(texarray[gh].flags & TEXTUREFLAGS_VRAM)
	{
		swizzle_fast(buf,sceGeEdramGetAddr() + texarray[gh].pvram->offset, PSM2BYTEx2(texarray[gh].psm) * texarray[gh].pitch / 2,texarray[gh].height);
		memcpy(sceGeEdramGetAddr() + texarray[gh].pvram->offset,buf,size);
		free(buf);
	}else
	{
		swizzle_fast(buf,texarray[gh].pmemory, PSM2BYTEx2(texarray[gh].psm) * texarray[gh].pitch >> 1,texarray[gh].height);
		free(texarray[gh].pmemory);
		texarray[gh].pmemory = buf;
	}
	texarray[gh].flags |= TEXTUREFLAGS_SWIZZLED;
//	sceKernelDcacheWritebackRange(buf,size);
	sceKernelDcacheWritebackAll();
	texarray[gh].flags |= TEXTUREFLAGS_RELOAD;
	return 0;
}
int UnswizzleGraph(int gh)	/*w肳ꂽOtBbNUnswizzleB*/
{
	sceKernelDcacheWritebackAll();
	void *buf;
	s32 size;
	if(GraphicHandleCheck(gh) == -1){return -1;}
	if(!(texarray[gh].flags & TEXTUREFLAGS_SWIZZLED)){return 0;}
	if((size = GraphSize2DataSize(texarray[gh].pitch,texarray[gh].height,texarray[gh].psm)) <= 0){return -1;}
	if((buf = memalign(16,size)) == NULL){return -1;}
	if(texarray[gh].flags & TEXTUREFLAGS_VRAM)
	{
		unswizzle_fast(buf,sceGeEdramGetAddr() + texarray[gh].pvram->offset, PSM2BYTEx2(texarray[gh].psm) * texarray[gh].pitch / 2,texarray[gh].height);
		memcpy(sceGeEdramGetAddr() + texarray[gh].pvram->offset,buf,size);
		free(buf);
	}else
	{
		unswizzle_fast(buf,texarray[gh].pmemory, PSM2BYTEx2(texarray[gh].psm) * texarray[gh].pitch >> 1,texarray[gh].height);
		free(texarray[gh].pmemory);
		texarray[gh].pmemory = buf;
	}
	texarray[gh].flags &= ~TEXTUREFLAGS_SWIZZLED;
//	sceKernelDcacheWritebackRange(buf,size);
	sceKernelDcacheWritebackAll();
	texarray[gh].flags |= TEXTUREFLAGS_RELOAD;
	return 0;
}

int MoveGraphToVRAM(int gh)	/*OtBbNVRAMɈړBVRAMs̏ꍇ͂ȂɂȂB*/
{
	GUFINISH
	s32 size;
	if(GraphicHandleCheck(gh) == -1)return -1;
	if(texarray[gh].flags & TEXTUREFLAGS_VRAM)return 0;
	if((size = GraphSize2DataSize(texarray[gh].pitch,texarray[gh].height,texarray[gh].psm)) <= 0)return -1;
	if((texarray[gh].pvram = AllocVRAM(size,0)) == NULL)return -1;
	memcpy(sceGeEdramGetAddr() + texarray[gh].pvram->offset,texarray[gh].pmemory,size);
	sceKernelDcacheWritebackAll();
//	sceKernelDcacheWritebackRange(sceGeEdramGetAddr() + texarray[gh].pvram->offset,size);/*CPULbV̖݂h*/
	free(texarray[gh].pmemory);
	texarray[gh].pmemory = NULL;
	texarray[gh].flags |= TEXTUREFLAGS_VRAM;
	texarray[gh].flags |= TEXTUREFLAGS_RELOAD;
	return 0;
}

int MoveGraphToDDR(int gh)	/*OtBbNCɈړ*/
{
	GUFINISH
	s32 size;
	if(GraphicHandleCheck(gh) == -1)return -1;
	if(!(texarray[gh].flags & TEXTUREFLAGS_VRAM))return 0;
	if((size = GraphSize2DataSize(texarray[gh].pitch,texarray[gh].height,texarray[gh].psm)) <= 0)return -1;
	if(texarray[gh].pmemory == NULL)
	{
		if((texarray[gh].pmemory = memalign(16,size)) == NULL)return -1;
	}
	sceKernelDcacheWritebackAll();
	memcpy(texarray[gh].pmemory,sceGeEdramGetAddr() + texarray[gh].pvram->offset,size);
	sceKernelDcacheWritebackAll();
//	sceKernelDcacheWritebackRange(texarray[gh].pmemory,size);/*CPULbV̖݂h*/
	FreeVRAM(texarray[gh].pvram);
	texarray[gh].pvram = NULL;
	texarray[gh].flags &= (~TEXTUREFLAGS_VRAM);
	texarray[gh].flags |= TEXTUREFLAGS_RELOAD;
	return 0;
}

int LoadRAWData(const char *FileName,int SizeX,int SizeY,int Format)
{
	int i;
	int fh;
	int gh;
	int depth;
	if((fh = FileRead_open(FileName)) == -1)return -1;
	if((gh = MakeGraph(SizeX,SizeY,Format)) == -1)
	{
		FileRead_close(fh);
		return -1;
	}
	depth = Format == GU_PSM_8888 ? 4 : 2;
	for(i = 0;i < texarray[gh].mv;++i)
	{
		FileRead_seek(fh,i * SizeX * depth,SEEK_SET);
		FileRead_read(texarray[gh].pmemory + i * texarray[gh].pitch * depth,i * texarray[gh].pitch * depth,fh);
	}
//	FileRead_read(texarray[gh].pmemory,texarray[gh].mu * texarray[gh].mv * depth,fh);
	FileRead_close(fh);
	sceKernelDcacheWritebackAll();
//	sceKernelDcacheWritebackRange(texarray[gh].pmemory,texarray[gh].pitch * texarray[gh].height * depth);

	/*KvA\Ȃswizzle*/
	if(gusettings.flags[0] & GPUSETTINGFLAGS_0_CREATESWIZZLEDGRAPH)
	{
		//swizzle
		SwizzleGraph(gh);
	}
	/*KvA\ȂVRAMɓ]*/
	if(gusettings.flags[0] & GPUSETTINGFLAGS_0_CREATEVRAMGRAPH)
	{
		MoveGraphToVRAM(gh);
	}
	return gh;
}

int ConvertGraphFormat(int gh,int psm)
/*
DDRSwizzleȂOtBbNɂB

VRAMOtBbNSwizzleOtBbNȂ猳ɖ߂B

X[p[rbgZ^CBfobOC܂
*/
{
	int x,y;
	char swizzleflag = 0;
	char vramflag = 0;
	int size;
	void* buf;
	GraphicHandleCheck(gh);
	if(psm == texarray[gh].psm)return 0;
	if(psm < 0 || psm > 3 || texarray[gh].psm < 0 || texarray[gh].psm > 3)return -1;	/*ϊƕϊ̂ǂ炩4444,5551,5650,8888ȊÕtH[}bgȂ玸s*/
	size = GraphSize2DataSize(texarray[gh].pitch,texarray[gh].height,psm);
	if((buf = memalign(16,size)) == NULL)return -1;
	if(texarray[gh].flags & TEXTUREFLAGS_VRAM)
	{
		MoveGraphToDDR(gh);
		vramflag = 1;
	}
	if(texarray[gh].flags & TEXTUREFLAGS_SWIZZLED)
	{
		UnswizzleGraph(gh);
		swizzleflag = 1;
	}
	switch(texarray[gh].psm)
	{
	case GU_PSM_4444:
		goto SRC4444;
	case GU_PSM_5551:
		goto SRC5551;
	case GU_PSM_5650:
		goto SRC5650;
	case GU_PSM_8888:
		goto SRC8888;
	default:
		return -1;
	}
SRC4444:
	switch(psm)
	{
	case GU_PSM_5551:
		for(y = 0;y < texarray[gh].mv;++y)
		{
			for(x = 0;x < texarray[gh].pitch;++x)
			{
				u16 color = *(((u16*)texarray[gh].pmemory) + y * texarray[gh].pitch + x);
				color = (color & 0x8000) | ((color & 0x0f00) << 3) | ((color & 0x00f0) << 2) | ((color & 0x000f) << 1)
					| ((color & 0x0800) >> 1) | ((color & 0x0080) >> 2) | ((color & 0x0008) >> 3);
				*(((u16*)buf) + y * texarray[gh].pitch + x) = color;
			}
		}
		goto ENDPROCESS;
	case GU_PSM_5650:
		for(y = 0;y < texarray[gh].mv;++y)
		{
			for(x = 0;x < texarray[gh].pitch;++x)
			{
				u16 color = *(((u16*)texarray[gh].pmemory) + y * texarray[gh].pitch + x);
				color = ((color & 0x0f00) << 4) | ((color & 0x00f0) << 3) | ((color & 0x000f) << 1)
					| (color & 0x0800) | ((color & 0x00c0) >> 1) | ((color & 0x0008) << 1);
				*(((u16*)buf) + y * texarray[gh].pitch + x) = color;
			}
		}
		goto ENDPROCESS;
	case GU_PSM_8888:
		for(y = 0;y < texarray[gh].mv;++y)
		{
			for(x = 0;x < texarray[gh].pitch;++x)
			{
				u32 color = *(((u16*)texarray[gh].pmemory) + y * texarray[gh].pitch + x);
				color = ((color & 0x0000f000) << 16) | ((color & 0x0000f000) << 12)
					| ((color & 0x00000f00) << 12) | ((color & 0x00000f00) << 8)
					| ((color & 0x000000f0) << 8) | ((color & 0x000000f0) << 4)
					| ((color & 0x0000000f) << 4) | (color & 0x0000000f);
				*(((u32*)buf) + y * texarray[gh].pitch + x) = color;
			}
		}
		goto ENDPROCESS;
	}
SRC5551:
	switch(psm)
	{
	case GU_PSM_4444:
		for(y = 0;y < texarray[gh].mv;++y)
		{
			for(x = 0;x < texarray[gh].pitch;++x)
			{
				u16 color = *(((u16*)texarray[gh].pmemory) + y * texarray[gh].pitch + x);
				color = (color & 0x8000) | ((color & 0x8000) >> 1) | ((color & 0x8000) >> 2) | ((color & 0x8000) >> 3)
					| ((color & 0x7800) >> 3) | ((color & 0x03c0) >> 2) | ((color & 0x001e) >> 1);
				*(((u16*)buf) + y * texarray[gh].pitch + x) = color;
			}
		}
		goto ENDPROCESS;
	case GU_PSM_5650:
		for(y = 0;y < texarray[gh].mv;++y)
		{
			for(x = 0;x < texarray[gh].pitch;++x)
			{
				u16 color = *(((u32*)texarray[gh].pmemory) + y * texarray[gh].pitch + x);
				color = ((color & 0x7ef0) << 1) | (color & 0x01f)
					| ((color & 0x0200) >> 4);
				*(((u16*)buf) + y * texarray[gh].pitch + x) = color;
			}
		}
		goto ENDPROCESS;
	case GU_PSM_8888:
		for(y = 0;y < texarray[gh].mv;++y)
		{
			for(x = 0;x < texarray[gh].pitch;++x)
			{
				u32 color = *(((u16*)texarray[gh].pmemory) + y * texarray[gh].pitch + x);
				color = ((color & 0x8000) << 16) | ((color & 0x8000) << 15) | ((color & 0x8000) << 14) | ((color & 0x8000) << 13)
					 | ((color & 0x8000) << 12) | ((color & 0x8000) << 11) | ((color & 0x8000) << 10) | ((color & 0x8000) << 9)
					 | ((color & 0x7c00) << 9) | ((color & 0x03e0) << 6) | ((color & 0x001f) << 3)
					 | ((color & 0x7000) << 4) | ((color & 0x0380) << 1) | ((color & 0x001c) >> 2);
				*(((u32*)buf) + y * texarray[gh].pitch + x) = color;
			}
		}
		goto ENDPROCESS;
	}
SRC5650:
	switch(psm)
	{
	case GU_PSM_4444:
		for(y = 0;y < texarray[gh].mv;++y)
		{
			for(x = 0;x < texarray[gh].pitch;++x)
			{
				u16 color = *(((u16*)texarray[gh].pmemory) + y * texarray[gh].pitch + x);
				color = 0xf000 | ((color & 0xf000) >> 4) | ((color & 0x0780) >> 3) | ((color & 0x001e) >> 1);
				*(((u16*)buf) + y * texarray[gh].pitch + x) = color;
			}
		}
		goto ENDPROCESS;
	case GU_PSM_5551:
		for(y = 0;y < texarray[gh].mv;++y)
		{
			for(x = 0;x < texarray[gh].pitch;++x)
			{
				u16 color = *(((u16*)texarray[gh].pmemory) + y * texarray[gh].pitch + x);
				color = 0x8000 | ((color & 0xffc0) >> 1) | (color & 0x001f);
				*(((u16*)buf) + y * texarray[gh].pitch + x) = color;
			}
		}
		goto ENDPROCESS;
	case GU_PSM_8888:
		for(y = 0;y < texarray[gh].mv;++y)
		{
			for(x = 0;x < texarray[gh].pitch;++x)
			{
				u32 color = *(((u16*)texarray[gh].pmemory) + y * texarray[gh].pitch + x);
				color = 0xff000000 | ((color & 0x00008f00) << 8) | ((color & 0x07e0) << 5) | ((color & 0x0000001f) << 3)
					| ((color & 0x0000e000) << 3) | ((color & 0x00000600) >> 1) | ((color & 0x0000001c) >> 2);
				*(((u32*)buf) + y * texarray[gh].pitch + x) = color;
			}
		}
		goto ENDPROCESS;
	}
SRC8888:
	switch(psm)
	{
	case GU_PSM_4444:
		for(y = 0;y < texarray[gh].mv;++y)
		{
			for(x = 0;x < texarray[gh].pitch;++x)
			{
				u32 color = *(((u32*)texarray[gh].pmemory) + y * texarray[gh].pitch + x);
				color = ((color & 0xf0000000) >> 16) | ((color & 0x00f00000) >> 12) | ((color & 0x0000f000) >> 8) | ((color & 0x000000f0) >> 4);
				*(((u16*)buf) + y * texarray[gh].pitch + x) = (u16)(color & 0x0000ffff);
			}
		}
		goto ENDPROCESS;
	case GU_PSM_5551:
		for(y = 0;y < texarray[gh].mv;++y)
		{
			for(x = 0;x < texarray[gh].pitch;++x)
			{
				u32 color = *(((u32*)texarray[gh].pmemory) + y * texarray[gh].pitch + x);
				color = ((color & 0x80000000) >> 16) | ((color & 0x00f80000) >> 9) | ((color & 0x0000f800) >> 6) | ((color & 0x000000f8) >> 3);
				*(((u16*)buf) + y * texarray[gh].pitch + x) = (u16)(color & 0x0000ffff);
			}
		}
		goto ENDPROCESS;
	case GU_PSM_5650:
		for(y = 0;y < texarray[gh].mv;++y)
		{
			for(x = 0;x < texarray[gh].pitch;++x)
			{
				u32 color = *(((u32*)texarray[gh].pmemory) + y * texarray[gh].pitch + x);
				color = ((color & 0x00f80000) >> 8) | ((color & 0x0000fc00) >> 5) | ((color & 0x000000f8) >> 3);
				*(((u16*)buf) + y * texarray[gh].pitch + x) = (u16)(color & 0x0000ffff);
			}
		}
		goto ENDPROCESS;
	}
ENDPROCESS:
	free(texarray[gh].pmemory);
	texarray[gh].pmemory = buf;
	texarray[gh].psm = psm;

	if(swizzleflag)
	{
		SwizzleGraph(gh);
	}
	if(vramflag)
	{
		MoveGraphToVRAM(gh);
	}
	return 0;
}

//#define	DXP_NOUSE_LIBJPEG
#ifndef DXP_NOUSE_LIBJPEG

// (w jdatasrc.c ̗p)
//#include "jinclude.h"
#include "jpeglib.h"
#include "jerror.h"

// iodfǂ݂݃G[[`p\
typedef struct my_error_mgr {
	struct jpeg_error_mgr pub;	// WG[f[^

	jmp_buf setjmp_buffer;		// OWvp\
} *my_error_ptr ;

// G[ɌĂ΂֐
void my_error_exit( j_common_ptr cinfo )
{
	// cinfo->errWG[f[^̐擪AhXmy_error_mgr\̂̐擪AhXɕϊ
	my_error_ptr myerr = (my_error_ptr) cinfo->err;
	// ܂悭킩܂AƂ肠G[bZ[WW֐H
	(*cinfo->err->output_message) (cinfo);
	// [U[߂G[R[ḧʒu܂Ŕ
	longjmp( myerr->setjmp_buffer, 1 ) ;
}


// ėpf[^`̓]p\
typedef struct
{
	struct jpeg_source_mgr pub;		/* public fields */

	JOCTET *buffer;					/* start of buffer */
	boolean start_of_file;			/* have we gotten any data yet? */

	STREAMDATA *Data ;				// ėpf[^`ǂݍݏp\
	int DataSize ;					// f[^̃TCY
} my_source_general_mgr;

typedef my_source_general_mgr	*my_src_general_ptr;

#define INPUT_BUF_SIZE		(4096)	// Ɨpobt@̃TCY

// ǂݍރ\[X֐
METHODDEF(void)
init_source_general( j_decompress_ptr cinfo )
{
	my_src_general_ptr src = (my_src_general_ptr) cinfo->src;

	// t@Cǂݍ݊JñtO𗧂Ă
	src->start_of_file = TRUE;
}

// f[^obt@Ƀf[^]
METHODDEF(boolean)
fill_input_buffer_general (j_decompress_ptr cinfo)
{
	my_src_general_ptr src = (my_src_general_ptr) cinfo->src;
	size_t nbytes;

	// ]f[^̗ʂRs[
	nbytes = ( src->DataSize - STTELL( src->Data ) < INPUT_BUF_SIZE ) ?
			 src->DataSize - STTELL( src->Data ) : INPUT_BUF_SIZE ;
	if( nbytes != 0 )
	{
		STREAD( src->buffer, nbytes, 1, src->Data ) ;
	}

	// ǂݍ݂ɎsG[
	if( nbytes <= 0 )
	{
		if (src->start_of_file)	/* Treat empty input file as fatal error */
			ERREXIT(cinfo, JERR_INPUT_EMPTY);
		WARNMS(cinfo, JWRN_JPEG_EOF);

		/* Insert a fake EOI marker */
	    src->buffer[0] = (JOCTET) 0xFF;
		src->buffer[1] = (JOCTET) JPEG_EOI;
		nbytes = 2;
	}

	// ̑̏
	src->pub.next_input_byte = src->buffer;
	src->pub.bytes_in_buffer = nbytes;
	src->start_of_file = FALSE;

	return TRUE;
}

// w肳ꂽTCỸf[^XLbv鏈
METHODDEF(void)
skip_input_data_general( j_decompress_ptr cinfo, long num_bytes)
{
	my_src_general_ptr src = (my_src_general_ptr) cinfo->src;

	// f[^XLbv
	if( num_bytes > 0 )
	{
		while( num_bytes > (long) src->pub.bytes_in_buffer )
		{
			num_bytes -= (long) src->pub.bytes_in_buffer;
			(void) fill_input_buffer_general( cinfo ) ;
		}
		src->pub.next_input_byte += (size_t) num_bytes;
		src->pub.bytes_in_buffer -= (size_t) num_bytes;
	}
}

// f[^Ƃ̏
METHODDEF(void)
term_source_general( j_decompress_ptr cinfo )
{
  /* no work necessary here */
}

// ėpf[^ǂݍݏf[^ǂݍނ悤ɂۂ̐ݒs֐
GLOBAL(void)
jpeg_general_src (j_decompress_ptr cinfo, STREAMDATA *Data )
{
	my_src_general_ptr src;

	// ܂iodff[^ꎞIɊi[obt@mۂĂȂmۂ
	if (cinfo->src == NULL)
	{
		/* first time for this JPEG object? */
		cinfo->src = (struct jpeg_source_mgr *)
						(*cinfo->mem->alloc_small) ((j_common_ptr) cinfo, JPOOL_PERMANENT,
						sizeof(my_source_general_mgr));
		src = (my_src_general_ptr) cinfo->src;
		src->buffer = (JOCTET *)
					(*cinfo->mem->alloc_small) ((j_common_ptr) cinfo, JPOOL_PERMANENT,
					INPUT_BUF_SIZE * sizeof(JOCTET));
	}

	// ֐|C^ȂǂZbg
	src = (my_src_general_ptr) cinfo->src;
	src->pub.init_source			= init_source_general ;
	src->pub.fill_input_buffer		= fill_input_buffer_general ;
	src->pub.skip_input_data		= skip_input_data_general ;
	src->pub.resync_to_restart		= jpeg_resync_to_restart ; /* use default method */
	src->pub.term_source			= term_source_general ;

	src->Data = Data ;

	// ݂̃t@C|C^I[܂ł̃TCY擾
	{
		long pos ;
		pos = STTELL( src->Data ) ;
		STSEEK( src->Data, 0, STREAM_SEEKTYPE_END ) ;
		src->DataSize = STTELL( src->Data ) - pos ;
		STSEEK( src->Data, pos, STREAM_SEEKTYPE_SET ) ;
	}

	src->pub.bytes_in_buffer = 0; /* forces fill_input_buffer on first read */
	src->pub.next_input_byte = NULL; /* until buffer loaded */
}

#ifdef DX_TEST	// eXgp
extern LONGLONG time2;
#endif




extern int LoadJpegImage(const char *FileName)
{
	STREAMDATA src;
	STREAMDATA *Src = &src;
	if(SetupSTREAMDATA(FileName,Src) == -1)
	{
		return -1;
	}
	struct jpeg_decompress_struct cinfo ;
	struct my_error_mgr jerr ;
	JSAMPARRAY buffer ;
	int InPitch ;
	int i ;

	// ʏiodfG[[`̃ZbgAbv
	memset( &cinfo, 0, sizeof( cinfo ) );
	cinfo.err = jpeg_std_error(&jerr.pub);
	jerr.pub.error_exit = my_error_exit;
	if( setjmp( jerr.setjmp_buffer ) )
	{
		jpeg_destroy_decompress( &cinfo );
		STCLOSE(Src);
		return -1;
	}

#ifdef DX_TEST	// eXgp
	time2 = ST_GetNowHiPerformanceCount();
#endif
	// cinfõAP[gƏs
	jpeg_create_decompress(&cinfo);

	// ėpf[^ǂݍݏf[^ǂݍސݒs
	jpeg_general_src( &cinfo, Src ) ;

	// iodft@C̃p[^̓ǂ݂
	(void)jpeg_read_header(&cinfo, TRUE);

	// iodft@C̉𓀂̊Jn
	(void)jpeg_start_decompress(&cinfo);

	if(cinfo.output_components != 1 && cinfo.out_color_components != 3)
	{
		jpeg_destroy_decompress( &cinfo );
		STCLOSE(Src);
		return -1 ;
	}
	/*OtBbNnhB*/
	int gh = MakeGraph(cinfo.output_width,cinfo.output_height,GU_PSM_8888);
	if(gh == -1)
	{
		//G[
		jpeg_destroy_decompress( &cinfo );
		STCLOSE(Src);
		return -1 ;
	}

	// PC̃f[^oCgvZ
	InPitch = cinfo.output_width * cinfo.output_components ;

	// f[^obt@̊m
	buffer = (*cinfo.mem->alloc_sarray)
				((j_common_ptr) &cinfo, JPOOL_IMAGE, InPitch, 1 );
	
	// 摜f[^̓ǂ݂
	int row = 0;
	while( cinfo.output_scanline < cinfo.output_height && row < texarray[gh].mv)
	{
		(void) jpeg_read_scanlines(&cinfo, buffer, 1);

		// f[^o̓f[^ɕϊāA܂͂̂܂ܓ]
		for(i = 0;i < texarray[gh].mu;++i)
		{
			if(cinfo.output_components == 1)
			{/*O[XP[*/
				*((unsigned char*)(texarray[gh].pmemory) + texarray[gh].pitch * row * 4 + i * 4 + 0) = 0xff;
				*((unsigned char*)(texarray[gh].pmemory) + texarray[gh].pitch * row * 4 + i * 4 + 1) = *(buffer[0] + i);
				*((unsigned char*)(texarray[gh].pmemory) + texarray[gh].pitch * row * 4 + i * 4 + 2) = *(buffer[0] + i);
				*((unsigned char*)(texarray[gh].pmemory) + texarray[gh].pitch * row * 4 + i * 4 + 3) = *(buffer[0] + i);
			}
			else
			{/*ABGR*/
				*((unsigned char*)(texarray[gh].pmemory) + texarray[gh].pitch * row * 4 + i * 4 + 3) = 0xff;					//A
				*((unsigned char*)(texarray[gh].pmemory) + texarray[gh].pitch * row * 4 + i * 4 + 2) = *(buffer[0] + i * 3 + 2);//B
				*((unsigned char*)(texarray[gh].pmemory) + texarray[gh].pitch * row * 4 + i * 4 + 1) = *(buffer[0] + i * 3 + 1);//G
				*((unsigned char*)(texarray[gh].pmemory) + texarray[gh].pitch * row * 4 + i * 4 + 0) = *(buffer[0] + i * 3 + 0);//R
			}
		}
		++row;
	}

	// 𓀏̏I
	(void) jpeg_finish_decompress(&cinfo);
	// cinfo\̂̉
	jpeg_destroy_decompress(&cinfo);
#ifdef DX_TEST	// eXgp
	time2 = ST_GetNowHiPerformanceCount() - time2 ;
#endif

	// I
//	GraphicNormalize(texi);/*OtBbN𐳋KiẮHj*/
	STCLOSE(Src);
	return gh ;
}


#else
// iodf摜̓ǂ݂ PSP̃Cugo[W
int LoadJpegImage(const char *FileName)
{
	if(sceJpegInitMJpeg() < 0)return -1;
	if(sceJpegCreateMJpeg(512,512) < 0)
	{
		sceJpegFinishMJpeg();
		return -1;
	}
	int size = FileRead_size(FileName);
	u8* rgbabuf = (u8*)malloc(4*512*512);
	u8* databuf = (u8*)malloc(size);
	if(databuf == NULL || rgbabuf == NULL)
	{
		free(databuf);
		free(rgbabuf);
		sceJpegDeleteMJpeg();
		sceJpegFinishMJpeg();
		return -1;
	}
	int fh = FileRead_open(FileName);
	if(fh == -1)
	{
		free(databuf);
		free(rgbabuf);
		sceJpegDeleteMJpeg();
		sceJpegFinishMJpeg();
		return -1;
	}
	FileRead_read(databuf,size,fh);
	FileRead_close(fh);
	int res = sceJpegDecodeMJpeg(databuf,size,rgbabuf,0);
	free(databuf);
	sceJpegDeleteMJpeg();
	sceJpegFinishMJpeg();
	if(res < 0)
	{
		free(rgbabuf);
		return -1;
	}
	int height = res >> 16;
	int width = res & 0x0000ffff;
	int gh = MakeGraph(height,width,DXP_FMT_8888);
	if(gh == -1)
	{
		free(rgbabuf);
		return -1;
	}
	memcpy(texarray[gh].pmemory,rgbabuf,4 * height * width);
	int i;
	for(i = 0;i < height;++i)
		memcpy(((u32*)texarray[gh].pmemory) + texarray[gh].pitch * i,((u32*)rgbabuf) + 512 * i,width * 4);
	free(rgbabuf);
	return gh;
}
#endif


#ifndef DX_NON_PNGREAD

// ėpf[^ǂݍݏ̓ǂݍ݂邽߂̃f[^^
typedef struct tagPNGGENERAL
{
	STREAMDATA *Data ;
	unsigned int DataSize ;
} PNGGENERAL ;

// ėpf[^ǂݍݏf[^ǂݍރR[obN֐
static void png_general_read_data(png_structp png_ptr, png_bytep data, png_size_t length)
{
	PNGGENERAL *PGen ;

	PGen = (PNGGENERAL *)CVT_PTR(png_ptr->io_ptr) ;

	// c̃TCYȂG[
	if( PGen->DataSize - STTELL( PGen->Data ) < length )
	{
		png_error(png_ptr, "Read Error");
	}
	else
	{
		STREAD( data, length, 1, PGen->Data ) ;
	}
}

// ėpf[^ǂݍݏ̓ǂݍ݂ݒ肷֐
int png_general_read_set( png_structp png_ptr, PNGGENERAL *PGen, STREAMDATA *Data )
{
	PGen->Data = Data ;

	// ݂̃t@C|C^I[܂ł̃TCY擾
	{
		long pos ;
		pos = STTELL( PGen->Data ) ;
		STSEEK( PGen->Data, 0, STREAM_SEEKTYPE_END ) ;
		PGen->DataSize = STTELL( PGen->Data ) - pos ;
		STSEEK( PGen->Data, pos, STREAM_SEEKTYPE_SET ) ;
	}

	// R[obN֐̃Zbg
	png_set_read_fn( png_ptr, PGen, png_general_read_data ) ;

	// I
	return 0 ;
}

// omf摜̓ǂ݂
int LoadPngImage(const char *FileName)
{
//	BASEIMAGE *Image ;
	STREAMDATA src;
	STREAMDATA *Src = &src;
	if(SetupSTREAMDATA(FileName,Src) == -1)
	{
		STCLOSE(Src);
		return -1;
	}
	png_bytep *row_pointers;
	unsigned int row, rowbytes ;
	u8 Expand ;
	PNGGENERAL PGen ;
	png_structp png_ptr;
	png_infop info_ptr;
	unsigned int sig_read = 0;
	png_uint_32 width, height;
	int bit_depth, color_type, interlace_type;
	int i ;
	png_bytep BufPoint ;

	Expand = 0;

	// omfǗ̍쐬
	if( ( png_ptr = png_create_read_struct(PNG_LIBPNG_VER_STRING, NULL, NULL, NULL ) ) == NULL )
	{
		STCLOSE(Src);
		return -1 ;
	}
	// 摜\̂̍쐬
	if( ( info_ptr = png_create_info_struct( png_ptr ) ) == NULL ) 
	{
		STCLOSE(Src);
		png_destroy_read_struct(&png_ptr, (png_infopp)NULL, (png_infopp)NULL);
		return -1 ;
	}

	// G[̏ZbgAbvя
	if( setjmp( png_jmpbuf( png_ptr ) ) )
	{
		STCLOSE(Src);
		png_destroy_read_struct( &png_ptr, &info_ptr, (png_infopp)NULL );
		return -1 ;
	}

	// ėpf[^ǂݍݏǂݍޏꍇ̐ݒs
	png_general_read_set( png_ptr, &PGen, Src ) ;

	// ݒ菈S
	png_set_sig_bytes(		png_ptr, sig_read ) ;												// 悭킩疳()
	png_read_info(			png_ptr, info_ptr );												// 摜𓾂
	png_get_IHDR(			png_ptr, info_ptr, &width, &height, &bit_depth, &color_type,		// 摜̊{Xe[^X擾
							&interlace_type, NULL, NULL ) ;
	png_set_strip_16(		png_ptr ) ;															// PUrbg̉摜łWrbgŎ[悤ɐݒ
//	if( BmpFlag == TRUE )										png_set_strip_alpha( png_ptr ) ;// At@`l
	png_set_packing(		png_ptr ) ;															// PoCgȉ̃pbg摜oCgPʂœWJ悤w
	png_set_packswap(		png_ptr ) ;															// 悭킩疳

//	if( color_type == PNG_COLOR_TYPE_PALETTE )					png_set_expand( png_ptr ) ;		// pbggp摜f[^̎WJw

	// `ltpbgWrbgȉ̃O[XP[摜̏ꍇ
	// o͉摜̃sNZtH[}bgtJ[ɂ
	if( ( color_type == PNG_COLOR_TYPE_GRAY && bit_depth <= 8 ) ||
	    png_get_valid( png_ptr, info_ptr, PNG_INFO_tRNS ) )
	{
		png_set_expand( png_ptr );		
		Expand = 1 ;
	}
	png_set_gray_to_rgb(png_ptr);
	png_set_add_alpha(png_ptr,0xff,PNG_FILLER_AFTER);			/*At@񂪖ꍇ͕t*/
//	png_set_bgr(			png_ptr ) ;															// J[zqfaafqɔ]
	
	// ύXݒ𔽉f
	png_read_update_info(	png_ptr, info_ptr ) ;

	// PCɕKvȃf[^ʂ𓾂
	rowbytes = png_get_rowbytes( png_ptr, info_ptr ) ;

	// OtBbNf[^i[郁̈쐬
	{
		png_bytep BufP ;

		row_pointers = ( png_bytep * )malloc( height * sizeof( png_bytep * ) ) ;
		if( ( BufPoint = ( png_bytep )png_malloc( png_ptr, rowbytes * height ) ) == NULL )	return -1 ;
		BufP = BufPoint ;
		for (row = 0; row < height; row++, BufP += rowbytes )
			row_pointers[row] = BufP ;
	}

	// 摜f[^̓ǂݍ
	png_read_image( png_ptr, row_pointers );

	int gh;

	// Zbg
	{
		// J[Zbg
		if( color_type == PNG_COLOR_TYPE_PALETTE && Expand == 0)
		{
			//pbgJ[ł
			if(bit_depth == 8)
				gh = MakeGraph(width,height,GU_PSM_T8);
			else
				gh = MakeGraph(width,height,GU_PSM_T4);
			if(gh == -1)
			{
				//s
				free( row_pointers ) ;
				png_destroy_read_struct(&png_ptr, &info_ptr, (png_infopp)NULL);
				STCLOSE(Src);
				return -1;
			}

			//摜ۂɎg悤ɂ
			int bn = 8 / bit_depth;
			for(i = 0;i < texarray[gh].mv;++i)
				memcpy(((u8*)texarray[gh].pmemory) + texarray[gh].pitch * i / bn,row_pointers[i],texarray[gh].mu / bn);
			png_colorp SrcPalette ;
			int PaletteNum ;
			// pbg擾
			png_get_PLTE( png_ptr, info_ptr, &SrcPalette, &PaletteNum ) ;

			// pbg̐QTUȏゾꍇ͂QTUɕ␳
			if( PaletteNum < 256 ) PaletteNum = 256 ;

			for(i = 0;i < PaletteNum;++i)
			{
				texarray[gh].ppalette->data[i] = 0xff000000 |
					(((u32)SrcPalette[i].blue & 0x000000ff) << 16) |
					(((u32)SrcPalette[i].green & 0x000000ff) << 8) |
					(((u32)SrcPalette[i].red & 0x000000ff) << 0);
			}
		}
		else
		if( color_type == PNG_COLOR_TYPE_GRAY || color_type == PNG_COLOR_TYPE_GRAY_ALPHA )
		{
			//O[XP[ł
			gh = MakeGraph(width,height,GU_PSM_8888);
			if(gh == -1)
			{
				//s
				free( row_pointers ) ;
				png_destroy_read_struct(&png_ptr, &info_ptr, (png_infopp)NULL);
				STCLOSE(Src);
				return -1;
			}
			//摜ۂɎg悤ɂ
			int i;
			int bn = 8 / bit_depth;
			for(i = 0;i < texarray[gh].mv;++i)
				memcpy(((u8*)texarray[gh].pmemory) + texarray[gh].pitch * 4 * i / bn,row_pointers[i],texarray[gh].mu  * 4 / bn);
		}
		else
		{
			//tJ[ł
			gh = MakeGraph(width,height,GU_PSM_8888);
			if(gh == -1)
			{
				//s
				free( row_pointers ) ;
				png_destroy_read_struct(&png_ptr, &info_ptr, (png_infopp)NULL);
				STCLOSE(Src);
				return -1;
			}
			//摜ۂɎg悤ɂ
			int i;
			int bn = 8 / bit_depth;
			for(i = 0;i < texarray[gh].mv;++i)
				memcpy(((u8*)texarray[gh].pmemory) + texarray[gh].pitch * 4 * i / bn,row_pointers[i],texarray[gh].mu * 4 / bn);
		}
	}

	// ̉
	png_free( png_ptr, BufPoint ) ;
	free( row_pointers ) ;

	// ǂݍݏ̏I
	png_read_end(png_ptr, info_ptr);

	// ǂݍݏp\̂̔j
	png_destroy_read_struct(&png_ptr, &info_ptr, (png_infopp)NULL);

	STCLOSE(Src);
	// I
	sceKernelDcacheWritebackAll();//S񂶂Ⴆ
	return gh;
}
#else
int LoadPngImage(const char *FileName)
{
	return -1;
}

#endif // DX_NON_PNGREAD
