/*
*	DXCuPortable	R[hϊ	Ver1.00
*		FJ
*
*	l	FUnicodesjis𑊌ݕϊ܂
*	L̖ڈ͂悻30KBytełB
*/


#include "dxlibp.h"
#define TABLE_MAX	7070

static const u16 table[TABLE_MAX][2];
int sjis2unicode(u16 sjis,u16 *punicode);
int unicode2sjis(u16 unicode,u16 *psjis);
int IsSjisZenkaku(int c);
int unicodestr2sjisstr(const u16 *unis,char *sjiss);
int sjisstr2unicodestr(const char *sjiss,u16 *unis);

int unicodestr2sjisstr(const u16 *unis,char *sjiss)
{
	int i;
	u16 tmp;
	char *pc = sjiss;
	for(i = 0;unis[i] != 0;++i)
	{
		if(unicode2sjis(unis[i],&tmp) != -1)
		{
			if(IsSjisZenkaku(tmp >> 8))
			{
				*pc++ = (tmp >> 8) & 0xff;
				*pc++ = tmp & 0xff;
			}
			else
			{
				*pc++ = (u8)(0xff & tmp);
			}
		}
	}
	*++pc = '\0';
	return i;
}

int sjisstr2unicodestr(const char *sjiss,u16 *unis)
{
	int i;
	u16 tmp;
	u16 *pc = unis;
	for(i = 0;sjiss[i] != '\0';++i)
	{
		if(IsSjisZenkaku(sjiss[i]))
		{
			//2oCg
			tmp = ((sjiss[i] << 8) & 0xFF00) + (sjiss[i + 1] & 0xFF);
			if(sjis2unicode(tmp,&tmp) == -1)
			{
				++i;
				continue;
			}
			*pc++ = tmp;
			++i;
		}
		else
		{
			//1oCg
			tmp = sjiss[i] & 0x00ff;
			if(sjis2unicode(tmp,&tmp) == -1)continue;
			*pc++ = tmp;
		}
	}
	*pc = 0;
	return pc - unis;
}


int IsSjisZenkaku(int c)
{
	c &= 0xff;
	return ((c >= 0x81) && (c < 0xa0)) || ((c >= 0xe0) && (c <= 0xfd));
}

int sjis2unicode(u16 sjis,u16 *punicode)
{
	if(punicode == NULL)return -1;
	int i;
	for(i = 0;i < 7070;++i)if(table[i][0] == sjis)break;
	if(i >= TABLE_MAX)return -1;
	*punicode = table[i][1];
	return 0;
}

int unicode2sjis(u16 unicode,u16 *psjis)
{
	if(psjis == NULL)return -1;
	int i;
	for(i = 0;i < TABLE_MAX;++i)if(table[i][1] == unicode)break;
	if(i >= TABLE_MAX)return -1;
	*psjis = table[i][0];
	return 0;
}



//SJISUnicodȇΉ\B[
//table[n][];ŃANZXB0ȂSJISA1ȂUnicode
//{͍͂sV悭Ȃ񂾂ǁc΂
static const u16 table[TABLE_MAX][2] = 
{
0x0000,0x0000,
0x0001,0x0001,
0x0002,0x0002,
0x0003,0x0003,
0x0004,0x0004,
0x0005,0x0005,
0x0006,0x0006,
0x0007,0x0007,
0x0008,0x0008,
0x0009,0x0009,
0x000a,0x000A,
0x000b,0x000B,
0x000c,0x000C,
0x000d,0x000D,
0x000e,0x000E,
0x000f,0x000F,
0x0010,0x0010,
0x0011,0x0011,
0x0012,0x0012,
0x0013,0x0013,
0x0014,0x0014,
0x0015,0x0015,
0x0016,0x0016,
0x0017,0x0017,
0x0018,0x0018,
0x0019,0x0019,
0x001a,0x001A,
0x001b,0x001B,
0x001c,0x001C,
0x001d,0x001D,
0x001e,0x001E,
0x001f,0x001F,
0x0020,0x0020,
0x0021,0x0021,
0x0022,0x0022,
0x0023,0x0023,
0x0024,0x0024,
0x0025,0x0025,
0x0026,0x0026,
0x0027,0x0027,
0x0028,0x0028,
0x0029,0x0029,
0x002a,0x002A,
0x002b,0x002B,
0x002c,0x002C,
0x002d,0x002D,
0x002e,0x002E,
0x002f,0x002F,
0x0030,0x0030,
0x0031,0x0031,
0x0032,0x0032,
0x0033,0x0033,
0x0034,0x0034,
0x0035,0x0035,
0x0036,0x0036,
0x0037,0x0037,
0x0038,0x0038,
0x0039,0x0039,
0x003a,0x003A,
0x003b,0x003B,
0x003c,0x003C,
0x003d,0x003D,
0x003e,0x003E,
0x003f,0x003F,
0x0040,0x0040,
0x0041,0x0041,
0x0042,0x0042,
0x0043,0x0043,
0x0044,0x0044,
0x0045,0x0045,
0x0046,0x0046,
0x0047,0x0047,
0x0048,0x0048,
0x0049,0x0049,
0x004a,0x004A,
0x004b,0x004B,
0x004c,0x004C,
0x004d,0x004D,
0x004e,0x004E,
0x004f,0x004F,
0x0050,0x0050,
0x0051,0x0051,
0x0052,0x0052,
0x0053,0x0053,
0x0054,0x0054,
0x0055,0x0055,
0x0056,0x0056,
0x0057,0x0057,
0x0058,0x0058,
0x0059,0x0059,
0x005a,0x005A,
0x005b,0x005B,
0x005c,0x005C,
0x005d,0x005D,
0x005e,0x005E,
0x005f,0x005F,
0x0060,0x0060,
0x0061,0x0061,
0x0062,0x0062,
0x0063,0x0063,
0x0064,0x0064,
0x0065,0x0065,
0x0066,0x0066,
0x0067,0x0067,
0x0068,0x0068,
0x0069,0x0069,
0x006a,0x006A,
0x006b,0x006B,
0x006c,0x006C,
0x006d,0x006D,
0x006e,0x006E,
0x006f,0x006F,
0x0070,0x0070,
0x0071,0x0071,
0x0072,0x0072,
0x0073,0x0073,
0x0074,0x0074,
0x0075,0x0075,
0x0076,0x0076,
0x0077,0x0077,
0x0078,0x0078,
0x0079,0x0079,
0x007a,0x007A,
0x007b,0x007B,
0x007c,0x007C,
0x007d,0x007D,
0x007e,0x007E,
0x007f,0x007F,
0x00a1,0xFF61,
0x00a2,0xFF62,
0x00a3,0xFF63,
0x00a4,0xFF64,
0x00a5,0xFF65,
0x00a6,0xFF66,
0x00a7,0xFF67,
0x00a8,0xFF68,
0x00a9,0xFF69,
0x00aa,0xFF6A,
0x00ab,0xFF6B,
0x00ac,0xFF6C,
0x00ad,0xFF6D,
0x00ae,0xFF6E,
0x00af,0xFF6F,
0x00b0,0xFF70,
0x00b1,0xFF71,
0x00b2,0xFF72,
0x00b3,0xFF73,
0x00b4,0xFF74,
0x00b5,0xFF75,
0x00b6,0xFF76,
0x00b7,0xFF77,
0x00b8,0xFF78,
0x00b9,0xFF79,
0x00ba,0xFF7A,
0x00bb,0xFF7B,
0x00bc,0xFF7C,
0x00bd,0xFF7D,
0x00be,0xFF7E,
0x00bf,0xFF7F,
0x00c0,0xFF80,
0x00c1,0xFF81,
0x00c2,0xFF82,
0x00c3,0xFF83,
0x00c4,0xFF84,
0x00c5,0xFF85,
0x00c6,0xFF86,
0x00c7,0xFF87,
0x00c8,0xFF88,
0x00c9,0xFF89,
0x00ca,0xFF8A,
0x00cb,0xFF8B,
0x00cc,0xFF8C,
0x00cd,0xFF8D,
0x00ce,0xFF8E,
0x00cf,0xFF8F,
0x00d0,0xFF90,
0x00d1,0xFF91,
0x00d2,0xFF92,
0x00d3,0xFF93,
0x00d4,0xFF94,
0x00d5,0xFF95,
0x00d6,0xFF96,
0x00d7,0xFF97,
0x00d8,0xFF98,
0x00d9,0xFF99,
0x00da,0xFF9A,
0x00db,0xFF9B,
0x00dc,0xFF9C,
0x00dd,0xFF9D,
0x00de,0xFF9E,
0x00df,0xFF9F,
0x8140,0x3000,
0x8141,0x3001,
0x8142,0x3002,
0x8143,0xFF0C,
0x8144,0xFF0E,
0x8145,0x30FB,
0x8146,0xFF1A,
0x8147,0xFF1B,
0x8148,0xFF1F,
0x8149,0xFF01,
0x814a,0x309B,
0x814b,0x309C,
0x814c,0x00B4,
0x814d,0xFF40,
0x814e,0x00A8,
0x814f,0xFF3E,
0x8150,0xFFE3,
0x8151,0xFF3F,
0x8152,0x30FD,
0x8153,0x30FE,
0x8154,0x309D,
0x8155,0x309E,
0x8156,0x3003,
0x8157,0x4EDD,
0x8158,0x3005,
0x8159,0x3006,
0x815a,0x3007,
0x815b,0x30FC,
0x815c,0x2014,
0x815d,0x2010,
0x815e,0xFF0F,
0x815f,0xFF3C,
0x8160,0x301C,
0x8161,0x2016,
0x8162,0xFF5C,
0x8163,0x2026,
0x8164,0x2025,
0x8165,0x2018,
0x8166,0x2019,
0x8167,0x201C,
0x8168,0x201D,
0x8169,0xFF08,
0x816a,0xFF09,
0x816b,0x3014,
0x816c,0x3015,
0x816d,0xFF3B,
0x816e,0xFF3D,
0x816f,0xFF5B,
0x8170,0xFF5D,
0x8171,0x3008,
0x8172,0x3009,
0x8173,0x300A,
0x8174,0x300B,
0x8175,0x300C,
0x8176,0x300D,
0x8177,0x300E,
0x8178,0x300F,
0x8179,0x3010,
0x817a,0x3011,
0x817b,0xFF0B,
0x817c,0x2212,
0x817d,0x00B1,
0x817e,0x00D7,
0x817f,0x00F7,
0x8181,0xFF1D,
0x8182,0x2260,
0x8183,0xFF1C,
0x8184,0xFF1E,
0x8185,0x2266,
0x8186,0x2267,
0x8187,0x221E,
0x8188,0x2234,
0x8189,0x2642,
0x818a,0x2640,
0x818b,0x00B0,
0x818c,0x2032,
0x818d,0x2033,
0x818e,0x2103,
0x818f,0xFFE5,
0x8190,0xFF04,
0x8191,0x00A2,
0x8192,0x00A3,
0x8193,0xFF05,
0x8194,0xFF03,
0x8195,0xFF06,
0x8196,0xFF0A,
0x8197,0xFF20,
0x8198,0x00A7,
0x8199,0x2606,
0x819a,0x2605,
0x819b,0x25CB,
0x819c,0x25CF,
0x819d,0x25CE,
0x819e,0x25C7,
0x819f,0x25C6,
0x81a0,0x25A1,
0x81a1,0x25A0,
0x81a2,0x25B3,
0x81a3,0x25B2,
0x81a4,0x25BD,
0x81a5,0x25BC,
0x81a6,0x203B,
0x81a7,0x3012,
0x81a8,0x2192,
0x81a9,0x2190,
0x81aa,0x2191,
0x81ab,0x2193,
0x81ac,0x3013,
0x81b8,0x2208,
0x81b9,0x220B,
0x81ba,0x2286,
0x81bb,0x2287,
0x81bc,0x2282,
0x81bd,0x2283,
0x81be,0x222A,
0x81bf,0x2229,
0x81c8,0x2227,
0x81c9,0x2228,
0x81ca,0x00AC,
0x81cb,0x21D2,
0x81cc,0x21D4,
0x81cd,0x2200,
0x81ce,0x2203,
0x81da,0x2220,
0x81db,0x22A5,
0x81dc,0x2312,
0x81dd,0x2202,
0x81de,0x2207,
0x81df,0x2261,
0x81e0,0x2252,
0x81e1,0x226A,
0x81e2,0x226B,
0x81e3,0x221A,
0x81e4,0x223D,
0x81e5,0x221D,
0x81e6,0x2235,
0x81e7,0x222B,
0x81e8,0x222C,
0x81f0,0x212B,
0x81f1,0x2030,
0x81f2,0x266F,
0x81f3,0x266D,
0x81f4,0x266A,
0x81f5,0x2020,
0x81f6,0x2021,
0x81f7,0x00B6,
0x81fc,0x25EF,
0x824f,0xFF10,
0x8250,0xFF11,
0x8251,0xFF12,
0x8252,0xFF13,
0x8253,0xFF14,
0x8254,0xFF15,
0x8255,0xFF16,
0x8256,0xFF17,
0x8257,0xFF18,
0x8258,0xFF19,
0x8260,0xFF21,
0x8261,0xFF22,
0x8262,0xFF23,
0x8263,0xFF24,
0x8264,0xFF25,
0x8265,0xFF26,
0x8266,0xFF27,
0x8267,0xFF28,
0x8268,0xFF29,
0x8269,0xFF2A,
0x826a,0xFF2B,
0x826b,0xFF2C,
0x826c,0xFF2D,
0x826d,0xFF2E,
0x826e,0xFF2F,
0x826f,0xFF30,
0x8270,0xFF31,
0x8271,0xFF32,
0x8272,0xFF33,
0x8273,0xFF34,
0x8274,0xFF35,
0x8275,0xFF36,
0x8276,0xFF37,
0x8277,0xFF38,
0x8278,0xFF39,
0x8279,0xFF3A,
0x8281,0xFF41,
0x8282,0xFF42,
0x8283,0xFF43,
0x8284,0xFF44,
0x8285,0xFF45,
0x8286,0xFF46,
0x8287,0xFF47,
0x8288,0xFF48,
0x8289,0xFF49,
0x828a,0xFF4A,
0x828b,0xFF4B,
0x828c,0xFF4C,
0x828d,0xFF4D,
0x828e,0xFF4E,
0x828f,0xFF4F,
0x8290,0xFF50,
0x8291,0xFF51,
0x8292,0xFF52,
0x8293,0xFF53,
0x8294,0xFF54,
0x8295,0xFF55,
0x8296,0xFF56,
0x8297,0xFF57,
0x8298,0xFF58,
0x8299,0xFF59,
0x829a,0xFF5A,
0x829f,0x3041,
0x82a0,0x3042,
0x82a1,0x3043,
0x82a2,0x3044,
0x82a3,0x3045,
0x82a4,0x3046,
0x82a5,0x3047,
0x82a6,0x3048,
0x82a7,0x3049,
0x82a8,0x304A,
0x82a9,0x304B,
0x82aa,0x304C,
0x82ab,0x304D,
0x82ac,0x304E,
0x82ad,0x304F,
0x82ae,0x3050,
0x82af,0x3051,
0x82b0,0x3052,
0x82b1,0x3053,
0x82b2,0x3054,
0x82b3,0x3055,
0x82b4,0x3056,
0x82b5,0x3057,
0x82b6,0x3058,
0x82b7,0x3059,
0x82b8,0x305A,
0x82b9,0x305B,
0x82ba,0x305C,
0x82bb,0x305D,
0x82bc,0x305E,
0x82bd,0x305F,
0x82be,0x3060,
0x82bf,0x3061,
0x82c0,0x3062,
0x82c1,0x3063,
0x82c2,0x3064,
0x82c3,0x3065,
0x82c4,0x3066,
0x82c5,0x3067,
0x82c6,0x3068,
0x82c7,0x3069,
0x82c8,0x306A,
0x82c9,0x306B,
0x82ca,0x306C,
0x82cb,0x306D,
0x82cc,0x306E,
0x82cd,0x306F,
0x82ce,0x3070,
0x82cf,0x3071,
0x82d0,0x3072,
0x82d1,0x3073,
0x82d2,0x3074,
0x82d3,0x3075,
0x82d4,0x3076,
0x82d5,0x3077,
0x82d6,0x3078,
0x82d7,0x3079,
0x82d8,0x307A,
0x82d9,0x307B,
0x82da,0x307C,
0x82db,0x307D,
0x82dc,0x307E,
0x82dd,0x307F,
0x82de,0x3080,
0x82df,0x3081,
0x82e0,0x3082,
0x82e1,0x3083,
0x82e2,0x3084,
0x82e3,0x3085,
0x82e4,0x3086,
0x82e5,0x3087,
0x82e6,0x3088,
0x82e7,0x3089,
0x82e8,0x308A,
0x82e9,0x308B,
0x82ea,0x308C,
0x82eb,0x308D,
0x82ec,0x308E,
0x82ed,0x308F,
0x82ee,0x3090,
0x82ef,0x3091,
0x82f0,0x3092,
0x82f1,0x3093,
0x8340,0x30A1,
0x8341,0x30A2,
0x8342,0x30A3,
0x8343,0x30A4,
0x8344,0x30A5,
0x8345,0x30A6,
0x8346,0x30A7,
0x8347,0x30A8,
0x8348,0x30A9,
0x8349,0x30AA,
0x834a,0x30AB,
0x834b,0x30AC,
0x834c,0x30AD,
0x834d,0x30AE,
0x834e,0x30AF,
0x834f,0x30B0,
0x8350,0x30B1,
0x8351,0x30B2,
0x8352,0x30B3,
0x8353,0x30B4,
0x8354,0x30B5,
0x8355,0x30B6,
0x8356,0x30B7,
0x8357,0x30B8,
0x8358,0x30B9,
0x8359,0x30BA,
0x835a,0x30BB,
0x835b,0x30BC,
0x835c,0x30BD,
0x835d,0x30BE,
0x835e,0x30BF,
0x835f,0x30C0,
0x8360,0x30C1,
0x8361,0x30C2,
0x8362,0x30C3,
0x8363,0x30C4,
0x8364,0x30C5,
0x8365,0x30C6,
0x8366,0x30C7,
0x8367,0x30C8,
0x8368,0x30C9,
0x8369,0x30CA,
0x836a,0x30CB,
0x836b,0x30CC,
0x836c,0x30CD,
0x836d,0x30CE,
0x836e,0x30CF,
0x836f,0x30D0,
0x8370,0x30D1,
0x8371,0x30D2,
0x8372,0x30D3,
0x8373,0x30D4,
0x8374,0x30D5,
0x8375,0x30D6,
0x8376,0x30D7,
0x8377,0x30D8,
0x8378,0x30D9,
0x8379,0x30DA,
0x837a,0x30DB,
0x837b,0x30DC,
0x837c,0x30DD,
0x837d,0x30DE,
0x837e,0x30DF,
0x837f,0x30E0,
0x8381,0x30E1,
0x8382,0x30E2,
0x8383,0x30E3,
0x8384,0x30E4,
0x8385,0x30E5,
0x8386,0x30E6,
0x8387,0x30E7,
0x8388,0x30E8,
0x8389,0x30E9,
0x838a,0x30EA,
0x838b,0x30EB,
0x838c,0x30EC,
0x838d,0x30ED,
0x838e,0x30EE,
0x838f,0x30EF,
0x8390,0x30F0,
0x8391,0x30F1,
0x8392,0x30F2,
0x8393,0x30F3,
0x8394,0x30F4,
0x8395,0x30F5,
0x8396,0x30F6,
0x839f,0x0391,
0x83a0,0x0392,
0x83a1,0x0393,
0x83a2,0x0394,
0x83a3,0x0395,
0x83a4,0x0396,
0x83a5,0x0397,
0x83a6,0x0398,
0x83a7,0x0399,
0x83a8,0x039A,
0x83a9,0x039B,
0x83aa,0x039C,
0x83ab,0x039D,
0x83ac,0x039E,
0x83ad,0x039F,
0x83ae,0x03A0,
0x83af,0x03A1,
0x83b0,0x03A3,
0x83b1,0x03A4,
0x83b2,0x03A5,
0x83b3,0x03A6,
0x83b4,0x03A7,
0x83b5,0x03A8,
0x83b6,0x03A9,
0x83bf,0x03B1,
0x83c0,0x03B2,
0x83c1,0x03B3,
0x83c2,0x03B4,
0x83c3,0x03B5,
0x83c4,0x03B6,
0x83c5,0x03B7,
0x83c6,0x03B8,
0x83c7,0x03B9,
0x83c8,0x03BA,
0x83c9,0x03BB,
0x83ca,0x03BC,
0x83cb,0x03BD,
0x83cc,0x03BE,
0x83cd,0x03BF,
0x83ce,0x03C0,
0x83cf,0x03C1,
0x83d0,0x03C3,
0x83d1,0x03C4,
0x83d2,0x03C5,
0x83d3,0x03C6,
0x83d4,0x03C7,
0x83d5,0x03C8,
0x83d6,0x03C9,
0x8440,0x0410,
0x8441,0x0411,
0x8442,0x0412,
0x8443,0x0413,
0x8444,0x0414,
0x8445,0x0415,
0x8446,0x0401,
0x8447,0x0416,
0x8448,0x0417,
0x8449,0x0418,
0x844a,0x0419,
0x844b,0x041A,
0x844c,0x041B,
0x844d,0x041C,
0x844e,0x041D,
0x844f,0x041E,
0x8450,0x041F,
0x8451,0x0420,
0x8452,0x0421,
0x8453,0x0422,
0x8454,0x0423,
0x8455,0x0424,
0x8456,0x0425,
0x8457,0x0426,
0x8458,0x0427,
0x8459,0x0428,
0x845a,0x0429,
0x845b,0x042A,
0x845c,0x042B,
0x845d,0x042C,
0x845e,0x042D,
0x845f,0x042E,
0x8460,0x042F,
0x8470,0x0430,
0x8471,0x0431,
0x8472,0x0432,
0x8473,0x0433,
0x8474,0x0434,
0x8475,0x0435,
0x8476,0x0451,
0x8477,0x0436,
0x8478,0x0437,
0x8479,0x0438,
0x847a,0x0439,
0x847b,0x043A,
0x847c,0x043B,
0x847d,0x043C,
0x847e,0x043D,
0x847f,0x043E,
0x8481,0x043F,
0x8482,0x0440,
0x8483,0x0441,
0x8484,0x0442,
0x8485,0x0443,
0x8486,0x0444,
0x8487,0x0445,
0x8488,0x0446,
0x8489,0x0447,
0x848a,0x0448,
0x848b,0x0449,
0x848c,0x044A,
0x848d,0x044B,
0x848e,0x044C,
0x848f,0x044D,
0x8490,0x044E,
0x8491,0x044F,
0x849f,0x2500,
0x84a0,0x2502,
0x84a1,0x250C,
0x84a2,0x2510,
0x84a3,0x2518,
0x84a4,0x2514,
0x84a5,0x251C,
0x84a6,0x252C,
0x84a7,0x2524,
0x84a8,0x2534,
0x84a9,0x253C,
0x84aa,0x2501,
0x84ab,0x2503,
0x84ac,0x250F,
0x84ad,0x2513,
0x84ae,0x251B,
0x84af,0x2517,
0x84b0,0x2523,
0x84b1,0x2533,
0x84b2,0x252B,
0x84b3,0x253B,
0x84b4,0x254B,
0x84b5,0x2520,
0x84b6,0x252F,
0x84b7,0x2528,
0x84b8,0x2537,
0x84b9,0x253F,
0x84ba,0x251D,
0x84bb,0x2530,
0x84bc,0x2525,
0x84bd,0x2538,
0x84be,0x2542,
0x889f,0x4E9C,
0x88a0,0x5516,
0x88a1,0x5A03,
0x88a2,0x963F,
0x88a3,0x54C0,
0x88a4,0x611B,
0x88a5,0x6328,
0x88a6,0x59F6,
0x88a7,0x9022,
0x88a8,0x8475,
0x88a9,0x831C,
0x88aa,0x7A50,
0x88ab,0x60AA,
0x88ac,0x63E1,
0x88ad,0x6E25,
0x88ae,0x65ED,
0x88af,0x8466,
0x88b0,0x82A6,
0x88b1,0x9BF5,
0x88b2,0x6893,
0x88b3,0x5727,
0x88b4,0x65A1,
0x88b5,0x6271,
0x88b6,0x5B9B,
0x88b7,0x59D0,
0x88b8,0x867B,
0x88b9,0x98F4,
0x88ba,0x7D62,
0x88bb,0x7DBE,
0x88bc,0x9B8E,
0x88bd,0x6216,
0x88be,0x7C9F,
0x88bf,0x88B7,
0x88c0,0x5B89,
0x88c1,0x5EB5,
0x88c2,0x6309,
0x88c3,0x6697,
0x88c4,0x6848,
0x88c5,0x95C7,
0x88c6,0x978D,
0x88c7,0x674F,
0x88c8,0x4EE5,
0x88c9,0x4F0A,
0x88ca,0x4F4D,
0x88cb,0x4F9D,
0x88cc,0x5049,
0x88cd,0x56F2,
0x88ce,0x5937,
0x88cf,0x59D4,
0x88d0,0x5A01,
0x88d1,0x5C09,
0x88d2,0x60DF,
0x88d3,0x610F,
0x88d4,0x6170,
0x88d5,0x6613,
0x88d6,0x6905,
0x88d7,0x70BA,
0x88d8,0x754F,
0x88d9,0x7570,
0x88da,0x79FB,
0x88db,0x7DAD,
0x88dc,0x7DEF,
0x88dd,0x80C3,
0x88de,0x840E,
0x88df,0x8863,
0x88e0,0x8B02,
0x88e1,0x9055,
0x88e2,0x907A,
0x88e3,0x533B,
0x88e4,0x4E95,
0x88e5,0x4EA5,
0x88e6,0x57DF,
0x88e7,0x80B2,
0x88e8,0x90C1,
0x88e9,0x78EF,
0x88ea,0x4E00,
0x88eb,0x58F1,
0x88ec,0x6EA2,
0x88ed,0x9038,
0x88ee,0x7A32,
0x88ef,0x8328,
0x88f0,0x828B,
0x88f1,0x9C2F,
0x88f2,0x5141,
0x88f3,0x5370,
0x88f4,0x54BD,
0x88f5,0x54E1,
0x88f6,0x56E0,
0x88f7,0x59FB,
0x88f8,0x5F15,
0x88f9,0x98F2,
0x88fa,0x6DEB,
0x88fb,0x80E4,
0x88fc,0x852D,
0x8940,0x9662,
0x8941,0x9670,
0x8942,0x96A0,
0x8943,0x97FB,
0x8944,0x540B,
0x8945,0x53F3,
0x8946,0x5B87,
0x8947,0x70CF,
0x8948,0x7FBD,
0x8949,0x8FC2,
0x894a,0x96E8,
0x894b,0x536F,
0x894c,0x9D5C,
0x894d,0x7ABA,
0x894e,0x4E11,
0x894f,0x7893,
0x8950,0x81FC,
0x8951,0x6E26,
0x8952,0x5618,
0x8953,0x5504,
0x8954,0x6B1D,
0x8955,0x851A,
0x8956,0x9C3B,
0x8957,0x59E5,
0x8958,0x53A9,
0x8959,0x6D66,
0x895a,0x74DC,
0x895b,0x958F,
0x895c,0x5642,
0x895d,0x4E91,
0x895e,0x904B,
0x895f,0x96F2,
0x8960,0x834F,
0x8961,0x990C,
0x8962,0x53E1,
0x8963,0x55B6,
0x8964,0x5B30,
0x8965,0x5F71,
0x8966,0x6620,
0x8967,0x66F3,
0x8968,0x6804,
0x8969,0x6C38,
0x896a,0x6CF3,
0x896b,0x6D29,
0x896c,0x745B,
0x896d,0x76C8,
0x896e,0x7A4E,
0x896f,0x9834,
0x8970,0x82F1,
0x8971,0x885B,
0x8972,0x8A60,
0x8973,0x92ED,
0x8974,0x6DB2,
0x8975,0x75AB,
0x8976,0x76CA,
0x8977,0x99C5,
0x8978,0x60A6,
0x8979,0x8B01,
0x897a,0x8D8A,
0x897b,0x95B2,
0x897c,0x698E,
0x897d,0x53AD,
0x897e,0x5186,
0x897f,0x5712,
0x8981,0x5830,
0x8982,0x5944,
0x8983,0x5BB4,
0x8984,0x5EF6,
0x8985,0x6028,
0x8986,0x63A9,
0x8987,0x63F4,
0x8988,0x6CBF,
0x8989,0x6F14,
0x898a,0x708E,
0x898b,0x7114,
0x898c,0x7159,
0x898d,0x71D5,
0x898e,0x733F,
0x898f,0x7E01,
0x8990,0x8276,
0x8991,0x82D1,
0x8992,0x8597,
0x8993,0x9060,
0x8994,0x925B,
0x8995,0x9D1B,
0x8996,0x5869,
0x8997,0x65BC,
0x8998,0x6C5A,
0x8999,0x7525,
0x899a,0x51F9,
0x899b,0x592E,
0x899c,0x5965,
0x899d,0x5F80,
0x899e,0x5FDC,
0x899f,0x62BC,
0x89a0,0x65FA,
0x89a1,0x6A2A,
0x89a2,0x6B27,
0x89a3,0x6BB4,
0x89a4,0x738B,
0x89a5,0x7FC1,
0x89a6,0x8956,
0x89a7,0x9D2C,
0x89a8,0x9D0E,
0x89a9,0x9EC4,
0x89aa,0x5CA1,
0x89ab,0x6C96,
0x89ac,0x837B,
0x89ad,0x5104,
0x89ae,0x5C4B,
0x89af,0x61B6,
0x89b0,0x81C6,
0x89b1,0x6876,
0x89b2,0x7261,
0x89b3,0x4E59,
0x89b4,0x4FFA,
0x89b5,0x5378,
0x89b6,0x6069,
0x89b7,0x6E29,
0x89b8,0x7A4F,
0x89b9,0x97F3,
0x89ba,0x4E0B,
0x89bb,0x5316,
0x89bc,0x4EEE,
0x89bd,0x4F55,
0x89be,0x4F3D,
0x89bf,0x4FA1,
0x89c0,0x4F73,
0x89c1,0x52A0,
0x89c2,0x53EF,
0x89c3,0x5609,
0x89c4,0x590F,
0x89c5,0x5AC1,
0x89c6,0x5BB6,
0x89c7,0x5BE1,
0x89c8,0x79D1,
0x89c9,0x6687,
0x89ca,0x679C,
0x89cb,0x67B6,
0x89cc,0x6B4C,
0x89cd,0x6CB3,
0x89ce,0x706B,
0x89cf,0x73C2,
0x89d0,0x798D,
0x89d1,0x79BE,
0x89d2,0x7A3C,
0x89d3,0x7B87,
0x89d4,0x82B1,
0x89d5,0x82DB,
0x89d6,0x8304,
0x89d7,0x8377,
0x89d8,0x83EF,
0x89d9,0x83D3,
0x89da,0x8766,
0x89db,0x8AB2,
0x89dc,0x5629,
0x89dd,0x8CA8,
0x89de,0x8FE6,
0x89df,0x904E,
0x89e0,0x971E,
0x89e1,0x868A,
0x89e2,0x4FC4,
0x89e3,0x5CE8,
0x89e4,0x6211,
0x89e5,0x7259,
0x89e6,0x753B,
0x89e7,0x81E5,
0x89e8,0x82BD,
0x89e9,0x86FE,
0x89ea,0x8CC0,
0x89eb,0x96C5,
0x89ec,0x9913,
0x89ed,0x99D5,
0x89ee,0x4ECB,
0x89ef,0x4F1A,
0x89f0,0x89E3,
0x89f1,0x56DE,
0x89f2,0x584A,
0x89f3,0x58CA,
0x89f4,0x5EFB,
0x89f5,0x5FEB,
0x89f6,0x602A,
0x89f7,0x6094,
0x89f8,0x6062,
0x89f9,0x61D0,
0x89fa,0x6212,
0x89fb,0x62D0,
0x89fc,0x6539,
0x8a40,0x9B41,
0x8a41,0x6666,
0x8a42,0x68B0,
0x8a43,0x6D77,
0x8a44,0x7070,
0x8a45,0x754C,
0x8a46,0x7686,
0x8a47,0x7D75,
0x8a48,0x82A5,
0x8a49,0x87F9,
0x8a4a,0x958B,
0x8a4b,0x968E,
0x8a4c,0x8C9D,
0x8a4d,0x51F1,
0x8a4e,0x52BE,
0x8a4f,0x5916,
0x8a50,0x54B3,
0x8a51,0x5BB3,
0x8a52,0x5D16,
0x8a53,0x6168,
0x8a54,0x6982,
0x8a55,0x6DAF,
0x8a56,0x788D,
0x8a57,0x84CB,
0x8a58,0x8857,
0x8a59,0x8A72,
0x8a5a,0x93A7,
0x8a5b,0x9AB8,
0x8a5c,0x6D6C,
0x8a5d,0x99A8,
0x8a5e,0x86D9,
0x8a5f,0x57A3,
0x8a60,0x67FF,
0x8a61,0x86CE,
0x8a62,0x920E,
0x8a63,0x5283,
0x8a64,0x5687,
0x8a65,0x5404,
0x8a66,0x5ED3,
0x8a67,0x62E1,
0x8a68,0x64B9,
0x8a69,0x683C,
0x8a6a,0x6838,
0x8a6b,0x6BBB,
0x8a6c,0x7372,
0x8a6d,0x78BA,
0x8a6e,0x7A6B,
0x8a6f,0x899A,
0x8a70,0x89D2,
0x8a71,0x8D6B,
0x8a72,0x8F03,
0x8a73,0x90ED,
0x8a74,0x95A3,
0x8a75,0x9694,
0x8a76,0x9769,
0x8a77,0x5B66,
0x8a78,0x5CB3,
0x8a79,0x697D,
0x8a7a,0x984D,
0x8a7b,0x984E,
0x8a7c,0x639B,
0x8a7d,0x7B20,
0x8a7e,0x6A2B,
0x8a7f,0x6A7F,
0x8a81,0x68B6,
0x8a82,0x9C0D,
0x8a83,0x6F5F,
0x8a84,0x5272,
0x8a85,0x559D,
0x8a86,0x6070,
0x8a87,0x62EC,
0x8a88,0x6D3B,
0x8a89,0x6E07,
0x8a8a,0x6ED1,
0x8a8b,0x845B,
0x8a8c,0x8910,
0x8a8d,0x8F44,
0x8a8e,0x4E14,
0x8a8f,0x9C39,
0x8a90,0x53F6,
0x8a91,0x691B,
0x8a92,0x6A3A,
0x8a93,0x9784,
0x8a94,0x682A,
0x8a95,0x515C,
0x8a96,0x7AC3,
0x8a97,0x84B2,
0x8a98,0x91DC,
0x8a99,0x938C,
0x8a9a,0x565B,
0x8a9b,0x9D28,
0x8a9c,0x6822,
0x8a9d,0x8305,
0x8a9e,0x8431,
0x8a9f,0x7CA5,
0x8aa0,0x5208,
0x8aa1,0x82C5,
0x8aa2,0x74E6,
0x8aa3,0x4E7E,
0x8aa4,0x4F83,
0x8aa5,0x51A0,
0x8aa6,0x5BD2,
0x8aa7,0x520A,
0x8aa8,0x52D8,
0x8aa9,0x52E7,
0x8aaa,0x5DFB,
0x8aab,0x559A,
0x8aac,0x582A,
0x8aad,0x59E6,
0x8aae,0x5B8C,
0x8aaf,0x5B98,
0x8ab0,0x5BDB,
0x8ab1,0x5E72,
0x8ab2,0x5E79,
0x8ab3,0x60A3,
0x8ab4,0x611F,
0x8ab5,0x6163,
0x8ab6,0x61BE,
0x8ab7,0x63DB,
0x8ab8,0x6562,
0x8ab9,0x67D1,
0x8aba,0x6853,
0x8abb,0x68FA,
0x8abc,0x6B3E,
0x8abd,0x6B53,
0x8abe,0x6C57,
0x8abf,0x6F22,
0x8ac0,0x6F97,
0x8ac1,0x6F45,
0x8ac2,0x74B0,
0x8ac3,0x7518,
0x8ac4,0x76E3,
0x8ac5,0x770B,
0x8ac6,0x7AFF,
0x8ac7,0x7BA1,
0x8ac8,0x7C21,
0x8ac9,0x7DE9,
0x8aca,0x7F36,
0x8acb,0x7FF0,
0x8acc,0x809D,
0x8acd,0x8266,
0x8ace,0x839E,
0x8acf,0x89B3,
0x8ad0,0x8ACC,
0x8ad1,0x8CAB,
0x8ad2,0x9084,
0x8ad3,0x9451,
0x8ad4,0x9593,
0x8ad5,0x9591,
0x8ad6,0x95A2,
0x8ad7,0x9665,
0x8ad8,0x97D3,
0x8ad9,0x9928,
0x8ada,0x8218,
0x8adb,0x4E38,
0x8adc,0x542B,
0x8add,0x5CB8,
0x8ade,0x5DCC,
0x8adf,0x73A9,
0x8ae0,0x764C,
0x8ae1,0x773C,
0x8ae2,0x5CA9,
0x8ae3,0x7FEB,
0x8ae4,0x8D0B,
0x8ae5,0x96C1,
0x8ae6,0x9811,
0x8ae7,0x9854,
0x8ae8,0x9858,
0x8ae9,0x4F01,
0x8aea,0x4F0E,
0x8aeb,0x5371,
0x8aec,0x559C,
0x8aed,0x5668,
0x8aee,0x57FA,
0x8aef,0x5947,
0x8af0,0x5B09,
0x8af1,0x5BC4,
0x8af2,0x5C90,
0x8af3,0x5E0C,
0x8af4,0x5E7E,
0x8af5,0x5FCC,
0x8af6,0x63EE,
0x8af7,0x673A,
0x8af8,0x65D7,
0x8af9,0x65E2,
0x8afa,0x671F,
0x8afb,0x68CB,
0x8afc,0x68C4,
0x8b40,0x6A5F,
0x8b41,0x5E30,
0x8b42,0x6BC5,
0x8b43,0x6C17,
0x8b44,0x6C7D,
0x8b45,0x757F,
0x8b46,0x7948,
0x8b47,0x5B63,
0x8b48,0x7A00,
0x8b49,0x7D00,
0x8b4a,0x5FBD,
0x8b4b,0x898F,
0x8b4c,0x8A18,
0x8b4d,0x8CB4,
0x8b4e,0x8D77,
0x8b4f,0x8ECC,
0x8b50,0x8F1D,
0x8b51,0x98E2,
0x8b52,0x9A0E,
0x8b53,0x9B3C,
0x8b54,0x4E80,
0x8b55,0x507D,
0x8b56,0x5100,
0x8b57,0x5993,
0x8b58,0x5B9C,
0x8b59,0x622F,
0x8b5a,0x6280,
0x8b5b,0x64EC,
0x8b5c,0x6B3A,
0x8b5d,0x72A0,
0x8b5e,0x7591,
0x8b5f,0x7947,
0x8b60,0x7FA9,
0x8b61,0x87FB,
0x8b62,0x8ABC,
0x8b63,0x8B70,
0x8b64,0x63AC,
0x8b65,0x83CA,
0x8b66,0x97A0,
0x8b67,0x5409,
0x8b68,0x5403,
0x8b69,0x55AB,
0x8b6a,0x6854,
0x8b6b,0x6A58,
0x8b6c,0x8A70,
0x8b6d,0x7827,
0x8b6e,0x6775,
0x8b6f,0x9ECD,
0x8b70,0x5374,
0x8b71,0x5BA2,
0x8b72,0x811A,
0x8b73,0x8650,
0x8b74,0x9006,
0x8b75,0x4E18,
0x8b76,0x4E45,
0x8b77,0x4EC7,
0x8b78,0x4F11,
0x8b79,0x53CA,
0x8b7a,0x5438,
0x8b7b,0x5BAE,
0x8b7c,0x5F13,
0x8b7d,0x6025,
0x8b7e,0x6551,
0x8b7f,0x673D,
0x8b81,0x6C42,
0x8b82,0x6C72,
0x8b83,0x6CE3,
0x8b84,0x7078,
0x8b85,0x7403,
0x8b86,0x7A76,
0x8b87,0x7AAE,
0x8b88,0x7B08,
0x8b89,0x7D1A,
0x8b8a,0x7CFE,
0x8b8b,0x7D66,
0x8b8c,0x65E7,
0x8b8d,0x725B,
0x8b8e,0x53BB,
0x8b8f,0x5C45,
0x8b90,0x5DE8,
0x8b91,0x62D2,
0x8b92,0x62E0,
0x8b93,0x6319,
0x8b94,0x6E20,
0x8b95,0x865A,
0x8b96,0x8A31,
0x8b97,0x8DDD,
0x8b98,0x92F8,
0x8b99,0x6F01,
0x8b9a,0x79A6,
0x8b9b,0x9B5A,
0x8b9c,0x4EA8,
0x8b9d,0x4EAB,
0x8b9e,0x4EAC,
0x8b9f,0x4F9B,
0x8ba0,0x4FA0,
0x8ba1,0x50D1,
0x8ba2,0x5147,
0x8ba3,0x7AF6,
0x8ba4,0x5171,
0x8ba5,0x51F6,
0x8ba6,0x5354,
0x8ba7,0x5321,
0x8ba8,0x537F,
0x8ba9,0x53EB,
0x8baa,0x55AC,
0x8bab,0x5883,
0x8bac,0x5CE1,
0x8bad,0x5F37,
0x8bae,0x5F4A,
0x8baf,0x602F,
0x8bb0,0x6050,
0x8bb1,0x606D,
0x8bb2,0x631F,
0x8bb3,0x6559,
0x8bb4,0x6A4B,
0x8bb5,0x6CC1,
0x8bb6,0x72C2,
0x8bb7,0x72ED,
0x8bb8,0x77EF,
0x8bb9,0x80F8,
0x8bba,0x8105,
0x8bbb,0x8208,
0x8bbc,0x854E,
0x8bbd,0x90F7,
0x8bbe,0x93E1,
0x8bbf,0x97FF,
0x8bc0,0x9957,
0x8bc1,0x9A5A,
0x8bc2,0x4EF0,
0x8bc3,0x51DD,
0x8bc4,0x5C2D,
0x8bc5,0x6681,
0x8bc6,0x696D,
0x8bc7,0x5C40,
0x8bc8,0x66F2,
0x8bc9,0x6975,
0x8bca,0x7389,
0x8bcb,0x6850,
0x8bcc,0x7C81,
0x8bcd,0x50C5,
0x8bce,0x52E4,
0x8bcf,0x5747,
0x8bd0,0x5DFE,
0x8bd1,0x9326,
0x8bd2,0x65A4,
0x8bd3,0x6B23,
0x8bd4,0x6B3D,
0x8bd5,0x7434,
0x8bd6,0x7981,
0x8bd7,0x79BD,
0x8bd8,0x7B4B,
0x8bd9,0x7DCA,
0x8bda,0x82B9,
0x8bdb,0x83CC,
0x8bdc,0x887F,
0x8bdd,0x895F,
0x8bde,0x8B39,
0x8bdf,0x8FD1,
0x8be0,0x91D1,
0x8be1,0x541F,
0x8be2,0x9280,
0x8be3,0x4E5D,
0x8be4,0x5036,
0x8be5,0x53E5,
0x8be6,0x533A,
0x8be7,0x72D7,
0x8be8,0x7396,
0x8be9,0x77E9,
0x8bea,0x82E6,
0x8beb,0x8EAF,
0x8bec,0x99C6,
0x8bed,0x99C8,
0x8bee,0x99D2,
0x8bef,0x5177,
0x8bf0,0x611A,
0x8bf1,0x865E,
0x8bf2,0x55B0,
0x8bf3,0x7A7A,
0x8bf4,0x5076,
0x8bf5,0x5BD3,
0x8bf6,0x9047,
0x8bf7,0x9685,
0x8bf8,0x4E32,
0x8bf9,0x6ADB,
0x8bfa,0x91E7,
0x8bfb,0x5C51,
0x8bfc,0x5C48,
0x8c40,0x6398,
0x8c41,0x7A9F,
0x8c42,0x6C93,
0x8c43,0x9774,
0x8c44,0x8F61,
0x8c45,0x7AAA,
0x8c46,0x718A,
0x8c47,0x9688,
0x8c48,0x7C82,
0x8c49,0x6817,
0x8c4a,0x7E70,
0x8c4b,0x6851,
0x8c4c,0x936C,
0x8c4d,0x52F2,
0x8c4e,0x541B,
0x8c4f,0x85AB,
0x8c50,0x8A13,
0x8c51,0x7FA4,
0x8c52,0x8ECD,
0x8c53,0x90E1,
0x8c54,0x5366,
0x8c55,0x8888,
0x8c56,0x7941,
0x8c57,0x4FC2,
0x8c58,0x50BE,
0x8c59,0x5211,
0x8c5a,0x5144,
0x8c5b,0x5553,
0x8c5c,0x572D,
0x8c5d,0x73EA,
0x8c5e,0x578B,
0x8c5f,0x5951,
0x8c60,0x5F62,
0x8c61,0x5F84,
0x8c62,0x6075,
0x8c63,0x6176,
0x8c64,0x6167,
0x8c65,0x61A9,
0x8c66,0x63B2,
0x8c67,0x643A,
0x8c68,0x656C,
0x8c69,0x666F,
0x8c6a,0x6842,
0x8c6b,0x6E13,
0x8c6c,0x7566,
0x8c6d,0x7A3D,
0x8c6e,0x7CFB,
0x8c6f,0x7D4C,
0x8c70,0x7D99,
0x8c71,0x7E4B,
0x8c72,0x7F6B,
0x8c73,0x830E,
0x8c74,0x834A,
0x8c75,0x86CD,
0x8c76,0x8A08,
0x8c77,0x8A63,
0x8c78,0x8B66,
0x8c79,0x8EFD,
0x8c7a,0x981A,
0x8c7b,0x9D8F,
0x8c7c,0x82B8,
0x8c7d,0x8FCE,
0x8c7e,0x9BE8,
0x8c7f,0x5287,
0x8c81,0x621F,
0x8c82,0x6483,
0x8c83,0x6FC0,
0x8c84,0x9699,
0x8c85,0x6841,
0x8c86,0x5091,
0x8c87,0x6B20,
0x8c88,0x6C7A,
0x8c89,0x6F54,
0x8c8a,0x7A74,
0x8c8b,0x7D50,
0x8c8c,0x8840,
0x8c8d,0x8A23,
0x8c8e,0x6708,
0x8c8f,0x4EF6,
0x8c90,0x5039,
0x8c91,0x5026,
0x8c92,0x5065,
0x8c93,0x517C,
0x8c94,0x5238,
0x8c95,0x5263,
0x8c96,0x55A7,
0x8c97,0x570F,
0x8c98,0x5805,
0x8c99,0x5ACC,
0x8c9a,0x5EFA,
0x8c9b,0x61B2,
0x8c9c,0x61F8,
0x8c9d,0x62F3,
0x8c9e,0x6372,
0x8c9f,0x691C,
0x8ca0,0x6A29,
0x8ca1,0x727D,
0x8ca2,0x72AC,
0x8ca3,0x732E,
0x8ca4,0x7814,
0x8ca5,0x786F,
0x8ca6,0x7D79,
0x8ca7,0x770C,
0x8ca8,0x80A9,
0x8ca9,0x898B,
0x8caa,0x8B19,
0x8cab,0x8CE2,
0x8cac,0x8ED2,
0x8cad,0x9063,
0x8cae,0x9375,
0x8caf,0x967A,
0x8cb0,0x9855,
0x8cb1,0x9A13,
0x8cb2,0x9E78,
0x8cb3,0x5143,
0x8cb4,0x539F,
0x8cb5,0x53B3,
0x8cb6,0x5E7B,
0x8cb7,0x5F26,
0x8cb8,0x6E1B,
0x8cb9,0x6E90,
0x8cba,0x7384,
0x8cbb,0x73FE,
0x8cbc,0x7D43,
0x8cbd,0x8237,
0x8cbe,0x8A00,
0x8cbf,0x8AFA,
0x8cc0,0x9650,
0x8cc1,0x4E4E,
0x8cc2,0x500B,
0x8cc3,0x53E4,
0x8cc4,0x547C,
0x8cc5,0x56FA,
0x8cc6,0x59D1,
0x8cc7,0x5B64,
0x8cc8,0x5DF1,
0x8cc9,0x5EAB,
0x8cca,0x5F27,
0x8ccb,0x6238,
0x8ccc,0x6545,
0x8ccd,0x67AF,
0x8cce,0x6E56,
0x8ccf,0x72D0,
0x8cd0,0x7CCA,
0x8cd1,0x88B4,
0x8cd2,0x80A1,
0x8cd3,0x80E1,
0x8cd4,0x83F0,
0x8cd5,0x864E,
0x8cd6,0x8A87,
0x8cd7,0x8DE8,
0x8cd8,0x9237,
0x8cd9,0x96C7,
0x8cda,0x9867,
0x8cdb,0x9F13,
0x8cdc,0x4E94,
0x8cdd,0x4E92,
0x8cde,0x4F0D,
0x8cdf,0x5348,
0x8ce0,0x5449,
0x8ce1,0x543E,
0x8ce2,0x5A2F,
0x8ce3,0x5F8C,
0x8ce4,0x5FA1,
0x8ce5,0x609F,
0x8ce6,0x68A7,
0x8ce7,0x6A8E,
0x8ce8,0x745A,
0x8ce9,0x7881,
0x8cea,0x8A9E,
0x8ceb,0x8AA4,
0x8cec,0x8B77,
0x8ced,0x9190,
0x8cee,0x4E5E,
0x8cef,0x9BC9,
0x8cf0,0x4EA4,
0x8cf1,0x4F7C,
0x8cf2,0x4FAF,
0x8cf3,0x5019,
0x8cf4,0x5016,
0x8cf5,0x5149,
0x8cf6,0x516C,
0x8cf7,0x529F,
0x8cf8,0x52B9,
0x8cf9,0x52FE,
0x8cfa,0x539A,
0x8cfb,0x53E3,
0x8cfc,0x5411,
0x8d40,0x540E,
0x8d41,0x5589,
0x8d42,0x5751,
0x8d43,0x57A2,
0x8d44,0x597D,
0x8d45,0x5B54,
0x8d46,0x5B5D,
0x8d47,0x5B8F,
0x8d48,0x5DE5,
0x8d49,0x5DE7,
0x8d4a,0x5DF7,
0x8d4b,0x5E78,
0x8d4c,0x5E83,
0x8d4d,0x5E9A,
0x8d4e,0x5EB7,
0x8d4f,0x5F18,
0x8d50,0x6052,
0x8d51,0x614C,
0x8d52,0x6297,
0x8d53,0x62D8,
0x8d54,0x63A7,
0x8d55,0x653B,
0x8d56,0x6602,
0x8d57,0x6643,
0x8d58,0x66F4,
0x8d59,0x676D,
0x8d5a,0x6821,
0x8d5b,0x6897,
0x8d5c,0x69CB,
0x8d5d,0x6C5F,
0x8d5e,0x6D2A,
0x8d5f,0x6D69,
0x8d60,0x6E2F,
0x8d61,0x6E9D,
0x8d62,0x7532,
0x8d63,0x7687,
0x8d64,0x786C,
0x8d65,0x7A3F,
0x8d66,0x7CE0,
0x8d67,0x7D05,
0x8d68,0x7D18,
0x8d69,0x7D5E,
0x8d6a,0x7DB1,
0x8d6b,0x8015,
0x8d6c,0x8003,
0x8d6d,0x80AF,
0x8d6e,0x80B1,
0x8d6f,0x8154,
0x8d70,0x818F,
0x8d71,0x822A,
0x8d72,0x8352,
0x8d73,0x884C,
0x8d74,0x8861,
0x8d75,0x8B1B,
0x8d76,0x8CA2,
0x8d77,0x8CFC,
0x8d78,0x90CA,
0x8d79,0x9175,
0x8d7a,0x9271,
0x8d7b,0x783F,
0x8d7c,0x92FC,
0x8d7d,0x95A4,
0x8d7e,0x964D,
0x8d7f,0x9805,
0x8d81,0x9999,
0x8d82,0x9AD8,
0x8d83,0x9D3B,
0x8d84,0x525B,
0x8d85,0x52AB,
0x8d86,0x53F7,
0x8d87,0x5408,
0x8d88,0x58D5,
0x8d89,0x62F7,
0x8d8a,0x6FE0,
0x8d8b,0x8C6A,
0x8d8c,0x8F5F,
0x8d8d,0x9EB9,
0x8d8e,0x514B,
0x8d8f,0x523B,
0x8d90,0x544A,
0x8d91,0x56FD,
0x8d92,0x7A40,
0x8d93,0x9177,
0x8d94,0x9D60,
0x8d95,0x9ED2,
0x8d96,0x7344,
0x8d97,0x6F09,
0x8d98,0x8170,
0x8d99,0x7511,
0x8d9a,0x5FFD,
0x8d9b,0x60DA,
0x8d9c,0x9AA8,
0x8d9d,0x72DB,
0x8d9e,0x8FBC,
0x8d9f,0x6B64,
0x8da0,0x9803,
0x8da1,0x4ECA,
0x8da2,0x56F0,
0x8da3,0x5764,
0x8da4,0x58BE,
0x8da5,0x5A5A,
0x8da6,0x6068,
0x8da7,0x61C7,
0x8da8,0x660F,
0x8da9,0x6606,
0x8daa,0x6839,
0x8dab,0x68B1,
0x8dac,0x6DF7,
0x8dad,0x75D5,
0x8dae,0x7D3A,
0x8daf,0x826E,
0x8db0,0x9B42,
0x8db1,0x4E9B,
0x8db2,0x4F50,
0x8db3,0x53C9,
0x8db4,0x5506,
0x8db5,0x5D6F,
0x8db6,0x5DE6,
0x8db7,0x5DEE,
0x8db8,0x67FB,
0x8db9,0x6C99,
0x8dba,0x7473,
0x8dbb,0x7802,
0x8dbc,0x8A50,
0x8dbd,0x9396,
0x8dbe,0x88DF,
0x8dbf,0x5750,
0x8dc0,0x5EA7,
0x8dc1,0x632B,
0x8dc2,0x50B5,
0x8dc3,0x50AC,
0x8dc4,0x518D,
0x8dc5,0x6700,
0x8dc6,0x54C9,
0x8dc7,0x585E,
0x8dc8,0x59BB,
0x8dc9,0x5BB0,
0x8dca,0x5F69,
0x8dcb,0x624D,
0x8dcc,0x63A1,
0x8dcd,0x683D,
0x8dce,0x6B73,
0x8dcf,0x6E08,
0x8dd0,0x707D,
0x8dd1,0x91C7,
0x8dd2,0x7280,
0x8dd3,0x7815,
0x8dd4,0x7826,
0x8dd5,0x796D,
0x8dd6,0x658E,
0x8dd7,0x7D30,
0x8dd8,0x83DC,
0x8dd9,0x88C1,
0x8dda,0x8F09,
0x8ddb,0x969B,
0x8ddc,0x5264,
0x8ddd,0x5728,
0x8dde,0x6750,
0x8ddf,0x7F6A,
0x8de0,0x8CA1,
0x8de1,0x51B4,
0x8de2,0x5742,
0x8de3,0x962A,
0x8de4,0x583A,
0x8de5,0x698A,
0x8de6,0x80B4,
0x8de7,0x54B2,
0x8de8,0x5D0E,
0x8de9,0x57FC,
0x8dea,0x7895,
0x8deb,0x9DFA,
0x8dec,0x4F5C,
0x8ded,0x524A,
0x8dee,0x548B,
0x8def,0x643E,
0x8df0,0x6628,
0x8df1,0x6714,
0x8df2,0x67F5,
0x8df3,0x7A84,
0x8df4,0x7B56,
0x8df5,0x7D22,
0x8df6,0x932F,
0x8df7,0x685C,
0x8df8,0x9BAD,
0x8df9,0x7B39,
0x8dfa,0x5319,
0x8dfb,0x518A,
0x8dfc,0x5237,
0x8e40,0x5BDF,
0x8e41,0x62F6,
0x8e42,0x64AE,
0x8e43,0x64E6,
0x8e44,0x672D,
0x8e45,0x6BBA,
0x8e46,0x85A9,
0x8e47,0x96D1,
0x8e48,0x7690,
0x8e49,0x9BD6,
0x8e4a,0x634C,
0x8e4b,0x9306,
0x8e4c,0x9BAB,
0x8e4d,0x76BF,
0x8e4e,0x6652,
0x8e4f,0x4E09,
0x8e50,0x5098,
0x8e51,0x53C2,
0x8e52,0x5C71,
0x8e53,0x60E8,
0x8e54,0x6492,
0x8e55,0x6563,
0x8e56,0x685F,
0x8e57,0x71E6,
0x8e58,0x73CA,
0x8e59,0x7523,
0x8e5a,0x7B97,
0x8e5b,0x7E82,
0x8e5c,0x8695,
0x8e5d,0x8B83,
0x8e5e,0x8CDB,
0x8e5f,0x9178,
0x8e60,0x9910,
0x8e61,0x65AC,
0x8e62,0x66AB,
0x8e63,0x6B8B,
0x8e64,0x4ED5,
0x8e65,0x4ED4,
0x8e66,0x4F3A,
0x8e67,0x4F7F,
0x8e68,0x523A,
0x8e69,0x53F8,
0x8e6a,0x53F2,
0x8e6b,0x55E3,
0x8e6c,0x56DB,
0x8e6d,0x58EB,
0x8e6e,0x59CB,
0x8e6f,0x59C9,
0x8e70,0x59FF,
0x8e71,0x5B50,
0x8e72,0x5C4D,
0x8e73,0x5E02,
0x8e74,0x5E2B,
0x8e75,0x5FD7,
0x8e76,0x601D,
0x8e77,0x6307,
0x8e78,0x652F,
0x8e79,0x5B5C,
0x8e7a,0x65AF,
0x8e7b,0x65BD,
0x8e7c,0x65E8,
0x8e7d,0x679D,
0x8e7e,0x6B62,
0x8e7f,0x6B7B,
0x8e81,0x6C0F,
0x8e82,0x7345,
0x8e83,0x7949,
0x8e84,0x79C1,
0x8e85,0x7CF8,
0x8e86,0x7D19,
0x8e87,0x7D2B,
0x8e88,0x80A2,
0x8e89,0x8102,
0x8e8a,0x81F3,
0x8e8b,0x8996,
0x8e8c,0x8A5E,
0x8e8d,0x8A69,
0x8e8e,0x8A66,
0x8e8f,0x8A8C,
0x8e90,0x8AEE,
0x8e91,0x8CC7,
0x8e92,0x8CDC,
0x8e93,0x96CC,
0x8e94,0x98FC,
0x8e95,0x6B6F,
0x8e96,0x4E8B,
0x8e97,0x4F3C,
0x8e98,0x4F8D,
0x8e99,0x5150,
0x8e9a,0x5B57,
0x8e9b,0x5BFA,
0x8e9c,0x6148,
0x8e9d,0x6301,
0x8e9e,0x6642,
0x8e9f,0x6B21,
0x8ea0,0x6ECB,
0x8ea1,0x6CBB,
0x8ea2,0x723E,
0x8ea3,0x74BD,
0x8ea4,0x75D4,
0x8ea5,0x78C1,
0x8ea6,0x793A,
0x8ea7,0x800C,
0x8ea8,0x8033,
0x8ea9,0x81EA,
0x8eaa,0x8494,
0x8eab,0x8F9E,
0x8eac,0x6C50,
0x8ead,0x9E7F,
0x8eae,0x5F0F,
0x8eaf,0x8B58,
0x8eb0,0x9D2B,
0x8eb1,0x7AFA,
0x8eb2,0x8EF8,
0x8eb3,0x5B8D,
0x8eb4,0x96EB,
0x8eb5,0x4E03,
0x8eb6,0x53F1,
0x8eb7,0x57F7,
0x8eb8,0x5931,
0x8eb9,0x5AC9,
0x8eba,0x5BA4,
0x8ebb,0x6089,
0x8ebc,0x6E7F,
0x8ebd,0x6F06,
0x8ebe,0x75BE,
0x8ebf,0x8CEA,
0x8ec0,0x5B9F,
0x8ec1,0x8500,
0x8ec2,0x7BE0,
0x8ec3,0x5072,
0x8ec4,0x67F4,
0x8ec5,0x829D,
0x8ec6,0x5C61,
0x8ec7,0x854A,
0x8ec8,0x7E1E,
0x8ec9,0x820E,
0x8eca,0x5199,
0x8ecb,0x5C04,
0x8ecc,0x6368,
0x8ecd,0x8D66,
0x8ece,0x659C,
0x8ecf,0x716E,
0x8ed0,0x793E,
0x8ed1,0x7D17,
0x8ed2,0x8005,
0x8ed3,0x8B1D,
0x8ed4,0x8ECA,
0x8ed5,0x906E,
0x8ed6,0x86C7,
0x8ed7,0x90AA,
0x8ed8,0x501F,
0x8ed9,0x52FA,
0x8eda,0x5C3A,
0x8edb,0x6753,
0x8edc,0x707C,
0x8edd,0x7235,
0x8ede,0x914C,
0x8edf,0x91C8,
0x8ee0,0x932B,
0x8ee1,0x82E5,
0x8ee2,0x5BC2,
0x8ee3,0x5F31,
0x8ee4,0x60F9,
0x8ee5,0x4E3B,
0x8ee6,0x53D6,
0x8ee7,0x5B88,
0x8ee8,0x624B,
0x8ee9,0x6731,
0x8eea,0x6B8A,
0x8eeb,0x72E9,
0x8eec,0x73E0,
0x8eed,0x7A2E,
0x8eee,0x816B,
0x8eef,0x8DA3,
0x8ef0,0x9152,
0x8ef1,0x9996,
0x8ef2,0x5112,
0x8ef3,0x53D7,
0x8ef4,0x546A,
0x8ef5,0x5BFF,
0x8ef6,0x6388,
0x8ef7,0x6A39,
0x8ef8,0x7DAC,
0x8ef9,0x9700,
0x8efa,0x56DA,
0x8efb,0x53CE,
0x8efc,0x5468,
0x8f40,0x5B97,
0x8f41,0x5C31,
0x8f42,0x5DDE,
0x8f43,0x4FEE,
0x8f44,0x6101,
0x8f45,0x62FE,
0x8f46,0x6D32,
0x8f47,0x79C0,
0x8f48,0x79CB,
0x8f49,0x7D42,
0x8f4a,0x7E4D,
0x8f4b,0x7FD2,
0x8f4c,0x81ED,
0x8f4d,0x821F,
0x8f4e,0x8490,
0x8f4f,0x8846,
0x8f50,0x8972,
0x8f51,0x8B90,
0x8f52,0x8E74,
0x8f53,0x8F2F,
0x8f54,0x9031,
0x8f55,0x914B,
0x8f56,0x916C,
0x8f57,0x96C6,
0x8f58,0x919C,
0x8f59,0x4EC0,
0x8f5a,0x4F4F,
0x8f5b,0x5145,
0x8f5c,0x5341,
0x8f5d,0x5F93,
0x8f5e,0x620E,
0x8f5f,0x67D4,
0x8f60,0x6C41,
0x8f61,0x6E0B,
0x8f62,0x7363,
0x8f63,0x7E26,
0x8f64,0x91CD,
0x8f65,0x9283,
0x8f66,0x53D4,
0x8f67,0x5919,
0x8f68,0x5BBF,
0x8f69,0x6DD1,
0x8f6a,0x795D,
0x8f6b,0x7E2E,
0x8f6c,0x7C9B,
0x8f6d,0x587E,
0x8f6e,0x719F,
0x8f6f,0x51FA,
0x8f70,0x8853,
0x8f71,0x8FF0,
0x8f72,0x4FCA,
0x8f73,0x5CFB,
0x8f74,0x6625,
0x8f75,0x77AC,
0x8f76,0x7AE3,
0x8f77,0x821C,
0x8f78,0x99FF,
0x8f79,0x51C6,
0x8f7a,0x5FAA,
0x8f7b,0x65EC,
0x8f7c,0x696F,
0x8f7d,0x6B89,
0x8f7e,0x6DF3,
0x8f7f,0x6E96,
0x8f81,0x6F64,
0x8f82,0x76FE,
0x8f83,0x7D14,
0x8f84,0x5DE1,
0x8f85,0x9075,
0x8f86,0x9187,
0x8f87,0x9806,
0x8f88,0x51E6,
0x8f89,0x521D,
0x8f8a,0x6240,
0x8f8b,0x6691,
0x8f8c,0x66D9,
0x8f8d,0x6E1A,
0x8f8e,0x5EB6,
0x8f8f,0x7DD2,
0x8f90,0x7F72,
0x8f91,0x66F8,
0x8f92,0x85AF,
0x8f93,0x85F7,
0x8f94,0x8AF8,
0x8f95,0x52A9,
0x8f96,0x53D9,
0x8f97,0x5973,
0x8f98,0x5E8F,
0x8f99,0x5F90,
0x8f9a,0x6055,
0x8f9b,0x92E4,
0x8f9c,0x9664,
0x8f9d,0x50B7,
0x8f9e,0x511F,
0x8f9f,0x52DD,
0x8fa0,0x5320,
0x8fa1,0x5347,
0x8fa2,0x53EC,
0x8fa3,0x54E8,
0x8fa4,0x5546,
0x8fa5,0x5531,
0x8fa6,0x5617,
0x8fa7,0x5968,
0x8fa8,0x59BE,
0x8fa9,0x5A3C,
0x8faa,0x5BB5,
0x8fab,0x5C06,
0x8fac,0x5C0F,
0x8fad,0x5C11,
0x8fae,0x5C1A,
0x8faf,0x5E84,
0x8fb0,0x5E8A,
0x8fb1,0x5EE0,
0x8fb2,0x5F70,
0x8fb3,0x627F,
0x8fb4,0x6284,
0x8fb5,0x62DB,
0x8fb6,0x638C,
0x8fb7,0x6377,
0x8fb8,0x6607,
0x8fb9,0x660C,
0x8fba,0x662D,
0x8fbb,0x6676,
0x8fbc,0x677E,
0x8fbd,0x68A2,
0x8fbe,0x6A1F,
0x8fbf,0x6A35,
0x8fc0,0x6CBC,
0x8fc1,0x6D88,
0x8fc2,0x6E09,
0x8fc3,0x6E58,
0x8fc4,0x713C,
0x8fc5,0x7126,
0x8fc6,0x7167,
0x8fc7,0x75C7,
0x8fc8,0x7701,
0x8fc9,0x785D,
0x8fca,0x7901,
0x8fcb,0x7965,
0x8fcc,0x79F0,
0x8fcd,0x7AE0,
0x8fce,0x7B11,
0x8fcf,0x7CA7,
0x8fd0,0x7D39,
0x8fd1,0x8096,
0x8fd2,0x83D6,
0x8fd3,0x848B,
0x8fd4,0x8549,
0x8fd5,0x885D,
0x8fd6,0x88F3,
0x8fd7,0x8A1F,
0x8fd8,0x8A3C,
0x8fd9,0x8A54,
0x8fda,0x8A73,
0x8fdb,0x8C61,
0x8fdc,0x8CDE,
0x8fdd,0x91A4,
0x8fde,0x9266,
0x8fdf,0x937E,
0x8fe0,0x9418,
0x8fe1,0x969C,
0x8fe2,0x9798,
0x8fe3,0x4E0A,
0x8fe4,0x4E08,
0x8fe5,0x4E1E,
0x8fe6,0x4E57,
0x8fe7,0x5197,
0x8fe8,0x5270,
0x8fe9,0x57CE,
0x8fea,0x5834,
0x8feb,0x58CC,
0x8fec,0x5B22,
0x8fed,0x5E38,
0x8fee,0x60C5,
0x8fef,0x64FE,
0x8ff0,0x6761,
0x8ff1,0x6756,
0x8ff2,0x6D44,
0x8ff3,0x72B6,
0x8ff4,0x7573,
0x8ff5,0x7A63,
0x8ff6,0x84B8,
0x8ff7,0x8B72,
0x8ff8,0x91B8,
0x8ff9,0x9320,
0x8ffa,0x5631,
0x8ffb,0x57F4,
0x8ffc,0x98FE,
0x9040,0x62ED,
0x9041,0x690D,
0x9042,0x6B96,
0x9043,0x71ED,
0x9044,0x7E54,
0x9045,0x8077,
0x9046,0x8272,
0x9047,0x89E6,
0x9048,0x98DF,
0x9049,0x8755,
0x904a,0x8FB1,
0x904b,0x5C3B,
0x904c,0x4F38,
0x904d,0x4FE1,
0x904e,0x4FB5,
0x904f,0x5507,
0x9050,0x5A20,
0x9051,0x5BDD,
0x9052,0x5BE9,
0x9053,0x5FC3,
0x9054,0x614E,
0x9055,0x632F,
0x9056,0x65B0,
0x9057,0x664B,
0x9058,0x68EE,
0x9059,0x699B,
0x905a,0x6D78,
0x905b,0x6DF1,
0x905c,0x7533,
0x905d,0x75B9,
0x905e,0x771F,
0x905f,0x795E,
0x9060,0x79E6,
0x9061,0x7D33,
0x9062,0x81E3,
0x9063,0x82AF,
0x9064,0x85AA,
0x9065,0x89AA,
0x9066,0x8A3A,
0x9067,0x8EAB,
0x9068,0x8F9B,
0x9069,0x9032,
0x906a,0x91DD,
0x906b,0x9707,
0x906c,0x4EBA,
0x906d,0x4EC1,
0x906e,0x5203,
0x906f,0x5875,
0x9070,0x58EC,
0x9071,0x5C0B,
0x9072,0x751A,
0x9073,0x5C3D,
0x9074,0x814E,
0x9075,0x8A0A,
0x9076,0x8FC5,
0x9077,0x9663,
0x9078,0x976D,
0x9079,0x7B25,
0x907a,0x8ACF,
0x907b,0x9808,
0x907c,0x9162,
0x907d,0x56F3,
0x907e,0x53A8,
0x907f,0x9017,
0x9081,0x5439,
0x9082,0x5782,
0x9083,0x5E25,
0x9084,0x63A8,
0x9085,0x6C34,
0x9086,0x708A,
0x9087,0x7761,
0x9088,0x7C8B,
0x9089,0x7FE0,
0x908a,0x8870,
0x908b,0x9042,
0x908c,0x9154,
0x908d,0x9310,
0x908e,0x9318,
0x908f,0x968F,
0x9090,0x745E,
0x9091,0x9AC4,
0x9092,0x5D07,
0x9093,0x5D69,
0x9094,0x6570,
0x9095,0x67A2,
0x9096,0x8DA8,
0x9097,0x96DB,
0x9098,0x636E,
0x9099,0x6749,
0x909a,0x6919,
0x909b,0x83C5,
0x909c,0x9817,
0x909d,0x96C0,
0x909e,0x88FE,
0x909f,0x6F84,
0x90a0,0x647A,
0x90a1,0x5BF8,
0x90a2,0x4E16,
0x90a3,0x702C,
0x90a4,0x755D,
0x90a5,0x662F,
0x90a6,0x51C4,
0x90a7,0x5236,
0x90a8,0x52E2,
0x90a9,0x59D3,
0x90aa,0x5F81,
0x90ab,0x6027,
0x90ac,0x6210,
0x90ad,0x653F,
0x90ae,0x6574,
0x90af,0x661F,
0x90b0,0x6674,
0x90b1,0x68F2,
0x90b2,0x6816,
0x90b3,0x6B63,
0x90b4,0x6E05,
0x90b5,0x7272,
0x90b6,0x751F,
0x90b7,0x76DB,
0x90b8,0x7CBE,
0x90b9,0x8056,
0x90ba,0x58F0,
0x90bb,0x88FD,
0x90bc,0x897F,
0x90bd,0x8AA0,
0x90be,0x8A93,
0x90bf,0x8ACB,
0x90c0,0x901D,
0x90c1,0x9192,
0x90c2,0x9752,
0x90c3,0x9759,
0x90c4,0x6589,
0x90c5,0x7A0E,
0x90c6,0x8106,
0x90c7,0x96BB,
0x90c8,0x5E2D,
0x90c9,0x60DC,
0x90ca,0x621A,
0x90cb,0x65A5,
0x90cc,0x6614,
0x90cd,0x6790,
0x90ce,0x77F3,
0x90cf,0x7A4D,
0x90d0,0x7C4D,
0x90d1,0x7E3E,
0x90d2,0x810A,
0x90d3,0x8CAC,
0x90d4,0x8D64,
0x90d5,0x8DE1,
0x90d6,0x8E5F,
0x90d7,0x78A9,
0x90d8,0x5207,
0x90d9,0x62D9,
0x90da,0x63A5,
0x90db,0x6442,
0x90dc,0x6298,
0x90dd,0x8A2D,
0x90de,0x7A83,
0x90df,0x7BC0,
0x90e0,0x8AAC,
0x90e1,0x96EA,
0x90e2,0x7D76,
0x90e3,0x820C,
0x90e4,0x8749,
0x90e5,0x4ED9,
0x90e6,0x5148,
0x90e7,0x5343,
0x90e8,0x5360,
0x90e9,0x5BA3,
0x90ea,0x5C02,
0x90eb,0x5C16,
0x90ec,0x5DDD,
0x90ed,0x6226,
0x90ee,0x6247,
0x90ef,0x64B0,
0x90f0,0x6813,
0x90f1,0x6834,
0x90f2,0x6CC9,
0x90f3,0x6D45,
0x90f4,0x6D17,
0x90f5,0x67D3,
0x90f6,0x6F5C,
0x90f7,0x714E,
0x90f8,0x717D,
0x90f9,0x65CB,
0x90fa,0x7A7F,
0x90fb,0x7BAD,
0x90fc,0x7DDA,
0x9140,0x7E4A,
0x9141,0x7FA8,
0x9142,0x817A,
0x9143,0x821B,
0x9144,0x8239,
0x9145,0x85A6,
0x9146,0x8A6E,
0x9147,0x8CCE,
0x9148,0x8DF5,
0x9149,0x9078,
0x914a,0x9077,
0x914b,0x92AD,
0x914c,0x9291,
0x914d,0x9583,
0x914e,0x9BAE,
0x914f,0x524D,
0x9150,0x5584,
0x9151,0x6F38,
0x9152,0x7136,
0x9153,0x5168,
0x9154,0x7985,
0x9155,0x7E55,
0x9156,0x81B3,
0x9157,0x7CCE,
0x9158,0x564C,
0x9159,0x5851,
0x915a,0x5CA8,
0x915b,0x63AA,
0x915c,0x66FE,
0x915d,0x66FD,
0x915e,0x695A,
0x915f,0x72D9,
0x9160,0x758F,
0x9161,0x758E,
0x9162,0x790E,
0x9163,0x7956,
0x9164,0x79DF,
0x9165,0x7C97,
0x9166,0x7D20,
0x9167,0x7D44,
0x9168,0x8607,
0x9169,0x8A34,
0x916a,0x963B,
0x916b,0x9061,
0x916c,0x9F20,
0x916d,0x50E7,
0x916e,0x5275,
0x916f,0x53CC,
0x9170,0x53E2,
0x9171,0x5009,
0x9172,0x55AA,
0x9173,0x58EE,
0x9174,0x594F,
0x9175,0x723D,
0x9176,0x5B8B,
0x9177,0x5C64,
0x9178,0x531D,
0x9179,0x60E3,
0x917a,0x60F3,
0x917b,0x635C,
0x917c,0x6383,
0x917d,0x633F,
0x917e,0x63BB,
0x917f,0x64CD,
0x9181,0x65E9,
0x9182,0x66F9,
0x9183,0x5DE3,
0x9184,0x69CD,
0x9185,0x69FD,
0x9186,0x6F15,
0x9187,0x71E5,
0x9188,0x4E89,
0x9189,0x75E9,
0x918a,0x76F8,
0x918b,0x7A93,
0x918c,0x7CDF,
0x918d,0x7DCF,
0x918e,0x7D9C,
0x918f,0x8061,
0x9190,0x8349,
0x9191,0x8358,
0x9192,0x846C,
0x9193,0x84BC,
0x9194,0x85FB,
0x9195,0x88C5,
0x9196,0x8D70,
0x9197,0x9001,
0x9198,0x906D,
0x9199,0x9397,
0x919a,0x971C,
0x919b,0x9A12,
0x919c,0x50CF,
0x919d,0x5897,
0x919e,0x618E,
0x919f,0x81D3,
0x91a0,0x8535,
0x91a1,0x8D08,
0x91a2,0x9020,
0x91a3,0x4FC3,
0x91a4,0x5074,
0x91a5,0x5247,
0x91a6,0x5373,
0x91a7,0x606F,
0x91a8,0x6349,
0x91a9,0x675F,
0x91aa,0x6E2C,
0x91ab,0x8DB3,
0x91ac,0x901F,
0x91ad,0x4FD7,
0x91ae,0x5C5E,
0x91af,0x8CCA,
0x91b0,0x65CF,
0x91b1,0x7D9A,
0x91b2,0x5352,
0x91b3,0x8896,
0x91b4,0x5176,
0x91b5,0x63C3,
0x91b6,0x5B58,
0x91b7,0x5B6B,
0x91b8,0x5C0A,
0x91b9,0x640D,
0x91ba,0x6751,
0x91bb,0x905C,
0x91bc,0x4ED6,
0x91bd,0x591A,
0x91be,0x592A,
0x91bf,0x6C70,
0x91c0,0x8A51,
0x91c1,0x553E,
0x91c2,0x5815,
0x91c3,0x59A5,
0x91c4,0x60F0,
0x91c5,0x6253,
0x91c6,0x67C1,
0x91c7,0x8235,
0x91c8,0x6955,
0x91c9,0x9640,
0x91ca,0x99C4,
0x91cb,0x9A28,
0x91cc,0x4F53,
0x91cd,0x5806,
0x91ce,0x5BFE,
0x91cf,0x8010,
0x91d0,0x5CB1,
0x91d1,0x5E2F,
0x91d2,0x5F85,
0x91d3,0x6020,
0x91d4,0x614B,
0x91d5,0x6234,
0x91d6,0x66FF,
0x91d7,0x6CF0,
0x91d8,0x6EDE,
0x91d9,0x80CE,
0x91da,0x817F,
0x91db,0x82D4,
0x91dc,0x888B,
0x91dd,0x8CB8,
0x91de,0x9000,
0x91df,0x902E,
0x91e0,0x968A,
0x91e1,0x9EDB,
0x91e2,0x9BDB,
0x91e3,0x4EE3,
0x91e4,0x53F0,
0x91e5,0x5927,
0x91e6,0x7B2C,
0x91e7,0x918D,
0x91e8,0x984C,
0x91e9,0x9DF9,
0x91ea,0x6EDD,
0x91eb,0x7027,
0x91ec,0x5353,
0x91ed,0x5544,
0x91ee,0x5B85,
0x91ef,0x6258,
0x91f0,0x629E,
0x91f1,0x62D3,
0x91f2,0x6CA2,
0x91f3,0x6FEF,
0x91f4,0x7422,
0x91f5,0x8A17,
0x91f6,0x9438,
0x91f7,0x6FC1,
0x91f8,0x8AFE,
0x91f9,0x8338,
0x91fa,0x51E7,
0x91fb,0x86F8,
0x91fc,0x53EA,
0x9240,0x53E9,
0x9241,0x4F46,
0x9242,0x9054,
0x9243,0x8FB0,
0x9244,0x596A,
0x9245,0x8131,
0x9246,0x5DFD,
0x9247,0x7AEA,
0x9248,0x8FBF,
0x9249,0x68DA,
0x924a,0x8C37,
0x924b,0x72F8,
0x924c,0x9C48,
0x924d,0x6A3D,
0x924e,0x8AB0,
0x924f,0x4E39,
0x9250,0x5358,
0x9251,0x5606,
0x9252,0x5766,
0x9253,0x62C5,
0x9254,0x63A2,
0x9255,0x65E6,
0x9256,0x6B4E,
0x9257,0x6DE1,
0x9258,0x6E5B,
0x9259,0x70AD,
0x925a,0x77ED,
0x925b,0x7AEF,
0x925c,0x7BAA,
0x925d,0x7DBB,
0x925e,0x803D,
0x925f,0x80C6,
0x9260,0x86CB,
0x9261,0x8A95,
0x9262,0x935B,
0x9263,0x56E3,
0x9264,0x58C7,
0x9265,0x5F3E,
0x9266,0x65AD,
0x9267,0x6696,
0x9268,0x6A80,
0x9269,0x6BB5,
0x926a,0x7537,
0x926b,0x8AC7,
0x926c,0x5024,
0x926d,0x77E5,
0x926e,0x5730,
0x926f,0x5F1B,
0x9270,0x6065,
0x9271,0x667A,
0x9272,0x6C60,
0x9273,0x75F4,
0x9274,0x7A1A,
0x9275,0x7F6E,
0x9276,0x81F4,
0x9277,0x8718,
0x9278,0x9045,
0x9279,0x99B3,
0x927a,0x7BC9,
0x927b,0x755C,
0x927c,0x7AF9,
0x927d,0x7B51,
0x927e,0x84C4,
0x927f,0x9010,
0x9281,0x79E9,
0x9282,0x7A92,
0x9283,0x8336,
0x9284,0x5AE1,
0x9285,0x7740,
0x9286,0x4E2D,
0x9287,0x4EF2,
0x9288,0x5B99,
0x9289,0x5FE0,
0x928a,0x62BD,
0x928b,0x663C,
0x928c,0x67F1,
0x928d,0x6CE8,
0x928e,0x866B,
0x928f,0x8877,
0x9290,0x8A3B,
0x9291,0x914E,
0x9292,0x92F3,
0x9293,0x99D0,
0x9294,0x6A17,
0x9295,0x7026,
0x9296,0x732A,
0x9297,0x82E7,
0x9298,0x8457,
0x9299,0x8CAF,
0x929a,0x4E01,
0x929b,0x5146,
0x929c,0x51CB,
0x929d,0x558B,
0x929e,0x5BF5,
0x929f,0x5E16,
0x92a0,0x5E33,
0x92a1,0x5E81,
0x92a2,0x5F14,
0x92a3,0x5F35,
0x92a4,0x5F6B,
0x92a5,0x5FB4,
0x92a6,0x61F2,
0x92a7,0x6311,
0x92a8,0x66A2,
0x92a9,0x671D,
0x92aa,0x6F6E,
0x92ab,0x7252,
0x92ac,0x753A,
0x92ad,0x773A,
0x92ae,0x8074,
0x92af,0x8139,
0x92b0,0x8178,
0x92b1,0x8776,
0x92b2,0x8ABF,
0x92b3,0x8ADC,
0x92b4,0x8D85,
0x92b5,0x8DF3,
0x92b6,0x929A,
0x92b7,0x9577,
0x92b8,0x9802,
0x92b9,0x9CE5,
0x92ba,0x52C5,
0x92bb,0x6357,
0x92bc,0x76F4,
0x92bd,0x6715,
0x92be,0x6C88,
0x92bf,0x73CD,
0x92c0,0x8CC3,
0x92c1,0x93AE,
0x92c2,0x9673,
0x92c3,0x6D25,
0x92c4,0x589C,
0x92c5,0x690E,
0x92c6,0x69CC,
0x92c7,0x8FFD,
0x92c8,0x939A,
0x92c9,0x75DB,
0x92ca,0x901A,
0x92cb,0x585A,
0x92cc,0x6802,
0x92cd,0x63B4,
0x92ce,0x69FB,
0x92cf,0x4F43,
0x92d0,0x6F2C,
0x92d1,0x67D8,
0x92d2,0x8FBB,
0x92d3,0x8526,
0x92d4,0x7DB4,
0x92d5,0x9354,
0x92d6,0x693F,
0x92d7,0x6F70,
0x92d8,0x576A,
0x92d9,0x58F7,
0x92da,0x5B2C,
0x92db,0x7D2C,
0x92dc,0x722A,
0x92dd,0x540A,
0x92de,0x91E3,
0x92df,0x9DB4,
0x92e0,0x4EAD,
0x92e1,0x4F4E,
0x92e2,0x505C,
0x92e3,0x5075,
0x92e4,0x5243,
0x92e5,0x8C9E,
0x92e6,0x5448,
0x92e7,0x5824,
0x92e8,0x5B9A,
0x92e9,0x5E1D,
0x92ea,0x5E95,
0x92eb,0x5EAD,
0x92ec,0x5EF7,
0x92ed,0x5F1F,
0x92ee,0x608C,
0x92ef,0x62B5,
0x92f0,0x633A,
0x92f1,0x63D0,
0x92f2,0x68AF,
0x92f3,0x6C40,
0x92f4,0x7887,
0x92f5,0x798E,
0x92f6,0x7A0B,
0x92f7,0x7DE0,
0x92f8,0x8247,
0x92f9,0x8A02,
0x92fa,0x8AE6,
0x92fb,0x8E44,
0x92fc,0x9013,
0x9340,0x90B8,
0x9341,0x912D,
0x9342,0x91D8,
0x9343,0x9F0E,
0x9344,0x6CE5,
0x9345,0x6458,
0x9346,0x64E2,
0x9347,0x6575,
0x9348,0x6EF4,
0x9349,0x7684,
0x934a,0x7B1B,
0x934b,0x9069,
0x934c,0x93D1,
0x934d,0x6EBA,
0x934e,0x54F2,
0x934f,0x5FB9,
0x9350,0x64A4,
0x9351,0x8F4D,
0x9352,0x8FED,
0x9353,0x9244,
0x9354,0x5178,
0x9355,0x586B,
0x9356,0x5929,
0x9357,0x5C55,
0x9358,0x5E97,
0x9359,0x6DFB,
0x935a,0x7E8F,
0x935b,0x751C,
0x935c,0x8CBC,
0x935d,0x8EE2,
0x935e,0x985B,
0x935f,0x70B9,
0x9360,0x4F1D,
0x9361,0x6BBF,
0x9362,0x6FB1,
0x9363,0x7530,
0x9364,0x96FB,
0x9365,0x514E,
0x9366,0x5410,
0x9367,0x5835,
0x9368,0x5857,
0x9369,0x59AC,
0x936a,0x5C60,
0x936b,0x5F92,
0x936c,0x6597,
0x936d,0x675C,
0x936e,0x6E21,
0x936f,0x767B,
0x9370,0x83DF,
0x9371,0x8CED,
0x9372,0x9014,
0x9373,0x90FD,
0x9374,0x934D,
0x9375,0x7825,
0x9376,0x783A,
0x9377,0x52AA,
0x9378,0x5EA6,
0x9379,0x571F,
0x937a,0x5974,
0x937b,0x6012,
0x937c,0x5012,
0x937d,0x515A,
0x937e,0x51AC,
0x937f,0x51CD,
0x9381,0x5200,
0x9382,0x5510,
0x9383,0x5854,
0x9384,0x5858,
0x9385,0x5957,
0x9386,0x5B95,
0x9387,0x5CF6,
0x9388,0x5D8B,
0x9389,0x60BC,
0x938a,0x6295,
0x938b,0x642D,
0x938c,0x6771,
0x938d,0x6843,
0x938e,0x68BC,
0x938f,0x68DF,
0x9390,0x76D7,
0x9391,0x6DD8,
0x9392,0x6E6F,
0x9393,0x6D9B,
0x9394,0x706F,
0x9395,0x71C8,
0x9396,0x5F53,
0x9397,0x75D8,
0x9398,0x7977,
0x9399,0x7B49,
0x939a,0x7B54,
0x939b,0x7B52,
0x939c,0x7CD6,
0x939d,0x7D71,
0x939e,0x5230,
0x939f,0x8463,
0x93a0,0x8569,
0x93a1,0x85E4,
0x93a2,0x8A0E,
0x93a3,0x8B04,
0x93a4,0x8C46,
0x93a5,0x8E0F,
0x93a6,0x9003,
0x93a7,0x900F,
0x93a8,0x9419,
0x93a9,0x9676,
0x93aa,0x982D,
0x93ab,0x9A30,
0x93ac,0x95D8,
0x93ad,0x50CD,
0x93ae,0x52D5,
0x93af,0x540C,
0x93b0,0x5802,
0x93b1,0x5C0E,
0x93b2,0x61A7,
0x93b3,0x649E,
0x93b4,0x6D1E,
0x93b5,0x77B3,
0x93b6,0x7AE5,
0x93b7,0x80F4,
0x93b8,0x8404,
0x93b9,0x9053,
0x93ba,0x9285,
0x93bb,0x5CE0,
0x93bc,0x9D07,
0x93bd,0x533F,
0x93be,0x5F97,
0x93bf,0x5FB3,
0x93c0,0x6D9C,
0x93c1,0x7279,
0x93c2,0x7763,
0x93c3,0x79BF,
0x93c4,0x7BE4,
0x93c5,0x6BD2,
0x93c6,0x72EC,
0x93c7,0x8AAD,
0x93c8,0x6803,
0x93c9,0x6A61,
0x93ca,0x51F8,
0x93cb,0x7A81,
0x93cc,0x6934,
0x93cd,0x5C4A,
0x93ce,0x9CF6,
0x93cf,0x82EB,
0x93d0,0x5BC5,
0x93d1,0x9149,
0x93d2,0x701E,
0x93d3,0x5678,
0x93d4,0x5C6F,
0x93d5,0x60C7,
0x93d6,0x6566,
0x93d7,0x6C8C,
0x93d8,0x8C5A,
0x93d9,0x9041,
0x93da,0x9813,
0x93db,0x5451,
0x93dc,0x66C7,
0x93dd,0x920D,
0x93de,0x5948,
0x93df,0x90A3,
0x93e0,0x5185,
0x93e1,0x4E4D,
0x93e2,0x51EA,
0x93e3,0x8599,
0x93e4,0x8B0E,
0x93e5,0x7058,
0x93e6,0x637A,
0x93e7,0x934B,
0x93e8,0x6962,
0x93e9,0x99B4,
0x93ea,0x7E04,
0x93eb,0x7577,
0x93ec,0x5357,
0x93ed,0x6960,
0x93ee,0x8EDF,
0x93ef,0x96E3,
0x93f0,0x6C5D,
0x93f1,0x4E8C,
0x93f2,0x5C3C,
0x93f3,0x5F10,
0x93f4,0x8FE9,
0x93f5,0x5302,
0x93f6,0x8CD1,
0x93f7,0x8089,
0x93f8,0x8679,
0x93f9,0x5EFF,
0x93fa,0x65E5,
0x93fb,0x4E73,
0x93fc,0x5165,
0x9440,0x5982,
0x9441,0x5C3F,
0x9442,0x97EE,
0x9443,0x4EFB,
0x9444,0x598A,
0x9445,0x5FCD,
0x9446,0x8A8D,
0x9447,0x6FE1,
0x9448,0x79B0,
0x9449,0x7962,
0x944a,0x5BE7,
0x944b,0x8471,
0x944c,0x732B,
0x944d,0x71B1,
0x944e,0x5E74,
0x944f,0x5FF5,
0x9450,0x637B,
0x9451,0x649A,
0x9452,0x71C3,
0x9453,0x7C98,
0x9454,0x4E43,
0x9455,0x5EFC,
0x9456,0x4E4B,
0x9457,0x57DC,
0x9458,0x56A2,
0x9459,0x60A9,
0x945a,0x6FC3,
0x945b,0x7D0D,
0x945c,0x80FD,
0x945d,0x8133,
0x945e,0x81BF,
0x945f,0x8FB2,
0x9460,0x8997,
0x9461,0x86A4,
0x9462,0x5DF4,
0x9463,0x628A,
0x9464,0x64AD,
0x9465,0x8987,
0x9466,0x6777,
0x9467,0x6CE2,
0x9468,0x6D3E,
0x9469,0x7436,
0x946a,0x7834,
0x946b,0x5A46,
0x946c,0x7F75,
0x946d,0x82AD,
0x946e,0x99AC,
0x946f,0x4FF3,
0x9470,0x5EC3,
0x9471,0x62DD,
0x9472,0x6392,
0x9473,0x6557,
0x9474,0x676F,
0x9475,0x76C3,
0x9476,0x724C,
0x9477,0x80CC,
0x9478,0x80BA,
0x9479,0x8F29,
0x947a,0x914D,
0x947b,0x500D,
0x947c,0x57F9,
0x947d,0x5A92,
0x947e,0x6885,
0x947f,0x6973,
0x9481,0x7164,
0x9482,0x72FD,
0x9483,0x8CB7,
0x9484,0x58F2,
0x9485,0x8CE0,
0x9486,0x966A,
0x9487,0x9019,
0x9488,0x877F,
0x9489,0x79E4,
0x948a,0x77E7,
0x948b,0x8429,
0x948c,0x4F2F,
0x948d,0x5265,
0x948e,0x535A,
0x948f,0x62CD,
0x9490,0x67CF,
0x9491,0x6CCA,
0x9492,0x767D,
0x9493,0x7B94,
0x9494,0x7C95,
0x9495,0x8236,
0x9496,0x8584,
0x9497,0x8FEB,
0x9498,0x66DD,
0x9499,0x6F20,
0x949a,0x7206,
0x949b,0x7E1B,
0x949c,0x83AB,
0x949d,0x99C1,
0x949e,0x9EA6,
0x949f,0x51FD,
0x94a0,0x7BB1,
0x94a1,0x7872,
0x94a2,0x7BB8,
0x94a3,0x8087,
0x94a4,0x7B48,
0x94a5,0x6AE8,
0x94a6,0x5E61,
0x94a7,0x808C,
0x94a8,0x7551,
0x94a9,0x7560,
0x94aa,0x516B,
0x94ab,0x9262,
0x94ac,0x6E8C,
0x94ad,0x767A,
0x94ae,0x9197,
0x94af,0x9AEA,
0x94b0,0x4F10,
0x94b1,0x7F70,
0x94b2,0x629C,
0x94b3,0x7B4F,
0x94b4,0x95A5,
0x94b5,0x9CE9,
0x94b6,0x567A,
0x94b7,0x5859,
0x94b8,0x86E4,
0x94b9,0x96BC,
0x94ba,0x4F34,
0x94bb,0x5224,
0x94bc,0x534A,
0x94bd,0x53CD,
0x94be,0x53DB,
0x94bf,0x5E06,
0x94c0,0x642C,
0x94c1,0x6591,
0x94c2,0x677F,
0x94c3,0x6C3E,
0x94c4,0x6C4E,
0x94c5,0x7248,
0x94c6,0x72AF,
0x94c7,0x73ED,
0x94c8,0x7554,
0x94c9,0x7E41,
0x94ca,0x822C,
0x94cb,0x85E9,
0x94cc,0x8CA9,
0x94cd,0x7BC4,
0x94ce,0x91C6,
0x94cf,0x7169,
0x94d0,0x9812,
0x94d1,0x98EF,
0x94d2,0x633D,
0x94d3,0x6669,
0x94d4,0x756A,
0x94d5,0x76E4,
0x94d6,0x78D0,
0x94d7,0x8543,
0x94d8,0x86EE,
0x94d9,0x532A,
0x94da,0x5351,
0x94db,0x5426,
0x94dc,0x5983,
0x94dd,0x5E87,
0x94de,0x5F7C,
0x94df,0x60B2,
0x94e0,0x6249,
0x94e1,0x6279,
0x94e2,0x62AB,
0x94e3,0x6590,
0x94e4,0x6BD4,
0x94e5,0x6CCC,
0x94e6,0x75B2,
0x94e7,0x76AE,
0x94e8,0x7891,
0x94e9,0x79D8,
0x94ea,0x7DCB,
0x94eb,0x7F77,
0x94ec,0x80A5,
0x94ed,0x88AB,
0x94ee,0x8AB9,
0x94ef,0x8CBB,
0x94f0,0x907F,
0x94f1,0x975E,
0x94f2,0x98DB,
0x94f3,0x6A0B,
0x94f4,0x7C38,
0x94f5,0x5099,
0x94f6,0x5C3E,
0x94f7,0x5FAE,
0x94f8,0x6787,
0x94f9,0x6BD8,
0x94fa,0x7435,
0x94fb,0x7709,
0x94fc,0x7F8E,
0x9540,0x9F3B,
0x9541,0x67CA,
0x9542,0x7A17,
0x9543,0x5339,
0x9544,0x758B,
0x9545,0x9AED,
0x9546,0x5F66,
0x9547,0x819D,
0x9548,0x83F1,
0x9549,0x8098,
0x954a,0x5F3C,
0x954b,0x5FC5,
0x954c,0x7562,
0x954d,0x7B46,
0x954e,0x903C,
0x954f,0x6867,
0x9550,0x59EB,
0x9551,0x5A9B,
0x9552,0x7D10,
0x9553,0x767E,
0x9554,0x8B2C,
0x9555,0x4FF5,
0x9556,0x5F6A,
0x9557,0x6A19,
0x9558,0x6C37,
0x9559,0x6F02,
0x955a,0x74E2,
0x955b,0x7968,
0x955c,0x8868,
0x955d,0x8A55,
0x955e,0x8C79,
0x955f,0x5EDF,
0x9560,0x63CF,
0x9561,0x75C5,
0x9562,0x79D2,
0x9563,0x82D7,
0x9564,0x9328,
0x9565,0x92F2,
0x9566,0x849C,
0x9567,0x86ED,
0x9568,0x9C2D,
0x9569,0x54C1,
0x956a,0x5F6C,
0x956b,0x658C,
0x956c,0x6D5C,
0x956d,0x7015,
0x956e,0x8CA7,
0x956f,0x8CD3,
0x9570,0x983B,
0x9571,0x654F,
0x9572,0x74F6,
0x9573,0x4E0D,
0x9574,0x4ED8,
0x9575,0x57E0,
0x9576,0x592B,
0x9577,0x5A66,
0x9578,0x5BCC,
0x9579,0x51A8,
0x957a,0x5E03,
0x957b,0x5E9C,
0x957c,0x6016,
0x957d,0x6276,
0x957e,0x6577,
0x957f,0x65A7,
0x9581,0x666E,
0x9582,0x6D6E,
0x9583,0x7236,
0x9584,0x7B26,
0x9585,0x8150,
0x9586,0x819A,
0x9587,0x8299,
0x9588,0x8B5C,
0x9589,0x8CA0,
0x958a,0x8CE6,
0x958b,0x8D74,
0x958c,0x961C,
0x958d,0x9644,
0x958e,0x4FAE,
0x958f,0x64AB,
0x9590,0x6B66,
0x9591,0x821E,
0x9592,0x8461,
0x9593,0x856A,
0x9594,0x90E8,
0x9595,0x5C01,
0x9596,0x6953,
0x9597,0x98A8,
0x9598,0x847A,
0x9599,0x8557,
0x959a,0x4F0F,
0x959b,0x526F,
0x959c,0x5FA9,
0x959d,0x5E45,
0x959e,0x670D,
0x959f,0x798F,
0x95a0,0x8179,
0x95a1,0x8907,
0x95a2,0x8986,
0x95a3,0x6DF5,
0x95a4,0x5F17,
0x95a5,0x6255,
0x95a6,0x6CB8,
0x95a7,0x4ECF,
0x95a8,0x7269,
0x95a9,0x9B92,
0x95aa,0x5206,
0x95ab,0x543B,
0x95ac,0x5674,
0x95ad,0x58B3,
0x95ae,0x61A4,
0x95af,0x626E,
0x95b0,0x711A,
0x95b1,0x596E,
0x95b2,0x7C89,
0x95b3,0x7CDE,
0x95b4,0x7D1B,
0x95b5,0x96F0,
0x95b6,0x6587,
0x95b7,0x805E,
0x95b8,0x4E19,
0x95b9,0x4F75,
0x95ba,0x5175,
0x95bb,0x5840,
0x95bc,0x5E63,
0x95bd,0x5E73,
0x95be,0x5F0A,
0x95bf,0x67C4,
0x95c0,0x4E26,
0x95c1,0x853D,
0x95c2,0x9589,
0x95c3,0x965B,
0x95c4,0x7C73,
0x95c5,0x9801,
0x95c6,0x50FB,
0x95c7,0x58C1,
0x95c8,0x7656,
0x95c9,0x78A7,
0x95ca,0x5225,
0x95cb,0x77A5,
0x95cc,0x8511,
0x95cd,0x7B86,
0x95ce,0x504F,
0x95cf,0x5909,
0x95d0,0x7247,
0x95d1,0x7BC7,
0x95d2,0x7DE8,
0x95d3,0x8FBA,
0x95d4,0x8FD4,
0x95d5,0x904D,
0x95d6,0x4FBF,
0x95d7,0x52C9,
0x95d8,0x5A29,
0x95d9,0x5F01,
0x95da,0x97AD,
0x95db,0x4FDD,
0x95dc,0x8217,
0x95dd,0x92EA,
0x95de,0x5703,
0x95df,0x6355,
0x95e0,0x6B69,
0x95e1,0x752B,
0x95e2,0x88DC,
0x95e3,0x8F14,
0x95e4,0x7A42,
0x95e5,0x52DF,
0x95e6,0x5893,
0x95e7,0x6155,
0x95e8,0x620A,
0x95e9,0x66AE,
0x95ea,0x6BCD,
0x95eb,0x7C3F,
0x95ec,0x83E9,
0x95ed,0x5023,
0x95ee,0x4FF8,
0x95ef,0x5305,
0x95f0,0x5446,
0x95f1,0x5831,
0x95f2,0x5949,
0x95f3,0x5B9D,
0x95f4,0x5CF0,
0x95f5,0x5CEF,
0x95f6,0x5D29,
0x95f7,0x5E96,
0x95f8,0x62B1,
0x95f9,0x6367,
0x95fa,0x653E,
0x95fb,0x65B9,
0x95fc,0x670B,
0x9640,0x6CD5,
0x9641,0x6CE1,
0x9642,0x70F9,
0x9643,0x7832,
0x9644,0x7E2B,
0x9645,0x80DE,
0x9646,0x82B3,
0x9647,0x840C,
0x9648,0x84EC,
0x9649,0x8702,
0x964a,0x8912,
0x964b,0x8A2A,
0x964c,0x8C4A,
0x964d,0x90A6,
0x964e,0x92D2,
0x964f,0x98FD,
0x9650,0x9CF3,
0x9651,0x9D6C,
0x9652,0x4E4F,
0x9653,0x4EA1,
0x9654,0x508D,
0x9655,0x5256,
0x9656,0x574A,
0x9657,0x59A8,
0x9658,0x5E3D,
0x9659,0x5FD8,
0x965a,0x5FD9,
0x965b,0x623F,
0x965c,0x66B4,
0x965d,0x671B,
0x965e,0x67D0,
0x965f,0x68D2,
0x9660,0x5192,
0x9661,0x7D21,
0x9662,0x80AA,
0x9663,0x81A8,
0x9664,0x8B00,
0x9665,0x8C8C,
0x9666,0x8CBF,
0x9667,0x927E,
0x9668,0x9632,
0x9669,0x5420,
0x966a,0x982C,
0x966b,0x5317,
0x966c,0x50D5,
0x966d,0x535C,
0x966e,0x58A8,
0x966f,0x64B2,
0x9670,0x6734,
0x9671,0x7267,
0x9672,0x7766,
0x9673,0x7A46,
0x9674,0x91E6,
0x9675,0x52C3,
0x9676,0x6CA1,
0x9677,0x6B86,
0x9678,0x5800,
0x9679,0x5E4C,
0x967a,0x5954,
0x967b,0x672C,
0x967c,0x7FFB,
0x967d,0x51E1,
0x967e,0x76C6,
0x967f,0x6469,
0x9681,0x78E8,
0x9682,0x9B54,
0x9683,0x9EBB,
0x9684,0x57CB,
0x9685,0x59B9,
0x9686,0x6627,
0x9687,0x679A,
0x9688,0x6BCE,
0x9689,0x54E9,
0x968a,0x69D9,
0x968b,0x5E55,
0x968c,0x819C,
0x968d,0x6795,
0x968e,0x9BAA,
0x968f,0x67FE,
0x9690,0x9C52,
0x9691,0x685D,
0x9692,0x4EA6,
0x9693,0x4FE3,
0x9694,0x53C8,
0x9695,0x62B9,
0x9696,0x672B,
0x9697,0x6CAB,
0x9698,0x8FC4,
0x9699,0x4FAD,
0x969a,0x7E6D,
0x969b,0x9EBF,
0x969c,0x4E07,
0x969d,0x6162,
0x969e,0x6E80,
0x969f,0x6F2B,
0x96a0,0x8513,
0x96a1,0x5473,
0x96a2,0x672A,
0x96a3,0x9B45,
0x96a4,0x5DF3,
0x96a5,0x7B95,
0x96a6,0x5CAC,
0x96a7,0x5BC6,
0x96a8,0x871C,
0x96a9,0x6E4A,
0x96aa,0x84D1,
0x96ab,0x7A14,
0x96ac,0x8108,
0x96ad,0x5999,
0x96ae,0x7C8D,
0x96af,0x6C11,
0x96b0,0x7720,
0x96b1,0x52D9,
0x96b2,0x5922,
0x96b3,0x7121,
0x96b4,0x725F,
0x96b5,0x77DB,
0x96b6,0x9727,
0x96b7,0x9D61,
0x96b8,0x690B,
0x96b9,0x5A7F,
0x96ba,0x5A18,
0x96bb,0x51A5,
0x96bc,0x540D,
0x96bd,0x547D,
0x96be,0x660E,
0x96bf,0x76DF,
0x96c0,0x8FF7,
0x96c1,0x9298,
0x96c2,0x9CF4,
0x96c3,0x59EA,
0x96c4,0x725D,
0x96c5,0x6EC5,
0x96c6,0x514D,
0x96c7,0x68C9,
0x96c8,0x7DBF,
0x96c9,0x7DEC,
0x96ca,0x9762,
0x96cb,0x9EBA,
0x96cc,0x6478,
0x96cd,0x6A21,
0x96ce,0x8302,
0x96cf,0x5984,
0x96d0,0x5B5F,
0x96d1,0x6BDB,
0x96d2,0x731B,
0x96d3,0x76F2,
0x96d4,0x7DB2,
0x96d5,0x8017,
0x96d6,0x8499,
0x96d7,0x5132,
0x96d8,0x6728,
0x96d9,0x9ED9,
0x96da,0x76EE,
0x96db,0x6762,
0x96dc,0x52FF,
0x96dd,0x9905,
0x96de,0x5C24,
0x96df,0x623B,
0x96e0,0x7C7E,
0x96e1,0x8CB0,
0x96e2,0x554F,
0x96e3,0x60B6,
0x96e4,0x7D0B,
0x96e5,0x9580,
0x96e6,0x5301,
0x96e7,0x4E5F,
0x96e8,0x51B6,
0x96e9,0x591C,
0x96ea,0x723A,
0x96eb,0x8036,
0x96ec,0x91CE,
0x96ed,0x5F25,
0x96ee,0x77E2,
0x96ef,0x5384,
0x96f0,0x5F79,
0x96f1,0x7D04,
0x96f2,0x85AC,
0x96f3,0x8A33,
0x96f4,0x8E8D,
0x96f5,0x9756,
0x96f6,0x67F3,
0x96f7,0x85AE,
0x96f8,0x9453,
0x96f9,0x6109,
0x96fa,0x6108,
0x96fb,0x6CB9,
0x96fc,0x7652,
0x9740,0x8AED,
0x9741,0x8F38,
0x9742,0x552F,
0x9743,0x4F51,
0x9744,0x512A,
0x9745,0x52C7,
0x9746,0x53CB,
0x9747,0x5BA5,
0x9748,0x5E7D,
0x9749,0x60A0,
0x974a,0x6182,
0x974b,0x63D6,
0x974c,0x6709,
0x974d,0x67DA,
0x974e,0x6E67,
0x974f,0x6D8C,
0x9750,0x7336,
0x9751,0x7337,
0x9752,0x7531,
0x9753,0x7950,
0x9754,0x88D5,
0x9755,0x8A98,
0x9756,0x904A,
0x9757,0x9091,
0x9758,0x90F5,
0x9759,0x96C4,
0x975a,0x878D,
0x975b,0x5915,
0x975c,0x4E88,
0x975d,0x4F59,
0x975e,0x4E0E,
0x975f,0x8A89,
0x9760,0x8F3F,
0x9761,0x9810,
0x9762,0x50AD,
0x9763,0x5E7C,
0x9764,0x5996,
0x9765,0x5BB9,
0x9766,0x5EB8,
0x9767,0x63DA,
0x9768,0x63FA,
0x9769,0x64C1,
0x976a,0x66DC,
0x976b,0x694A,
0x976c,0x69D8,
0x976d,0x6D0B,
0x976e,0x6EB6,
0x976f,0x7194,
0x9770,0x7528,
0x9771,0x7AAF,
0x9772,0x7F8A,
0x9773,0x8000,
0x9774,0x8449,
0x9775,0x84C9,
0x9776,0x8981,
0x9777,0x8B21,
0x9778,0x8E0A,
0x9779,0x9065,
0x977a,0x967D,
0x977b,0x990A,
0x977c,0x617E,
0x977d,0x6291,
0x977e,0x6B32,
0x977f,0x6C83,
0x9781,0x6D74,
0x9782,0x7FCC,
0x9783,0x7FFC,
0x9784,0x6DC0,
0x9785,0x7F85,
0x9786,0x87BA,
0x9787,0x88F8,
0x9788,0x6765,
0x9789,0x83B1,
0x978a,0x983C,
0x978b,0x96F7,
0x978c,0x6D1B,
0x978d,0x7D61,
0x978e,0x843D,
0x978f,0x916A,
0x9790,0x4E71,
0x9791,0x5375,
0x9792,0x5D50,
0x9793,0x6B04,
0x9794,0x6FEB,
0x9795,0x85CD,
0x9796,0x862D,
0x9797,0x89A7,
0x9798,0x5229,
0x9799,0x540F,
0x979a,0x5C65,
0x979b,0x674E,
0x979c,0x68A8,
0x979d,0x7406,
0x979e,0x7483,
0x979f,0x75E2,
0x97a0,0x88CF,
0x97a1,0x88E1,
0x97a2,0x91CC,
0x97a3,0x96E2,
0x97a4,0x9678,
0x97a5,0x5F8B,
0x97a6,0x7387,
0x97a7,0x7ACB,
0x97a8,0x844E,
0x97a9,0x63A0,
0x97aa,0x7565,
0x97ab,0x5289,
0x97ac,0x6D41,
0x97ad,0x6E9C,
0x97ae,0x7409,
0x97af,0x7559,
0x97b0,0x786B,
0x97b1,0x7C92,
0x97b2,0x9686,
0x97b3,0x7ADC,
0x97b4,0x9F8D,
0x97b5,0x4FB6,
0x97b6,0x616E,
0x97b7,0x65C5,
0x97b8,0x865C,
0x97b9,0x4E86,
0x97ba,0x4EAE,
0x97bb,0x50DA,
0x97bc,0x4E21,
0x97bd,0x51CC,
0x97be,0x5BEE,
0x97bf,0x6599,
0x97c0,0x6881,
0x97c1,0x6DBC,
0x97c2,0x731F,
0x97c3,0x7642,
0x97c4,0x77AD,
0x97c5,0x7A1C,
0x97c6,0x7CE7,
0x97c7,0x826F,
0x97c8,0x8AD2,
0x97c9,0x907C,
0x97ca,0x91CF,
0x97cb,0x9675,
0x97cc,0x9818,
0x97cd,0x529B,
0x97ce,0x7DD1,
0x97cf,0x502B,
0x97d0,0x5398,
0x97d1,0x6797,
0x97d2,0x6DCB,
0x97d3,0x71D0,
0x97d4,0x7433,
0x97d5,0x81E8,
0x97d6,0x8F2A,
0x97d7,0x96A3,
0x97d8,0x9C57,
0x97d9,0x9E9F,
0x97da,0x7460,
0x97db,0x5841,
0x97dc,0x6D99,
0x97dd,0x7D2F,
0x97de,0x985E,
0x97df,0x4EE4,
0x97e0,0x4F36,
0x97e1,0x4F8B,
0x97e2,0x51B7,
0x97e3,0x52B1,
0x97e4,0x5DBA,
0x97e5,0x601C,
0x97e6,0x73B2,
0x97e7,0x793C,
0x97e8,0x82D3,
0x97e9,0x9234,
0x97ea,0x96B7,
0x97eb,0x96F6,
0x97ec,0x970A,
0x97ed,0x9E97,
0x97ee,0x9F62,
0x97ef,0x66A6,
0x97f0,0x6B74,
0x97f1,0x5217,
0x97f2,0x52A3,
0x97f3,0x70C8,
0x97f4,0x88C2,
0x97f5,0x5EC9,
0x97f6,0x604B,
0x97f7,0x6190,
0x97f8,0x6F23,
0x97f9,0x7149,
0x97fa,0x7C3E,
0x97fb,0x7DF4,
0x97fc,0x806F,
0x9840,0x84EE,
0x9841,0x9023,
0x9842,0x932C,
0x9843,0x5442,
0x9844,0x9B6F,
0x9845,0x6AD3,
0x9846,0x7089,
0x9847,0x8CC2,
0x9848,0x8DEF,
0x9849,0x9732,
0x984a,0x52B4,
0x984b,0x5A41,
0x984c,0x5ECA,
0x984d,0x5F04,
0x984e,0x6717,
0x984f,0x697C,
0x9850,0x6994,
0x9851,0x6D6A,
0x9852,0x6F0F,
0x9853,0x7262,
0x9854,0x72FC,
0x9855,0x7BED,
0x9856,0x8001,
0x9857,0x807E,
0x9858,0x874B,
0x9859,0x90CE,
0x985a,0x516D,
0x985b,0x9E93,
0x985c,0x7984,
0x985d,0x808B,
0x985e,0x9332,
0x985f,0x8AD6,
0x9860,0x502D,
0x9861,0x548C,
0x9862,0x8A71,
0x9863,0x6B6A,
0x9864,0x8CC4,
0x9865,0x8107,
0x9866,0x60D1,
0x9867,0x67A0,
0x9868,0x9DF2,
0x9869,0x4E99,
0x986a,0x4E98,
0x986b,0x9C10,
0x986c,0x8A6B,
0x986d,0x85C1,
0x986e,0x8568,
0x986f,0x6900,
0x9870,0x6E7E,
0x9871,0x7897,
0x9872,0x8155,
0x989f,0x5F0C,
0x98a0,0x4E10,
0x98a1,0x4E15,
0x98a2,0x4E2A,
0x98a3,0x4E31,
0x98a4,0x4E36,
0x98a5,0x4E3C,
0x98a6,0x4E3F,
0x98a7,0x4E42,
0x98a8,0x4E56,
0x98a9,0x4E58,
0x98aa,0x4E82,
0x98ab,0x4E85,
0x98ac,0x8C6B,
0x98ad,0x4E8A,
0x98ae,0x8212,
0x98af,0x5F0D,
0x98b0,0x4E8E,
0x98b1,0x4E9E,
0x98b2,0x4E9F,
0x98b3,0x4EA0,
0x98b4,0x4EA2,
0x98b5,0x4EB0,
0x98b6,0x4EB3,
0x98b7,0x4EB6,
0x98b8,0x4ECE,
0x98b9,0x4ECD,
0x98ba,0x4EC4,
0x98bb,0x4EC6,
0x98bc,0x4EC2,
0x98bd,0x4ED7,
0x98be,0x4EDE,
0x98bf,0x4EED,
0x98c0,0x4EDF,
0x98c1,0x4EF7,
0x98c2,0x4F09,
0x98c3,0x4F5A,
0x98c4,0x4F30,
0x98c5,0x4F5B,
0x98c6,0x4F5D,
0x98c7,0x4F57,
0x98c8,0x4F47,
0x98c9,0x4F76,
0x98ca,0x4F88,
0x98cb,0x4F8F,
0x98cc,0x4F98,
0x98cd,0x4F7B,
0x98ce,0x4F69,
0x98cf,0x4F70,
0x98d0,0x4F91,
0x98d1,0x4F6F,
0x98d2,0x4F86,
0x98d3,0x4F96,
0x98d4,0x5118,
0x98d5,0x4FD4,
0x98d6,0x4FDF,
0x98d7,0x4FCE,
0x98d8,0x4FD8,
0x98d9,0x4FDB,
0x98da,0x4FD1,
0x98db,0x4FDA,
0x98dc,0x4FD0,
0x98dd,0x4FE4,
0x98de,0x4FE5,
0x98df,0x501A,
0x98e0,0x5028,
0x98e1,0x5014,
0x98e2,0x502A,
0x98e3,0x5025,
0x98e4,0x5005,
0x98e5,0x4F1C,
0x98e6,0x4FF6,
0x98e7,0x5021,
0x98e8,0x5029,
0x98e9,0x502C,
0x98ea,0x4FFE,
0x98eb,0x4FEF,
0x98ec,0x5011,
0x98ed,0x5006,
0x98ee,0x5043,
0x98ef,0x5047,
0x98f0,0x6703,
0x98f1,0x5055,
0x98f2,0x5050,
0x98f3,0x5048,
0x98f4,0x505A,
0x98f5,0x5056,
0x98f6,0x506C,
0x98f7,0x5078,
0x98f8,0x5080,
0x98f9,0x509A,
0x98fa,0x5085,
0x98fb,0x50B4,
0x98fc,0x50B2,
0x9940,0x50C9,
0x9941,0x50CA,
0x9942,0x50B3,
0x9943,0x50C2,
0x9944,0x50D6,
0x9945,0x50DE,
0x9946,0x50E5,
0x9947,0x50ED,
0x9948,0x50E3,
0x9949,0x50EE,
0x994a,0x50F9,
0x994b,0x50F5,
0x994c,0x5109,
0x994d,0x5101,
0x994e,0x5102,
0x994f,0x5116,
0x9950,0x5115,
0x9951,0x5114,
0x9952,0x511A,
0x9953,0x5121,
0x9954,0x513A,
0x9955,0x5137,
0x9956,0x513C,
0x9957,0x513B,
0x9958,0x513F,
0x9959,0x5140,
0x995a,0x5152,
0x995b,0x514C,
0x995c,0x5154,
0x995d,0x5162,
0x995e,0x7AF8,
0x995f,0x5169,
0x9960,0x516A,
0x9961,0x516E,
0x9962,0x5180,
0x9963,0x5182,
0x9964,0x56D8,
0x9965,0x518C,
0x9966,0x5189,
0x9967,0x518F,
0x9968,0x5191,
0x9969,0x5193,
0x996a,0x5195,
0x996b,0x5196,
0x996c,0x51A4,
0x996d,0x51A6,
0x996e,0x51A2,
0x996f,0x51A9,
0x9970,0x51AA,
0x9971,0x51AB,
0x9972,0x51B3,
0x9973,0x51B1,
0x9974,0x51B2,
0x9975,0x51B0,
0x9976,0x51B5,
0x9977,0x51BD,
0x9978,0x51C5,
0x9979,0x51C9,
0x997a,0x51DB,
0x997b,0x51E0,
0x997c,0x8655,
0x997d,0x51E9,
0x997e,0x51ED,
0x997f,0x51F0,
0x9981,0x51F5,
0x9982,0x51FE,
0x9983,0x5204,
0x9984,0x520B,
0x9985,0x5214,
0x9986,0x520E,
0x9987,0x5227,
0x9988,0x522A,
0x9989,0x522E,
0x998a,0x5233,
0x998b,0x5239,
0x998c,0x524F,
0x998d,0x5244,
0x998e,0x524B,
0x998f,0x524C,
0x9990,0x525E,
0x9991,0x5254,
0x9992,0x526A,
0x9993,0x5274,
0x9994,0x5269,
0x9995,0x5273,
0x9996,0x527F,
0x9997,0x527D,
0x9998,0x528D,
0x9999,0x5294,
0x999a,0x5292,
0x999b,0x5271,
0x999c,0x5288,
0x999d,0x5291,
0x999e,0x8FA8,
0x999f,0x8FA7,
0x99a0,0x52AC,
0x99a1,0x52AD,
0x99a2,0x52BC,
0x99a3,0x52B5,
0x99a4,0x52C1,
0x99a5,0x52CD,
0x99a6,0x52D7,
0x99a7,0x52DE,
0x99a8,0x52E3,
0x99a9,0x52E6,
0x99aa,0x98ED,
0x99ab,0x52E0,
0x99ac,0x52F3,
0x99ad,0x52F5,
0x99ae,0x52F8,
0x99af,0x52F9,
0x99b0,0x5306,
0x99b1,0x5308,
0x99b2,0x7538,
0x99b3,0x530D,
0x99b4,0x5310,
0x99b5,0x530F,
0x99b6,0x5315,
0x99b7,0x531A,
0x99b8,0x5323,
0x99b9,0x532F,
0x99ba,0x5331,
0x99bb,0x5333,
0x99bc,0x5338,
0x99bd,0x5340,
0x99be,0x5346,
0x99bf,0x5345,
0x99c0,0x4E17,
0x99c1,0x5349,
0x99c2,0x534D,
0x99c3,0x51D6,
0x99c4,0x535E,
0x99c5,0x5369,
0x99c6,0x536E,
0x99c7,0x5918,
0x99c8,0x537B,
0x99c9,0x5377,
0x99ca,0x5382,
0x99cb,0x5396,
0x99cc,0x53A0,
0x99cd,0x53A6,
0x99ce,0x53A5,
0x99cf,0x53AE,
0x99d0,0x53B0,
0x99d1,0x53B6,
0x99d2,0x53C3,
0x99d3,0x7C12,
0x99d4,0x96D9,
0x99d5,0x53DF,
0x99d6,0x66FC,
0x99d7,0x71EE,
0x99d8,0x53EE,
0x99d9,0x53E8,
0x99da,0x53ED,
0x99db,0x53FA,
0x99dc,0x5401,
0x99dd,0x543D,
0x99de,0x5440,
0x99df,0x542C,
0x99e0,0x542D,
0x99e1,0x543C,
0x99e2,0x542E,
0x99e3,0x5436,
0x99e4,0x5429,
0x99e5,0x541D,
0x99e6,0x544E,
0x99e7,0x548F,
0x99e8,0x5475,
0x99e9,0x548E,
0x99ea,0x545F,
0x99eb,0x5471,
0x99ec,0x5477,
0x99ed,0x5470,
0x99ee,0x5492,
0x99ef,0x547B,
0x99f0,0x5480,
0x99f1,0x5476,
0x99f2,0x5484,
0x99f3,0x5490,
0x99f4,0x5486,
0x99f5,0x54C7,
0x99f6,0x54A2,
0x99f7,0x54B8,
0x99f8,0x54A5,
0x99f9,0x54AC,
0x99fa,0x54C4,
0x99fb,0x54C8,
0x99fc,0x54A8,
0x9a40,0x54AB,
0x9a41,0x54C2,
0x9a42,0x54A4,
0x9a43,0x54BE,
0x9a44,0x54BC,
0x9a45,0x54D8,
0x9a46,0x54E5,
0x9a47,0x54E6,
0x9a48,0x550F,
0x9a49,0x5514,
0x9a4a,0x54FD,
0x9a4b,0x54EE,
0x9a4c,0x54ED,
0x9a4d,0x54FA,
0x9a4e,0x54E2,
0x9a4f,0x5539,
0x9a50,0x5540,
0x9a51,0x5563,
0x9a52,0x554C,
0x9a53,0x552E,
0x9a54,0x555C,
0x9a55,0x5545,
0x9a56,0x5556,
0x9a57,0x5557,
0x9a58,0x5538,
0x9a59,0x5533,
0x9a5a,0x555D,
0x9a5b,0x5599,
0x9a5c,0x5580,
0x9a5d,0x54AF,
0x9a5e,0x558A,
0x9a5f,0x559F,
0x9a60,0x557B,
0x9a61,0x557E,
0x9a62,0x5598,
0x9a63,0x559E,
0x9a64,0x55AE,
0x9a65,0x557C,
0x9a66,0x5583,
0x9a67,0x55A9,
0x9a68,0x5587,
0x9a69,0x55A8,
0x9a6a,0x55DA,
0x9a6b,0x55C5,
0x9a6c,0x55DF,
0x9a6d,0x55C4,
0x9a6e,0x55DC,
0x9a6f,0x55E4,
0x9a70,0x55D4,
0x9a71,0x5614,
0x9a72,0x55F7,
0x9a73,0x5616,
0x9a74,0x55FE,
0x9a75,0x55FD,
0x9a76,0x561B,
0x9a77,0x55F9,
0x9a78,0x564E,
0x9a79,0x5650,
0x9a7a,0x71DF,
0x9a7b,0x5634,
0x9a7c,0x5636,
0x9a7d,0x5632,
0x9a7e,0x5638,
0x9a7f,0x566B,
0x9a81,0x5664,
0x9a82,0x562F,
0x9a83,0x566C,
0x9a84,0x566A,
0x9a85,0x5686,
0x9a86,0x5680,
0x9a87,0x568A,
0x9a88,0x56A0,
0x9a89,0x5694,
0x9a8a,0x568F,
0x9a8b,0x56A5,
0x9a8c,0x56AE,
0x9a8d,0x56B6,
0x9a8e,0x56B4,
0x9a8f,0x56C2,
0x9a90,0x56BC,
0x9a91,0x56C1,
0x9a92,0x56C3,
0x9a93,0x56C0,
0x9a94,0x56C8,
0x9a95,0x56CE,
0x9a96,0x56D1,
0x9a97,0x56D3,
0x9a98,0x56D7,
0x9a99,0x56EE,
0x9a9a,0x56F9,
0x9a9b,0x5700,
0x9a9c,0x56FF,
0x9a9d,0x5704,
0x9a9e,0x5709,
0x9a9f,0x5708,
0x9aa0,0x570B,
0x9aa1,0x570D,
0x9aa2,0x5713,
0x9aa3,0x5718,
0x9aa4,0x5716,
0x9aa5,0x55C7,
0x9aa6,0x571C,
0x9aa7,0x5726,
0x9aa8,0x5737,
0x9aa9,0x5738,
0x9aaa,0x574E,
0x9aab,0x573B,
0x9aac,0x5740,
0x9aad,0x574F,
0x9aae,0x5769,
0x9aaf,0x57C0,
0x9ab0,0x5788,
0x9ab1,0x5761,
0x9ab2,0x577F,
0x9ab3,0x5789,
0x9ab4,0x5793,
0x9ab5,0x57A0,
0x9ab6,0x57B3,
0x9ab7,0x57A4,
0x9ab8,0x57AA,
0x9ab9,0x57B0,
0x9aba,0x57C3,
0x9abb,0x57C6,
0x9abc,0x57D4,
0x9abd,0x57D2,
0x9abe,0x57D3,
0x9abf,0x580A,
0x9ac0,0x57D6,
0x9ac1,0x57E3,
0x9ac2,0x580B,
0x9ac3,0x5819,
0x9ac4,0x581D,
0x9ac5,0x5872,
0x9ac6,0x5821,
0x9ac7,0x5862,
0x9ac8,0x584B,
0x9ac9,0x5870,
0x9aca,0x6BC0,
0x9acb,0x5852,
0x9acc,0x583D,
0x9acd,0x5879,
0x9ace,0x5885,
0x9acf,0x58B9,
0x9ad0,0x589F,
0x9ad1,0x58AB,
0x9ad2,0x58BA,
0x9ad3,0x58DE,
0x9ad4,0x58BB,
0x9ad5,0x58B8,
0x9ad6,0x58AE,
0x9ad7,0x58C5,
0x9ad8,0x58D3,
0x9ad9,0x58D1,
0x9ada,0x58D7,
0x9adb,0x58D9,
0x9adc,0x58D8,
0x9add,0x58E5,
0x9ade,0x58DC,
0x9adf,0x58E4,
0x9ae0,0x58DF,
0x9ae1,0x58EF,
0x9ae2,0x58FA,
0x9ae3,0x58F9,
0x9ae4,0x58FB,
0x9ae5,0x58FC,
0x9ae6,0x58FD,
0x9ae7,0x5902,
0x9ae8,0x590A,
0x9ae9,0x5910,
0x9aea,0x591B,
0x9aeb,0x68A6,
0x9aec,0x5925,
0x9aed,0x592C,
0x9aee,0x592D,
0x9aef,0x5932,
0x9af0,0x5938,
0x9af1,0x593E,
0x9af2,0x7AD2,
0x9af3,0x5955,
0x9af4,0x5950,
0x9af5,0x594E,
0x9af6,0x595A,
0x9af7,0x5958,
0x9af8,0x5962,
0x9af9,0x5960,
0x9afa,0x5967,
0x9afb,0x596C,
0x9afc,0x5969,
0x9b40,0x5978,
0x9b41,0x5981,
0x9b42,0x599D,
0x9b43,0x4F5E,
0x9b44,0x4FAB,
0x9b45,0x59A3,
0x9b46,0x59B2,
0x9b47,0x59C6,
0x9b48,0x59E8,
0x9b49,0x59DC,
0x9b4a,0x598D,
0x9b4b,0x59D9,
0x9b4c,0x59DA,
0x9b4d,0x5A25,
0x9b4e,0x5A1F,
0x9b4f,0x5A11,
0x9b50,0x5A1C,
0x9b51,0x5A09,
0x9b52,0x5A1A,
0x9b53,0x5A40,
0x9b54,0x5A6C,
0x9b55,0x5A49,
0x9b56,0x5A35,
0x9b57,0x5A36,
0x9b58,0x5A62,
0x9b59,0x5A6A,
0x9b5a,0x5A9A,
0x9b5b,0x5ABC,
0x9b5c,0x5ABE,
0x9b5d,0x5ACB,
0x9b5e,0x5AC2,
0x9b5f,0x5ABD,
0x9b60,0x5AE3,
0x9b61,0x5AD7,
0x9b62,0x5AE6,
0x9b63,0x5AE9,
0x9b64,0x5AD6,
0x9b65,0x5AFA,
0x9b66,0x5AFB,
0x9b67,0x5B0C,
0x9b68,0x5B0B,
0x9b69,0x5B16,
0x9b6a,0x5B32,
0x9b6b,0x5AD0,
0x9b6c,0x5B2A,
0x9b6d,0x5B36,
0x9b6e,0x5B3E,
0x9b6f,0x5B43,
0x9b70,0x5B45,
0x9b71,0x5B40,
0x9b72,0x5B51,
0x9b73,0x5B55,
0x9b74,0x5B5A,
0x9b75,0x5B5B,
0x9b76,0x5B65,
0x9b77,0x5B69,
0x9b78,0x5B70,
0x9b79,0x5B73,
0x9b7a,0x5B75,
0x9b7b,0x5B78,
0x9b7c,0x6588,
0x9b7d,0x5B7A,
0x9b7e,0x5B80,
0x9b7f,0x5B83,
0x9b81,0x5BA6,
0x9b82,0x5BB8,
0x9b83,0x5BC3,
0x9b84,0x5BC7,
0x9b85,0x5BC9,
0x9b86,0x5BD4,
0x9b87,0x5BD0,
0x9b88,0x5BE4,
0x9b89,0x5BE6,
0x9b8a,0x5BE2,
0x9b8b,0x5BDE,
0x9b8c,0x5BE5,
0x9b8d,0x5BEB,
0x9b8e,0x5BF0,
0x9b8f,0x5BF6,
0x9b90,0x5BF3,
0x9b91,0x5C05,
0x9b92,0x5C07,
0x9b93,0x5C08,
0x9b94,0x5C0D,
0x9b95,0x5C13,
0x9b96,0x5C20,
0x9b97,0x5C22,
0x9b98,0x5C28,
0x9b99,0x5C38,
0x9b9a,0x5C39,
0x9b9b,0x5C41,
0x9b9c,0x5C46,
0x9b9d,0x5C4E,
0x9b9e,0x5C53,
0x9b9f,0x5C50,
0x9ba0,0x5C4F,
0x9ba1,0x5B71,
0x9ba2,0x5C6C,
0x9ba3,0x5C6E,
0x9ba4,0x4E62,
0x9ba5,0x5C76,
0x9ba6,0x5C79,
0x9ba7,0x5C8C,
0x9ba8,0x5C91,
0x9ba9,0x5C94,
0x9baa,0x599B,
0x9bab,0x5CAB,
0x9bac,0x5CBB,
0x9bad,0x5CB6,
0x9bae,0x5CBC,
0x9baf,0x5CB7,
0x9bb0,0x5CC5,
0x9bb1,0x5CBE,
0x9bb2,0x5CC7,
0x9bb3,0x5CD9,
0x9bb4,0x5CE9,
0x9bb5,0x5CFD,
0x9bb6,0x5CFA,
0x9bb7,0x5CED,
0x9bb8,0x5D8C,
0x9bb9,0x5CEA,
0x9bba,0x5D0B,
0x9bbb,0x5D15,
0x9bbc,0x5D17,
0x9bbd,0x5D5C,
0x9bbe,0x5D1F,
0x9bbf,0x5D1B,
0x9bc0,0x5D11,
0x9bc1,0x5D14,
0x9bc2,0x5D22,
0x9bc3,0x5D1A,
0x9bc4,0x5D19,
0x9bc5,0x5D18,
0x9bc6,0x5D4C,
0x9bc7,0x5D52,
0x9bc8,0x5D4E,
0x9bc9,0x5D4B,
0x9bca,0x5D6C,
0x9bcb,0x5D73,
0x9bcc,0x5D76,
0x9bcd,0x5D87,
0x9bce,0x5D84,
0x9bcf,0x5D82,
0x9bd0,0x5DA2,
0x9bd1,0x5D9D,
0x9bd2,0x5DAC,
0x9bd3,0x5DAE,
0x9bd4,0x5DBD,
0x9bd5,0x5D90,
0x9bd6,0x5DB7,
0x9bd7,0x5DBC,
0x9bd8,0x5DC9,
0x9bd9,0x5DCD,
0x9bda,0x5DD3,
0x9bdb,0x5DD2,
0x9bdc,0x5DD6,
0x9bdd,0x5DDB,
0x9bde,0x5DEB,
0x9bdf,0x5DF2,
0x9be0,0x5DF5,
0x9be1,0x5E0B,
0x9be2,0x5E1A,
0x9be3,0x5E19,
0x9be4,0x5E11,
0x9be5,0x5E1B,
0x9be6,0x5E36,
0x9be7,0x5E37,
0x9be8,0x5E44,
0x9be9,0x5E43,
0x9bea,0x5E40,
0x9beb,0x5E4E,
0x9bec,0x5E57,
0x9bed,0x5E54,
0x9bee,0x5E5F,
0x9bef,0x5E62,
0x9bf0,0x5E64,
0x9bf1,0x5E47,
0x9bf2,0x5E75,
0x9bf3,0x5E76,
0x9bf4,0x5E7A,
0x9bf5,0x9EBC,
0x9bf6,0x5E7F,
0x9bf7,0x5EA0,
0x9bf8,0x5EC1,
0x9bf9,0x5EC2,
0x9bfa,0x5EC8,
0x9bfb,0x5ED0,
0x9bfc,0x5ECF,
0x9c40,0x5ED6,
0x9c41,0x5EE3,
0x9c42,0x5EDD,
0x9c43,0x5EDA,
0x9c44,0x5EDB,
0x9c45,0x5EE2,
0x9c46,0x5EE1,
0x9c47,0x5EE8,
0x9c48,0x5EE9,
0x9c49,0x5EEC,
0x9c4a,0x5EF1,
0x9c4b,0x5EF3,
0x9c4c,0x5EF0,
0x9c4d,0x5EF4,
0x9c4e,0x5EF8,
0x9c4f,0x5EFE,
0x9c50,0x5F03,
0x9c51,0x5F09,
0x9c52,0x5F5D,
0x9c53,0x5F5C,
0x9c54,0x5F0B,
0x9c55,0x5F11,
0x9c56,0x5F16,
0x9c57,0x5F29,
0x9c58,0x5F2D,
0x9c59,0x5F38,
0x9c5a,0x5F41,
0x9c5b,0x5F48,
0x9c5c,0x5F4C,
0x9c5d,0x5F4E,
0x9c5e,0x5F2F,
0x9c5f,0x5F51,
0x9c60,0x5F56,
0x9c61,0x5F57,
0x9c62,0x5F59,
0x9c63,0x5F61,
0x9c64,0x5F6D,
0x9c65,0x5F73,
0x9c66,0x5F77,
0x9c67,0x5F83,
0x9c68,0x5F82,
0x9c69,0x5F7F,
0x9c6a,0x5F8A,
0x9c6b,0x5F88,
0x9c6c,0x5F91,
0x9c6d,0x5F87,
0x9c6e,0x5F9E,
0x9c6f,0x5F99,
0x9c70,0x5F98,
0x9c71,0x5FA0,
0x9c72,0x5FA8,
0x9c73,0x5FAD,
0x9c74,0x5FBC,
0x9c75,0x5FD6,
0x9c76,0x5FFB,
0x9c77,0x5FE4,
0x9c78,0x5FF8,
0x9c79,0x5FF1,
0x9c7a,0x5FDD,
0x9c7b,0x60B3,
0x9c7c,0x5FFF,
0x9c7d,0x6021,
0x9c7e,0x6060,
0x9c7f,0x6019,
0x9c81,0x6010,
0x9c82,0x6029,
0x9c83,0x600E,
0x9c84,0x6031,
0x9c85,0x601B,
0x9c86,0x6015,
0x9c87,0x602B,
0x9c88,0x6026,
0x9c89,0x600F,
0x9c8a,0x603A,
0x9c8b,0x605A,
0x9c8c,0x6041,
0x9c8d,0x606A,
0x9c8e,0x6077,
0x9c8f,0x605F,
0x9c90,0x604A,
0x9c91,0x6046,
0x9c92,0x604D,
0x9c93,0x6063,
0x9c94,0x6043,
0x9c95,0x6064,
0x9c96,0x6042,
0x9c97,0x606C,
0x9c98,0x606B,
0x9c99,0x6059,
0x9c9a,0x6081,
0x9c9b,0x608D,
0x9c9c,0x60E7,
0x9c9d,0x6083,
0x9c9e,0x609A,
0x9c9f,0x6084,
0x9ca0,0x609B,
0x9ca1,0x6096,
0x9ca2,0x6097,
0x9ca3,0x6092,
0x9ca4,0x60A7,
0x9ca5,0x608B,
0x9ca6,0x60E1,
0x9ca7,0x60B8,
0x9ca8,0x60E0,
0x9ca9,0x60D3,
0x9caa,0x60B4,
0x9cab,0x5FF0,
0x9cac,0x60BD,
0x9cad,0x60C6,
0x9cae,0x60B5,
0x9caf,0x60D8,
0x9cb0,0x614D,
0x9cb1,0x6115,
0x9cb2,0x6106,
0x9cb3,0x60F6,
0x9cb4,0x60F7,
0x9cb5,0x6100,
0x9cb6,0x60F4,
0x9cb7,0x60FA,
0x9cb8,0x6103,
0x9cb9,0x6121,
0x9cba,0x60FB,
0x9cbb,0x60F1,
0x9cbc,0x610D,
0x9cbd,0x610E,
0x9cbe,0x6147,
0x9cbf,0x613E,
0x9cc0,0x6128,
0x9cc1,0x6127,
0x9cc2,0x614A,
0x9cc3,0x613F,
0x9cc4,0x613C,
0x9cc5,0x612C,
0x9cc6,0x6134,
0x9cc7,0x613D,
0x9cc8,0x6142,
0x9cc9,0x6144,
0x9cca,0x6173,
0x9ccb,0x6177,
0x9ccc,0x6158,
0x9ccd,0x6159,
0x9cce,0x615A,
0x9ccf,0x616B,
0x9cd0,0x6174,
0x9cd1,0x616F,
0x9cd2,0x6165,
0x9cd3,0x6171,
0x9cd4,0x615F,
0x9cd5,0x615D,
0x9cd6,0x6153,
0x9cd7,0x6175,
0x9cd8,0x6199,
0x9cd9,0x6196,
0x9cda,0x6187,
0x9cdb,0x61AC,
0x9cdc,0x6194,
0x9cdd,0x619A,
0x9cde,0x618A,
0x9cdf,0x6191,
0x9ce0,0x61AB,
0x9ce1,0x61AE,
0x9ce2,0x61CC,
0x9ce3,0x61CA,
0x9ce4,0x61C9,
0x9ce5,0x61F7,
0x9ce6,0x61C8,
0x9ce7,0x61C3,
0x9ce8,0x61C6,
0x9ce9,0x61BA,
0x9cea,0x61CB,
0x9ceb,0x7F79,
0x9cec,0x61CD,
0x9ced,0x61E6,
0x9cee,0x61E3,
0x9cef,0x61F6,
0x9cf0,0x61FA,
0x9cf1,0x61F4,
0x9cf2,0x61FF,
0x9cf3,0x61FD,
0x9cf4,0x61FC,
0x9cf5,0x61FE,
0x9cf6,0x6200,
0x9cf7,0x6208,
0x9cf8,0x6209,
0x9cf9,0x620D,
0x9cfa,0x620C,
0x9cfb,0x6214,
0x9cfc,0x621B,
0x9d40,0x621E,
0x9d41,0x6221,
0x9d42,0x622A,
0x9d43,0x622E,
0x9d44,0x6230,
0x9d45,0x6232,
0x9d46,0x6233,
0x9d47,0x6241,
0x9d48,0x624E,
0x9d49,0x625E,
0x9d4a,0x6263,
0x9d4b,0x625B,
0x9d4c,0x6260,
0x9d4d,0x6268,
0x9d4e,0x627C,
0x9d4f,0x6282,
0x9d50,0x6289,
0x9d51,0x627E,
0x9d52,0x6292,
0x9d53,0x6293,
0x9d54,0x6296,
0x9d55,0x62D4,
0x9d56,0x6283,
0x9d57,0x6294,
0x9d58,0x62D7,
0x9d59,0x62D1,
0x9d5a,0x62BB,
0x9d5b,0x62CF,
0x9d5c,0x62FF,
0x9d5d,0x62C6,
0x9d5e,0x64D4,
0x9d5f,0x62C8,
0x9d60,0x62DC,
0x9d61,0x62CC,
0x9d62,0x62CA,
0x9d63,0x62C2,
0x9d64,0x62C7,
0x9d65,0x629B,
0x9d66,0x62C9,
0x9d67,0x630C,
0x9d68,0x62EE,
0x9d69,0x62F1,
0x9d6a,0x6327,
0x9d6b,0x6302,
0x9d6c,0x6308,
0x9d6d,0x62EF,
0x9d6e,0x62F5,
0x9d6f,0x6350,
0x9d70,0x633E,
0x9d71,0x634D,
0x9d72,0x641C,
0x9d73,0x634F,
0x9d74,0x6396,
0x9d75,0x638E,
0x9d76,0x6380,
0x9d77,0x63AB,
0x9d78,0x6376,
0x9d79,0x63A3,
0x9d7a,0x638F,
0x9d7b,0x6389,
0x9d7c,0x639F,
0x9d7d,0x63B5,
0x9d7e,0x636B,
0x9d7f,0x6369,
0x9d81,0x63BE,
0x9d82,0x63E9,
0x9d83,0x63C0,
0x9d84,0x63C6,
0x9d85,0x63E3,
0x9d86,0x63C9,
0x9d87,0x63D2,
0x9d88,0x63F6,
0x9d89,0x63C4,
0x9d8a,0x6416,
0x9d8b,0x6434,
0x9d8c,0x6406,
0x9d8d,0x6413,
0x9d8e,0x6426,
0x9d8f,0x6436,
0x9d90,0x651D,
0x9d91,0x6417,
0x9d92,0x6428,
0x9d93,0x640F,
0x9d94,0x6467,
0x9d95,0x646F,
0x9d96,0x6476,
0x9d97,0x644E,
0x9d98,0x652A,
0x9d99,0x6495,
0x9d9a,0x6493,
0x9d9b,0x64A5,
0x9d9c,0x64A9,
0x9d9d,0x6488,
0x9d9e,0x64BC,
0x9d9f,0x64DA,
0x9da0,0x64D2,
0x9da1,0x64C5,
0x9da2,0x64C7,
0x9da3,0x64BB,
0x9da4,0x64D8,
0x9da5,0x64C2,
0x9da6,0x64F1,
0x9da7,0x64E7,
0x9da8,0x8209,
0x9da9,0x64E0,
0x9daa,0x64E1,
0x9dab,0x62AC,
0x9dac,0x64E3,
0x9dad,0x64EF,
0x9dae,0x652C,
0x9daf,0x64F6,
0x9db0,0x64F4,
0x9db1,0x64F2,
0x9db2,0x64FA,
0x9db3,0x6500,
0x9db4,0x64FD,
0x9db5,0x6518,
0x9db6,0x651C,
0x9db7,0x6505,
0x9db8,0x6524,
0x9db9,0x6523,
0x9dba,0x652B,
0x9dbb,0x6534,
0x9dbc,0x6535,
0x9dbd,0x6537,
0x9dbe,0x6536,
0x9dbf,0x6538,
0x9dc0,0x754B,
0x9dc1,0x6548,
0x9dc2,0x6556,
0x9dc3,0x6555,
0x9dc4,0x654D,
0x9dc5,0x6558,
0x9dc6,0x655E,
0x9dc7,0x655D,
0x9dc8,0x6572,
0x9dc9,0x6578,
0x9dca,0x6582,
0x9dcb,0x6583,
0x9dcc,0x8B8A,
0x9dcd,0x659B,
0x9dce,0x659F,
0x9dcf,0x65AB,
0x9dd0,0x65B7,
0x9dd1,0x65C3,
0x9dd2,0x65C6,
0x9dd3,0x65C1,
0x9dd4,0x65C4,
0x9dd5,0x65CC,
0x9dd6,0x65D2,
0x9dd7,0x65DB,
0x9dd8,0x65D9,
0x9dd9,0x65E0,
0x9dda,0x65E1,
0x9ddb,0x65F1,
0x9ddc,0x6772,
0x9ddd,0x660A,
0x9dde,0x6603,
0x9ddf,0x65FB,
0x9de0,0x6773,
0x9de1,0x6635,
0x9de2,0x6636,
0x9de3,0x6634,
0x9de4,0x661C,
0x9de5,0x664F,
0x9de6,0x6644,
0x9de7,0x6649,
0x9de8,0x6641,
0x9de9,0x665E,
0x9dea,0x665D,
0x9deb,0x6664,
0x9dec,0x6667,
0x9ded,0x6668,
0x9dee,0x665F,
0x9def,0x6662,
0x9df0,0x6670,
0x9df1,0x6683,
0x9df2,0x6688,
0x9df3,0x668E,
0x9df4,0x6689,
0x9df5,0x6684,
0x9df6,0x6698,
0x9df7,0x669D,
0x9df8,0x66C1,
0x9df9,0x66B9,
0x9dfa,0x66C9,
0x9dfb,0x66BE,
0x9dfc,0x66BC,
0x9e40,0x66C4,
0x9e41,0x66B8,
0x9e42,0x66D6,
0x9e43,0x66DA,
0x9e44,0x66E0,
0x9e45,0x663F,
0x9e46,0x66E6,
0x9e47,0x66E9,
0x9e48,0x66F0,
0x9e49,0x66F5,
0x9e4a,0x66F7,
0x9e4b,0x670F,
0x9e4c,0x6716,
0x9e4d,0x671E,
0x9e4e,0x6726,
0x9e4f,0x6727,
0x9e50,0x9738,
0x9e51,0x672E,
0x9e52,0x673F,
0x9e53,0x6736,
0x9e54,0x6741,
0x9e55,0x6738,
0x9e56,0x6737,
0x9e57,0x6746,
0x9e58,0x675E,
0x9e59,0x6760,
0x9e5a,0x6759,
0x9e5b,0x6763,
0x9e5c,0x6764,
0x9e5d,0x6789,
0x9e5e,0x6770,
0x9e5f,0x67A9,
0x9e60,0x677C,
0x9e61,0x676A,
0x9e62,0x678C,
0x9e63,0x678B,
0x9e64,0x67A6,
0x9e65,0x67A1,
0x9e66,0x6785,
0x9e67,0x67B7,
0x9e68,0x67EF,
0x9e69,0x67B4,
0x9e6a,0x67EC,
0x9e6b,0x67B3,
0x9e6c,0x67E9,
0x9e6d,0x67B8,
0x9e6e,0x67E4,
0x9e6f,0x67DE,
0x9e70,0x67DD,
0x9e71,0x67E2,
0x9e72,0x67EE,
0x9e73,0x67B9,
0x9e74,0x67CE,
0x9e75,0x67C6,
0x9e76,0x67E7,
0x9e77,0x6A9C,
0x9e78,0x681E,
0x9e79,0x6846,
0x9e7a,0x6829,
0x9e7b,0x6840,
0x9e7c,0x684D,
0x9e7d,0x6832,
0x9e7e,0x684E,
0x9e7f,0x68B3,
0x9e81,0x682B,
0x9e82,0x6859,
0x9e83,0x6863,
0x9e84,0x6877,
0x9e85,0x687F,
0x9e86,0x689F,
0x9e87,0x688F,
0x9e88,0x68AD,
0x9e89,0x6894,
0x9e8a,0x689D,
0x9e8b,0x689B,
0x9e8c,0x6883,
0x9e8d,0x6AAE,
0x9e8e,0x68B9,
0x9e8f,0x6874,
0x9e90,0x68B5,
0x9e91,0x68A0,
0x9e92,0x68BA,
0x9e93,0x690F,
0x9e94,0x688D,
0x9e95,0x687E,
0x9e96,0x6901,
0x9e97,0x68CA,
0x9e98,0x6908,
0x9e99,0x68D8,
0x9e9a,0x6922,
0x9e9b,0x6926,
0x9e9c,0x68E1,
0x9e9d,0x690C,
0x9e9e,0x68CD,
0x9e9f,0x68D4,
0x9ea0,0x68E7,
0x9ea1,0x68D5,
0x9ea2,0x6936,
0x9ea3,0x6912,
0x9ea4,0x6904,
0x9ea5,0x68D7,
0x9ea6,0x68E3,
0x9ea7,0x6925,
0x9ea8,0x68F9,
0x9ea9,0x68E0,
0x9eaa,0x68EF,
0x9eab,0x6928,
0x9eac,0x692A,
0x9ead,0x691A,
0x9eae,0x6923,
0x9eaf,0x6921,
0x9eb0,0x68C6,
0x9eb1,0x6979,
0x9eb2,0x6977,
0x9eb3,0x695C,
0x9eb4,0x6978,
0x9eb5,0x696B,
0x9eb6,0x6954,
0x9eb7,0x697E,
0x9eb8,0x696E,
0x9eb9,0x6939,
0x9eba,0x6974,
0x9ebb,0x693D,
0x9ebc,0x6959,
0x9ebd,0x6930,
0x9ebe,0x6961,
0x9ebf,0x695E,
0x9ec0,0x695D,
0x9ec1,0x6981,
0x9ec2,0x696A,
0x9ec3,0x69B2,
0x9ec4,0x69AE,
0x9ec5,0x69D0,
0x9ec6,0x69BF,
0x9ec7,0x69C1,
0x9ec8,0x69D3,
0x9ec9,0x69BE,
0x9eca,0x69CE,
0x9ecb,0x5BE8,
0x9ecc,0x69CA,
0x9ecd,0x69DD,
0x9ece,0x69BB,
0x9ecf,0x69C3,
0x9ed0,0x69A7,
0x9ed1,0x6A2E,
0x9ed2,0x6991,
0x9ed3,0x69A0,
0x9ed4,0x699C,
0x9ed5,0x6995,
0x9ed6,0x69B4,
0x9ed7,0x69DE,
0x9ed8,0x69E8,
0x9ed9,0x6A02,
0x9eda,0x6A1B,
0x9edb,0x69FF,
0x9edc,0x6B0A,
0x9edd,0x69F9,
0x9ede,0x69F2,
0x9edf,0x69E7,
0x9ee0,0x6A05,
0x9ee1,0x69B1,
0x9ee2,0x6A1E,
0x9ee3,0x69ED,
0x9ee4,0x6A14,
0x9ee5,0x69EB,
0x9ee6,0x6A0A,
0x9ee7,0x6A12,
0x9ee8,0x6AC1,
0x9ee9,0x6A23,
0x9eea,0x6A13,
0x9eeb,0x6A44,
0x9eec,0x6A0C,
0x9eed,0x6A72,
0x9eee,0x6A36,
0x9eef,0x6A78,
0x9ef0,0x6A47,
0x9ef1,0x6A62,
0x9ef2,0x6A59,
0x9ef3,0x6A66,
0x9ef4,0x6A48,
0x9ef5,0x6A38,
0x9ef6,0x6A22,
0x9ef7,0x6A90,
0x9ef8,0x6A8D,
0x9ef9,0x6AA0,
0x9efa,0x6A84,
0x9efb,0x6AA2,
0x9efc,0x6AA3,
0x9f40,0x6A97,
0x9f41,0x8617,
0x9f42,0x6ABB,
0x9f43,0x6AC3,
0x9f44,0x6AC2,
0x9f45,0x6AB8,
0x9f46,0x6AB3,
0x9f47,0x6AAC,
0x9f48,0x6ADE,
0x9f49,0x6AD1,
0x9f4a,0x6ADF,
0x9f4b,0x6AAA,
0x9f4c,0x6ADA,
0x9f4d,0x6AEA,
0x9f4e,0x6AFB,
0x9f4f,0x6B05,
0x9f50,0x8616,
0x9f51,0x6AFA,
0x9f52,0x6B12,
0x9f53,0x6B16,
0x9f54,0x9B31,
0x9f55,0x6B1F,
0x9f56,0x6B38,
0x9f57,0x6B37,
0x9f58,0x76DC,
0x9f59,0x6B39,
0x9f5a,0x98EE,
0x9f5b,0x6B47,
0x9f5c,0x6B43,
0x9f5d,0x6B49,
0x9f5e,0x6B50,
0x9f5f,0x6B59,
0x9f60,0x6B54,
0x9f61,0x6B5B,
0x9f62,0x6B5F,
0x9f63,0x6B61,
0x9f64,0x6B78,
0x9f65,0x6B79,
0x9f66,0x6B7F,
0x9f67,0x6B80,
0x9f68,0x6B84,
0x9f69,0x6B83,
0x9f6a,0x6B8D,
0x9f6b,0x6B98,
0x9f6c,0x6B95,
0x9f6d,0x6B9E,
0x9f6e,0x6BA4,
0x9f6f,0x6BAA,
0x9f70,0x6BAB,
0x9f71,0x6BAF,
0x9f72,0x6BB2,
0x9f73,0x6BB1,
0x9f74,0x6BB3,
0x9f75,0x6BB7,
0x9f76,0x6BBC,
0x9f77,0x6BC6,
0x9f78,0x6BCB,
0x9f79,0x6BD3,
0x9f7a,0x6BDF,
0x9f7b,0x6BEC,
0x9f7c,0x6BEB,
0x9f7d,0x6BF3,
0x9f7e,0x6BEF,
0x9f7f,0x9EBE,
0x9f81,0x6C08,
0x9f82,0x6C13,
0x9f83,0x6C14,
0x9f84,0x6C1B,
0x9f85,0x6C24,
0x9f86,0x6C23,
0x9f87,0x6C5E,
0x9f88,0x6C55,
0x9f89,0x6C62,
0x9f8a,0x6C6A,
0x9f8b,0x6C82,
0x9f8c,0x6C8D,
0x9f8d,0x6C9A,
0x9f8e,0x6C81,
0x9f8f,0x6C9B,
0x9f90,0x6C7E,
0x9f91,0x6C68,
0x9f92,0x6C73,
0x9f93,0x6C92,
0x9f94,0x6C90,
0x9f95,0x6CC4,
0x9f96,0x6CF1,
0x9f97,0x6CD3,
0x9f98,0x6CBD,
0x9f99,0x6CD7,
0x9f9a,0x6CC5,
0x9f9b,0x6CDD,
0x9f9c,0x6CAE,
0x9f9d,0x6CB1,
0x9f9e,0x6CBE,
0x9f9f,0x6CBA,
0x9fa0,0x6CDB,
0x9fa1,0x6CEF,
0x9fa2,0x6CD9,
0x9fa3,0x6CEA,
0x9fa4,0x6D1F,
0x9fa5,0x884D,
0x9fa6,0x6D36,
0x9fa7,0x6D2B,
0x9fa8,0x6D3D,
0x9fa9,0x6D38,
0x9faa,0x6D19,
0x9fab,0x6D35,
0x9fac,0x6D33,
0x9fad,0x6D12,
0x9fae,0x6D0C,
0x9faf,0x6D63,
0x9fb0,0x6D93,
0x9fb1,0x6D64,
0x9fb2,0x6D5A,
0x9fb3,0x6D79,
0x9fb4,0x6D59,
0x9fb5,0x6D8E,
0x9fb6,0x6D95,
0x9fb7,0x6FE4,
0x9fb8,0x6D85,
0x9fb9,0x6DF9,
0x9fba,0x6E15,
0x9fbb,0x6E0A,
0x9fbc,0x6DB5,
0x9fbd,0x6DC7,
0x9fbe,0x6DE6,
0x9fbf,0x6DB8,
0x9fc0,0x6DC6,
0x9fc1,0x6DEC,
0x9fc2,0x6DDE,
0x9fc3,0x6DCC,
0x9fc4,0x6DE8,
0x9fc5,0x6DD2,
0x9fc6,0x6DC5,
0x9fc7,0x6DFA,
0x9fc8,0x6DD9,
0x9fc9,0x6DE4,
0x9fca,0x6DD5,
0x9fcb,0x6DEA,
0x9fcc,0x6DEE,
0x9fcd,0x6E2D,
0x9fce,0x6E6E,
0x9fcf,0x6E2E,
0x9fd0,0x6E19,
0x9fd1,0x6E72,
0x9fd2,0x6E5F,
0x9fd3,0x6E3E,
0x9fd4,0x6E23,
0x9fd5,0x6E6B,
0x9fd6,0x6E2B,
0x9fd7,0x6E76,
0x9fd8,0x6E4D,
0x9fd9,0x6E1F,
0x9fda,0x6E43,
0x9fdb,0x6E3A,
0x9fdc,0x6E4E,
0x9fdd,0x6E24,
0x9fde,0x6EFF,
0x9fdf,0x6E1D,
0x9fe0,0x6E38,
0x9fe1,0x6E82,
0x9fe2,0x6EAA,
0x9fe3,0x6E98,
0x9fe4,0x6EC9,
0x9fe5,0x6EB7,
0x9fe6,0x6ED3,
0x9fe7,0x6EBD,
0x9fe8,0x6EAF,
0x9fe9,0x6EC4,
0x9fea,0x6EB2,
0x9feb,0x6ED4,
0x9fec,0x6ED5,
0x9fed,0x6E8F,
0x9fee,0x6EA5,
0x9fef,0x6EC2,
0x9ff0,0x6E9F,
0x9ff1,0x6F41,
0x9ff2,0x6F11,
0x9ff3,0x704C,
0x9ff4,0x6EEC,
0x9ff5,0x6EF8,
0x9ff6,0x6EFE,
0x9ff7,0x6F3F,
0x9ff8,0x6EF2,
0x9ff9,0x6F31,
0x9ffa,0x6EEF,
0x9ffb,0x6F32,
0x9ffc,0x6ECC,
0xe040,0x6F3E,
0xe041,0x6F13,
0xe042,0x6EF7,
0xe043,0x6F86,
0xe044,0x6F7A,
0xe045,0x6F78,
0xe046,0x6F81,
0xe047,0x6F80,
0xe048,0x6F6F,
0xe049,0x6F5B,
0xe04a,0x6FF3,
0xe04b,0x6F6D,
0xe04c,0x6F82,
0xe04d,0x6F7C,
0xe04e,0x6F58,
0xe04f,0x6F8E,
0xe050,0x6F91,
0xe051,0x6FC2,
0xe052,0x6F66,
0xe053,0x6FB3,
0xe054,0x6FA3,
0xe055,0x6FA1,
0xe056,0x6FA4,
0xe057,0x6FB9,
0xe058,0x6FC6,
0xe059,0x6FAA,
0xe05a,0x6FDF,
0xe05b,0x6FD5,
0xe05c,0x6FEC,
0xe05d,0x6FD4,
0xe05e,0x6FD8,
0xe05f,0x6FF1,
0xe060,0x6FEE,
0xe061,0x6FDB,
0xe062,0x7009,
0xe063,0x700B,
0xe064,0x6FFA,
0xe065,0x7011,
0xe066,0x7001,
0xe067,0x700F,
0xe068,0x6FFE,
0xe069,0x701B,
0xe06a,0x701A,
0xe06b,0x6F74,
0xe06c,0x701D,
0xe06d,0x7018,
0xe06e,0x701F,
0xe06f,0x7030,
0xe070,0x703E,
0xe071,0x7032,
0xe072,0x7051,
0xe073,0x7063,
0xe074,0x7099,
0xe075,0x7092,
0xe076,0x70AF,
0xe077,0x70F1,
0xe078,0x70AC,
0xe079,0x70B8,
0xe07a,0x70B3,
0xe07b,0x70AE,
0xe07c,0x70DF,
0xe07d,0x70CB,
0xe07e,0x70DD,
0xe07f,0x70D9,
0xe081,0x7109,
0xe082,0x70FD,
0xe083,0x711C,
0xe084,0x7119,
0xe085,0x7165,
0xe086,0x7155,
0xe087,0x7188,
0xe088,0x7166,
0xe089,0x7162,
0xe08a,0x714C,
0xe08b,0x7156,
0xe08c,0x716C,
0xe08d,0x718F,
0xe08e,0x71FB,
0xe08f,0x7184,
0xe090,0x7195,
0xe091,0x71A8,
0xe092,0x71AC,
0xe093,0x71D7,
0xe094,0x71B9,
0xe095,0x71BE,
0xe096,0x71D2,
0xe097,0x71C9,
0xe098,0x71D4,
0xe099,0x71CE,
0xe09a,0x71E0,
0xe09b,0x71EC,
0xe09c,0x71E7,
0xe09d,0x71F5,
0xe09e,0x71FC,
0xe09f,0x71F9,
0xe0a0,0x71FF,
0xe0a1,0x720D,
0xe0a2,0x7210,
0xe0a3,0x721B,
0xe0a4,0x7228,
0xe0a5,0x722D,
0xe0a6,0x722C,
0xe0a7,0x7230,
0xe0a8,0x7232,
0xe0a9,0x723B,
0xe0aa,0x723C,
0xe0ab,0x723F,
0xe0ac,0x7240,
0xe0ad,0x7246,
0xe0ae,0x724B,
0xe0af,0x7258,
0xe0b0,0x7274,
0xe0b1,0x727E,
0xe0b2,0x7282,
0xe0b3,0x7281,
0xe0b4,0x7287,
0xe0b5,0x7292,
0xe0b6,0x7296,
0xe0b7,0x72A2,
0xe0b8,0x72A7,
0xe0b9,0x72B9,
0xe0ba,0x72B2,
0xe0bb,0x72C3,
0xe0bc,0x72C6,
0xe0bd,0x72C4,
0xe0be,0x72CE,
0xe0bf,0x72D2,
0xe0c0,0x72E2,
0xe0c1,0x72E0,
0xe0c2,0x72E1,
0xe0c3,0x72F9,
0xe0c4,0x72F7,
0xe0c5,0x500F,
0xe0c6,0x7317,
0xe0c7,0x730A,
0xe0c8,0x731C,
0xe0c9,0x7316,
0xe0ca,0x731D,
0xe0cb,0x7334,
0xe0cc,0x732F,
0xe0cd,0x7329,
0xe0ce,0x7325,
0xe0cf,0x733E,
0xe0d0,0x734E,
0xe0d1,0x734F,
0xe0d2,0x9ED8,
0xe0d3,0x7357,
0xe0d4,0x736A,
0xe0d5,0x7368,
0xe0d6,0x7370,
0xe0d7,0x7378,
0xe0d8,0x7375,
0xe0d9,0x737B,
0xe0da,0x737A,
0xe0db,0x73C8,
0xe0dc,0x73B3,
0xe0dd,0x73CE,
0xe0de,0x73BB,
0xe0df,0x73C0,
0xe0e0,0x73E5,
0xe0e1,0x73EE,
0xe0e2,0x73DE,
0xe0e3,0x74A2,
0xe0e4,0x7405,
0xe0e5,0x746F,
0xe0e6,0x7425,
0xe0e7,0x73F8,
0xe0e8,0x7432,
0xe0e9,0x743A,
0xe0ea,0x7455,
0xe0eb,0x743F,
0xe0ec,0x745F,
0xe0ed,0x7459,
0xe0ee,0x7441,
0xe0ef,0x745C,
0xe0f0,0x7469,
0xe0f1,0x7470,
0xe0f2,0x7463,
0xe0f3,0x746A,
0xe0f4,0x7476,
0xe0f5,0x747E,
0xe0f6,0x748B,
0xe0f7,0x749E,
0xe0f8,0x74A7,
0xe0f9,0x74CA,
0xe0fa,0x74CF,
0xe0fb,0x74D4,
0xe0fc,0x73F1,
0xe140,0x74E0,
0xe141,0x74E3,
0xe142,0x74E7,
0xe143,0x74E9,
0xe144,0x74EE,
0xe145,0x74F2,
0xe146,0x74F0,
0xe147,0x74F1,
0xe148,0x74F8,
0xe149,0x74F7,
0xe14a,0x7504,
0xe14b,0x7503,
0xe14c,0x7505,
0xe14d,0x750C,
0xe14e,0x750E,
0xe14f,0x750D,
0xe150,0x7515,
0xe151,0x7513,
0xe152,0x751E,
0xe153,0x7526,
0xe154,0x752C,
0xe155,0x753C,
0xe156,0x7544,
0xe157,0x754D,
0xe158,0x754A,
0xe159,0x7549,
0xe15a,0x755B,
0xe15b,0x7546,
0xe15c,0x755A,
0xe15d,0x7569,
0xe15e,0x7564,
0xe15f,0x7567,
0xe160,0x756B,
0xe161,0x756D,
0xe162,0x7578,
0xe163,0x7576,
0xe164,0x7586,
0xe165,0x7587,
0xe166,0x7574,
0xe167,0x758A,
0xe168,0x7589,
0xe169,0x7582,
0xe16a,0x7594,
0xe16b,0x759A,
0xe16c,0x759D,
0xe16d,0x75A5,
0xe16e,0x75A3,
0xe16f,0x75C2,
0xe170,0x75B3,
0xe171,0x75C3,
0xe172,0x75B5,
0xe173,0x75BD,
0xe174,0x75B8,
0xe175,0x75BC,
0xe176,0x75B1,
0xe177,0x75CD,
0xe178,0x75CA,
0xe179,0x75D2,
0xe17a,0x75D9,
0xe17b,0x75E3,
0xe17c,0x75DE,
0xe17d,0x75FE,
0xe17e,0x75FF,
0xe17f,0x75FC,
0xe181,0x7601,
0xe182,0x75F0,
0xe183,0x75FA,
0xe184,0x75F2,
0xe185,0x75F3,
0xe186,0x760B,
0xe187,0x760D,
0xe188,0x7609,
0xe189,0x761F,
0xe18a,0x7627,
0xe18b,0x7620,
0xe18c,0x7621,
0xe18d,0x7622,
0xe18e,0x7624,
0xe18f,0x7634,
0xe190,0x7630,
0xe191,0x763B,
0xe192,0x7647,
0xe193,0x7648,
0xe194,0x7646,
0xe195,0x765C,
0xe196,0x7658,
0xe197,0x7661,
0xe198,0x7662,
0xe199,0x7668,
0xe19a,0x7669,
0xe19b,0x766A,
0xe19c,0x7667,
0xe19d,0x766C,
0xe19e,0x7670,
0xe19f,0x7672,
0xe1a0,0x7676,
0xe1a1,0x7678,
0xe1a2,0x767C,
0xe1a3,0x7680,
0xe1a4,0x7683,
0xe1a5,0x7688,
0xe1a6,0x768B,
0xe1a7,0x768E,
0xe1a8,0x7696,
0xe1a9,0x7693,
0xe1aa,0x7699,
0xe1ab,0x769A,
0xe1ac,0x76B0,
0xe1ad,0x76B4,
0xe1ae,0x76B8,
0xe1af,0x76B9,
0xe1b0,0x76BA,
0xe1b1,0x76C2,
0xe1b2,0x76CD,
0xe1b3,0x76D6,
0xe1b4,0x76D2,
0xe1b5,0x76DE,
0xe1b6,0x76E1,
0xe1b7,0x76E5,
0xe1b8,0x76E7,
0xe1b9,0x76EA,
0xe1ba,0x862F,
0xe1bb,0x76FB,
0xe1bc,0x7708,
0xe1bd,0x7707,
0xe1be,0x7704,
0xe1bf,0x7729,
0xe1c0,0x7724,
0xe1c1,0x771E,
0xe1c2,0x7725,
0xe1c3,0x7726,
0xe1c4,0x771B,
0xe1c5,0x7737,
0xe1c6,0x7738,
0xe1c7,0x7747,
0xe1c8,0x775A,
0xe1c9,0x7768,
0xe1ca,0x776B,
0xe1cb,0x775B,
0xe1cc,0x7765,
0xe1cd,0x777F,
0xe1ce,0x777E,
0xe1cf,0x7779,
0xe1d0,0x778E,
0xe1d1,0x778B,
0xe1d2,0x7791,
0xe1d3,0x77A0,
0xe1d4,0x779E,
0xe1d5,0x77B0,
0xe1d6,0x77B6,
0xe1d7,0x77B9,
0xe1d8,0x77BF,
0xe1d9,0x77BC,
0xe1da,0x77BD,
0xe1db,0x77BB,
0xe1dc,0x77C7,
0xe1dd,0x77CD,
0xe1de,0x77D7,
0xe1df,0x77DA,
0xe1e0,0x77DC,
0xe1e1,0x77E3,
0xe1e2,0x77EE,
0xe1e3,0x77FC,
0xe1e4,0x780C,
0xe1e5,0x7812,
0xe1e6,0x7926,
0xe1e7,0x7820,
0xe1e8,0x792A,
0xe1e9,0x7845,
0xe1ea,0x788E,
0xe1eb,0x7874,
0xe1ec,0x7886,
0xe1ed,0x787C,
0xe1ee,0x789A,
0xe1ef,0x788C,
0xe1f0,0x78A3,
0xe1f1,0x78B5,
0xe1f2,0x78AA,
0xe1f3,0x78AF,
0xe1f4,0x78D1,
0xe1f5,0x78C6,
0xe1f6,0x78CB,
0xe1f7,0x78D4,
0xe1f8,0x78BE,
0xe1f9,0x78BC,
0xe1fa,0x78C5,
0xe1fb,0x78CA,
0xe1fc,0x78EC,
0xe240,0x78E7,
0xe241,0x78DA,
0xe242,0x78FD,
0xe243,0x78F4,
0xe244,0x7907,
0xe245,0x7912,
0xe246,0x7911,
0xe247,0x7919,
0xe248,0x792C,
0xe249,0x792B,
0xe24a,0x7940,
0xe24b,0x7960,
0xe24c,0x7957,
0xe24d,0x795F,
0xe24e,0x795A,
0xe24f,0x7955,
0xe250,0x7953,
0xe251,0x797A,
0xe252,0x797F,
0xe253,0x798A,
0xe254,0x799D,
0xe255,0x79A7,
0xe256,0x9F4B,
0xe257,0x79AA,
0xe258,0x79AE,
0xe259,0x79B3,
0xe25a,0x79B9,
0xe25b,0x79BA,
0xe25c,0x79C9,
0xe25d,0x79D5,
0xe25e,0x79E7,
0xe25f,0x79EC,
0xe260,0x79E1,
0xe261,0x79E3,
0xe262,0x7A08,
0xe263,0x7A0D,
0xe264,0x7A18,
0xe265,0x7A19,
0xe266,0x7A20,
0xe267,0x7A1F,
0xe268,0x7980,
0xe269,0x7A31,
0xe26a,0x7A3B,
0xe26b,0x7A3E,
0xe26c,0x7A37,
0xe26d,0x7A43,
0xe26e,0x7A57,
0xe26f,0x7A49,
0xe270,0x7A61,
0xe271,0x7A62,
0xe272,0x7A69,
0xe273,0x9F9D,
0xe274,0x7A70,
0xe275,0x7A79,
0xe276,0x7A7D,
0xe277,0x7A88,
0xe278,0x7A97,
0xe279,0x7A95,
0xe27a,0x7A98,
0xe27b,0x7A96,
0xe27c,0x7AA9,
0xe27d,0x7AC8,
0xe27e,0x7AB0,
0xe27f,0x7AB6,
0xe281,0x7AC5,
0xe282,0x7AC4,
0xe283,0x7ABF,
0xe284,0x9083,
0xe285,0x7AC7,
0xe286,0x7ACA,
0xe287,0x7ACD,
0xe288,0x7ACF,
0xe289,0x7AD5,
0xe28a,0x7AD3,
0xe28b,0x7AD9,
0xe28c,0x7ADA,
0xe28d,0x7ADD,
0xe28e,0x7AE1,
0xe28f,0x7AE2,
0xe290,0x7AE6,
0xe291,0x7AED,
0xe292,0x7AF0,
0xe293,0x7B02,
0xe294,0x7B0F,
0xe295,0x7B0A,
0xe296,0x7B06,
0xe297,0x7B33,
0xe298,0x7B18,
0xe299,0x7B19,
0xe29a,0x7B1E,
0xe29b,0x7B35,
0xe29c,0x7B28,
0xe29d,0x7B36,
0xe29e,0x7B50,
0xe29f,0x7B7A,
0xe2a0,0x7B04,
0xe2a1,0x7B4D,
0xe2a2,0x7B0B,
0xe2a3,0x7B4C,
0xe2a4,0x7B45,
0xe2a5,0x7B75,
0xe2a6,0x7B65,
0xe2a7,0x7B74,
0xe2a8,0x7B67,
0xe2a9,0x7B70,
0xe2aa,0x7B71,
0xe2ab,0x7B6C,
0xe2ac,0x7B6E,
0xe2ad,0x7B9D,
0xe2ae,0x7B98,
0xe2af,0x7B9F,
0xe2b0,0x7B8D,
0xe2b1,0x7B9C,
0xe2b2,0x7B9A,
0xe2b3,0x7B8B,
0xe2b4,0x7B92,
0xe2b5,0x7B8F,
0xe2b6,0x7B5D,
0xe2b7,0x7B99,
0xe2b8,0x7BCB,
0xe2b9,0x7BC1,
0xe2ba,0x7BCC,
0xe2bb,0x7BCF,
0xe2bc,0x7BB4,
0xe2bd,0x7BC6,
0xe2be,0x7BDD,
0xe2bf,0x7BE9,
0xe2c0,0x7C11,
0xe2c1,0x7C14,
0xe2c2,0x7BE6,
0xe2c3,0x7BE5,
0xe2c4,0x7C60,
0xe2c5,0x7C00,
0xe2c6,0x7C07,
0xe2c7,0x7C13,
0xe2c8,0x7BF3,
0xe2c9,0x7BF7,
0xe2ca,0x7C17,
0xe2cb,0x7C0D,
0xe2cc,0x7BF6,
0xe2cd,0x7C23,
0xe2ce,0x7C27,
0xe2cf,0x7C2A,
0xe2d0,0x7C1F,
0xe2d1,0x7C37,
0xe2d2,0x7C2B,
0xe2d3,0x7C3D,
0xe2d4,0x7C4C,
0xe2d5,0x7C43,
0xe2d6,0x7C54,
0xe2d7,0x7C4F,
0xe2d8,0x7C40,
0xe2d9,0x7C50,
0xe2da,0x7C58,
0xe2db,0x7C5F,
0xe2dc,0x7C64,
0xe2dd,0x7C56,
0xe2de,0x7C65,
0xe2df,0x7C6C,
0xe2e0,0x7C75,
0xe2e1,0x7C83,
0xe2e2,0x7C90,
0xe2e3,0x7CA4,
0xe2e4,0x7CAD,
0xe2e5,0x7CA2,
0xe2e6,0x7CAB,
0xe2e7,0x7CA1,
0xe2e8,0x7CA8,
0xe2e9,0x7CB3,
0xe2ea,0x7CB2,
0xe2eb,0x7CB1,
0xe2ec,0x7CAE,
0xe2ed,0x7CB9,
0xe2ee,0x7CBD,
0xe2ef,0x7CC0,
0xe2f0,0x7CC5,
0xe2f1,0x7CC2,
0xe2f2,0x7CD8,
0xe2f3,0x7CD2,
0xe2f4,0x7CDC,
0xe2f5,0x7CE2,
0xe2f6,0x9B3B,
0xe2f7,0x7CEF,
0xe2f8,0x7CF2,
0xe2f9,0x7CF4,
0xe2fa,0x7CF6,
0xe2fb,0x7CFA,
0xe2fc,0x7D06,
0xe340,0x7D02,
0xe341,0x7D1C,
0xe342,0x7D15,
0xe343,0x7D0A,
0xe344,0x7D45,
0xe345,0x7D4B,
0xe346,0x7D2E,
0xe347,0x7D32,
0xe348,0x7D3F,
0xe349,0x7D35,
0xe34a,0x7D46,
0xe34b,0x7D73,
0xe34c,0x7D56,
0xe34d,0x7D4E,
0xe34e,0x7D72,
0xe34f,0x7D68,
0xe350,0x7D6E,
0xe351,0x7D4F,
0xe352,0x7D63,
0xe353,0x7D93,
0xe354,0x7D89,
0xe355,0x7D5B,
0xe356,0x7D8F,
0xe357,0x7D7D,
0xe358,0x7D9B,
0xe359,0x7DBA,
0xe35a,0x7DAE,
0xe35b,0x7DA3,
0xe35c,0x7DB5,
0xe35d,0x7DC7,
0xe35e,0x7DBD,
0xe35f,0x7DAB,
0xe360,0x7E3D,
0xe361,0x7DA2,
0xe362,0x7DAF,
0xe363,0x7DDC,
0xe364,0x7DB8,
0xe365,0x7D9F,
0xe366,0x7DB0,
0xe367,0x7DD8,
0xe368,0x7DDD,
0xe369,0x7DE4,
0xe36a,0x7DDE,
0xe36b,0x7DFB,
0xe36c,0x7DF2,
0xe36d,0x7DE1,
0xe36e,0x7E05,
0xe36f,0x7E0A,
0xe370,0x7E23,
0xe371,0x7E21,
0xe372,0x7E12,
0xe373,0x7E31,
0xe374,0x7E1F,
0xe375,0x7E09,
0xe376,0x7E0B,
0xe377,0x7E22,
0xe378,0x7E46,
0xe379,0x7E66,
0xe37a,0x7E3B,
0xe37b,0x7E35,
0xe37c,0x7E39,
0xe37d,0x7E43,
0xe37e,0x7E37,
0xe37f,0x7E32,
0xe381,0x7E3A,
0xe382,0x7E67,
0xe383,0x7E5D,
0xe384,0x7E56,
0xe385,0x7E5E,
0xe386,0x7E59,
0xe387,0x7E5A,
0xe388,0x7E79,
0xe389,0x7E6A,
0xe38a,0x7E69,
0xe38b,0x7E7C,
0xe38c,0x7E7B,
0xe38d,0x7E83,
0xe38e,0x7DD5,
0xe38f,0x7E7D,
0xe390,0x8FAE,
0xe391,0x7E7F,
0xe392,0x7E88,
0xe393,0x7E89,
0xe394,0x7E8C,
0xe395,0x7E92,
0xe396,0x7E90,
0xe397,0x7E93,
0xe398,0x7E94,
0xe399,0x7E96,
0xe39a,0x7E8E,
0xe39b,0x7E9B,
0xe39c,0x7E9C,
0xe39d,0x7F38,
0xe39e,0x7F3A,
0xe39f,0x7F45,
0xe3a0,0x7F4C,
0xe3a1,0x7F4D,
0xe3a2,0x7F4E,
0xe3a3,0x7F50,
0xe3a4,0x7F51,
0xe3a5,0x7F55,
0xe3a6,0x7F54,
0xe3a7,0x7F58,
0xe3a8,0x7F5F,
0xe3a9,0x7F60,
0xe3aa,0x7F68,
0xe3ab,0x7F69,
0xe3ac,0x7F67,
0xe3ad,0x7F78,
0xe3ae,0x7F82,
0xe3af,0x7F86,
0xe3b0,0x7F83,
0xe3b1,0x7F88,
0xe3b2,0x7F87,
0xe3b3,0x7F8C,
0xe3b4,0x7F94,
0xe3b5,0x7F9E,
0xe3b6,0x7F9D,
0xe3b7,0x7F9A,
0xe3b8,0x7FA3,
0xe3b9,0x7FAF,
0xe3ba,0x7FB2,
0xe3bb,0x7FB9,
0xe3bc,0x7FAE,
0xe3bd,0x7FB6,
0xe3be,0x7FB8,
0xe3bf,0x8B71,
0xe3c0,0x7FC5,
0xe3c1,0x7FC6,
0xe3c2,0x7FCA,
0xe3c3,0x7FD5,
0xe3c4,0x7FD4,
0xe3c5,0x7FE1,
0xe3c6,0x7FE6,
0xe3c7,0x7FE9,
0xe3c8,0x7FF3,
0xe3c9,0x7FF9,
0xe3ca,0x98DC,
0xe3cb,0x8006,
0xe3cc,0x8004,
0xe3cd,0x800B,
0xe3ce,0x8012,
0xe3cf,0x8018,
0xe3d0,0x8019,
0xe3d1,0x801C,
0xe3d2,0x8021,
0xe3d3,0x8028,
0xe3d4,0x803F,
0xe3d5,0x803B,
0xe3d6,0x804A,
0xe3d7,0x8046,
0xe3d8,0x8052,
0xe3d9,0x8058,
0xe3da,0x805A,
0xe3db,0x805F,
0xe3dc,0x8062,
0xe3dd,0x8068,
0xe3de,0x8073,
0xe3df,0x8072,
0xe3e0,0x8070,
0xe3e1,0x8076,
0xe3e2,0x8079,
0xe3e3,0x807D,
0xe3e4,0x807F,
0xe3e5,0x8084,
0xe3e6,0x8086,
0xe3e7,0x8085,
0xe3e8,0x809B,
0xe3e9,0x8093,
0xe3ea,0x809A,
0xe3eb,0x80AD,
0xe3ec,0x5190,
0xe3ed,0x80AC,
0xe3ee,0x80DB,
0xe3ef,0x80E5,
0xe3f0,0x80D9,
0xe3f1,0x80DD,
0xe3f2,0x80C4,
0xe3f3,0x80DA,
0xe3f4,0x80D6,
0xe3f5,0x8109,
0xe3f6,0x80EF,
0xe3f7,0x80F1,
0xe3f8,0x811B,
0xe3f9,0x8129,
0xe3fa,0x8123,
0xe3fb,0x812F,
0xe3fc,0x814B,
0xe440,0x968B,
0xe441,0x8146,
0xe442,0x813E,
0xe443,0x8153,
0xe444,0x8151,
0xe445,0x80FC,
0xe446,0x8171,
0xe447,0x816E,
0xe448,0x8165,
0xe449,0x8166,
0xe44a,0x8174,
0xe44b,0x8183,
0xe44c,0x8188,
0xe44d,0x818A,
0xe44e,0x8180,
0xe44f,0x8182,
0xe450,0x81A0,
0xe451,0x8195,
0xe452,0x81A4,
0xe453,0x81A3,
0xe454,0x815F,
0xe455,0x8193,
0xe456,0x81A9,
0xe457,0x81B0,
0xe458,0x81B5,
0xe459,0x81BE,
0xe45a,0x81B8,
0xe45b,0x81BD,
0xe45c,0x81C0,
0xe45d,0x81C2,
0xe45e,0x81BA,
0xe45f,0x81C9,
0xe460,0x81CD,
0xe461,0x81D1,
0xe462,0x81D9,
0xe463,0x81D8,
0xe464,0x81C8,
0xe465,0x81DA,
0xe466,0x81DF,
0xe467,0x81E0,
0xe468,0x81E7,
0xe469,0x81FA,
0xe46a,0x81FB,
0xe46b,0x81FE,
0xe46c,0x8201,
0xe46d,0x8202,
0xe46e,0x8205,
0xe46f,0x8207,
0xe470,0x820A,
0xe471,0x820D,
0xe472,0x8210,
0xe473,0x8216,
0xe474,0x8229,
0xe475,0x822B,
0xe476,0x8238,
0xe477,0x8233,
0xe478,0x8240,
0xe479,0x8259,
0xe47a,0x8258,
0xe47b,0x825D,
0xe47c,0x825A,
0xe47d,0x825F,
0xe47e,0x8264,
0xe47f,0x8262,
0xe481,0x8268,
0xe482,0x826A,
0xe483,0x826B,
0xe484,0x822E,
0xe485,0x8271,
0xe486,0x8277,
0xe487,0x8278,
0xe488,0x827E,
0xe489,0x828D,
0xe48a,0x8292,
0xe48b,0x82AB,
0xe48c,0x829F,
0xe48d,0x82BB,
0xe48e,0x82AC,
0xe48f,0x82E1,
0xe490,0x82E3,
0xe491,0x82DF,
0xe492,0x82D2,
0xe493,0x82F4,
0xe494,0x82F3,
0xe495,0x82FA,
0xe496,0x8393,
0xe497,0x8303,
0xe498,0x82FB,
0xe499,0x82F9,
0xe49a,0x82DE,
0xe49b,0x8306,
0xe49c,0x82DC,
0xe49d,0x8309,
0xe49e,0x82D9,
0xe49f,0x8335,
0xe4a0,0x8334,
0xe4a1,0x8316,
0xe4a2,0x8332,
0xe4a3,0x8331,
0xe4a4,0x8340,
0xe4a5,0x8339,
0xe4a6,0x8350,
0xe4a7,0x8345,
0xe4a8,0x832F,
0xe4a9,0x832B,
0xe4aa,0x8317,
0xe4ab,0x8318,
0xe4ac,0x8385,
0xe4ad,0x839A,
0xe4ae,0x83AA,
0xe4af,0x839F,
0xe4b0,0x83A2,
0xe4b1,0x8396,
0xe4b2,0x8323,
0xe4b3,0x838E,
0xe4b4,0x8387,
0xe4b5,0x838A,
0xe4b6,0x837C,
0xe4b7,0x83B5,
0xe4b8,0x8373,
0xe4b9,0x8375,
0xe4ba,0x83A0,
0xe4bb,0x8389,
0xe4bc,0x83A8,
0xe4bd,0x83F4,
0xe4be,0x8413,
0xe4bf,0x83EB,
0xe4c0,0x83CE,
0xe4c1,0x83FD,
0xe4c2,0x8403,
0xe4c3,0x83D8,
0xe4c4,0x840B,
0xe4c5,0x83C1,
0xe4c6,0x83F7,
0xe4c7,0x8407,
0xe4c8,0x83E0,
0xe4c9,0x83F2,
0xe4ca,0x840D,
0xe4cb,0x8422,
0xe4cc,0x8420,
0xe4cd,0x83BD,
0xe4ce,0x8438,
0xe4cf,0x8506,
0xe4d0,0x83FB,
0xe4d1,0x846D,
0xe4d2,0x842A,
0xe4d3,0x843C,
0xe4d4,0x855A,
0xe4d5,0x8484,
0xe4d6,0x8477,
0xe4d7,0x846B,
0xe4d8,0x84AD,
0xe4d9,0x846E,
0xe4da,0x8482,
0xe4db,0x8469,
0xe4dc,0x8446,
0xe4dd,0x842C,
0xe4de,0x846F,
0xe4df,0x8479,
0xe4e0,0x8435,
0xe4e1,0x84CA,
0xe4e2,0x8462,
0xe4e3,0x84B9,
0xe4e4,0x84BF,
0xe4e5,0x849F,
0xe4e6,0x84D9,
0xe4e7,0x84CD,
0xe4e8,0x84BB,
0xe4e9,0x84DA,
0xe4ea,0x84D0,
0xe4eb,0x84C1,
0xe4ec,0x84C6,
0xe4ed,0x84D6,
0xe4ee,0x84A1,
0xe4ef,0x8521,
0xe4f0,0x84FF,
0xe4f1,0x84F4,
0xe4f2,0x8517,
0xe4f3,0x8518,
0xe4f4,0x852C,
0xe4f5,0x851F,
0xe4f6,0x8515,
0xe4f7,0x8514,
0xe4f8,0x84FC,
0xe4f9,0x8540,
0xe4fa,0x8563,
0xe4fb,0x8558,
0xe4fc,0x8548,
0xe540,0x8541,
0xe541,0x8602,
0xe542,0x854B,
0xe543,0x8555,
0xe544,0x8580,
0xe545,0x85A4,
0xe546,0x8588,
0xe547,0x8591,
0xe548,0x858A,
0xe549,0x85A8,
0xe54a,0x856D,
0xe54b,0x8594,
0xe54c,0x859B,
0xe54d,0x85EA,
0xe54e,0x8587,
0xe54f,0x859C,
0xe550,0x8577,
0xe551,0x857E,
0xe552,0x8590,
0xe553,0x85C9,
0xe554,0x85BA,
0xe555,0x85CF,
0xe556,0x85B9,
0xe557,0x85D0,
0xe558,0x85D5,
0xe559,0x85DD,
0xe55a,0x85E5,
0xe55b,0x85DC,
0xe55c,0x85F9,
0xe55d,0x860A,
0xe55e,0x8613,
0xe55f,0x860B,
0xe560,0x85FE,
0xe561,0x85FA,
0xe562,0x8606,
0xe563,0x8622,
0xe564,0x861A,
0xe565,0x8630,
0xe566,0x863F,
0xe567,0x864D,
0xe568,0x4E55,
0xe569,0x8654,
0xe56a,0x865F,
0xe56b,0x8667,
0xe56c,0x8671,
0xe56d,0x8693,
0xe56e,0x86A3,
0xe56f,0x86A9,
0xe570,0x86AA,
0xe571,0x868B,
0xe572,0x868C,
0xe573,0x86B6,
0xe574,0x86AF,
0xe575,0x86C4,
0xe576,0x86C6,
0xe577,0x86B0,
0xe578,0x86C9,
0xe579,0x8823,
0xe57a,0x86AB,
0xe57b,0x86D4,
0xe57c,0x86DE,
0xe57d,0x86E9,
0xe57e,0x86EC,
0xe57f,0x86DF,
0xe581,0x86DB,
0xe582,0x86EF,
0xe583,0x8712,
0xe584,0x8706,
0xe585,0x8708,
0xe586,0x8700,
0xe587,0x8703,
0xe588,0x86FB,
0xe589,0x8711,
0xe58a,0x8709,
0xe58b,0x870D,
0xe58c,0x86F9,
0xe58d,0x870A,
0xe58e,0x8734,
0xe58f,0x873F,
0xe590,0x8737,
0xe591,0x873B,
0xe592,0x8725,
0xe593,0x8729,
0xe594,0x871A,
0xe595,0x8760,
0xe596,0x875F,
0xe597,0x8778,
0xe598,0x874C,
0xe599,0x874E,
0xe59a,0x8774,
0xe59b,0x8757,
0xe59c,0x8768,
0xe59d,0x876E,
0xe59e,0x8759,
0xe59f,0x8753,
0xe5a0,0x8763,
0xe5a1,0x876A,
0xe5a2,0x8805,
0xe5a3,0x87A2,
0xe5a4,0x879F,
0xe5a5,0x8782,
0xe5a6,0x87AF,
0xe5a7,0x87CB,
0xe5a8,0x87BD,
0xe5a9,0x87C0,
0xe5aa,0x87D0,
0xe5ab,0x96D6,
0xe5ac,0x87AB,
0xe5ad,0x87C4,
0xe5ae,0x87B3,
0xe5af,0x87C7,
0xe5b0,0x87C6,
0xe5b1,0x87BB,
0xe5b2,0x87EF,
0xe5b3,0x87F2,
0xe5b4,0x87E0,
0xe5b5,0x880F,
0xe5b6,0x880D,
0xe5b7,0x87FE,
0xe5b8,0x87F6,
0xe5b9,0x87F7,
0xe5ba,0x880E,
0xe5bb,0x87D2,
0xe5bc,0x8811,
0xe5bd,0x8816,
0xe5be,0x8815,
0xe5bf,0x8822,
0xe5c0,0x8821,
0xe5c1,0x8831,
0xe5c2,0x8836,
0xe5c3,0x8839,
0xe5c4,0x8827,
0xe5c5,0x883B,
0xe5c6,0x8844,
0xe5c7,0x8842,
0xe5c8,0x8852,
0xe5c9,0x8859,
0xe5ca,0x885E,
0xe5cb,0x8862,
0xe5cc,0x886B,
0xe5cd,0x8881,
0xe5ce,0x887E,
0xe5cf,0x889E,
0xe5d0,0x8875,
0xe5d1,0x887D,
0xe5d2,0x88B5,
0xe5d3,0x8872,
0xe5d4,0x8882,
0xe5d5,0x8897,
0xe5d6,0x8892,
0xe5d7,0x88AE,
0xe5d8,0x8899,
0xe5d9,0x88A2,
0xe5da,0x888D,
0xe5db,0x88A4,
0xe5dc,0x88B0,
0xe5dd,0x88BF,
0xe5de,0x88B1,
0xe5df,0x88C3,
0xe5e0,0x88C4,
0xe5e1,0x88D4,
0xe5e2,0x88D8,
0xe5e3,0x88D9,
0xe5e4,0x88DD,
0xe5e5,0x88F9,
0xe5e6,0x8902,
0xe5e7,0x88FC,
0xe5e8,0x88F4,
0xe5e9,0x88E8,
0xe5ea,0x88F2,
0xe5eb,0x8904,
0xe5ec,0x890C,
0xe5ed,0x890A,
0xe5ee,0x8913,
0xe5ef,0x8943,
0xe5f0,0x891E,
0xe5f1,0x8925,
0xe5f2,0x892A,
0xe5f3,0x892B,
0xe5f4,0x8941,
0xe5f5,0x8944,
0xe5f6,0x893B,
0xe5f7,0x8936,
0xe5f8,0x8938,
0xe5f9,0x894C,
0xe5fa,0x891D,
0xe5fb,0x8960,
0xe5fc,0x895E,
0xe640,0x8966,
0xe641,0x8964,
0xe642,0x896D,
0xe643,0x896A,
0xe644,0x896F,
0xe645,0x8974,
0xe646,0x8977,
0xe647,0x897E,
0xe648,0x8983,
0xe649,0x8988,
0xe64a,0x898A,
0xe64b,0x8993,
0xe64c,0x8998,
0xe64d,0x89A1,
0xe64e,0x89A9,
0xe64f,0x89A6,
0xe650,0x89AC,
0xe651,0x89AF,
0xe652,0x89B2,
0xe653,0x89BA,
0xe654,0x89BD,
0xe655,0x89BF,
0xe656,0x89C0,
0xe657,0x89DA,
0xe658,0x89DC,
0xe659,0x89DD,
0xe65a,0x89E7,
0xe65b,0x89F4,
0xe65c,0x89F8,
0xe65d,0x8A03,
0xe65e,0x8A16,
0xe65f,0x8A10,
0xe660,0x8A0C,
0xe661,0x8A1B,
0xe662,0x8A1D,
0xe663,0x8A25,
0xe664,0x8A36,
0xe665,0x8A41,
0xe666,0x8A5B,
0xe667,0x8A52,
0xe668,0x8A46,
0xe669,0x8A48,
0xe66a,0x8A7C,
0xe66b,0x8A6D,
0xe66c,0x8A6C,
0xe66d,0x8A62,
0xe66e,0x8A85,
0xe66f,0x8A82,
0xe670,0x8A84,
0xe671,0x8AA8,
0xe672,0x8AA1,
0xe673,0x8A91,
0xe674,0x8AA5,
0xe675,0x8AA6,
0xe676,0x8A9A,
0xe677,0x8AA3,
0xe678,0x8AC4,
0xe679,0x8ACD,
0xe67a,0x8AC2,
0xe67b,0x8ADA,
0xe67c,0x8AEB,
0xe67d,0x8AF3,
0xe67e,0x8AE7,
0xe67f,0x8AE4,
0xe681,0x8AF1,
0xe682,0x8B14,
0xe683,0x8AE0,
0xe684,0x8AE2,
0xe685,0x8AF7,
0xe686,0x8ADE,
0xe687,0x8ADB,
0xe688,0x8B0C,
0xe689,0x8B07,
0xe68a,0x8B1A,
0xe68b,0x8AE1,
0xe68c,0x8B16,
0xe68d,0x8B10,
0xe68e,0x8B17,
0xe68f,0x8B20,
0xe690,0x8B33,
0xe691,0x97AB,
0xe692,0x8B26,
0xe693,0x8B2B,
0xe694,0x8B3E,
0xe695,0x8B28,
0xe696,0x8B41,
0xe697,0x8B4C,
0xe698,0x8B4F,
0xe699,0x8B4E,
0xe69a,0x8B49,
0xe69b,0x8B56,
0xe69c,0x8B5B,
0xe69d,0x8B5A,
0xe69e,0x8B6B,
0xe69f,0x8B5F,
0xe6a0,0x8B6C,
0xe6a1,0x8B6F,
0xe6a2,0x8B74,
0xe6a3,0x8B7D,
0xe6a4,0x8B80,
0xe6a5,0x8B8C,
0xe6a6,0x8B8E,
0xe6a7,0x8B92,
0xe6a8,0x8B93,
0xe6a9,0x8B96,
0xe6aa,0x8B99,
0xe6ab,0x8B9A,
0xe6ac,0x8C3A,
0xe6ad,0x8C41,
0xe6ae,0x8C3F,
0xe6af,0x8C48,
0xe6b0,0x8C4C,
0xe6b1,0x8C4E,
0xe6b2,0x8C50,
0xe6b3,0x8C55,
0xe6b4,0x8C62,
0xe6b5,0x8C6C,
0xe6b6,0x8C78,
0xe6b7,0x8C7A,
0xe6b8,0x8C82,
0xe6b9,0x8C89,
0xe6ba,0x8C85,
0xe6bb,0x8C8A,
0xe6bc,0x8C8D,
0xe6bd,0x8C8E,
0xe6be,0x8C94,
0xe6bf,0x8C7C,
0xe6c0,0x8C98,
0xe6c1,0x621D,
0xe6c2,0x8CAD,
0xe6c3,0x8CAA,
0xe6c4,0x8CBD,
0xe6c5,0x8CB2,
0xe6c6,0x8CB3,
0xe6c7,0x8CAE,
0xe6c8,0x8CB6,
0xe6c9,0x8CC8,
0xe6ca,0x8CC1,
0xe6cb,0x8CE4,
0xe6cc,0x8CE3,
0xe6cd,0x8CDA,
0xe6ce,0x8CFD,
0xe6cf,0x8CFA,
0xe6d0,0x8CFB,
0xe6d1,0x8D04,
0xe6d2,0x8D05,
0xe6d3,0x8D0A,
0xe6d4,0x8D07,
0xe6d5,0x8D0F,
0xe6d6,0x8D0D,
0xe6d7,0x8D10,
0xe6d8,0x9F4E,
0xe6d9,0x8D13,
0xe6da,0x8CCD,
0xe6db,0x8D14,
0xe6dc,0x8D16,
0xe6dd,0x8D67,
0xe6de,0x8D6D,
0xe6df,0x8D71,
0xe6e0,0x8D73,
0xe6e1,0x8D81,
0xe6e2,0x8D99,
0xe6e3,0x8DC2,
0xe6e4,0x8DBE,
0xe6e5,0x8DBA,
0xe6e6,0x8DCF,
0xe6e7,0x8DDA,
0xe6e8,0x8DD6,
0xe6e9,0x8DCC,
0xe6ea,0x8DDB,
0xe6eb,0x8DCB,
0xe6ec,0x8DEA,
0xe6ed,0x8DEB,
0xe6ee,0x8DDF,
0xe6ef,0x8DE3,
0xe6f0,0x8DFC,
0xe6f1,0x8E08,
0xe6f2,0x8E09,
0xe6f3,0x8DFF,
0xe6f4,0x8E1D,
0xe6f5,0x8E1E,
0xe6f6,0x8E10,
0xe6f7,0x8E1F,
0xe6f8,0x8E42,
0xe6f9,0x8E35,
0xe6fa,0x8E30,
0xe6fb,0x8E34,
0xe6fc,0x8E4A,
0xe740,0x8E47,
0xe741,0x8E49,
0xe742,0x8E4C,
0xe743,0x8E50,
0xe744,0x8E48,
0xe745,0x8E59,
0xe746,0x8E64,
0xe747,0x8E60,
0xe748,0x8E2A,
0xe749,0x8E63,
0xe74a,0x8E55,
0xe74b,0x8E76,
0xe74c,0x8E72,
0xe74d,0x8E7C,
0xe74e,0x8E81,
0xe74f,0x8E87,
0xe750,0x8E85,
0xe751,0x8E84,
0xe752,0x8E8B,
0xe753,0x8E8A,
0xe754,0x8E93,
0xe755,0x8E91,
0xe756,0x8E94,
0xe757,0x8E99,
0xe758,0x8EAA,
0xe759,0x8EA1,
0xe75a,0x8EAC,
0xe75b,0x8EB0,
0xe75c,0x8EC6,
0xe75d,0x8EB1,
0xe75e,0x8EBE,
0xe75f,0x8EC5,
0xe760,0x8EC8,
0xe761,0x8ECB,
0xe762,0x8EDB,
0xe763,0x8EE3,
0xe764,0x8EFC,
0xe765,0x8EFB,
0xe766,0x8EEB,
0xe767,0x8EFE,
0xe768,0x8F0A,
0xe769,0x8F05,
0xe76a,0x8F15,
0xe76b,0x8F12,
0xe76c,0x8F19,
0xe76d,0x8F13,
0xe76e,0x8F1C,
0xe76f,0x8F1F,
0xe770,0x8F1B,
0xe771,0x8F0C,
0xe772,0x8F26,
0xe773,0x8F33,
0xe774,0x8F3B,
0xe775,0x8F39,
0xe776,0x8F45,
0xe777,0x8F42,
0xe778,0x8F3E,
0xe779,0x8F4C,
0xe77a,0x8F49,
0xe77b,0x8F46,
0xe77c,0x8F4E,
0xe77d,0x8F57,
0xe77e,0x8F5C,
0xe77f,0x8F62,
0xe781,0x8F63,
0xe782,0x8F64,
0xe783,0x8F9C,
0xe784,0x8F9F,
0xe785,0x8FA3,
0xe786,0x8FAD,
0xe787,0x8FAF,
0xe788,0x8FB7,
0xe789,0x8FDA,
0xe78a,0x8FE5,
0xe78b,0x8FE2,
0xe78c,0x8FEA,
0xe78d,0x8FEF,
0xe78e,0x9087,
0xe78f,0x8FF4,
0xe790,0x9005,
0xe791,0x8FF9,
0xe792,0x8FFA,
0xe793,0x9011,
0xe794,0x9015,
0xe795,0x9021,
0xe796,0x900D,
0xe797,0x901E,
0xe798,0x9016,
0xe799,0x900B,
0xe79a,0x9027,
0xe79b,0x9036,
0xe79c,0x9035,
0xe79d,0x9039,
0xe79e,0x8FF8,
0xe79f,0x904F,
0xe7a0,0x9050,
0xe7a1,0x9051,
0xe7a2,0x9052,
0xe7a3,0x900E,
0xe7a4,0x9049,
0xe7a5,0x903E,
0xe7a6,0x9056,
0xe7a7,0x9058,
0xe7a8,0x905E,
0xe7a9,0x9068,
0xe7aa,0x906F,
0xe7ab,0x9076,
0xe7ac,0x96A8,
0xe7ad,0x9072,
0xe7ae,0x9082,
0xe7af,0x907D,
0xe7b0,0x9081,
0xe7b1,0x9080,
0xe7b2,0x908A,
0xe7b3,0x9089,
0xe7b4,0x908F,
0xe7b5,0x90A8,
0xe7b6,0x90AF,
0xe7b7,0x90B1,
0xe7b8,0x90B5,
0xe7b9,0x90E2,
0xe7ba,0x90E4,
0xe7bb,0x6248,
0xe7bc,0x90DB,
0xe7bd,0x9102,
0xe7be,0x9112,
0xe7bf,0x9119,
0xe7c0,0x9132,
0xe7c1,0x9130,
0xe7c2,0x914A,
0xe7c3,0x9156,
0xe7c4,0x9158,
0xe7c5,0x9163,
0xe7c6,0x9165,
0xe7c7,0x9169,
0xe7c8,0x9173,
0xe7c9,0x9172,
0xe7ca,0x918B,
0xe7cb,0x9189,
0xe7cc,0x9182,
0xe7cd,0x91A2,
0xe7ce,0x91AB,
0xe7cf,0x91AF,
0xe7d0,0x91AA,
0xe7d1,0x91B5,
0xe7d2,0x91B4,
0xe7d3,0x91BA,
0xe7d4,0x91C0,
0xe7d5,0x91C1,
0xe7d6,0x91C9,
0xe7d7,0x91CB,
0xe7d8,0x91D0,
0xe7d9,0x91D6,
0xe7da,0x91DF,
0xe7db,0x91E1,
0xe7dc,0x91DB,
0xe7dd,0x91FC,
0xe7de,0x91F5,
0xe7df,0x91F6,
0xe7e0,0x921E,
0xe7e1,0x91FF,
0xe7e2,0x9214,
0xe7e3,0x922C,
0xe7e4,0x9215,
0xe7e5,0x9211,
0xe7e6,0x925E,
0xe7e7,0x9257,
0xe7e8,0x9245,
0xe7e9,0x9249,
0xe7ea,0x9264,
0xe7eb,0x9248,
0xe7ec,0x9295,
0xe7ed,0x923F,
0xe7ee,0x924B,
0xe7ef,0x9250,
0xe7f0,0x929C,
0xe7f1,0x9296,
0xe7f2,0x9293,
0xe7f3,0x929B,
0xe7f4,0x925A,
0xe7f5,0x92CF,
0xe7f6,0x92B9,
0xe7f7,0x92B7,
0xe7f8,0x92E9,
0xe7f9,0x930F,
0xe7fa,0x92FA,
0xe7fb,0x9344,
0xe7fc,0x932E,
0xe840,0x9319,
0xe841,0x9322,
0xe842,0x931A,
0xe843,0x9323,
0xe844,0x933A,
0xe845,0x9335,
0xe846,0x933B,
0xe847,0x935C,
0xe848,0x9360,
0xe849,0x937C,
0xe84a,0x936E,
0xe84b,0x9356,
0xe84c,0x93B0,
0xe84d,0x93AC,
0xe84e,0x93AD,
0xe84f,0x9394,
0xe850,0x93B9,
0xe851,0x93D6,
0xe852,0x93D7,
0xe853,0x93E8,
0xe854,0x93E5,
0xe855,0x93D8,
0xe856,0x93C3,
0xe857,0x93DD,
0xe858,0x93D0,
0xe859,0x93C8,
0xe85a,0x93E4,
0xe85b,0x941A,
0xe85c,0x9414,
0xe85d,0x9413,
0xe85e,0x9403,
0xe85f,0x9407,
0xe860,0x9410,
0xe861,0x9436,
0xe862,0x942B,
0xe863,0x9435,
0xe864,0x9421,
0xe865,0x943A,
0xe866,0x9441,
0xe867,0x9452,
0xe868,0x9444,
0xe869,0x945B,
0xe86a,0x9460,
0xe86b,0x9462,
0xe86c,0x945E,
0xe86d,0x946A,
0xe86e,0x9229,
0xe86f,0x9470,
0xe870,0x9475,
0xe871,0x9477,
0xe872,0x947D,
0xe873,0x945A,
0xe874,0x947C,
0xe875,0x947E,
0xe876,0x9481,
0xe877,0x947F,
0xe878,0x9582,
0xe879,0x9587,
0xe87a,0x958A,
0xe87b,0x9594,
0xe87c,0x9596,
0xe87d,0x9598,
0xe87e,0x9599,
0xe87f,0x95A0,
0xe881,0x95A8,
0xe882,0x95A7,
0xe883,0x95AD,
0xe884,0x95BC,
0xe885,0x95BB,
0xe886,0x95B9,
0xe887,0x95BE,
0xe888,0x95CA,
0xe889,0x6FF6,
0xe88a,0x95C3,
0xe88b,0x95CD,
0xe88c,0x95CC,
0xe88d,0x95D5,
0xe88e,0x95D4,
0xe88f,0x95D6,
0xe890,0x95DC,
0xe891,0x95E1,
0xe892,0x95E5,
0xe893,0x95E2,
0xe894,0x9621,
0xe895,0x9628,
0xe896,0x962E,
0xe897,0x962F,
0xe898,0x9642,
0xe899,0x964C,
0xe89a,0x964F,
0xe89b,0x964B,
0xe89c,0x9677,
0xe89d,0x965C,
0xe89e,0x965E,
0xe89f,0x965D,
0xe8a0,0x965F,
0xe8a1,0x9666,
0xe8a2,0x9672,
0xe8a3,0x966C,
0xe8a4,0x968D,
0xe8a5,0x9698,
0xe8a6,0x9695,
0xe8a7,0x9697,
0xe8a8,0x96AA,
0xe8a9,0x96A7,
0xe8aa,0x96B1,
0xe8ab,0x96B2,
0xe8ac,0x96B0,
0xe8ad,0x96B4,
0xe8ae,0x96B6,
0xe8af,0x96B8,
0xe8b0,0x96B9,
0xe8b1,0x96CE,
0xe8b2,0x96CB,
0xe8b3,0x96C9,
0xe8b4,0x96CD,
0xe8b5,0x894D,
0xe8b6,0x96DC,
0xe8b7,0x970D,
0xe8b8,0x96D5,
0xe8b9,0x96F9,
0xe8ba,0x9704,
0xe8bb,0x9706,
0xe8bc,0x9708,
0xe8bd,0x9713,
0xe8be,0x970E,
0xe8bf,0x9711,
0xe8c0,0x970F,
0xe8c1,0x9716,
0xe8c2,0x9719,
0xe8c3,0x9724,
0xe8c4,0x972A,
0xe8c5,0x9730,
0xe8c6,0x9739,
0xe8c7,0x973D,
0xe8c8,0x973E,
0xe8c9,0x9744,
0xe8ca,0x9746,
0xe8cb,0x9748,
0xe8cc,0x9742,
0xe8cd,0x9749,
0xe8ce,0x975C,
0xe8cf,0x9760,
0xe8d0,0x9764,
0xe8d1,0x9766,
0xe8d2,0x9768,
0xe8d3,0x52D2,
0xe8d4,0x976B,
0xe8d5,0x9771,
0xe8d6,0x9779,
0xe8d7,0x9785,
0xe8d8,0x977C,
0xe8d9,0x9781,
0xe8da,0x977A,
0xe8db,0x9786,
0xe8dc,0x978B,
0xe8dd,0x978F,
0xe8de,0x9790,
0xe8df,0x979C,
0xe8e0,0x97A8,
0xe8e1,0x97A6,
0xe8e2,0x97A3,
0xe8e3,0x97B3,
0xe8e4,0x97B4,
0xe8e5,0x97C3,
0xe8e6,0x97C6,
0xe8e7,0x97C8,
0xe8e8,0x97CB,
0xe8e9,0x97DC,
0xe8ea,0x97ED,
0xe8eb,0x9F4F,
0xe8ec,0x97F2,
0xe8ed,0x7ADF,
0xe8ee,0x97F6,
0xe8ef,0x97F5,
0xe8f0,0x980F,
0xe8f1,0x980C,
0xe8f2,0x9838,
0xe8f3,0x9824,
0xe8f4,0x9821,
0xe8f5,0x9837,
0xe8f6,0x983D,
0xe8f7,0x9846,
0xe8f8,0x984F,
0xe8f9,0x984B,
0xe8fa,0x986B,
0xe8fb,0x986F,
0xe8fc,0x9870,
0xe940,0x9871,
0xe941,0x9874,
0xe942,0x9873,
0xe943,0x98AA,
0xe944,0x98AF,
0xe945,0x98B1,
0xe946,0x98B6,
0xe947,0x98C4,
0xe948,0x98C3,
0xe949,0x98C6,
0xe94a,0x98E9,
0xe94b,0x98EB,
0xe94c,0x9903,
0xe94d,0x9909,
0xe94e,0x9912,
0xe94f,0x9914,
0xe950,0x9918,
0xe951,0x9921,
0xe952,0x991D,
0xe953,0x991E,
0xe954,0x9924,
0xe955,0x9920,
0xe956,0x992C,
0xe957,0x992E,
0xe958,0x993D,
0xe959,0x993E,
0xe95a,0x9942,
0xe95b,0x9949,
0xe95c,0x9945,
0xe95d,0x9950,
0xe95e,0x994B,
0xe95f,0x9951,
0xe960,0x9952,
0xe961,0x994C,
0xe962,0x9955,
0xe963,0x9997,
0xe964,0x9998,
0xe965,0x99A5,
0xe966,0x99AD,
0xe967,0x99AE,
0xe968,0x99BC,
0xe969,0x99DF,
0xe96a,0x99DB,
0xe96b,0x99DD,
0xe96c,0x99D8,
0xe96d,0x99D1,
0xe96e,0x99ED,
0xe96f,0x99EE,
0xe970,0x99F1,
0xe971,0x99F2,
0xe972,0x99FB,
0xe973,0x99F8,
0xe974,0x9A01,
0xe975,0x9A0F,
0xe976,0x9A05,
0xe977,0x99E2,
0xe978,0x9A19,
0xe979,0x9A2B,
0xe97a,0x9A37,
0xe97b,0x9A45,
0xe97c,0x9A42,
0xe97d,0x9A40,
0xe97e,0x9A43,
0xe97f,0x9A3E,
0xe981,0x9A55,
0xe982,0x9A4D,
0xe983,0x9A5B,
0xe984,0x9A57,
0xe985,0x9A5F,
0xe986,0x9A62,
0xe987,0x9A65,
0xe988,0x9A64,
0xe989,0x9A69,
0xe98a,0x9A6B,
0xe98b,0x9A6A,
0xe98c,0x9AAD,
0xe98d,0x9AB0,
0xe98e,0x9ABC,
0xe98f,0x9AC0,
0xe990,0x9ACF,
0xe991,0x9AD1,
0xe992,0x9AD3,
0xe993,0x9AD4,
0xe994,0x9ADE,
0xe995,0x9ADF,
0xe996,0x9AE2,
0xe997,0x9AE3,
0xe998,0x9AE6,
0xe999,0x9AEF,
0xe99a,0x9AEB,
0xe99b,0x9AEE,
0xe99c,0x9AF4,
0xe99d,0x9AF1,
0xe99e,0x9AF7,
0xe99f,0x9AFB,
0xe9a0,0x9B06,
0xe9a1,0x9B18,
0xe9a2,0x9B1A,
0xe9a3,0x9B1F,
0xe9a4,0x9B22,
0xe9a5,0x9B23,
0xe9a6,0x9B25,
0xe9a7,0x9B27,
0xe9a8,0x9B28,
0xe9a9,0x9B29,
0xe9aa,0x9B2A,
0xe9ab,0x9B2E,
0xe9ac,0x9B2F,
0xe9ad,0x9B32,
0xe9ae,0x9B44,
0xe9af,0x9B43,
0xe9b0,0x9B4F,
0xe9b1,0x9B4D,
0xe9b2,0x9B4E,
0xe9b3,0x9B51,
0xe9b4,0x9B58,
0xe9b5,0x9B74,
0xe9b6,0x9B93,
0xe9b7,0x9B83,
0xe9b8,0x9B91,
0xe9b9,0x9B96,
0xe9ba,0x9B97,
0xe9bb,0x9B9F,
0xe9bc,0x9BA0,
0xe9bd,0x9BA8,
0xe9be,0x9BB4,
0xe9bf,0x9BC0,
0xe9c0,0x9BCA,
0xe9c1,0x9BB9,
0xe9c2,0x9BC6,
0xe9c3,0x9BCF,
0xe9c4,0x9BD1,
0xe9c5,0x9BD2,
0xe9c6,0x9BE3,
0xe9c7,0x9BE2,
0xe9c8,0x9BE4,
0xe9c9,0x9BD4,
0xe9ca,0x9BE1,
0xe9cb,0x9C3A,
0xe9cc,0x9BF2,
0xe9cd,0x9BF1,
0xe9ce,0x9BF0,
0xe9cf,0x9C15,
0xe9d0,0x9C14,
0xe9d1,0x9C09,
0xe9d2,0x9C13,
0xe9d3,0x9C0C,
0xe9d4,0x9C06,
0xe9d5,0x9C08,
0xe9d6,0x9C12,
0xe9d7,0x9C0A,
0xe9d8,0x9C04,
0xe9d9,0x9C2E,
0xe9da,0x9C1B,
0xe9db,0x9C25,
0xe9dc,0x9C24,
0xe9dd,0x9C21,
0xe9de,0x9C30,
0xe9df,0x9C47,
0xe9e0,0x9C32,
0xe9e1,0x9C46,
0xe9e2,0x9C3E,
0xe9e3,0x9C5A,
0xe9e4,0x9C60,
0xe9e5,0x9C67,
0xe9e6,0x9C76,
0xe9e7,0x9C78,
0xe9e8,0x9CE7,
0xe9e9,0x9CEC,
0xe9ea,0x9CF0,
0xe9eb,0x9D09,
0xe9ec,0x9D08,
0xe9ed,0x9CEB,
0xe9ee,0x9D03,
0xe9ef,0x9D06,
0xe9f0,0x9D2A,
0xe9f1,0x9D26,
0xe9f2,0x9DAF,
0xe9f3,0x9D23,
0xe9f4,0x9D1F,
0xe9f5,0x9D44,
0xe9f6,0x9D15,
0xe9f7,0x9D12,
0xe9f8,0x9D41,
0xe9f9,0x9D3F,
0xe9fa,0x9D3E,
0xe9fb,0x9D46,
0xe9fc,0x9D48,
0xea40,0x9D5D,
0xea41,0x9D5E,
0xea42,0x9D64,
0xea43,0x9D51,
0xea44,0x9D50,
0xea45,0x9D59,
0xea46,0x9D72,
0xea47,0x9D89,
0xea48,0x9D87,
0xea49,0x9DAB,
0xea4a,0x9D6F,
0xea4b,0x9D7A,
0xea4c,0x9D9A,
0xea4d,0x9DA4,
0xea4e,0x9DA9,
0xea4f,0x9DB2,
0xea50,0x9DC4,
0xea51,0x9DC1,
0xea52,0x9DBB,
0xea53,0x9DB8,
0xea54,0x9DBA,
0xea55,0x9DC6,
0xea56,0x9DCF,
0xea57,0x9DC2,
0xea58,0x9DD9,
0xea59,0x9DD3,
0xea5a,0x9DF8,
0xea5b,0x9DE6,
0xea5c,0x9DED,
0xea5d,0x9DEF,
0xea5e,0x9DFD,
0xea5f,0x9E1A,
0xea60,0x9E1B,
0xea61,0x9E1E,
0xea62,0x9E75,
0xea63,0x9E79,
0xea64,0x9E7D,
0xea65,0x9E81,
0xea66,0x9E88,
0xea67,0x9E8B,
0xea68,0x9E8C,
0xea69,0x9E92,
0xea6a,0x9E95,
0xea6b,0x9E91,
0xea6c,0x9E9D,
0xea6d,0x9EA5,
0xea6e,0x9EA9,
0xea6f,0x9EB8,
0xea70,0x9EAA,
0xea71,0x9EAD,
0xea72,0x9761,
0xea73,0x9ECC,
0xea74,0x9ECE,
0xea75,0x9ECF,
0xea76,0x9ED0,
0xea77,0x9ED4,
0xea78,0x9EDC,
0xea79,0x9EDE,
0xea7a,0x9EDD,
0xea7b,0x9EE0,
0xea7c,0x9EE5,
0xea7d,0x9EE8,
0xea7e,0x9EEF,
0xea7f,0x9EF4,
0xea81,0x9EF6,
0xea82,0x9EF7,
0xea83,0x9EF9,
0xea84,0x9EFB,
0xea85,0x9EFC,
0xea86,0x9EFD,
0xea87,0x9F07,
0xea88,0x9F08,
0xea89,0x76B7,
0xea8a,0x9F15,
0xea8b,0x9F21,
0xea8c,0x9F2C,
0xea8d,0x9F3E,
0xea8e,0x9F4A,
0xea8f,0x9F52,
0xea90,0x9F54,
0xea91,0x9F63,
0xea92,0x9F5F,
0xea93,0x9F60,
0xea94,0x9F61,
0xea95,0x9F66,
0xea96,0x9F67,
0xea97,0x9F6C,
0xea98,0x9F6A,
0xea99,0x9F77,
0xea9a,0x9F72,
0xea9b,0x9F76,
0xea9c,0x9F95,
0xea9d,0x9F9C,
0xea9e,0x9FA0,
0xea9f,0x582F,
0xeaa0,0x69C7,
0xeaa1,0x9059,
0xeaa2,0x7464,
0xeaa3,0x51DC,
0xeaa4,0x7199,
};
