# Ă܊Ǘ
module TekitamaManager

  # 
  def TekitamaManager.initAll
    # ŜĂܔz
    @objects = []
    @collisions = []
  end

  # ŜĂ܂ړ
  def TekitamaManager.moveAll
    # ړ
    @objects.each do |t|
      t.move
    end
  end

  # ŜĂ܂`
  def TekitamaManager.drawAll
    # `
    @objects.each do |t|
      t.draw
    end
  end

  def TekitamaManager.objects
    @objects
  end

  def TekitamaManager.collisions
    @collisions
  end

  # tOĂIuWFNg폜
  def TekitamaManager.clear
    @objects.delete_if do |t|
      t.delflag
    end
  end
end


# iij
class TekitamaS

  def self.create(*arr)
    TekitamaManager.objects.push(self.new(*arr))
  end

  def initialize(x, y, angle, speed)
    @x = x
    @y = y
    @dx = Math.cos(TO_RADIAN * angle) * speed
    @dy = Math.sin(TO_RADIAN * angle) * speed
    @delflag = false
    @damage = 10
    @collision = CollisionBox.new(IMAGE_tekitama1.x1, IMAGE_tekitama1.y1,
                                  IMAGE_tekitama1.x2, IMAGE_tekitama1.y2, self)
  end

  def move
    # ړ
    @x = @x + @dx
    @y = @y + @dy

    # ʊO
    if @y <= -IMAGE_tekitama1.height or @x <= -IMAGE_tekitama1.width or
       @y >  480  or @x >  640  then
      @delflag = true
      return
    end

    # 蔻͈͐ݒ
    @collision.set(@x, @y)
    TekitamaManager.collisions.push(@collision)
  end

  def shot(opponent)
    @delflag = true
  end

  def draw
    # Ă܂`悷
    Window.draw(@x, @y, IMAGE_tekitama1, 10)
  end

attr_accessor :delflag, :damage
end


# Ă܁ipjNX
class TekitamaMajo

  def self.create(*arr)
    TekitamaManager.objects.push(self.new(*arr))
  end

  def initialize(x, y, angle, speed, count, wait, obj)
    @x = x
    @y = y
    @dx = 0
    @dy = 0
    @speed = speed
    @angle = angle
    @count = count
    @obj = obj
    @delflag = false
    @damage = 20
    @alpha = 0
    @wait = wait
    @rot = 0
    @state = 0 # 0͏oA1͑҂ԁA2͔ԁA3͏
    @collision = CollisionBox.new(IMAGE_tekitama3.x1, IMAGE_tekitama3.y1,
                                  IMAGE_tekitama3.x2, IMAGE_tekitama3.y2, self)
  end

  def move

    # G̉]
    @rot = @rot - 2
    if @rot < 0 then
      @rot = @rot + 360
    end

    # ړ
    case @state
    when 0 # o
      @wait = @wait - 1
      @alpha = @alpha + 4
      if @alpha > 255 then
        @alpha = 255
      end
      if @wait <= 0 then
        @state = 1
      end

      if $saru == nil or @obj.delflag == true then # oɂ邩񂾏ꍇ
        @state = 3
      end

      return

    when 1 # ҂
      if $saru == nil or @obj.delflag == true then # ҋ@ɂ邩񂾏ꍇ
        @state = 3
        return
      end

      @count = @count - 1
      if @count <= 0 then
        @state = 2
        @angle = Math.atan2($saru.y - @y, $saru.x - @x) / Math::PI * 180
        @dx = Math.cos(TO_RADIAN * @angle) * @speed
        @dy = Math.sin(TO_RADIAN * @angle) * @speed
      end

    when 2 # 
      @count = @count + 1
      if @count >= 4 then
        OtherKirakira.create(@x+2 - (Math.cos(TO_RADIAN * (@angle + rand(0) * 180 - 90)) * @speed/2),
                             @y+2 - (Math.sin(TO_RADIAN * (@angle + rand(0) * 180 - 90)) * @speed/2)) if $effectmode == 1
        @count = 0
      end

      # ړ
      @x = @x + @dx
      @y = @y + @dy

      # ʊO
      if @y <= -IMAGE_tekitama3.height or @x <= -IMAGE_tekitama3.width or
         @y >  480  or @x >  640  then
        @delflag = true
        return
      end

    when 3 # 
      @alpha = @alpha - 8
      if @alpha < 0 then
        @delflag = true
      end

      return
    end

    # 蔻͈͐ݒ
    @collision.set(@x, @y)
    TekitamaManager.collisions.push(@collision)
  end

  def shot(opponent)
    @delflag = true
  end
  
  def draw
    Window.drawEx(@x, @y, IMAGE_tekitama3, :angle => @rot, :alpha => @alpha, :z => 10)
  end

attr_accessor :delflag, :damage
end


# \EXgCN݂Ȃipj
class TekitamaSS

  def self.create(*arr)
    TekitamaManager.objects.push(self.new(*arr))
  end

  def initialize(x, y, dy, obj)
    @x = x
    @y = y
    @dx = 6
    @dy = dy
    @flag = @dy < 0 ? -1 : 1
    @rot = 0

    @obj = obj
    @delflag = false
    @damage = 20
    @state = 0
    @count = 0
    @collision = CollisionBox.new(IMAGE_tekitama3.x1, IMAGE_tekitama3.y1,
                                  IMAGE_tekitama3.x2, IMAGE_tekitama3.y2, self)
  end

  def move

    # G̉]
    @rot = @rot - 2
    if @rot < 0 then
      @rot = @rot + 360
    end

    @tx = @x
    @ty = @y

    angle = Math.atan2(@ty - @y, @tx - @x) / Math::PI * 180
    speed = Math.sqrt(@dx * @dx + @dy * @dy)

    @count = @count + 1
    if @count >= 4 then
      OtherKirakira.create(@x+2 - (Math.cos(TO_RADIAN * (angle + rand(0) * 180 - 90)) * speed/2),
                           @y+2 - (Math.sin(TO_RADIAN * (angle + rand(0) * 180 - 90)) * speed/2)) if $effectmode == 1
      @count = 0
    end

    # ړ
    case @state
    when 0

      @dx = @dx - 0.2
      @x = @x + @dx
      @y = @y + @dy
      if @y <= -IMAGE_tekitama3.height or @x <= -IMAGE_tekitama3.width or
         @y >  480  or @x >  640  then
        @delflag = true
        return
      end
      
      if @dx < 0 then
        @state = 1
      end

    when 1
      @dx = @dx - 0.05
      @x = @x + @dx
      if $saru != nil and @y < $saru.y then
        @dy = @dy + 0.02 if @flag == -1
      else
        @dy = @dy - 0.02 if @flag == 1
      end

      @y = @y + @dy
      if @y <= -IMAGE_tekitama3.height or @x <= -IMAGE_tekitama3.width or
         @y >  480  or @x >  640  then
        @delflag = true
        return
      end
      
      if @dx < 0 then
        @state = 1
      end

    end

    # 蔻͈͐ݒ
    @collision.set(@x, @y)
    TekitamaManager.collisions.push(@collision)
  end

  def shot(opponent)
    @delflag = true
  end
  
  def draw
    Window.drawRot(@x, @y, IMAGE_tekitama3, @rot, nil, nil, 10)
  end

attr_accessor :delflag, :damage
end


# piij
class TekitamaU

  def self.create(*arr)
    TekitamaManager.objects.push(self.new(*arr))
  end

  def initialize(x, y, angle, speed)
    @x = x
    @y = y
    @dx = Math.cos(TO_RADIAN * angle) * speed
    @dy = Math.sin(TO_RADIAN * angle) * speed
    @delflag = false
    @damage = 20
    @rot = 0
    @collision = CollisionBox.new(IMAGE_usatama.x1, IMAGE_usatama.y1,
                                  IMAGE_usatama.x2, IMAGE_usatama.y2, self)
  end

  def move
    # ړ
    @x = @x + @dx
    @y = @y + @dy

    # ʊO
    if @y <= -IMAGE_usatama.height or @x <= -IMAGE_usatama.width or
       @y >  480  or @x >  640  then
      @delflag = true
      return
    end

    @rot += 2
    if @rot > 360 then
      @rot -= 360
    end

    # 蔻͈͐ݒ
    @collision.set(@x, @y)
    TekitamaManager.collisions.push(@collision)
  end

  def shot(opponent)
#    @delflag = true
  end

  def draw
    # Ă܂`悷
    Window.drawRot(@x, @y, IMAGE_usatama, @rot, nil, nil, 10)
  end

attr_accessor :delflag, :damage, :x1, :x2, :y1, :y2
end

# Feiij
class TekitamaY

  def self.create(*arr)
    TekitamaManager.objects.push(self.new(*arr))
  end

  def initialize(x, y, angle, speed)
    @x = x
    @y = y
    @dx = Math.cos(TO_RADIAN * angle) * speed
    @dy = Math.sin(TO_RADIAN * angle) * speed
    @delflag = false
    @damage = 10
    @collision = CollisionBox.new(IMAGE_tekitama2.x1, IMAGE_tekitama2.y1,
                                  IMAGE_tekitama2.x2, IMAGE_tekitama2.y2, self)
  end

  def move
    # ړ
    @x = @x + @dx
    @y = @y + @dy

    # ʊO
    if @y <= -IMAGE_tekitama1.height or @x <= -IMAGE_tekitama1.width or
       @y >  480  or @x >  640  then
      @delflag = true
      return
    end

    # 蔻͈͐ݒ
    @collision.set(@x, @y)
    TekitamaManager.collisions.push(@collision)
  end

  def shot(opponent)
    @delflag = true
  end

  def draw
    # Ă܂`悷
    Window.draw(@x, @y, IMAGE_tekitama2, 10)
  end

attr_accessor :delflag, :damage, :x1, :x2, :y1, :y2
end
