#include "stdafx.h"
#include "resource.h"		// For IDS_XXX.
#include "Env.h"			// For g_pEnv.
#include "DBLShortLine.h"	// For DBLShortLine.
#include "ObjPictArrow.h"	// For FCObjPictArrow.
#include "ObjFigure.h"		// For FCObjFigure.
#include "UtilMisc.h"		// For ArcTan.
#include "UtilCoord.h"		// For mm2lg.etc.
#include "UtilGraph.h"		// For FCAutoDC.
#include "UtilStr.h"		// For GetResString.
#include "UtilBezier.h"		// For DrawBezierFast2 etc.
#include "Arrow.h"			// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

////////////////////////////////////////////////////////////////////////////
// FCBaseArrow _xZkqqHx_iDeOiDiJiDfIiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myCalcTb
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHfOiCkGiCoHiCoKiClNiDhIiDfHiDeGiLmIjApMiPoDiCmMiBeBiOjOiNiP_xHqqkZx_T0_xZkqqHx_iCmFjHfOiCkGiCoHiCoKiCoJjAoGjDkKjDfP_xHqqkZx_O_xZkqqHx_iCkJiCoH_xHqqkZx_
 *			_xZkqqHx_iLjHjHkD_xHqqkZx_Q_xZkqqHx_iCmMjDfP_xHqqkZx_B_xZkqqHx_iCpAiOfKiPgPiClFiBeBiDhIiDfHiDeGiLmIjApMiCmMjDfP_xHqqkZx_O_xZkqqHx_iCkJiCoHjDfP_xHqqkZx_B_xZkqqHx_jClMjBePiCmMjDfP_xHqqkZx_(_xZkqqHx_jDfP_xHqqkZx_G)_xZkqqHx_iCnMiCmF_xHqqkZx_
 *			_xZkqqHx_iCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptO		:_xZkqqHx_jDfP_xHqqkZx_O_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			mmptB		:_xZkqqHx_jDfP_xHqqkZx_B_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			vControls	:_xZkqqHx_iDhIiDfHiDeGiLmIjApMiCpAiOhHjCoIiBeCjDfP_xHqqkZx_O-_xZkqqHx_jDfP_xHqqkZx_G_xZkqqHx_iCpAiNoNiPjMiClFiClNjCgMiCpAjFnEiClHiBeC_xHqqkZx_
 *			dT0			:_xZkqqHx_jAoGjDkKjDfPiCmMiOjOiNiP_xHqqkZx_T0_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_T0_xZkqqHx_iCmN_xHqqkZx_vControls[0]_xZkqqHx_iCmMiOjOiNiPiBeC_xHqqkZx_
 *			mmQ			:_xZkqqHx_iLjHjHkD_xHqqkZx_Q_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jDfP_xHqqkZx_B_xZkqqHx_iCmMiOjOiNiPiCpAjFnEiClHiBeCjDfP_xHqqkZx_B_xZkqqHx_iCmMiImKjChFiCkKiDhIiDfHiDeGiLmIjApMiCpAjClEiCkGiCmEiClFiCnMiCkEiPoKiNiHiCmN_xHqqkZx_-1_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	Arrow.mdrw _xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static double myCalcTb (DBLPoint& mmptB,
						FCBezierControlsVector& vControls,
						const DBLPoint& mmptO,
						double dT0,
						mmetol mmQ)
{
	const DBLPoint mmptP0 = vControls.front().A();
	const DBLPoint mmptPn = vControls.back().D();
	double dT = FFCalcAfterDistanceT(vControls[0], mmptO, dT0, mmQ);
	while (dT == -1.0)
	{
		vControls.erase(vControls.begin());
		if (vControls.empty()) break;
		dT = FFCalcAfterDistanceT(vControls[0], mmptO, 0.0, mmQ);
	}
	if (vControls.empty())
	//----- _xZkqqHx_jDfP_xHqqkZx_B_xZkqqHx_iCmMiImKjChFiCkKiDhIiDfHiDeGiLmIjApMiCpAjClEiCkGiCmEiClFiCnMiCkEiPoKiNiH_xHqqkZx_ -----
	{
		DBLPoint mmptL = mmptPn - mmptP0;
		mmptB = mmptP0 + mmptL * (mmQ / mmptL.Len());
	} else
	//----- _xZkqqHx_jDfP_xHqqkZx_B_xZkqqHx_iCmMiImKjChFiCkKiDhIiDfHiDeGiLmIjApMiCpAjClEiCkGiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		mmptB = FFCalcBezierPoint(vControls[0], dT);
	}
	return dT;
} // myCalcTb.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myCalcPointB
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHfOiCkGiCoHiCoKiClNiDhMiDiKiDfDiDjDjEhKjHpBiPoDiCmMiBeBjAoGjDkKjDfP_xHqqkZx_O_xZkqqHx_iCkJiCoHiLjHjHkD_xHqqkZx_Q_xZkqqHx_iCmMjDfP_xHqqkZx_B_xZkqqHx_iCpAiOfKiPgPiClFiBeB_xHqqkZx_
 *			_xZkqqHx_iDhMiDiKiDfDiDjDjEhKjHpBiCmMjDfP_xHqqkZx_O_xZkqqHx_iCkJiCoHjDfP_xHqqkZx_B_xZkqqHx_jClMjBePiCmMjDfP_xHqqkZx_(_xZkqqHx_jDfP_xHqqkZx_G)_xZkqqHx_iCnMiCmFiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptO			:_xZkqqHx_jDfP_xHqqkZx_O_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			mmptB			:_xZkqqHx_jDfP_xHqqkZx_B_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			mmptG			:_xZkqqHx_jDfP_xHqqkZx_G_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			vmmptPoly	:_xZkqqHx_iDhMiDiKiDfDiDjDjEhKjHpBiCpAiOhHjCoIiBeCjDfP_xHqqkZx_O-_xZkqqHx_jDfP_xHqqkZx_G_xZkqqHx_iCpAiNoNiPjMiClFiClNjCgMiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmDeltaLen	:_xZkqqHx_jDfP_xHqqkZx_B_xZkqqHx_iCmGjDfP_xHqqkZx_H_xZkqqHx_iCmMiLjHjHkDiCkKiClBiCmMjCgMiImIiJlKiCmIiCoHiCmOjDkPiIoKiCmGjElLjCgGiClDiCoKiCoJiBeC_xHqqkZx_
 *			mmQ			:_xZkqqHx_iLjHjHkD_xHqqkZx_Q_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNoNiPjMiClDiCoKiClNjDfPiCmMjAjEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	Arrow.mdrw _xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static long myCalcPointB (DBLPoint& mmptO, DBLPoint& mmptB, DBLPoint& mmptG,
						DBLPointVector& vmmptPoly, mmetol mmDeltaLen, mmetol mmQ)
{
	DBLPoint mmptH;
	mmptO = vmmptPoly[0];
	mmetol mmOH;
	long lC;
// 01.11.13 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	for (lC = 1; lC < vmmptPoly.size(); lC++)
	for (lC = 1; lC < vmmptPoly.size();)
	{
		mmptG = vmmptPoly[lC - 1];
		mmptH = vmmptPoly[lC];
		mmOH = (mmptH - mmptO).Len();
		if (almosteq(mmptG, mmptH))
		//----- _xZkqqHx_jDkPiClGjDfPiCkKjDpBiCmCjBlBiCkNiPoKiNiH_xHqqkZx_ -----
		{
			// mmptG == mmptH _xZkqqHx_iCmFiMhGiOfKiCpAjAgJiCnPiCoJiCmGiBeB_xHqqkZx_
			// DBLLine(mmptG, mmptH).GetDistancePoint _xZkqqHx_iKnGjAjEiCmFiDeHiDiJiBfLiCkKjEkNjAlGiBeC_xHqqkZx_
			// _xZkqqHx_jDfP_xHqqkZx_H_xZkqqHx_iCpAiNoNiPjMiBeC_xHqqkZx_
			vmmptPoly.erase(vmmptPoly.begin() + lC);
			// _xZkqqHx_iClBiClBiCmFiBeB_xHqqkZx_lC++_xZkqqHx_iCpAiClFiCmIiCkCiCoGiCkEiCmJjCiNiInDiBeJ_xHqqkZx_
		} else
		if (mmOH - mmDeltaLen < mmQ && mmQ < mmOH + mmDeltaLen)
		//----- _xZkqqHx_iLjHjHkD_xHqqkZx_OH_xZkqqHx_iCkKiLjHjHkD_xHqqkZx_Q_xZkqqHx_iCmJiLnPiCkCiBgJjBkGiClPjDfP_xHqqkZx_B_xZkqqHx_iCmNjDfP_xHqqkZx_H_xZkqqHx_iCmMiLnPjGfEiCmMiBgKiPoKiNiH_xHqqkZx_ -----
		{
			mmptB = mmptH;
			lC++;
			// _xZkqqHx_jDfP_xHqqkZx_O-_xZkqqHx_jDfP_xHqqkZx_H_xZkqqHx_iCpAiNoNiPjMiBeC_xHqqkZx_
			vmmptPoly.erase(vmmptPoly.begin(), vmmptPoly.begin() + lC);
			// _xZkqqHx_iNoNiPjMiClFiClNjClIjDfPiCmMjAjEiCpAjFnEiClHiBeC_xHqqkZx_
			return lC;
		} else
		if (mmQ < mmOH)
		//----- _xZkqqHx_jDfP_xHqqkZx_O_xZkqqHx_iCmGjDfP_xHqqkZx_H_xZkqqHx_iCmMiLjHjHkDiCkKiLjHjHkD_xHqqkZx_Q_xZkqqHx_iCpAiJhKiCkGiClNiPoKiNiH_xHqqkZx_ -----
		{
			DBLPoint mmptB0, mmptB1;
			// _xZkqqHx_jDfP_xHqqkZx_O_xZkqqHx_iCkJiCoHiLjHjHkDiCkK_xHqqkZx_Q_xZkqqHx_iCmFiCkAiCoJiBeBjClMjApM_xHqqkZx_GH_xZkqqHx_iPoDiCmMjDfP_xHqqkZx_ B0, B1 _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
			DBLLine(mmptG, mmptH).GetDistancePoint(mmptB0, mmptB1, mmptO, mmQ);
			// mmptG_xZkqqHx_iCmJiLnPiCkCiPiHiCmJ_xHqqkZx_B0,B1_xZkqqHx_iCpAjFmAiCnHiCoJiBeC_xHqqkZx_
			if ((mmptG - mmptB1).PowLen() < (mmptG - mmptB0).PowLen())
				Exchange(mmptB0, mmptB1);
			// B0,B1_xZkqqHx_iCmMiCkEiClPiBeBjDfP_xHqqkZx_G,_xZkqqHx_jDfP_xHqqkZx_H_xZkqqHx_iCmMiKnEiCmJiCkAiCoJjFpLiCkKjDfP_xHqqkZx_B_xZkqqHx_iBeC_xHqqkZx_
			if (DBLShortLine(mmptG, mmptH).IsInside(mmptB0))
				mmptB = mmptB0;
			else	// IsInside(mmptB1)
				mmptB = mmptB1;
			// _xZkqqHx_jDfP_xHqqkZx_O-_xZkqqHx_jDfP_xHqqkZx_G_xZkqqHx_iCpAiNoNiPjMiBeC_xHqqkZx_
			vmmptPoly.erase(vmmptPoly.begin(), vmmptPoly.begin() + lC);
			// _xZkqqHx_iNoNiPjMiClFiClNjClIjDfPiCmMjAjEiCpAjFnEiClHiBeC_xHqqkZx_
			return lC;
//----- 01.11.13 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		} else
		{
			 lC++;
		}
//----- 01.11.13 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	}
	//----- _xZkqqHx_iDhMiDiKiDfDiDjDjEhKjHpBiCmMiNmFiMoDiCnMiCmFjClCiCnHiCmEiCoAiLjHjHkD_xHqqkZx_Q_xZkqqHx_iCpAiJhKiCkGiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	// _xZkqqHx_iClBiClBiCmFiCmNiBeBjDfP_xHqqkZx_H_xZkqqHx_iCmNiBeBiDhMiDiKiDfDiDjDiCmMiNmFiMoDiCmMjDfPiCpAiOhHiClFiCmEiCkCiCoJiBeC_xHqqkZx_
	// _xZkqqHx_jDfP_xHqqkZx_B_xZkqqHx_iCpAiMhGiOfKiBeCjDfP_xHqqkZx_O=_xZkqqHx_jDfP_xHqqkZx_H_xZkqqHx_iCmMiPoKiNiHiCmNjAiFjFlNiCmMjGoOiIpDiCmJiBeC_xHqqkZx_
	if (!almost0(mmOH))
		mmptB = mmptO + (mmptH - mmptO) * (mmQ / mmOH);
	else
		mmptB = mmptO + DBLPoint(mmQ, 0.0);
	// _xZkqqHx_jDfP_xHqqkZx_O-_xZkqqHx_jDfP_xHqqkZx_H_xZkqqHx_iCpAiNoNiPjMiBeCjBkGiClPjBfDiCmEiCpAiNoNiPjMiBeC_xHqqkZx_
	vmmptPoly.clear();
	// _xZkqqHx_iNoNiPjMiClFiClNjClIjDfPiCmMjAjEiCpAjFnEiClHiBeC_xHqqkZx_
	return lC;
} // myCalcPointB.

//----- 03.07.08 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCArrowExp::~FCArrowExp
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	MolipSDK_xZkqqHx_iCmM_xHqqkZx_FCArrowExp_xZkqqHx_iCmMiDgGiDfIiDgHiDiJiDeOiDfOiBeCiClBiCoKiCkKjGlDiCkCiCmGiBeBiDiBiDiCiDiKiKeKjFpKiCkK_xHqqkZx_
// *			_xZkqqHx_iCkEiCnMiCkNiNhDiCkJiCmIiCkCiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.10.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//FCArrowExp::~FCArrowExp ()
//{
//} // FCArrowExp::~FCArrowExp.
//----- 03.07.08 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCBaseArrow::FCBaseArrow
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bWidePoly	:_xZkqqHx_jFjNiNeMiCmMiDhMiDiKiDfDiDjDiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCBaseArrow::FCBaseArrow (BOOL bWidePoly) : m_bWidePoly(bWidePoly)
{
} // FCBaseArrow::FCBaseArrow.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCBaseArrow::~FCBaseArrow
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCBaseArrow::~FCBaseArrow ()
{
} // FCBaseArrow::~FCBaseArrow.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCBaseArrow::MakeFitBezier
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhIiDfHiDeGiLmIjApMjEhKjHpBiCpAiBeBiClLiCmMjAoGjDkKiCmJjGoOiIpDiCkKjFhEiCkPiCoHiCoKiCoJiCoGiCkEiCmJjEhKjHpBiCpA_xHqqkZx_
 *			_xZkqqHx_iNfMjAkMiClHiCoJjCgMiCpAjFmPiNfIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	polyBezier	:_xZkqqHx_jEhKjHpBiCpAiOhHjCoIiBeCjFmPiNfIiClDiCoKiClNjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmP			:_xZkqqHx_iCgPiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmQ			:_xZkqqHx_iChAiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmptA		:_xZkqqHx_jDfPiCgAiCmMiNmAjFfHiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmptB		:_xZkqqHx_jDfPiCgBiCmMiNmAjFfHiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmH			:_xZkqqHx_jApMiCmMjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmMinH		:_xZkqqHx_jApMiCmMjFjNiCmMiNmFjCoBjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	Arrow.mdrw _xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCBaseArrow::MakeFitBezier (	FCMmPolyBezier& polyBezier,
									mmetol& mmP,
									mmetol& mmQ,
									DBLPoint& mmptA,
									DBLPoint& mmptB,
									mmetol mmH,
									mmetol mmMinH) const
{
	FCBezierControlsVector vControls;
	FFControlConv(vControls, polyBezier);
do {
	// _xZkqqHx_jDfP_xHqqkZx_B,C,J,K_xZkqqHx_iOfKiPgPjHhAiCmM_xHqqkZx_W_xZkqqHx_iCmNiBeB_xHqqkZx_mmW_xZkqqHx_iCmJjFmPiNfIiBeCiNmFjCoBjCgMiCpAiOhHjCoIiClHiCoJiClNiCnPiBeC_xHqqkZx_
	mmetol mmW = mmH;
	// mmW _xZkqqHx_iCmMjBoFiCkLiClDiCpAiBeBiNmFjCoBiCmFiCoA_xHqqkZx_ mmMinH _xZkqqHx_iCmJiBeC_xHqqkZx_mmW = 0 _xZkqqHx_iCpAjEpAiCkPiCoJiBeC_xHqqkZx_
	if (mmW < mmMinH) mmW = mmMinH;
	// mmP = 0 _xZkqqHx_iCmFiCoAjGoCjBoIiCmIiCkNjDkOiNoMiClHiCoJiCoGiCkEiCmJiClFiCmEiCkAiCoJiBeC_xHqqkZx_
	mmP = GetP(mmH);
	mmQ = mmP + (0.5 * mmW);
	DBLPoint mmptO = vControls[0].A();
	// _xZkqqHx_jHfOiCkGiCoHiCoKiClNiDhIiDfHiDeGiLmIjApMiPoDiCmMiBeBjAoGjDkKjDfP_xHqqkZx_O(t=0.0)_xZkqqHx_iCkJiCoHiLjHjHkD_xHqqkZx_Q_xZkqqHx_iCmMjDfP_xHqqkZx_B(t=Tb)_xZkqqHx_iCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
	double dTb = myCalcTb(mmptB, vControls, mmptO, 0.0, mmQ);
	// _xZkqqHx_jDfP_xHqqkZx_A_xZkqqHx_iCpAiOfKiPgPiBeC_xHqqkZx_
	mmptA = mmptO + (mmptB - mmptO) * (mmP / mmQ);
	if (vControls.empty())
	//----- _xZkqqHx_jBfDiCmEiCmMiDhIiDfHiDeGiLmIjApMiCkKiNoNiPjMiClDiCoKiClNiBgJjBkGiClPiLjHjHkD_xHqqkZx_Q_xZkqqHx_iCkKjBfDiDhIiDfHiDeGiLmIjApMiCpAiJhKiCkGiCoJiBgKiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jDfPiCgAiBeBjDfPiCgBiCpAiMiLiCnEjClMjApMiCmMiDhIiDfHiDeGiCpAjBhNjDpMiBeC_xHqqkZx_
		vControls.push_back(FCBezierControls(mmptA, mmptA, mmptB, mmptB));
		break;
	}
	if (vControls[0].IsLine())
	//----- _xZkqqHx_iCgBiCkJiCoHjAoGiCmMiDhIiDfHiDeGiLmIjApMiCkKjClMjApMiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// A-B,B-_xZkqqHx_iCpAjClMjApMiCmJiClHiCoJiBeCjDfPiCgBiCmN_xHqqkZx_vControls[0]_xZkqqHx_iPoDiCmJiCkAiCoJiCmMiCmFiBeBiOgOjDfPiCpAiCgBiCmJiClHiCoKiCmOiCoGiCkCiBeC_xHqqkZx_
		vControls[0].A() = mmptB;
		vControls[0].B() = mmptB;
		vControls[0].C() = vControls[0].D();
		vControls.insert(vControls.begin(), FCBezierControls(mmptA, mmptA, mmptB, mmptB));
		break;
	}

	DBLPoint mmptC;
	// _xZkqqHx_jHfOiCkGiCoHiCoKiClNiDhIiDfHiDeGiLmIjApMiPoDiCmMiBeBjDfP_xHqqkZx_B(t=Tb)_xZkqqHx_iCkJiCoHiLjHjHkD_xHqqkZx_W_xZkqqHx_iCmMjDfP_xHqqkZx_C(t=Tc)_xZkqqHx_iCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
	double dTc = myCalcTb(mmptC, vControls, mmptB, dTb, mmW);
	if (vControls.empty())
	//----- _xZkqqHx_jBfDiCmEiCmMiDhIiDfHiDeGiLmIjApMiCkKiNoNiPjMiClDiCoKiClNiBgJjBkGiClPjDfPiCgBiCkJiCoHiLjHjHkDiChGiCkKjBfDiDhIiDfHiDeGiLmIjApMiCpAiJhKiCkGiCoJiBgKiPoKiNiH_xHqqkZx_ -----
	{
		break;
	}
	// _xZkqqHx_iDhIiDfHiDeGiLmIjApMiCmMiBeBjDfP_xHqqkZx_C(t=Tc)_xZkqqHx_iBgAiPeJjDfP_xHqqkZx_(t=1.0)_xZkqqHx_iCpAjAfGiClFiCkCiDhIiDfHiDeGiLmIjApMiCmFiLnPiOjHiBeC_xHqqkZx_
	FFChopBezier(vControls[0], vControls[0], dTc, 1.0);

	//----- _xZkqqHx_jDfP_xHqqkZx_J,K_xZkqqHx_iCpAiOfKiPgPiClFiBeBiCgAiCgCiCpAiMiLiCnEiLnPiOjHiDhIiDfHiDeGiCpAjBhNjDpM_xHqqkZx_ ------
	DBLPoint mmptJ = mmptA + (mmptB - mmptA) * (0.8 / 0.5);
	DBLPoint mmptLc = vControls[0].A() - vControls[0].B();
	if (almost0(mmptLc))
		mmptLc = vControls[0].A() - vControls[0].C();
	if (almost0(mmptLc))
		mmptLc = vControls[0].A() - vControls[0].D();
	mmptLc /= mmptLc.Len();
	DBLPoint mmptK = vControls[0].A() + mmptLc * (0.5 * mmW);
	vControls.insert(vControls.begin(), FCBezierControls(mmptA, mmptB, mmptK, mmptC));

} while (FALSE);
	FFControlConv(polyBezier, vControls);
} // FCBaseArrow::MakeFitBezier.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCBaseArrow::InitByPoly
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhMiDiKiDfDiDjDjEhKjHpBiCpAiBeBiClLiCmMjAoGjDkKiCmJjGoOiIpDiCkKjFhEiCkPiCoHiCoKiCoJiCoGiCkEiCmJjEhKjHpBiCpAiNfMjAkMiClHiCoJ_xHqqkZx_
 *			_xZkqqHx_jCgMiCpAjFmPiNfIiClFiCmEiBeBjGoOiIpDiCpAiClLiCoKiCmJiNiHiCoNiClJiCmEiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vmmptPoly	:_xZkqqHx_jEhKjHpBiCpAiOhHjCoIiBeCjFmPiNfIiClDiCoKiClNjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmH			:_xZkqqHx_jApMiCmMjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmElemLen	:_xZkqqHx_jClIjDfPiNmAjFfHjEhKjHpBiCmMiJpAjBjMjDhIiCpAiOhHjCoIiBeCjClIjDfPiNmAjFfHiKnEiCmMiLjHjHkDiCmM_xHqqkZx_
 *						 _xZkqqHx_jGnKiImAiCpAiOkGiClHiBeCjFiJiCmMiPoKiNiHiCmNiNmFjDeLjCgMiCpAiOkJjDkOjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			psidPenStyle	:_xZkqqHx_iDhJiDjDiCmMiDfIiDfOiDeDiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmfPenWeight	:_xZkqqHx_iDhJiDjDiCmMjBlOiClDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			scidPenBackSColor	:_xZkqqHx_iDhJiDjDiCmMjEhHiMgJjAeGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			ptidBrushPattern	:_xZkqqHx_iDhFiDiJiDfGiCmMiDhAiDfOiBfLiDjDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			scidBrushForeSColor	:_xZkqqHx_iDhFiDiJiDfGiCmMjBePiMgJjAeGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			scidBrushBackSColor	:_xZkqqHx_iDhFiDiJiDfGiCmMjEhHiMgJjAeGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			scidShadowSColor	:_xZkqqHx_iJgFiCmMjAeGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	Arrow.mdrw _xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCBaseArrow::InitByPoly (	DBLPointVector& vmmptPoly,
								mmetol mmH,
								mmetol mmElemLen,
								PenStyleID psidPenStyle,
								fmmetol mmfPenWeight,
								SColorID scidPenBackSColor,
								PatternID ptidBrushPattern,
								SColorID scidBrushForeSColor,
								SColorID scidBrushBackSColor,
								SColorID scidShadowSColor)
{
	DBLPoint mmptA;
	DBLPoint mmptB;
do {
	// _xZkqqHx_jDfP_xHqqkZx_B,C,J,K_xZkqqHx_iOfKiPgPjHhAiCmM_xHqqkZx_W_xZkqqHx_iCmNiBeB_xHqqkZx_mmW_xZkqqHx_iCmJjFmPiNfIiBeCiNmFjCoBjCgMiCpAiOhHjCoIiClHiCoJiClNiCnPiBeC_xHqqkZx_
	mmetol mmW = mmH;
	// mmW _xZkqqHx_iCmMjBoFiCkLiClDiCpAiBeBiNmFjCoBiCmFiCoA_xHqqkZx_ mmElemLen _xZkqqHx_iCmJiBeC_xHqqkZx_mmW = 0 _xZkqqHx_iCpAjEpAiCkPiCoJiBeC_xHqqkZx_
	if (mmW < mmElemLen) mmW = mmElemLen;
	// mmP = 0 _xZkqqHx_iCmFiCoAjGoCjBoIiCmIiCkNjDkOiNoMiClHiCoJiCoGiCkEiCmJiClFiCmEiCkAiCoJiBeC_xHqqkZx_
	mmetol mmP = GetP(mmH);
	mmetol mmQ = mmP + (0.5 * mmW);
	mmetol mmDeltaLen = mmElemLen * 0.1;
	DBLPoint mmptO;
	DBLPoint mmptG;
	// _xZkqqHx_jHfOiCkGiCoHiCoKiClNiDhMiDiKiDfDiDjDjEhKjHpBiPoDiCmMiBeBjAoGjDkKjDfP_xHqqkZx_O_xZkqqHx_iCkJiCoHiLjHjHkD_xHqqkZx_Q_xZkqqHx_iCmMjDfP_xHqqkZx_B_xZkqqHx_iCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
	(void)myCalcPointB(mmptO, mmptB, mmptG, vmmptPoly, mmDeltaLen, mmQ);
	// _xZkqqHx_jDfP_xHqqkZx_A_xZkqqHx_iCpAiOfKiPgPiBeC_xHqqkZx_
	mmptA = mmptO + (mmptB - mmptO) * (mmP / mmQ);
	if (vmmptPoly.empty())
	//----- _xZkqqHx_jBfDiCmEiCmMiDhMiDiKiDfDiDjDiCkKiNoNiPjMiClDiCoKiClNiBgJjBkGiClPiLjHjHkD_xHqqkZx_Q_xZkqqHx_iCkKjBfDiDhMiDiKiDfDiDjDiCpAiJhKiCkGiCoJiBgKiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jDfP_xHqqkZx_B_xZkqqHx_iCpAjBhNjDpMiBeC_xHqqkZx_
		vmmptPoly.insert(vmmptPoly.begin(), mmptB);
		// _xZkqqHx_jDfP_xHqqkZx_A_xZkqqHx_iCpAjBhNjDpMiBeC_xHqqkZx_
		vmmptPoly.insert(vmmptPoly.begin(), mmptA);
		break;
	}
	if (DBLLine(mmptO, mmptB).IsMostOnLine(vmmptPoly[0]))
	//----- _xZkqqHx_jDfP_xHqqkZx_O,_xZkqqHx_jDfP_xHqqkZx_B,_xZkqqHx_jDfP_xHqqkZx_H_xZkqqHx_iCkKiIoKjClMjApMiCmJjFmAiCnEiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jDfP_xHqqkZx_A_xZkqqHx_iCpAjBhNjDpMiBeC_xHqqkZx_
		vmmptPoly.insert(vmmptPoly.begin(), mmptA);
		// _xZkqqHx_jDfP_xHqqkZx_A_xZkqqHx_iCmGjDfP_xHqqkZx_C_xZkqqHx_iCpAiLmIjApMiCmFjFoCiKnEiClHiCoJjFeLjHhGiCmNjGlDiCkCiBeC_xHqqkZx_
		break;
	}
	// _xZkqqHx_jDfP_xHqqkZx_B_xZkqqHx_iCpAjBhNjDpMiBeC_xHqqkZx_
	vmmptPoly.insert(vmmptPoly.begin(), mmptB);
	DBLPoint mmptC;
	DBLPoint mmptI;
	// _xZkqqHx_jHfOiCkGiCoHiCoKiClNiDhMiDiKiDfDiDjDjEhKjHpBiPoDiCmMiBeBjDfP_xHqqkZx_B_xZkqqHx_iCkJiCoHiLjHjHkD_xHqqkZx_W_xZkqqHx_iCmMjDfP_xHqqkZx_C_xZkqqHx_iCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
	long lCutNum = myCalcPointB(mmptB, mmptC, mmptI, vmmptPoly, mmDeltaLen, mmW);
	if (lCutNum == 1)
	//----- _xZkqqHx_iNoNiPjMiClDiCoKiClNjDfPiCkKiIoKiCmCiClOiCkPiBgJjBkGiClPjDfP_xHqqkZx_B_xZkqqHx_iCmMiCnNiBgKiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jApM_xHqqkZx_G-H-I_xZkqqHx_iCmNjClMjApMiCmFiCkAiCoJiJmCjEfMjAkLiCkKiNiCiCkCiBeCiLmIjApMjFoCiKnEiCmNiClFiCmIiCkCiBeC_xHqqkZx_
		// _xZkqqHx_jDfP_xHqqkZx_B_xZkqqHx_iCpAjBhNjDpMiBeC_xHqqkZx_
		vmmptPoly.insert(vmmptPoly.begin(), mmptB);
		// _xZkqqHx_jDfP_xHqqkZx_A_xZkqqHx_iCpAjBhNjDpMiBeC_xHqqkZx_
		vmmptPoly.insert(vmmptPoly.begin(), mmptA);
		break;
	}
	if (lCutNum == 2)
	//----- _xZkqqHx_iNoNiPjMiClDiCoKiClNjDfPiCkKjDpBiCmCiClOiCkPiBgJjBkGiClPjDfP_xHqqkZx_B_xZkqqHx_iBeBjDfP_xHqqkZx_I_xZkqqHx_iCmMiCnNiBgKiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jApM_xHqqkZx_G-H-I_xZkqqHx_iCmNjClMjApMiCmFiCkAiCoJiJmCjEfMjAkLiCkKiNiCiCkCiBeCiLmIjApMjFoCiKnEiCmNiClFiCmIiCkCiBeC_xHqqkZx_
		// _xZkqqHx_jDfP_xHqqkZx_I_xZkqqHx_iCpAjBhNjDpMiBeC_xHqqkZx_
		vmmptPoly.insert(vmmptPoly.begin(), mmptI);
		// _xZkqqHx_jDfP_xHqqkZx_B_xZkqqHx_iCpAjBhNjDpMiBeC_xHqqkZx_
		vmmptPoly.insert(vmmptPoly.begin(), mmptB);
		// _xZkqqHx_jDfP_xHqqkZx_A_xZkqqHx_iCpAjBhNjDpMiBeC_xHqqkZx_
		vmmptPoly.insert(vmmptPoly.begin(), mmptA);
		break;
	}
	//----- _xZkqqHx_jDfP_xHqqkZx_J,K_xZkqqHx_iCpAiOfKiPgP_xHqqkZx_ ------
	// mmptI == mmptC_xZkqqHx_iCmMiPoKiNiHiCmNiMhGiOfKiCkKiCkEiCnMiCkNiNhDiCkJiCmIiCkCiBeC_xHqqkZx_
	// myCalcPointB_xZkqqHx_iKnGjAjEiCmNiBeB_xHqqkZx_mmptI_xZkqqHx_iCmG_xHqqkZx_mmptC_xZkqqHx_iCkKiLnPiCkCiPoKiNiHiCmN_xHqqkZx_mmptC_xZkqqHx_iCpA_xHqqkZx_mmptI_xZkqqHx_iPoDiCmJiOoGiCoIiBeB_xHqqkZx_
	// mmptI_xZkqqHx_iCpAiNoNiPjMiClHiCoJiCmMiCmFiBeB_xHqqkZx_mmptI == mmptC_xZkqqHx_iCmNiCkAiCoIiCkGiCmIiCkCiBeC_xHqqkZx_
	DBLPoint mmptJ = mmptA + (mmptB - mmptA) * (0.8 / 0.5);
	DBLPoint mmptK = mmptC + (mmptI - mmptC) * (0.5 * mmW) / (mmptI - mmptC).Len();
	//----- _xZkqqHx_jDfP_xHqqkZx_A-_xZkqqHx_jDfP_xHqqkZx_C_xZkqqHx_iCmMjFoCiKnEiLmIjApM_xHqqkZx_(_xZkqqHx_jDfP_xHqqkZx_A_xZkqqHx_iCmNiKnMiCnMiCmIiCkCiBeBjDfP_xHqqkZx_C_xZkqqHx_iCmNiKnMiCnO_xHqqkZx_)_xZkqqHx_iCpAiMhGiOfK_xHqqkZx_ -----
	DBLPoint mmptaStone4[] = { mmptA, mmptJ, mmptK, mmptC };
	DBLPointVector vmmptStuff;
	::DrawBezierFast2(vmmptStuff, mmptaStone4, lCutNum);
	// _xZkqqHx_jDfP_xHqqkZx_A-_xZkqqHx_jDfP_xHqqkZx_C_xZkqqHx_iCmMjFoCiKnEiLmIjApM_xHqqkZx_(_xZkqqHx_jDfP_xHqqkZx_A_xZkqqHx_iCmNiKnMiCnMiCmIiCkCiBeBjDfP_xHqqkZx_C_xZkqqHx_iCmNiKnMiCnO_xHqqkZx_)_xZkqqHx_iCpAjBhNjDpMiBeC_xHqqkZx_
	vmmptPoly.insert(vmmptPoly.begin(), vmmptStuff.begin(), vmmptStuff.end());
	// _xZkqqHx_jDfP_xHqqkZx_A_xZkqqHx_iCpAjBhNjDpMiBeC_xHqqkZx_
	vmmptPoly.insert(vmmptPoly.begin(), mmptA);
} while (FALSE);
	InitArrow(mmH, mmptA, mmptB, psidPenStyle, mmfPenWeight,
				scidPenBackSColor, ptidBrushPattern,
				scidBrushForeSColor, scidBrushBackSColor, scidShadowSColor);
} // FCBaseArrow::InitByPoly.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCBaseArrow::FillArrow
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jGoOiIpDiCmMjGhLjBmMjAnKjBlBjFjEjFkKiCpAiOhHjCoIiCmMjAeGiCmFjDgIiCmCiCnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC			:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmElemLen	:_xZkqqHx_jClIjDfPiNmAjFfHjEhKjHpBiCmMiJpAjBjMjDhIiCpAiOhHjCoIiBeCjClIjDfPiNmAjFfHiKnEiCmMiLjHjHkDiCmM_xHqqkZx_
 *						 _xZkqqHx_jGnKiImAiCpAiOkGiClHiBeCjFiJiCmMiPoKiNiHiCmNiNmFjDeLjCgMiCpAiOkJjDkOjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			scid		:_xZkqqHx_jDgIiCmCiCnEiClFjAeGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lgrtRgn		:_xZkqqHx_jFgAiJoGjHmMiIoGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCBaseArrow::FillArrow (CDC* pDC, mmetol mmElemLen, SColorID scid, const CRect& lgrtRgn) const
{
	DBLPointVector vmmptPoly;
	GetPolygon(vmmptPoly, mmElemLen);
	CPointVector vlgptPoly;
	mm2lg(vlgptPoly, vmmptPoly);
	FCDraw draw(pDC);
	draw.PenInitNull();
	draw.BrushInit(FD_PATTERN_UNUSE, FD_S_COLOR_TRANSPARENT, scid);
	draw.Polygon(vlgptPoly.begin(), vlgptPoly.size(), lgrtRgn);
} // FCBaseArrow::FillArrow.

//----------<NOT EXPORT TO VIEWER>-----------

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCBaseArrow::FillArrow
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jGoOiIpDiCmMjGhLjBmMjAnKjBlBjFjEjFkKiCpAjDgIiCmCiCnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	eDraw		:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmElemLen	:_xZkqqHx_jClIjDfPiNmAjFfHjEhKjHpBiCmMiJpAjBjMjDhIiCpAiOhHjCoIiBeCjClIjDfPiNmAjFfHiKnEiCmMiLjHjHkDiCmM_xHqqkZx_
 *						 _xZkqqHx_jGnKiImAiCpAiOkGiClHiBeCjFiJiCmMiPoKiNiHiCmNiNmFjDeLjCgMiCpAiOkJjDkOjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCBaseArrow::FillArrow (FCEditDraw& eDraw, mmetol mmElemLen) const
{
	DBLPointVector vmmptPoly;
	GetPolygon(vmmptPoly, mmElemLen);
	CPointVector vlgptPoly;
	mm2lg(vlgptPoly, vmmptPoly);
	eDraw.Polygon(vlgptPoly.begin(), vlgptPoly.size());
} // FCBaseArrow::FillArrow.

//----------</NOT EXPORT TO VIEWER>-----------

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCBaseArrow::CalcOuterFrame
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	mmptEdge_xZkqqHx_iCmMiImKjChFiCmJiCkAiCoJjGoOiIpDiCkKiNmFjBoFiCmFjFgAiJoGiClDiCoKiCkEiCoJiDhEiDiMiBfLiDiAiCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmrtFrame	:_xZkqqHx_iDhEiDiMiBfLiDiAiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmptEdge	:_xZkqqHx_jGoOiIpDiCmMjBlGiNnNiClHiCoJjCfLjDfPiCmMiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmH			:_xZkqqHx_iDhMiDiKiDfDiDjDjApMiCmMjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmfPenWeight:_xZkqqHx_jFgAiJoGjApMiCmMjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jBoFiCnMiCkJiCmIjCgMiCpAiMhGiOfKiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCBaseArrow::CalcOuterFrame (DBLRect& mmrtFrame, const DBLPoint& mmptEdge,
									mmetol mmH, fmmetol mmfPenWeight) const
{
	const mmetol mmP = GetP(mmH);
	// _xZkqqHx_jDfP_xHqqkZx_O_xZkqqHx_iCpA_xHqqkZx_(0,0)_xZkqqHx_iCmGiClHiCoJiDhEiDiMiBfLiDiAiCpAiOoGjDlOiBeCiDhEiDiMiBfLiDiAiCmJiCmN_xHqqkZx_mmfPenWeight_xZkqqHx_iCpAiNgMjHlGiNmPiCnNiBeC_xHqqkZx_
	mmrtFrame = GetFrame(mmH, mmfPenWeight) + DBLPoint(mmP, 0.0);
	// _xZkqqHx_jGoOiIpDiCmMiKePjAnKiDhEiDiMiBfLiDiAiBgJiNmFjBoFjCgMiBgKiCpAiNoMjAkMiBeC_xHqqkZx_
	mmetol mmPowLen = DBLPoint(mmrtFrame.left, mmrtFrame.top).PowLen();
	if (mmPowLen < DBLPoint(mmrtFrame.right, mmrtFrame.top).PowLen())
		mmPowLen = DBLPoint(mmrtFrame.right, mmrtFrame.top).PowLen();
	if (mmPowLen < DBLPoint(mmrtFrame.right, mmrtFrame.bottom).PowLen())
		mmPowLen = DBLPoint(mmrtFrame.right, mmrtFrame.bottom).PowLen();
	if (mmPowLen < DBLPoint(mmrtFrame.left, mmrtFrame.bottom).PowLen())
		mmPowLen = DBLPoint(mmrtFrame.left, mmrtFrame.bottom).PowLen();
	mmetol mmLen = sqrt(mmPowLen);
	// _xZkqqHx_iKePjAnKiDhEiDiMiBfLiDiAiCmJjGoOiIpDiCkKjHfOiCkGiCkEiCoJiNmFjBoFiCmMiJgFiLlPiCpAiNgMjHlGiBeC_xHqqkZx_
	mmrtFrame.SetRect(mmptEdge - mmLen, mmptEdge + mmLen);
} // FCBaseArrow::CalcOuterFrame.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCBaseArrow::CalcAffectFrame
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	mmptEdge_xZkqqHx_iCmMiImKjChFiCmJiCkAiCoJjGoOiIpDiCkKiBeBiClLiClBiCkJiCoHiCmCiCmIiCkKiCoJiDhMiDiKiDfDiDjDiCmJ_xHqqkZx_
 *			_xZkqqHx_iNmFjBoFiCmFiLhJiCnKiClFiCkEiCoJjEmNiImNiCmMiLoJiMgAiCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmrtFrame	:_xZkqqHx_iDhEiDiMiBfLiDiAiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmptEdge	:_xZkqqHx_jGoOiIpDiCmMjBlGiNnNiClHiCoJjCfLjDfPiCmMiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmH			:_xZkqqHx_iDhMiDiKiDfDiDjDjApMiCmMjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmfPenWeight:_xZkqqHx_jFgAiJoGjApMiCmMjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jGoOiIpDiCmMiMhGiOfKiCmNiBeBjGoOiIpDiCmMjCfLjDfPiCkJiCoHiNmFjBoFiCmF_xHqqkZx_ P + 0.5W + W _xZkqqHx_iCmMiLjHjHkDiCmMjEmNiImNiCmM_xHqqkZx_
 *			_xZkqqHx_jIeBiMiLjDfPiCmMiDhMiDiKiDfDiDjDiCkKjAlDiKgNiCmJiMhGiOfKiClDiCoKiCmEiCkCiCmIiCkCiCmGiBeBjGoOiIpDiCpAiDhMiDiKiDfDiDjDiCmJ_xHqqkZx_
 *			_xZkqqHx_jAnKjBlBiClHiCoJiClNiCnPiCmMiMhGiOfKiCkKjAlDiClFiCkNiNhDiCoNiCoKiCmIiCkCiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiClNiCnPiBeBjGoOiIpDiCmMjCfLjDfPiCpAjCiGjAfDiCmJ_xHqqkZx_ P + 0.5W + W _xZkqqHx_iCmMiLjHjHkDiCpAiCoAiCmCiLoJiMgAiCkK_xHqqkZx_
 *			_xZkqqHx_iNmEjFgAiJoGjEmNiImNiCmJjDpMiCoJiCkJiCmHiCkEiCkJiCpAiDgAiDeGiDgCiDeOiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiLoJiMgAiCmMjEmNiImNiCmJjDpMiCoJiDhMiDiKiDfDiDjDiCmNiBeBjGoOiIpDiCmMiNmEiMhGiOfKiOjOiCmJjDkPiOjOiCmJiNmEiMhGiOfK_xHqqkZx_
 *			_xZkqqHx_iClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
 *			Arrow.mdrw _xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCBaseArrow::CalcAffectFrame (DBLRect& mmrtFrame, const DBLPoint& mmptEdge,
									mmetol mmH, fmmetol mmfPenWeight) const
{
	const mmetol mmP = GetP(mmH);
	// _xZkqqHx_jDfP_xHqqkZx_O_xZkqqHx_iCpA_xHqqkZx_(0,0)_xZkqqHx_iCmGiClHiCoJiDhEiDiMiBfLiDiAiCpAiOoGjDlOiBeCiDhEiDiMiBfLiDiAiCmJiCmN_xHqqkZx_mmfPenWeight_xZkqqHx_iCpAiNgMjHlGiNmPiCnNiBeC_xHqqkZx_
	mmrtFrame = GetFrame(mmH, mmfPenWeight) + DBLPoint(mmP, 0.0);
	// _xZkqqHx_jGoOiIpDiCmMiKePjAnKiDhEiDiMiBfLiDiAiBgJiNmFjBoFjCgMiBgKiCpAiNoMjAkMiBeC_xHqqkZx_
	mmetol mmLen = mmP + (1.5 * mmH) + (mmfPenWeight / 2.0);
	mmetol mmPowLen = mmLen * mmLen;
	if (mmPowLen < DBLPoint(mmrtFrame.left, mmrtFrame.top).PowLen())
		mmPowLen = DBLPoint(mmrtFrame.left, mmrtFrame.top).PowLen();
	if (mmPowLen < DBLPoint(mmrtFrame.right, mmrtFrame.top).PowLen())
		mmPowLen = DBLPoint(mmrtFrame.right, mmrtFrame.top).PowLen();
	if (mmPowLen < DBLPoint(mmrtFrame.right, mmrtFrame.bottom).PowLen())
		mmPowLen = DBLPoint(mmrtFrame.right, mmrtFrame.bottom).PowLen();
	if (mmPowLen < DBLPoint(mmrtFrame.left, mmrtFrame.bottom).PowLen())
		mmPowLen = DBLPoint(mmrtFrame.left, mmrtFrame.bottom).PowLen();
	if (mmLen * mmLen < mmPowLen)
		mmLen = sqrt(mmPowLen);
	// _xZkqqHx_jGoOiIpDiCkKjHfOiCkGiCkEiCoJiNmFjBoFiCmMiJgFiLlPiCmMjEmNiImNiCmMiLoJiMgAiBeC_xHqqkZx_
	mmrtFrame.SetRect(mmptEdge - mmLen, mmptEdge + mmLen);
} // FCBaseArrow::CalcAffectFrame.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCBaseArrow::Release
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiJpAjFpKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iClBiCmMiDiCiDfHiDiFiBfLiDiLiCkJiCoHiCmIiCoH_xHqqkZx_delete_xZkqqHx_iCmFiCoAjHmHiCkCiCkKiBeBjBlMiCmMiDiCiDfHiDiFiBfLiDiLiCkJiCoHiCmN_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiKnGjAjEiCpAiOgHiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.10.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCBaseArrow::Release ()
{
	delete this;
} // FCBaseArrow::Release.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCBaseArrow::GetPostPolyline
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPoDiPpMiCoIiCmFjFgAiJoGiClDiCoKiCoJjApMiCmMjClIjDfPjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vmmptPoly	:_xZkqqHx_jClIjDfPjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	_xZkqqHx_jGfPiPpDiCmMjGoOiIpDiCmMiPoKiNiHiBeBjGfPiCmMjFgAiJoGiCkKiPoDiPpMiCoIiCmFjFeLjHhGiBeC_xHqqkZx_
 *			FCStdArrow_xZkqqHx_iDeOiDiJiDfIiCmMiDiBiDjDiDgPiKnGjAjEiBeC_xHqqkZx_MolipSDK/FCArrow_xZkqqHx_jHhAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.10.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCBaseArrow::GetPostPolyline (DBLPointVector& vmmptPoly) const
{
} // FCBaseArrow::GetPostPolyline.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCBaseArrow::GetP
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jGoOiIpDiCmMjAoGjCfLiCkJiCoHiBeBjGoOiIpDjAnKjBlBjDfP_xHqqkZx_A_xZkqqHx_iCnMiCmFiCmMiLjHjHkDiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmH	:_xZkqqHx_jAnKjBlBiClDiCoKiCoJjApMiCmMjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iLjHjHkD_xHqqkZx_P_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	FCStdArrow_xZkqqHx_iDeOiDiJiDfIiCmMiDiBiDjDiDgPiKnGjAjEiBeC_xHqqkZx_MolipSDK/FCArrow_xZkqqHx_jHhAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	Arrow.mdrw _xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.10.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
mmetol FCBaseArrow::GetP (mmetol mmH, const FCUGPqr& pqr) const
{
	return 0.0;
} // FCBaseArrow::GetP.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCBaseArrow::GetLocalObject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMjGoOiIpDjHhAiCmJjFkBjAlLiClDiCoKiBeBiDiNiBfLiDeKiDiJiDeDiDfJiClDiCoKiClNiDhDiDeOiDgAiDiDjGoOiIpDjFjEjFgJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhDiDeOiDgAiDiDjGoOiIpDjFjEjFgJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	FCPictArrow_xZkqqHx_iDeOiDiJiDfIiCmMiDiBiDjDiDgPiKnGjAjEiBeC_xHqqkZx_MolipSDK/FCArrow_xZkqqHx_jHhAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.10.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCObjPictArrow* FCBaseArrow::GetLocalObject () const
{
	return NULL;
} // FCBaseArrow::GetLocalObject.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCBaseArrow::GetStdObject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jGoOiIpD_xHqqkZx_ID_xZkqqHx_iCmGjFjNiNeMjApMiCkJiCmHiCkEiCkJiCmMiPoOjFpBiCkJiCoHiBeBiOfBiPmGiClHiCnHiCkLjGoOiIpDjFjEjFgJiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jGoOiIpDjFjEjFgJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	FCPictArrow_xZkqqHx_iDeOiDiJiDfIiCmMiDiBiDjDiDgPiKnGjAjEiBeC_xHqqkZx_MolipSDK/FCArrow_xZkqqHx_jHhAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.10.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const FCObjPictArrow* FCBaseArrow::GetStdObject () const
{
	return NULL;
} // FCBaseArrow::GetStdObject.

////////////////////////////////////////////////////////////////////////////
// FCStdArrow _xZkqqHx_iDeOiDiJiDfIiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCStdArrow::FCStdArrow
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	params		:_xZkqqHx_jFfHiPiAjGoOiIpDiCmMiMgAiPpDiCpAiMiIjCoIiClHiCoJiDhAiDiJiDiBiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bWidePoly	:_xZkqqHx_jFjNiNeMiCmMiDhMiDiKiDfDiDjDiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCStdArrow::FCStdArrow (const FCUGArrowParams& params, BOOL bWidePoly)
			: FCBaseArrow(bWidePoly)
{
	m_params = params;
} // FCStdArrow::FCStdArrow.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCStdArrow::Type
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeOiDiJiDfIiDfOiDeDiDhGiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeOiDiJiDfIiDfOiDeDiDhGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.10.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FTArrowClassType FCStdArrow::Type () const
{
	return FDAW_STANDARD;	// FCStdArrow_xZkqqHx_iDeOiDiJiDfIiBeC_xHqqkZx_
} // FCStdArrow::Type.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCStdArrow::GetP
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jGoOiIpDiCmMjAoGjCfLiCkJiCoHiBeBjGoOiIpDjAnKjBlBjDfP_xHqqkZx_A_xZkqqHx_iCnMiCmFiCmMiLjHjHkDiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmH	:_xZkqqHx_jAnKjBlBiClDiCoKiCoJjApMiCmMjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iLjHjHkD_xHqqkZx_P_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	Arrow.mdrw _xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
mmetol FCStdArrow::GetP (mmetol mmH) const
{
	FCUGPqr pqr;
	CalcPQR(pqr, mmH, m_params);
	return GetP(mmH, pqr);
} // FCStdArrow::GetP.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCStdArrow::GetFrame
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDfP_xHqqkZx_A_xZkqqHx_iCpA_xHqqkZx_(0,0)_xZkqqHx_iCmGiClFiClNiCmGiCkLiCmMiBeBiDhDiDeOiDgAiDiDjGoOiIpDiDhEiDiMiBfLiDiAiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmH	:_xZkqqHx_jAnKjBlBiClDiCoKiCoJjApMiCmMjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhDiDeOiDgAiDiDjGoOiIpDiDhEiDiMiBfLiDiAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	Arrow.mdrw _xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DBLRect FCStdArrow::GetFrame (mmetol mmH, fmmetol mmWeight) const
{
	FCUGPqr pqr;
	CalcPQR(pqr, mmH, m_params);
	mmetol mmP = GetP(mmH, pqr);
	DBLRect mmrtFrame(0, -pqr.dR, (pqr.dP < pqr.dQ) ? pqr.dQ : pqr.dP, pqr.dR);
	mmrtFrame -= DBLPoint(mmP, 0.0);
	// _xZkqqHx_iKnLjGfPiCmMjGoOiIpDiCmMiPoKiNiHiBeBiDhJiDjDiCmMjBlOiClD_xHqqkZx_/2 _xZkqqHx_jFkKiCnJiCmHiNeMiClAiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
	switch (m_params.byType)
	{
	case FDUG_ARW_TYPE_TYPICAL:		// _xZkqqHx_jCoIiMgAiDhAiDfOiBfLiDjDiBeC_xHqqkZx_
		switch (m_params.byParam0)
		{
		case FDUG_ARW_STYL_ARROW_A0:	// _xZkqqHx_jCfKiCkCjGoOiIpDiBgJjGfPiPpDiBgKiBeC_xHqqkZx_
		case FDUG_ARW_STYL_ARROW_A1:	// _xZkqqHx_jFiBjCmKjGoOiIpDiBgJjGfPiPpDiBgKiBeC_xHqqkZx_
		case FDUG_ARW_STYL_ARROW_A2:	// _xZkqqHx_jClHiCkCjGoOiIpDiBgJjGfPiPpDiBgKiBeC_xHqqkZx_
			mmrtFrame.Extend(mmWeight / 2.0);
			break;
		}
		break;
	case FDUG_ARW_TYPE_ARROW_A:		// _xZkqqHx_jGoOiIpDiBgJjGfPiPpDiBgKiBeC_xHqqkZx_
		mmrtFrame.Extend(mmWeight / 2.0);
		break;
	}
	return mmrtFrame;
} // FCStdArrow::GetFrame.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCStdArrow::InitArrow
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jGoOiIpDiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmH		:_xZkqqHx_jGoOiIpDiCpAjAnKjBlBiClHiCoJjApMiCmMjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptA	:_xZkqqHx_jGoOiIpDiCmMjAnKjBlBjDfP_xHqqkZx_ A_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptB	:_xZkqqHx_jGoOiIpDiCmMjFpLiMpMiCpAiOkGiClHiClNiCnPiCmMjDfPiCpAiOhHjCoIiBeCjGoOiIpDiCmN_xHqqkZx_A->B_xZkqqHx_iCmMjFpLiMpMiBeC_xHqqkZx_
 *					 _xZkqqHx_jBkGiClPiBeBjGoOiCmMjAoGiCmN_xHqqkZx_B->A_xZkqqHx_iCmMjFpLiMpMiCpAiMpMiCkNiBeC_xHqqkZx_
 *			psidPenStyle	:_xZkqqHx_iDhJiDjDiCmMiDfIiDfOiDeDiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmfPenWeight	:_xZkqqHx_iDhJiDjDiCmMjBlOiClDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			scidPenBackSColor	:_xZkqqHx_iDhJiDjDiCmMjEhHiMgJjAeGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			ptidBrushPattern	:_xZkqqHx_iDhFiDiJiDfGiCmMiDhAiDfOiBfLiDjDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			scidBrushForeSColor	:_xZkqqHx_iDhFiDiJiDfGiCmMjBePiMgJjAeGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			scidBrushBackSColor	:_xZkqqHx_iDhFiDiJiDfGiCmMjEhHiMgJjAeGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			scidShadowSColor	:_xZkqqHx_iJgFiCmMjAeGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCStdArrow::InitArrow (mmetol mmH, const DBLPoint& mmptA, const DBLPoint& mmptB,
							PenStyleID psidPenStyle, fmmetol mmfPenWeight,
							SColorID scidPenBackSColor, PatternID ptidBrushPattern,
							SColorID scidBrushForeSColor, SColorID scidBrushBackSColor,
							SColorID scidShadowSColor)
{
	// _xZkqqHx_iDhEiDiJiDgCiDgHiBeBjGlDiClFiCmMiPoKiNiHiCmNiDeHiDiJiBfLiBeC_xHqqkZx_
	ASSERT(m_params.byType != FDUG_ARW_TYPE_FLAT);
	// _xZkqqHx_iDhAiDiJiDiBiBfLiDfOiCkJiCoHjFmPjAjEiCgPiBeBiChAiBeBiChBiCpAiOfKiPgPiBeC_xHqqkZx_
	FCUGPqr pqr;		// _xZkqqHx_jFmPjAjEiCgPiBeBiChAiBeBiChBiBeC_xHqqkZx_
	CalcPQR(pqr, mmH, m_params);
	mmetol mmP = GetP(mmH, pqr);
	mmetol mmAB = (mmptB - mmptA).Len();
	DBLPoint mmptAB = mmptB - mmptA;
	DBLPoint mmptBm = mmptA + mmptAB * (pqr.dQ - mmP) / mmAB;
	DBLPoint mmptC1, mmptC2, mmptC3, mmptC4;
	m_mmptaC[0].x = mmptA.x - mmptAB.y * (mmH / 2.0) / mmAB;
	m_mmptaC[0].y = mmptA.y + mmptAB.x * (mmH / 2.0) / mmAB;
	m_mmptaC[1].x = mmptBm.x - mmptAB.y * pqr.dR / mmAB;
	m_mmptaC[1].y = mmptBm.y + mmptAB.x * pqr.dR / mmAB;
	m_mmptaC[2] = mmptA - mmptAB * mmP / mmAB;
	m_mmptaC[3] = 2 * mmptBm - m_mmptaC[1];
	m_mmptaC[4] = 2 * mmptA - m_mmptaC[0];
	//----- _xZkqqHx_iDhJiDjDiBeFiDhFiDiJiDfGjBkOjAkLiCpAjFnLjBlG_xHqqkZx_ -----
	m_psidPenStyle = psidPenStyle;
	m_mmH = mmH;
	m_mmfPenWeight = mmfPenWeight;
	m_scidPenBackSColor = scidPenBackSColor;
	m_scidShadowSColor = scidShadowSColor;
} // FCStdArrow::InitArrow.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCStdArrow::GetPolygon
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jGhLjBmMiCmJjAnKjBlBiClHiCoJjGoOiIpDiCmMiDhMiDiKiDfDiDjDiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vmmptPoly	:_xZkqqHx_iDhMiDiKiDfDiDjDjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmElemLen	:_xZkqqHx_jClIjDfPiNmAjFfHjEhKjHpBiCmMiJpAjBjMjDhIiCpAiOhHjCoIiBeCjClIjDfPiNmAjFfHiKnEiCmMiLjHjHkDiCmM_xHqqkZx_
 *						 _xZkqqHx_jGnKiImAiCpAiOkGiClHiBeCjFiJiCmMiPoKiNiHiCmNiNmFjDeLjCgMiCpAiOkJjDkOjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCStdArrow::GetPolygon (DBLPointVector& vmmptPoly, mmetol mmElemLen) const
{
	//----- _xZkqqHx_jGoOiIpDiCmMiMfOiClCiCmGiCmJiPiIjHjNiCpAjFkKiCkPiCoJiBeCiDhEiDiJiDgCiDgHiCmMiPoKiNiHiCmNiPiIjHjNiNmPiCnN_xHqqkZx_ -----
	switch (m_params.byType)
	{
	case FDUG_ARW_TYPE_TYPICAL:		// _xZkqqHx_jCoIiMgAiDhAiDfOiBfLiDjDiBeC_xHqqkZx_
		switch (m_params.byParam0)
		{
		case FDUG_ARW_STYL_ARROW_A0:	// _xZkqqHx_jCfKiCkCjGoOiIpDiBgJjGfPiPpDiBgKiBeC_xHqqkZx_
		case FDUG_ARW_STYL_ARROW_A1:	// _xZkqqHx_jFiBjCmKjGoOiIpDiBgJjGfPiPpDiBgKiBeC_xHqqkZx_
		case FDUG_ARW_STYL_ARROW_A2:	// _xZkqqHx_jClHiCkCjGoOiIpDiBgJjGfPiPpDiBgKiBeC_xHqqkZx_
			goto L_DRAW_ARROW_A;
		case FDUG_ARW_STYL_ARROW_B0:	// _xZkqqHx_jCfKiCkCjGoOiIpDiBgJiOePiKhAiMgAiBgKiBeC_xHqqkZx_
		case FDUG_ARW_STYL_ARROW_B1:	// _xZkqqHx_jFiBjCmKjGoOiIpDiBgJiOePiKhAiMgAiBgKiBeC_xHqqkZx_
		case FDUG_ARW_STYL_ARROW_B2:	// _xZkqqHx_jClHiCkCjGoOiIpDiBgJiOePiKhAiMgAiBgKiBeC_xHqqkZx_
			goto L_DRAW_ARROW_B;
		default:
			goto L_DRAW_ARROW_C;
		}
		break;
	case FDUG_ARW_TYPE_ARROW_A:		// _xZkqqHx_jGoOiIpDiBgJjGfPiPpDiBgKiBeC_xHqqkZx_
		goto L_DRAW_ARROW_A;
	case FDUG_ARW_TYPE_ARROW_B:		// _xZkqqHx_jGoOiIpDiBgJiOePiKhAiMgAiBgKiBeC_xHqqkZx_
		goto L_DRAW_ARROW_B;
	case FDUG_ARW_TYPE_ARROW_C:		// _xZkqqHx_jGoOiIpDiBgJiCoCiClGiCoIiMfOiBgKiBeC_xHqqkZx_
		goto L_DRAW_ARROW_C;
	}
//----- _xZkqqHx_jGfPiPpDjGoOiIpDiCmMjEhKjHpBiNoMjAkMiDiLiBfLiDgAiDjD_xHqqkZx_ -----
L_DRAW_ARROW_A:
	vmmptPoly.push_back(m_mmptaC[0]);
	vmmptPoly.push_back(m_mmptaC[2]);
	vmmptPoly.push_back(m_mmptaC[4]);
	return;
//----- _xZkqqHx_iOePiKhAjGoOiIpDiCmMjEhKjHpBiNoMjAkMiDiLiBfLiDgAiDjD_xHqqkZx_ -----
L_DRAW_ARROW_B:
	vmmptPoly.push_back(m_mmptaC[0]);
	vmmptPoly.push_back(m_mmptaC[1]);
	vmmptPoly.push_back(m_mmptaC[2]);
	vmmptPoly.push_back(m_mmptaC[3]);
	vmmptPoly.push_back(m_mmptaC[4]);
	return;
//----- _xZkqqHx_iCkNiClDiCnBjGoOiIpDiCmMjEhKjHpBiNoMjAkMiDiLiBfLiDgAiDjD_xHqqkZx_ -----
L_DRAW_ARROW_C:
	vmmptPoly.push_back(m_mmptaC[0]);
	vmmptPoly.push_back(m_mmptaC[1]);
	vmmptPoly.push_back(m_mmptaC[2]);
	vmmptPoly.push_back(m_mmptaC[3]);
	vmmptPoly.push_back(m_mmptaC[4]);
	return;
} // FCStdArrow::GetPolygon.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCStdArrow::GetBezier
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jGhLjBmMiCmJjAnKjBlBiClHiCoJjGoOiIpDiCmMiDhIiDfHiDeGiLmIjApMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	polyBezier	:_xZkqqHx_iDhIiDfHiDeGiLmIjApMjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCStdArrow::GetBezier (FCMmPolyBezier& polyBezier) const
{
	polyBezier.clear();
	polyBezier.SetIsBezier(TRUE);
	//----- _xZkqqHx_jGoOiIpDiCmMiMfOiClCiCmGiCmJiPiIjHjNiCpAjFkKiCkPiCoJiBeCiDhEiDiJiDgCiDgHiCmMiPoKiNiHiCmNiPiIjHjNiNmPiCnN_xHqqkZx_ -----
	switch (m_params.byType)
	{
	case FDUG_ARW_TYPE_TYPICAL:		// _xZkqqHx_jCoIiMgAiDhAiDfOiBfLiDjDiBeC_xHqqkZx_
		switch (m_params.byParam0)
		{
		case FDUG_ARW_STYL_ARROW_A0:	// _xZkqqHx_jCfKiCkCjGoOiIpDiBgJjGfPiPpDiBgKiBeC_xHqqkZx_
		case FDUG_ARW_STYL_ARROW_A1:	// _xZkqqHx_jFiBjCmKjGoOiIpDiBgJjGfPiPpDiBgKiBeC_xHqqkZx_
		case FDUG_ARW_STYL_ARROW_A2:	// _xZkqqHx_jClHiCkCjGoOiIpDiBgJjGfPiPpDiBgKiBeC_xHqqkZx_
			goto L_DRAW_ARROW_A;
		case FDUG_ARW_STYL_ARROW_B0:	// _xZkqqHx_jCfKiCkCjGoOiIpDiBgJiOePiKhAiMgAiBgKiBeC_xHqqkZx_
		case FDUG_ARW_STYL_ARROW_B1:	// _xZkqqHx_jFiBjCmKjGoOiIpDiBgJiOePiKhAiMgAiBgKiBeC_xHqqkZx_
		case FDUG_ARW_STYL_ARROW_B2:	// _xZkqqHx_jClHiCkCjGoOiIpDiBgJiOePiKhAiMgAiBgKiBeC_xHqqkZx_
			goto L_DRAW_ARROW_B;
		default:
			goto L_DRAW_ARROW_C;
		}
		break;
	case FDUG_ARW_TYPE_ARROW_A:		// _xZkqqHx_jGoOiIpDiBgJjGfPiPpDiBgKiBeC_xHqqkZx_
		goto L_DRAW_ARROW_A;
	case FDUG_ARW_TYPE_ARROW_B:		// _xZkqqHx_jGoOiIpDiBgJiOePiKhAiMgAiBgKiBeC_xHqqkZx_
		goto L_DRAW_ARROW_B;
	case FDUG_ARW_TYPE_ARROW_C:		// _xZkqqHx_jGoOiIpDiBgJiCoCiClGiCoIiMfOiBgKiBeC_xHqqkZx_
		goto L_DRAW_ARROW_C;
	}
//----- _xZkqqHx_jGfPiPpDjGoOiIpDiCmMjEhKjHpBiNoMjAkMiDiLiBfLiDgAiDjD_xHqqkZx_ -----
L_DRAW_ARROW_A:
	polyBezier.push_back(m_mmptaC[0]);
	polyBezier.push_back(m_mmptaC[0]);
	polyBezier.push_back(m_mmptaC[2]);
	polyBezier.push_back(m_mmptaC[2]);
	polyBezier.push_back(m_mmptaC[2]);
	polyBezier.push_back(m_mmptaC[4]);
	polyBezier.push_back(m_mmptaC[4]);
	return;
//----- _xZkqqHx_iOePiKhAjGoOiIpDiCmMjEhKjHpBiNoMjAkMiDiLiBfLiDgAiDjD_xHqqkZx_ -----
L_DRAW_ARROW_B:
	polyBezier.push_back(m_mmptaC[0]);
	polyBezier.push_back(m_mmptaC[0]);
	polyBezier.push_back(m_mmptaC[1]);
	polyBezier.push_back(m_mmptaC[1]);
	polyBezier.push_back(m_mmptaC[1]);
	polyBezier.push_back(m_mmptaC[2]);
	polyBezier.push_back(m_mmptaC[2]);
	polyBezier.push_back(m_mmptaC[2]);
	polyBezier.push_back(m_mmptaC[3]);
	polyBezier.push_back(m_mmptaC[3]);
	polyBezier.push_back(m_mmptaC[3]);
	polyBezier.push_back(m_mmptaC[4]);
	polyBezier.push_back(m_mmptaC[4]);
	return;
//----- _xZkqqHx_iCkNiClDiCnBjGoOiIpDiCmMjEhKjHpBiNoMjAkMiDiLiBfLiDgAiDjD_xHqqkZx_ -----
L_DRAW_ARROW_C:
	polyBezier.push_back(m_mmptaC[0]);
	polyBezier.push_back(m_mmptaC[0]);
	polyBezier.push_back(m_mmptaC[1]);
	polyBezier.push_back(m_mmptaC[1]);
	polyBezier.push_back(m_mmptaC[1]);
	polyBezier.push_back(m_mmptaC[2]);
	polyBezier.push_back(m_mmptaC[2]);
	polyBezier.push_back(m_mmptaC[2]);
	polyBezier.push_back(m_mmptaC[3]);
	polyBezier.push_back(m_mmptaC[3]);
	polyBezier.push_back(m_mmptaC[3]);
	polyBezier.push_back(m_mmptaC[4]);
	polyBezier.push_back(m_mmptaC[4]);
	return;
} // FCStdArrow::GetBezier.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCStdArrow::CalcExactOuterFrame
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAhNiMgAiCmJiKePjAnKiClHiCoJjAlDiKgNiCmIiDhEiDiMiBfLiDiAiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmfPenWeight	:_xZkqqHx_iDhJiDjDjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iKePjAnKiClHiCoJiDhEiDiMiBfLiDiAiDfEiDeDiDfJiBeCiOmAiNmAjFfHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_jAhNiMgAiCmMiDfCiDhDiBfLiOjOiCmJiBeBiDfCiDhDiBfLjEmNiImNiCpAiOfKiPgPiClHiCoJiCmMiCmJjHhAiCkCiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iOmAiNhDiCmJiOjOiKnEiCkKiCkJiCkJiCmBiCmEiCoAiBeBiPgPjHiIiCoJiMmAiCoIjAlDiKgNiCmIjCgMiCkKjFeLjHhGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.06.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DBLRect FCStdArrow::CalcExactOuterFrame (fmmetol mmfPenWeight) const
{
	DBLRect mmrtFrame(0,0,0,0);
	//----- _xZkqqHx_jGoOiIpDiCmMjGhLjBmMiCmMiDhMiDiKiDfDiDjDiCkJiCoHiBeBiDhEiDiMiBfLiDiAiOfKiPgP_xHqqkZx_ -----
	DBLPointVector vmmptPoly;
// 06.12.04 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	GetPolygon(vmmptPoly, FFGetStdElemLen());
	GetPolygon(vmmptPoly, -1);
	if (!vmmptPoly.empty())
		::FFCalcFrame(mmrtFrame, vmmptPoly.size(), vmmptPoly.begin());
	// _xZkqqHx_jApMiCmMjFjN_xHqqkZx_/2_xZkqqHx_iClOiCkPiKgHjBoFiBeC_xHqqkZx_
	if (m_bWidePoly) mmrtFrame.Extend(mmfPenWeight / 2.0);

	//----- _xZkqqHx_jGoOiIpDiCmMiPoDiPpMiCoIiBeBiJlKiPpMiCoIiCmMiDhMiDiKiDfDiDjDiCkJiCoHiBeBiDhEiDiMiBfLiDiAiOfKiPgP_xHqqkZx_ -----
	vmmptPoly.clear();
	GetPostPolyline(vmmptPoly);
	if (!vmmptPoly.empty())
	{
		DBLRect mmrtDecorate;
		::FFCalcFrame(mmrtDecorate, vmmptPoly.size(), vmmptPoly.begin());
		// _xZkqqHx_jApMiCmMjFjN_xHqqkZx_/2_xZkqqHx_iClOiCkPiKgHjBoFiBeC_xHqqkZx_
		mmrtDecorate.Extend(mmfPenWeight / 2.0);
		mmrtFrame |= mmrtDecorate;
	}
	return mmrtFrame;
} // FCStdArrow::CalcExactOuterFrame.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCStdArrow::PreDraw
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jGoOiIpDjGhLjBmMiCmMiJlKiCmJiCkAiCoJiPpMiCoIiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bIsMono	:_xZkqqHx_iDiCiDgNiDiJiDiLjFgAiJoGiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCStdArrow::PreDraw (CDC* pDC, BOOL bIsMono) const
{
} // FCStdArrow::PreDraw.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCStdArrow::PostDraw
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jGoOiIpDjGhLjBmMiCmMiPoDiCmJiCkAiCoJiPpMiCoIiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bIsMono	:_xZkqqHx_iDiCiDgNiDiJiDiLjFgAiJoGiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCStdArrow::PostDraw (CDC* pDC, BOOL bIsMono) const
{
//----- 01.10.17 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	switch (m_params.byType)
//	{
//	case FDUG_ARW_TYPE_TYPICAL:		// _xZkqqHx_jCoIiMgAiDhAiDfOiBfLiDjDiBeC_xHqqkZx_
//		switch (m_params.byParam0)
//		{
//		case FDUG_ARW_STYL_ARROW_A0:	// _xZkqqHx_jCfKiCkCjGoOiIpDiBgJjGfPiPpDiBgKiBeC_xHqqkZx_
//		case FDUG_ARW_STYL_ARROW_A1:	// _xZkqqHx_jFiBjCmKjGoOiIpDiBgJjGfPiPpDiBgKiBeC_xHqqkZx_
//		case FDUG_ARW_STYL_ARROW_A2:	// _xZkqqHx_jClHiCkCjGoOiIpDiBgJjGfPiPpDiBgKiBeC_xHqqkZx_
//			goto L_DRAW_ARROW_A;
//		}
//		break;
//	case FDUG_ARW_TYPE_ARROW_A:		// _xZkqqHx_jGoOiIpDiBgJjGfPiPpDiBgKiBeC_xHqqkZx_
//		goto L_DRAW_ARROW_A;
//	}
//	return;
//L_DRAW_ARROW_A:
//	FCDraw draw(pDC);
//	draw.PenInit(m_psidPenStyle, m_bWidePoly ? m_mmfPenWeight : m_mmH,
//				bIsMono ? FD_S_COLOR_BLACK : m_scidPenBackSColor);
//	DBLPointVector vmmptPoly;
//	vmmptPoly.push_back(m_mmptaC[1]);
//	vmmptPoly.push_back(m_mmptaC[2]);
//	vmmptPoly.push_back(m_mmptaC[3]);
//	CPointVector vlgptPoly;
//	mm2lg(vlgptPoly, vmmptPoly);
//	draw.Polyline(vlgptPoly.begin(), vlgptPoly.size());
//----- 01.10.17 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	DBLPointVector vmmptPoly;
	GetPostPolyline(vmmptPoly);
	if (!vmmptPoly.empty())
	{
		FCDraw draw(pDC);
//----- 02.05.28 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ (_xZkqqHx_jDfPjApMiCmMjGfPiPpDjGoOiIpDiClOiCmGjGoOiIpDiCoAjDfPjApMiCmJ_xHqqkZx_)-----
//		draw.PenInit(m_psidPenStyle, m_bWidePoly ? m_mmfPenWeight : m_mmH,
//					bIsMono ? FD_S_COLOR_BLACK : m_scidPenBackSColor);
//----- 02.05.28 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ (_xZkqqHx_jDfPjApMiCmMjGfPiPpDjGoOiIpDiClOiCmGjGoOiIpDiCoAjDfPjApMiCmJ_xHqqkZx_)-----
		// _xZkqqHx_iDhJiDjDiPiJiKpKiJlLiBeCjGfPiPpDjGoOiIpDiCmMjGfPjFgAiJoGiCmIiCmMiCmFiBeBiDhJiDjDiDfIiDfOiDeDiDiLiCmN_xHqqkZx_SOLID_xZkqqHx_iCmJiBeC_xHqqkZx_
		draw.PenInit(FD_PEN_STYLE_SOLID, m_bWidePoly ? m_mmfPenWeight : m_mmH,
					bIsMono ? FD_S_COLOR_BLACK : m_scidPenBackSColor);
//----- 02.05.28 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ (_xZkqqHx_jDfPjApMiCmMjGfPiPpDjGoOiIpDiClOiCmGjGoOiIpDiCoAjDfPjApMiCmJ_xHqqkZx_)-----
		CPointVector vlgptPoly;
		mm2lg(vlgptPoly, vmmptPoly);
		draw.Polyline(vlgptPoly.begin(), vlgptPoly.size());
	}
//----- 01.10.17 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCStdArrow::PostDraw.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCStdArrow::DrawShadow
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jGoOiIpDjGhLjBmMiCmMiPoDiPpMiCoIiCmGiJlKiPpMiCoIiCmMiJgFiCpAjFgAiJoGiClHiCoJiBeCjGoOiIpDjGhLjBmMiBgJiDhMiDiKiDfDiDjD_xHqqkZx_
 *			_xZkqqHx_iCmJjAnKjBlBiClDiCoKiCoJjFjEjFkKiBgKiCmMiJgFiCmNjFgAiJoGiClFiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCStdArrow::DrawShadow (CDC* pDC)
{
//----- 01.10.17 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	switch (m_params.byType)
//	{
//	case FDUG_ARW_TYPE_TYPICAL:		// _xZkqqHx_jCoIiMgAiDhAiDfOiBfLiDjDiBeC_xHqqkZx_
//		switch (m_params.byParam0)
//		{
//		case FDUG_ARW_STYL_ARROW_A0:	// _xZkqqHx_jCfKiCkCjGoOiIpDiBgJjGfPiPpDiBgKiBeC_xHqqkZx_
//		case FDUG_ARW_STYL_ARROW_A1:	// _xZkqqHx_jFiBjCmKjGoOiIpDiBgJjGfPiPpDiBgKiBeC_xHqqkZx_
//		case FDUG_ARW_STYL_ARROW_A2:	// _xZkqqHx_jClHiCkCjGoOiIpDiBgJjGfPiPpDiBgKiBeC_xHqqkZx_
//			goto L_DRAW_ARROW_A;
//		}
//		break;
//	case FDUG_ARW_TYPE_ARROW_A:		// _xZkqqHx_jGoOiIpDiBgJjGfPiPpDiBgKiBeC_xHqqkZx_
//		goto L_DRAW_ARROW_A;
//	}
//	return;
//L_DRAW_ARROW_A:
//	// _xZkqqHx_iDfIiDeOiDiNiBfLiDiLiDeJiDhEiDfKiDgCiDgHjCgMiBeC_xHqqkZx_
//	FCDraw draw(pDC, g_->dZoom, g_->lgOffsetX - mm2lg(g_pEnv->GetShadowLen().x),
//								g_->lgOffsetY - mm2lg(g_pEnv->GetShadowLen().y));
//	draw.PenInit(m_psidPenStyle, m_bWidePoly ? m_mmfPenWeight : m_mmH, m_scidShadowSColor);
//	DBLPointVector vmmptPoly;
//	vmmptPoly.push_back(m_mmptaC[1]);
//	vmmptPoly.push_back(m_mmptaC[2]);
//	vmmptPoly.push_back(m_mmptaC[3]);
//	CPointVector vlgptPoly;
//	mm2lg(vlgptPoly, vmmptPoly);
//	draw.Polyline(vlgptPoly.begin(), vlgptPoly.size());
//----- 01.10.17 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	DBLPointVector vmmptPoly;
	GetPostPolyline(vmmptPoly);
	if (!vmmptPoly.empty())
	{
		// _xZkqqHx_iDfIiDeOiDiNiBfLiDiLiDeJiDhEiDfKiDgCiDgHjCgMiBeC_xHqqkZx_
		FCDraw draw(pDC,
					g_->eDrawWhich,
					g_->dZoom,
					g_->lgOffsetX - mm2lg(g_pEnv->GetShadowLen().x),
					g_->lgOffsetY - mm2lg(g_pEnv->GetShadowLen().y));
//----- 02.05.28 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ (_xZkqqHx_jDfPjApMiCmMjGfPiPpDjGoOiIpDiClOiCmGjGoOiIpDiCoAjDfPjApMiCmJ_xHqqkZx_)-----
//		draw.PenInit(m_psidPenStyle, m_bWidePoly ? m_mmfPenWeight : m_mmH, m_scidShadowSColor);
//----- 02.05.28 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ (_xZkqqHx_jDfPjApMiCmMjGfPiPpDjGoOiIpDiClOiCmGjGoOiIpDiCoAjDfPjApMiCmJ_xHqqkZx_)-----
		// _xZkqqHx_iDhJiDjDiPiJiKpKiJlLiBeCjGfPiPpDjGoOiIpDiCmMjGfPjFgAiJoGiCmIiCmMiCmFiBeBiDhJiDjDiDfIiDfOiDeDiDiLiCmN_xHqqkZx_SOLID_xZkqqHx_iCmJiBeC_xHqqkZx_
		draw.PenInit(FD_PEN_STYLE_SOLID,
					m_bWidePoly ? m_mmfPenWeight : m_mmH, m_scidShadowSColor);
//----- 02.05.28 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ (_xZkqqHx_jDfPjApMiCmMjGfPiPpDjGoOiIpDiClOiCmGjGoOiIpDiCoAjDfPjApMiCmJ_xHqqkZx_)-----
		CPointVector vlgptPoly;
		mm2lg(vlgptPoly, vmmptPoly);
		draw.Polyline(vlgptPoly.begin(), vlgptPoly.size());
	}
//----- 01.10.17 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCStdArrow::DrawShadow.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCStdArrow::GetPostPolyline
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPoDiPpMiCoIiCmFjFgAiJoGiClDiCoKiCoJjApMiCmMjClIjDfPjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vmmptPoly	:_xZkqqHx_jClIjDfPjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	_xZkqqHx_jGfPiPpDiCmMjGoOiIpDiCmMiPoKiNiHiBeBjGfPiCmMjFgAiJoGiCkKiPoDiPpMiCoIiCmFjFeLjHhGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.10.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCStdArrow::GetPostPolyline (DBLPointVector& vmmptPoly) const
{
	switch (m_params.byType)
	{
	case FDUG_ARW_TYPE_TYPICAL:		// _xZkqqHx_jCoIiMgAiDhAiDfOiBfLiDjDiBeC_xHqqkZx_
		switch (m_params.byParam0)
		{
		case FDUG_ARW_STYL_ARROW_A0:	// _xZkqqHx_jCfKiCkCjGoOiIpDiBgJjGfPiPpDiBgKiBeC_xHqqkZx_
		case FDUG_ARW_STYL_ARROW_A1:	// _xZkqqHx_jFiBjCmKjGoOiIpDiBgJjGfPiPpDiBgKiBeC_xHqqkZx_
		case FDUG_ARW_STYL_ARROW_A2:	// _xZkqqHx_jClHiCkCjGoOiIpDiBgJjGfPiPpDiBgKiBeC_xHqqkZx_
			goto L_DRAW_ARROW_A;
		}
		break;
	case FDUG_ARW_TYPE_ARROW_A:		// _xZkqqHx_jGoOiIpDiBgJjGfPiPpDiBgKiBeC_xHqqkZx_
		goto L_DRAW_ARROW_A;
	}
	return;
L_DRAW_ARROW_A:
	vmmptPoly.push_back(m_mmptaC[1]);
	vmmptPoly.push_back(m_mmptaC[2]);
	vmmptPoly.push_back(m_mmptaC[3]);
} // FCStdArrow::GetPostPolyline.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCStdArrow::GetP
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jGoOiIpDiCmMjAoGjCfLiCkJiCoHiBeBjGoOiIpDjAnKjBlBjDfP_xHqqkZx_A_xZkqqHx_iCnMiCmFiCmMiLjHjHkDiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmH	:_xZkqqHx_jAnKjBlBiClDiCoKiCoJjApMiCmMjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pqr	:PQR_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iLjHjHkD_xHqqkZx_P_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	Arrow.mdrw _xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
mmetol FCStdArrow::GetP (mmetol mmH, const FCUGPqr& pqr) const
{
	mmetol mmSm = pqr.dQ - pqr.dP;
	mmetol mmTm = mmSm * (mmH / 2.0) / pqr.dR;
	return pqr.dP + mmTm;
} // FCStdArrow::GetP.

////////////////////////////////////////////////////////////////////////////
// FCPictArrow _xZkqqHx_iDeOiDiJiDfIiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPictArrow::FCPictArrow
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	paid		:_xZkqqHx_iDhDiDeOiDgAiDiDjGoOiIpDiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			bWidePoly	:_xZkqqHx_jFjNiNeMiCmMiDhMiDiKiDfDiDjDiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCPictArrow::FCPictArrow (PictArrowID paid, BOOL bWidePoly)
			: FCBaseArrow(bWidePoly)
{
	m_paid = paid;
	m_bWidePoly = bWidePoly;
	m_pArrow = NULL;
} // FCPictArrow::FCPictArrow.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPictArrow::~FCPictArrow
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCPictArrow::~FCPictArrow ()
{
	if (m_pArrow != NULL)
	{
// 02.05.29 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ (Molip_xZkqqHx_iCpA_xHqqkZx_OLE_xZkqqHx_iCmGiClFiCmEiDhJiBfLiDfIiDgHiClFiClNjAoGiCmMiDeBiDhGiDiKiCkJiCoHiBeB_xHqqkZx_Molip_xZkqqHx_iNmEjFnCiPfHiCkKiCmFiCkLiCmIiCkNiCmIiCmBiCmEiClFiCnMiCkEiBeC_xHqqkZx_)
//		m_pArrow->Terminate();
		delete m_pArrow;
		m_pArrow = NULL;
	}
} // FCPictArrow::FCPictArrow.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPictArrow::Type
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeOiDiJiDfIiDfOiDeDiDhGiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeOiDiJiDfIiDfOiDeDiDhGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.10.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FTArrowClassType FCPictArrow::Type () const
{
	return FDAW_PICTURE;	// FCPictArrow_xZkqqHx_iDeOiDiJiDfIiBeC_xHqqkZx_
} // FCPictArrow::Type.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPictArrow::GetP
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jGoOiIpDiCmMjAoGjCfLiCkJiCoHiBeBjGoOiIpDjAnKjBlBjDfP_xHqqkZx_A_xZkqqHx_iCnMiCmFiCmMiLjHjHkDiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmH	:_xZkqqHx_jAnKjBlBiClDiCoKiCoJjApMiCmMjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iLjHjHkD_xHqqkZx_P_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	Arrow.mdrw _xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
mmetol FCPictArrow::GetP (mmetol mmH) const
{
	const FCObjPictArrow* pArrow = GetStdObject();
//----- 01.08.15 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDhJiDjDiCmMjBlOiClDiCmMiNmFjCoBjCgMiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
	if (mmH < pArrow->GetMinArrowPenWeight())
		mmH = pArrow->GetMinArrowPenWeight();
//----- 01.08.15 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	mmetol mmWidth = pArrow->GetArrowFrame().Width();
	mmetol mmHeight = pArrow->GetArrowFrame().Height();
	return mmWidth * (mmH / mmHeight);
} // FCPictArrow::GetP.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPictArrow::GetFrame
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDfP_xHqqkZx_A_xZkqqHx_iCpA_xHqqkZx_(0,0)_xZkqqHx_iCmGiClFiClNiCmGiCkLiCmMiBeBiDhDiDeOiDgAiDiDjGoOiIpDiDhEiDiMiBfLiDiAiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmH	:_xZkqqHx_jAnKjBlBiClDiCoKiCoJjApMiCmMjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhDiDeOiDgAiDiDjGoOiIpDiDhEiDiMiBfLiDiAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	Arrow.mdrw _xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DBLRect FCPictArrow::GetFrame (mmetol mmH, fmmetol mmWeight) const
{
	const FCObjPictArrow* pArrow = GetStdObject();
//----- 01.08.15 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDhJiDjDiCmMjBlOiClDiCmMiNmFjCoBjCgMiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
	if (mmH < pArrow->GetMinArrowPenWeight())
		mmH = pArrow->GetMinArrowPenWeight();
//----- 01.08.15 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	mmetol mmHeight = pArrow->GetArrowFrame().Height();
	DBLRect mmrt = pArrow->GetOuterFrame();
	mmrt -= DBLPoint(pArrow->GetArrowFrame().right,
					(pArrow->GetArrowFrame().top +
						pArrow->GetArrowFrame().bottom) / 2.0);
	mmrt *= (mmH / mmHeight);
	return mmrt.ExtendRect(mmWeight / 2.0);
} // FCPictArrow::GetFrame.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPictArrow::InitArrow
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jGoOiIpDiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmH		:_xZkqqHx_jGoOiIpDiCpAjAnKjBlBiClHiCoJjApMiCmMjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptA	:_xZkqqHx_jGoOiIpDiCmMjAnKjBlBjDfP_xHqqkZx_ A_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptB	:_xZkqqHx_jGoOiIpDiCmMjFpLiMpMiCpAiOkGiClHiClNiCnPiCmMjDfPiCpAiOhHjCoIiBeCjGoOiIpDiCmN_xHqqkZx_A->B_xZkqqHx_iCmMjFpLiMpMiBeC_xHqqkZx_
 *					 _xZkqqHx_jBkGiClPiBeBjGoOiCmMjAoGiCmN_xHqqkZx_B->A_xZkqqHx_iCmMjFpLiMpMiCpAiMpMiCkNiBeC_xHqqkZx_
 *			psidPenStyle	:_xZkqqHx_iDhJiDjDiCmMiDfIiDfOiDeDiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmfPenWeight	:_xZkqqHx_iDhJiDjDiCmMjBlOiClDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			scidPenBackSColor	:_xZkqqHx_iDhJiDjDiCmMjEhHiMgJjAeGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			ptidBrushPattern	:_xZkqqHx_iDhFiDiJiDfGiCmMiDhAiDfOiBfLiDjDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			scidBrushForeSColor	:_xZkqqHx_iDhFiDiJiDfGiCmMjBePiMgJjAeGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			scidBrushBackSColor	:_xZkqqHx_iDhFiDiJiDfGiCmMjEhHiMgJjAeGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			scidShadowSColor	:_xZkqqHx_iJgFiCmMjAeGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCPictArrow::InitArrow (mmetol mmH, const DBLPoint& mmptA, const DBLPoint& mmptB,
							PenStyleID psidPenStyle, fmmetol mmfPenWeight,
							SColorID scidPenBackSColor, PatternID ptidBrushPattern,
							SColorID scidBrushForeSColor, SColorID scidBrushBackSColor,
							SColorID scidShadowSColor)
{
	ASSERT(m_pArrow == NULL);
//----- 01.08.15 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDeJiDiKiDfHiDgJiDiLjCgMiCpAjFnLjBlGiBeCiDhJiDjDjFjNjAnNjCoIjHhAiBeC_xHqqkZx_
	const mmetol mmH_Orig = mmH;
	// _xZkqqHx_iDhJiDjDiCmMjBlOiClDiCmMiNmFjCoBjCgMiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
	if (mmH < GetStdObject()->GetMinArrowPenWeight())
		mmH = GetStdObject()->GetMinArrowPenWeight();
//----- 01.08.15 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_jGhLjBmMiNiCiClDiCkK_xHqqkZx_ 0 _xZkqqHx_iCmMiPoKiNiHiCmNiBeBiPiJiKpKiJlLiClFiCmIiCkCiBeC_xHqqkZx_
	if (almost0(mmH)) return;
	m_pArrow = (FCObjPictArrow*)GetStdObject()->Duplicate();
	mmetol mmHeight = m_pArrow->GetArrowFrame().Height();
	//----- _xZkqqHx_jDgPjIfOiDhJiDjDiBeFjDgPjIfOiDhFiDiJiDfGiCpAjCmKiPoNiCmMiDhJiDjDiBeFiDhFiDiJiDfGiCmJjFmPiKlHiClHiCoJ_xHqqkZx_ -----
	long lObjIdx;
	for (lObjIdx = 0; lObjIdx < m_pArrow->GetMemberSize(); lObjIdx++)
	{
		// _xZkqqHx_iDhDiDeOiDgAiDiDjGoOiIpDiCmMiDiBiDjDiDgPiBfLiCmNiBeBjFeLiClIjAhNiMgAiMgOjFjEjFgJiBgJ_xHqqkZx_ObjFigure_xZkqqHx_iBgKiBeC_xHqqkZx_
		FCObjFigure* pObj = (FCObjFigure*)m_pArrow->GetMember(lObjIdx);
		//----- _xZkqqHx_jDgPjIfOiDhJiDjDiCmMiPoKiNiHiCmNiBeBjCmKiPoNiCmMiDhJiDjDiCmJjFmPiKlHiClHiCoJ_xHqqkZx_ -----
		if (pObj->GetPenRegister() != FD_PEN_REGISTER_UNUSE)
		{
			pObj->SetPenStyle(g_pEnv->GetPenRegisterRec(pObj->GetPenRegister())->m_psidPenStyle);
			pObj->SetPenWeight(g_pEnv->GetPenRegisterRec(pObj->GetPenRegister())->m_mmfPenWeight);
			pObj->SetPenBackSColor(g_pEnv->GetPenRegisterRec(pObj->GetPenRegister())->m_scidPenBackSColor);
			pObj->SetPenRegister(FD_PEN_REGISTER_UNUSE);
		}
		//----- _xZkqqHx_jDgPjIfOiDhFiDiJiDfGiCmMiPoKiNiHiCmNiBeBjCmKiPoNiCmMiDhFiDiJiDfGiCmJjFmPiKlHiClHiCoJ_xHqqkZx_ -----
		if (pObj->GetBrushRegister() != FD_BRUSH_REGISTER_UNUSE)
		{
			pObj->SetBrushPattern(g_pEnv->GetBrushRegisterRec(pObj->GetBrushRegister())->m_ptidBrushPattern);
			pObj->SetBrushForeSColor(g_pEnv->GetBrushRegisterRec(pObj->GetBrushRegister())->m_scidBrushForeSColor);
			pObj->SetBrushBackSColor(g_pEnv->GetBrushRegisterRec(pObj->GetBrushRegister())->m_scidBrushBackSColor);
			pObj->SetBrushRegister(FD_BRUSH_REGISTER_UNUSE);
		}
		//----- _xZkqqHx_iDfOiBfLiDfBiDgCiDgHjFjEjFgJiCmMiDhJiDjDiPoOjFpBiCpAiBeBiMhAiPlDiDhEiDiJiDePiCmJiPfNiCmBiCmEiPjBiCkLiKlHiCkGiCoJ_xHqqkZx_ -----
		BYTE byDuty = m_pArrow->GetDuty(lObjIdx);
		if (byDuty & FDAR_SYNC_PEN_STYLE)
			pObj->SetPenStyle(psidPenStyle);
		if (byDuty & FDAR_SYNC_PEN_WEIGHT)
			pObj->SetPenWeight(mmfPenWeight);
		else
		if (byDuty & FDAR_SYNC_PEN_WIDTH)
			pObj->SetPenWeight(mmH_Orig);
		else
			pObj->SetPenWeight(pObj->GetPenWeight() * (mmH / mmHeight));
										// _xZkqqHx_iDhJiDjDiCmMjBlOiClDiCmNiDiKiDfEiDeDiDfJiCmJiNiHiCoNiClJiCmEjFmPiNfIiBeC_xHqqkZx_
		if (byDuty & FDAR_SYNC_PEN_BACK_S_COLOR)
			pObj->SetPenBackSColor(scidPenBackSColor);
		if (byDuty & FDAR_SYNC_BRUSH_PATTERN)
			pObj->SetBrushPattern(ptidBrushPattern);
		if (byDuty & FDAR_SYNC_BRUSH_FORE_S_COLOR)
			pObj->SetBrushForeSColor(scidBrushForeSColor);
		if (byDuty & FDAR_SYNC_BRUSH_BACK_S_COLOR)
			pObj->SetBrushBackSColor(scidBrushBackSColor);
		pObj->SetShadowSColor(scidShadowSColor);
	}
	//----- _xZkqqHx_iDfEiDeDiDfJiBeBiImKjChFiBeBiJpBjDfNiCpAiCkAiCoNiClJiCoJ_xHqqkZx_ -----
	DBLRect mmrtFrame = m_pArrow->GetResizeFrame();
	mmrtFrame -= DBLPoint(m_pArrow->GetArrowFrame().right,
						(m_pArrow->GetArrowFrame().top +
							m_pArrow->GetArrowFrame().bottom) / 2.0);
	mmrtFrame *= (mmH / mmHeight);
	mmrtFrame += mmptA;
	m_pArrow->Resize(TRUE, TRUE, mmrtFrame, m_pArrow->GetResizeFrame());
	DBLPoint mmptAngle = mmptB - mmptA;
	double angle = ::ArcTan(mmptAngle);
	m_pArrow->Rotate(angle, mmptA);
} // FCPictArrow::InitArrow.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPictArrow::GetPolygon
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jGhLjBmMiCmJjAnKjBlBiClHiCoJjGoOiIpDiCmMiDhMiDiKiDfDiDjDiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vmmptPoly	:_xZkqqHx_iDhMiDiKiDfDiDjDjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmElemLen	:_xZkqqHx_jClIjDfPiNmAjFfHjEhKjHpBiCmMiJpAjBjMjDhIiCpAiOhHjCoIiBeCjClIjDfPiNmAjFfHiKnEiCmMiLjHjHkDiCmM_xHqqkZx_
 *						 _xZkqqHx_jGnKiImAiCpAiOkGiClHiBeCjFiJiCmMiPoKiNiHiCmNiNmFjDeLjCgMiCpAiOkJjDkOjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCPictArrow::GetPolygon (DBLPointVector& vmmptPoly, mmetol mmElemLen) const
{
	// _xZkqqHx_iPiJiKpKiJlLiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiHiBgJ_xHqqkZx_mmH == 0_xZkqqHx_iCmIiCmHiBgKiCmNjFjMiLeBiBeC_xHqqkZx_
	if (m_pArrow == NULL) return;
	// _xZkqqHx_jGhLjBmMjAnKjBlBjGoOiIpDiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiHiCmNiBeBiClBiCmMiCnMiCnMjFjMiLeBiBeC_xHqqkZx_
	if (m_pArrow->GetArrowDutyObject() == NULL) return;
	m_pArrow->GetArrowDutyObject()->NewObjPolygonForDraw(vmmptPoly, mmElemLen, NULL, 0);
} // FCPictArrow::GetPolygon.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPictArrow::GetBezier
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jGhLjBmMiCmJjAnKjBlBiClHiCoJjGoOiIpDiCmMiDhIiDfHiDeGiLmIjApMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	polyBezier	:_xZkqqHx_iDhIiDfHiDeGiLmIjApMjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCPictArrow::GetBezier (FCMmPolyBezier& polyBezier) const
{
	// _xZkqqHx_iPiJiKpKiJlLiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiHiBgJ_xHqqkZx_mmH == 0_xZkqqHx_iCmIiCmHiBgKiCmNjFjMiLeBiBeC_xHqqkZx_
	if (m_pArrow == NULL) return;
	// _xZkqqHx_jGhLjBmMjAnKjBlBjGoOiIpDiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiHiCmNiBeBiClBiCmMiCnMiCnMjFjMiLeBiBeC_xHqqkZx_
	if (m_pArrow->GetArrowDutyObject() == NULL) return;
	m_pArrow->GetArrowDutyObject()->NewObjBezierForDraw(polyBezier);
} // FCPictArrow::GetBezier.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPictArrow::CalcExactOuterFrame
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAhNiMgAiCmJiKePjAnKiClHiCoJjAlDiKgNiCmIiDhEiDiMiBfLiDiAiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmfPenWeight	:_xZkqqHx_iDhJiDjDjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iKePjAnKiClHiCoJiDhEiDiMiBfLiDiAiDfEiDeDiDfJiBeCiOmAiNmAjFfHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_jAhNiMgAiCmMiDfCiDhDiBfLiOjOiCmJiBeBiDfCiDhDiBfLjEmNiImNiCpAiOfKiPgPiClHiCoJiCmMiCmJjHhAiCkCiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iOmAiNhDiCmJiOjOiKnEiCkKiCkJiCkJiCmBiCmEiCoAiBeBiPgPjHiIiCoJiMmAiCoIjAlDiKgNiCmIjCgMiCkKjFeLjHhGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.06.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DBLRect FCPictArrow::CalcExactOuterFrame (fmmetol mmfPenWeight) const
{
	// _xZkqqHx_iPiJiKpKiJlLiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiHiCmNiDeHiDiJiBfLiBeC_xHqqkZx_
	ASSERT(m_pArrow != NULL);
	DBLRect mmrtFrame(0,0,0,0);
	if (m_pArrow->GetArrowDutyObject() != NULL)
	//----- _xZkqqHx_jGhLjBmMjAnKjBlBjGoOiIpDiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		DBLPointVector vmmptPoly;
//----- 06.12.04 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		m_pArrow->GetArrowDutyObject()->
//			NewObjPolygonForDraw(vmmptPoly, FFGetStdElemLen(), NULL, 0);
//----- 06.12.04 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		m_pArrow->GetArrowDutyObject()->
			NewObjPolygonForDraw(vmmptPoly, -1, NULL, 0);
//----- 06.12.04 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		::FFCalcFrame(mmrtFrame, vmmptPoly.size(), vmmptPoly.begin());
		// _xZkqqHx_jApMiCmMjFjN_xHqqkZx_/2_xZkqqHx_iClOiCkPiKgHjBoFiBeC_xHqqkZx_
		if (m_bWidePoly) mmrtFrame.Extend(mmfPenWeight / 2.0);
	}
	//----- _xZkqqHx_iJlKiPpMiCoIiCmMiDfEiDeDiDfJiCpAiJmBiOfK_xHqqkZx_ -----
	ObjDynabaseVector::const_iterator iObj;
	ObjDynabaseVector vObj;
	m_pArrow->GetPreDrawObjects(vObj);
	for (iObj = vObj.begin(); iObj != vObj.end(); iObj++)
		mmrtFrame |= (*iObj)->CalcExactOuterFrame();
	vObj.clear();
	//----- _xZkqqHx_iPoDiPpMiCoIiCmMiDfEiDeDiDfJiCpAiJmBiOfK_xHqqkZx_ -----
	m_pArrow->GetPostDrawObjects(vObj);
	for (iObj = vObj.begin(); iObj != vObj.end(); iObj++)
		mmrtFrame |= (*iObj)->CalcExactOuterFrame();
	return mmrtFrame;
} // FCPictArrow::CalcExactOuterFrame.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPictArrow::PreDraw
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jGoOiIpDjGhLjBmMiCmMiJlKiCmJiCkAiCoJiPpMiCoIiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bIsMono	:_xZkqqHx_iDiCiDgNiDiJiDiLjFgAiJoGiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCPictArrow::PreDraw (CDC* pDC, BOOL bIsMono) const
{
	// _xZkqqHx_iPiJiKpKiJlLiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiHiBgJ_xHqqkZx_mmH == 0_xZkqqHx_iCmIiCmHiBgKiCmNjFjMiLeBiBeC_xHqqkZx_
	if (m_pArrow == NULL) return;
	ObjDynabaseVector vObj;
	m_pArrow->GetPreDrawObjects(vObj);
	// _xZkqqHx_iDfOiBfLiDfBiDgCiDgHjFjEjFgJiCpAjFgAiJoGiBeC_xHqqkZx_
	ObjDynabaseVector::iterator iObj;
	for (iObj = vObj.begin(); iObj != vObj.end(); iObj++)
	{
		// _xZkqqHx_iDhDiDeOiDgAiDiDjGoOiIpDiCmMiDiBiDjDiDgPiBfLiCmNiBeBjFeLiClIjAhNiMgAiMgOjFjEjFgJiBgJ_xHqqkZx_ObjFigure_xZkqqHx_iBgKiBeC_xHqqkZx_
		FCObjFigure* pFig = (FCObjFigure*)(*iObj);
		FCLgPolyBezier vlgptPoly;
		FCBaseArrow* pArrowF = NULL;
		FCBaseArrow* pArrowB = NULL;
		BOOL bIsWidePoly;
		BOOL bIsClose;
		pFig->DrawObject(pDC, vlgptPoly, bIsClose, pArrowF, pArrowB,
						bIsWidePoly, bIsMono);
		if (pArrowF != NULL) delete pArrowF;
		if (pArrowB != NULL) delete pArrowB;
	}
} // FCPictArrow::PreDraw.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPictArrow::PostDraw
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jGoOiIpDjGhLjBmMiCmMiPoDiCmJiCkAiCoJiPpMiCoIiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bIsMono	:_xZkqqHx_iDiCiDgNiDiJiDiLjFgAiJoGiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCPictArrow::PostDraw (CDC* pDC, BOOL bIsMono) const
{
	// _xZkqqHx_iPiJiKpKiJlLiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiHiBgJ_xHqqkZx_mmH == 0_xZkqqHx_iCmIiCmHiBgKiCmNjFjMiLeBiBeC_xHqqkZx_
	if (m_pArrow == NULL) return;
	ObjDynabaseVector vObj;
	m_pArrow->GetPostDrawObjects(vObj);
	// _xZkqqHx_iDfOiBfLiDfBiDgCiDgHjFjEjFgJiCpAjFgAiJoGiBeC_xHqqkZx_
	ObjDynabaseVector::iterator iObj;
	for (iObj = vObj.begin(); iObj != vObj.end(); iObj++)
	{
		// _xZkqqHx_iDhDiDeOiDgAiDiDjGoOiIpDiCmMiDiBiDjDiDgPiBfLiCmNiBeBjFeLiClIjAhNiMgAiMgOjFjEjFgJiBgJ_xHqqkZx_ObjFigure_xZkqqHx_iBgKiBeC_xHqqkZx_
		FCObjFigure* pFig = (FCObjFigure*)(*iObj);
		FCLgPolyBezier vlgptPoly;
		FCBaseArrow* pArrowF = NULL;
		FCBaseArrow* pArrowB = NULL;
		BOOL bIsWidePoly;
		BOOL bIsClose;
		pFig->DrawObject(pDC, vlgptPoly, bIsClose, pArrowF, pArrowB,
						bIsWidePoly, bIsMono);
		if (pArrowF != NULL) delete pArrowF;
		if (pArrowB != NULL) delete pArrowB;
	}
} // FCPictArrow::PostDraw.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPictArrow::DrawShadow
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jGoOiIpDjGhLjBmMiCmMiPoDiPpMiCoIiCmGiJlKiPpMiCoIiCmMiJgFiCpAjFgAiJoGiClHiCoJiBeCjGoOiIpDjGhLjBmMiBgJiDhMiDiKiDfDiDjD_xHqqkZx_
 *			_xZkqqHx_iCmJjAnKjBlBiClDiCoKiCoJjFjEjFkKiBgKiCmMiJgFiCmNjFgAiJoGiClFiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCPictArrow::DrawShadow (CDC* pDC)
{
	ObjDynabaseVector vObj;
	m_pArrow->GetPreDrawObjects(vObj);
	m_pArrow->GetPostDrawObjects(vObj);
	ObjDynabaseVector::iterator iObj;
	for (iObj = vObj.begin(); iObj != vObj.end(); iObj++)
	{
		// _xZkqqHx_iDhDiDeOiDgAiDiDjGoOiIpDiCmMiDiBiDjDiDgPiBfLiCmNiBeBjFeLiClIjAhNiMgAiMgOjFjEjFgJiBgJ_xHqqkZx_ObjFigure_xZkqqHx_iBgKiBeC_xHqqkZx_
		FCObjFigure* pFig = (FCObjFigure*)(*iObj);
		FCLgPolyBezier vlgptPoly;
		FCBaseArrow* pArrowF = NULL;
		FCBaseArrow* pArrowB = NULL;
		BOOL bIsWidePoly;
		BOOL bIsClose;
		pFig->DrawShadow(pDC, vlgptPoly, bIsClose, pArrowF, pArrowB, bIsWidePoly);
		if (pArrowF != NULL) delete pArrowF;
		if (pArrowB != NULL) delete pArrowB;
	}
} // FCPictArrow::DrawShadow.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPictArrow::GetLocalObject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMjGoOiIpDjHhAiCmJjFkBjAlLiClDiCoKiBeBiDiNiBfLiDeKiDiJiDeDiDfJiClDiCoKiClNiDhDiDeOiDgAiDiDjGoOiIpDjFjEjFgJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhDiDeOiDgAiDiDjGoOiIpDjFjEjFgJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	_xZkqqHx_iDhGiDiJiDePiDeDiDjD_xHqqkZx_SDK_xZkqqHx_jHhAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.10.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCObjPictArrow* FCPictArrow::GetLocalObject () const
{
	return m_pArrow;
} // FCPictArrow::GetLocalObject.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPictArrow::GetStdObject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jGoOiIpD_xHqqkZx_ID_xZkqqHx_iCmGjFjNiNeMjApMiCkJiCmHiCkEiCkJiCmMiPoOjFpBiCkJiCoHiBeBiOfBiPmGiClHiCnHiCkLjGoOiIpDjFjEjFgJiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const FCObjPictArrow* FCPictArrow::GetStdObject () const
{
	if (m_bWidePoly && g_pEnv->GetPictArrowRec(m_paid)->m_objpPictArrowMaster2 != NULL)
		return (const FCObjPictArrow*)g_pEnv->GetPictArrowRec(m_paid)->m_objpPictArrowMaster2;
	else
		return (const FCObjPictArrow*)g_pEnv->GetPictArrowRec(m_paid)->m_objpPictArrowMaster1;
} // FCPictArrow::GetStdObject.

//----- 06.03.18 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCPictArrow::PenBrushConvert
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiJlKiCmJiCkAiCoJjBfDiCmEiCmMjFjEjFgJiCmMiBeBjDgPjIfOiDhJiDjDiCmGjDgPjIfOiDhFiDiJiDfGiCpAjCmKiPoNiCmM_xHqqkZx_
// *			_xZkqqHx_iDhJiDjDiCmGiDhFiDiJiDfGiCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj				:_xZkqqHx_jBmOiPnLjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
// *			byDuty				:_xZkqqHx_jFjEjFgJiCmMjGpAiKiEiCpAiOhHjCoIiBeC_xHqqkZx_
// *			psidPenStyle		:_xZkqqHx_iDhJiDjDiDfIiDfOiDeDiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
// *			mmfPenWeight		:_xZkqqHx_iDhJiDjDjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
// *			mmPenWidth			:_xZkqqHx_iDhJiDjDjFjNiBgJjFjNiNeMjFjEjFgJiCmMiPoKiNiHiCmNjFjNiBgKiCpAiOhHjCoIiBeC_xHqqkZx_
// *			dRatio				:_xZkqqHx_iDhJiDjDiKgHjBoFjHkGiCpAiOhHjCoIiBeC_xHqqkZx_
// *			scidPenBackSColor	:_xZkqqHx_iDhJiDjDjEhHiMgJjAeGiCpAiOhHjCoIiBeC_xHqqkZx_
// *			ptidBrushPattern	:_xZkqqHx_iDhFiDiJiDfGiDhAiDfOiBfLiDjDiCpAiOhHjCoIiBeC_xHqqkZx_
// *			scidBrushForeSColor	:_xZkqqHx_iDhFiDiJiDfGjBePiMgJjAeGiCpAiOhHjCoIiBeC_xHqqkZx_
// *			scidBrushBackSColor	:_xZkqqHx_iDhFiDiJiDfGjEhHiMgJjAeGiCpAiOhHjCoIiBeC_xHqqkZx_
// *			scidShadowSColor	:_xZkqqHx_iJgFjAeGiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCPictArrow::PenBrushConvert (	FCObjDynabase* pObj,			// _xZkqqHx_jBmOiPnLjFjEjFgJiBeC_xHqqkZx_
//									BYTE byDuty,					// _xZkqqHx_jFjEjFgJiCmMjGpAiKiEiBeC_xHqqkZx_
//									PenStyleID psidPenStyle,		// _xZkqqHx_iDhJiDjDiDfIiDfOiDeDiDiLiBeC_xHqqkZx_
//									fmmetol mmfPenWeight,			// _xZkqqHx_iDhJiDjDjFjNiBeC_xHqqkZx_
//									mmetol mmPenWidth,				// _xZkqqHx_iDhJiDjDjFjNiBgJjFjNiNeMjFjEjFgJiCmMiPoKiNiHiCmNjFjNiBgK_xHqqkZx_
//									double dRatio,					// _xZkqqHx_iDhJiDjDiKgHjBoFjHkGiBeC_xHqqkZx_
//									SColorID scidPenBackSColor,		// _xZkqqHx_iDhJiDjDjEhHiMgJjAeGiBeC_xHqqkZx_
//									PatternID ptidBrushPattern,		// _xZkqqHx_iDhFiDiJiDfGiDhAiDfOiBfLiDjDiBeC_xHqqkZx_
//									SColorID scidBrushForeSColor, 	// _xZkqqHx_iDhFiDiJiDfGjBePiMgJjAeGiBeC_xHqqkZx_
//									SColorID scidBrushBackSColor,	// _xZkqqHx_iDhFiDiJiDfGjEhHiMgJjAeGiBeC_xHqqkZx_
//									SColorID scidShadowSColor)		// _xZkqqHx_iJgFjAeGiBeC_xHqqkZx_
//{
//	// _xZkqqHx_iNmEiLeBjDeJiCmJiDiBiDjDiDgPiBfLjFjEjFgJiCmJiPiIjHjNiCpAiOmAiNhDiBeC_xHqqkZx_
//	for (long lObjIdx = 0; lObjIdx < pObj->GetMemberSize(); lObjIdx++)
//		PenBrushConvert(pObj->GetMember(lObjIdx),		// _xZkqqHx_jBmOiPnLjFjEjFgJiBeC_xHqqkZx_
//						byDuty,					// _xZkqqHx_jFjEjFgJiCmMjGpAiKiEiBeC_xHqqkZx_
//						psidPenStyle,			// _xZkqqHx_iDhJiDjDiDfIiDfOiDeDiDiLiBeC_xHqqkZx_
//						mmfPenWeight,			// _xZkqqHx_iDhJiDjDjFjNiBeC_xHqqkZx_
//						mmPenWidth,				// _xZkqqHx_iDhJiDjDjFjNiBgJjFjNiNeMjFjEjFgJiCmMiPoKiNiHiCmNjFjNiBgK_xHqqkZx_
//						dRatio,					// _xZkqqHx_iDhJiDjDiKgHjBoFjHkGiBeC_xHqqkZx_
//						scidPenBackSColor,		// _xZkqqHx_iDhJiDjDjEhHiMgJjAeGiBeC_xHqqkZx_
//						ptidBrushPattern,		// _xZkqqHx_iDhFiDiJiDfGiDhAiDfOiBfLiDjDiBeC_xHqqkZx_
//						scidBrushForeSColor, 	// _xZkqqHx_iDhFiDiJiDfGjBePiMgJjAeGiBeC_xHqqkZx_
//						scidBrushBackSColor,	// _xZkqqHx_iDhFiDiJiDfGjEhHiMgJjAeGiBeC_xHqqkZx_
//						scidShadowSColor);		// _xZkqqHx_iJgFjAeGiBeC_xHqqkZx_
//
//	if (pObj->IsKindOf(FDOJ_FIGURE))
//	//----- _xZkqqHx_jAhNiMgAiMgOjFjEjFgJiCmMiPoKiNiH_xHqqkZx_ -----
//	{
//		//----- _xZkqqHx_jAhNiMgAiMgOjFjEjFgJiCmMiPoKiNiHiCmNiBeBjBkOjAkLjFmPiNfIiCmMiPiIjHjNiCpAjBlBiCkPiCoJ_xHqqkZx_ -----
//		FCObjFigure* pFig = (FCObjFigure*)pObj;
//		//----- _xZkqqHx_jDgPjIfOiDhJiDjDiCmMiPoKiNiHiCmNiBeBjCmKiPoNiCmMiDhJiDjDiCmJjFmPiKlHiClHiCoJ_xHqqkZx_ -----
//		if (pFig->GetPenRegister() != FD_PEN_REGISTER_UNUSE)
//		{
//			pFig->SetPenStyle(g_pEnv->GetPenRegisterRec(pFig->GetPenRegister())->m_psidPenStyle);
//			pFig->SetPenWeight(g_pEnv->GetPenRegisterRec(pFig->GetPenRegister())->m_mmfPenWeight);
//			pFig->SetPenBackSColor(g_pEnv->GetPenRegisterRec(pFig->GetPenRegister())->m_scidPenBackSColor);
//			pFig->SetPenRegister(FD_PEN_REGISTER_UNUSE);
//		}
//		//----- _xZkqqHx_jDgPjIfOiDhFiDiJiDfGiCmMiPoKiNiHiCmNiBeBjCmKiPoNiCmMiDhFiDiJiDfGiCmJjFmPiKlHiClHiCoJ_xHqqkZx_ -----
//		if (pFig->GetBrushRegister() != FD_BRUSH_REGISTER_UNUSE)
//		{
//			pFig->SetBrushPattern(g_pEnv->GetBrushRegisterRec(pFig->GetBrushRegister())->m_ptidBrushPattern);
//			pFig->SetBrushForeSColor(g_pEnv->GetBrushRegisterRec(pFig->GetBrushRegister())->m_scidBrushForeSColor);
//			pFig->SetBrushBackSColor(g_pEnv->GetBrushRegisterRec(pFig->GetBrushRegister())->m_scidBrushBackSColor);
//			pFig->SetBrushRegister(FD_BRUSH_REGISTER_UNUSE);
//		}
//		//----- _xZkqqHx_iDfOiBfLiDfBiDgCiDgHjFjEjFgJiCmMiDhJiDjDiPoOjFpBiCpAiBeBiMhAiPlDiDhEiDiJiDePiCmJiPfNiCmBiCmEiPjBiCkLiKlHiCkGiCoJ_xHqqkZx_ -----
//		if (byDuty & FDAR_SYNC_PEN_STYLE)
//			pFig->SetPenStyle(psidPenStyle);
//		if (byDuty & FDAR_SYNC_PEN_WEIGHT)
//			pFig->SetPenWeight(mmfPenWeight);
//		else
//		if (byDuty & FDAR_SYNC_PEN_WIDTH)
//			pFig->SetPenWeight(mmPenWidth);
//		else
//			pFig->SetPenWeight(pFig->GetPenWeight() * dRatio);
//										// _xZkqqHx_iDhJiDjDiCmMjBlOiClDiCmNiDiKiDfEiDeDiDfJiCmJiNiHiCoNiClJiCmEjFmPiNfIiBeC_xHqqkZx_
//		if (byDuty & FDAR_SYNC_PEN_BACK_S_COLOR)
//			pFig->SetPenBackSColor(scidPenBackSColor);
//		if (byDuty & FDAR_SYNC_BRUSH_PATTERN)
//			pFig->SetBrushPattern(ptidBrushPattern);
//		if (byDuty & FDAR_SYNC_BRUSH_FORE_S_COLOR)
//			pFig->SetBrushForeSColor(scidBrushForeSColor);
//		if (byDuty & FDAR_SYNC_BRUSH_BACK_S_COLOR)
//			pFig->SetBrushBackSColor(scidBrushBackSColor);
//		pFig->SetShadowSColor(scidShadowSColor);
//	}
//} // FCPictArrow::PenBrushConvert.
//----- 06.03.18 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

///////////////////////////////////////////////////////////////////////////////

//----------<NOT EXPORT TO VIEWER>-----------
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	GetArrowStyleName
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfOiDeDiDhGiCkKjCoIiMgAiDhAiDfOiBfLiDjD_xHqqkZx_(FDUG_ARW_TYPE_TYPICAL)_xZkqqHx_iCmMiOjOiBeB_xHqqkZx_
 *			_xZkqqHx_iDfIiDfOiDeDiDiL_xHqqkZx_(FDUG_ARW_STYL_ARROW_XX)_xZkqqHx_iCkJiCoHiDfIiDfOiDeDiDiLjGlMjFlGiOjKjHpBiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	_xZkqqHx_iDfIiDfOiDeDiDiLiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfIiDfOiDeDiDiLjGlMjFlGiOjKjHpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDhAiDgFiDeCiDfPiDeDiDeBiDiNiDePjHhAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.11 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
const wchar_t* GetArrowStyleName (int index)
{
	const DWORD dwName[] =
	{
		IDS_ARROW_WIRE_SHORT,		// "_xZkqqHx_jCfKiCkCjGoOiIpD_xHqqkZx_(_xZkqqHx_jGfPiPpD_xHqqkZx_)"
		IDS_ARROW_WIRE_REGULAR,		// "_xZkqqHx_jFiBjCmKjGoOiIpD_xHqqkZx_(_xZkqqHx_jGfPiPpD_xHqqkZx_)"
		IDS_ARROW_WIRE_LONG,		// "_xZkqqHx_jClHiCkCjGoOiIpD_xHqqkZx_(_xZkqqHx_jGfPiPpD_xHqqkZx_)"
		IDS_ARROW_DELTA_SHORT,		// "_xZkqqHx_jCfKiCkCjGoOiIpD_xHqqkZx_(_xZkqqHx_iOePiKhAiMgA_xHqqkZx_)"
		IDS_ARROW_DELTA_REGULAR,	// "_xZkqqHx_jFiBjCmKjGoOiIpD_xHqqkZx_(_xZkqqHx_iOePiKhAiMgA_xHqqkZx_)"
		IDS_ARROW_DELTA_LONG,		// "_xZkqqHx_jClHiCkCjGoOiIpD_xHqqkZx_(_xZkqqHx_iOePiKhAiMgA_xHqqkZx_)"
		IDS_ARROW_STANDARD_SHORT,	// "_xZkqqHx_jCfKiCkCjGoOiIpD_xHqqkZx_(_xZkqqHx_iCoCiClGiCoIiMfO_xHqqkZx_)"
		IDS_ARROW_STANDARD_REGULAR,	// "_xZkqqHx_jFiBjCmKjGoOiIpD_xHqqkZx_(_xZkqqHx_iCoCiClGiCoIiMfO_xHqqkZx_)"
		IDS_ARROW_STANDARD_LONG,	// "_xZkqqHx_jClHiCkCjGoOiIpD_xHqqkZx_(_xZkqqHx_iCoCiClGiCoIiMfO_xHqqkZx_)"
	};
	return GetResWString(dwName[index]);
} // GetArrowStyleName.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	GetArrowSizeName
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfOiDeDiDhGiCkKjCoIiMgAiDhAiDfOiBfLiDjD_xHqqkZx_(FDUG_ARW_TYPE_TYPICAL)_xZkqqHx_iCmMiOjOiBeBjGoOiIpDiCmM_xHqqkZx_
 *			_xZkqqHx_iDfEiDeDiDfJjAjEiCkJiCoHjBoFiCkLiClDiCpAjFfMiClHjFlGiOjKjHpBiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	_xZkqqHx_jGoOiIpDiCmMiDfEiDeDiDfJjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jGoOiIpDiCmMjBoFiCkLiClDiCpAjFfMiClHjGlMjFlGiOjKjHpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDhAiDgFiDeCiDfPiDeDiDeBiDiNiDePjHhAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.11 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
const wchar_t* GetArrowSizeName (int index)
{
	// _xZkqqHx_iDfEiDeDiDfJjHhAjFlGiOjKjHpBiBeC_xHqqkZx_FDUG_ARW_SIZE_MAX_xZkqqHx_iBhLiCfAiMmCiBeC_xHqqkZx_
	const DWORD dwName[] =
	{
		IDS_SMALL_QUITE,    // "_xZkqqHx_iLmJiCnPiCmEiPkMiClDiCkC_xHqqkZx_"
		IDS_SMALL_PRETTY,   // "_xZkqqHx_iCkJiCmIiCoIiPkMiClDiCkC_xHqqkZx_"
		IDS_SMALL_SOSO,     // "_xZkqqHx_iCnMiCkAiCnMiCkAiPkMiClDiCkC_xHqqkZx_"
		IDS_SMALL_RATHER,   // "_xZkqqHx_iPkNiClFiPkMiClDiCkC_xHqqkZx_"
		IDS_REGULAR,        // "_xZkqqHx_jFiBjCmK_xHqqkZx_"
		IDS_LARGE_RATHER,   // "_xZkqqHx_iPkNiClFjBoFiCkLiCkC_xHqqkZx_"
		IDS_LARGE_SOSO,     // "_xZkqqHx_iCnMiCkAiCnMiCkAjBoFiCkLiCkC_xHqqkZx_"
		IDS_LARGE_PRETTY,   // "_xZkqqHx_iCkJiCmIiCoIjBoFiCkLiCkC_xHqqkZx_"
		IDS_LARGE_QUITE,    // "_xZkqqHx_iLmJiCnPiCmEjBoFiCkLiCkC_xHqqkZx_"
	};
	return GetResWString(dwName[index]);
} // GetArrowSizeName.
//----------</NOT EXPORT TO VIEWER>-----------

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CalcPQR
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jGoOiIpDiCmJiOgHjHhAiClHiCoJjFmPjAjEiCgPiBeBiChAiBeBiChBiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pqr			:_xZkqqHx_iCgPiBeBiChAiBeBiChBiCpAjFnEiClHiInHiCmMjFmPjAjEiBeC_xHqqkZx_
 *			mmWeight	:_xZkqqHx_jApMiCmMjFjNiBeC_xHqqkZx_
 *			params		:_xZkqqHx_jGoOiIpDiCpAiMhGiOfKiClHiCoJiInHiCmMiCfCiCmCiCmMiDhAiDiJiDiBiBfLiDfOiCmG_xHqqkZx_
 *						 _xZkqqHx_jGoOiIpDiCmMiMfOiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iCgPiBeBiChAiBeBiChBiCmNjAnNiMhGiDgNiBfLiDgH_xHqqkZx_P244_xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iChAiCmGiChBiCmMjCgMiCmNiCePiCmJiCmIiCoHiCmIiCkCiCoGiCkEiCmJiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CalcPQR (FCUGPqr& pqr, double mmWeight, const FCUGArrowParams& params)
{
	if (mmWeight < 1.0) mmWeight = 1.0;
	double dW2 = double(mmWeight) / 2.0;
	switch (params.byType)
	{
	case FDUG_ARW_TYPE_FLAT:		// _xZkqqHx_iDhEiDiJiDgCiDgHiBeC_xHqqkZx_
		pqr.dR = pqr.dP = pqr.dQ = 0;
		break;
	case FDUG_ARW_TYPE_TYPICAL:		// _xZkqqHx_jDfEiMfOjDeJiDhAiDfOiBfLiDjDiBeC_xHqqkZx_
		switch (params.byParam0)
		{
		case FDUG_ARW_STYL_ARROW_A0:	// _xZkqqHx_jCfKiCkCjGoOiIpDiBgJjGfPiPpDiBgKiBeC_xHqqkZx_
			pqr.dR = (double(params.byParam1) * double(params.byParam1) / 6.0 + 1.0) * dW2;
			pqr.dQ = pqr.dR;
			pqr.dP = 0.0;
			break;
		case FDUG_ARW_STYL_ARROW_A1:	// _xZkqqHx_jFiBjCmKjGoOiIpDiBgJjGfPiPpDiBgKiBeC_xHqqkZx_
			pqr.dR = (double(params.byParam1) * double(params.byParam1) / 6.0 + 1.0) * dW2;
			pqr.dQ = pqr.dR * 2.0;
			pqr.dP = 0.0;
			break;
		case FDUG_ARW_STYL_ARROW_A2:	// _xZkqqHx_jClHiCkCjGoOiIpDiBgJjGfPiPpDiBgKiBeC_xHqqkZx_
			pqr.dR = (double(params.byParam1) * double(params.byParam1) / 6.0 + 1.0) * dW2;
			pqr.dQ = pqr.dR * 3.0;
			pqr.dP = 0.0;
			break;
		case FDUG_ARW_STYL_ARROW_B0:	// _xZkqqHx_jCfKiCkCjGoOiIpDiBgJiOePiKhAiMgAiBgKiBeC_xHqqkZx_
			pqr.dR = (double(params.byParam1) * double(params.byParam1) / 6.0 + 1.0) * dW2;
			pqr.dP = pqr.dQ = pqr.dR;
			break;
		case FDUG_ARW_STYL_ARROW_B1:	// _xZkqqHx_jFiBjCmKjGoOiIpDiBgJiOePiKhAiMgAiBgKiBeC_xHqqkZx_
			pqr.dR = (double(params.byParam1) * double(params.byParam1) / 6.0 + 1.0) * dW2;
			pqr.dP = pqr.dQ = pqr.dR * 2.0;
			break;
		case FDUG_ARW_STYL_ARROW_B2:	// _xZkqqHx_jClHiCkCjGoOiIpDiBgJiOePiKhAiMgAiBgKiBeC_xHqqkZx_
			pqr.dR = (double(params.byParam1) * double(params.byParam1) / 6.0 + 1.0) * dW2;
			pqr.dP = pqr.dQ = pqr.dR * 3.0;
			break;
		case FDUG_ARW_STYL_ARROW_C0:	// _xZkqqHx_jCfKiCkCjGoOiIpDiBgJiCoCiClGiCoIiMfOiBgKiBeC_xHqqkZx_
			pqr.dR = (double(params.byParam1) * double(params.byParam1) / 6.0 + 1.0) * dW2;
			pqr.dQ = pqr.dR;
			pqr.dP = pqr.dQ * 0.7;
			break;
		case FDUG_ARW_STYL_ARROW_C1:	// _xZkqqHx_jFiBjCmKjGoOiIpDiBgJiCoCiClGiCoIiMfOiBgKiBeC_xHqqkZx_
			pqr.dR = (double(params.byParam1) * double(params.byParam1) / 6.0 + 1.0) * dW2;
			pqr.dQ = pqr.dR * 2.0;
			pqr.dP = pqr.dQ * 0.7;
			break;
		case FDUG_ARW_STYL_ARROW_C2:	// _xZkqqHx_jClHiCkCjGoOiIpDiBgJiCoCiClGiCoIiMfOiBgKiBeC_xHqqkZx_
			pqr.dR = (double(params.byParam1) * double(params.byParam1) / 6.0 + 1.0) * dW2;
			pqr.dQ = pqr.dR * 3.0;
			pqr.dP = pqr.dQ * 0.7;
			break;
		}
		break;
	case FDUG_ARW_TYPE_ARROW_A:		// _xZkqqHx_jGoOiIpDiBgJjGfPiPpDiBgKiBeC_xHqqkZx_
		pqr.dR = (params.byParam0 + 1) * dW2;
		pqr.dQ = (2 * params.byParam1 + 1) * dW2;
		pqr.dP = 0.0;
		break;
	case FDUG_ARW_TYPE_ARROW_B:		// _xZkqqHx_jGoOiIpDiBgJiOePiKhAiMgAiBgKiBeC_xHqqkZx_
		pqr.dP = pqr.dQ = (2 * params.byParam1 + 1) * dW2;
		pqr.dR = (params.byParam0 + 1) * dW2;
		break;
	case FDUG_ARW_TYPE_ARROW_C:		// _xZkqqHx_jGoOiIpDiBgJiCoCiClGiCoIiMfOiBgKiBeC_xHqqkZx_
		pqr.dP = (2 * params.byParam2 + 1) * dW2;
		pqr.dQ = (2 * params.byParam1 + 1) * dW2;
		pqr.dR = (params.byParam0 + 1) * dW2;
		break;
	}
} // CalcPQR.

