// CmbPenWeight.cpp : _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgFiBfLiDfGiDiHiDjD_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

#include "stdafx.h"
#include "DynamicDraw.h"
#include "UtilCoord.h"		// For mm2lg.etc.
#include "UtilWin.h"		// For FFGetWindowText.
#include "UtilMath.h"		// For histr2hix.
#include "UtilGraph.h"		// For FCAutoDC.
#include "RegData.h"		// For hix2mm,mm2hix.
#include "CmbPenWeight.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define	FDOJ_LINE_BOX_WIDTH	50

//----- 05.08.10 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
// _xZkqqHx_iDgIiDiNiDgCiDhGiDfPiDeFiDjDiCmMjFjNiBeC_xHqqkZx_
const int CFCCmbPenWeight::DROPWIDTH = 250;
//----- 05.08.10 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

/////////////////////////////////////////////////////////////////////////////
// CFCCmbPenWeight

IMPLEMENT_DYNCREATE(CFCCmbPenWeight, CFCCmbBase)

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCmbPenWeight::CFCCmbPenWeight
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDhEiDeIiDiLiDgHiDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCCmbPenWeight::CFCCmbPenWeight () : CFCCmbBase(FALSE)
{
	m_mmfProperWeight = -1.0;
	m_mmfCurrentWeight = -1.0;
} // CFCCmbPenWeight::CFCCmbPenWeight.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCmbPenWeight::~CFCCmbPenWeight
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCCmbPenWeight::~CFCCmbPenWeight ()
{
} // CFCCmbPenWeight::~CFCCmbPenWeight.

BEGIN_MESSAGE_MAP(CFCCmbPenWeight, BASE_CLASS)
	//{{AFX_MSG_MAP(CFCCmbPenWeight)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


static mmetol s_mmaPenWeight[] =
{
	0.0,
	0.25,
	0.5,
	0.75,
	1.0,
	1.5,
	2.0,
	3.0,
	4.0,
};


/////////////////////////////////////////////////////////////////////////////
// _xZkqqHx_iLkEjCmKiDiGiBfLiDfFiDeJiDhJiDiMiBfLiDfGiDiHiDjD_xHqqkZx_
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCmbPenWeight::UpdateItem
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNjBeJjBpAjCiGiCmMiDgGiBfLiDfOiCpAjFnLjBlGiClFiCmEiBeBiMpDjFoCiDiKiDfIiDgHiCpAiNfIjAfGiClHiCoJiBeCiClLiCmMiMoD_xHqqkZx_
 *			_xZkqqHx_iDgGiBfLiDfOiCpAjGnPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	SetFocus_xZkqqHx_jDjJiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeCjBlMiCmMiDeFiDeCiDjDiDgIiDeFjDjJiCmFiMpDjFoCiDiKiDfIiDgHiCkK_xHqqkZx_
 *			_xZkqqHx_iNfIjAfGiClDiCoKiClNiPoKiNiHiCmJjBmOiJjOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.12.17 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCCmbPenWeight::UpdateItem ()
{
	// _xZkqqHx_jFfMiOkGjFlGiOjKjHpBiCpAjFnLjBlGiBeC_xHqqkZx_
	WString str;
	// _xZkqqHx_iMlLiNnNiCmMjBeJjBpAiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnLjBlGiBeC_xHqqkZx_
	INT	nSel = GetCurSel();
	FFGetWindowText(this, str);
	// _xZkqqHx_iMlLiNnNiCmMjBeJjBpAjCiGiCmMiImKjChFiCpAjFnLjBlGiBeC_xHqqkZx_
	DWORD dwSel = GetEditSel();

	// _xZkqqHx_iMpDjFoCiDiKiDfIiDgHiCpAiIoKjAfGiBeC_xHqqkZx_
	ResetContent();
	SetItems();

	// _xZkqqHx_jBeJjBpAiDeDiDjDiDgGiDgCiDeOiDfIiCpAjGnPiClHiBeC_xHqqkZx_
	SetCurSel(nSel);
	// _xZkqqHx_jFfMiOkGjFlGiOjKjHpBiCpAjGnPiClHiBeC_xHqqkZx_
	FFSetWindowText(this, str);
	// _xZkqqHx_jBeJjBpAiImKjChFiCpAjGnPiClHiBeC_xHqqkZx_
	SetEditSel(dwSel & 0xffff, dwSel >> 16);
} // CFCCmbPenWeight::UpdateItem.

/////////////////////////////////////////////////////////////////////////////
// _xZkqqHx_iMmFjHeMiDiGiBfLiDfFiDeJiDhJiDiMiBfLiDfGiDiHiDjD_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCmbPenWeight::GetCurPenWeight
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
fmmetol CFCCmbPenWeight::GetCurPenWeight () const
{
	return m_mmfCurrentWeight;
} // CFCCmbPenWeight::GetCurPenWeight.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCmbPenWeight::SetCurPenWeight
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCCmbPenWeight::SetCurPenWeight (fmmetol mmfPenWeight)
{
	m_mmfCurrentWeight = mmfPenWeight;

	DWORD	dwPenW = *(reinterpret_cast<DWORD*>(&mmfPenWeight));
	LONG	lSel;
	for (lSel = GetCount() - 1; 0 <= lSel; lSel--)
	{
		if (dwPenW == GetItemData(lSel))
		{
			m_mmfProperWeight = -1.0;
			SetCurSel(lSel);
			return;
		}
	}
	m_mmfProperWeight = mmfPenWeight;
	UpdateItem();	// m_lProperColor_xZkqqHx_iCpAjElNiJgGiClHiCoJiClNiCnPiBeC_xHqqkZx_
	for (lSel = GetCount() - 1; 0 <= lSel; lSel--)
	{
		if (dwPenW == GetItemData(lSel))
		{
			SetCurSel(lSel);
			return;
		}
	}
	SetCurSel(1);
} // CFCCmbPenWeight::SetCurPenWeight.

/////////////////////////////////////////////////////////////////////////////
// _xZkqqHx_iDiGiBfLiDfFiDeJiBfLiDgPiBfLiDiJiDeDiDgI_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCmbPenWeight::SetItems
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDfIiDgHiDhLiDgCiDeOiDfIiPiJiKpKiJlLiCmMiNnLiCmJiOmAiNhDiClDiCoKiCoJiBeCiDiKiDfIiDgHiDhLiDgCiDeOiDfIiCmJ_xHqqkZx_
 *			_xZkqqHx_iMpDjFoCiDiKiDfIiDgHiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCCmbPenWeight::SetItems ()
{
	wchar_t tcsBuff[100];
	DWORD	dwPenW;
	LONG	lIndex;
	//----- _xZkqqHx_iOhHjCoIjGlDiClFiCmMiDeBiDeDiDgFiDiAiCpA_xHqqkZx_-1_xZkqqHx_iCmFjDgPjIfO_xHqqkZx_ -----
	fmmetol fPenW = -1.0;
	dwPenW = *(reinterpret_cast<DWORD*>(&fPenW));
	lIndex = AddString(_T(""));
	SetItemData(lIndex, dwPenW);
	//----- _xZkqqHx_iMmFjHeMiDeBiDeDiDgFiDiAiCkKiCkAiCoKiCmOjDgPjIfO_xHqqkZx_ -----
	if (0 <= m_mmfProperWeight)
	{
		hix2histr(tcsBuff, mm2hix(m_mmfProperWeight));
		dwPenW = *(reinterpret_cast<DWORD*>(&m_mmfProperWeight));
		lIndex = AddString(WStrToTStr(tcsBuff));
		SetItemData(lIndex, dwPenW);
	}
	//----- _xZkqqHx_jHmHiCkNiOgHiCkEiDfIiDfOiDeDiDiLiCpAjDgPjIfO_xHqqkZx_ -----
	WString strNum;
	const int iMaxC = sizeof(s_mmaPenWeight) / sizeof(s_mmaPenWeight[0]);
	for (int iC = 0; iC < iMaxC; iC++)
	{
		// _xZkqqHx_jDkPiClGjFlGiOjKjHpBiCmNjAnNjCoIiClFiCmIiCkCiBeC_xHqqkZx_
		if (strNum == hix2histr(tcsBuff, hixroundoff(mm2hix(s_mmaPenWeight[iC])))) continue;
		strNum = tcsBuff;
		lIndex = AddString(WStrToTStr(strNum));
		fPenW = mmroundoff(s_mmaPenWeight[iC]);
		dwPenW = *(reinterpret_cast<DWORD*>(&fPenW));
		SetItemData(lIndex, dwPenW);
	}
} // CFCCmbPenWeight::SetItems.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCmbPenWeight::DrawItemSub
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCCmbPenWeight::DrawItemSub (DWORD dwID, UINT wItem, COLORREF col, CRect& lgrtBox, BOOL bIsDropped, CDC* pDC)
{
	CRect lgrtDraw;
	if (lgrtBox.Width() < FDOJ_LINE_BOX_WIDTH)
		lgrtDraw = lgrtBox;
	else
		lgrtDraw.SetRect(	lgrtBox.left,
							lgrtBox.top,
					 		lgrtBox.left + FDOJ_LINE_BOX_WIDTH,
							lgrtBox.bottom);
	CRect lgrtText(	lgrtDraw.right + 4,
					lgrtBox.top,
					lgrtBox.right,
					lgrtBox.bottom);
	fmmetol mmfPenWeight = *(reinterpret_cast<fmmetol*>(&dwID));
	if (mmfPenWeight < 0.0) return;

	// CDC_xZkqqHx_iCpA_xHqqkZx_Auto_xZkqqHx_iCmFiDiJiDgCiDhGiBeC_xHqqkZx_
	FCAutoDC atDC(pDC, FALSE, 0, 0);
	LOGBRUSH logBrush = { BS_SOLID, FD_COLREF_BLACK, 0 };
	atDC.SetPen(PS_GEOMETRIC|PS_SOLID|PS_ENDCAP_FLAT,
					D2L(mmfPenWeight * g_->dDisplayPPM), &logBrush);
	atDC.MoveTo(lgrtDraw.left, (lgrtDraw.top + lgrtDraw.bottom) / 2);
	atDC.LineTo(lgrtDraw.right, (lgrtDraw.top + lgrtDraw.bottom) / 2);
	WString	str;
	FFGetLBText(this, wItem, str);
	if (0 < lgrtText.Width())
		atDC.DrawText(str, CP_ACP, &lgrtText, DT_LEFT);
} // CFCCmbPenWeight::DrawItemSub.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCmbPenWeight::SelChanged
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCCmbPenWeight::SelChanged ()
{
	DWORD dwID = GetItemData(GetCurSel());
	m_mmfCurrentWeight = *(reinterpret_cast<fmmetol*>(&dwID));
} // CFCCmbPenWeight::SelChanged.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCmbPenWeight::EditChanged
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCCmbPenWeight::EditChanged ()
{
	WString	str;
	FFGetWindowText(this, str);
	m_mmfCurrentWeight = hix2mm(histr2hix(str));
} // CFCCmbPenWeight::EditChanged.

/////////////////////////////////////////////////////////////////////////////
// _xZkqqHx_iDiGiBfLiDfFiDeBiDgHiDiKiDhCiDiFiBfLiDgH_xHqqkZx_

/////////////////////////////////////////////////////////////////////////////
// CFCCmbPenWeight _xZkqqHx_iDiBiDgCiDfKiBfLiDfH_xHqqkZx_ _xZkqqHx_iDgOiDjDiDgIiDiJ_xHqqkZx_
