#ifndef __ControlFDATmpl_h
#define __ControlFDATmpl_h

#include "stdafx.h"
#include "UtilMisc.h"	// For FFSetCapture.etc.

typedef void (*MoveItemCallback)(
						DWORD dwData,			// _xZkqqHx_iDfCiBfLiDiLiDgPiDgCiDeOjHhAiDgGiBfLiDfOiBeC_xHqqkZx_
						CWnd* pWnd,				// _xZkqqHx_iMmEiCnBiPgPiClFiMlDiCmMiDeFiDeCiDjDiDgIiDeFiBeC_xHqqkZx_
						long lCurState,			// FDA_xZkqqHx_iCmMiMlLiNnNiCmMiPpDjBnEiBeC_xHqqkZx_
						const CPoint& ptMsc,	// _xZkqqHx_iMlLiNnNiCmMiDhNiDeFiDfIiNmAjFfHiBeC_xHqqkZx_
						DWORD dwFlags);			// _xZkqqHx_jDkPiOjOiDeMiBfLiCmMiPpDjBnEiBeC_xHqqkZx_

template<class SUPER> class CFCControlFDATmpl : public SUPER
{
// _xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfGiDiHiDjD_xHqqkZx_
public:
	CFCControlFDATmpl();

// _xZkqqHx_iDiGiBfLiDfFiKnGjAjEiBeC_xHqqkZx_
public:
// 06.11.08 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	virtual BOOL	GetIsSingleSelect () const;
	virtual void	SetSingleSelect (BOOL bSingle);
//----- 07.01.20 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//// 06.11.07 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
////	virtual void	ClearContents ();
//----- 07.01.20 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	virtual void	ClearContents ();
//----- 07.01.20 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	virtual void	SetMoveItemCallback (MoveItemCallback fncMoveItem, DWORD dwData);

protected:
	virtual void	MemoMscPoint ();
	virtual long	CalcMemoToMscPower () const;
	virtual BOOL	CanStartMoveItem () const;

	//----- _xZkqqHx_iDeDiDhIiDjDiDgHjEkNjAlGiKnGjAjE_xHqqkZx_ -----
	virtual void	OnMsEvent (DWORD dwMessage, const CPoint& ptMsc, UINT nFlags);
	virtual void	OnKyEvent (DWORD dwMessage, UINT nChar, UINT nFlags);
	virtual void	OnCmEvent (DWORD dwCommand);
	//----- _xZkqqHx_iDeDiDhIiDjDiDgHiPiIjHjNiKnGjAjE_xHqqkZx_ -----
	virtual void	TimerEvent (DWORD dwIDEvent);
	virtual long	TransFDA (long iState, DWORD dwMessage, DWORD dwCommand = 0);
	virtual void	StateFDA (long iState);
	//----- _xZkqqHx_jBeKiInKiPpDjBnEiPiIjHjNiKnGjAjE_xHqqkZx_ -----
	virtual void	StateIdle ();					// _xZkqqHx_jBnCiClPiBeC_xHqqkZx_
	virtual void	StateRangeSelectItem ();		// _xZkqqHx_jEmNiImNjBeJjBpAiBeC_xHqqkZx_
	virtual void	StateRemoveSelectItem ();		// _xZkqqHx_jBeJjBpAiJpAiPjMiBeC_xHqqkZx_
	virtual void	StateAddSelectItem ();			// _xZkqqHx_jCmHiJmBjBeJjBpAiBeC_xHqqkZx_
	virtual void	StateSelectItem ();				// _xZkqqHx_jBeJjBpAiBeC_xHqqkZx_
	virtual void	StateSelectItem2 ();			// _xZkqqHx_jBeJjBpA_xHqqkZx__2_xZkqqHx_iBeC_xHqqkZx_
	virtual void	StateWaitEvent ();				// _xZkqqHx_iDeDiDhIiDjDiDgHjBnCiClPiBeC_xHqqkZx_
	virtual void	StateWaitEvent2 ();				// _xZkqqHx_iDeDiDhIiDjDiDgHjBnCiClP_xHqqkZx__2_xZkqqHx_iBeC_xHqqkZx_
	virtual void	StateBeginMoveItem ();			// _xZkqqHx_iInKjDkOiPiIjHjNiKeKiOgOiBeC_xHqqkZx_
	virtual void	StateMovingItem ();				// _xZkqqHx_iInKjDkOiPiIjHjNiBeC_xHqqkZx_
	virtual void	StateEndMoveItem ();			// _xZkqqHx_iInKjDkOiPiIjHjNiPeJjHlJiBeC_xHqqkZx_
	virtual void	StateCancelMoveItem ();			// _xZkqqHx_iInKjDkOiPiIjHjNiDeMiDiDiDjDiDfKiDiLiBeC_xHqqkZx_
	virtual void	StateRbtnSelectItem ();			// _xZkqqHx_iJeFiDhLiDfOiDjDjHhAjBeJjBpAiBeC_xHqqkZx_
	virtual void	StateContextMenu ();			// _xZkqqHx_iDiBiDgKiDiFiBfLjFfMiOkGiBeC_xHqqkZx_
	virtual void	StateLbtnDblClick ();			// _xZkqqHx_iNlGiDhLiDfOiDjDiDfPiDhFiDiLiDeOiDiKiDgCiDeOiBeC_xHqqkZx_

// _xZkqqHx_iDiGiBfLiDfFjCoIiLgAiBeC_xHqqkZx_
public:
enum
{
	STATE_NONE = 0,					// _xZkqqHx_iPpDjBnEjGlDiClFiBeC_xHqqkZx_
	STATE_IDLE,						// _xZkqqHx_jBnCiClPiBeC_xHqqkZx_
	STATE_RANGE_SELECT_ITEM,		// _xZkqqHx_jEmNiImNjBeJjBpAiBeC_xHqqkZx_
	STATE_REMOVE_SELECT_ITEM,		// _xZkqqHx_jBeJjBpAiJpAiPjMiBeC_xHqqkZx_
	STATE_ADD_SELECT_ITEM,			// _xZkqqHx_jCmHiJmBjBeJjBpAiBeC_xHqqkZx_
	STATE_SELECT_ITEM,				// _xZkqqHx_jBeJjBpAiBeC_xHqqkZx_
	STATE_SELECT_ITEM_2,			// _xZkqqHx_jBeJjBpA_xHqqkZx__2_xZkqqHx_iBeC_xHqqkZx_
	STATE_WAIT_EVENT,				// _xZkqqHx_iDeDiDhIiDjDiDgHjBnCiClPiBeC_xHqqkZx_
	STATE_WAIT_EVENT_2,				// _xZkqqHx_iDeDiDhIiDjDiDgHjBnCiClP_xHqqkZx__2_xZkqqHx_iBeC_xHqqkZx_
	STATE_BEGIN_MOVE_ITEM,			// _xZkqqHx_iInKjDkOiPiIjHjNiKeKiOgOiBeC_xHqqkZx_
	STATE_MOVING_ITEM,				// _xZkqqHx_iInKjDkOiPiIjHjNiBeC_xHqqkZx_
	STATE_END_MOVE_ITEM,			// _xZkqqHx_iInKjDkOiPiIjHjNiPeJjHlJiBeC_xHqqkZx_
	STATE_CANCEL_MOVE_ITEM,			// _xZkqqHx_iInKjDkOiPiIjHjNjCiGiOhOiBeC_xHqqkZx_
	STATE_RBTN_SELECT_ITEM,			// _xZkqqHx_iJeFiDhLiDfOiDjDjHhAjBeJjBpAiBeC_xHqqkZx_
	STATE_CONTEXT_MENU,				// _xZkqqHx_iDiBiDgKiDiFiBfLjFfMiOkGiBeC_xHqqkZx_
	STATE_LBTN_DBL_CLICK,			// _xZkqqHx_iNlGiDhLiDfOiDjDiDfPiDhFiDiLiDeOiDiKiDgCiDeOiBeC_xHqqkZx_
	STATE_END,						// _xZkqqHx_iPpDjBnEiPeJjHlJiBeC_xHqqkZx_
};

// _xZkqqHx_iDiGiBfLiDfFjFmPjAjEiBeC_xHqqkZx_
protected:
	CPoint		m_lgptMemo;			// _xZkqqHx_iDhNiDeFiDfIiNmAjFfHiBgJiLeMiJkPjHhAiBgKiBeC_xHqqkZx_
	BOOL		m_bSingleSelect;	// _xZkqqHx_jCfAjDmGjBeJjBpAiDiCiBfLiDgIiCkJiBeI_xHqqkZx_
	MoveItemCallback m_fncMoveItem;	// _xZkqqHx_iDeBiDeDiDgFiDiAiInKjDkOiDfCiBfLiDiLiDgPiDgCiDeOiKnGjAjEiBeC_xHqqkZx_
	DWORD		m_dwData;			// _xZkqqHx_iDfCiBfLiDiLiDgPiDgCiDeOjHhAiDgGiBfLiDfOiBeC_xHqqkZx_
	//----- _xZkqqHx_iDgDiBfLiDiLiCmMiPpDjBnEjFmPjAjE_xHqqkZx_ -----
	long		m_lCurState;		// FDA_xZkqqHx_iCmMiMlLiNnNiCmMiPpDjBnEiBeC_xHqqkZx_
	CPoint		m_ptMsc;			// _xZkqqHx_iMlLiNnNiCmMiDhNiDeFiDfIiNmAjFfHiBeC_xHqqkZx_
	DWORD		m_dwFlags;			// _xZkqqHx_jDkPiOjOiDeMiBfLiCmMiPpDjBnEiBeC_xHqqkZx_
	DWORD		m_dwChar;			// _xZkqqHx_iMlLiNnNiCmMiDeMiBfLiDfCiBfLiDgIiBeC_xHqqkZx_
	DWORD		m_dwCommand;		// _xZkqqHx_iMlLiNnNiCmMiDfCiDhNiDjDiDgIiBeC_xHqqkZx_

// _xZkqqHx_iDeBiDgHiDiKiDhCiDiFiBfLiDgH_xHqqkZx_
public:

// _xZkqqHx_iDeJiDhJiDiMiBfLiDfGiDiHiDjD_xHqqkZx_
public:

// _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgFiBfLiDfGiDiHiDjD_xHqqkZx_
public:
	virtual ~CFCControlFDATmpl();

}; // class CFCControlFDATmpl.

/////////////////////////////////////////////////////////////////////////////
// CFCControlFDATmpl

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCControlFDATmpl::CFCControlFDATmpl
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
CFCControlFDATmpl<SUPER>::CFCControlFDATmpl ()
{
	m_lgptMemo = CPoint(0, 0);	// _xZkqqHx_iDhNiDeFiDfIiNmAjFfHiBgJiLeMiJkPjHhAiBgKiBeC_xHqqkZx_
	m_bSingleSelect = FALSE;	// _xZkqqHx_jCfAjDmGjBeJjBpAiDiCiBfLiDgIiCkJiBeI_xHqqkZx_
	m_fncMoveItem = NULL;		// _xZkqqHx_iDeBiDeDiDgFiDiAiInKjDkOiDfCiBfLiDiLiDgPiDgCiDeOiKnGjAjEiBeC_xHqqkZx_
	//----- _xZkqqHx_iDgDiBfLiDiLiCmMiPpDjBnEjFmPjAjE_xHqqkZx_ -----
	m_lCurState = STATE_IDLE;	// FDA_xZkqqHx_iCmMiMlLiNnNiCmMiPpDjBnEiBeC_xHqqkZx_
	m_ptMsc = CPoint(0, 0);	// _xZkqqHx_iMlLiNnNiCmMiDhNiDeFiDfIiNmAjFfHiBeC_xHqqkZx_
	m_dwFlags = 0;				// _xZkqqHx_jDkPiOjOiDeMiBfLiCmMiPpDjBnEiBeC_xHqqkZx_
	m_dwChar = 0;				// _xZkqqHx_iMlLiNnNiCmMiDeMiBfLiDfCiBfLiDgIiBeC_xHqqkZx_
	m_dwCommand = 0;			// _xZkqqHx_iMlLiNnNiCmMiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
} // CFCControlFDATmpl::CFCControlFDATmpl.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCControlFDATmpl::~CFCControlFDATmpl
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
CFCControlFDATmpl<SUPER>::~CFCControlFDATmpl ()
{
} // CFCControlFDATmpl::~CFCControlFDATmpl.

/////////////////////////////////////////////////////////////////////////////
// CFCControlFDATmpl _xZkqqHx_iDiGiBfLiDfFiKnGjAjE_xHqqkZx_

//----- 06.11.08 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCControlFDATmpl<SUPER>::GetIsSingleSelect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jCfAjDmGjBeJjBpAiDiCiBfLiDgIiCmMjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jCfAjDmGjBeJjBpAiDiCiBfLiDgIiCmMiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.11.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL CFCControlFDATmpl<SUPER>::GetIsSingleSelect () const
{
	return m_bSingleSelect;
} // CFCControlFDATmpl<SUPER>::GetIsSingleSelect.
//----- 06.11.08 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCControlFDATmpl<SUPER>::SetSingleSelect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jCfAjDmGjBeJjBpAiDiCiBfLiDgIiCmMjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void CFCControlFDATmpl<SUPER>::SetSingleSelect (BOOL bSingle)
{
	m_bSingleSelect = bSingle;	// _xZkqqHx_jCfAjDmGjBeJjBpAiDiCiBfLiDgIiCkJiBeI_xHqqkZx_
} // CFCControlFDATmpl<SUPER>::SetSingleSelect.

//----- 07.01.20 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////----- 06.11.07 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
/////*************************************************************************
//// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCControlFDATmpl<SUPER>::ClearContents
//// *
//// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDgFiDjDiDgDiCpAiDeOiDiKiDeBiClHiCoJiBeC_xHqqkZx_
//// *
//// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
//// *************************************************************************/
////template<class SUPER>
////void CFCControlFDATmpl<SUPER>::ClearContents ()
////{
////	m_lgptMemo = CPoint(0, 0);	// _xZkqqHx_iDhNiDeFiDfIiNmAjFfHiBgJiLeMiJkPjHhAiBgKiBeC_xHqqkZx_
////	//----- _xZkqqHx_iDgDiBfLiDiLiCmMiPpDjBnEjFmPjAjE_xHqqkZx_ -----
////	m_lCurState = STATE_IDLE;	// FDA_xZkqqHx_iCmMiMlLiNnNiCmMiPpDjBnEiBeC_xHqqkZx_
////	m_ptMsc = CPoint(0, 0);	// _xZkqqHx_iMlLiNnNiCmMiDhNiDeFiDfIiNmAjFfHiBeC_xHqqkZx_
////	m_dwFlags = 0;				// _xZkqqHx_jDkPiOjOiDeMiBfLiCmMiPpDjBnEiBeC_xHqqkZx_
////	m_dwChar = 0;				// _xZkqqHx_iMlLiNnNiCmMiDeMiBfLiDfCiBfLiDgIiBeC_xHqqkZx_
////	m_dwCommand = 0;			// _xZkqqHx_iMlLiNnNiCmMiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
////	// Superclass_xZkqqHx_iBeC_xHqqkZx_
////	SUPER::ClearContents();
////} // CFCControlFDATmpl<SUPER>::ClearContents.
////----- 06.11.07 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//----- 07.01.20 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCControlFDATmpl<SUPER>::ClearContents
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDgFiDjDiDgDiCpAiDeOiDiKiDeBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void CFCControlFDATmpl<SUPER>::ClearContents ()
{
	m_lgptMemo = CPoint(0, 0);	// _xZkqqHx_iDhNiDeFiDfIiNmAjFfHiBgJiLeMiJkPjHhAiBgKiBeC_xHqqkZx_
	//----- _xZkqqHx_iDgDiBfLiDiLiCmMiPpDjBnEjFmPjAjE_xHqqkZx_ -----
	m_lCurState = STATE_IDLE;	// FDA_xZkqqHx_iCmMiMlLiNnNiCmMiPpDjBnEiBeC_xHqqkZx_
	m_ptMsc = CPoint(0, 0);	// _xZkqqHx_iMlLiNnNiCmMiDhNiDeFiDfIiNmAjFfHiBeC_xHqqkZx_
	m_dwFlags = 0;				// _xZkqqHx_jDkPiOjOiDeMiBfLiCmMiPpDjBnEiBeC_xHqqkZx_
	m_dwChar = 0;				// _xZkqqHx_iMlLiNnNiCmMiDeMiBfLiDfCiBfLiDgIiBeC_xHqqkZx_
	m_dwCommand = 0;			// _xZkqqHx_iMlLiNnNiCmMiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
	// Superclass_xZkqqHx_iBeC_xHqqkZx_
	SUPER::ClearContents();
} // CFCControlFDATmpl<SUPER>::ClearContents.
//----- 07.01.20 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCControlFDATmpl<SUPER>::SetMoveItemCallback
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeBiDeDiDgFiDiAiInKjDkOiDfCiBfLiDiLiDgPiDgCiDeOiKnGjAjEiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.05.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void CFCControlFDATmpl<SUPER>::SetMoveItemCallback (MoveItemCallback fncMoveItem, DWORD dwData)
{
	m_fncMoveItem = fncMoveItem;
	m_dwData = dwData;
} // CFCControlFDATmpl<SUPER>::SetMoveItemCallback.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCControlFDATmpl<SUPER>::MemoMscPoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDhNiDeFiDfIiImKjChFiCpAiLeMjIfOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void CFCControlFDATmpl<SUPER>::MemoMscPoint ()
{
	// _xZkqqHx_iDhNiDeFiDfIiNmAjFfHiBgJiLeMiJkPjHhAiBgKiBeC_xHqqkZx_
	m_lgptMemo = m_ptMsc;
} // CFCControlFDATmpl<SUPER>::MemoMscPoint.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCControlFDATmpl<SUPER>::CalcMemoToMscPower
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iLeMjIfOiClDiCoKiClNiImKjChFiCmGiBeBiMlLiNnNiCmMiDhNiDeFiDfIiImKjChFiCmMiLjHjHkDiCmMiCfBiPoGiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iLjHjHkDiCmMiCfBiPoGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
long CFCControlFDATmpl<SUPER>::CalcMemoToMscPower () const
{
	CSize sz = m_lgptMemo - m_ptMsc;
	return sz.cx * sz.cx + sz.cy * sz.cy;
} // CFCControlFDATmpl<SUPER>::CalcMemoToMscPower.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCControlFDATmpl<SUPER>::CanStartMoveItem
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiPpDjBnEiCmFiBeBiDeBiDeDiDgFiDiAiCpAiInKjDkOiCmFiCkLiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iInKjDkOiCmFiCkLiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.05.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
BOOL CFCControlFDATmpl<SUPER>::CanStartMoveItem () const
{
	// _xZkqqHx_iDfCiBfLiDiLiDgPiDgCiDeOiCkKiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE_xZkqqHx_iBeC_xHqqkZx_
	if (m_fncMoveItem == NULL) return FALSE;
	// _xZkqqHx_iIoKiCmCiCmFiCoAiDeBiDeDiDgFiDiAiCkKjBeJjBpAiClDiCoKiCmEiCkCiCoJiCkJiBeI_xHqqkZx_
	long lIndex;
	for (lIndex = GetItemCount() - 1; 0 <= lIndex; lIndex--)
		if (IsSelectionMark(lIndex)) return TRUE;
	return FALSE;
} // CFCControlFDATmpl::CanStartMoveItem.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCControlFDATmpl<SUPER>::OnMsEvent
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhNiDeFiDfIiDiBiDgCiDfKiBfLiDfHiCmJiJjOiClGiCmEiBeBiPpDjBnEjBeKiInKiCpAjDkOiCkJiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwMessage	:_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			ptMsc	:_xZkqqHx_iDhNiDeFiDfIiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			nFlags	:_xZkqqHx_iDeMiBfLiCpAjClCiCnHiCoJiDhEiDiJiDePiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCkKjGlDiCkCiPoKiNiHiCoAiPpDjBnEiCmNjBeKiInKiClHiCoJiClBiCmGiCkKiCkAiCoJiCmMiCmFiBeBiClLiCoKiCoAiPiIjHjNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void CFCControlFDATmpl<SUPER>::OnMsEvent (DWORD dwMessage, const CPoint& ptMsc, UINT nFlags)
{
	// _xZkqqHx_iDhNiDeFiDfIiNmAjFfHiCkKjDkPiClGiBjFiDhNiDeFiDfIiInKjDkOiCmNjGlDiOiLiBeC_xHqqkZx_WM_LBUTTONDOWN_xZkqqHx_iCmMiMoDiCmJiDhNiDeFiDfIiCpA_xHqqkZx_
	// _xZkqqHx_iInKjDkOiClFiCmIiCkNiCmEiCoAiBeB_xHqqkZx_CanDelete_xZkqqHx_iBeB_xHqqkZx_CanProperties_xZkqqHx_jDjJiCkKjFmPiJlLiClHiCoJiCmG_xHqqkZx_WM_MOUSEMOVE
	// _xZkqqHx_iCkKjEkNjAlGiClHiCoJiPoKiNiHiCkKiCkAiCoJiBeC_xHqqkZx_
	if (dwMessage == WM_MOUSEMOVE && m_ptMsc == ptMsc) return;
	// _xZkqqHx_iDhEiDiJiDePjFmPjAjEiLeMjIfOiBeC_xHqqkZx_
	m_dwFlags = nFlags;
	// _xZkqqHx_iDhNiDeFiDfIiImKjChFiCmMiNmAjFfHiCpAjFmPiKlHiBeC_xHqqkZx_
	m_ptMsc = ptMsc;
	for (;;)
	{
		// _xZkqqHx_iPpDjBnEiCmMjBeKiInKiCpAiMjPiNpFiBeC_xHqqkZx_
		long lNewState = TransFDA(m_lCurState, dwMessage);
		// _xZkqqHx_jBeKiInKiClFiCmIiCkCiPoKiNiHiCmNiPeJjHlJiBeC_xHqqkZx_
		if (lNewState == STATE_NONE) break;
		// _xZkqqHx_jBeKiInKiMoDiCmMiPpDjBnEiCpAjAnNjCoIiBeC_xHqqkZx_
		m_lCurState = lNewState;
		// _xZkqqHx_iPpDjBnEiCmJiJjOiClGiClNiPiIjHjNiBeC_xHqqkZx_
		StateFDA(m_lCurState);
		// _xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCmJjGlDiClFiCpAjAnNjCoIiBeC_xHqqkZx_
		dwMessage = WM_NULL;
	}
} // CFCControlFDATmpl<SUPER>::OnMsEvent.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCControlFDATmpl<SUPER>::OnKyEvent
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeMiBfLiDiBiDgCiDfKiBfLiDfHiCmJiJjOiClGiCmEiBeBiPpDjBnEjBeKiInKiCpAjDkOiCkJiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwMessage	:_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			nChar	:_xZkqqHx_iJjPiClDiCoKiClNiDeMiBfLiCpAiOhHjCoIiBeC_xHqqkZx_
 *			nFlags	:_xZkqqHx_jDkPiOjOiCmJiJjPiClDiCoKiClNiDeMiBfLiCmMiPpDjBnEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCkKjGlDiCkCiPoKiNiHiCoAiPpDjBnEiCmNjBeKiInKiClHiCoJiClBiCmGiCkKiCkAiCoJiCmMiCmFiBeBiClLiCoKiCoAiPiIjHjNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void CFCControlFDATmpl<SUPER>::OnKyEvent (DWORD dwMessage, UINT nChar, UINT nFlags)
{
	// _xZkqqHx_iMlLiNnNiCmMiDeMiBfLiDfCiBfLiDgIiBeC_xHqqkZx_
	m_dwChar = nChar;
	// _xZkqqHx_iDhEiDiJiDePjFmPjAjEiLeMjIfOiBeC_xHqqkZx_
	m_dwFlags = nFlags;
	for (;;)
	{
		// _xZkqqHx_iPpDjBnEiCmMjBeKiInKiCpAiMjPiNpFiBeC_xHqqkZx_
		long lNewState = TransFDA(m_lCurState, dwMessage);
		// _xZkqqHx_jBeKiInKiClFiCmIiCkCiPoKiNiHiCmNiPeJjHlJiBeC_xHqqkZx_
		if (lNewState == STATE_NONE) break;
		// _xZkqqHx_jBeKiInKiMoDiCmMiPpDjBnEiCpAjAnNjCoIiBeC_xHqqkZx_
		m_lCurState = lNewState;
		// _xZkqqHx_iPpDjBnEiCmJiJjOiClGiClNiPiIjHjNiBeC_xHqqkZx_
		StateFDA(m_lCurState);
		// _xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCmJjGlDiClFiCpAjAnNjCoIiBeC_xHqqkZx_
		dwMessage = WM_NULL;
	}
} // CFCControlFDATmpl<SUPER>::OnKyEvent.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCControlFDATmpl<SUPER>::OnCmEvent
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiCmJiJjOiClGiCmEiBeBiPpDjBnEjBeKiInKiCpAjDkOiCkJiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwCommand	:_xZkqqHx_iDfCiDhNiDjDiDgIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCkKjGlDiCkCiPoKiNiHiCoAiPpDjBnEiCmNjBeKiInKiClHiCoJiClBiCmGiCkKiCkAiCoJiCmMiCmFiBeBiClLiCoKiCoAiPiIjHjNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void CFCControlFDATmpl<SUPER>::OnCmEvent (DWORD dwCommand)
{
	m_dwCommand = dwCommand;
	DWORD dwMessage = WM_COMMAND;
	for (;;)
	{
		// _xZkqqHx_iPpDjBnEiCmMjBeKiInKiCpAiMjPiNpFiBeC_xHqqkZx_
		long lNewState = TransFDA(m_lCurState, dwMessage, dwCommand);
		// _xZkqqHx_jBeKiInKiClFiCmIiCkCiPoKiNiHiCmNiPeJjHlJiBeC_xHqqkZx_
		if (lNewState == STATE_NONE) break;
		// _xZkqqHx_jBeKiInKiMoDiCmMiPpDjBnEiCpAjAnNjCoIiBeC_xHqqkZx_
		m_lCurState = lNewState;
		// _xZkqqHx_iPpDjBnEiCmJiJjOiClGiClNiPiIjHjNiBeC_xHqqkZx_
		StateFDA(m_lCurState);
		// _xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCmJjGlDiClFiCpAjAnNjCoIiBeC_xHqqkZx_
		dwMessage = WM_NULL;
	}
} // CFCControlFDATmpl<SUPER>::OnCmEvent.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCControlFDATmpl::TimerEvent
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfOiDeDiDhNiBfLiCkKjAnNjCoIiClDiCoKiClNiPoKiNiHiCmNiBeBjCoIiKpKjDeJiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwIDEvent	:_xZkqqHx_iDfOiDeDiDhNiBfLiDeDiDhIiDjDiDgH_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void CFCControlFDATmpl<SUPER>::TimerEvent (DWORD dwIDEvent)
{
	TRACE(_T("CFCControlFDATmpl::TimerEvent\r\n"));
} // CFCControlFDATmpl::TimerEvent.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCControlFDATmpl::TransFDA
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMiIjCoIjAkLjHeMiMmAiDeJiBfLiDgHiDhNiDgHiDjDiCmMjBeKiInKiCpAjFnEiClHiBeC_xHqqkZx_ToolBaseFDA.mdrw_xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	iState	:_xZkqqHx_iMlLiNnNiCmMiPpDjBnEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwMessage	:_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwCommand	:_xZkqqHx_iDfCiDhNiDjDiDgIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBeKiInKiMoDiCmMiPpDjBnEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
long CFCControlFDATmpl<SUPER>::TransFDA (long lState, DWORD dwMessage, DWORD dwCommand)
{
	// _xZkqqHx_iInKiNhDjAoGiPpDjBnEiBeC_xHqqkZx_
	long lNextState = STATE_NONE;	// _xZkqqHx_iPpDjBnEjGlDiClFiBeC_xHqqkZx_
//----- 01.03.25 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDeBiDeDiDgFiDiAiCkKjGlDiCkCiPoKiNiHiCmNiDfPiDiBiBeC_xHqqkZx_
//	if (GetItemCount() == 0) return lNextState;
//----- 01.03.25 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	// FDA_xZkqqHx_iCmMiMlLiNnNiCmMiPpDjBnEiBeC_xHqqkZx_
	switch (lState)
	{
	case STATE_IDLE:				// _xZkqqHx_jBnCiClPiBeC_xHqqkZx_
		switch (dwMessage)
		{
		case WM_LBUTTONDOWN:	// _xZkqqHx_iNlGiDhLiDfOiDjDiDfPiDeFiDjDiBeC_xHqqkZx_
			if (m_bSingleSelect)
			//----- _xZkqqHx_jCfAjDmGjBeJjBpAiDiCiBfLiDgI_xHqqkZx_ -----
			{
				lNextState = STATE_SELECT_ITEM;				// _xZkqqHx_jBeJjBpAiBeC_xHqqkZx_
			} else
			if (m_dwFlags & MK_SHIFT)
			{
				lNextState = STATE_RANGE_SELECT_ITEM;		// _xZkqqHx_jEmNiImNjBeJjBpAiBeC_xHqqkZx_
			} else
			if (m_dwFlags & MK_CONTROL)
			{
				if (IsOnSelectedItem(m_ptMsc))
					lNextState = STATE_REMOVE_SELECT_ITEM;	// _xZkqqHx_jBeJjBpAiJpAiPjMiBeC_xHqqkZx_
				else
					lNextState = STATE_ADD_SELECT_ITEM;		// _xZkqqHx_jCmHiJmBjBeJjBpAiBeC_xHqqkZx_
			} else
			{
				if (IsOnSelectedItem(m_ptMsc))
					lNextState = STATE_WAIT_EVENT_2;		// _xZkqqHx_iDeDiDhIiDjDiDgHjBnCiClP_xHqqkZx__2_xZkqqHx_iBeC_xHqqkZx_
				else
					lNextState = STATE_SELECT_ITEM;			// _xZkqqHx_jBeJjBpAiBeC_xHqqkZx_
			}
			break;

		case WM_RBUTTONDOWN:	// _xZkqqHx_iJeFiDhLiDfOiDjDiDfPiDeFiDjDiBeC_xHqqkZx_
			if (!(m_dwFlags & MK_SHIFT) && !(m_dwFlags & MK_CONTROL) && !IsOnSelectedItem(m_ptMsc))
				lNextState = STATE_RBTN_SELECT_ITEM;		// _xZkqqHx_iJeFiDhLiDfOiDjDjHhAjBeJjBpAiBeC_xHqqkZx_
			break;

		case WM_LBUTTONDBLCLK:		// _xZkqqHx_iNlGiDhLiDfOiDjDiDfPiDhFiDiLiDeOiDiKiDgCiDeOiBeC_xHqqkZx_
			lNextState = STATE_LBTN_DBL_CLICK;				// _xZkqqHx_iNlGiDhLiDfOiDjDiDfPiDhFiDiLiDeOiDiKiDgCiDeOiBeC_xHqqkZx_
			break;

		case WM_CONTEXTMENU:		// _xZkqqHx_iDfCiDjDiDgFiDeMiDfIiDgHiDiBiDgKiDiFiBfLiBeC_xHqqkZx_
			lNextState = STATE_CONTEXT_MENU;				// _xZkqqHx_iDiBiDgKiDiFiBfLjFfMiOkGiBeC_xHqqkZx_
			break;

		case WM_MOUSEMOVE:		// _xZkqqHx_iDhNiDeFiDfIiInKjDkOiBeC_xHqqkZx_
			lNextState = STATE_IDLE;						// _xZkqqHx_jBnCiClPiBeC_xHqqkZx_
			break;
		}
		break;

	case STATE_RANGE_SELECT_ITEM:	// _xZkqqHx_jEmNiImNjBeJjBpAiBeC_xHqqkZx_
		lNextState = STATE_WAIT_EVENT;						// _xZkqqHx_iDeDiDhIiDjDiDgHjBnCiClPiBeC_xHqqkZx_
		break;

	case STATE_REMOVE_SELECT_ITEM:	// _xZkqqHx_jBeJjBpAiJpAiPjMiBeC_xHqqkZx_
		lNextState = STATE_WAIT_EVENT;						// _xZkqqHx_iDeDiDhIiDjDiDgHjBnCiClPiBeC_xHqqkZx_
		break;

	case STATE_ADD_SELECT_ITEM:		// _xZkqqHx_jCmHiJmBjBeJjBpAiBeC_xHqqkZx_
		lNextState = STATE_WAIT_EVENT;						// _xZkqqHx_iDeDiDhIiDjDiDgHjBnCiClPiBeC_xHqqkZx_
		break;

	case STATE_SELECT_ITEM:			// _xZkqqHx_jBeJjBpAiBeC_xHqqkZx_
		lNextState = STATE_WAIT_EVENT;						// _xZkqqHx_iDeDiDhIiDjDiDgHjBnCiClPiBeC_xHqqkZx_
		break;

	case STATE_SELECT_ITEM_2:		// _xZkqqHx_jBeJjBpA_xHqqkZx__2_xZkqqHx_iBeC_xHqqkZx_
		lNextState = STATE_IDLE;							// _xZkqqHx_jBnCiClPiBeC_xHqqkZx_
		break;

	case STATE_WAIT_EVENT:			// _xZkqqHx_iDeDiDhIiDjDiDgHjBnCiClPiBeC_xHqqkZx_
		switch (dwMessage)
		{
		case WM_MOUSEMOVE:		// _xZkqqHx_iDhNiDeFiDfIiInKjDkOiBeC_xHqqkZx_
			if (4 < CalcMemoToMscPower() && CanStartMoveItem())
				lNextState = STATE_BEGIN_MOVE_ITEM;			// _xZkqqHx_iInKjDkOiPiIjHjNiKeKiOgOiBeC_xHqqkZx_
			break;
		case WM_LBUTTONUP:		// _xZkqqHx_iNlGiDhLiDfOiDjDiDeBiDgCiDhGiBeC_xHqqkZx_
			lNextState = STATE_IDLE;						// _xZkqqHx_jBnCiClPiBeC_xHqqkZx_
			break;
		}
		break;

	case STATE_WAIT_EVENT_2:			// _xZkqqHx_iDeDiDhIiDjDiDgHjBnCiClP_xHqqkZx__2_xZkqqHx_iBeC_xHqqkZx_
		switch (dwMessage)
		{
		case WM_MOUSEMOVE:		// _xZkqqHx_iDhNiDeFiDfIiInKjDkOiBeC_xHqqkZx_
			if (4 < CalcMemoToMscPower() && CanStartMoveItem())
				lNextState = STATE_BEGIN_MOVE_ITEM;			// _xZkqqHx_iInKjDkOiPiIjHjNiKeKiOgOiBeC_xHqqkZx_
			break;
		case WM_LBUTTONUP:		// _xZkqqHx_iNlGiDhLiDfOiDjDiDeBiDgCiDhGiBeC_xHqqkZx_
			lNextState = STATE_SELECT_ITEM_2;				// _xZkqqHx_jBeJjBpAiBeC_xHqqkZx_
			break;
		}
		break;

	case STATE_BEGIN_MOVE_ITEM:	// _xZkqqHx_iInKjDkOiPiIjHjNiKeKiOgOiBeC_xHqqkZx_
		lNextState = STATE_MOVING_ITEM;						// _xZkqqHx_iInKjDkOiPiIjHjNiBeC_xHqqkZx_
		break;

	case STATE_MOVING_ITEM:	// _xZkqqHx_iInKjDkOiPiIjHjNiBeC_xHqqkZx_
		switch (dwMessage)
		{
		case WM_MOUSEMOVE:		// _xZkqqHx_iDhNiDeFiDfIiInKjDkOiBeC_xHqqkZx_
			lNextState = STATE_MOVING_ITEM;					// _xZkqqHx_iInKjDkOiPiIjHjNiBeC_xHqqkZx_
			break;

		case WM_LBUTTONUP:		// _xZkqqHx_iNlGiDhLiDfOiDjDiDeBiDgCiDhGiBeC_xHqqkZx_
			lNextState = STATE_END_MOVE_ITEM;				// _xZkqqHx_iInKjDkOiPiIjHjNiPeJjHlJiBeC_xHqqkZx_
			break;

		case WM_RBUTTONUP:		// _xZkqqHx_iJeFiDhLiDfOiDjDiDeBiDgCiDhGiBeC_xHqqkZx_
			lNextState = STATE_CANCEL_MOVE_ITEM;			// _xZkqqHx_iInKjDkOiPiIjHjNjCiGiOhOiBeC_xHqqkZx_
			break;
		}
		break;

	case STATE_END_MOVE_ITEM:	// _xZkqqHx_iInKjDkOiPiIjHjNiPeJjHlJiBeC_xHqqkZx_
		lNextState = STATE_IDLE;							// _xZkqqHx_jBnCiClPiBeC_xHqqkZx_
		break;

	case STATE_CANCEL_MOVE_ITEM:	// _xZkqqHx_iInKjDkOiPiIjHjNjCiGiOhOiBeC_xHqqkZx_
		lNextState = STATE_IDLE;							// _xZkqqHx_jBnCiClPiBeC_xHqqkZx_
		break;

	case STATE_RBTN_SELECT_ITEM:	// _xZkqqHx_iJeFiDhLiDfOiDjDjHhAjBeJjBpAiBeC_xHqqkZx_
		lNextState = STATE_IDLE;							// _xZkqqHx_jBnCiClPiBeC_xHqqkZx_
		break;

	case STATE_CONTEXT_MENU:		// _xZkqqHx_iDiBiDgKiDiFiBfLjFfMiOkGiBeC_xHqqkZx_
		lNextState = STATE_IDLE;							// _xZkqqHx_jBnCiClPiBeC_xHqqkZx_
		break;

	case STATE_LBTN_DBL_CLICK:		// _xZkqqHx_iNlGiDhLiDfOiDjDiDfPiDhFiDiLiDeOiDiKiDgCiDeOiBeC_xHqqkZx_
		lNextState = STATE_IDLE;							// _xZkqqHx_jBnCiClPiBeC_xHqqkZx_
		break;
	}
	return lNextState;
} // CFCControlFDATmpl<SUPER>::TransFDA.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCControlFDATmpl<SUPER>::StateFDA
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPpDjBnEiCmJiJjOiClGiClNiPiIjHjNiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lState	:_xZkqqHx_iMlLiNnNiCmMiPpDjBnEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void CFCControlFDATmpl<SUPER>::StateFDA (long lState)
{
	// FDA_xZkqqHx_iCmMiOjPiCmMiPpDjBnEiBeC_xHqqkZx_
	switch (lState)
	{
	case STATE_NONE:					// _xZkqqHx_iPpDjBnEjGlDiClFiBeC_xHqqkZx_
		break;
	case STATE_IDLE:					// _xZkqqHx_jBnCiClPiBeC_xHqqkZx_
		StateIdle();
		break;
	case STATE_RANGE_SELECT_ITEM:		// _xZkqqHx_jEmNiImNjBeJjBpAiBeC_xHqqkZx_
		StateRangeSelectItem();
		break;
	case STATE_REMOVE_SELECT_ITEM:		// _xZkqqHx_jBeJjBpAiJpAiPjMiBeC_xHqqkZx_
		StateRemoveSelectItem();
		break;
	case STATE_ADD_SELECT_ITEM:			// _xZkqqHx_jCmHiJmBjBeJjBpAiBeC_xHqqkZx_
		StateAddSelectItem();
		break;
	case STATE_SELECT_ITEM:				// _xZkqqHx_jBeJjBpAiBeC_xHqqkZx_
		StateSelectItem();
		break;
	case STATE_SELECT_ITEM_2:			// _xZkqqHx_jBeJjBpA_xHqqkZx__2_xZkqqHx_iBeC_xHqqkZx_
		StateSelectItem2();
		break;
	case STATE_WAIT_EVENT:				// _xZkqqHx_iDeDiDhIiDjDiDgHjBnCiClPiBeC_xHqqkZx_
		StateWaitEvent();
		break;
	case STATE_WAIT_EVENT_2:			// _xZkqqHx_iDeDiDhIiDjDiDgHjBnCiClP_xHqqkZx__2_xZkqqHx_iBeC_xHqqkZx_
		StateWaitEvent2();
		break;
	case STATE_BEGIN_MOVE_ITEM:			// _xZkqqHx_iInKjDkOiPiIjHjNiKeKiOgOiBeC_xHqqkZx_
		StateBeginMoveItem();
		break;
	case STATE_MOVING_ITEM:				// _xZkqqHx_iInKjDkOiPiIjHjNiBeC_xHqqkZx_
		StateMovingItem();
		break;
	case STATE_END_MOVE_ITEM:			// _xZkqqHx_iInKjDkOiPiIjHjNiPeJjHlJiBeC_xHqqkZx_
		StateEndMoveItem();
		break;
	case STATE_CANCEL_MOVE_ITEM:		// _xZkqqHx_iInKjDkOiPiIjHjNjCiGiOhOiBeC_xHqqkZx_
		StateCancelMoveItem();
		break;
	case STATE_RBTN_SELECT_ITEM:		// _xZkqqHx_iJeFiDhLiDfOiDjDjHhAjBeJjBpAiBeC_xHqqkZx_
		StateRbtnSelectItem();
		break;
	case STATE_CONTEXT_MENU:			// _xZkqqHx_iDiBiDgKiDiFiBfLjFfMiOkGiBeC_xHqqkZx_
		StateContextMenu();
		break;
	case STATE_LBTN_DBL_CLICK:			// _xZkqqHx_iNlGiDhLiDfOiDjDiDfPiDhFiDiLiDeOiDiKiDgCiDeOiBeC_xHqqkZx_
		StateLbtnDblClick();
		break;
	}
} // CFCControlFDATmpl<SUPER>::StateFDA.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCControlFDATmpl<SUPER>::StateIdle
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFjBnCiClPiBhGiPiIjHjNiCpAiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void CFCControlFDATmpl<SUPER>::StateIdle ()
{
	TRACE(_T("CFCControlFDATmpl<SUPER>::StateIdle\r\n"));
} // CFCControlFDATmpl<SUPER>::StateIdle.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCControlFDATmpl<SUPER>::StateRangeSelectItem
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFjEmNiImNjBeJjBpAiBhGiPiIjHjNiCpAiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void CFCControlFDATmpl<SUPER>::StateRangeSelectItem ()
{
	TRACE(_T("CFCControlFDATmpl<SUPER>::StateRangeSelectItem\r\n"));
	// _xZkqqHx_iDhNiDeFiDfIiImKjChFiCmMiDeBiDeDiDgFiDiAiCpAiOoGjDlOiBeC_xHqqkZx_
	long lMscIndex = PointToIndex(m_ptMsc);
	if (lMscIndex == -1) return;
	long lIndexB = GetIndexB();
	if (lIndexB == -1) lIndexB = 0;
	SetSelect(lMscIndex, lIndexB, FALSE, TRUE);
} // CFCControlFDATmpl<SUPER>::StateRangeSelectItem.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCControlFDATmpl<SUPER>::StateRemoveSelectItem
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFjBeJjBpAiJpAiPjMiBhGiPiIjHjNiCpAiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void CFCControlFDATmpl<SUPER>::StateRemoveSelectItem ()
{
	TRACE(_T("CFCControlFDATmpl<SUPER>::StateRemoveSelectItem\r\n"));
	// _xZkqqHx_iDhNiDeFiDfIiImKjChFiCmMiDeBiDeDiDgFiDiAiCpAiOoGjDlOiBeC_xHqqkZx_
	long lMscIndex = PointToIndex(m_ptMsc);
// 01.03.18 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	if (lMscIndex == -1) return;
	// _xZkqqHx_iDeBiDeDiDgFiDiAiCmMjBeJjBpAiCpAiJpAiPjMiBeC_xHqqkZx_
	SetSelectionMark(lMscIndex, FALSE);
	// _xZkqqHx_iMlLiNnNiCmMjBeJjBpAjCiGiDeBiDeDiDgFiDiAiCpAjAnNjCoIiBeC_xHqqkZx_
	if (lMscIndex == GetIndexA())
	{
		// _xZkqqHx_iNmFiMoDiCmMjBeJjBpAiDeBiDeDiDgFiDiAiCpAiMlLiNnNiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCmJjAnNjCoIiBeC_xHqqkZx_
		long lIndex;
		for (lIndex = GetItemCount() - 1; 0 <= lIndex; lIndex--)
			if (IsSelectionMark(lIndex)) break;
		SetIndexAB(lIndex, lIndex, FALSE, TRUE);
	}
	// _xZkqqHx_iNmEjFgAiJoGiBeC_xHqqkZx_
	SendRgnRedraw();
} // CFCControlFDATmpl<SUPER>::StateRemoveSelectItem.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCControlFDATmpl<SUPER>::StateAddSelectItem
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFjCmHiJmBjBeJjBpAiBhGiPiIjHjNiCpAiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void CFCControlFDATmpl<SUPER>::StateAddSelectItem ()
{
	TRACE(_T("CFCControlFDATmpl<SUPER>::StateAddSelectItem\r\n"));
	// _xZkqqHx_iDhNiDeFiDfIiImKjChFiCmMiDeBiDeDiDgFiDiAiCpAiOoGjDlOiBeC_xHqqkZx_
	long lMscIndex = PointToIndex(m_ptMsc);
// 01.03.18 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	if (lMscIndex == -1) return;
	// _xZkqqHx_iDeBiDeDiDgFiDiAiCmMjBeJjBpAiCpAjCmHiJmBiBeC_xHqqkZx_
	SetSelectionMark(lMscIndex);
	// _xZkqqHx_iMlLiNnNiCmMjBeJjBpAjCiGiDeBiDeDiDgFiDiAiCpAjAnNjCoIiBeC_xHqqkZx_
	SetIndexAB(lMscIndex, lMscIndex, FALSE, TRUE);
	// _xZkqqHx_iNmEjFgAiJoGiBeC_xHqqkZx_
	SendRgnRedraw();
} // CFCControlFDATmpl<SUPER>::StateAddSelectItem.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCControlFDATmpl<SUPER>::StateSelectItem
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFjBeJjBpAiBhGiPiIjHjNiCpAiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void CFCControlFDATmpl<SUPER>::StateSelectItem ()
{
	TRACE(_T("CFCControlFDATmpl<SUPER>::StateSelectItem\r\n"));
	// _xZkqqHx_iMlLiNnNiCmMjBeJjBpAjCiGiDeBiDeDiDgFiDiAiCpAjAnNjCoIiBeC_xHqqkZx_
	long lIndex = PointToIndex(m_ptMsc);
// 06.11.15 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	if (lIndex == -1) return;
	// _xZkqqHx_jBfDiCmEiCmMiDeBiDeDiDgFiDiAiCkJiCoHjBeJjBpAiDhNiBfLiDeOiCpAiPmBiLiOiBeC_xHqqkZx_
	SetAllSelectionMark(FALSE);
	// _xZkqqHx_jBeJjBpAiDeDiDjDiDgGiDgCiDeOiDfIiCpAjAnNjCoIiBeC_xHqqkZx_
	SetIndexAB(lIndex, lIndex, FALSE, TRUE);
	// _xZkqqHx_jAfGiClFiCkCjBeJjBpAiDhNiBfLiDeOiCpAjAnNjCoIiBeC_xHqqkZx_
// 06.11.15 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	if (lIndex != -1)
		SetSelectionMark(GetIndexA());
	// _xZkqqHx_jFmPiNfIiClDiCoKiClNiDeBiDeDiDgFiDiAiCpAiNmEjFgAiJoGiBeC_xHqqkZx_
	SendRgnRedraw();
} // CFCControlFDATmpl<SUPER>::StateSelectItem.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCControlFDATmpl<SUPER>::StateSelectItem2
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFjBeJjBpA_xHqqkZx__2_xZkqqHx_iBhGiPiIjHjNiCpAiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void CFCControlFDATmpl<SUPER>::StateSelectItem2 ()
{
	StateSelectItem();
} // CFCControlFDATmpl<SUPER>::StateSelectItem2.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCControlFDATmpl<SUPER>::StateWaitEvent
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiDeDiDhIiDjDiDgHjBnCiClPiBhGiPiIjHjNiCpAiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void CFCControlFDATmpl<SUPER>::StateWaitEvent ()
{
	TRACE(_T("CFCControlFDATmpl<SUPER>::StateWaitEvent\r\n"));
	// _xZkqqHx_iDhNiDeFiDfIiNmAjFfHiCpAiLeMiJkPiBeCiInKjDkOjHmKiMhGiOfKjHhAiBeC_xHqqkZx_
	MemoMscPoint();
} // CFCControlFDATmpl<SUPER>::StateWaitEvent.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCControlFDATmpl<SUPER>::StateWaitEvent2
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiDeDiDhIiDjDiDgHjBnCiClP_xHqqkZx__2_xZkqqHx_iBhGiPiIjHjNiCpAiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void CFCControlFDATmpl<SUPER>::StateWaitEvent2 ()
{
	TRACE(_T("CFCControlFDATmpl<SUPER>::StateWaitEvent2\r\n"));
	StateWaitEvent();
} // CFCControlFDATmpl<SUPER>::StateWaitEvent2.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCControlFDATmpl<SUPER>::StateBeginMoveItem
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiInKjDkOiPiIjHjNiKeKiOgOiBhGiPiIjHjNiCpAiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.05.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void CFCControlFDATmpl<SUPER>::StateBeginMoveItem ()
{
	TRACE(_T("CFCControlFDATmpl<SUPER>::StateBeginMoveItem\r\n"));
	// _xZkqqHx_iClBiCmM_xHqqkZx_Window_xZkqqHx_iCmJiDeDiDhIiDjDiDgHiBeC_xHqqkZx_
	::FFSetCapture(m_hWnd);
	// _xZkqqHx_iDfCiBfLiDiLiDgPiDgCiDeOiOmAiNhDiBeC_xHqqkZx_
	(*m_fncMoveItem)(m_dwData, this, m_lCurState, m_ptMsc, m_dwFlags);
} // CFCControlFDATmpl<SUPER>::StateBeginMoveItem.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCControlFDATmpl<SUPER>::StateMovingItem
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiInKjDkOiPiIjHjNiBhGiPiIjHjNiCpAiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.05.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void CFCControlFDATmpl<SUPER>::StateMovingItem ()
{
	TRACE(_T("CFCControlFDATmpl<SUPER>::StateMovingItem\r\n"));
	// _xZkqqHx_iDfCiBfLiDiLiDgPiDgCiDeOiOmAiNhDiBeC_xHqqkZx_
	(*m_fncMoveItem)(m_dwData, this, m_lCurState, m_ptMsc, m_dwFlags);
} // CFCControlFDATmpl<SUPER>::StateMovingItem.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCControlFDATmpl<SUPER>::StateEndMoveItem
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiInKjDkOiPiIjHjNiPeJjHlJiBhGiPiIjHjNiCpAiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.05.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void CFCControlFDATmpl<SUPER>::StateEndMoveItem ()
{
	TRACE(_T("CFCControlFDATmpl<SUPER>::StateEndMoveItem\r\n"));
	// _xZkqqHx_iDhNiDeFiDfIiCmMjFnPiKgMiCpAiJpAiPjMiClFiCnMiClHiBeCiDhAiDfIiCmJiCoGiCmBiCmEiCmN_xHqqkZx_ FFSetCapture _xZkqqHx_iCpA_xHqqkZx_
	// _xZkqqHx_iMgPjHfCiClFiCmIiCkCiPoKiNiHiCoAiCkAiCoJiClNiCnPiBeBiDgAiDeGiDgCiDeOiClHiCoJiBeC_xHqqkZx_
	if (::FFGetCapture() == m_hWnd)
		::FFReleaseCapture();
	// _xZkqqHx_iDfCiBfLiDiLiDgPiDgCiDeOiOmAiNhDiBeC_xHqqkZx_
	(*m_fncMoveItem)(m_dwData, this, m_lCurState, m_ptMsc, m_dwFlags);
} // CFCControlFDATmpl<SUPER>::StateEndMoveItem.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCControlFDATmpl<SUPER>::StateCancelMoveItem
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiInKjDkOiPiIjHjNiPeJjHlJiBhGiPiIjHjNiCpAiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.05.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void CFCControlFDATmpl<SUPER>::StateCancelMoveItem ()
{
	TRACE(_T("CFCControlFDATmpl<SUPER>::StateCancelMoveItem\r\n"));
	// _xZkqqHx_iDhNiDeFiDfIiCmMjFnPiKgMiCpAiJpAiPjMiClFiCnMiClHiBeCiDhAiDfIiCmJiCoGiCmBiCmEiCmN_xHqqkZx_ FFSetCapture _xZkqqHx_iCpA_xHqqkZx_
	// _xZkqqHx_iMgPjHfCiClFiCmIiCkCiPoKiNiHiCoAiCkAiCoJiClNiCnPiBeBiDgAiDeGiDgCiDeOiClHiCoJiBeC_xHqqkZx_
	if (::FFGetCapture() == m_hWnd)
		::FFReleaseCapture();
	// _xZkqqHx_iDfCiBfLiDiLiDgPiDgCiDeOiOmAiNhDiBeC_xHqqkZx_
	(*m_fncMoveItem)(m_dwData, this, m_lCurState, m_ptMsc, m_dwFlags);
} // CFCControlFDATmpl<SUPER>::StateCancelMoveItem.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCControlFDATmpl<SUPER>::StateRbtnSelectItem
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiJeFiDhLiDfOiDjDjHhAjBeJjBpAiBhGiPiIjHjNiCpAiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void CFCControlFDATmpl<SUPER>::StateRbtnSelectItem ()
{
	TRACE(_T("CFCControlFDATmpl<SUPER>::StateRbtnSelectItem\r\n"));
	StateSelectItem();
} // CFCControlFDATmpl<SUPER>::StateRbtnSelectItem.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCControlFDATmpl<SUPER>::StateContextMenu
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiDiBiDgKiDiFiBfLjFfMiOkGiBhGiPiIjHjNiCpAiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void CFCControlFDATmpl<SUPER>::StateContextMenu ()
{
	TRACE(_T("CFCControlFDATmpl<SUPER>::StateContextMenu\r\n"));
	GetParent()->PostMessage(WM_CONTEXTMENU, WPARAM(GetSafeHwnd()),
							MAKELONG(m_ptMsc.x, m_ptMsc.y));
} // CFCControlFDATmpl<SUPER>::StateContextMenu.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCControlFDATmpl<SUPER>::StateLbtnDblClick
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiNlGiDhLiDfOiDjDiDfPiDhFiDiLiDeOiDiKiDgCiDeOiBhGiPiIjHjNiCpAiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER>
void CFCControlFDATmpl<SUPER>::StateLbtnDblClick ()
{
	TRACE(_T("CFCControlFDATmpl<SUPER>::StateLbtnDblClick\r\n"));
	// _xZkqqHx_iDfPiDhFiDiLiDeOiDiKiDgCiDeOiCpAiDhMiDfIiDgHiBeC_xHqqkZx_
	PostLBtnDblClkMessage();
} // CFCControlFDATmpl<SUPER>::StateLbtnDblClick.

#endif//__ControlFDATmpl_h
