#include "stdafx.h"
#include "DynamicDraw.h"	// For FFGetApp.
#include "DynamicDrawView.h"// For g_pView.
#include "RegData.h"		// For GetLocalAppName().etc.
#include "UtilGraph.h"		// For FCAutoDC.
#include "UtilMisc.h"		// For FFSetCapture.etc.
#include "FrameWnd.h"		// For FFGetMainWnd().
#include "CtlBrPane.h"		// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


IMPLEMENT_DYNAMIC(CFCCtlBrPane, CControlBar)

BEGIN_MESSAGE_MAP(CFCCtlBrPane, BASE_CLASS)
	//{{AFX_MSG_MAP(CFCCtlBrPane)
	ON_WM_MOUSEMOVE()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_SIZE()
	ON_WM_CREATE()
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
	// Global help commands
END_MESSAGE_MAP()

const COLORREF FD_PANEBAR_COLOR = FD_COLREF_DARK_GRAY;

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrPane::CFCCtlBrPane
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfO_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.10.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCCtlBrPane::CFCCtlBrPane ()
{
	// _xZkqqHx_iDeFiDeCiDjDiDgIiDeFjFjNiCmMiDgGiDhEiDeIiDiLiDgHjCgMiBeCjGhLjDjGiCmMjCgMiCmNiDiMiDfHiDfIiDgHiDiKiCkJiCoHiOoGjDlOiBeC_xHqqkZx_
	m_lWidth = 200;
	// _xZkqqHx_iDhJiDeDiDjDiDhLiBfLiDfPiBfLiPoDiCmFiDhLiDfOiDjDiCkKiJjPiClDiCoKiCmEiCkCiCoJiCkJiBeI_xHqqkZx_
	m_bIsBtnOnPaneBorder = FALSE;
} // CFCCtlBrPane::CFCCtlBrPane.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrPane::~CFCCtlBrPane
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfO_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.10.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCCtlBrPane::~CFCCtlBrPane ()
{
} // CFCCtlBrPane::~CFCCtlBrPane.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrPane::Create
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDeJiDhFiDfHiDeGiDeOiDgHiCmJiMiLiCnBjFhEiCkPiCoHiCoKiClNiOhBiDeFiDeCiDjDiDgIiDeFiCpAiNoMjAkMiClFiBeB_xHqqkZx_
 *			_xZkqqHx_iPiJiKpKiJlLiCpAiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pParentWnd	:_xZkqqHx_jAgFiDeFiDeCiDjDiDgIiDeFiCpAiOhHjCoI_xHqqkZx_.
 *			dwStyle		:Window_xZkqqHx_iCmMiDfIiDfOiDeDiDiLiCpAiOhHjCoI_xHqqkZx_.
 *			nID			:_xZkqqHx_iOhBiDeFiDeCiDjDiDgIiDeFiCmM_xHqqkZx_ ID _xZkqqHx_iCpAiOhHjCoI_xHqqkZx_
 *			wndpMsgWnd	:_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCpAjBjHiCoIiCmCiCkPiCoJiDeFiDeCiDjDiDgIiDeF_xHqqkZx_.NULL_xZkqqHx_iCmIiCoHjBjHiCoHiCmIiCkC_xHqqkZx_.
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	:_xZkqqHx_jAlDiPoNiPeJjHlJ_xHqqkZx_
 *			FALSE	:_xZkqqHx_iInJiPoNiPeJjHlJ_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.10.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCCtlBrPane::Create (CWnd* pParentWnd, DWORD dwStyle, UINT nID, CWnd* wndpMsgWnd)
{
	ASSERT_VALID(pParentWnd);   // must have a parent
	//----- _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCkJiCoHjCgMiCpAiOoGjDlO_xHqqkZx_ -----
	// _xZkqqHx_iDeMiBfLjGlMiCpAiNoMjAkMiBeC_xHqqkZx_
	WString strKey;
	strKey.Format(L"%s\\CFCCtlBrPane-%x", ::GetLocalAppName(), nID);
	// _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCmMjFjNiCpAiDiMiDfHiDfIiDgHiDiKiCkJiCoHjDmHiCnNiPgPiClHiBeC_xHqqkZx_
	m_lWidth = FFGetApp()->GetProfileIntW(strKey, L"Width", int(m_lWidth));
	if (m_lWidth < GetWidthMin())
		m_lWidth = GetWidthMin();

	dwStyle |= WS_CLIPSIBLINGS;
	// force WS_CLIPSIBLINGS (avoids SetWindowPos bugs)

	// create the HWND
	LPCTSTR lpszClass = AfxRegisterWndClass(0,
							::FFGetApp()->LoadStandardCursor(IDC_ARROW),
							(HBRUSH)(COLOR_BTNFACE+1), NULL);
	CRect rect;
	rect.SetRectEmpty();
	if (!BASE_CLASS::Create(lpszClass, NULL, dwStyle, rect, pParentWnd, nID))
		return FALSE;

	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiDgPiBfLiCmMiDfIiDfOiDeDiDiLiCpAiDiMiDfHiDfIiDgHiDiKiCkJiCoHjDmHiCnNiPgPiClHiBeC_xHqqkZx_
// 05.07.20 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	DWORD dwBarStyle = (DWORD)FFGetApp()->GetProfileIntW(strKey, L"Style", int(CBRS_TOOLTIPS|CBRS_FLYBY|CBRS_ALIGN_LEFT));
	DWORD dwBarStyle = (DWORD)FFGetApp()->GetProfileIntW(strKey, L"Style", int(CBRS_FLYBY|CBRS_ALIGN_LEFT));
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiDgPiBfLiCmMiDfIiDfOiDeDiDiLiCpAjAnNjCoIiBeC_xHqqkZx_
	SetBarStyle(dwBarStyle);

	return TRUE;
} // CFCCtlBrPane::Create.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrPane::GetIsLeftSide
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNlGiDfEiDeDiDgIiCmJiCkAiCoJiCkJiOkGiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNlGiDfEiDeDiDgIiCmJiCkAiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeBiJeFiDfEiDeDiDgIiCmMiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCCtlBrPane::GetIsLeftSide ()
{
	return (GetBarStyle() & CBRS_ALIGN_LEFT) ? TRUE : FALSE;
} // CFCCtlBrPane::GetIsLeftSide.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrPane::SetIsLeftSide
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNlGiCmGiJeFiCmMiCmHiClPiCoHiCmMiDfEiDeDiDgIiCmJiCkAiCoJiCkJjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bIsLeftSide	:_xZkqqHx_iNlGiCmJiCkAiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeBiJeFiCmJiCkAiCoJiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCCtlBrPane::SetIsLeftSide (BOOL bIsLeftSide)
{
	if (GetIsLeftSide() != bIsLeftSide)
	{
//----- 05.07.20 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		if (bIsLeftSide)
//			SetBarStyle(CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_ALIGN_LEFT);
//		else
//			SetBarStyle(CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_ALIGN_RIGHT);
//----- 05.07.20 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		if (bIsLeftSide)
			SetBarStyle(CBRS_FLYBY | CBRS_ALIGN_LEFT);
		else
			SetBarStyle(CBRS_FLYBY | CBRS_ALIGN_RIGHT);
//----- 05.07.20 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		// _xZkqqHx_iDiMiDeDiDeBiDeFiDgHiCpAiMhGiOfKiClFiBeBiNmEjEhKjChFiBeC_xHqqkZx_
		UpdateLayout();
		// CFCMainFrame_xZkqqHx_iCmJiDiMiDeDiDeBiDeFiDgHiCmMiNmEiMhGiOfKiCpAiClDiClJiCoJiBeC_xHqqkZx_
		GetDockingFrame()->RecalcLayout();
		if (IsWindowVisible())
		//----- _xZkqqHx_iDeFiDeCiDjDiDgIiDeFjFfMiOkGiPpDjBnEiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDhCiDiFiBfLjBfDjBmMiCpAiNmEjFgAiJoGiBeCiNlGiCkJiCoHiJeFiBeBiJeFiCkJiCoHiNlGiCnGiInKjDkOiClHiCoJiCmGiBeB_xHqqkZx_
			// RecalcLayout_xZkqqHx_iCmFiCmNiCkEiCnMiCkNiNmEjFgAiJoGiCmFiCkLiCmIiCkCiClNiCnPiBeC_xHqqkZx_
			// _xZkqqHx_jBfDiJoGjGmKiCpAiNmEjFgAiJoGiBeC_xHqqkZx_
			g_pView->SendRgnRedraw(TRUE);
		}
		// _xZkqqHx_iDfIiDfOiDeDiDiLiDgGiBfLiDfOiCpAiDiMiDfHiDfIiDgHiDiKiCmJiPjBiCkLiNjOiCnOiBeC_xHqqkZx_
		WriteProfile();
	}
} // CFCCtlBrPane::SetIsLeftSide.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrPane::GetWidthMin
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCmMiNmFjCoBjFjNiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iClBiCoKiCkKjGlDiCkCiCmGiBeBiDeFiDeCiDjDiDgIiDeFjFjNiCkK_xHqqkZx_ 0 _xZkqqHx_iCmJiCmFiCkLiCmEiClFiCnMiCkEiBeCiClLiCmMiPoKiNiHiBeB_xHqqkZx_
 *			_xZkqqHx_iDhJiDeDiDjDiCpAjBeJjBpAiClFiCmEiCoAiDgIiDiJiDgCiDePiCmFiCkLiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long CFCCtlBrPane::GetWidthMin () const
{
	return 20;
} // CFCCtlBrPane::GetWidthMin.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrPane::GetBorderRect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhJiDeDiDjDiDhLiBfLiDfPiBfLiCmMiLoJiMgAiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhJiDeDiDjDiDhLiBfLiDfPiBfLiCmMiLoJiMgAiBeCiDeOiDiJiDeDiDeBiDjDiDgHiNmAjFfHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	GetBarStyle() _xZkqqHx_iCkK_xHqqkZx_ const _xZkqqHx_iCmFiCmIiCkCiClNiCnPiBeB_xHqqkZx_const_xZkqqHx_iCmJiCmFiCkLiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.07.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CRect CFCCtlBrPane::GetBorderRect ()
{
//----- 05.01.23 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	CRect rtClient;
//	GetClientRect(rtClient);
//	rtClient.left = rtClient.right - FD_PANEBAR_WIDTH - 2;
//	return rtClient;
//----- 05.01.23 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iDeOiDiJiDeDiDeBiDjDiDgHjHmMiIoGiCpAiOoGjDlOiBeC_xHqqkZx_
	CRect rtClient;
	GetClientRect(rtClient);
	if (GetIsLeftSide())
	//----- _xZkqqHx_iNlGjBkEiCmMiDfCiDjDiDgHiDiNiBfLiDiLiDgPiBfLiCmMiPoKiNiH_xHqqkZx_ -----
	{
		rtClient.left = rtClient.right - FD_PANEBAR_WIDTH;
	} else
	//----- _xZkqqHx_iJeFjBkEiCmMiDfCiDjDiDgHiDiNiBfLiDiLiDgPiBfLiCmMiPoKiNiH_xHqqkZx_ -----
	{
		rtClient.right = rtClient.left + FD_PANEBAR_WIDTH;
	}
	return rtClient;
//----- 05.01.23 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CFCCtlBrPane::GetBorderRect.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrPane::GetUserRect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhLiBfLiDfPiBfLiImIiKePiCmMjHmMiIoGiBgJiDiGiBfLiDfFjHjIjHhAjHmMiIoGiBgKiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhLiBfLiDfPiBfLiImIiKePiCmMjHmMiIoGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	GetBarStyle() _xZkqqHx_iCkK_xHqqkZx_ const _xZkqqHx_iCmFiCmIiCkCiClNiCnPiBeB_xHqqkZx_const_xZkqqHx_iCmJiCmFiCkLiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CRect CFCCtlBrPane::GetUserRect ()
{
	// _xZkqqHx_iDeOiDiJiDeDiDeBiDjDiDgHjHmMiIoGiCpAiOoGjDlOiBeC_xHqqkZx_
	CRect rtClient;
	GetClientRect(rtClient);
	if (GetIsLeftSide())
	//----- _xZkqqHx_iNlGjBkEiCmMiDfCiDjDiDgHiDiNiBfLiDiLiDgPiBfLiCmMiPoKiNiH_xHqqkZx_ -----
	{
		rtClient.right -= FD_PANEBAR_WIDTH;
	} else
	//----- _xZkqqHx_iJeFjBkEiCmMiDfCiDjDiDgHiDiNiBfLiDiLiDgPiBfLiCmMiPoKiNiH_xHqqkZx_ -----
	{
		rtClient.left += FD_PANEBAR_WIDTH;
	}
	return rtClient;
} // CFCCtlBrPane::GetUserRect.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrPane::UpdateLayout
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKgFiDfCiDjDiDgHiDiNiBfLiDiLiCpAiNmEjEhKjChFiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCmMiDiKiDfEiDeDiDfJiOjOiBeBiDfEiDeDiDgIiDhCiDiFiBfLjAnNjCoIiOjOiCmIiCmHiCmJiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCCtlBrPane::UpdateLayout ()
{
	// _xZkqqHx_iDhJiDeDiDjDiDhLiBfLiDfPiBfLiCmMiDeFiDeCiDjDiDgIiDeFiCpAiInKjDkOiBeC_xHqqkZx_
	m_wndPaneBorder.MoveWindow(GetBorderRect());
} // CFCCtlBrPane::UpdateLayout.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrPane::WriteProfile
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCmJiDeFiDeCiDjDiDgIiDeFiDfEiDeDiDfJiPoOjFpBjDjJiCpAjFnLjBlGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCCtlBrPane::WriteProfile ()
{
	// _xZkqqHx_iDeMiBfLjGlMiCpAiNoMjAkMiBeC_xHqqkZx_
	WString strKey;
	strKey.Format(L"%s\\CFCCtlBrPane-%x", ::GetLocalAppName(), GetDlgCtrlID());
	// _xZkqqHx_iDgGiBfLiDfOiCpAiDiMiDfHiDfIiDgHiDiKiCmJiPjBiCkLiNjOiCnOiBeC_xHqqkZx_
	FFGetApp()->WriteProfileIntW(strKey, L"Width", int(m_lWidth));
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiDgPiBfLiCmMiDfIiDfOiDeDiDiLiCpAiDiMiDfHiDfIiDgHiDiKiCmJiPjBiCkLiNjOiCnOiBeC_xHqqkZx_
	FFGetApp()->WriteProfileIntW(strKey, L"Style", int(GetBarStyle()));
} // CFCCtlBrPane::WriteProfile.

//----- 05.01.23 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrPane::GetBorderScreenRect
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhJiDeDiDjDiDhLiBfLiDfPiBfLiCmMiLoJiMgAiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhJiDeDiDjDiDhLiBfLiDfPiBfLiCmMiLoJiMgAiBeCiDfIiDeOiDiKiBfLiDjDiNmAjFfHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.07.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//CRect CFCCtlBrPane::GetBorderScreenRect () const
//{
//	CRect rt = GetBorderRect();
//	ClientToScreen(rt);
//	return rt;
//} // CFCCtlBrPane::GetBorderScreenRect.
//----- 05.01.23 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrPane::CalcFixedLayout
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiDfCiDjDiDgHiDiNiBfLiDiL_xHqqkZx_ _xZkqqHx_iDgPiBfLiCmMiDfEiDeDiDfJiCpAjFnEiClH_xHqqkZx_.
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bStretch	:_xZkqqHx_iDgPiBfLiCpAiDhEiDiMiBfLiDiAiCmMiDfEiDeDiDfJiCmJiNiHiCoNiClJiCmEjAeMiPgLiClDiClJiCoJiCkJ_xHqqkZx_
 *						 _xZkqqHx_iCmHiCkEiCkJiCpAiOkGiClHiBeC_xHqqkZx_
 *			bHorz		:_xZkqqHx_iDgPiBfLiCkKjAiFjFlNjFpLiMpMiCkJjAiCjClMjFpLiMpMiCkJiCpAiOkGiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfEiDeDiDfJ_xHqqkZx_.
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	CControlBar_xZkqqHx_iCmMiDfEiDhFiDeOiDiJiDfIiCmJiCmNjFeLjAhLiCmMiKnGjAjE_xHqqkZx_._xZkqqHx_iDfPiDeDiDgJiDhOiDgCiDeOiCmIiDiKiDfEiDeDiDfJ_xHqqkZx_
 *			_xZkqqHx_iCpAiClHiCoJiPoKiNiHiBgJiDhEiDiNiBfLiDgHiCmFiDiKiDfEiDeDiDfJjDjJiBgKiCmNiBeB_xHqqkZx_CalcDynamicLayout_xZkqqHx_iKnGjAjE_xHqqkZx_
 *			_xZkqqHx_iCoAjFeLjHhGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.10.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CSize CFCCtlBrPane::CalcFixedLayout (BOOL bStretch, BOOL bHorz)
{
	if (bHorz)
		return BASE_CLASS::CalcFixedLayout(bStretch, bHorz);
//	ASSERT(!bHorz);
	CSize szThis = BASE_CLASS::CalcFixedLayout(bStretch, bHorz);
	// _xZkqqHx_iLfOiOjHiDhJiDeDiDjDiInKjDkOiOjOiCmJjAnNjCoIiClDiCoKiClNjFjNiCpAjAnNjCoIiBeC_xHqqkZx_
	szThis.cx = m_lWidth;
	return szThis;
} // CFCCtlBrPane::CalcFixedLayout.

void CFCCtlBrPane::OnUpdateCmdUI (CFrameWnd* /*pTarget*/, BOOL /*bDisableIfNoHndler*/)
{
} // CFCCtlBrPane::OnUpdateCmdUI.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrPane::DoPaint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJoGjGmKjFfMiOkGiKnGjAjE_xHqqkZx_.
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfI_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.10.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCCtlBrPane::DoPaint (CDC* pDC)
{
	// CDC_xZkqqHx_iCpA_xHqqkZx_Auto_xZkqqHx_iCmFiDiJiDgCiDhGiBeC_xHqqkZx_
	FCAutoDC atDC(pDC, FALSE, 0, 0);
	CRect rtClient;
	GetClientRect(rtClient);
	// _xZkqqHx_jEhHiMgJjAeGiCmFjDgIiCoIjCnHiClHiBeC_xHqqkZx_
	atDC.FillRect(rtClient, FCAtBrush(::GetSysColor(COLOR_3DFACE)));

	// _xZkqqHx_iDhLiBfLiDfPiBfLiCpAiPkNiClFiLkNjClCiClHiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iLkNjClCiClFiClHiCkMiCmIiCkCiCoGiCkEiBeBiNlGjBkEiCmJiCkAiCoJiCmGiCkLiCmNiJeFjCfLiCmMiImDjApMiCmMiCnNiBeB_xHqqkZx_
	// _xZkqqHx_iJeFjBkEiCmJiCkAiCoJiCmGiCkLiCmNiNlGjCfLiCmMjGlOjApMiCmMiCnNiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
	if (GetIsLeftSide())
	//----- _xZkqqHx_iNlGjBkEiCmMiDfCiDjDiDgHiDiNiBfLiDiLiDgPiBfLiCmMiPoKiNiH_xHqqkZx_ -----
	{
		atDC.SetPen(PS_GEOMETRIC, 1, ::GetSysColor(COLOR_3DDKSHADOW));
		atDC.MoveTo(rtClient.right - 1, rtClient.top);
		atDC.LineTo(rtClient.right - 1, rtClient.bottom);
	} else
	//----- _xZkqqHx_iJeFjBkEiCmMiDfCiDjDiDgHiDiNiBfLiDiLiDgPiBfLiCmMiPoKiNiH_xHqqkZx_ -----
	{
		atDC.SetPen(PS_GEOMETRIC, 1, ::GetSysColor(COLOR_3DHILIGHT));
		atDC.MoveTo(rtClient.left, rtClient.top);
		atDC.LineTo(rtClient.left, rtClient.bottom);
	}
} // CFCCtlBrPane::DoPaint

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrPane::OnLButtonDown
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhNiDeFiDfIiCmMiNlGiDhLiDfOiDjDiCkKiJjPiClDiCoKiClNiCmGiCkLiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nFlags	:_xZkqqHx_jDkPiOjOiCmJiJjPiClDiCoKiClNiDeMiBfLjDjJiCmMiPoOjFpB_xHqqkZx_.
 *			point	:_xZkqqHx_iDhNiDeFiDfIiNmAjFfHiBeCiDeOiDiJiDeDiDeBiDjDiDgHiNmAjFfH_xHqqkZx_.
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iLfOiOjHiDhJiDeDiDjDiCmMiInKjDkOiPiIjHjNiCpAiNhDiCkE_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.10.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCCtlBrPane::OnLButtonDown (UINT nFlags, CPoint point)
{
	if (GetBorderRect().PtInRect(point))
	//----- _xZkqqHx_iDhJiDeDiDjDjFkKiKiEjApMiPoDiCmJiDhNiDeFiDfIiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// OnLButtonUp_xZkqqHx_iCnMiCmFiClBiCmM_xHqqkZx_Window_xZkqqHx_iCmJiDeDiDhIiDjDiDgHiBeC_xHqqkZx_
		::FFSetCapture(m_hWnd);
		// _xZkqqHx_iDhJiDeDiDjDiDhLiBfLiDfPiBfLiPoDiCmFiDhLiDfOiDjDiCkKiJjPiClDiCoKiCmEiCkCiCoJiCkJiBeI_xHqqkZx_
		m_bIsBtnOnPaneBorder = TRUE;
		// _xZkqqHx_iDeKiBfLiDfMiDiLiCpAjFmPiNfI_xHqqkZx_.
		FFGetMainWnd()->SetCurCursor(&m_wndPaneBorder, FFGetApp()->LoadCursor(IDC_CURSOR_SPLIT));
		//----- _xZkqqHx_iDhJiDeDiDjDjFkKiKiEjApMiCmMiDeOiDiJiDeDiDeBiDjDiDgHiNmAjFfHiCpA_xHqqkZx_m_rtBar_xZkqqHx_iCmJ_xHqqkZx_
		//		_xZkqqHx_jAnNjCoIiClFiBeB_xHqqkZx_CFCMainFrame_xZkqqHx_iCmMiDeOiDiJiDeDiDeBiDjDiDgHiNmAjFfHiCmJjFmPiKlHiClHiCoJ_xHqqkZx_ -----
		CRect rtBorder = GetBorderRect();
		m_rtBar.SetRect((rtBorder.left + rtBorder.right) / 2, rtBorder.top,
						(rtBorder.left + rtBorder.right) / 2, rtBorder.bottom);
		// _xZkqqHx_iDhJiDeDiDjDiDhLiBfLiDfPiBfLiCmMiNmAjFfHiCpAiDhEiDiMiBfLiDiAiNmAjFfHiMgOiCnGjFmPiKlHiBeC_xHqqkZx_
		MapWindowPoints(GetDockingFrame(), m_rtBar);
		//----- CFCMainFrame_xZkqqHx_iPoDiCmJiLfOiOjHiDhJiDeDiDjDjFkKiKiEjApMiCpAjFgAiJoG_xHqqkZx_ -----
		CClientDC dcFrame(GetDockingFrame());
		// _xZkqqHx_iPeDjAlDjApMjFgAiJoGjHhAiDeOiDiJiDfIiCpAiNoMjAkMiBeC_xHqqkZx_
		FCEditDraw edrawFrame(&dcFrame, FD_PANEBAR_WIDTH, OptiColor(FD_PANEBAR_COLOR) ^
												g_pReg->GetOptiSheetColor(), -1, 0, 0);
		edrawFrame.Line(&CPoint(m_rtBar.left, m_rtBar.top),
						&CPoint(m_rtBar.left, m_rtBar.bottom));
	}
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnLButtonDown(nFlags, point);
} // CFCCtlBrPane::OnLButtonDown.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrPane::OnMouseMove
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhNiDeFiDfIiCkKiInKjDkOiClDiCoKiClNiCmGiCkLiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nFlags	:_xZkqqHx_jDkPiOjOiCmJiJjPiClDiCoKiClNiDeMiBfLjDjJiCmMiPoOjFpB_xHqqkZx_.
 *			point	:_xZkqqHx_iDhNiDeFiDfIiNmAjFfHiBeCiDeOiDiJiDeDiDeBiDjDiDgHiNmAjFfH_xHqqkZx_.
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iLfOiOjHiDhJiDeDiDjDiCmMiInKjDkOiPiIjHjNiCpAiNhDiCkE_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.10.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCCtlBrPane::OnMouseMove (UINT nFlags, CPoint point)
{
	if (m_bIsBtnOnPaneBorder)
	//----- _xZkqqHx_iDhJiDeDiDjDiDhLiBfLiDfPiBfLiPoDiCmFiDhLiDfOiDjDiCkKiJjPiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		FFGetMainWnd()->SetCurCursor(&m_wndPaneBorder, FFGetApp()->LoadCursor(IDC_CURSOR_SPLIT));
		//----- _xZkqqHx_jBePiJpBjFgAiCkCiClNiLfOiOjHiDhJiDeDiDjDjFkKiKiEjApMiCpAiPmBiLiO_xHqqkZx_ -----
		CClientDC dcFrame(GetDockingFrame());
		// _xZkqqHx_iPeDjAlDjApMjFgAiJoGjHhAiDeOiDiJiDfIiCpAiNoMjAkMiBeC_xHqqkZx_
		FCEditDraw edrawFrame(&dcFrame, FD_PANEBAR_WIDTH, OptiColor(FD_PANEBAR_COLOR) ^
												g_pReg->GetOptiSheetColor(), -1, 0, 0);
		edrawFrame.Line(&CPoint(m_rtBar.left, m_rtBar.top),
						&CPoint(m_rtBar.left, m_rtBar.bottom));
		//----- _xZkqqHx_jAfGiClFiCkCiDhJiDeDiDjDjFkKiKiEjApMiCmMiNmAjFfHiCpAjAnNjCoI_xHqqkZx_ -----
		// _xZkqqHx_iDeOiDiJiDeDiDeBiDjDiDgHjHmMiIoGiCpAiOoGjDlOiBeC_xHqqkZx_
		CRect rtClient;
		GetClientRect(rtClient);
		// _xZkqqHx_iDhJiDeDiDjDiDgPiBfLiCmMiNmAjFfHiCpAiMhGiOfKiBeC_xHqqkZx_m_rtBar.right _xZkqqHx_iCmNjFhDiOgHjHhAiBeC_xHqqkZx_
		m_rtBar.SetRect(point.x, rtClient.top, 0, rtClient.bottom);
		if (GetIsLeftSide())
		//----- _xZkqqHx_iNlGjBkEiCmMiDfCiDjDiDgHiDiNiBfLiDiLiDgPiBfLiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDhJiDeDiDjDiCmMiNmFjCoBjFjNiCpAiJlKiJpBiCoHiCmIiCkCiCoGiCkEiCmJiClHiCoJiBeC_xHqqkZx_
			if (m_rtBar.left < rtClient.left + GetWidthMin())
				m_rtBar.left = rtClient.left + GetWidthMin();
		} else
		//----- _xZkqqHx_iJeFjBkEiCmMiDfCiDjDiDgHiDiNiBfLiDiLiDgPiBfLiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDhJiDeDiDjDiCmMiNmFjCoBjFjNiCpAiJlKiJpBiCoHiCmIiCkCiCoGiCkEiCmJiClHiCoJiBeC_xHqqkZx_
			if (rtClient.right - GetWidthMin() < m_rtBar.left)
				m_rtBar.left = rtClient.right - GetWidthMin();
		}
		// _xZkqqHx_iDhJiDeDiDjDiDhLiBfLiDfPiBfLiCmMiNmAjFfHiCpAiDhEiDiMiBfLiDiAiNmAjFfHiMgOiCnGjFmPiKlHiBeC_xHqqkZx_
		MapWindowPoints(GetDockingFrame(), m_rtBar);
		//----- CFCMainFrame_xZkqqHx_iPoDiCmJiLfOiOjHiDhJiDeDiDjDjFkKiKiEjApMiCpAjFgAiJoG_xHqqkZx_ -----
		edrawFrame.Line(&CPoint(m_rtBar.left, m_rtBar.top),
						&CPoint(m_rtBar.left, m_rtBar.bottom));
	} else
	//----- _xZkqqHx_iDhJiDeDiDjDiDhLiBfLiDfPiBfLiPoDiCmFiDhLiDfOiDjDiCkKiJjPiClDiCoKiCmEiCkCiCoJiImIiKePiCmMiPoKiNiH_xHqqkZx_ -----
	{
		if (GetBorderRect().PtInRect(point))
			FFGetMainWnd()->SetCurCursor(&m_wndPaneBorder, FFGetApp()->LoadCursor(IDC_CURSOR_SPLIT));
	}
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnMouseMove(nFlags, point);
} // CFCCtlBrPane::OnMouseMove.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrPane::OnLButtonUp
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhNiDeFiDfIiCmMiNlGiDhLiDfOiDjDiCkKjHkDiClDiCoKiClNiCmGiCkLiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nFlags	:_xZkqqHx_jDkPiOjOiCmJiJjPiClDiCoKiClNiDeMiBfLjDjJiCmMiPoOjFpB_xHqqkZx_.
 *			point	:_xZkqqHx_iDhNiDeFiDfIiNmAjFfHiBeCiDeOiDiJiDeDiDeBiDjDiDgHiNmAjFfH_xHqqkZx_.
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iLfOiOjHiDhJiDeDiDjDiCmMiInKjDkOiPiIjHjNiCpAiNhDiCkE_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.10.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCCtlBrPane::OnLButtonUp (UINT nFlags, CPoint point)
{
	if (m_bIsBtnOnPaneBorder)
	//----- _xZkqqHx_iDhJiDeDiDjDiDhLiBfLiDfPiBfLiPoDiCmFiDhLiDfOiDjDiCkKiJjPiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDhNiDeFiDfIiDeDiDhIiDjDiDgHiDeMiDiDiDhGiDgAiDiDiCpAiJpAiPjMiBeC_xHqqkZx_
		::FFReleaseCapture();
		// _xZkqqHx_iDhJiDeDiDjDiDhLiBfLiDfPiBfLiPoDiCmFiDhLiDfOiDjDiCkKiJjPiClDiCoKiCmEiCkCiCoJiCkJiBeI_xHqqkZx_
		m_bIsBtnOnPaneBorder = FALSE;
		FFGetMainWnd()->SetCurCursor(&m_wndPaneBorder, FFGetApp()->LoadCursor(IDC_CURSOR_SPLIT));
		//----- _xZkqqHx_jBePiJpBjFgAiCkCiClNiLfOiOjHiDhJiDeDiDjDjFkKiKiEjApMiCpAiPmBiLiO_xHqqkZx_ -----
		CClientDC dcFrame(GetDockingFrame());
		// _xZkqqHx_iPeDjAlDjApMjFgAiJoGjHhAiDeOiDiJiDfIiCpAiNoMjAkMiBeC_xHqqkZx_
		FCEditDraw edrawFrame(&dcFrame, FD_PANEBAR_WIDTH, OptiColor(FD_PANEBAR_COLOR) ^
												g_pReg->GetOptiSheetColor(), -1, 0, 0);
		edrawFrame.Line(&CPoint(m_rtBar.left, m_rtBar.top),
						&CPoint(m_rtBar.left, m_rtBar.bottom));
		//----- _xZkqqHx_jAfGiClFiCkCiDeFiDeCiDjDiDgIiDeFiDfEiDeDiDfJiCpAjDlBiPgP_xHqqkZx_ -----
		CRect rtNew;
		GetWindowRect(rtNew);
		GetDockingFrame()->ScreenToClient(rtNew);

		if (GetIsLeftSide())
		//----- _xZkqqHx_iNlGjBkEiCmMiDfCiDjDiDgHiDiNiBfLiDiLiDgPiBfLiCmMiPoKiNiH_xHqqkZx_ -----
		{
			rtNew.right = m_rtBar.left + FD_PANEBAR_WIDTH / 2;
		} else
		//----- _xZkqqHx_iJeFjBkEiCmMiDfCiDjDiDgHiDiNiBfLiDiLiDgPiBfLiCmMiPoKiNiH_xHqqkZx_ -----
		{
			rtNew.left = m_rtBar.left - FD_PANEBAR_WIDTH / 2;
		}
		// CalcFixedLayout_xZkqqHx_jHhAiCmJiDeFiDeCiDjDiDgIiDeFjFjNiCpAiLeMjIfOiBeC_xHqqkZx_
		m_lWidth = rtNew.Width();
		// _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiDfEiDeDiDfJiCpAjAnNjCoIiBeC_xHqqkZx_
		MoveWindow(rtNew);
		// CFCMainFrame_xZkqqHx_iCmJiDiMiDeDiDeBiDeFiDgHiCmMiNmEiMhGiOfKiCpAiClDiClJiCoJiBeC_xHqqkZx_
		GetDockingFrame()->RecalcLayout();
		// RecalcLayout_xZkqqHx_iCmFiCoAiNmEjFgAiJoGiClHiCoJiCkKiBeBiLfOiOjHiDhJiDeDiDjDiPoDiCmJiDfDiDhOiCkK_xHqqkZx_
		// _xZkqqHx_iOgDiCoJiClBiCmGiCkKiCkAiCoJiClNiCnPiBeBiNmEjDhIjFgAiJoGiBeC_xHqqkZx_
		Invalidate();
		// _xZkqqHx_iDfIiDfOiDeDiDiLiDgGiBfLiDfOiCpAiDiMiDfHiDfIiDgHiDiKiCmJiPjBiCkLiNjOiCnOiBeC_xHqqkZx_
		WriteProfile();
	}
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnLButtonUp(nFlags, point);
} // CFCCtlBrPane::OnLButtonUp.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrPane::OnSize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfEiDeDiDfJjFmPiNfIiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nType	:_xZkqqHx_iDfEiDeDiDfJjFmPiNfIiCmMiDfOiDeDiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			cx		:_xZkqqHx_jAfGiClFiCkCiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			cy		:_xZkqqHx_jAfGiClFiCkCiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.07.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCCtlBrPane::OnSize (UINT nType, int cx, int cy)
{
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnSize(nType, cx, cy);
	// _xZkqqHx_iDiMiDeDiDeBiDeFiDgHiCpAiMhGiOfKiClFiBeBiNmEjEhKjChFiBeC_xHqqkZx_
	UpdateLayout();
} // CFCCtlBrPane::OnSize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrPane::OnCreate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeFiDeCiDjDiDgIiDeFiNoMjAkMiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.07.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
int CFCCtlBrPane::OnCreate (LPCREATESTRUCT lpCreateStruct)
{
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	if (BASE_CLASS::OnCreate(lpCreateStruct) == -1)
		return -1;
	// _xZkqqHx_iDhJiDeDiDjDiDhLiBfLiDfPiBfLiCmMiDeFiDeCiDjDiDgIiDeFiCpAiNoMjAkMiBeC_xHqqkZx_
	// create the HWND
	LPCTSTR lpszClass = AfxRegisterWndClass(0,
							::FFGetApp()->LoadStandardCursor(IDC_ARROW),
							(HBRUSH)(COLOR_BTNFACE+1), NULL);
	CRect rect;
	rect.SetRectEmpty();
	m_wndPaneBorder.Create(lpszClass, NULL, WS_CHILD, rect, this, 0);
	return 0;
} // CFCCtlBrPane::OnCreate.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrPane::OnDestroy
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeFiDeCiDjDiDgIiDeFjGjFiPmBiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.07.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCCtlBrPane::OnDestroy ()
{
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnDestroy();
	// _xZkqqHx_iDhJiDeDiDjDiDhLiBfLiDfPiBfLiCmMiDeFiDeCiDjDiDgIiDeFiCpAiNoNiPjMiBeC_xHqqkZx_
	m_wndPaneBorder.DestroyWindow();
} // CFCCtlBrPane::OnDestroy.
