#include "stdafx.h"
#include "DynamicDraw.h"	// For FFGetApp.
#include "DynamicDrawView.h"// For g_pView.
#include "UtilCoord.h"		// For mm2lg.etc.
#include "UtilMath.h"		// For _i64tow10fig.
#include "UtilGraph.h"		// For FCAutoDC.
#include "UtilWin.h"		// For FFNotifyPendingMessage.
#include "RegData.h"		// For InitRegFont.
#include "PursuerText.h"	// For CFCPursuerText.
#include "CtlBrVRuler.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// 06.04.23 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//#define FD_RULER_WIDTH	20

//----- 06.04.24 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//#define FD_RULER_WIDTH	20
//#define FD_RULER_HALF	10
//----- 06.04.24 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
#define FD_RULER_TOP	2
#define FD_RULER_WIDTH	22
#define FD_RULER_HALF	12
//----- 06.04.24 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

////////////////////////////////////////////////////////////////////////////
// CFCCtlBrVRuler_xZkqqHx_iBeC_xHqqkZx_

IMPLEMENT_DYNAMIC(CFCCtlBrVRuler, CControlBar)

BEGIN_MESSAGE_MAP(CFCCtlBrVRuler, BASE_CLASS)
	//{{AFX_MSG_MAP(CFCCtlBrVRuler)
	ON_WM_SHOWWINDOW()
	ON_WM_WINDOWPOSCHANGED()
	//}}AFX_MSG_MAP
	// Global help commands
	ON_MESSAGE(WM_USER_UPDATE_RULER, OnUserUpdateRuler)
	ON_MESSAGE(WM_USER_PURSUER_TEXT_NEED_INFO, OnUserPursuerTextNeedInfo)
END_MESSAGE_MAP()

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrVRuler::CFCCtlBrVRuler
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.06 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
//----- 06.04.24 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//CFCCtlBrVRuler::CFCCtlBrVRuler (BOOL bDrawBorder)
//{
//	m_bDrawBorder = bDrawBorder;
//} // CFCCtlBrVRuler::CFCCtlBrVRuler.
//----- 06.04.24 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
CFCCtlBrVRuler::CFCCtlBrVRuler ()
{
} // CFCCtlBrVRuler::CFCCtlBrVRuler.
//----- 06.04.24 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrVRuler::~CFCCtlBrVRuler
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.06 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCCtlBrVRuler::~CFCCtlBrVRuler ()
{
} // CFCCtlBrVRuler::~CFCCtlBrVRuler.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrVRuler::Create
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiNoMjAkMiMoDiCmJiBeB_xHqqkZx_CFCMainFrame_xZkqqHx_iCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pParentWnd	:_xZkqqHx_jAgFiDeFiDeCiDjDiDgIiDeFiCpAiOhHjCoIiBeCjCmKiPoNiCmN_xHqqkZx_CFCMainFrame_xZkqqHx_iBeC_xHqqkZx_
 * 			dwStyle		:_xZkqqHx_iDeFiDeCiDjDiDgIiDeFiDfIiDfOiDeDiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *			nID			:_xZkqqHx_iDeFiDeCiDjDiDgIiDeF_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNoMjAkMjAkMiMpHiOjOiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiOlIjEhDiOjOiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCCtlBrVRuler::Create (CWnd* pParentWnd, DWORD dwStyle, UINT nID)
{
	ASSERT_VALID(pParentWnd);   // must have a parent

	dwStyle |= WS_CLIPSIBLINGS;
	// force WS_CLIPSIBLINGS (avoids SetWindowPos bugs)

	// create the HWND
	CRect rect;
	rect.SetRectEmpty();
	LPCTSTR lpszClass = AfxRegisterWndClass(0,
							::FFGetApp()->LoadStandardCursor(IDC_ARROW),
							(HBRUSH)(COLOR_BTNFACE+1), NULL);

	if (!CWnd::Create(lpszClass, NULL, dwStyle, rect, pParentWnd, nID))
		return FALSE;

	//----- _xZkqqHx_iDiBiDjDiDgPjFmPjAjEiPiJiKpKiJlL_xHqqkZx_ -----
	m_mmPitch0 = 0.0;				// _xZkqqHx_iNnHiCkJiCkCiNiPiCnNiBeCiOmAiNmAjFfHiBeC_xHqqkZx_
	m_mmPitch1 = 0.0;				// _xZkqqHx_jBoFiCkLiCkCiNiPiCnNiBeCiOmAiNmAjFfHiBeC_xHqqkZx_
	m_nZoomFig = 0;					// Zoom_xZkqqHx_iCmMiMiFiBeC_xHqqkZx_10^m_nZoomFig_xZkqqHx_iBeC_xHqqkZx_
	m_dvOffset = 0;					// _xZkqqHx_iDfIiDeOiDiNiBfLiDiLiImKjChFiBeC_xHqqkZx_0_xZkqqHx_iCkJiCoHiNlGjFpLiMpMiCnGiCmMiDeJiDhEiDfKiDgCiDgHiBeC_xHqqkZx_
	m_dvrctRuler.SetRect(0,0,0,0);	// Ruler_xZkqqHx_jFgAiJoGjHmMiIoGiBeCiDgGiDgPiDeDiDfIiNmAjFfHiBeC_xHqqkZx_
	//----- _xZkqqHx_iDiLiBfLiDiJiBfLiDhNiDeFiDfIiDhNiBfLiDeKiBfLiKnGiMfH_xHqqkZx_ -----
	memset(m_baIsRulerMMKVisible, 0, sizeof(m_baIsRulerMMKVisible));
	memset(m_lgaRulerMMK, 0, sizeof(m_lgaRulerMMK));
//----------<NOT EXPORT TO VIEWER>-----------
	m_wndpTarget = NULL;
//----------</NOT EXPORT TO VIEWER>-----------
	return TRUE;
} // CFCCtlBrVRuler::Create.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrVRuler::ScrollTo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfIiDeOiDiNiBfLiDiLiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_DynamicDrawView.cpp_xZkqqHx_iCkJiCoHiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lgVal	:_xZkqqHx_iDfIiDeOiDiNiBfLiDiLiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_View_xZkqqHx_iCmMjIfPjHjNiNmAjFfHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.06 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCCtlBrVRuler::ScrollTo (long lgVal)
{
	if (m_dvrctRuler.Height() < ::abs(m_dvOffset - lgVal))
	/*----- _xZkqqHx_iDfIiDeOiDiNiBfLiDiLjHmKiCkKjFgAiJoGjEmNiImNiCpAjClEiCkGiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----*/
	{
		m_dvOffset = lgVal;
		RedrawWindow();
	} else
	/*----- _xZkqqHx_iDfIiDeOiDiNiBfLiDiLjHmKiCkKjFgAiJoGjEmNiImNiCpAjClEiCkGiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----*/
	{
//----- 00.04.06 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		CClientDC dc(this); // _xZkqqHx_jFgAiJoGjHhAiCmMiDgGiDgPiDeDiDfI_xHqqkZx_ _xZkqqHx_iDfCiDjDiDgFiDeMiDfIiDgH_xHqqkZx_.
//		CRect	client;
//		(void)dc.ScrollDC(0, m_dvOffset - lgVal, &m_dvrctRuler, &m_dvrctRuler,
//							NULL, &client);
//
//		m_dvOffset = lgVal;
//		RedrawWindow(&client, NULL, RDW_INVALIDATE | RDW_UPDATENOW);
//----- 00.04.06 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		ScrollWindow(0, m_dvOffset - lgVal, &m_dvrctRuler, &m_dvrctRuler);
		m_dvOffset = lgVal;
		UpdateWindow();
//----- 00.04.06 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	}
} // CFCCtlBrVRuler::ScrollTo.

//----- 03.07.15 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrVRuler::OnViewSize
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	CView_xZkqqHx_iCmMiDfEiDeDiDfJiCkKjFmPiNfIiClDiCoKiClNiOjOiBeBiDfEiDeDiDfJiCpAjDoAjFjEjFmPjAjEiCmJiOoGiCoIiNjOiCnOiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	CFCDynamicDrawView::UpdateScrollSize_xZkqqHx_iKnGjAjEiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.02.19 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
// *************************************************************************/
//void CFCCtlBrVRuler::OnViewSize ()
//{
//	if (g_pView != NULL)
//	{
//		// View_xZkqqHx_iCmMjHmMiIoGiCpAjIfPjHjNiNmAjFfHiCmFiOoGjDlOiBeC_xHqqkZx_
//		g_pView->GetClientRectLG(m_dvrctRuler);
//		// View_xZkqqHx_iCmMjIfPjHjNiNmAjFfHiCmMjFkIjHjNiNmAjFfHiCmJjBmOiClHiCoJiDeJiDhEiDfKiDgCiDgHjCgMiCpAiMhGiOfKiBeC_xHqqkZx_
//		m_dvOffset = m_dvrctRuler.top;
//		// View_xZkqqHx_iCmMjHmMiIoGiCpAjFkIjHjNiNmAjFfHiCmJjFmPiKlHiBeC_xHqqkZx_
//		m_dvrctRuler.top = 0;
//		m_dvrctRuler.bottom -= m_dvOffset;
//		// View_xZkqqHx_iCmMjHmMiIoGiCpAiBeBiClBiCmMiDiLiBfLiDiJiBfLiCmFiCmMjFkIjHjNiNmAjFfHiCmJjFmPiKlHiBeC_xHqqkZx_
//		g_pView->ClientToScreen(&m_dvrctRuler);
//		ScreenToClient(&m_dvrctRuler);
//		// m_dvrctRuler_xZkqqHx_iCpAiBeBiDiLiBfLiDiJiBfLiCmMiDhCiDiFiBfLjEmNiImNiCmMjDgIiCoIiCmCiCnEiClFjHmMiIoGiCmJiBeC_xHqqkZx_
//		m_dvrctRuler.left = 0;
//		m_dvrctRuler.right = FD_RULER_WIDTH;
//	}
//
//	//----- Scale_xZkqqHx_iKnGiMfHiPiJiKpKiJlL_xHqqkZx_ -----
//
//	//----- _xZkqqHx_jIfPjHjNiNmAjFfHiCkK_xHqqkZx_20pixel_xZkqqHx_jCpGjDhIiCmJiCmIiCoJiCoGiCkEiCmJiBeBiDhDiDgCiDgAiCpAjClCjAkO_xHqqkZx_ -----
//	// 20pixel_xZkqqHx_iCpA_xHqqkZx_HI_xZkqqHx_iNmAjFfHiCmJjFmPiKlHiBeC_xHqqkZx_
//	hic hiPitch = lg2hi(20);
//	//----- HI_xZkqqHx_iNmAjFfHjCgMiCpAiBeB_xHqqkZx_a * 10^b (1 <= a < 10) _xZkqqHx_iCmJjFmPiKlH_xHqqkZx_ -----
//	double b = log10(hiPitch);
//	if (0 < b)
//	{
//		b = int(b);
//	} else
//	{
//		if ((b - int(b)) != 0.0)
//			b = int(b) - 1.0;
//	}
//	double p = pow(10.0, b);
//	double a = hiPitch / p;
//	//----- a _xZkqqHx_iCpA_xHqqkZx_1.0,2.5,5.0,10.0_xZkqqHx_iCmMiCkCiClIiCoKiCkJiLnPiCkCjCgMiCmJjFfHiPiAiJlL_xHqqkZx_ -----
//	double ra = 1.0;
//	double dif = fabs(a - ra);
//	// _xZkqqHx_iDhDiDgCiDgAiCfAiCmMiPkMjAjEjDfPiImIiJlKiCmMiMiFjAjEiBeC_xHqqkZx_0.1 _xZkqqHx_iCmIiCoHiCmO_xHqqkZx_ -1_xZkqqHx_iBeC_xHqqkZx_
//	short nZoomFigure = b + 1.0;
//	if (fabs(a - 2.5) < dif)
//	{
//		ra = 2.5;
//		dif = fabs(a - ra);
//		nZoomFigure = b;
//	}
//	if (fabs(a - 5.0) < dif)
//	{
//		ra = 5.0;
//		dif = fabs(a - ra);
//		nZoomFigure = b + 1.0;
//	}
//	if (fabs(a - 10.0) < dif)
//	{
//		ra = 10.0;
//		dif = fabs(a - ra);
//		nZoomFigure = b + 2.0;
//	}
//	if (0 < nZoomFigure) nZoomFigure = 0;
//	// Scale_xZkqqHx_iCmMiNnHiCkJiCkCiNiPiCnNjFjNiBeC_xHqqkZx_
//	mmetol mmScalePitch0 = hi2mm(ra * p);
//	// Scale_xZkqqHx_iCmMjBlOiCkCiNiPiCnNjFjNiBeC_xHqqkZx_
//	mmetol mmScalePitch1 = 10.0 * mmScalePitch0;
//	// _xZkqqHx_iDhDiDgCiDgAiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
//	SetPitch(mmScalePitch0, mmScalePitch1, nZoomFigure);
//	// _xZkqqHx_iNmEjFgAiJoGiBeC_xHqqkZx_
//	Invalidate();
//} // CFCCtlBrVRuler::OnViewSize.
//----- 03.07.15 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

void CFCCtlBrVRuler::SetPitch (double mmPitch0, double mmPitch1, short nZoomFig)
{
	m_mmPitch0 = mmPitch0;
	m_mmPitch1 = mmPitch1;
	m_nZoomFig = nZoomFig;
	Invalidate();
} // CFCCtlBrVRuler::SetPitch.

void CFCCtlBrVRuler::SetTextRange (CWnd* wndpTarget, double vmmBegin, double vmmEnd)
{
	m_wndpTarget = wndpTarget;
	m_vmmBegin	= vmmBegin;		// _xZkqqHx_jFfMiOkGjEmNiImNiCmMiKeKiOgOiNmAjFfH_xHqqkZx_.
	m_vmmEnd	= vmmEnd;		// _xZkqqHx_jFfMiOkGjEmNiImNiCmMiPeJjHlJiNmAjFfH_xHqqkZx_.
	Invalidate();
} // CFCCtlBrVRuler::SetTextRange.

void CFCCtlBrVRuler::UnSetTextRange ()
{
	m_wndpTarget = NULL;
	Invalidate();
} // CFCCtlBrVRuler::UnSetTextRange.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrVRuler::IsRulerMMKVisible
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiLiBfLiDiJiBfLiDhNiDeFiDfIiDhNiBfLiDeKiBfLiCmMjFfMiOkGiBeFjEpBjFfMiOkGiCmMiPpDjBnEiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nIndex	: _xZkqqHx_jClCiCnHiClNiCkCiDiLiBfLiDiJiBfLiDhNiDeFiDfIiDhNiBfLiDeKiBfLiCmMiDeDiDjDiDgGiDgCiDeOiDfI_xHqqkZx_.
 *************************************************************************/
BOOL CFCCtlBrVRuler::IsRulerMMKVisible (short nIndex) const
{
	return m_baIsRulerMMKVisible[nIndex];
} // CFCCtlBrVRuler::IsRulerMMKVisible.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrVRuler::SetRulerMMKVisible
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiLiBfLiDiJiBfLiDhNiDeFiDfIiDhNiBfLiDeKiBfLiCmMjFfMiOkGiBeFjEpBjFfMiOkGiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nIndex	: _xZkqqHx_jAnNjCoIiClFiClNiCkCiDiLiBfLiDiJiBfLiDhNiDeFiDfIiDhNiBfLiDeKiBfLiCmMiDeDiDjDiDgGiDgCiDeOiDfI_xHqqkZx_.
 *			bVisible: _xZkqqHx_jAnNjCoIiClHiCoJjFfMiOkGiBeFjEpBjFfMiOkGiCmMiPpDjBnE_xHqqkZx_.
 *************************************************************************/
void CFCCtlBrVRuler::SetRulerMMKVisible (short nIndex, BOOL bVisible)
{
	if (m_baIsRulerMMKVisible[nIndex] == bVisible) return;
	m_baIsRulerMMKVisible[nIndex] = bVisible;
	if (!IsWindowVisible()) return;

//----- 00.07.14 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	CClientDC dc(this);
//	// CDC_xZkqqHx_iCpA_xHqqkZx_Auto_xZkqqHx_iCmFiDiJiDgCiDhGiBeC_xHqqkZx_
//	FCAutoDC atDC(&dc);
//	//----- _xZkqqHx_iKgFiOoNiDiCiBfLiDgIiCpA_xHqqkZx_CDC_xZkqqHx_iCnGjAnNjCoI_xHqqkZx_ -----
//	atDC.SetROP2(R2_NOT);
//	atDC.SetPen(PS_SOLID, 0, g_pReg->GetOptiRegColor(FDCL_RULER_MMK));
//	//----- _xZkqqHx_iDgPiBfLiCpAiPmBiLiOiIlNiCkCiCmNjFfMiOkG_xHqqkZx_ -----
//	atDC.MoveTo(0, VLG2DV(m_lgaRulerMMK[nIndex]));
//	atDC.LineTo(FD_RULER_WIDTH, VLG2DV(m_lgaRulerMMK[nIndex]));
//----- 00.07.14 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iPeDjAlDjApMjFgAiJoGjHhAiDeOiDiJiDfIiCpAiNoMjAkMiBeC_xHqqkZx_
	CClientDC dc(this);
	// _xZkqqHx_iDiLiBfLiDiJiBfLiDhNiDeFiDfIiDhNiBfLiDeKiBfLjAeGiCmGiDiLiBfLiDiJiBfLjGlOiCoJiCkCjAeGiCmMjEhCjBlMjAeGiCpAiOhHjCoIiBeC_xHqqkZx_
	FCEditDraw eDraw(&dc, 0, g_pReg->GetOptiRegColor(FDCL_RULER_MMK) ^
								g_pReg->GetOptiRegColor(FDCL_RULER_LIGHT), -1, 0, 0);
	//----- _xZkqqHx_iDgPiBfLiCpAiPmBiLiOiIlNiCkCiCmNjFfMiOkG_xHqqkZx_ -----
// 06.04.24 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	eDraw.Line(	&CPoint(0, VLG2DV(m_lgaRulerMMK[nIndex])),
	eDraw.Line(	&CPoint(FD_RULER_TOP, VLG2DV(m_lgaRulerMMK[nIndex])),
				&CPoint(FD_RULER_WIDTH, VLG2DV(m_lgaRulerMMK[nIndex])));
//----- 00.07.14 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CFCCtlBrVRuler::SetRulerMMKVisible.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrVRuler::MoveRulerMMK
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiLiBfLiDiJiBfLiDhNiDeFiDfIiDhNiBfLiDeKiBfLiCpAiInKjDkOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nIndex	:_xZkqqHx_iInKjDkOiClFiClNiCkCiDiLiBfLiDiJiBfLiDhNiDeFiDfIiDhNiBfLiDeKiBfLiCmMiDeDiDjDiDgGiDgCiDeOiDfI_xHqqkZx_.
 *			lgVal	:_xZkqqHx_iInKjDkOjAoGiCmMiNmAjFfHiBgJ_xHqqkZx_View_xZkqqHx_jIfPjHjNiNmAjFfHiBgK_xHqqkZx_.
 *************************************************************************/
void CFCCtlBrVRuler::MoveRulerMMK (short nIndex, long lgVal)
{
	if (m_baIsRulerMMKVisible[nIndex])
	//----- _xZkqqHx_iDiLiBfLiDiJiBfLiDhNiDeFiDfIiDhNiBfLiDeKiBfLiCmNjFfMiOkGiPpDjBnE_xHqqkZx_ ------
	{
//----- 00.07.14 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		CClientDC dc(this);
//		// CDC_xZkqqHx_iCpA_xHqqkZx_Auto_xZkqqHx_iCmFiDiJiDgCiDhGiBeC_xHqqkZx_
//		FCAutoDC atDC(&dc);
//		//----- _xZkqqHx_iKgFiOoNiDiCiBfLiDgIiCpA_xHqqkZx_CDC_xZkqqHx_iCnGjAnNjCoI_xHqqkZx_ -----
//		atDC.SetROP2(R2_NOT);
//		atDC.SetPen(PS_SOLID, 0, g_pReg->GetOptiRegColor(FDCL_RULER_MMK));
//----- 00.07.14 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		// _xZkqqHx_iPeDjAlDjApMjFgAiJoGjHhAiDeOiDiJiDfIiCpAiNoMjAkMiBeC_xHqqkZx_
		CClientDC dc(this);
		// _xZkqqHx_iDiLiBfLiDiJiBfLiDhNiDeFiDfIiDhNiBfLiDeKiBfLjAeGiCmGiDiLiBfLiDiJiBfLjGlOiCoJiCkCjAeGiCmMjEhCjBlMjAeGiCpAiOhHjCoIiBeC_xHqqkZx_
		FCEditDraw eDraw(&dc, 0, g_pReg->GetOptiRegColor(FDCL_RULER_MMK) ^
									g_pReg->GetOptiRegColor(FDCL_RULER_LIGHT), -1, 0, 0);
//----- 00.07.14 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		// _xZkqqHx_iDgPiBfLiCmM_xHqqkZx_y_xZkqqHx_iNmAjFfHiBgJjFkIjHjNiNmAjFfHiBgKiCpAiMhGiOfKiBeC_xHqqkZx_
		long dvY = VLG2DV(m_lgaRulerMMK[nIndex]);
		// _xZkqqHx_iDiLiBfLiDiJiBfLjFgAiJoGjHmMiIoGjDoAiCmMiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
		if (m_dvrctRuler.top <= dvY && dvY <= m_dvrctRuler.bottom)
		{
			//----- _xZkqqHx_iMlLiNnNiCmMiDgPiBfLiCpAiPmBiLiO_xHqqkZx_ -----
//----- 00.07.14 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//			atDC.MoveTo(0, dvY);
//			atDC.LineTo(FD_RULER_WIDTH, dvY);
//----- 00.07.14 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
// 06.04.24 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//			eDraw.Line(	&CPoint(0, dvY),
			eDraw.Line(	&CPoint(FD_RULER_TOP, dvY),
						&CPoint(FD_RULER_WIDTH, dvY));
//----- 00.07.14 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		}
		// _xZkqqHx_jAfGiClFiCkCiDhNiDeFiDfIiNmAjFfHiCpAjAnNjCoIiBeC_xHqqkZx_
		m_lgaRulerMMK[nIndex] = lgVal;
		// _xZkqqHx_iDgPiBfLiCmM_xHqqkZx_y_xZkqqHx_iNmAjFfHiBgJjFkIjHjNiNmAjFfHiBgKiCpAiMhGiOfKiBeC_xHqqkZx_
		dvY = VLG2DV(m_lgaRulerMMK[nIndex]);
		// _xZkqqHx_iDiLiBfLiDiJiBfLjFgAiJoGjHmMiIoGjDoAiCmMiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
		if (m_dvrctRuler.top <= dvY && dvY <= m_dvrctRuler.bottom)
		{
			//----- _xZkqqHx_jAfGiClFiCkCiDgPiBfLiCpAjFgAiJoG_xHqqkZx_ -----
//----- 00.07.14 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//			atDC.MoveTo(0, dvY);
//			atDC.LineTo(FD_RULER_WIDTH, dvY);
//----- 00.07.14 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
// 06.04.24 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//			eDraw.Line(	&CPoint(0, dvY),
			eDraw.Line(	&CPoint(FD_RULER_TOP, dvY),
						&CPoint(FD_RULER_WIDTH, dvY));
//----- 00.07.14 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		}
	} else
	//----- _xZkqqHx_iDiLiBfLiDiJiBfLiDhNiDeFiDfIiDhNiBfLiDeKiBfLiCmNjEpBjFfMiOkGiPpDjBnE_xHqqkZx_ -----
	{
		// _xZkqqHx_jAfGiClFiCkCiDhNiDeFiDfIiNmAjFfHiCpAjAnNjCoIiBeC_xHqqkZx_
		m_lgaRulerMMK[nIndex] = lgVal;
	}
} // CFCCtlBrVRuler::MoveRulerMMK.

long CFCCtlBrVRuler::VLG2DV (long lgVal) const
{
	return lgVal + m_dvrctRuler.top - m_dvOffset;
} // CFCCtlBrVRuler::VLG2DV.

long CFCCtlBrVRuler::DV2VLG (long dvVal) const
{
	return dvVal - m_dvrctRuler.top + m_dvOffset;
} // CFCCtlBrVRuler::DV2VLG.

long CFCCtlBrVRuler::VMM2DV (double vmmVal) const
{
	return VLG2DV(mm2lg(vmmVal));
} // CFCCtlBrVRuler::VMM2DV.

double CFCCtlBrVRuler::DV2VMM (long dvVal) const
{
	return lg2mm(DV2VLG(dvVal));
} // CFCCtlBrVRuler::DV2VMM.

long CFCCtlBrVRuler::TMM2DV (double tmmVal) const
{
	return VMM2DV(tmmVal + m_vmmBegin);
} // CFCCtlBrVRuler::TMM2DV.

double CFCCtlBrVRuler::DV2TMM (long dvVal) const
{
	return DV2VMM(dvVal) - m_vmmBegin;
} // CFCCtlBrVRuler::DV2TMM.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrVRuler::DrawTextRange
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiDeHiDgGiDeCiDgCiDgHiDiCiBfLiDgIiOjOiCmMiDiLiBfLiDiJiBfLiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.06 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCCtlBrVRuler::DrawTextRange (CDC* pDC)
{
	// CDC_xZkqqHx_iCpA_xHqqkZx_Auto_xZkqqHx_iCmFiDiJiDgCiDhGiBeCiDeOiDiKiDgCiDhGjFmPiNfIiCmJjBmOiJjOiClFiCmEiBeB_xHqqkZx_SaveDC_xZkqqHx_iCpAiOmAiNhDiBeC_xHqqkZx_
	FCAutoDC atDC(pDC, TRUE, 0, 0);

	long dvBegin = VMM2DV(m_vmmBegin);
	long dvEnd = VMM2DV(m_vmmEnd);

	// _xZkqqHx_iMlLiNnNiCmMiDeOiDiKiDgCiDhGiCmJiDiLiBfLiDiJiBfLjHmMiIoGiCpAiPgEiCmLiCmEjAnNjCoIiBeC_xHqqkZx_
	atDC.IntersectClipRect(&m_dvrctRuler);

	// CDC_xZkqqHx_iCmMiDeOiDiKiDgCiDhGiCpAjDlOiCoJiBeC_xHqqkZx_dvrctClip_xZkqqHx_iCmNiDgGiDgPiDeDiDfIiNmAjFfHiMgOiBeC_xHqqkZx_
	CRect dvrctClip;
	pDC->GetClipBox(&dvrctClip);

//----- 06.04.24 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	long	dvVal;
//	long	lC;
//	wchar_t	tcsBuf[200];
//	CSize	szText;
//	CRect	rctNewClip;
//----- 06.04.24 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 06.04.24 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDiLiBfLiDiJiBfLiDhNiDeFiDfIiDhNiBfLiDeKiBfLiCmMiDhJiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
//	atDC.SetPen(PS_SOLID, 0, g_pReg->GetOptiRegColor(FDCL_RULER_MMK));
//----- 06.04.24 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	//----- _xZkqqHx_jAjEjCgMjFfMiOkGjHhAiDhEiDeIiDjDiDgHiCmMjAnNjCoI_xHqqkZx_ -----
	FCAtFont font;
	g_pReg->InitRegFont(*font.Get(), FDFT_VRULER_DIGITS, 900);
	atDC.SetObject(font);
	//----- _xZkqqHx_jFlGiOjKjFgAiJoGiCmMjAeGiBjFiDiCiBfLiDgIiCpAjAnNjCoI_xHqqkZx_ -----
	atDC.SetTextColor(::g_pReg->GetOptiRegColor(FDCL_RULER_TEXT));
	atDC.SetBkMode(TRANSPARENT);

	//----- _xZkqqHx_jAkHiMmAjHmMiIoGiCpAjDgIjCnHiClH_xHqqkZx_ -----
	CRect	rtPaint;
	//----- _xZkqqHx_jAkHiMmAjHmMiIoGiPoDiCpAjDgIjCnHiClH_xHqqkZx_ -----
	FCAtBrush brOutside(::g_pReg->GetOptiRegColor(FDCL_RULER_DARK_FACE));
	rtPaint.SetRect(0, m_dvrctRuler.top, FD_RULER_WIDTH, dvBegin);
	rtPaint &= dvrctClip;
	if (!rtPaint.IsRectEmpty()) atDC.FillRect(rtPaint, brOutside);
	//----- _xZkqqHx_jAkHiMmAjHmMiIoGiJlKiCpAjDgIjCnHiClH_xHqqkZx_ -----
	rtPaint.SetRect(0, dvEnd, FD_RULER_WIDTH, m_dvrctRuler.bottom);
	rtPaint &= dvrctClip;
	if (!rtPaint.IsRectEmpty()) atDC.FillRect(rtPaint, brOutside);
	//----- _xZkqqHx_jAkHiMmAjHmMiIoGiCpAjDgIjCnHiClH_xHqqkZx_ -----
	rtPaint.SetRect(0, dvBegin, FD_RULER_WIDTH, dvEnd);
	rtPaint &= dvrctClip;
//----- 06.04.24 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if (!rtPaint.IsRectEmpty())
//		atDC.FillRect(rtPaint, FCAtBrush(::g_pReg->GetOptiRegColor(FDCL_RULER_LIGHT)));
//----- 06.04.24 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	if (!rtPaint.IsRectEmpty())
		atDC.FillRect(rtPaint, FCAtBrush(::g_pReg->GetOptiRegColor(FDCL_RULER_FACE)));
//----- 06.04.24 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

//----- 06.04.24 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	//----- _xZkqqHx_iDiLiBfLiDiJiBfLiCmMiNlGjFjEiCmMiNgBiCpAjFgAiJoG_xHqqkZx_ -----
	// _xZkqqHx_iNgBiCmMiMpFjFjEjFkKiCpAjFgAiJoGiBeC_xHqqkZx_
	atDC.SetPen(PS_SOLID, 0, ::g_pReg->GetOptiRegColor(FDCL_RULER_SHADOW));
	atDC.MoveTo(m_dvrctRuler.left, m_dvrctRuler.top);
	atDC.LineTo(m_dvrctRuler.left, m_dvrctRuler.bottom);
	// _xZkqqHx_iNgBiCmMiJgFjFjEjFkKiCpAjFgAiJoGiBeC_xHqqkZx_
	atDC.SetPen(PS_SOLID, 0, ::g_pReg->GetOptiRegColor(FDCL_RULER_LIGHT));
	atDC.MoveTo(m_dvrctRuler.left + 1, m_dvrctRuler.top);
	atDC.LineTo(m_dvrctRuler.left + 1, m_dvrctRuler.bottom);
	//----- _xZkqqHx_iNjFjAeGiBeBjFjNiCePiCmMiDhJiDjDiCpAjAnNjCoI_xHqqkZx_ -----
	atDC.SetPen(PS_SOLID, 0, ::g_pReg->GetOptiRegColor(FDCL_RULER_MMK));
//----- 06.04.24 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	//----- _xZkqqHx_iDhDiDgCiDgA_xHqqkZx_0_xZkqqHx_iCmMjGnKjAlHiCmMjFfMiOkG_xHqqkZx_ -----
	long lC = static_cast<long>(DV2TMM(dvrctClip.top) / m_mmPitch0) - 1;
	for (;; lC++)
	{
		long dvVal = TMM2DV(lC * m_mmPitch0);
		if (dvrctClip.bottom < dvVal) break;
//----- 06.04.24 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		atDC.MoveTo(0, dvVal);
//		atDC.LineTo(3, dvVal);
//----- 06.04.24 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		atDC.MoveTo(FD_RULER_TOP, dvVal);
		atDC.LineTo(FD_RULER_TOP + 3, dvVal);
//----- 06.04.24 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		atDC.MoveTo(FD_RULER_WIDTH  - 3, dvVal);
		atDC.LineTo(FD_RULER_WIDTH, dvVal);
	}

	//----- _xZkqqHx_iDhDiDgCiDgA_xHqqkZx_1_xZkqqHx_iCmMjGnKjAlHiCmGjAjEjCgMiCmMjFfMiOkG_xHqqkZx_ -----
	lC = static_cast<long>(DV2TMM(dvrctClip.top) / m_mmPitch1) - 1;
	double dFig = 1.0;
	if (m_nZoomFig != 0) dFig = pow(10.0, m_nZoomFig);
	for (;; lC++)
	{
		long dvVal = TMM2DV(lC * m_mmPitch1);
		wchar_t tcsBuf[200];
		_i64tow10fig(D2LL(mm2hi(lC * m_mmPitch1) / dFig), tcsBuf, m_nZoomFig);
		CSize szText = atDC.GetTextExtent(tcsBuf, wcslen(tcsBuf));
		if (dvrctClip.bottom < dvVal - szText.cx / 2) break;
		atDC.MoveTo(FD_RULER_WIDTH - 6, dvVal);
		atDC.LineTo(FD_RULER_WIDTH, dvVal);
// 06.04.24 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		atDC.TextOut(0, dvVal + szText.cx / 2, tcsBuf, wcslen(tcsBuf), CP_ACP);
		atDC.TextOut(FD_RULER_TOP, dvVal + szText.cx / 2, tcsBuf, wcslen(tcsBuf), CP_ACP);
	}
} // CFCCtlBrVRuler::DrawTextRange.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrVRuler::CalcFixedLayout
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiMiDeDiDeBiDeFiDgHiMiIjCoIiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.05.06 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
CSize CFCCtlBrVRuler::CalcFixedLayout (BOOL bStretch, BOOL bHorz)
{
//	ASSERT(!bHorz);
	CSize szThis = CControlBar::CalcFixedLayout(bStretch, bHorz);
	if (!bHorz)
		szThis.cx = FD_RULER_WIDTH;

	return szThis;
} // CFCCtlBrVRuler::CalcFixedLayout.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrVRuler::OnUpdateCmdUI
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIjHeMiMpIjAkLiCmMiPiIjHjNiKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iPiIjHjNiCkKjGlDiCkNiCmEiCoAiLeMiPhBiCkKjFeLjHhGiBeCiPoDiImKjCiKiPnLiDeOiDiJiDfIiCmJiLpDiCmMiKnGjAjEiCmGiClFiCmE_xHqqkZx_
 *			_xZkqqHx_jCoIiLgAiClDiCoKiCmEiCkCiCoJiClNiCnPiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.05.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCCtlBrVRuler::OnUpdateCmdUI (CFrameWnd* /*pTarget*/, BOOL /*bDisableIfNoHndler*/)
{
} // CFCCtlBrVRuler::OnUpdateCmdUI.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrVRuler::DoPaint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNmEjFgAiJoGiCpAiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.02.19 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCCtlBrVRuler::DoPaint (CDC* pDC)
{
	// _xZkqqHx_iNiPiCnNiCkKjAnNjCoIiClDiCoKiCmEiCkCiCmIiCkPiCoKiCmOjFjMiLeBiBeC_xHqqkZx_
	if (almost0(m_mmPitch0) || almost0(m_mmPitch1)) return;

	// CDC_xZkqqHx_iCpA_xHqqkZx_Auto_xZkqqHx_iCmFiDiJiDgCiDhGiBeCiDeOiDiKiDgCiDhGjFmPiNfIiCmJjBmOiJjOiClFiCmEiBeB_xHqqkZx_SaveDC_xZkqqHx_iCpAiOmAiNhDiBeC_xHqqkZx_
	FCAutoDC atDC(pDC, TRUE, 0, 0);

	//----- _xZkqqHx_jFlGiOjKjFgAiJoGiCmMjAeGiBjFiDiCiBfLiDgIiCpAjAnNjCoI_xHqqkZx_ -----
	atDC.SetTextColor(::g_pReg->GetOptiRegColor(FDCL_RULER_TEXT));
	atDC.SetBkMode(TRANSPARENT);
	//----- _xZkqqHx_jCfAiImKjFfMiOkGiPiIjHjN_xHqqkZx_ -----
	// CDC_xZkqqHx_iCmMiDeOiDiKiDgCiDhGiCpAjDlOiCoJiBeC_xHqqkZx_dvrctClip_xZkqqHx_iCmNiDgGiDgPiDeDiDfIiNmAjFfHiMgOiBeC_xHqqkZx_
	CRect dvrctClip;
	pDC->GetClipBox(&dvrctClip);
	// _xZkqqHx_jCfAiImKjFfMiOkGjHmMiIoGiCmGiCmMiPgEiCmIiCoIiCmMjHmMiIoGiCpAiMhGiOfKiBeC_xHqqkZx_
	dvrctClip &= CRect(0, 0, m_dvrctRuler.right, m_dvrctRuler.top);
	if (!dvrctClip.IsRectEmpty())
	//----- _xZkqqHx_jFgAiJoGjHmMiIoGiCmGjCfAiImKjFfMiOkGjHmMiIoGiCmGiCmMiPgEiCmIiCoIiCmMjHmMiIoGiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		//----- _xZkqqHx_iDiLiBfLiDiJiBfLiCmMiNlGjFjEiCmMiNgBiCpAjFgAiJoG_xHqqkZx_ -----
//----- 06.04.24 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//		// _xZkqqHx_iNgBiCmMiJgFjFjEjFkKiCpAjFgAiJoGiBeC_xHqqkZx_
//		atDC.SetPen(PS_SOLID, 0, ::g_pReg->GetOptiRegColor(FDCL_RULER_SHADOW));
//		atDC.MoveTo(0, m_dvrctRuler.top);
//		atDC.LineTo(0, 0);
//		atDC.LineTo(m_dvrctRuler.right, 0);
//----- 06.04.24 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//----- 06.04.24 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		// _xZkqqHx_jEhHiMgJiCpAjDgIiCoIiCmCiCnEiClFiBeC_xHqqkZx_
		atDC.FillRect(dvrctClip, FCAtBrush(::g_pReg->GetOptiRegColor(FDCL_RULER_UNIT_FACE)));

		// _xZkqqHx_iNgBiCmMiMpFjFjEjFkKiCpAjFgAiJoGiBeC_xHqqkZx_
		atDC.SetPen(PS_SOLID, 0, ::g_pReg->GetOptiRegColor(FDCL_RULER_LIGHT));
		atDC.MoveTo(1, m_dvrctRuler.top);
		atDC.LineTo(1, 1);
		atDC.LineTo(m_dvrctRuler.right, 1);
		atDC.MoveTo(0, m_dvrctRuler.top - 1);
		atDC.LineTo(m_dvrctRuler.right - 1, m_dvrctRuler.top - 1);
		atDC.LineTo(m_dvrctRuler.right - 1, 0);

		// _xZkqqHx_iNgBiCmMiJgFjFjEjFkKiCpAjFgAiJoGiBeC_xHqqkZx_
		atDC.SetPen(PS_SOLID, 0, ::g_pReg->GetOptiRegColor(FDCL_RULER_SHADOW));
		atDC.MoveTo(0, m_dvrctRuler.top);
		atDC.LineTo(0, 0);
		atDC.LineTo(m_dvrctRuler.right, 0);
		atDC.MoveTo(0, m_dvrctRuler.top - 2);
		atDC.LineTo(m_dvrctRuler.right - 2, m_dvrctRuler.top - 2);
		atDC.LineTo(m_dvrctRuler.right - 2, 0);
//----- 06.04.24 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

		//----- _xZkqqHx_jCfAiImKjFfMiOkGjHhAiDhEiDeIiDjDiDgHiCmMjAnNjCoIiBgJjAiFjFlNiDiLiBfLiDiJiBfLiCmMiDhEiDeIiDjDiDgHiCpAiOgHjHhAiBgK_xHqqkZx_ -----
		FCAtFont fontUnit;
		g_pReg->InitRegFont(*fontUnit.Get(), FDFT_HRULER_DIGITS, 0);
		atDC.SetObject(fontUnit);
		// _xZkqqHx_jCfAiImKiCpAjFfMiOkGiBeC_xHqqkZx_
		atDC.TextOut(FD_RULER_TOP, FD_RULER_TOP, g_pReg->GetUnitString(), wcslen(g_pReg->GetUnitString()), CP_ACP);
	}

//----------<NOT EXPORT TO VIEWER>-----------
	if (m_wndpTarget != NULL)
	//----- _xZkqqHx_iDgFiDeMiDfIiDgHiDiCiBfLiDgIiCmMiPoKiNiHiCmMiPiIjHjN_xHqqkZx_ -----
	{
		DrawTextRange(pDC);
		return;
	}
//----------</NOT EXPORT TO VIEWER>-----------

	//----- CFCDynamicDrawView_xZkqqHx_iCmM_xHqqkZx_CDC_xZkqqHx_iCpAiOgHiCkEjFjEjFgJjDjJiCmMjFgAiJoGiCmGiIoBiCkCiBeBjFgAiJoGjGlNjHnPiCmN_xHqqkZx_
	//		_xZkqqHx_iDgGiDgPiDeDiDfIiNmAjFfHiCmFiNhDiCkEiBeCiClBiCmMiDeOiDiJiDfIiCmFjIfPjHjNiNmAjFfHiCmGiMlOiCkEiCmMiCmN_xHqqkZx_
	//		_xZkqqHx_jAlDiKgNiCmJiCmN_xHqqkZx_CFCDynamicDrawView_xZkqqHx_iCmM_xHqqkZx_X_xZkqqHx_iNmAjFfHiCmMjIfPjHjNiNmAjFfHiCmGiCkCiCkEiClBiCmG_xHqqkZx_	-----

	//----- _xZkqqHx_jAjEjCgMjFfMiOkGjHhAiDhEiDeIiDjDiDgHiCmMjAnNjCoI_xHqqkZx_ -----
	FCAtFont font;
	g_pReg->InitRegFont(*font.Get(), FDFT_VRULER_DIGITS, 900);
	atDC.SetObject(font);

	// _xZkqqHx_iMlLiNnNiCmMiDeOiDiKiDgCiDhGiCmJiDiLiBfLiDiJiBfLjHmMiIoGiCpAiPgEiCmLiCmEjAnNjCoIiBeC_xHqqkZx_
	atDC.IntersectClipRect(&m_dvrctRuler);
	// CDC_xZkqqHx_iCmMiDeOiDiKiDgCiDhGiCpAjDlOiCoJiBeC_xHqqkZx_dvrctClip_xZkqqHx_iCmNiDgGiDgPiDeDiDfIiNmAjFfHiMgOiBeC_xHqqkZx_
	pDC->GetClipBox(&dvrctClip);

//----- 06.04.24 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	//----- _xZkqqHx_iNjFjAeGiBeBjFjNiCePiCmMiDhJiDjDiCpAjAnNjCoI_xHqqkZx_ -----
//	atDC.SetPen(PS_SOLID, 0, ::g_pReg->GetOptiRegColor(FDCL_RULER_MMK));
//----- 06.04.24 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 06.04.24 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	long	dvVal;
//	long	lC;
//	wchar_t	tcsBuf[200];
//	CSize	szText;
//----- 06.04.24 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_jFgAiJoGjHmMiIoGiCpAjGlOiCoJiCkCjEhHiMgJjAeGiCmFjDgIjCnHiClHiBeC_xHqqkZx_
// 06.04.24 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	atDC.FillRect(dvrctClip, FCAtBrush(::g_pReg->GetOptiRegColor(FDCL_RULER_LIGHT)));
	atDC.FillRect(dvrctClip, FCAtBrush(::g_pReg->GetOptiRegColor(FDCL_RULER_FACE)));

//----- 06.04.23 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	//----- _xZkqqHx_iDiLiBfLiDiJiBfLiCmMiNlGjFjEiCmMiNgBiCpAjFgAiJoG_xHqqkZx_ -----
	// _xZkqqHx_iNgBiCmMiJgFjFjEjFkKiCpAjFgAiJoGiBeC_xHqqkZx_
	atDC.SetPen(PS_SOLID, 0, ::g_pReg->GetOptiRegColor(FDCL_RULER_SHADOW));
	atDC.MoveTo(m_dvrctRuler.left, m_dvrctRuler.top);
	atDC.LineTo(m_dvrctRuler.left, m_dvrctRuler.bottom);
	// _xZkqqHx_iNgBiCmMiMpFjFjEjFkKiCpAjFgAiJoGiBeC_xHqqkZx_
	atDC.SetPen(PS_SOLID, 0, ::g_pReg->GetOptiRegColor(FDCL_RULER_LIGHT));
	atDC.MoveTo(m_dvrctRuler.left + 1, m_dvrctRuler.top);
	atDC.LineTo(m_dvrctRuler.left + 1, m_dvrctRuler.bottom);
	//----- _xZkqqHx_iNjFjAeGiBeBjFjNiCePiCmMiDhJiDjDiCpAjAnNjCoI_xHqqkZx_ -----
	atDC.SetPen(PS_SOLID, 0, ::g_pReg->GetOptiRegColor(FDCL_RULER_MMK));
//----- 06.04.23 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

//----- 06.04.24 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	if (m_bDrawBorder)
//	//----- _xZkqqHx_iDhLiBfLiDfPiBfLjApMiCpAjFgAiJoGiClHiCoJiCkJiBeI_xHqqkZx_ -----
//	{
//		atDC.MoveTo(m_dvrctRuler.right - 1, m_dvrctRuler.top);
//		atDC.LineTo(m_dvrctRuler.right - 1, m_dvrctRuler.bottom);
//	}
//----- 06.04.24 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	//----- _xZkqqHx_iDiLiBfLiDiJiBfLiCmMiNiPiCnNiCmMiNmFiPiJiCmMiImKjChFiCpAiLiBiCnPiCoJ_xHqqkZx_ ------
	long lC = static_cast<long>(DV2VMM(dvrctClip.top) / m_mmPitch0) - 1;
	for (;; lC++)
	{
		long dvVal = VMM2DV(lC * m_mmPitch0);
		if (dvrctClip.bottom < dvVal) break;
		atDC.MoveTo(FD_RULER_WIDTH - 3, dvVal);
		atDC.LineTo(FD_RULER_WIDTH, dvVal);
	}

	//----- _xZkqqHx_iDiLiBfLiDiJiBfLiCmMiNiPiCnNiCmMiNmFiPiJiCmMiImKjChFiCpAiLiBiCnPiCoJ_xHqqkZx_ ------
	lC = static_cast<long>(DV2VMM(dvrctClip.top) / m_mmPitch1) - 1;
	double dFig = 1.0;
	if (m_nZoomFig != 0) dFig = pow(10.0, m_nZoomFig);
	for (;; lC++)
	{
		long dvVal = VMM2DV(lC * m_mmPitch1);
		wchar_t tcsBuf[200];
		_i64tow10fig(D2LL(mm2hi(lC * m_mmPitch1) / dFig), tcsBuf, m_nZoomFig);
		CSize szText = atDC.GetTextExtent(tcsBuf, wcslen(tcsBuf));
		if (dvrctClip.bottom < dvVal - szText.cx / 2) break;
		atDC.MoveTo(FD_RULER_WIDTH - 6, dvVal);
		atDC.LineTo(FD_RULER_WIDTH, dvVal);
// 06.04.24 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		atDC.TextOut(0, dvVal + szText.cx / 2, tcsBuf, wcslen(tcsBuf), CP_ACP);
		atDC.TextOut(FD_RULER_TOP, dvVal + szText.cx / 2, tcsBuf, wcslen(tcsBuf), CP_ACP);
	}

	//----- _xZkqqHx_iDiLiBfLiDiJiBfLiDhNiDeFiDfIiDhNiBfLiDeKiBfLjFfMiOkGjHhAiPeDjAlDjApMjFgAiJoGjHhAiDeOiDiJiDfIiCpAiNoMjAkM_xHqqkZx_ -----
	// _xZkqqHx_iDiLiBfLiDiJiBfLiDhNiDeFiDfIiDhNiBfLiDeKiBfLjAeGiCmGiDiLiBfLiDiJiBfLjGlOiCoJiCkCjAeGiCmMjEhCjBlMjAeGiCpAiOhHjCoIiBeC_xHqqkZx_
	FCEditDraw eDraw(pDC, 0, g_pReg->GetOptiRegColor(FDCL_RULER_MMK) ^
								g_pReg->GetOptiRegColor(FDCL_RULER_LIGHT), -1, 0, 0);

	short	nIndex;
	for (nIndex = 0; nIndex < FD_RULER_MMK_MAX; nIndex++)
	{
		if (m_baIsRulerMMKVisible[nIndex])
		/****** _xZkqqHx_iDiLiBfLiDiJiBfLiDhNiDeFiDfIiDhNiBfLiDeKiBfLiCmNjFfMiOkGiPpDjBnE_xHqqkZx_ ******/
		{
			//----- _xZkqqHx_iDiLiBfLiDiJiBfLiDhNiDeFiDfIiDhNiBfLiDeKiBfLiCpAjFgAiJoG_xHqqkZx_ -----
// 06.04.24 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//			eDraw.Line(	&CPoint(0, VLG2DV(m_lgaRulerMMK[nIndex])),
			eDraw.Line(	&CPoint(FD_RULER_TOP, VLG2DV(m_lgaRulerMMK[nIndex])),
						&CPoint(FD_RULER_WIDTH, VLG2DV(m_lgaRulerMMK[nIndex])));
		}
	}
	// Do not call CControlBar::OnPaint() for painting messages
} // CFCCtlBrVRuler::DoPaint

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrVRuler::OnShowWindow
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCmMjFfMiOkGiPpDjBnEiCkKjFmPiNfIiClDiCoKiClNiCmGiCkLiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bShow	:_xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCpAjFfMiOkGiClHiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiClFiCnMiClHiBeC_xHqqkZx_
 *					 _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCpAjFfMiOkGiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAiBeBjEpBjFfMiOkGiCmJiClHiCoJ_xHqqkZx_
 *					 _xZkqqHx_iPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAiOhHjCoIiClFiCnMiClHiBeC_xHqqkZx_
 *			nStatus	:_xZkqqHx_jFfMiOkGiClHiCoJiDeFiDeCiDjDiDgIiDeFiCmMiPpDjBnEiCpAiOhHjCoIiClFiCnMiClHiBeC_xHqqkZx_
 *					 ShowWindow _xZkqqHx_iDiBiDjDiDgPiKnGjAjEiCkKiMmEiCnBiPgPiClDiCoKiBeBiDiBiDgCiDfKiBfLiDfHiCkK_xHqqkZx_
 *					 _xZkqqHx_jBjHiCoHiCoKiCoJiPoKiNiHiCmN_xHqqkZx_ 0 _xZkqqHx_iCmJiCmIiCoIiCnMiClHiBeC_xHqqkZx_
 *					 _xZkqqHx_iClLiCoKiImIiKePiCmMiPoKiNiHiCmNiBeB_xHqqkZx_nStatus _xZkqqHx_iCmNiOjPiCmMjCgMiCmMiCkCiClIiCoKiCkJiCmJiCmIiCoIiCnMiClHiBeC_xHqqkZx_ 
 *				SW_PARENTCLOSING	:_xZkqqHx_jAgFiDeFiDeCiDjDiDgIiDeFiCkKiDeOiDiNiBfLiDfJ_xHqqkZx_ (_xZkqqHx_iDeBiDeDiDfCiDjDiJlL_xHqqkZx_) 
 *									 _xZkqqHx_iClDiCoKiCoJiCkJiBeBiDhMiDgCiDhGiDeBiDgCiDhG_xHqqkZx_ _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCkK_xHqqkZx_
 *									 _xZkqqHx_jEpBjFfMiOkGiCmJiCmIiCoIiCnMiClHiBeC_xHqqkZx_
 *				SW_PARENTOPENING	:_xZkqqHx_jAgFiDeFiDeCiDjDiDgIiDeFiCkKiDeJiBfLiDhGiDjD_xHqqkZx_ (_xZkqqHx_jFfMiOkG_xHqqkZx_) _xZkqqHx_iClDiCoKiCoJiCkJiBeB_xHqqkZx_
 *									 _xZkqqHx_iDhMiDgCiDhGiDeBiDgCiDhG_xHqqkZx_ _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCkKjFfMiOkGiClDiCoKiCnMiClHiBeC_xHqqkZx_ 
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.07.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCCtlBrVRuler::OnShowWindow (BOOL bShow, UINT nStatus)
{
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	CControlBar::OnShowWindow(bShow, nStatus);
	// _xZkqqHx_jChOjAmPiClDiCoKiCmEiCkCiCoJiDiBiDgCiDfKiBfLiDfHiCpAiPiIjHjNiBeC_xHqqkZx_
// 03.07.17 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	if (bShow) FFNotifyPendingMessage();
	FFNotifyPendingMessage(this, bShow);
} // CFCCtlBrVRuler::OnShowWindow.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrVRuler::OnUserUpdateRuler
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiLiBfLiDiJiBfLiCmMjFfMiOkGiCpAiNfIjAfGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wParam	:_xZkqqHx_jGkCiOgHjHhAiBeC_xHqqkZx_
 *			lParam	:_xZkqqHx_jGkCiOgHjHhAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPoNiCmJiCfAiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	CView_xZkqqHx_iCmMiDfEiDeDiDfJiCkKjFmPiNfIiClDiCoKiClNiOjOiBeBiDfEiDeDiDfJiCpAjDoAjFjEjFmPjAjEiCmJiOoGiCoIiNjOiCnOiBeC_xHqqkZx_
 *			CFCDynamicDrawView::UpdateScrollSize_xZkqqHx_iKnGjAjEjDjJiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.07.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
LRESULT CFCCtlBrVRuler::OnUserUpdateRuler (WPARAM wParam, LPARAM lParam)
{
	if (g_pView != NULL)
	{
		// View_xZkqqHx_iCmMjHmMiIoGiCpAjIfPjHjNiNmAjFfHiCmFiOoGjDlOiBeC_xHqqkZx_
		g_pView->GetClientRectLG(m_dvrctRuler);
		// View_xZkqqHx_iCmMjIfPjHjNiNmAjFfHiCmMjFkIjHjNiNmAjFfHiCmJjBmOiClHiCoJiDeJiDhEiDfKiDgCiDgHjCgMiCpAiMhGiOfKiBeC_xHqqkZx_
		m_dvOffset = m_dvrctRuler.top;
		// View_xZkqqHx_iCmMjHmMiIoGiCpAjFkIjHjNiNmAjFfHiCmJjFmPiKlHiBeC_xHqqkZx_
		m_dvrctRuler.top = 0;
		m_dvrctRuler.bottom -= m_dvOffset;
		// View_xZkqqHx_iCmMjHmMiIoGiCpAiBeBiClBiCmMiDiLiBfLiDiJiBfLiCmFiCmMjFkIjHjNiNmAjFfHiCmJjFmPiKlHiBeC_xHqqkZx_
		g_pView->ClientToScreen(&m_dvrctRuler);
		ScreenToClient(&m_dvrctRuler);
		// m_dvrctRuler_xZkqqHx_iCpAiBeBiDiLiBfLiDiJiBfLiCmMiDhCiDiFiBfLjEmNiImNiCmMjDgIiCoIiCmCiCnEiClFjHmMiIoGiCmJiBeC_xHqqkZx_
		m_dvrctRuler.left = 0;
		m_dvrctRuler.right = FD_RULER_WIDTH;
	}

	//----- Scale_xZkqqHx_iKnGiMfHiPiJiKpKiJlL_xHqqkZx_ -----

	//----- _xZkqqHx_jIfPjHjNiNmAjFfHiCkK_xHqqkZx_20pixel_xZkqqHx_jCpGjDhIiCmJiCmIiCoJiCoGiCkEiCmJiBeBiDhDiDgCiDgAiCpAjClCjAkO_xHqqkZx_ -----
	// 20pixel_xZkqqHx_iCpA_xHqqkZx_HI_xZkqqHx_iNmAjFfHiCmJjFmPiKlHiBeC_xHqqkZx_
	hic hiPitch = lg2hi(20);
	//----- HI_xZkqqHx_iNmAjFfHjCgMiCpAiBeB_xHqqkZx_a * 10^b (1 <= a < 10) _xZkqqHx_iCmJjFmPiKlH_xHqqkZx_ -----
	double b = log10(hiPitch);
	if (0 < b)
	{
		b = int(b);
	} else
	{
		if ((b - int(b)) != 0.0)
			b = int(b) - 1.0;
	}
	double p = pow(10.0, b);
	double a = hiPitch / p;
	//----- a _xZkqqHx_iCpA_xHqqkZx_1.0,2.5,5.0,10.0_xZkqqHx_iCmMiCkCiClIiCoKiCkJiLnPiCkCjCgMiCmJjFfHiPiAiJlL_xHqqkZx_ -----
	double ra = 1.0;
	double dif = fabs(a - ra);
	// _xZkqqHx_iDhDiDgCiDgAiCfAiCmMiPkMjAjEjDfPiImIiJlKiCmMiMiFjAjEiBeC_xHqqkZx_0.1 _xZkqqHx_iCmIiCoHiCmO_xHqqkZx_ -1_xZkqqHx_iBeC_xHqqkZx_
	short nZoomFigure = b + 1.0;
	if (fabs(a - 2.5) < dif)
	{
		ra = 2.5;
		dif = fabs(a - ra);
		nZoomFigure = b;
	}
	if (fabs(a - 5.0) < dif)
	{
		ra = 5.0;
		dif = fabs(a - ra);
		nZoomFigure = b + 1.0;
	}
	if (fabs(a - 10.0) < dif)
	{
		ra = 10.0;
		dif = fabs(a - ra);
		nZoomFigure = b + 2.0;
	}
	if (0 < nZoomFigure) nZoomFigure = 0;
	// Scale_xZkqqHx_iCmMiNnHiCkJiCkCiNiPiCnNjFjNiBeC_xHqqkZx_
	mmetol mmScalePitch0 = hi2mm(ra * p);
	// Scale_xZkqqHx_iCmMjBlOiCkCiNiPiCnNjFjNiBeC_xHqqkZx_
	mmetol mmScalePitch1 = 10.0 * mmScalePitch0;
	// _xZkqqHx_iDhDiDgCiDgAiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
	SetPitch(mmScalePitch0, mmScalePitch1, nZoomFigure);
	// _xZkqqHx_iNmEjFgAiJoGiBeC_xHqqkZx_
	Invalidate();

	return 1;
} // CFCCtlBrVRuler::OnUserUpdateRuler.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrVRuler::OnUserPursuerTextNeedInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhMiDgCiDhGiDhBiDjDiDgHiCkKiDhBiDjDiDgHiPoOjFpBiCmMjAnNjCoIiCpAjHhGiLiBiClHiCoJiNnLiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wParam	:_xZkqqHx_iDhNiDeFiDfIiImKjChFiCmMiDeFiDeCiDjDiDgIiDeFiDgOiDjDiDgIiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_jFeLiClIiBeB_xHqqkZx_GetCursorPos_xZkqqHx_iKnGjAjEiCmFiDhNiDeFiDfIiImKjChFiCpAiOoGjDlOiClHiCoJiClBiCmGiBeC_xHqqkZx_
 *			_xZkqqHx_iDhNiDeFiDfIiNmAjFfHiCkK_xHqqkZx_WM_MOUSEMOVE_xZkqqHx_iCmJjHiKiCmBiCmEiCkCiCoJiCmGiBeBiDiBiDgKiDiFiBfLjFfMiOkGiOjOiCmIiCmHiCmJ_xHqqkZx_
 *			_xZkqqHx_iDhNiDeFiDfIiImKjChFiCkKiMlLiNnNiCmMiImKjChFiCmGjAeIiCkCiIoBiCmBiCmEiCkCiCoJiPoKiNiHiCkKiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jCmHjAnFiDhBiDjDiDgHiCmNiBeBiDhNiDeFiDfIiImKjChFiCmMiDeFiDeCiDjDiDgIiDeFiCpAjClCiCnHiBeBiCnMiClIiClLiCmMiDeFiDeCiDjDiDgIiDeFiCnG_xHqqkZx_
 *			WM_USER_PURSUER_TEXT_NEED_INFO_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCpA_xHqqkZx_SendMessage_xZkqqHx_iCmFjBjHjFhEiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDiBiDgCiDfKiBfLiDfHjGnPiCoIjCgMiCkKiCePiCmMiPoKiNiHiCmNiBeBiClLiCmMiDeFiDeCiDjDiDgIiDeFiCmMjAgFiDeFiDeCiDjDiDgIiDeFiCnG_xHqqkZx_
 *			_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCpAjBjHjFhEiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jGnPiCoIjCgMiCkKiCePiImIiKePiCmFiCkAiCoJiCkJjAgFiDeFiDeCiDjDiDgIiDeFiCkKjGlDiCkNiCmIiCoJiCnMiCmFiClBiCoKiCpAiMeKiCoIjFnEiClHiBeC_xHqqkZx_
 *			wParam _xZkqqHx_iCmJiCmNiBeBiNmFiPiJiCmJiDiBiDgCiDfKiBfLiDfHiCpAjBjHjFhEiClFiClNiDeFiDeCiDjDiDgIiDeFiCkKiOhHjCoIiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
LRESULT CFCCtlBrVRuler::OnUserPursuerTextNeedInfo (WPARAM wParam, LPARAM)
{
	if (g_pReg->GetIsPopupHint() && g_pReg->GetIsPopupRulerHint())
	//----- _xZkqqHx_iDhMiDgCiDhGiDeBiDgCiDhGiCpAjFfMiOkGiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDhNiDeFiDfIiDeKiBfLiDfMiDiLiCmMiMlLiNnNiCmMiImKjChFiCpAiBeBiDfIiDeOiDiKiBfLiDjDiNmAjFfHiCmFiOoGjDlOiBeC_xHqqkZx_
		CPoint dvptMouse;
		(void)::GetCursorPos(&dvptMouse);
		// _xZkqqHx_iDeOiDiJiDeDiDeBiDjDiDgHiNmAjFfHiCmJjFmPiKlHiBeC_xHqqkZx_
		ScreenToClient(&dvptMouse);
		if (CRect(0, 0, m_dvrctRuler.right, m_dvrctRuler.top).PtInRect(dvptMouse))
		//----- _xZkqqHx_jCfAiImKjFfMiOkGjFjEjFkKiCmMiPoKiNiH_xHqqkZx_ -----
		{
			FFGetApp()->GetPopHint()->SetTargetInfo(ID_WND_RULER_UNIT);
		} else
		//----- _xZkqqHx_iDiLiBfLiDiJiBfLjFjEjFkKiCmMiPoKiNiH_xHqqkZx_ -----
		{
			FFGetApp()->GetPopHint()->SetTargetInfo(GetDlgCtrlID());
		}
	}
	return 1;
} // CFCCtlBrVRuler::OnUserPursuerTextNeedInfo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrVRuler::OnWindowPosChanged
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCmMiImKjChFiBeFiDfEiDeDiDfJjDjJiCkKjFmPiNfIiClDiCoKiClNiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lpwndpos	:_xZkqqHx_iImKjChFiPoOjFpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	_xZkqqHx_iDgDiBfLiDiLiDgPiBfLiCpAiInKjDkOiClFiCmEiDhEiDiMiBfLiDiAiDiMiDeDiDeBiDeFiDgHiCkKjFmPiNfIiClDiCoKiClNiPoKiNiHiCpA_xHqqkZx_
 *			_xZkqqHx_iNgMiCkGiCoJiBeC_xHqqkZx_
 *			g_pFrame _xZkqqHx_iCmMiPoKiNiHiBeBiDiLiBfLiDiJiBfLiCkK_xHqqkZx_DynamicDrawView_xZkqqHx_iCoGiCoIiCoAjAoGiCmJiInKjDkOiBeF_xHqqkZx_
 *			_xZkqqHx_iDiKiDfEiDeDiDfJiClDiCoKiCoJiClNiCnPiBeB_xHqqkZx_DynamicDrawView_xZkqqHx_iCmMiInKjDkOiBeFiDiKiDfEiDeDiDfJiCmJiCoGiCmBiCmE_xHqqkZx_
 *			OnUserUpdateRuler _xZkqqHx_iCkKiMmEiCmOiCoKiClNiCmGiCkLiBeBjAlDiKgNiCmJiDhCiDiFiBfLiCmMiPoOjFpBiCpA_xHqqkZx_
 *			_xZkqqHx_iLeMjIfOiCmFiCkLiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iIoKjFpLiBeB_xHqqkZx_g_pInPlace _xZkqqHx_iCmMiPoKiNiHiBeBiDiLiBfLiDiJiBfLiCkK_xHqqkZx_DynamicDrawView_xZkqqHx_iCoGiCoIiCoAiMoDiCmJ_xHqqkZx_
 *			_xZkqqHx_iInKjDkOiBeFiDiKiDfEiDeDiDfJiClDiCoKiCoJiClNiCnPiBeB_xHqqkZx_DynamicDrawView_xZkqqHx_iCmMiInKjDkOiBeFiDiKiDfEiDeDiDfJiCmJ_xHqqkZx_
 *			_xZkqqHx_iCoGiCmBiCmE_xHqqkZx_ OnUserUpdateRuler _xZkqqHx_iCkKiMmEiCmOiCoKiClNiCmGiCkLiBeBjGkCiClOiDiLiBfLiDiJiBfLiCmN_xHqqkZx_
 *			_xZkqqHx_jAlDiClFiCkCiImKjChFiCmJiInKjDkOiClFiCmEiCkIiCoHiClIiBeBiDhCiDiFiBfLiCmMiPoOjFpBiCpAjAlDiClFiCkNiLeMjIfOiCmFiCkLiCmIiCkCiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiClNiCnPiBeBiDiLiBfLiDiJiBfLiCmM_xHqqkZx_OnWindowPosChanged_xZkqqHx_iKnGjAjEiCkJiCoHiCoA_xHqqkZx_
 *			OnUserUpdateRuler _xZkqqHx_iCpAiMmEiCnEjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.07.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCCtlBrVRuler::OnWindowPosChanged (WINDOWPOS FAR* lpwndpos)
{
	// Superclass_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
	BASE_CLASS::OnWindowPosChanged(lpwndpos);
	if (!(SWP_NOMOVE & lpwndpos->flags) || !(SWP_NOSIZE & lpwndpos->flags))
	//----- _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCmMiInKjDkOiBeFiDiKiDfEiDeDiDfJiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDiLiBfLiDiJiBfLiNfIjAfGiCmMiDiBiDgCiDfKiBfLiDfHiCpAjChOjAmPiBeC_xHqqkZx_
		FFPushPendingMessage(FCPendingMessage(FD_PMSG_MAIN_VRULER,
											WM_USER_UPDATE_RULER, NULL, NULL,
											TRUE,
											FD_PMSG_MAIN_VRULER|FD_PMSG_IF_VISIBLE,
											FD_PMSG_VIEW|FD_PMSG_IF_VISIBLE));
	}
} // CFCCtlBrVRuler::OnWindowPosChanged.
