#ifndef __DBLPoint_h
#define __DBLPoint_h

#include <math.h>	// For sqrt.

//;----- <EXPORT TO SDK> -----;

/**********************************************************************
 *                            DBLPoint
 **********************************************************************/
class DBLPoint
{
public:
	DBLPoint ();
	DBLPoint (double dX, double dY);
	DBLPoint (const POINT& cpt);

	void	SetPoint (double dX, double dY);
	void	SetPoint (const DBLPoint& dpt);
	void	SetPoint (const POINT& cpt);

	BOOL	IsNull () const;
	double	PowLen () const;
	double	Len () const;
// 05.05.09 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	BOOL	IsMostEqual (const DBLPoint& dpt) const;

	void operator *= (const double& d);
	void operator *= (const DBLPoint& pt);
	void operator /= (const double& d);
	void operator += (const DBLPoint& mmpt);
	void operator -= (const DBLPoint& mmpt);

	DBLPoint RotatePoint (double dSin, double dCos) const;

public:
	double	x;
	double	y;
}; // class DBLPoint.

inline DBLPoint operator - (const DBLPoint& point);

inline BOOL operator == (const DBLPoint& point, const DBLPoint& point1);
inline BOOL operator != (const DBLPoint& point, const DBLPoint& point1);

inline DBLPoint operator + (const DBLPoint& point, const DBLPoint& point1);
inline DBLPoint operator + (const DBLPoint& point, double d);
inline DBLPoint operator + (double d, const DBLPoint& point);

inline DBLPoint operator - (const DBLPoint& point, const DBLPoint& point1);
inline DBLPoint operator - (const DBLPoint& point, double d);
inline DBLPoint operator - (double d, const DBLPoint& point);

inline DBLPoint operator * (const DBLPoint& point, const DBLPoint& point1);
inline DBLPoint operator * (const DBLPoint& point, double d);
inline DBLPoint operator * (double d, const DBLPoint& point);

inline DBLPoint operator / (const DBLPoint& point, const DBLPoint& point1);
inline DBLPoint operator / (const DBLPoint& point, double d);
inline DBLPoint operator / (double d, const DBLPoint& point);

inline BOOL almostless (const DBLPoint& a, const DBLPoint& b);
inline BOOL almosteq (const DBLPoint& a, const DBLPoint& b);
inline BOOL almost0 (const DBLPoint& a);
inline BOOL abouteq (const DBLPoint& a, const DBLPoint& b);
inline BOOL about0 (const DBLPoint& a);
inline BOOL rougheq (const DBLPoint& a, const DBLPoint& b);
inline BOOL rough0 (const DBLPoint& a);

/**********************************************************************
 *                            DBLPoint
 **********************************************************************/
inline DBLPoint::DBLPoint () {}

inline DBLPoint::DBLPoint (double dX, double dY) : x(dX), y(dY) {}

inline DBLPoint::DBLPoint (const POINT& cpt) : x(cpt.x), y(cpt.y) {}

inline void DBLPoint::SetPoint (double dX, double dY)
{
	x = dX; y = dY;
} // DBLPoint::SetPoint.

inline void DBLPoint::SetPoint (const DBLPoint& dpt)
{
	x = dpt.x; y = dpt.y;
} // DBLPoint::SetPoint.

inline void DBLPoint::SetPoint (const POINT& cpt)
{
	x = cpt.x; y = cpt.y;
} // DBLPoint::SetPoint.

inline BOOL DBLPoint::IsNull () const
{
	return (x == 0.0 && y == 0.0);
} // DBLPoint::IsNull.

inline double DBLPoint::PowLen () const
{
	return x * x + y * y;
} // DBLPoint::PowLen.

inline double DBLPoint::Len () const
{
	return sqrt(x * x + y * y);
} // DBLPoint::Len.

//----- 05.05.09 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	DBLPoint::IsMostEqual
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iCfBjDfPiCkKiCnJiCnKjDjJiClFiCkCiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dpt	:_xZkqqHx_jClCiCnHiCoJjBmOiPnLiCmMjDfPiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iCnJiCnKjDjJiClFiCkCiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiClLiCkEiCmFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	FCObjWidePoly::OmitAxisPoly_xZkqqHx_iCmMiClNiCnPiCmJjDlBjDpMiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//inline BOOL DBLPoint::IsMostEqual (const DBLPoint& dpt) const
//{
//	return abouteq(x, dpt.x) && abouteq(y, dpt.y);
//} // DBLPoint::IsMostEqual.
//----- 05.05.09 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 98.10.19 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//inline BOOL DBLPoint::operator == (const DBLPoint& pt)
//{
//	return (x == pt.x) && (y == pt.y);
//}
//----- 98.10.19 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

inline void DBLPoint::operator *= (const double& d)
{
	x *= d;
	y *= d;
} // DBLPoint::operator *= .

inline void DBLPoint::operator *= (const DBLPoint& pt)
{
	x *= pt.x;
	y *= pt.y;
} // DBLPoint::operator *= .

inline void DBLPoint::operator /= (const double& d)
{
	x /= d;
	y /= d;
} // DBLPoint::operator /= .

inline void DBLPoint::operator += (const DBLPoint& mmpt)
{
	x += mmpt.x;
	y += mmpt.y;
} // DBLPoint::operator.

inline void DBLPoint::operator -= (const DBLPoint& mmpt)
{
	x -= mmpt.x;
	y -= mmpt.y;
} // DBLPoint::operator.

inline DBLPoint DBLPoint::RotatePoint (double dSin, double dCos) const
{
	return DBLPoint(x * dCos - y * dSin, x * dSin + y * dCos);
} // DBLPoint::RotatePoint.

inline BOOL operator == (const DBLPoint& point, const DBLPoint& point1)
{
	return (point.x == point1.x) && (point.y == point1.y);
} // operator == (const.

inline BOOL operator != (const DBLPoint& point, const DBLPoint& point1)
{
	return (point.x != point1.x) || (point.y != point1.y);
} // operator != (const.

inline DBLPoint operator - (const DBLPoint& point)
{
	return DBLPoint(-point.x, -point.y);
} // operator - (const.

inline DBLPoint operator + (const DBLPoint& point, const DBLPoint& point1)
{
	return DBLPoint(point.x + point1.x, point.y + point1.y);
} // operator + (const.

inline DBLPoint operator + (const DBLPoint& point, double d)
{
	return DBLPoint(point.x + d, point.y + d);
} // operator + (const.

inline DBLPoint operator + (double d, const DBLPoint& point)
{
	return DBLPoint(point.x + d, point.y + d);
} // operator + (double.

inline DBLPoint operator - (const DBLPoint& point, const DBLPoint& point1)
{
	return DBLPoint(point.x - point1.x, point.y - point1.y);
} // operator - (const.

inline DBLPoint operator - (const DBLPoint& point, double d)
{
	return DBLPoint(point.x - d, point.y - d);
} // operator - (const.

inline DBLPoint operator - (double d, const DBLPoint& point)
{
	return DBLPoint(d - point.x, d - point.y);
} // operator - (double.

inline DBLPoint operator * (const DBLPoint& point, const DBLPoint& point1)
{
	return DBLPoint(point.x * point1.x, point.y * point1.y);
} // operator * (const.

inline DBLPoint operator * (const DBLPoint& point, double d)
{
	return DBLPoint(point.x * d, point.y * d);
} // operator * (const.

inline DBLPoint operator * (double d, const DBLPoint& point)
{
	return DBLPoint(point.x * d, point.y * d);
} // operator * (double.

inline DBLPoint operator / (const DBLPoint& point, const DBLPoint& point1)
{
	return DBLPoint(point.x / point1.x, point.y / point1.y);
} // operator / (const.

inline DBLPoint operator / (const DBLPoint& point, double d)
{
	return DBLPoint(point.x / d, point.y / d);
} // operator / (const.

inline DBLPoint operator / (double d, const DBLPoint& point)
{
	return DBLPoint(d / point.x, d / point.y);
} // operator / (double.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	almostless
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	DBLPoint_xZkqqHx_iMfOiCmMiCfBjCgM_xHqqkZx_ a,b _xZkqqHx_iCkK_xHqqkZx_ _xZkqqHx_iCnJiCmGiCpBiCmH_xHqqkZx_ a < b _xZkqqHx_iCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *			_xZkqqHx_iCnJiCmGiCpBiCmHiCmGiMlOiCmBiCmEiCoAiBeB_xHqqkZx_a >= b _xZkqqHx_iCmNjHeMiCoIiCkGiCmIiCkCiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	a,b	:_xZkqqHx_jEoEiKhCiClHiCoJiCfBjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iCnJiCmGiCpBiCmH_xHqqkZx_ < _xZkqqHx_iCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	y_xZkqqHx_iNmAjFfHjCgMiCmMjBoFiPkMiCpAjEoEiKhCiClHiCoJiBeC_xHqqkZx_y_xZkqqHx_iNmAjFfHiCkKjDjJiClFiCkCiPoKiNiHiCmMiCnNiBeB_xHqqkZx_x_xZkqqHx_iNmAjFfHjCgMiCpAjEoEiKhCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline BOOL almostless (const DBLPoint& a, const DBLPoint& b)
{
	if (almostless(a.y, b.y)) return TRUE;
	if (almostless(b.y, a.y)) return FALSE;
	return almostless(a.x, b.x);
} // almostless (const DBLPoint& a, const DBLPoint& b).

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	almosteq
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	DBLPoint_xZkqqHx_iMfOiCmMiCfBjCgMiCkKiCnJiCmGiCpBiCmHjDjJiClFiCkCiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	a,b	:_xZkqqHx_jEoEiKhCiClHiCoJiCfBjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iCnJiCmGiCpBiCmHjDjJiClFiCkCiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjDjJiClFiCkNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline BOOL almosteq (const DBLPoint& a, const DBLPoint& b)
{
	return almosteq(a.x, b.x) && almosteq(a.y, b.y);
} // almosteq (const DBLPoint& a, const DBLPoint& b).

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	almost0
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	DBLPoint_xZkqqHx_iMfOjCgMiCkKiCnJiCmGiCpBiCmH_xHqqkZx_0_xZkqqHx_iCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	a	:_xZkqqHx_jEoEiKhCiClHiCoJjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iCnJiCmGiCpBiCmHjDjJiClFiCkCiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjDjJiClFiCkNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline BOOL almost0 (const DBLPoint& a)
{
	return almost0(a.x) && almost0(a.y);
} // almost0 (double x).

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	abouteq
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	DBLPoint_xZkqqHx_iMfOiCmMiCfBjCgMiCkKiClOiCkCiClNiCkCjDjJiClFiCkCiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	a,b	:_xZkqqHx_jEoEiKhCiClHiCoJiCfBjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iClOiCkCiClNiCkCjDjJiClFiCkCiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjDjJiClFiCkNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.10.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline BOOL abouteq (const DBLPoint& a, const DBLPoint& b)
{
	return abouteq(a.x, b.x) && abouteq(a.y, b.y);
} // abouteq (const DBLPoint& a, const DBLPoint& b).

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	about0
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	DBLPoint_xZkqqHx_iMfOjCgMiCkKiClOiCkCiClNiCkC_xHqqkZx_0_xZkqqHx_iCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	a	:_xZkqqHx_jEoEiKhCiClHiCoJjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iClOiCkCiClNiCkCjDjJiClFiCkCiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjDjJiClFiCkNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.10.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline BOOL about0 (const DBLPoint& a)
{
	return about0(a.x) && about0(a.y);
} // about0 (double x).

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	rougheq
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	DBLPoint_xZkqqHx_iMfOiCmMiCfBjCgMiCkKiCnMiCkAiCnMiCkAjDjJiClFiCkCiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	a,b	:_xZkqqHx_jEoEiKhCiClHiCoJiCfBjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iCnMiCkAiCnMiCkAjDjJiClFiCkCiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjDjJiClFiCkNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline BOOL rougheq (const DBLPoint& a, const DBLPoint& b)
{
	return rougheq(a.x, b.x) && rougheq(a.y, b.y);
} // rougheq (const DBLPoint& a, const DBLPoint& b).

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	rough0
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	DBLPoint_xZkqqHx_iMfOjCgMiCkKiCnMiCkAiCnMiCkA_xHqqkZx_0_xZkqqHx_iCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	a	:_xZkqqHx_jEoEiKhCiClHiCoJjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iCnMiCkAiCnMiCkAjDjJiClFiCkCiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjDjJiClFiCkNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.03.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline BOOL rough0 (const DBLPoint& a)
{
	return rough0(a.x) && rough0(a.y);
} // rough0 (double x).

//;----- </EXPORT TO SDK> -----;

#endif//__DBLPoint_h
