// DbGroup.cpp : _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgFiBfLiDfGiDiHiDjD_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

#include "stdafx.h"
#include "DynamicDb.h"	// For FCDynamicDb.
#include "UtilErr.h"	// For FFThrowMiscUnknown.
#include "UtilFile.h"	// For  <<.
#include "UtilVirtualTable.h"	// For FFGetSubControlIds.
#include "VirtualTable.h"	// For FCVirtualTable.

#include "DbGroup.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

const DWORD	CONTROL_TABLE_ID = 0;

/////////////////////////////////////////////////////////////////////////////
// FCDbGroup

FCDbGroup::FCDbGroup ()
{
} // FCDbGroup::FCDbGroup.

FCDbGroup::FCDbGroup (const FCTableName& groupName)
			:BASE_CLASS()
{
	Initialize(FCTableName(groupName).PushBack(CONTROL_TABLE_ID));
} // FCDbGroup::FCDbGroup.

FCDbGroup::~FCDbGroup ()
{
} // FCDbGroup::~FCDbGroup.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbGroup::CreateSubGroup
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDePiDiLiBfLiDhGiCmMiJlKiCmJiBeBiOhHjCoIiClDiCoKiClN_xHqqkZx_ID_xZkqqHx_iCmFiDfEiDhFiDePiDiLiBfLiDhGiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	readLock	:_xZkqqHx_iJlKjAhNiCmMjHoBiCmFiBeBiKmHjHjNiDgFiBfLiDhFiDiLiCfFiCmM_xHqqkZx_Read_xZkqqHx_iDiNiDgCiDeOiCpAjFnEiClHiBeC_xHqqkZx_
 *			writeLock	:_xZkqqHx_iJlKjAhNiCmMjHoBiCmFiBeBiKmHjHjNiDgFiBfLiDhFiDiLiCfFiCmM_xHqqkZx_Write_xZkqqHx_iDiNiDgCiDeOiCpAjFnEiClHiBeC_xHqqkZx_
 *			dwGroupId	:_xZkqqHx_iJlKjAhNiCmMjHoBiCmFiBeBiDePiDiLiBfLiDhGiCfEiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_DWORD(-1)_xZkqqHx_iCpA_xHqqkZx_
 *						 _xZkqqHx_iOhHjCoIiClHiCoJiCmGiLpDiCkL_xHqqkZx_ID_xZkqqHx_iCkKiOkJjDkOjDeJiCmJiKiEiCoIjDjGiCmEiCoHiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNoMjAkMiClDiCoKiClNiDePiDiLiBfLiDhGiBgJiDePiDiLiBfLiDhGiCfEiBgKiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGiCpAjAfGiClFiCkNjCmHiJmBiClHiCoJiPoKiNiHiCmNiBeBiJlKjAhNiCmMjHmMiIoGiCgAiCmMiCoGiCkEiCmJiBeBiDePiDiLiBfLiDhGiCmM_xHqqkZx_
 *			_xZkqqHx_iDiMiDfCiBfLiDgIiBgJ_xHqqkZx_FCGroupRec_xZkqqHx_iBgKiCmGiKmHjHjNiDgFiBfLiDhFiDiLiCmMiDiMiDfCiBfLiDgIiBgJ_xHqqkZx_FCTableRec_xZkqqHx_iBgKiCkK_xHqqkZx_
 *			_xZkqqHx_jCmHiJmBiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iKmHjHjNiDgFiBfLiDhFiDiLiCfBiCmJiCmNiBeBiDePiDiLiBfLiDhGiCfEiCmMiDeHiDjDiDgHiDiKiBfLiCkKjDgPjIfOiClDiCoKiCoJiBeC_xHqqkZx_
 *
 *                                          _xZkqqHx_iBeG_xHqqkZx_
 *                                    _xZkqqHx_iEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_
 *                                    _xZkqqHx_iEkAiDePiDiLiBfLiDhGiCfAiEkA_xHqqkZx_
 *                                    _xZkqqHx_iEkEiEjPiEjPiEkGiEjPiEjPiEkD_xHqqkZx_
 *                  _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
 *                  _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_                _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkBiBgDiBgDiBgDiBgDiBeGiBgDiBgDiCgAiBgDiEkC_xHqqkZx_
 *          _xZkqqHx_iEkBiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkCiEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_    _xZkqqHx_iEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_
 *          _xZkqqHx_iEkAiKmHjHjNiDgFiBfLiDhFiDiLiCfBiEkAiEkAiDgFiBfLiDhFiDiLiCfCiEkAiBgDiBgDiEkAiDePiDiLiBfLiDhGiCfDiEkAiBgDiBeG_xHqqkZx_  _xZkqqHx_iEkAiDePiDiLiBfLiDhGiCfEiEkA_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_
 *          _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkDiEkEiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_    _xZkqqHx_iEkEiEjPiEjPiEkGiEjPiEjPiEkD_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkEiEjPiEjPiEkGiEjPiEjPiEkD_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_
 *                                                    _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_
 *                                                              _xZkqqHx_iBeGiEkBiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkCiBeG_xHqqkZx_
 *                                                              _xZkqqHx_iBeGiEkAiKmHjHjNiDgFiBfLiDhFiDiLiCfFiEkAiBeG_xHqqkZx_
 *                                                              _xZkqqHx_iBeGiEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkDiBeG_xHqqkZx_
 *                                                              _xZkqqHx_iEkEiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiEkD_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCDbGroup FCDbGroup::CreateSubGroup (	FCDbReadLock& readLock,
										FCDbWriteLock& writeLock,
										const void* pData,
										size_t szDataSize,
										DWORD dwGroupId)
{
	if (dwGroupId == DWORD(-1))
		dwGroupId = GetFreeId(FDCT_TYPE_GROUP);
	// _xZkqqHx_iKmHjHjNiDgFiBfLiDhFiDiLiCfBiCmNiDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
	if (!g_pFileServer->GetIsReadLocked(m_tableName) ||
		!g_pFileServer->GetIsWriteLocked(m_tableName))
		FFThrowMiscUnknown();
	// _xZkqqHx_iDePiDiLiBfLiDhGiCfEiCmMiDgFiBfLiDhFiDiLjGlMiCpAiNoMjAkMiBeC_xHqqkZx_
	FCTableName groupName = m_tableName;
	groupName.SetLast(dwGroupId);
	// _xZkqqHx_iKmHjHjNiDgFiBfLiDhFiDiLiCfFiCpAiDiNiDgCiDeOiClHiCoJiBeC_xHqqkZx_
	BOOL bIsLocked = FFCreateLock(readLock, writeLock, FCTableName(groupName).PushBack(CONTROL_TABLE_ID));
	if (bIsLocked)
	//----- _xZkqqHx_iKmHjHjNiDgFiBfLiDhFiDiLiCfFiCkKiDiNiDgCiDeOiCmFiCkLiClNiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iKmHjHjNiDgFiBfLiDhFiDiLiCfBiCmJiBeBiDePiDiLiBfLiDhGiCfEiCpAjDgPjIfOiClHiCoJiBeC_xHqqkZx_
		AppendControlRecord(FDCT_TYPE_GROUP, dwGroupId, pData, szDataSize);
		// _xZkqqHx_iDePiDiLiBfLiDhGiCfEiCpAiNoMjAkMiBeC_xHqqkZx_
		g_pFileServer->CmdCreateGroup(groupName);
		// _xZkqqHx_iKmHjHjNiDgFiBfLiDhFiDiLiCfFiCpAiNoMjAkMiBeC_xHqqkZx_
		g_pFileServer->CmdCreateTable(FCTableName(groupName).PushBack(CONTROL_TABLE_ID));
		return FCDbGroup(groupName);
	} else
	//----- _xZkqqHx_iKmHjHjNiDgFiBfLiDhFiDiLiCfFiCkKiDiNiDgCiDeOiCmFiCkLiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		return FCDbGroup();
	}
} // FCDbGroup::CreateSubGroup.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbGroup::CreateSubTable
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDePiDiLiBfLiDhGiCmMiJlKiCmJiBeBiOhHjCoIiClDiCoKiClN_xHqqkZx_ID_xZkqqHx_iCmFiDfEiDhFiDgFiBfLiDhFiDiLiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	readLock	:_xZkqqHx_iJlKjAhNiCmMjHoBiCmFiBeBiDgFiBfLiDhFiDiLiCfDiCmM_xHqqkZx_Read_xZkqqHx_iDiNiDgCiDeOiCpAjFnEiClHiBeC_xHqqkZx_
 *			writeLock	:_xZkqqHx_iJlKjAhNiCmMjHoBiCmFiBeBiDgFiBfLiDhFiDiLiCfDiCmM_xHqqkZx_Write_xZkqqHx_iDiNiDgCiDeOiCpAjFnEiClHiBeC_xHqqkZx_
 *			dwTableId	:_xZkqqHx_iJlKjAhNiCmMjHoBiCmFiBeBiDgFiBfLiDhFiDiLiCfDiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_DWORD(-1)_xZkqqHx_iCpA_xHqqkZx_
 *						 _xZkqqHx_iOhHjCoIiClHiCoJiCmGiLpDiCkL_xHqqkZx_ID_xZkqqHx_iCkKiOkJjDkOjDeJiCmJiKiEiCoIjDjGiCmEiCoHiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNoMjAkMiClDiCoKiClNiDgFiBfLiDhFiDiLiBgJiDgFiBfLiDhFiDiLiCfDiBgKiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDgFiBfLiDhFiDiLiCpAjAfGiClFiCkNjCmHiJmBiClHiCoJiPoKiNiHiCmNiBeBiJlKjAhNiCmMjHmMiIoGiCgAiCmMiCoGiCkEiCmJiBeBiDgFiBfLiDhFiDiLiCmM_xHqqkZx_
 *			_xZkqqHx_iDiMiDfCiBfLiDgIiBgJ_xHqqkZx_FCGroupRec_xZkqqHx_iBgKiCkKjCmHiJmBiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iKmHjHjNiDgFiBfLiDhFiDiLiCfBiCmJiCmNiBeBiDgFiBfLiDhFiDiLiCfDiCmMiDeHiDjDiDgHiDiKiBfLiCkKjDgPjIfOiClDiCoKiCoJiBeC_xHqqkZx_
 *
 *                                          _xZkqqHx_iBeG_xHqqkZx_
 *                                    _xZkqqHx_iEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_
 *                                    _xZkqqHx_iEkAiDePiDiLiBfLiDhGiCfAiEkA_xHqqkZx_
 *                                    _xZkqqHx_iEkEiEjPiEjPiEkGiEjPiEjPiEkD_xHqqkZx_
 *                  _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEkGiBgD_xHqqkZx_
 *                  _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkBiBgDiBgDiBgDiBeGiBgDiCgAiBgDiEkC_xHqqkZx_
 *          _xZkqqHx_iEkBiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkCiEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_  _xZkqqHx_iBeGiEkBiEjPiEjPiEkIiEjPiEjPiEkCiBeG_xHqqkZx_
 *          _xZkqqHx_iEkAiKmHjHjNiDgFiBfLiDhFiDiLiCfBiEkAiEkAiDgFiBfLiDhFiDiLiCfCiEkAiBgDiBeGiEkAiDgFiBfLiDhFiDiLiCfDiEkAiBeG_xHqqkZx_
 *          _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkDiEkEiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_  _xZkqqHx_iBeGiEkEiEjPiEjPiEjPiEjPiEjPiEkDiBeG_xHqqkZx_
 *                                            _xZkqqHx_iEkEiBgDiBgDiBgDiBgDiBgDiBgDiBgDiEkD_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCDbTable FCDbGroup::CreateSubTable (	FCDbReadLock& readLock,
										FCDbWriteLock& writeLock,
										const void* pData,
										size_t szDataSize,
										DWORD dwTableId)
{
	if (dwTableId == DWORD(-1))
		dwTableId = GetFreeId(FDCT_TYPE_TABLE);
	// _xZkqqHx_iKmHjHjNiDgFiBfLiDhFiDiLiCfBiCmNiDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
	if (!g_pFileServer->GetIsReadLocked(m_tableName) ||
		!g_pFileServer->GetIsWriteLocked(m_tableName))
		FFThrowMiscUnknown();
	// _xZkqqHx_iDgFiBfLiDhFiDiLiCfDiCmMiDgFiBfLiDhFiDiLjGlMiCpAiNoMjAkMiBeC_xHqqkZx_
	FCTableName tableName = m_tableName;
	tableName.SetLast(dwTableId);
	// _xZkqqHx_iDgFiBfLiDhFiDiLiCfDiCpAiDiNiDgCiDeOiClHiCoJiBeC_xHqqkZx_
	BOOL bIsLocked = FFCreateLock(readLock, writeLock, tableName);
	if (bIsLocked)
	//----- _xZkqqHx_iDgFiBfLiDhFiDiLiCfDiCkKiDiNiDgCiDeOiCmFiCkLiClNiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iKmHjHjNiDgFiBfLiDhFiDiLiCfBiCmJiBeBiDgFiBfLiDhFiDiLiCfDiCpAjDgPjIfOiClHiCoJiBeC_xHqqkZx_
		AppendControlRecord(FDCT_TYPE_TABLE, dwTableId, pData, szDataSize);
		// _xZkqqHx_iDgFiBfLiDhFiDiLiCfDiCpAiNoMjAkMiBeC_xHqqkZx_
		g_pFileServer->CmdCreateTable(tableName);
		return FCDbTable(tableName);
	} else
	//----- _xZkqqHx_iDgFiBfLiDhFiDiLiCfDiCkKiDiNiDgCiDeOiCmFiCkLiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		return FCDbTable();
	}
} // FCDbGroup::CreateSubTable.

DWORD FCDbGroup::GetFreeId (BYTE byType)
{
	DWORDSet stFreeIds;
	GetFreeIds(stFreeIds, byType, 1);
	return *stFreeIds.begin();
} // FCDbGroup::GetFreeId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbGroup::GetFreeIds
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDfOiDeDiDhGiCmFiOgHiCoNiCoKiCmEiCkCiCmIiCkC_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIjAjEjFkKiPfHiCnPiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	stFreeIds	:ID_xZkqqHx_iPfHiNiHiCpAjFnEiClHiBeC_xHqqkZx_
 *			byType		:_xZkqqHx_iDfOiDeDiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			szCount		:_xZkqqHx_jFeLjHhGiCmI_xHqqkZx_ID_xZkqqHx_jAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDbGroup::GetFreeIds (DWORDSet& stFreeIds, BYTE byType, size_t szCount)
{
	// _xZkqqHx_iKpJiCmJiOgHiCoNiCoKiCmEiCkCiCoJ_xHqqkZx_ID_xZkqqHx_iCpAiPfHiCnPiCoJiBeC_xHqqkZx_
	DWORDSet stUsedTableId;
	GetEntryList(stUsedTableId, byType);
	DWORD dwId = 0;
	while (szCount != 0)
	{
		if (stUsedTableId.find(dwId) == stUsedTableId.end())
		//----- dwId_xZkqqHx_iCkKiCnMiClOiOgHiCoNiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jFnEjCgMiCmJjCmHiJmBiBeC_xHqqkZx_
			stFreeIds.insert(dwId);
			// _xZkqqHx_iOgHjHhAiNmPiCnN_xHqqkZx_ID_xZkqqHx_iCmJjCmHiJmBiBeC_xHqqkZx_
			stUsedTableId.insert(dwId);
			// _xZkqqHx_iDeKiDeFiDjDiDgHiCpAiMlIiCoHiClHiBeC_xHqqkZx_
			szCount--;
		}
		dwId++;
	}
} // FCDbGroup::GetFreeIds.

//----- 06.02.10 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbGroup::GetIsSubGroupExist
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
// *
// * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCDbGroup::GetIsSubGroupExist (DWORD dwGroupId) const
//{
//	return g_pFileServer->GetIsGroupExist(GetGroupName().PushBack(dwGroupId));
//} // FCDbGroup::GetIsSubGroupExist.
//----- 06.02.10 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbGroup::GetIsSubTableExist
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCDbGroup::GetIsSubTableExist (DWORD dwTableId) const
{
	return g_pFileServer->GetIsTableExist(GetGroupName().PushBack(dwTableId));
} // FCDbGroup::GetIsSubTableExist.

//----- 06.01.10 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbGroup::GetSubGroup
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDePiDiLiBfLiDhGiCmMiDfEiDhFiDePiDiLiBfLiDhGiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwGroupId	:_xZkqqHx_iDfEiDhFiDePiDiLiBfLiDhGiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeCiJlKjAhNiCmMjHoBiCmFiBeBiDePiDiLiBfLiDhGiCfEiCpA_xHqqkZx_
//						 _xZkqqHx_iOoGjDlOiClHiCoJiPoKiNiHiCmNiBeBiDePiDiLiBfLiDhGiCfEiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfEiDhFiDePiDiLiBfLiDhGiBgJiDePiDiLiBfLiDhGiCfEiBgKiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jBlMiDeBiDhGiDiKiCkJiCoHiDePiDiLiBfLiDhGiCfEiCkKiNoNiPjMiClDiCoKiClNiJmCjEfMjAkLiCoAiCkAiCoJiBeC_xHqqkZx_
// *			_xZkqqHx_iKmHjHjNiDgFiBfLiDhFiDiLiCfBiCmJiCmNiBeBiDePiDiLiBfLiDhGiCfEiCmMiDeHiDjDiDgHiDiKiBfLiCkKjDgPjIfOiClDiCoKiCmEiCkCiCoJ_xHqqkZx_
// *			_xZkqqHx_iCmNiClIiCmIiCmMiCmFiBeBiClLiCoKiCpAiDgAiDeGiDgCiDeOiClFiCmEiCkIiCkNiBeC_xHqqkZx_
// *
// *                                          _xZkqqHx_iBeG_xHqqkZx_
// *                                    _xZkqqHx_iEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_
// *                                    _xZkqqHx_iEkAiDePiDiLiBfLiDhGiCfAiEkA_xHqqkZx_
// *                                    _xZkqqHx_iEkEiEjPiEjPiEkGiEjPiEjPiEkD_xHqqkZx_
// *                  _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
// *                  _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_                _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkBiBgDiBgDiBgDiBgDiBeGiBgDiBgDiCgAiBgDiEkC_xHqqkZx_
// *          _xZkqqHx_iEkBiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkCiEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_    _xZkqqHx_iEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_
// *          _xZkqqHx_iEkAiKmHjHjNiDgFiBfLiDhFiDiLiCfBiEkAiEkAiDgFiBfLiDhFiDiLiCfCiEkAiBgDiBgDiEkAiDePiDiLiBfLiDhGiCfDiEkAiBgDiBeG_xHqqkZx_  _xZkqqHx_iEkAiDePiDiLiBfLiDhGiCfEiEkA_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_
// *          _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkDiEkEiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_    _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_
// *                                                              _xZkqqHx_iEkEiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiEkD_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//FCDbGroup FCDbGroup::GetSubGroup (DWORD dwGroupId)
//{
//	if (!g_pFileServer->GetIsReadLocked(m_tableName))
//		FFThrowMiscUnknown();
//	const DWORD dwIndex = FindEntry(FDCT_TYPE_GROUP, dwGroupId);
//	if (dwIndex == DWORD(-1))
//		return FCDbGroup();
//	else
//		return FCDbGroup(FCTableName(m_tableName).SetLast(dwGroupId));
//} // FCDbGroup::GetSubGroup.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbGroup::GetSubTable
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDePiDiLiBfLiDhGiCmMiDfEiDhFiDgFiBfLiDhFiDiLiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwGroupId	:_xZkqqHx_iDfEiDhFiDgFiBfLiDhFiDiLiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeCiJlKjAhNiCmMjHoBiCmFiBeBiDgFiBfLiDhFiDiLiCfDiCpA_xHqqkZx_
//						 _xZkqqHx_iOoGjDlOiClHiCoJiPoKiNiHiCmNiBeBiDgFiBfLiDhFiDiLiCfDiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfEiDhFiDgFiBfLiDhFiDiLiBgJiDgFiBfLiDhFiDiLiCfDiBgKiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jBlMiDeBiDhGiDiKiCkJiCoHiDgFiBfLiDhFiDiLiCfDiCkKiNoNiPjMiClDiCoKiClNiJmCjEfMjAkLiCoAiCkAiCoJiBeC_xHqqkZx_
// *			_xZkqqHx_iKmHjHjNiDgFiBfLiDhFiDiLiCfBiCmJiCmNiBeBiDgFiBfLiDhFiDiLiCfDiCmMiDeHiDjDiDgHiDiKiBfLiCkKjDgPjIfOiClDiCoKiCmEiCkCiCoJ_xHqqkZx_
// *			_xZkqqHx_iCmNiClIiCmIiCmMiCmFiBeBiClLiCoKiCpAiDgAiDeGiDgCiDeOiClFiCmEiCkIiCkNiBeC_xHqqkZx_
// *
// *                                          _xZkqqHx_iBeG_xHqqkZx_
// *                                    _xZkqqHx_iEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_
// *                                    _xZkqqHx_iEkAiDePiDiLiBfLiDhGiCfAiEkA_xHqqkZx_
// *                                    _xZkqqHx_iEkEiEjPiEjPiEkGiEjPiEjPiEkD_xHqqkZx_
// *                  _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEkGiBgD_xHqqkZx_
// *                  _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkBiBgDiBgDiBgDiBeGiBgDiCgAiBgDiEkC_xHqqkZx_
// *          _xZkqqHx_iEkBiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkCiEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_  _xZkqqHx_iBeGiEkBiEjPiEjPiEkIiEjPiEjPiEkCiBeG_xHqqkZx_
// *          _xZkqqHx_iEkAiKmHjHjNiDgFiBfLiDhFiDiLiCfBiEkAiEkAiDgFiBfLiDhFiDiLiCfCiEkAiBgDiBeGiEkAiDgFiBfLiDhFiDiLiCfDiEkAiBeG_xHqqkZx_
// *          _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkDiEkEiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_  _xZkqqHx_iBeGiEkEiEjPiEjPiEjPiEjPiEjPiEkDiBeG_xHqqkZx_
// *                                            _xZkqqHx_iEkEiBgDiBgDiBgDiBgDiBgDiBgDiBgDiEkD_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//FCDbTable FCDbGroup::GetSubTable (DWORD dwTableId)
//{
//	if (!g_pFileServer->GetIsReadLocked(m_tableName))
//		FFThrowMiscUnknown();
//	const DWORD dwIndex = FindEntry(FDCT_TYPE_TABLE, dwTableId);
//	if (dwIndex == DWORD(-1))
//		return FCDbTable();
//	else
//		return FCDbTable(FCTableName(m_tableName).SetLast(dwTableId));
//} // FCDbGroup::GetSubTable.
//----- 06.01.10 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbGroup::GetSubGroup
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDePiDiLiBfLiDhGiCmMiDfEiDhFiDePiDiLiBfLiDhGiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	readLock	:_xZkqqHx_jFnEjCgMiCmMiDfEiDhFiDePiDiLiBfLiDhGiCpAiDiNiDgCiDeOiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *			dwTableId0	:_xZkqqHx_iDfEiDhFiDePiDiLiBfLiDhGiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwTableId1	:dwTableId0_xZkqqHx_iCmMiDfEiDhFiDePiDiLiBfLiDhGiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeCjFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_
 *						 DWORD(-1)_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwTableId2	:dwTableId1_xZkqqHx_iCmMiDfEiDhFiDePiDiLiBfLiDhGiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeCjFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_
 *						 DWORD(-1)_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwTableId3	:dwTableId2_xZkqqHx_iCmMiDfEiDhFiDePiDiLiBfLiDhGiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeCjFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_
 *						 DWORD(-1)_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfEiDhFiDePiDiLiBfLiDhGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iJlKjAhNiCmJjHoBiCpAiOkGiClHiBeC_xHqqkZx_
 *			dwTableId0=4, dwTableId1=6, dwTableId2=7, dwTableId1=DWORD(-1)
 *			_xZkqqHx_iCpAiOhHjCoIiClFiClNiPoKiNiHiBeBiCgAiCmMiDePiDiLiBfLiDhGiCfGiCkKiOoGjDlOiClDiCoKiCoJiBeC_xHqqkZx_
 *			readLock _xZkqqHx_iCmJiCmNiBeBiKmHjHjNiDgFiBfLiDhFiDiLiCfHiCmMiDiNiDgCiDeOiCkKjAnNjCoIiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jBlMiDeBiDhGiDiKiCkJiCoHiDePiDiLiBfLiDhGiCfGiCnMiCmFiCmMjDhCjCiGiCkKiNoNiPjMiClDiCoKiClNiJmCjEfMjAkLiCoAiCkAiCoJiCmMiCmFiBeB_xHqqkZx_
 *			_xZkqqHx_iDePiDiLiBfLiDhGiCfGiCmJiOiKiCoJiKgFiKmHjHjNiDgFiBfLiDhFiDiLiCpAiDgAiDeGiDgCiDeOiClFiCmIiCkKiCoHiJlKiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
 *
 *                                          _xZkqqHx_iBeG_xHqqkZx_
 *                                    _xZkqqHx_iEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_
 *                                    _xZkqqHx_iEkAiDePiDiLiBfLiDhGiCfAiEkA_xHqqkZx_
 *                                    _xZkqqHx_iEkEiEjPiEjPiEkGiEjPiEjPiEkD_xHqqkZx_
 *                  _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEjPiBgD_xHqqkZx_
 *                  _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_                _xZkqqHx_iEkA_xHqqkZx_        
 *          _xZkqqHx_iEkBiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkCiEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_    _xZkqqHx_iEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_  
 *          _xZkqqHx_iEkAiKmHjHjNiDgFiBfLiDhFiDiLiCfBiEkAiEkAiDgFiBfLiDhFiDiLiCfCiEkAiBgDiBgDiEkAiDePiDiLiBfLiDhGiCfDiEkAiBgD_xHqqkZx_
 *          _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkDiEkEiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_    _xZkqqHx_iEkEiEjPiEjPiEkGiEjPiEjPiEkD_xHqqkZx_  
 *                          _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEkIiEjPiEjPiEjPiEjPiBgD_xHqqkZx_
 *                          _xZkqqHx_iEkA_xHqqkZx_                  _xZkqqHx_iEkA_xHqqkZx_
 *                  _xZkqqHx_iEkBiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkC_xHqqkZx_    _xZkqqHx_iEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_
 *                  _xZkqqHx_iEkAiKmHjHjNiDgFiBfLiDhFiDiLiCfEiEkAiBgDiBgDiEkAiDePiDiLiBfLiDhGiCfFiEkA_xHqqkZx_
 *                  _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_    _xZkqqHx_iEkEiEjPiEjPiEkGiEjPiEjPiEkD_xHqqkZx_
 *                                        _xZkqqHx_iEkGiEjPiEjPiEkIiEjPiEjPiEjPiEjPiBgD_xHqqkZx_
 *                              _xZkqqHx_iEkBiBgDiBgDiBgDiBgDiBeGiBgDiBgDiCgAiBgDiEkC_xHqqkZx_
 *                              _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_
 *                              _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkAiDePiDiLiBfLiDhGiCfGiEkA_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_
 *                              _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkEiEjPiEjPiEkGiEjPiEjPiEkD_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_
 *                              _xZkqqHx_iEkEiBgDiBgDiBgDiBgDiBeGiBgDiBgDiBgDiBgDiEkD_xHqqkZx_
 *                          _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEkIiEjPiEjPiEjPiBgD_xHqqkZx_
 *                          _xZkqqHx_iEkA_xHqqkZx_            
 *                  _xZkqqHx_iEkBiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkC_xHqqkZx_    
 *                  _xZkqqHx_iEkAiKmHjHjNiDgFiBfLiDhFiDiLiCfHiEkAiBgDiBgD_xHqqkZx_
 *                  _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_    
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCDbGroup FCDbGroup::GetSubGroup (	DWORD dwTableId0,
									DWORD dwTableId1,
									DWORD dwTableId2,
									DWORD dwTableId3)
{
	// _xZkqqHx_iKmHjHjNiDgFiBfLiDhFiDiLiCfBiCkKiDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiClBiCmGiCpAiKgNjEeGiBeC_xHqqkZx_
	if (!g_pFileServer->GetIsReadLocked(m_tableName))
		FFThrowMiscUnknown();

	// _xZkqqHx_iDePiDiLiBfLiDhGiCfDiCmMiDeHiDjDiDgHiDiKiBfLiCkKjHeMiCoJiCkJiKgNjEeGiClHiCoJiBeC_xHqqkZx_
	if (FindEntry(FDCT_TYPE_GROUP, dwTableId0) == DWORD(-1))
		return FCDbGroup();
	// _xZkqqHx_iDePiDiLiBfLiDhGiCfDiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
	FCDbGroup dbSubGroup = FCDbGroup(FCTableName(m_tableName).SetLast(dwTableId0));

	if (dwTableId1 == DWORD(-1))
	//----- _xZkqqHx_iClBiCoKiImIiPoDiJlKiCmMiDePiDiLiBfLiDhGiCpAiLiBiCnPiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		return dbSubGroup;
	} else
	//----- _xZkqqHx_iNfIiCmJiJlKiCmMiDePiDiLiBfLiDhGiCpAiLiBiCnPiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iKmHjHjNiDgFiBfLiDhFiDiLiCfEiCpAiDiNiDgCiDeOiBeC_xHqqkZx_
		FCDbReadLock readLockTmp;
		if (!dbSubGroup.TryLock(readLockTmp))
			return FCDbGroup();
		return dbSubGroup.GetSubGroup(	dwTableId1,
										dwTableId2,
										dwTableId3);
	}
} // FCDbGroup::GetSubGroup.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbGroup::GetSubTable
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDePiDiLiBfLiDhGiCmMiDfEiDhFiDgFiBfLiDhFiDiLiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	readLock	:_xZkqqHx_jFnEjCgMiCmMiDfEiDhFiDgFiBfLiDhFiDiLiCpAiDiNiDgCiDeOiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *			dwTableId0	:_xZkqqHx_iDfEiDhFiDgFiBfLiDhFiDiLiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwTableId1	:dwTableId0_xZkqqHx_iCmMiDfEiDhFiDgFiBfLiDhFiDiLiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeCjFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_
 *						 DWORD(-1)_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwTableId2	:dwTableId1_xZkqqHx_iCmMiDfEiDhFiDgFiBfLiDhFiDiLiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeCjFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_
 *						 DWORD(-1)_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwTableId3	:dwTableId2_xZkqqHx_iCmMiDfEiDhFiDgFiBfLiDhFiDiLiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeCjFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_
 *						 DWORD(-1)_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfEiDhFiDgFiBfLiDhFiDiLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iJlKjAhNiCmJjHoBiCpAiOkGiClHiBeC_xHqqkZx_
 *			dwTableId0=4, dwTableId1=6, dwTableId2=7, dwTableId1=DWORD(-1)
 *			_xZkqqHx_iCpAiOhHjCoIiClFiClNiPoKiNiHiBeBiCgAiCmMiDgFiBfLiDhFiDiLiCfGiCkKiOoGjDlOiClDiCoKiCoJiBeC_xHqqkZx_
 *			readLock _xZkqqHx_iCmJiCmNiBeBiKmHjHjNiDgFiBfLiDhFiDiLiCfHiCmMiDiNiDgCiDeOiCkKjAnNjCoIiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jBlMiDeBiDhGiDiKiCkJiCoHiDgFiBfLiDhFiDiLiCfGiCnMiCmFiCmMjDhCjCiGiCkKiNoNiPjMiClDiCoKiClNiJmCjEfMjAkLiCoAiCkAiCoJiCmMiCmFiBeB_xHqqkZx_
 *			_xZkqqHx_iDgFiBfLiDhFiDiLiCfGiCmJiOiKiCoJiKgFiKmHjHjNiDgFiBfLiDhFiDiLiCpAiDgAiDeGiDgCiDeOiClFiCmIiCkKiCoHiJlKiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
 *
 *                                          _xZkqqHx_iBeG_xHqqkZx_
 *                                    _xZkqqHx_iEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_
 *                                    _xZkqqHx_iEkAiDePiDiLiBfLiDhGiCfAiEkA_xHqqkZx_
 *                                    _xZkqqHx_iEkEiEjPiEjPiEkGiEjPiEjPiEkD_xHqqkZx_
 *                  _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEjPiBgD_xHqqkZx_
 *                  _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_                _xZkqqHx_iEkA_xHqqkZx_        
 *          _xZkqqHx_iEkBiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkCiEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_    _xZkqqHx_iEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_  
 *          _xZkqqHx_iEkAiKmHjHjNiDgFiBfLiDhFiDiLiCfBiEkAiEkAiDgFiBfLiDhFiDiLiCfCiEkAiBgDiBgDiEkAiDePiDiLiBfLiDhGiCfDiEkAiBgD_xHqqkZx_
 *          _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkDiEkEiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_    _xZkqqHx_iEkEiEjPiEjPiEkGiEjPiEjPiEkD_xHqqkZx_  
 *                          _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEkIiEjPiEjPiEjPiEjPiBgD_xHqqkZx_
 *                          _xZkqqHx_iEkA_xHqqkZx_                  _xZkqqHx_iEkA_xHqqkZx_
 *                  _xZkqqHx_iEkBiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkC_xHqqkZx_    _xZkqqHx_iEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_
 *                  _xZkqqHx_iEkAiKmHjHjNiDgFiBfLiDhFiDiLiCfEiEkAiBgDiBgDiEkAiDePiDiLiBfLiDhGiCfFiEkA_xHqqkZx_
 *                  _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_    _xZkqqHx_iEkEiEjPiEjPiEkGiEjPiEjPiEkD_xHqqkZx_
 *                                        _xZkqqHx_iEkGiEjPiEjPiEkIiEjPiEjPiEjPiEjPiBgD_xHqqkZx_
 *                              _xZkqqHx_iEkBiBgDiBgDiBgDiBgDiBeGiBgDiBgDiCgAiBgDiEkC_xHqqkZx_
 *                              _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_
 *                              _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkAiDgFiBfLiDhFiDiLiCfGiEkA_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_
 *                              _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_
 *                              _xZkqqHx_iEkEiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiEkD_xHqqkZx_
 *
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCDbTable FCDbGroup::GetSubTable (	DWORD dwTableId0,
									DWORD dwTableId1,
									DWORD dwTableId2,
									DWORD dwTableId3)
{
	// _xZkqqHx_iKmHjHjNiDgFiBfLiDhFiDiLiCfBiCkKiDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiClBiCmGiCpAiKgNjEeGiBeC_xHqqkZx_
	if (!g_pFileServer->GetIsReadLocked(m_tableName))
		FFThrowMiscUnknown();
	if (dwTableId1 == DWORD(-1))
	//----- _xZkqqHx_iClBiCoKiImIiPoDiJlKiCmMiDePiDiLiBfLiDhGiCpAiLiBiCnPiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDgFiBfLiDhFiDiLiCfDiCmMiDeHiDjDiDgHiDiKiBfLiCkKjHeMiCoJiCkJiKgNjEeGiClHiCoJiBeC_xHqqkZx_
		if (FindEntry(FDCT_TYPE_TABLE, dwTableId0) == DWORD(-1))
			return FCDbTable();
		// _xZkqqHx_iDgFiBfLiDhFiDiLiCfDiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
		return FCDbTable(FCTableName(m_tableName).SetLast(dwTableId0));
	} else
	//----- _xZkqqHx_iNfIiCmJiJlKiCmMiDePiDiLiBfLiDhGiCpAiLiBiCnPiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDePiDiLiBfLiDhGiCfDiCmMiDeHiDjDiDgHiDiKiBfLiCkKjHeMiCoJiCkJiKgNjEeGiClHiCoJiBeC_xHqqkZx_
		if (FindEntry(FDCT_TYPE_GROUP, dwTableId0) == DWORD(-1))
			return FCDbTable();
		// _xZkqqHx_iDePiDiLiBfLiDhGiCfDiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
		FCDbGroup dbSubGroup = FCDbGroup(FCTableName(m_tableName).SetLast(dwTableId0));
		// _xZkqqHx_iKmHjHjNiDgFiBfLiDhFiDiLiCfEiCpAiDiNiDgCiDeOiBeC_xHqqkZx_
		FCDbReadLock readLockTmp;
		if (!dbSubGroup.TryLock(readLockTmp))
			return FCDbTable();
		return dbSubGroup.GetSubTable(	dwTableId1,
										dwTableId2,
										dwTableId3);
	}
} // FCDbGroup::GetSubTable.
//----- 06.01.10 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbGroup::TryLockLower
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDePiDiLiBfLiDhGiCoGiCoIiJlKiCmMiDePiDiLiBfLiDhGiCmJjBkOiClHiCoJiDgFiBfLiDhFiDiLiBgJiClBiCmMiDePiDiLiBfLiDhGiCpAiKnMiCnOiBgK_xHqqkZx_
 *			_xZkqqHx_iCpAjBfDiCmEiDiNiDgCiDeOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 *
 *                                          _xZkqqHx_iBeG_xHqqkZx_
 *                                          _xZkqqHx_iEkA_xHqqkZx_
 *                                    _xZkqqHx_iEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_
 *                                    _xZkqqHx_iEkAiDePiDiLiBfLiDhGiCfAiEkA_xHqqkZx_
 *                                    _xZkqqHx_iEkEiEjPiEjPiEkGiEjPiEjPiEkD_xHqqkZx_
 *                  _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
 *                  _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_                _xZkqqHx_iEkA_xHqqkZx_      
 *          _xZkqqHx_iEkBiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkCiEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_    _xZkqqHx_iEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_
 *          _xZkqqHx_iEkAiKmHjHjNiDgFiBfLiDhFiDiLiCfBiEkAiEkAiDgFiBfLiDhFiDiLiCfCiEkAiBgDiBgDiEkAiDePiDiLiBfLiDhGiCfDiEkAiBgD_xHqqkZx_
 *          _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkDiEkEiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_    _xZkqqHx_iEkEiEjPiEjPiEkGiEjPiEjPiEkD_xHqqkZx_
 *                                                    _xZkqqHx_iEkA_xHqqkZx_      
 *                            _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEkC_xHqqkZx_      
 *                            _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_                _xZkqqHx_iEkA_xHqqkZx_      
 *                    _xZkqqHx_iEkBiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkCiEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_    _xZkqqHx_iEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_
 *                    _xZkqqHx_iEkAiKmHjHjNiDgFiBfLiDhFiDiLiCfEiEkAiEkAiDgFiBfLiDhFiDiLiCfFiEkAiBgDiBgDiEkAiDePiDiLiBfLiDhGiCfGiEkA_xHqqkZx_
 *                    _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkDiEkEiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_    _xZkqqHx_iEkEiEjPiEjPiEkGiEjPiEjPiEkD_xHqqkZx_
 *                                                              _xZkqqHx_iEkA_xHqqkZx_      
 *                                      _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEkC_xHqqkZx_      
 *                                      _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_                _xZkqqHx_iEkA_xHqqkZx_      
 *                              _xZkqqHx_iEkBiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkCiEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_    _xZkqqHx_iEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_
 *                              _xZkqqHx_iEkAiKmHjHjNiDgFiBfLiDhFiDiLiCfHiEkAiEkAiDgFiBfLiDhFiDiLiCfIiEkAiBgDiBgDiEkAiDePiDiLiBfLiDhG_xHqqkZx_10_xZkqqHx_iEkA_xHqqkZx_
 *                              _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkDiEkEiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_    _xZkqqHx_iEkEiEjPiEjPiEkGiEjPiEjPiEkD_xHqqkZx_
 *                                                                        _xZkqqHx_iBeG_xHqqkZx_      
 *
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
//----- 06.02.04 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//BOOL FCDbGroup::TryLockLower (	FCDbReadLockVector& vReadLock,
//								FCDbWriteLockVector& vWriteLock)
//{
//	BOOL bSucceed = TRUE;
//	vReadLock.push_back(FCDbReadLock());
//	vWriteLock.push_back(FCDbWriteLock());
//	if (TryLock(vReadLock.back(), vWriteLock.back()))
//	//----- _xZkqqHx_iKmHjHjNiDgFiBfLiDhFiDiLiCfBiCkKiDiNiDgCiDeOiCmFiCkLiClNiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iClBiCmMiDePiDiLiBfLiDhGiCmMjClMiJlKiCmMiDgFiBfLiDhFiDiLiBgJiDgFiBfLiDhFiDiLiCfCiBgDiBgKiCpAjBfDiCmEiLiBiCnPiCoJiBeC_xHqqkZx_
//		DWORDSet stTableId;
//		GetEntryList(stTableId, FDCT_TYPE_TABLE);
//		// _xZkqqHx_jClMiJlKiCmMiDgFiBfLiDhFiDiLiCpAiDiNiDgCiDeOiClHiCoJiBeC_xHqqkZx_
//		DWORDSet::const_iterator iId;
//		for (iId = stTableId.begin();
//			 bSucceed && iId != stTableId.end(); iId++)
//		{
//			FCTableName tableName = FCTableName(m_tableName).SetLast(*iId);
//			vReadLock.push_back(FCDbReadLock());
//			vWriteLock.push_back(FCDbWriteLock());
//			if (!FFTryLock(vReadLock.back(), vWriteLock.back(), tableName))
//				bSucceed = FALSE;
//		}
//
//		// _xZkqqHx_iClBiCmMiDePiDiLiBfLiDhGiCmMjClMiJlKiCmMiDePiDiLiBfLiDhGiBgJiDePiDiLiBfLiDhGiCfDiBgDiBgKiCpAjBfDiCmEiLiBiCnPiCoJiBeC_xHqqkZx_
//		DWORDSet stGroupId;
//		GetEntryList(stGroupId, FDCT_TYPE_GROUP);
//		// _xZkqqHx_jClMiJlKiCmMiDePiDiLiBfLiDhGiCmJjBmOiClFiCmEiBeBiNmEiLeBjDeJiCmJiDiNiDgCiDeOiPiIjHjNiCpAiOmAiOhLiClHiCoJiBeC_xHqqkZx_
//		for (iId = stGroupId.begin();
//			 bSucceed && iId != stGroupId.end(); iId++)
//		{
//			if (!FCDbGroup(FCTableName(m_tableName).SetLast(*iId)).TryLockLower(vReadLock, vWriteLock))
//				bSucceed = FALSE;
//		}
//	} else
//	{
//		bSucceed = FALSE;
//	}
//	if (!bSucceed)
//	{
//		vReadLock.clear();
//		vWriteLock.clear();
//	}
//	return bSucceed;
//} // FCDbGroup::TryLockLower.
//----- 06.02.04 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
BOOL FCDbGroup::TryLockLower (FCDbLockBank& lockBank)
{
	BOOL bSucceed = TRUE;
	FCDbReadLock readLock;
	FCDbWriteLock writeLock;
	if (TryLock(readLock, writeLock))
	//----- _xZkqqHx_iKmHjHjNiDgFiBfLiDhFiDiLiCfBiCkKiDiNiDgCiDeOiCmFiCkLiClNiPoKiNiH_xHqqkZx_ -----
	{
		lockBank.Append(readLock);
		lockBank.Append(writeLock);
		// _xZkqqHx_iClBiCmMiDePiDiLiBfLiDhGiCmMjClMiJlKiCmMiDgFiBfLiDhFiDiLiBgJiDgFiBfLiDhFiDiLiCfCiBgDiBgKiCpAjBfDiCmEiLiBiCnPiCoJiBeC_xHqqkZx_
		DWORDSet stTableId;
		GetEntryList(stTableId, FDCT_TYPE_TABLE);
		// _xZkqqHx_jClMiJlKiCmMiDgFiBfLiDhFiDiLiCpAiDiNiDgCiDeOiClHiCoJiBeC_xHqqkZx_
		DWORDSet::const_iterator iId;
		for (iId = stTableId.begin();
			 bSucceed && iId != stTableId.end(); iId++)
		{
			FCTableName tableName = FCTableName(m_tableName).SetLast(*iId);
			FCDbReadLock readLockSub;
			FCDbWriteLock writeLockSub;
			if (FFTryLock(readLockSub, writeLockSub, tableName))
			//----- _xZkqqHx_iDiNiDgCiDeOiCmFiCkLiClNiPoKiNiH_xHqqkZx_ -----
			{
				lockBank.Append(readLockSub);
				lockBank.Append(writeLockSub);
			} else
			//----- _xZkqqHx_iDiNiDgCiDeOiCmFiCkLiCmIiCkCiPoKiNiH_xHqqkZx_ -----
			{
				bSucceed = FALSE;
			}
		}

		// _xZkqqHx_iClBiCmMiDePiDiLiBfLiDhGiCmMjClMiJlKiCmMiDePiDiLiBfLiDhGiBgJiDePiDiLiBfLiDhGiCfDiBgDiBgKiCpAjBfDiCmEiLiBiCnPiCoJiBeC_xHqqkZx_
		DWORDSet stGroupId;
		if (bSucceed)
			GetEntryList(stGroupId, FDCT_TYPE_GROUP);
		// _xZkqqHx_jClMiJlKiCmMiDePiDiLiBfLiDhGiCmJjBmOiClFiCmEiBeBiNmEiLeBjDeJiCmJiDiNiDgCiDeOiPiIjHjNiCpAiOmAiOhLiClHiCoJiBeC_xHqqkZx_
		for (iId = stGroupId.begin();
			 bSucceed && iId != stGroupId.end(); iId++)
		{
			if (!FCDbGroup(FCTableName(m_tableName).SetLast(*iId)).TryLockLower(lockBank))
				bSucceed = FALSE;
		}
	} else
	{
		bSucceed = FALSE;
	}
	if (!bSucceed)
		lockBank.Clear();
	return bSucceed;
} // FCDbGroup::TryLockLower.
//----- 06.02.04 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbGroup::DeleteSubGroup
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iJlKjAhNiCmJiCkIiCkCiCmEiBeBiClBiCmMiDePiDiLiBfLiDhGiCkKiDePiDiLiBfLiDhGiCfAiBeB_xHqqkZx_dwGroupId_xZkqqHx_iCkKiDePiDiLiBfLiDhGiCfDiCmMiPoKiNiHiBeB_xHqqkZx_
 *			DeleteSubGroup_xZkqqHx_iKnGjAjEiCpAiOmAiNhDiClHiCoJiCmGjDfPjApMjEmNiImNiCgAiCkKjBfDiCmEiNoNiPjMiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jDfPjApMjEmNiImNiCgAiCmJiKnMiCnMiCoKiCoJiDgFiBfLiDhFiDiLiCmNjBfDiCmEiDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
 *			TryLockLower_xZkqqHx_iKnGjAjEiCpAiOgHiCmBiCmEiDiNiDgCiDeOiClFiCmEiCkIiCkNiBeC_xHqqkZx_
 *
 *                                          _xZkqqHx_iBeG_xHqqkZx_
 *                                          _xZkqqHx_iEkA_xHqqkZx_
 *                                    _xZkqqHx_iEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_
 *                                    _xZkqqHx_iEkAiDePiDiLiBfLiDhGiCfAiEkA_xHqqkZx_
 *                                    _xZkqqHx_iEkEiEjPiEjPiEkGiEjPiEjPiEkD_xHqqkZx_
 *                  _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
 *                  _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkBiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiCgAiBgDiBgDiBgDiBgDiBgDiBgDiBgDiEkC_xHqqkZx_
 *          _xZkqqHx_iEkBiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkCiEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_  _xZkqqHx_iBeGiEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_                    _xZkqqHx_iBeG_xHqqkZx_
 *          _xZkqqHx_iEkAiKmHjHjNiDgFiBfLiDhFiDiLiCfBiEkAiEkAiDgFiBfLiDhFiDiLiCfCiEkAiBgDiBeGiEkAiDePiDiLiBfLiDhGiCfDiEkAiBgD_xHqqkZx_                  _xZkqqHx_iBeG_xHqqkZx_
 *          _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkDiEkEiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_  _xZkqqHx_iBeGiEkEiEjPiEjPiEkGiEjPiEjPiEkD_xHqqkZx_                    _xZkqqHx_iBeG_xHqqkZx_
 *        _xZkqqHx_iEkBiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiEkD_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_                          _xZkqqHx_iBeG_xHqqkZx_
 *        _xZkqqHx_iBeG_xHqqkZx_                  _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEkC_xHqqkZx_                _xZkqqHx_iBeG_xHqqkZx_
 *        _xZkqqHx_iBeG_xHqqkZx_                  _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_                _xZkqqHx_iEkA_xHqqkZx_                _xZkqqHx_iBeG_xHqqkZx_
 *        _xZkqqHx_iBeG_xHqqkZx_          _xZkqqHx_iEkBiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkCiEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_    _xZkqqHx_iEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_          _xZkqqHx_iBeG_xHqqkZx_
 *        _xZkqqHx_iBeG_xHqqkZx_          _xZkqqHx_iEkAiKmHjHjNiDgFiBfLiDhFiDiLiCfEiEkAiEkAiDgFiBfLiDhFiDiLiCfFiEkAiBgDiBgDiEkAiDePiDiLiBfLiDhGiCfGiEkA_xHqqkZx_          _xZkqqHx_iBeG_xHqqkZx_
 *        _xZkqqHx_iBeG_xHqqkZx_          _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkDiEkEiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_    _xZkqqHx_iEkEiEjPiEjPiEkGiEjPiEjPiEkD_xHqqkZx_          _xZkqqHx_iBeG_xHqqkZx_
 *        _xZkqqHx_iBeG_xHqqkZx_                                                    _xZkqqHx_iEkA_xHqqkZx_                _xZkqqHx_iBeG_xHqqkZx_
 *        _xZkqqHx_iBeG_xHqqkZx_                            _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEkC_xHqqkZx_      _xZkqqHx_iBeG_xHqqkZx_
 *        _xZkqqHx_iBeG_xHqqkZx_                            _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_                _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iBeG_xHqqkZx_
 *        _xZkqqHx_iBeG_xHqqkZx_                    _xZkqqHx_iEkBiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkCiEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_    _xZkqqHx_iEkBiEjPiEjPiEkIiEjPiEjPiEkCiBeG_xHqqkZx_
 *        _xZkqqHx_iBeG_xHqqkZx_                    _xZkqqHx_iEkAiKmHjHjNiDgFiBfLiDhFiDiLiCfHiEkAiEkAiDgFiBfLiDhFiDiLiCfIiEkAiBgDiBgDiEkAiDgFiBfLiDhFiDiL_xHqqkZx_10_xZkqqHx_iEkAiBeG_xHqqkZx_
 *        _xZkqqHx_iBeG_xHqqkZx_                    _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkDiEkEiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_    _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEkDiBeG_xHqqkZx_
 *        _xZkqqHx_iEkEiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiEkD_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDbGroup::DeleteSubGroup (DWORD dwGroupId)
{
	// _xZkqqHx_iKmHjHjNiDgFiBfLiDhFiDiLiCfBiCmNiDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
	if (!GetIsReadLocked() || !GetIsWriteLocked())
		FFThrowMiscUnknown();
	const DWORD dwIndex = FindEntry(FDCT_TYPE_GROUP, dwGroupId);
	// _xZkqqHx_iOhHjCoIiClDiCoKiClNiDfEiDhFiDePiDiLiBfLiDhGiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiHiCmNiDeHiDiJiBfLiBeC_xHqqkZx_
	if (dwIndex == DWORD(-1))
		FFThrowMiscUnknown();
	// _xZkqqHx_iDePiDiLiBfLiDhGiCfDiImIiJlKiCmMiDgFiBfLiDhFiDiLiCmMiDiNiDgCiDeOiCpAiKgNjEeGiClHiCoJiBeC_xHqqkZx_
	FCDbGroup dbSubGroup = GetSubGroup(dwGroupId);
	if (!dbSubGroup.GetIsLockLower(TRUE))
		FFThrowMiscUnknown();

	// _xZkqqHx_iKmHjHjNiDgFiBfLiDhFiDiLiCfBiCkJiCoHiBeBiDePiDiLiBfLiDhGiCfDiCmMiDeHiDjDiDgHiDiKiBfLiCpAjGjFiPmBiClHiCoJiBeC_xHqqkZx_
	DeleteRecord(dwIndex);
	// _xZkqqHx_iDePiDiLiBfLiDhGiCfDiImIiJlKiCpAiNoNiPjMiBeC_xHqqkZx_
	dbSubGroup.myDeleteLower();
} // FCDbGroup::DeleteSubGroup.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbGroup::DeleteSubTable
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *                                          _xZkqqHx_iBeG_xHqqkZx_
 *                                    _xZkqqHx_iEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_
 *                                    _xZkqqHx_iEkAiDePiDiLiBfLiDhGiCfAiEkA_xHqqkZx_
 *                                    _xZkqqHx_iEkEiEjPiEjPiEkGiEjPiEjPiEkD_xHqqkZx_
 *                  _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEkGiBgD_xHqqkZx_
 *                  _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkBiBgDiBgDiBgDiBeGiBgDiCgAiBgDiEkC_xHqqkZx_
 *          _xZkqqHx_iEkBiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkCiEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_  _xZkqqHx_iBeGiEkBiEjPiEjPiEkIiEjPiEjPiEkCiBeG_xHqqkZx_
 *          _xZkqqHx_iEkAiKmHjHjNiDgFiBfLiDhFiDiLiCfBiEkAiEkAiDgFiBfLiDhFiDiLiCfCiEkAiBgDiBeGiEkAiDgFiBfLiDhFiDiLiCfDiEkAiBeG_xHqqkZx_
 *          _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkDiEkEiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_  _xZkqqHx_iBeGiEkEiEjPiEjPiEjPiEjPiEjPiEkDiBeG_xHqqkZx_
 *                                            _xZkqqHx_iEkEiBgDiBgDiBgDiBgDiBgDiBgDiBgDiEkD_xHqqkZx_
 *
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDbGroup::DeleteSubTable (DWORD dwTableId)
{
	// _xZkqqHx_iKmHjHjNiDgFiBfLiDhFiDiLiCfBiCmNiDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
	if (!GetIsReadLocked() || !GetIsWriteLocked())
		FFThrowMiscUnknown();
	const DWORD dwIndex = FindEntry(FDCT_TYPE_TABLE, dwTableId);
	// _xZkqqHx_iOhHjCoIiClDiCoKiClNiDfEiDhFiDgFiBfLiDhFiDiLiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiHiCmNiDeHiDiJiBfLiBeC_xHqqkZx_
	if (dwIndex == DWORD(-1))
		FFThrowMiscUnknown();
	// _xZkqqHx_iDgFiBfLiDhFiDiLiCfDiCmMiDiNiDgCiDeOiCpAiKgNjEeGiClHiCoJiBeC_xHqqkZx_
	FCDbTable dbSubTable = GetSubTable(dwTableId);
	if (!dbSubTable.GetIsReadLocked() ||
		!dbSubTable.GetIsWriteLocked())
		FFThrowMiscUnknown();
	// _xZkqqHx_iKmHjHjNiDgFiBfLiDhFiDiLiCfBiCkJiCoHiBeBiDgFiBfLiDhFiDiLiCfDiCmMiDeHiDjDiDgHiDiKiBfLiCpAjGjFiPmBiClHiCoJiBeC_xHqqkZx_
	DeleteRecord(dwIndex);
	// _xZkqqHx_iDgFiBfLiDhFiDiLiCfDiCpAiNoNiPjMiBeC_xHqqkZx_
	g_pFileServer->CmdDeleteTable(dbSubTable.GetTableName());
} // FCDbGroup::DeleteSubTable.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbGroup::GetGroupName
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCTableName FCDbGroup::GetGroupName () const
{
	return FCTableName(m_tableName).PopBack();
} // FCDbGroup::GetGroupName.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbGroup::GetSubTableName
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfEiDhFiDgFiBfLiDhFiDiLiCmMiDgFiBfLiDhFiDiLjGlMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwTableId0	:_xZkqqHx_iDfEiDhFiDgFiBfLiDhFiDiLiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwTableId1	:dwTableId0_xZkqqHx_iCmMiDfEiDhFiDgFiBfLiDhFiDiLiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeCjFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_
 *						 DWORD(-1)_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwTableId2	:dwTableId1_xZkqqHx_iCmMiDfEiDhFiDgFiBfLiDhFiDiLiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeCjFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_
 *						 DWORD(-1)_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwTableId3	:dwTableId2_xZkqqHx_iCmMiDfEiDhFiDgFiBfLiDhFiDiLiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeCjFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_
 *						 DWORD(-1)_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfEiDhFiDgFiBfLiDhFiDiLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCTableName FCDbGroup::GetSubTableName (	DWORD dwTableId0,
											DWORD dwTableId1,
											DWORD dwTableId2,
											DWORD dwTableId3) const
{
	FCTableName tableName = GetGroupName();
	do {
		if (dwTableId0 == DWORD(-1)) break;
		tableName.PushBack(dwTableId0);
		if (dwTableId1 == DWORD(-1)) break;
		tableName.PushBack(dwTableId1);
		if (dwTableId2 == DWORD(-1)) break;
		tableName.PushBack(dwTableId2);
		if (dwTableId3 == DWORD(-1)) break;
		tableName.PushBack(dwTableId3);
	} while (FALSE);
	return tableName;
} // FCDbGroup::GetSubTableName.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbGroup::GetControlRecord
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKmHjHjNiDgFiBfLiDhFiDiLiCkJiCoHiBeBiOhHjCoIiClDiCoKiClNiDeDiDjDiDgGiDgCiDeOiDfIiCmMiDeHiDjDiDgHiDiKiBfLiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	byType	:_xZkqqHx_iDeHiDjDiDgHiDiKiBfLiCmMiDfOiDeDiDhGiCpAjFnEiClHiBeC_xHqqkZx_
 *				FDCT_TYPE_TABLE			_xZkqqHx_iDgFiBfLiDhFiDiLiBeC_xHqqkZx_
 *				FDCT_TYPE_GROUP			_xZkqqHx_iDePiDiLiBfLiDhGiBeC_xHqqkZx_
 *				FDCT_TYPE_ASCII			ASCII_xZkqqHx_iDgFiDeMiDfIiDgHiDgGiBfLiDfOiBeC_xHqqkZx_
 *				FDCT_TYPE_UNICODE		UNICODE_xZkqqHx_iDgFiDeMiDfIiDgHiDgGiBfLiDfOiBeC_xHqqkZx_
 *				FDCT_TYPE_BINARY		_xZkqqHx_iDgPiDeDiDgJiDiKiDgGiBfLiDfOiBeC_xHqqkZx_
 *			dwId	:_xZkqqHx_iDeHiDjDiDgHiDiKiBfLiCmM_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			vData	:_xZkqqHx_iDeHiDjDiDgHiDiKiBfLiCmMiDgGiBfLiDfOiCpAjFnEiClHiBeCjFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwIndex	:_xZkqqHx_iDiMiDfCiBfLiDgIiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDbGroup::GetControlRecord (BYTE& byType, DWORD& dwId, BYTEVector* vData, DWORD dwIndex)
{
	DWORD dwDataSize = FD_CONTROL_TYPE_SIZE + FD_CONTROL_ID_SIZE;
	if (vData != NULL)
		dwDataSize = GetRecordDataSize(dwIndex);
	// _xZkqqHx_iDiMiDfCiBfLiDgIiDgGiBfLiDfOiCpAiOoGjDlOiBeC_xHqqkZx_
	BYTEVector vDataBuff(dwDataSize);
	GetRecordData(&vDataBuff[0], vDataBuff.size(), dwIndex);

	byType = GetTypeFromControlRecord(&vDataBuff[0]);
	dwId = GetIdFromControlRecord(&vDataBuff[0]);
	if (vData != NULL)
		vData->assign(vDataBuff.begin() + sizeof(BYTE) + sizeof(DWORD), vDataBuff.end());
} // FCDbGroup::GetControlRecord.

DWORD FCDbGroup::FindEntry (BYTE byType, DWORD dwId)
{
	DWORD dwIndex;
	for (dwIndex = GetRecordCount() - 1; dwIndex != DWORD(-1); dwIndex--)
	{
		BYTE byTypeTmp;
		DWORD dwIdTmp;
		GetControlRecord(byTypeTmp, dwIdTmp, NULL, dwIndex);
		// _xZkqqHx_iDfOiDeDiDhGiBeB_xHqqkZx_ID_xZkqqHx_iCmGiCoAiCmJiIoKjChGiClHiCoJiPoKiNiHiCmNiPeJjHlJiBeC_xHqqkZx_
		if (byTypeTmp == byType && dwIdTmp == dwId)
			break;
	}
	return dwIndex;
} // FCDbGroup::FindEntry.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbGroup::AppendControlRecord
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKmHjHjNiDgFiBfLiDhFiDiLiCmJiBeBiOhHjCoIiClDiCoKiClNiDeHiDjDiDgHiDiKiBfLiCpAjDgPjIfOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	byType	:_xZkqqHx_iDeHiDjDiDgHiDiKiBfLiCmMiDfOiDeDiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
 *				FDCT_TYPE_TABLE			_xZkqqHx_iDgFiBfLiDhFiDiLiBeC_xHqqkZx_
 *				FDCT_TYPE_GROUP			_xZkqqHx_iDePiDiLiBfLiDhGiBeC_xHqqkZx_
 *				FDCT_TYPE_ASCII			ASCII_xZkqqHx_iDgFiDeMiDfIiDgHiDgGiBfLiDfOiBeC_xHqqkZx_
 *				FDCT_TYPE_UNICODE		UNICODE_xZkqqHx_iDgFiDeMiDfIiDgHiDgGiBfLiDfOiBeC_xHqqkZx_
 *				FDCT_TYPE_BINARY		_xZkqqHx_iDgPiDeDiDgJiDiKiDgGiBfLiDfOiBeC_xHqqkZx_
 *			dwId	:_xZkqqHx_iDeHiDjDiDgHiDiKiBfLiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			pData	:_xZkqqHx_iDeHiDjDiDgHiDiKiBfLiCmMiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			szDataSize	:_xZkqqHx_iDgGiBfLiDfOiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDbGroup::AppendControlRecord (BYTE byType, DWORD dwId, const void* pData, size_t szDataSize)
{
	BYTEVector vBuff;
	MakeControlRecord(vBuff, byType, dwId, (const BYTE*)pData, szDataSize);
	AppendRecordAuto(&vBuff[0], vBuff.size());
} // FCDbGroup::AppendControlRecord.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbGroup::GetEntryList
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKmHjHjNiDgFiBfLiDhFiDiLiCmMiPoOjFpBiCpAiMjPiNpFiClFiBeBiOhHjCoIiClDiCoKiClNiDfOiDeDiDhGiCmMiDeHiDjDiDgHiDiKiBfLiCpA_xHqqkZx_
 *			_xZkqqHx_jBfDiCmEiPfHiCnPiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDgFiBfLiDhFiDiLiCpAjBfDiCmEiPfHiCnPiClNiPoKiNiHiBeBiKmHjHjNiDgFiBfLiDhFiDiLiCmNiKnMiCnMiCoKiCmIiCkCiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDbGroup::GetEntryList (DWORDSet& stTableId, BYTE byType)
{
//----- 05.12.29 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	const FCVirtualTable* pVirtualTable = g_pFileServer->QueryTable(m_tableName);
//	BYTE aDataBuff[FD_CONTROL_TYPE_SIZE + FD_CONTROL_ID_SIZE];
//	DWORD dwIndex;
//	for (dwIndex = 0; dwIndex != pVirtualTable->GetRecordCount(); dwIndex++)
//	{
//		if (pVirtualTable->IsNullRecord(dwIndex))
//			g_pFileServer->CacheTableRealRecords(m_tableName, dwIndex);
//		pVirtualTable->GetRecordData(aDataBuff, sizeof(aDataBuff), dwIndex);
//		// _xZkqqHx_iDfOiDeDiDhGiCkKiIoKjChGiClHiCoJiPoKiNiHiCmNjCmHiJmBiBeC_xHqqkZx_
//		if (GetTypeFromControlRecord(aDataBuff) == byType)
//			stTableId.insert(GetIdFromControlRecord(aDataBuff));
//	}
//----- 05.12.29 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	DWORD dwIndex;
	for (dwIndex = GetRecordCount() - 1; dwIndex != DWORD(-1); dwIndex--)
	{
		BYTE byTypeTmp;
		DWORD dwIdTmp;
		GetControlRecord(byTypeTmp, dwIdTmp, NULL, dwIndex);
		// _xZkqqHx_iDfOiDeDiDhGiCkKiIoKjChGiClHiCoJiPoKiNiHiCmNjCmHiJmBiBeC_xHqqkZx_
		if (byTypeTmp == byType)
			stTableId.insert(dwIdTmp);
	}
//----- 05.12.29 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCDbGroup::GetEntryList.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbGroup::GetIsLockLower
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDePiDiLiBfLiDhGiCoGiCoIiJlKiCmMiDePiDiLiBfLiDhGiCmJjBkOiClHiCoJiDgFiBfLiDhFiDiLiBgJiClBiCmMiDePiDiLiBfLiDhGiCpAiKnMiCnOiBgK_xHqqkZx_
 *			_xZkqqHx_iCkKjBfDiCmEiDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiCkJiKgNjEeGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 *
 *                                          _xZkqqHx_iBeG_xHqqkZx_
 *                                          _xZkqqHx_iEkA_xHqqkZx_
 *                                    _xZkqqHx_iEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_
 *                                    _xZkqqHx_iEkAiDePiDiLiBfLiDhGiCfAiEkA_xHqqkZx_
 *                                    _xZkqqHx_iEkEiEjPiEjPiEkGiEjPiEjPiEkD_xHqqkZx_
 *                  _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
 *                  _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_                _xZkqqHx_iEkA_xHqqkZx_      
 *          _xZkqqHx_iEkBiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkCiEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_    _xZkqqHx_iEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_
 *          _xZkqqHx_iEkAiKmHjHjNiDgFiBfLiDhFiDiLiCfBiEkAiEkAiDgFiBfLiDhFiDiLiCfCiEkAiBgDiBgDiEkAiDePiDiLiBfLiDhGiCfDiEkAiBgD_xHqqkZx_
 *          _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkDiEkEiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_    _xZkqqHx_iEkEiEjPiEjPiEkGiEjPiEjPiEkD_xHqqkZx_
 *                                                    _xZkqqHx_iEkA_xHqqkZx_      
 *                            _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEkC_xHqqkZx_      
 *                            _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_                _xZkqqHx_iEkA_xHqqkZx_      
 *                    _xZkqqHx_iEkBiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkCiEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_    _xZkqqHx_iEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_
 *                    _xZkqqHx_iEkAiKmHjHjNiDgFiBfLiDhFiDiLiCfEiEkAiEkAiDgFiBfLiDhFiDiLiCfFiEkAiBgDiBgDiEkAiDePiDiLiBfLiDhGiCfGiEkA_xHqqkZx_
 *                    _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkDiEkEiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_    _xZkqqHx_iEkEiEjPiEjPiEkGiEjPiEjPiEkD_xHqqkZx_
 *                                                              _xZkqqHx_iEkA_xHqqkZx_      
 *                                      _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEkC_xHqqkZx_      
 *                                      _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_                _xZkqqHx_iEkA_xHqqkZx_      
 *                              _xZkqqHx_iEkBiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkCiEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_    _xZkqqHx_iEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_
 *                              _xZkqqHx_iEkAiKmHjHjNiDgFiBfLiDhFiDiLiCfHiEkAiEkAiDgFiBfLiDhFiDiLiCfIiEkAiBgDiBgDiEkAiDePiDiLiBfLiDhG_xHqqkZx_10_xZkqqHx_iEkA_xHqqkZx_
 *                              _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkDiEkEiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_    _xZkqqHx_iEkEiEjPiEjPiEkGiEjPiEjPiEkD_xHqqkZx_
 *                                                                        _xZkqqHx_iBeG_xHqqkZx_      
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCDbGroup::GetIsLockLower (BOOL bIsCheckWriteLock)
{
	// _xZkqqHx_iKmHjHjNiDgFiBfLiDhFiDiLiCfBiCkK_xHqqkZx_Read_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiCkJiKgNjEeGiBeC_xHqqkZx_
	if (!g_pFileServer->GetIsReadLocked(m_tableName))
		return FALSE;
	if (bIsCheckWriteLock)
	//----- Write_xZkqqHx_iDiNiDgCiDeOiCoAiKgNjEeGiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// Write_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiCkJiKgNjEeGiBeC_xHqqkZx_
		if (!g_pFileServer->GetIsWriteLocked(m_tableName))
			return FALSE;
	}
	// _xZkqqHx_iClBiCmMiDePiDiLiBfLiDhGiCmMjClMiJlKiCmMiDgFiBfLiDhFiDiLiBgJiDgFiBfLiDhFiDiLiCfCiBgDiBgKiCpAjBfDiCmEiLiBiCnPiCoJiBeC_xHqqkZx_
	DWORDSet stTableId;
	GetEntryList(stTableId, FDCT_TYPE_TABLE);
	// _xZkqqHx_jClMiJlKiCmMiDgFiBfLiDhFiDiLiCkKiDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiCkJiKgNjEeGiBeC_xHqqkZx_
	DWORDSet::const_iterator iId;
	for (iId = stTableId.begin(); iId != stTableId.end(); iId++)
	{
		FCTableName tableName = FCTableName(m_tableName).SetLast(*iId);
		// _xZkqqHx_iDgFiBfLiDhFiDiLiCkK_xHqqkZx_Read_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiCkJiKgNjEeGiBeC_xHqqkZx_
		if (!g_pFileServer->GetIsReadLocked(tableName))
			return FALSE;
		if (bIsCheckWriteLock)
		//----- Write_xZkqqHx_iDiNiDgCiDeOiCoAiKgNjEeGiClHiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// Write_xZkqqHx_iDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiCkJiKgNjEeGiBeC_xHqqkZx_
			if (!g_pFileServer->GetIsWriteLocked(tableName))
				return FALSE;
		}
	}
	// _xZkqqHx_iClBiCmMiDePiDiLiBfLiDhGiCmMjClMiJlKiCmMiDePiDiLiBfLiDhGiBgJiDePiDiLiBfLiDhGiCfDiBgDiBgKiCpAjBfDiCmEiLiBiCnPiCoJiBeC_xHqqkZx_
	DWORDSet stGroupId;
	GetEntryList(stGroupId, FDCT_TYPE_GROUP);
	// _xZkqqHx_jClMiJlKiCmMiDePiDiLiBfLiDhGiCmJjBmOiClFiCmEiBeBiNmEiLeBjDeJiCmJiDiNiDgCiDeOiPiIjHjNiCpAiOmAiOhLiClHiCoJiBeC_xHqqkZx_
	for (iId = stGroupId.begin(); iId != stGroupId.end(); iId++)
	{
		if (!FCDbGroup(FCTableName(m_tableName).SetLast(*iId)).GetIsLockLower(bIsCheckWriteLock))
			return FALSE;
	}
	return TRUE;
} // FCDbGroup::GetIsLockLower.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDbGroup::myDeleteLower
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDePiDiLiBfLiDhGiCoGiCoIiJlKiCmMiDePiDiLiBfLiDhGiCmJjBkOiClHiCoJiDePiDiLiBfLiDhGiCmGiDgFiBfLiDhFiDiL_xHqqkZx_
 *			_xZkqqHx_iBgJiClBiCmMiDePiDiLiBfLiDhGiCpAiKnMiCnOiBgKiCpAjBfDiCmEiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 *
 *                                          _xZkqqHx_iBeG_xHqqkZx_
 *                                          _xZkqqHx_iEkA_xHqqkZx_
 *                                    _xZkqqHx_iEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_
 *                                    _xZkqqHx_iEkAiDePiDiLiBfLiDhGiCfAiEkA_xHqqkZx_
 *                                    _xZkqqHx_iEkEiEjPiEjPiEkGiEjPiEjPiEkD_xHqqkZx_
 *                  _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
 *                  _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_                _xZkqqHx_iEkA_xHqqkZx_      
 *          _xZkqqHx_iEkBiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkCiEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_    _xZkqqHx_iEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_
 *          _xZkqqHx_iEkAiKmHjHjNiDgFiBfLiDhFiDiLiCfBiEkAiEkAiDgFiBfLiDhFiDiLiCfCiEkAiBgDiBgDiEkAiDePiDiLiBfLiDhGiCfDiEkAiBgD_xHqqkZx_
 *          _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkDiEkEiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_    _xZkqqHx_iEkEiEjPiEjPiEkGiEjPiEjPiEkD_xHqqkZx_
 *                                                    _xZkqqHx_iEkA_xHqqkZx_      
 *                            _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEkC_xHqqkZx_      
 *                            _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_                _xZkqqHx_iEkA_xHqqkZx_      
 *                    _xZkqqHx_iEkBiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkCiEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_    _xZkqqHx_iEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_
 *                    _xZkqqHx_iEkAiKmHjHjNiDgFiBfLiDhFiDiLiCfEiEkAiEkAiDgFiBfLiDhFiDiLiCfFiEkAiBgDiBgDiEkAiDePiDiLiBfLiDhGiCfGiEkA_xHqqkZx_
 *                    _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkDiEkEiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_    _xZkqqHx_iEkEiEjPiEjPiEkGiEjPiEjPiEkD_xHqqkZx_
 *                                                              _xZkqqHx_iEkA_xHqqkZx_      
 *                                      _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEkC_xHqqkZx_      
 *                                      _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_                _xZkqqHx_iEkA_xHqqkZx_      
 *                              _xZkqqHx_iEkBiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkCiEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_    _xZkqqHx_iEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_
 *                              _xZkqqHx_iEkAiKmHjHjNiDgFiBfLiDhFiDiLiCfHiEkAiEkAiDgFiBfLiDhFiDiLiCfIiEkAiBgDiBgDiEkAiDePiDiLiBfLiDhG_xHqqkZx_10_xZkqqHx_iEkA_xHqqkZx_
 *                              _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkDiEkEiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_    _xZkqqHx_iEkEiEjPiEjPiEkGiEjPiEjPiEkD_xHqqkZx_
 *                                                                        _xZkqqHx_iBeG_xHqqkZx_      
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDbGroup::myDeleteLower ()
{
	// _xZkqqHx_iClBiCmMiDePiDiLiBfLiDhGiCmMjClMiJlKiCmMiDePiDiLiBfLiDhGiBgJiDePiDiLiBfLiDhGiCfDiBgDiBgKiCpAjBfDiCmEiLiBiCnPiCoJiBeC_xHqqkZx_
	DWORDSet stGroupId;
	GetEntryList(stGroupId, FDCT_TYPE_GROUP);
	// _xZkqqHx_jClMiJlKiCmMiDePiDiLiBfLiDhGiCmJjBmOiClFiCmEiBeBiNmEiLeBjDeJiCmJiNoNiPjMiPiIjHjNiCpAiOmAiOhLiClHiCoJiBeC_xHqqkZx_
	DWORDSet::const_iterator iId;
	for (iId = stGroupId.begin(); iId != stGroupId.end(); iId++)
		FCDbGroup(FCTableName(m_tableName).SetLast(*iId)).myDeleteLower();

	// _xZkqqHx_iClBiCmMiDePiDiLiBfLiDhGiCmMjClMiJlKiCmMiDgFiBfLiDhFiDiLiBgJiDgFiBfLiDhFiDiLiCfCiBgDiBgKiCpAjBfDiCmEiLiBiCnPiCoJiBeC_xHqqkZx_
	DWORDSet stTableId;
	GetEntryList(stTableId, FDCT_TYPE_TABLE);
	// _xZkqqHx_iKmHjHjNiDgFiBfLiDhFiDiLiBgJiKmHjHjNiDgFiBfLiDhFiDiLiCfBiBgKiCmNiKnMiCnMiCoKiCmIiCkCiCmMiCmFiBeBiDiKiDfIiDgHiCmJjCmHiJmBiBeC_xHqqkZx_
	stTableId.insert(CONTROL_TABLE_ID);
	// _xZkqqHx_jClMiJlKiCmMiDgFiBfLiDhFiDiLiCpAiNoNiPjMiBeC_xHqqkZx_
	for (iId = stTableId.begin(); iId != stTableId.end(); iId++)
	{
		FCTableName tableName = FCTableName(m_tableName).SetLast(*iId);
		g_pFileServer->CmdDeleteTable(tableName);
	}
	// _xZkqqHx_iClBiCmMiDePiDiLiBfLiDhGiCpAiNoNiPjMiBeC_xHqqkZx_
	g_pFileServer->CmdDeleteGroup(GetGroupName());
} // FCDbGroup::myDeleteLower.

void FCDbGroup::MakeControlRecord (BYTEVector& vBuff, BYTE byType, DWORD dwId, const BYTE* pData, size_t szData)
{
	vBuff << byType;
	vBuff << dwId;
	if (szData != 0)
		FFWriteStream(vBuff, pData, szData);
} // FCDbGroup::MakeControlRecord.

BYTE FCDbGroup::GetTypeFromControlRecord (const BYTE* pData)
{
	return pData[0];
} // FCDbGroup::GetTypeFromControlRecord.

DWORD FCDbGroup::GetIdFromControlRecord (const BYTE* pData)
{
	DWORD dwId;
	memcpy(&dwId, &pData[1], sizeof(dwId));
	return dwId;
} // FCDbGroup::GetIdFromControlRecord.

const BYTE* FCDbGroup::GetDataFromControlRecord (const BYTE* pData)
{
	return pData + FD_CONTROL_TYPE_SIZE + FD_CONTROL_ID_SIZE;
} // FCDbGroup::GetDataFromControlRecord.

