#if !defined(AFX_DBLOCK_H__B5F68EC6_C284_404C_947F_7E822F5CF686__INCLUDED_)
#define AFX_DBLOCK_H__B5F68EC6_C284_404C_947F_7E822F5CF686__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// DbLock.h : _xZkqqHx_iDhHiDgCiDfPiBfL_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

#include "UtilVirtualTable.h"	// For FCTableName.

class FCDynamicDb;
struct FCTableName;

/////////////////////////////////////////////////////////////////////////////
// FCDbLock _xZkqqHx_iDeFiDeCiDjDiDgIiDeF_xHqqkZx_

class FCDbLock
{
public:
	FCDbLock ();
	virtual ~FCDbLock ();
// 05.12.18 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	virtual void	SetGroup (const FCTableName& groupName);
	virtual void	SetTable (const FCTableName& tableName);
	virtual void	SetTable (	HString hstrTopDirPath,
								DWORD dwTableId0,
								DWORD dwTableId1 = DWORD(-1),
								DWORD dwTableId2 = DWORD(-1),
								DWORD dwTableId3 = DWORD(-1));
	virtual void	Clear ();
	virtual BOOL	IsLocked () const;
	virtual long	GetLocalLockCount () const;
	virtual GUID	GetLockedTableGuid () const;
	virtual DWORD	GetLockDeleteIdentifier () const;
	virtual DWORD	GetLockAppendIdentifier () const;
	virtual FCTableName	GetTableName () const;
	virtual BOOL	TryLock () = 0;
	virtual void	Unlock () = 0;
	virtual void	UnlockAll ();
	virtual void	Set (const FCDbLock& dbLock);

protected:
	FCTableName		m_tableName;
	long			m_lLockCount;
}; // class FCDbLock.

class FCDbReadLock : public FCDbLock
{
protected:
typedef FCDbLock BASE_CLASS;

public:
	FCDbReadLock ();
//	FCDbReadLock (const FCTableName& tableName, BOOL bIsLocked = FALSE);
	FCDbReadLock (const FCTableName& tableName);
	FCDbReadLock (const FCDbReadLock& readLock);
	FCDbReadLock (	HString hstrTopDirPath,
					DWORD dwTableId0,
					DWORD dwTableId1 = DWORD(-1),
					DWORD dwTableId2 = DWORD(-1),
					DWORD dwTableId3 = DWORD(-1));
	virtual ~FCDbReadLock ();
	virtual BOOL	TryLock ();
	virtual void	Unlock ();
	virtual void	operator = (const FCDbReadLock& readLock);
}; // class FCDbReadLock.

class FCDbWriteLock : public FCDbLock
{
protected:
typedef FCDbLock BASE_CLASS;

public:
	FCDbWriteLock ();
//	FCDbWriteLock (const FCTableName& tableName, BOOL bIsLocked = FALSE);
	FCDbWriteLock (const FCTableName& tableName);
	FCDbWriteLock (const FCDbWriteLock& writeLock);
	FCDbWriteLock (	HString hstrTopDirPath,
					DWORD dwTableId0,
					DWORD dwTableId1 = DWORD(-1),
					DWORD dwTableId2 = DWORD(-1),
					DWORD dwTableId3 = DWORD(-1));
	virtual ~FCDbWriteLock ();
// 05.12.15 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	virtual BOOL	CreateTopGroupLock ();
	virtual BOOL	CreateLock ();
	virtual BOOL	TryLock ();
	virtual void	Unlock ();
	virtual void	operator = (const FCDbWriteLock& writeLock);
}; // class FCDbWriteLock.

extern BOOL FFTryLock (FCDbReadLock& readLock, const FCTableName& tableName);
extern BOOL FFTryLock (FCDbWriteLock& writeLock, const FCTableName& tableName);
extern BOOL FFTryLock (FCDbReadLock& readLock, FCDbWriteLock& writeLock, const FCTableName& tableName);
extern BOOL FFCreateLock (FCDbReadLock& readLock, FCDbWriteLock& writeLock, const FCTableName& tableName);

class FCDbLockBank
{
public:
	void	Append (const FCDbReadLock& readLock);
	void	Append (const FCDbWriteLock& writeLock);
	void	Clear ();
	const FCDbReadLock&		GetReadLock (const FCTableName& tableName) const;
	const FCDbWriteLock&	GetWriteLock (const FCTableName& tableName) const;

protected:
	map<FCTableName, FCDbReadLock>	m_mpTableToReadLock;
	map<FCTableName, FCDbWriteLock>	m_mpTableToWriteLock;
}; // class FCDbLockBank.

//----- 06.02.04 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//typedef vector<FCDbReadLock> FCDbReadLockVector;
//typedef vector<FCDbWriteLock> FCDbWriteLockVector;
//----- 06.02.04 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/////////////////////////////////////////////////////////////////////////////

#endif // !defined(AFX_DBLOCK_H__B5F68EC6_C284_404C_947F_7E822F5CF686__INCLUDED_)
