// DlgHiForkTag.cpp : _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgFiBfLiDfGiDiHiDjD_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

#include "stdafx.h"
#include "DynamicDraw.h"		// For FFGetApp.
#include "UtilMisc.h"			// For FdsecToFiletime.
#include "UtilDlg.h"			// For SetUnitString.etc.
#include "UtilStr.h"			// For FFLoadString.
#include "UtilFile.h"			// For FFGetFileDirectory.
#include "UtilErr.h"			// For FFThrowMiscUnknown.
#include "HiProject.h"		// For FCHiProject.
#include "HiForkTable.h"			// For FCHiForkTable.
#include "DlgHiForkTag.h"		// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CFCDlgHiForkTag _xZkqqHx_iDfPiDeDiDeBiDiNiDeP_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgHiForkTag::CFCDlgHiForkTag
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bCreate	:_xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiCpAjAfGiLeLiCmJiNoMjAkMiClHiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeBiKpJjBlGiCmM_xHqqkZx_
 *					 _xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiCpAjFnCiPfHiClHiCoJiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			pParent	:_xZkqqHx_jAgFiDeFiDeCiDjDiDgIiDeFiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.07.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCDlgHiForkTag::CFCDlgHiForkTag (BOOL bCreate /*=TRUE*/, CWnd* pParent /*=NULL*/)
				: BASE_CLASS(bCreate ? IDD_DLG_CREATE_HI_FORK_TAG : IDD_DLG_HI_FORK_TAG, pParent)
{
	//{{AFX_DATA_INIT(CFCDlgHiForkTag)
	m_strDateCreate = _T("");
	m_strHidocumentSessionIndex = _T("");
	m_strHidocumentTitle = _T("");
	m_strHidocumentVersion = _T("");
	m_strProjectPath = _T("");
	m_strProjectTitle = _T("");
	m_bRegisterUserId = FALSE;
	m_strComment = _T("");
	m_strTitle = _T("");
	m_dHtreeScore = 1.0;
	//}}AFX_DATA_INIT

	// _xZkqqHx_jAfGiLeLiNoMjAkMiCkJiBeI_xHqqkZx_
	m_bIsCreate = bCreate;
	// _xZkqqHx_jFnCiPfHiJmCjEfMiCkJiBeI_xHqqkZx_
	m_bCanModify = TRUE;
	// _xZkqqHx_jDgPjIfOiDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	m_guidRegisterUserId = GUID_NULL;
} // CFCDlgHiForkTag::CFCDlgHiForkTag.

/////////////////////////////////////////////////////////////////////////////
// CFCDlgHiForkTag _xZkqqHx_iDiGiBfLiDfFiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgHiForkTag::Initialize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiIpIjAjEiCmFjFmPjAjEiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	project			:_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lDocId			:_xZkqqHx_jHjKjHpAjFlGiPjBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			fliSessionIndex	:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			forkFile		:_xZkqqHx_jHjKjHpAjFkKiKpCiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.10.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgHiForkTag::Initialize (	FCHiProject& project,
									long lDocId,
									flint fliSessionIndex,
									FCHiForkTable& forkFile)
{
	//----- _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhEiDeAiDeDiDiLiCkJiCoHiDgGiBfLiDfOiCpAiOoGjDlOiClHiCoJ_xHqqkZx_ -----
	m_strProjectPath = FFGetFileDirectory(project.GetFilePath(), TRUE);
	m_strProjectTitle = WStrToTStr(project.GetTitle());
	m_strHidocumentTitle = WStrToTStr(project.GetDocumentRec(lDocId).GetDocTitle());
	m_strHidocumentVersion = WStrToTStr(project.GetDocumentRec(lDocId).GetVersion());
	m_strHidocumentSessionIndex.Format(_T("%I64d"), fliSessionIndex);
	// _xZkqqHx_jFnCiPfHiJmCjEfMiCkJiBeI_xHqqkZx_
	m_bCanModify = project.IsQualifiedToModify(FFGetApp()->GetUserId());

	if (m_bIsCreate)
	//----- _xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiCpAjAfGiLeLiCmJiNoMjAkMiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDfOiDeDiDgHiDiLiBeC_xHqqkZx_
		m_strTitle.Empty();
		// _xZkqqHx_iDfCiDiBiDjDiDgHjDoAjHgFiBeC_xHqqkZx_
		m_strComment.Empty();
		// _xZkqqHx_jDgPjIfOjDpKiOjOiBeC_xHqqkZx_
		// _xZkqqHx_jHoBiBeG_xHqqkZx_2004_xZkqqHx_jEeO_xHqqkZx_8_xZkqqHx_iMiO_xHqqkZx_19_xZkqqHx_jDpK_xHqqkZx_ 0_xZkqqHx_iOjO_xHqqkZx_15_xZkqqHx_jFkK_xHqqkZx_
		// IDS_FORM_DATE_TIME_LONG = "%#Y_xZkqqHx_jEeO_xHqqkZx_%#m_xZkqqHx_iMiO_xHqqkZx_%#d %#H:%#M"
		m_strDateCreate = COleDateTime(FdsecToFiletime(FFGetCurrentSecTime())).Format(FFLoadString(IDS_FORM_DATE_TIME_LONG));
		// _xZkqqHx_jDgPjIfOiDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
		m_guidRegisterUserId = FFGetApp()->GetUserId();
		// _xZkqqHx_jDgPjIfOiDiGiBfLiDfFjGlMiBeC_xHqqkZx_
		m_wstrRegisterUserName = FFGetApp()->GetUserName();
		// _xZkqqHx_iNoMiOnCiCpAjDgPjIfOiClHiCoJiCkJiBeI_xHqqkZx_
		m_bRegisterUserId = (m_guidRegisterUserId != GUID_NULL);
		// _xZkqqHx_jHjKjHpAiDfIiDfCiDeBiBeC_xHqqkZx_
		m_dHtreeScore = 1.0;
	} else
	//----- _xZkqqHx_iKpJjBlGiCmMjHjKjHpAjFkKiKpCiDfOiDePiCpAjFnCiPfHiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		WString wstrTitle;
		WString wstrComment;
		GUID guidUserId;
		double dHtreeScore;
		// _xZkqqHx_iOhHjCoIiImKjChFiCmJjHjKjHpAjFkKiKpCiDfOiDePiCkKjGlDiCkCiPoKiNiHiCmNiDeHiDiJiBfLiBeC_xHqqkZx_
		FDSECTIME fdstDateCreate;		// _xZkqqHx_jDgPjIfOjDpKiOjOiBeC_xHqqkZx_
		if (!forkFile.IsThereHiForkTag(	fliSessionIndex,
										&fdstDateCreate,
										&dHtreeScore,
										&guidUserId,
										&wstrTitle,
										&wstrComment))
			FFThrowMiscUnknown();
		m_strTitle = WStrToTStr(wstrTitle);
		m_strComment = WStrToTStr(wstrComment);
		// _xZkqqHx_jHoBiBeG_xHqqkZx_2004_xZkqqHx_jEeO_xHqqkZx_8_xZkqqHx_iMiO_xHqqkZx_19_xZkqqHx_jDpK_xHqqkZx_ 0_xZkqqHx_iOjO_xHqqkZx_15_xZkqqHx_jFkK_xHqqkZx_
		// IDS_FORM_DATE_TIME_LONG = "%#Y_xZkqqHx_jEeO_xHqqkZx_%#m_xZkqqHx_iMiO_xHqqkZx_%#d %#H:%#M"
		m_strDateCreate = COleDateTime(FdsecToFiletime(fdstDateCreate)).Format(FFLoadString(IDS_FORM_DATE_TIME_LONG));
		// _xZkqqHx_jDgPjIfOiDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
		m_guidRegisterUserId = guidUserId;
		// _xZkqqHx_jDgPjIfOiDiGiBfLiDfFjGlMiBeC_xHqqkZx_
		m_wstrRegisterUserName = project.UserIdToUserName(guidUserId);
		// _xZkqqHx_iNoMiOnCiCpAjDgPjIfOiClHiCoJiCkJiBeI_xHqqkZx_
		m_bRegisterUserId = (m_guidRegisterUserId != GUID_NULL);
		// _xZkqqHx_jHjKjHpAiDfIiDfCiDeBiBeC_xHqqkZx_
		m_dHtreeScore = dHtreeScore;
	}
} // CFCDlgHiForkTag::Initialize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgHiForkTag::UpdateControls
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFmPjAjEiCmMjCgMiCmFiDfCiDjDiDgHiDiNiBfLiDiLiCmMjFfMiOkGiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.10.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgHiForkTag::UpdateControls ()
{
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjCgMiCpAjAnNjCoIiBeC_xHqqkZx_
	UpdateData(FALSE);

	if (m_bRegisterUserId)
	//----- _xZkqqHx_iNoMjAkMiOnCiPoOjFpBiCpAiLeMjIfOiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		FFSetDlgItemText(this, IDC_HTC_EDT_USER_ID,
						FFGetFormedUserId(m_guidRegisterUserId, m_wstrRegisterUserName));
	} else
	//----- _xZkqqHx_iNoMjAkMiOnCiPoOjFpBiCpAiLeMjIfOiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		FFSetDlgItemText(this, IDC_HTC_EDT_USER_ID, FFLoadWString(IDS_GUEST));
	}
} // CFCDlgHiForkTag::UpdateControls.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgHiForkTag::UpdateVariables
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjFfMiOkGiCmFjFmPjAjEiCmMjCgMiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.10.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgHiForkTag::UpdateVariables ()
{
	// _xZkqqHx_jFmPjAjEiCmMjCgMiCpAjAnNjCoIiBeC_xHqqkZx_
	UpdateData(TRUE);
} // CFCDlgHiForkTag::UpdateVariables.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgHiForkTag::UpdateActivate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjHeMiMpIjAkLiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.10.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgHiForkTag::UpdateActivate ()
{
	if (m_bIsCreate)
	//----- _xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiCpAjAfGiLeLiCmJiNoMjAkMiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iNoMjAkMiOnCiCpAjDgPjIfOiBeI_xHqqkZx_
		if (m_guidRegisterUserId == GUID_NULL)
			GetDlgItem(IDC_HTC_CHK_REGISTER_USER_ID)->EnableWindow(FALSE);
	} else
	//----- _xZkqqHx_iKpJjBlGiCmMjHjKjHpAjFkKiKpCiDfOiDePiCpAjFnCiPfHiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		if (!m_bCanModify)
		{
			// _xZkqqHx_iDfOiDeDiDgHiDiLiBeC_xHqqkZx_
			((CEdit*)GetDlgItem(IDC_HTC_EDT_TITLE))->SetReadOnly(TRUE);
			// _xZkqqHx_jDoAjHgFiBeC_xHqqkZx_
			((CEdit*)GetDlgItem(IDC_HTC_EDT_COMMENT))->SetReadOnly(TRUE);
			// _xZkqqHx_iDfIiDfCiDeBiBeC_xHqqkZx_
			((CEdit*)GetDlgItem(IDC_HTC_EDT_HTREE_SCORE))->SetReadOnly(TRUE);
		}
	}
} // CFCDlgHiForkTag::UpdateActivate.

/////////////////////////////////////////////////////////////////////////////
// CFCDlgHiForkTag _xZkqqHx_iDfPiDeDiDeBiDiNiDeP_xHqqkZx_

void CFCDlgHiForkTag::DoDataExchange(CDataExchange* pDX)
{
	BASE_CLASS::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFCDlgHiForkTag)
	DDX_Text(pDX, IDC_HTC_EDT_DATE_CREATE, m_strDateCreate);
	DDX_Text(pDX, IDC_HTC_EDT_HIDOCUMENT_SESSION_INDEX, m_strHidocumentSessionIndex);
	DDX_Text(pDX, IDC_HTC_EDT_HIDOCUMENT_TITLE, m_strHidocumentTitle);
	DDX_Text(pDX, IDC_HTC_EDT_HIDOCUMENT_VERSION, m_strHidocumentVersion);
	DDX_Text(pDX, IDC_HTC_EDT_PROJECT_PATH, m_strProjectPath);
	DDX_Text(pDX, IDC_HTC_EDT_PROJECT_TITLE, m_strProjectTitle);
	DDX_Check(pDX, IDC_HTC_CHK_REGISTER_USER_ID, m_bRegisterUserId);
	DDX_Text(pDX, IDC_HTC_EDT_COMMENT, m_strComment);
	DDX_Text(pDX, IDC_HTC_EDT_TITLE, m_strTitle);
	DDX_Text(pDX, IDC_HTC_EDT_HTREE_SCORE, m_dHtreeScore);
	DDV_MinMaxDouble(pDX, m_dHtreeScore, 0., 1.);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CFCDlgHiForkTag, BASE_CLASS)
	//{{AFX_MSG_MAP(CFCDlgHiForkTag)
	ON_WM_TIMER()
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFCDlgHiForkTag _xZkqqHx_iDiBiDgCiDfKiBfLiDfH_xHqqkZx_ _xZkqqHx_iDgOiDjDiDgIiDiJ_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgHiForkTag::OnInitDialog
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfPiDeDiDeBiDiNiDePiPiJiKpKiJlLiOjOiCmJiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.07.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCDlgHiForkTag::OnInitDialog ()
{
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnInitDialog();
//----- 05.08.27 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	if (m_bIsCreate)
	//----- _xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiCpAjAfGiLeLiCmJiNoMjAkMiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// 10_xZkqqHx_jFgCiClCiCmGiCmJiDfOiDeDiDhNiBfLiMmEiCnBiPgPiClFiBeCiOjOiKnEiCmMjFfMiOkGiCmNjFkKjCfAiImKiCmIiCmMiCmF_xHqqkZx_10_xZkqqHx_jFgCjCfAiImKiCmMiNfIjAfGiCmFiPfMjFkKiBeC_xHqqkZx_
		SetTimer(1, 10000, NULL);
	}
//----- 05.08.27 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_jFmPjAjEiCmMjCgMiCmFiDfCiDjDiDgHiDiNiBfLiDiLiCmMjFfMiOkGiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
	UpdateControls();
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjHeMiMpIjAkLiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
	UpdateActivate();
	// _xZkqqHx_iDfPiDeDiDeBiDiNiDePiCmMjCfAiImKjFfMiOkGiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
	::SetUnitString(m_hWnd);
	// _xZkqqHx_jHjIiCkLjIhCjBmOiJjOjFlGiOjKjHpBiCmMjAnNjCoIiCpAiNhDiCkEiBeC_xHqqkZx_
	::RightByLeftHand(m_hWnd);
	// _xZkqqHx_iDfPiDeDiDeBiDiNiDePiCpAiDhNiDeFiDfIiImKjChFiCmJiInKjDkOiBeC_xHqqkZx_
	if (!IsKindOf(RUNTIME_CLASS(CPropertyPage)))
		::FFJustifyWindow(m_hWnd);
	return TRUE;  // _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmJiDhEiDeIiBfLiDeKiDfIiCpAjAnNjCoIiClFiCmIiCkCiCmGiCkLiBeBjGnPiCoIjCgMiCmN_xHqqkZx_ TRUE _xZkqqHx_iCmGiCmIiCoIiCnMiClH_xHqqkZx_
	              // _xZkqqHx_jHoBiKeP_xHqqkZx_: OCX _xZkqqHx_iDhGiDiNiDhAiDgFiDeC_xHqqkZx_ _xZkqqHx_iDhJiBfLiDfHiCmMjGnPiCoIjCgMiCmN_xHqqkZx_ FALSE _xZkqqHx_iCmGiCmIiCoIiCnMiClH_xHqqkZx_
} // CFCDlgHiForkTag::OnInitDialog.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgHiForkTag::OnDestroy
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeFiDeCiDjDiDgIiDeFiNoNiPjMiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgHiForkTag::OnDestroy ()
{
	if (m_bIsCreate)
	//----- _xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiCpAjAfGiLeLiCmJiNoMjAkMiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDfOiDeDiDhNiBfLiNoNiPjMiBeC_xHqqkZx_
		KillTimer(1);
	}
	// Baseclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnDestroy();
} // CFCDlgHiForkTag::OnDestroy.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgHiForkTag::OnOK
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	OK_xZkqqHx_iDhLiDfOiDjDiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.07.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgHiForkTag::OnOK ()
{
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjFfMiOkGiCmFjFmPjAjEiCmMjCgMiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
	UpdateVariables();
	m_strTitle.TrimLeft();
	m_strTitle.TrimRight();
	m_strComment.TrimLeft();
	m_strComment.TrimRight();
	if (!m_bCanModify)
	//----- _xZkqqHx_jFnCiPfHiJmCjEfMiCmFiCmNiCmIiCkCiPoKiNiH_xHqqkZx_ ------
	{
		// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeCiDfPiDeDiDeBiDiNiDePiCpAjFmCiClGiCoJiBeC_xHqqkZx_
		BASE_CLASS::OnCancel();
	} else
	{
		// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeCiDfPiDeDiDeBiDiNiDePiCpAjFmCiClGiCoJiBeC_xHqqkZx_
		BASE_CLASS::OnOK();
	}
} // CFCDlgHiForkTag::OnOK.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgHiForkTag::OnTimer
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfOiDeDiDhNiBfLiCmFiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgHiForkTag::OnTimer (UINT nIDEvent)
{
	if (m_bIsCreate)
	//----- _xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiCpAjAfGiLeLiCmJiNoMjAkMiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		UpdateVariables();
		// _xZkqqHx_jDgPjIfOjDpKiOjOiBeC_xHqqkZx_
		FDSECTIME fdstDateCreate = FFGetCurrentSecTime();
		// _xZkqqHx_jHoBiBeG_xHqqkZx_2004_xZkqqHx_jEeO_xHqqkZx_8_xZkqqHx_iMiO_xHqqkZx_19_xZkqqHx_jDpK_xHqqkZx_ 0_xZkqqHx_iOjO_xHqqkZx_15_xZkqqHx_jFkK_xHqqkZx_
		// IDS_FORM_DATE_TIME_LONG = "%#Y_xZkqqHx_jEeO_xHqqkZx_%#m_xZkqqHx_iMiO_xHqqkZx_%#d %#H:%#M"
		m_strDateCreate = COleDateTime(FdsecToFiletime(fdstDateCreate)).Format(FFLoadString(IDS_FORM_DATE_TIME_LONG));
		UpdateControls();
	}
	// Baseclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnTimer(nIDEvent);
} // CFCDlgHiForkTag::OnTimer.

