// DlgMessageBox.cpp : _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgFiBfLiDfGiDiHiDjD_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

#include "stdafx.h"
#include "DynamicDraw.h"	// For FFGetApp.
#include "UtilErr.h"		// For CFCMiscException.
#include "UtilDlg.h"		// For FFJustifyWindow.
#include "UtilWin.h"		// For FFSetWindowText.
#include "DlgMessageBox.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CFCDlgMessageBox _xZkqqHx_iDfPiDeDiDeBiDiNiDeP_xHqqkZx_

CFCDlgMessageBox::CFCDlgMessageBox (CWnd* pParent /*=NULL*/)
	: BASE_CLASS(CFCDlgMessageBox::IDD, pParent)
{
	//{{AFX_DATA_INIT(CFCDlgMessageBox)
		// _xZkqqHx_iDiBiDiC_xHqqkZx_ - ClassWizard _xZkqqHx_iCmNiClBiCmMiImKjChFiCmJiDhNiDgCiDhDiDjDiDePjHhAiCmMiDhNiDeOiDiNiCpAjCmHiJmBiCnMiClNiCmNiNoNiPjMiClFiCnMiClHiBeC_xHqqkZx_
	//}}AFX_DATA_INIT

	// _xZkqqHx_iDiGiBfLiDfFjFmPjAjEiPiJiKpKiJlLiBeC_xHqqkZx_
	m_dwType = MB_OK;
//----- 02.08.28 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ (_xZkqqHx_iDhEiDeIiDjDiDgHiDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCmMjFfMiOkGiCmJjBmOiJjO_xHqqkZx_)-----
	m_szTextBoxSize = CSize(0, 0);
//----- 02.08.28 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ (_xZkqqHx_iDhEiDeIiDjDiDgHiDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCmMjFfMiOkGiCmJjBmOiJjO_xHqqkZx_)-----
} // CFCDlgMessageBox::CFCDlgMessageBox.

void CFCDlgMessageBox::DoDataExchange(CDataExchange* pDX)
{
	BASE_CLASS::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFCDlgMessageBox)
		// _xZkqqHx_iDiBiDiC_xHqqkZx_ - ClassWizard _xZkqqHx_iCmNiClBiCmMiImKjChFiCmJiDhNiDgCiDhDiDjDiDePjHhAiCmMiDhNiDeOiDiNiCpAjCmHiJmBiCnMiClNiCmNiNoNiPjMiClFiCnMiClHiBeC_xHqqkZx_
	//}}AFX_DATA_MAP
} // CFCDlgMessageBox::DoDataExchange.

BEGIN_MESSAGE_MAP(CFCDlgMessageBox, BASE_CLASS)
	//{{AFX_MSG_MAP(CFCDlgMessageBox)
	ON_BN_CLICKED(IDYES, OnYes)
	ON_BN_CLICKED(IDNO, OnNo)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFCDlgMessageBox _xZkqqHx_iDiGiBfLiDfFiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgMessageBox::SetText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfPiDeDiDeBiDiNiDePiCmJjFfMiOkGiClHiCoJiDiBiDgCiDfKiBfLiDfHiCmMiDgFiDeMiDfIiDgHiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tcpText	:_xZkqqHx_iDgFiDeMiDfIiDgHjFlGiOjKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.07.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgMessageBox::SetText (const wchar_t* tcpText)
{
	m_strText = tcpText;
} // CFCDlgMessageBox::SetText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgMessageBox::SetCaption
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfPiDeDiDeBiDiNiDePiCmMiDfOiDeDiDgHiDiLjFlGiOjKjHpBiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tcpCaption	:_xZkqqHx_iDfOiDeDiDgHiDiLjFlGiOjKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.07.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgMessageBox::SetCaption (const wchar_t* tcpCaption)
{
	m_strCaption = tcpCaption;
} // CFCDlgMessageBox::SetCaption.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgMessageBox::SetType
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfPiDeDiDeBiDiNiDePiCmMiDfOiDeDiDhGiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwType	:_xZkqqHx_iDfOiDeDiDhGiCpAiOhHjCoIiBeC_xHqqkZx_MessageBox_xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *					 _xZkqqHx_iNkBiCmMiCmGiClBiCoLiBeBiDfEiDhMiBfLiDgHiClFiCmEiCkCiCoJiCmMiCmNiImIiJlKiCmMiCnNiBeC_xHqqkZx_
 *					 MB_OK
 *					 MB_OKCANCEL
 *					 MB_YESNO
 *					 MB_YESNOCANCEL
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.07.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgMessageBox::SetType (DWORD dwType)
{
	// _xZkqqHx_iPiIjHjNjFhDiJmCjEfMiCmIiDfOiDeDiDhGiCpAiOhHjCoIiClFiClNiPoKiNiHiCmNjGkCjCoIiLgAiDeHiDiJiBfLiCpAiDfIiDiNiBfLiBeC_xHqqkZx_
	if (!IsAcceptableType(dwType))
		FFThrowMiscUnknown();
	m_dwType = dwType;
} // CFCDlgMessageBox::SetType.

//----- 02.08.28 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ (_xZkqqHx_iDhEiDeIiDjDiDgHiDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCmMjFfMiOkGiCmJjBmOiJjO_xHqqkZx_)-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgMessageBox::SetTextBoxSize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiDhLiDgCiDeOiDfIiCmMiDfEiDeDiDfJiCpAiOhHjCoIiClHiCoJiBeCiOhHjCoIiClFiCmIiCkCiPoKiNiHiCmNiBeB_xHqqkZx_
 *			_xZkqqHx_jAnNjCoIiClDiCoKiClNjFlGiOjKjHpBiCmJiNiHiClJiCmEiDfEiDeDiDfJiCkKjFmPiNfIiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	sz	:_xZkqqHx_iDeFiDeCiDjDiDgIiDeFiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.08.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgMessageBox::SetTextBoxSize (CSize sz)
{
	m_szTextBoxSize = sz;
} // CFCDlgMessageBox::SetTextBoxSize.
//----- 02.08.28 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ (_xZkqqHx_iDhEiDeIiDjDiDgHiDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCmMjFfMiOkGiCmJjBmOiJjO_xHqqkZx_)-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgMessageBox::IsAcceptableType
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDfOiDeDiDhGiCmNiClBiCmMiDfPiDeDiDeBiDiNiDePiCmFiPiIjHjNiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwType	:_xZkqqHx_iDfOiDeDiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPiIjHjNiJmCjEfMiCmFiCkAiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iPiIjHjNiJmCjEfMiCmFiCmIiCkCiDfOiDeDiDhGiCpAiDfPiDeDiDeBiDiNiDePiCmJjAnNjCoIiBeBjFfMiOkGiClFiCoGiCkEiCmGiClHiCoJiCmG_xHqqkZx_
 *			_xZkqqHx_iDeHiDiJiBfLiCpAiDfIiDiNiBfLiClHiCoJiPoKiNiHiCkKiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.09.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCDlgMessageBox::IsAcceptableType (DWORD dwType)
{
	// MB_OK_xZkqqHx_jDjJiBeB_xHqqkZx_MB_ICONXXX_xZkqqHx_jDjJiBeBiClBiCoKiClOiCkPiCmIiCoH_xHqqkZx_0xff_xZkqqHx_iImIiJlKiBeC_xHqqkZx_
	if (0xff < dwType) return FALSE;
	switch (dwType & 0x0000000fL)
	{
	case MB_OK:
	case MB_OKCANCEL:
	case MB_YESNO:
	case MB_YESNOCANCEL:
		return TRUE;
	default:
		return FALSE;
	}
} // CFCDlgMessageBox::IsAcceptableType.

/////////////////////////////////////////////////////////////////////////////
// CFCDlgMessageBox _xZkqqHx_iDiBiDgCiDfKiBfLiDfH_xHqqkZx_ _xZkqqHx_iDgOiDjDiDgIiDiJ_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgMessageBox::OnInitDialog
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfPiDeDiDeBiDiNiDePiPiJiKpKiJlLiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJlKiLeMiDfCiDiBiDjDiDgHiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.07.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCDlgMessageBox::OnInitDialog ()
{
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnInitDialog();

	// _xZkqqHx_iDeMiDiDiDhGiDfGiDiHiDjDjFlGiOjKjHpBiCmMiOoGjDlOiBeC_xHqqkZx_
	if (m_strCaption.IsEmpty())
		m_strCaption = FFGetApp()->GetDocString(CDocTemplate::windowTitle);
	// _xZkqqHx_iDeMiDiDiDhGiDfGiDiHiDjDjFlGiOjKjHpBiCmMjAnNjCoIiBeC_xHqqkZx_
	FFSetWindowText(this, m_strCaption);

	BOOL bShowYes = FALSE;
	BOOL bShowNo = FALSE;
	BOOL bShowOk = FALSE;
	BOOL bShowCancel = FALSE;

	switch (m_dwType & 0x0000000fL)
	{
	case MB_OK:
		bShowOk = TRUE;
		break;
	case MB_OKCANCEL:
		bShowOk = TRUE;
		bShowCancel = TRUE;
		break;
	case MB_YESNO:
		bShowYes = TRUE;
		bShowNo = TRUE;
		break;
	case MB_YESNOCANCEL:
		bShowYes = TRUE;
		bShowNo = TRUE;
		bShowCancel = TRUE;
		break;
	default:
		// _xZkqqHx_jGkCjCoIiLgAiDeHiDiJiBfLiCpAiDfIiDiNiBfLiBeC_xHqqkZx_
		FFThrowMiscUnknown();
	}
	GetDlgItem(IDYES)->ShowWindow(bShowYes ? SW_SHOW : SW_HIDE);
	GetDlgItem(IDNO)->ShowWindow(bShowNo ? SW_SHOW : SW_HIDE);
	GetDlgItem(IDOK)->ShowWindow(bShowOk ? SW_SHOW : SW_HIDE);
	GetDlgItem(IDCANCEL)->ShowWindow(bShowCancel ? SW_SHOW : SW_HIDE);
	GetDlgItem(IDYES)->EnableWindow(bShowYes);
	GetDlgItem(IDNO)->EnableWindow(bShowNo);
	GetDlgItem(IDOK)->EnableWindow(bShowOk);
	GetDlgItem(IDCANCEL)->EnableWindow(bShowCancel);

//----- 05.11.20 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDgFiDeMiDfIiDgHiCpAiPmBiLiOiBeCiDfGiDiHiBfLiDgHiDeKiDgCiDgHiCmJiDhBiDgCiDgHiClDiClJiCmIiCkCiClNiCnPiBeC_xHqqkZx_
	if (!bShowYes)
		FFSetDlgItemText(this, IDYES, L"");
	if (!bShowNo)
		FFSetDlgItemText(this, IDNO, L"");
	if (!bShowOk)
		FFSetDlgItemText(this, IDOK, L"");
	if (!bShowCancel)
		FFSetDlgItemText(this, IDCANCEL, L"");
//----- 05.11.20 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_iDeBiDeDiDfCiDjDiDfCiDjDiDgHiDiNiBfLiDiLiCpAiOoGjDlOiBeC_xHqqkZx_
	CStatic* pIcon = (CStatic*)GetDlgItem(IDC_MSB_STC_ICON);

	switch (m_dwType & 0x000000f0L)
	{
	case MB_ICONEXCLAMATION:
	// case MB_ICONWARNING:
	//----- _xZkqqHx_iKlEjCfBjFiE_xHqqkZx_(!) -----
		pIcon->SetIcon(::LoadIcon(NULL, IDI_EXCLAMATION));
		break;
	case MB_ICONINFORMATION:
	// case MB_ICONASTERISK:
	//----- _xZkqqHx_iDeDiDjDiDhEiDeIiDiBiBfLiDfGiDiHiDjD_xHqqkZx_(i) -----
		pIcon->SetIcon(::LoadIcon(NULL, IDI_INFORMATION));
		break;
	case MB_ICONQUESTION:
	//----- _xZkqqHx_iLfOjGoCjFiE_xHqqkZx_(?) -----
		pIcon->SetIcon(::LoadIcon(NULL, IDI_QUESTION));
		break;
	case MB_ICONSTOP:
	// case MB_ICONERROR:
	// case MB_ICONHAND:
	//----- _xZkqqHx_iDfIiDgHiDgCiDhGiDhNiBfLiDeO_xHqqkZx_ -----
		pIcon->SetIcon(::LoadIcon(NULL, IDI_ERROR));
		break;
	default:
		pIcon->ShowWindow(SW_HIDE);
	}

	//----- _xZkqqHx_iDeNiDiDiDgCiDhGiCpAiMhGiOfK_xHqqkZx_ -----
	CRect rtIcon;
	pIcon->GetWindowRect(rtIcon);
	ScreenToClient(rtIcon);
	CSize szGap(rtIcon.left, rtIcon.top);

	CRect rtBtn;
	GetDlgItem(IDYES)->GetWindowRect(rtBtn);
	long lMinWidth = szGap.cx;
	if (bShowYes)
		lMinWidth += rtBtn.Width() + szGap.cx;
	if (bShowNo)
		lMinWidth += rtBtn.Width() + szGap.cx;
	if (bShowOk)
		lMinWidth += rtBtn.Width() + szGap.cx;
	if (bShowCancel)
		lMinWidth += rtBtn.Width() + szGap.cx;

	long lMinHeight = szGap.cy + rtIcon.Height() + szGap.cy + rtBtn.Height() + szGap.cy;

	// _xZkqqHx_iDgFiDeMiDfIiDgHjFfMiOkGjHhAiDfCiDjDiDgHiDiNiBfLiDiLiCmJiDgFiDeMiDfIiDgHjAnNjCoIiBeC_xHqqkZx_
	// _xZkqqHx_iDfEiDeDiDfJiMhGiOfKjHhAiCmJiBeBjFlGiOjKjHpBiNmFiMoDiCmJiJpMiNhDiBhLiJpMiNhDiCpAjCmHiJmBiBeC_xHqqkZx_
	CEdit* pEdit = (CEdit*)GetDlgItem(IDC_MSB_EDT_TEXT);
	FFSetWindowText(pEdit, m_strText + L"\r\n\r\n");

	//----- _xZkqqHx_iDgFiDeMiDfIiDgHjFfMiOkGjHhAiDfCiDjDiDgHiDiNiBfLiDiLiCmMiDfEiDeDiDfJiCpAiMhGiOfK_xHqqkZx_ -----
	if (m_szTextBoxSize == CSize(0, 0))
	//----- _xZkqqHx_iDgFiDeMiDfIiDgHiDhLiDgCiDeOiDfIiCmMiDfEiDeDiDfJiCkKiOhHjCoIiClDiCoKiCmEiCkCiCmIiCkPiCoKiCmOiBeBiDgFiDeMiDfIiDgHiCkJiCoHiMhGiOfK_xHqqkZx_ -----
	{
		// _xZkqqHx_iNhDjAjEiCpAiOoGjDlOiBeCiNmFiMoDiCmJjFeLiClIiJpMiNhDiBhLiJpMiNhDiCkKiCkAiCoJiBeC_xHqqkZx_
		const int iLineCount = pEdit->GetLineCount() - 1;
		for (int iC = 0; iC < iLineCount; iC++)
		{
			//----- _xZkqqHx_jFfMiOkGiClDiCoKiCoJjFlGiOjKjHpBiCkJiCoHiBeBiNmFiCoAiNlGiCmGiNmFiCoAiJlKiCmMiNmAjFfHiCpAiOoGjDlO_xHqqkZx_ -----
			int iTopIdx = pEdit->LineIndex(iC);
			int iLineSz = pEdit->LineLength(iTopIdx);
			CPoint ptRight = pEdit->PosFromChar(iTopIdx + iLineSz);
			if (m_szTextBoxSize.cx < ptRight.x) m_szTextBoxSize.cx = ptRight.x;
			if (m_szTextBoxSize.cy < ptRight.y) m_szTextBoxSize.cy = ptRight.y;
		}
	} else
	//----- _xZkqqHx_iDgFiDeMiDfIiDgHiDhLiDgCiDeOiDfIiCmMiDfEiDeDiDfJiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDgFiDeMiDfIiDgHiDhLiDgCiDeOiDfIiCmJjAiCjClMiDfIiDeOiDiNiBfLiDiLiDgPiBfLiCpAiPoNiOjOjFfMiOkGiBeC_xHqqkZx_
		pEdit->ModifyStyle(0, WS_VSCROLL);
	}
	// _xZkqqHx_iDgFiDeMiDfIiDgHjFfMiOkGjHhAiDfCiDjDiDgHiDiNiBfLiDiLiCmJiDgFiDeMiDfIiDgHiCpAiNmEjDhIjAnNjCoIiBeC_xHqqkZx_
	FFSetWindowText(pEdit, m_strText);

	long lWidth = szGap.cx + rtIcon.Width() + szGap.cx + m_szTextBoxSize.cx + szGap.cx;
	if (lWidth < lMinWidth) lWidth = lMinWidth;
	long lHeight = szGap.cy + m_szTextBoxSize.cy + szGap.cy + rtBtn.Height() + szGap.cy;
	if (lHeight < lMinHeight) lHeight = lMinHeight;

	CRect rtEdit(rtIcon.right + szGap.cx, szGap.cy,
				lWidth - szGap.cx, lHeight - szGap.cy - rtBtn.Height() - szGap.cy);
	pEdit->MoveWindow(rtEdit);

	CPoint ptBtn((lWidth - lMinWidth) / 2 + szGap.cx,
					lHeight - szGap.cy - rtBtn.Height());

	if (bShowYes)
	{
		GetDlgItem(IDYES)->MoveWindow(ptBtn.x, ptBtn.y, rtBtn.Width(), rtBtn.Height());
		ptBtn.x += rtBtn.Width() + szGap.cx;
	}
	if (bShowNo)
	{
		GetDlgItem(IDNO)->MoveWindow(ptBtn.x, ptBtn.y, rtBtn.Width(), rtBtn.Height());
		ptBtn.x += rtBtn.Width() + szGap.cx;
	}
	if (bShowOk)
	{
		GetDlgItem(IDOK)->MoveWindow(ptBtn.x, ptBtn.y, rtBtn.Width(), rtBtn.Height());
		ptBtn.x += rtBtn.Width() + szGap.cx;
	}
	if (bShowCancel)
	{
		GetDlgItem(IDCANCEL)->MoveWindow(ptBtn.x, ptBtn.y, rtBtn.Width(), rtBtn.Height());
		ptBtn.x += rtBtn.Width() + szGap.cx;
	}

	CRect rtClient;
	GetClientRect(rtClient);
	long lMoveW = lWidth - rtClient.Width();
	long lMoveH = lHeight - rtClient.Height();

	CRect rtScreen;
	GetWindowRect(rtScreen);
	rtScreen.right += lMoveW;
	rtScreen.bottom += lMoveH;
	MoveWindow(rtScreen);

//----- 00.12.31 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDfPiDeDiDeBiDiNiDePiCmMjCfAiImKjFfMiOkGiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
	::SetUnitString(m_hWnd);
	// _xZkqqHx_jHjIiCkLjIhCjBmOiJjOjFlGiOjKjHpBiCmMjAnNjCoIiCpAiNhDiCkEiBeC_xHqqkZx_
	::RightByLeftHand(m_hWnd);
	// _xZkqqHx_iDfPiDeDiDeBiDiNiDePiCpAiDhNiDeFiDfIiImKjChFiCmJiInKjDkOiBeC_xHqqkZx_
	FFJustifyWindow(m_hWnd);
//----- 00.12.31 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	return TRUE;  // _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmJiDhEiDeIiBfLiDeKiDfIiCpAjAnNjCoIiClFiCmIiCkCiCmGiCkLiBeBjGnPiCoIjCgMiCmN_xHqqkZx_ TRUE _xZkqqHx_iCmGiCmIiCoIiCnMiClH_xHqqkZx_
	              // _xZkqqHx_jHoBiKeP_xHqqkZx_: OCX _xZkqqHx_iDhGiDiNiDhAiDgFiDeC_xHqqkZx_ _xZkqqHx_iDhJiBfLiDfHiCmMjGnPiCoIjCgMiCmN_xHqqkZx_ FALSE _xZkqqHx_iCmGiCmIiCoIiCnMiClH_xHqqkZx_
} // CFCDlgMessageBox::OnInitDialog.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgMessageBox::OnYes
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhLiDfOiDjDiBhFiCmNiCkCiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.07.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgMessageBox::OnYes ()
{
	EndDialog(IDYES);
} // CFCDlgMessageBox::OnYes.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgMessageBox::OnNo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhLiDfOiDjDiBhFiCkCiCkCiCkGiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.07.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgMessageBox::OnNo ()
{
	EndDialog(IDNO);
} // CFCDlgMessageBox::OnNo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgMessageBox::OnOK
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhLiDfOiDjDiBhF_xHqqkZx_OK_xZkqqHx_iBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.07.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgMessageBox::OnOK ()
{
	EndDialog(IDOK);
} // CFCDlgMessageBox::OnOK.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgMessageBox::OnCancel
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhLiDfOiDjDiBhFiDeMiDiDiDjDiDfKiDiLiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.07.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgMessageBox::OnCancel ()
{
	EndDialog(IDCANCEL);
} // CFCDlgMessageBox::OnCancel.
