// DlgPictArrowModify.cpp : _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgFiBfLiDfGiDiHiDjD_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

#include "stdafx.h"
#include "DynamicDraw.h"
#include "ZOrder.h"			// For FCZOrder.
#include "SheetManager.h"	// For FCSheetManager.
#include "UtilStr.h"		// For GetResString.
#include "DlgInputStr.h"	// For CFCDlgInputStr.
#include "DlgPictArrowModify.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CFCDlgPictArrowModify _xZkqqHx_iDfPiDeDiDeBiDiNiDeP_xHqqkZx_


CFCDlgPictArrowModify::CFCDlgPictArrowModify (CWnd* pParent /*=NULL*/) : BASE_CLASS(pParent)
{
	//{{AFX_DATA_INIT(CFCDlgPictArrowModify)
		// _xZkqqHx_iDiBiDiC_xHqqkZx_ - ClassWizard _xZkqqHx_iCmNiClBiCmMiImKjChFiCmJiDhNiDgCiDhDiDjDiDePjHhAiCmMiDhNiDeOiDiNiCpAjCmHiJmBiCnMiClNiCmNiNoNiPjMiClFiCnMiClHiBeC_xHqqkZx_
	//}}AFX_DATA_INIT
} // CFCDlgPictArrowModify::CFCDlgPictArrowModify.

void CFCDlgPictArrowModify::DoDataExchange(CDataExchange* pDX)
{
	BASE_CLASS::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFCDlgPictArrowModify)
		// _xZkqqHx_iDiBiDiC_xHqqkZx_ - ClassWizard _xZkqqHx_iCmNiClBiCmMiImKjChFiCmJiDhNiDgCiDhDiDjDiDePjHhAiCmMiDhNiDeOiDiNiCpAjCmHiJmBiCnMiClNiCmNiNoNiPjMiClFiCnMiClHiBeC_xHqqkZx_
	//}}AFX_DATA_MAP
} // CFCDlgPictArrowModify::DoDataExchange.

/////////////////////////////////////////////////////////////////////////////
// CFCDlgPictArrowModify _xZkqqHx_iDiGiBfLiDfFiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgPictArrowModify::SetPictArrowRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiMiDfCiBfLiDgIiCpAjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgPictArrowModify::SetPictArrowRec (const FCPictArrowRec& rec)
{
	m_pictArrowRec = rec;
} // CFCDlgPictArrowModify::SetPictArrowRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgPictArrowModify::GetPictArrowRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiMiDfCiBfLiDgIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const FCPictArrowRec& CFCDlgPictArrowModify::GetPictArrowRec () const
{
	return m_pictArrowRec;
} // CFCDlgPictArrowModify::GetPictArrowRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgPictArrowModify::GetEditdrawCommand
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iCmHiCmMiDeHiDgGiDeCiDgCiDgHiDgIiDiNiBfLiCpAiLeOjDkOiClHiCoJiCkJiOhHjCoIiClHiCoJiClNiCnPiCmMiDfCiDhNiDjDiDgIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const wchar_t* CFCDlgPictArrowModify::GetEditdrawCommand () const
{
	return L"arrowedit";
} // CFCDlgPictArrowModify::GetEditdrawCommand.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgPictArrowModify::ReceiveRecFromSheet
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfGiBfLiDgHiCkJiCoHiBeBiDiMiDfCiBfLiDgIiPoOjFpBiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDeHiDgGiDeCiDgCiDgHiDgIiDiNiBfLiCkJiCoHiDgGiBfLiDfOiOpDjAeNiClFiClNiCmGiCkLiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgPictArrowModify::ReceiveRecFromSheet (const FCSheetManager& sheetManager)
{
	// _xZkqqHx_iChJiDeJiBfLiDfPiBfLiCpAiOoGjDlOiBeC_xHqqkZx_
	FCZOrder zOrder0;
	FCZOrder zOrder1;
	sheetManager.GetSheet(0)->GetZOrder(zOrder0, FDOZ_ON_ANY);
	sheetManager.GetSheet(1)->GetZOrder(zOrder1, FDOZ_ON_ANY);
	WString strPictArrowName;
	if (m_pictArrowRec.m_objpPictArrowMaster1 == NULL)
	//----- _xZkqqHx_iDeBiDiNiBfLiDeHiDgGiDeCiDfOiLeOjDkOiPpDjBnEiCkKiDeBiDiNiBfLjAfGiLeLiNoMjAkMiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// IDS_UNTITLED_PICT_ARROW = "_xZkqqHx_jGlDjBoIjGoOiIpD_xHqqkZx_"
		strPictArrowName = GetResWString(IDS_UNTITLED_PICT_ARROW);
	} else
	//----- _xZkqqHx_iDeBiDiNiBfLiDeHiDgGiDeCiDfOiLeOjDkOiPpDjBnEiCkKiDeBiDiNiBfLiPeDjAlDiCmMiPoKiNiH_xHqqkZx_ -----
	{
		strPictArrowName = m_pictArrowRec.m_szName;
	}
	//----- _xZkqqHx_iDeBiDiNiBfLjGlMiCpAiDfPiDeDiDeBiDiNiDePiCmFjAnNjCoI_xHqqkZx_ -----
	CFCDlgInputStr dlgStr;
	// IDS_MSG_INPUT_ENTRY_NAME = "_xZkqqHx_jDgPjIfOjGlMiCpAjDpMjHmNiClFiCmEiCkNiClOiClDiCkC_xHqqkZx_"
	dlgStr.m_strTitle = GetResWString(IDS_MSG_INPUT_ENTRY_NAME);
	dlgStr.m_strInput = strPictArrowName;
	if (dlgStr.DoModal() == IDOK)
		strPictArrowName = TStrToWStr(dlgStr.m_strInput);
	// _xZkqqHx_iDeBiDiNiBfLjFjEjFgJiCpAjDgPjIfOiBeCjDoAjFjEiCmFiMlLiNnNiCmMjBeJjBpAiCoAjFmPiNfIiBeC_xHqqkZx_
	m_pictArrowRec.Init(zOrder0.Front(), zOrder1.Front(), strPictArrowName);
} // CFCDlgPictArrowModify::ReceiveRecFromSheet.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgPictArrowModify::SetRecToSheet
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfGiBfLiDgHiCmJiBeBiDiMiDfCiBfLiDgIiPoOjFpBiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDeHiDgGiDeCiDgCiDgHiDgIiDiNiBfLiCpAiLeOjDkOiClHiCoJiCmGiCkLiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	sheetManager	:_xZkqqHx_iDfGiBfLiDgHiDhNiDgMiBfLiDfHiDiDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			szName			:_xZkqqHx_iDiMiDfCiBfLiDgIjGlMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgPictArrowModify::SetRecToSheet (FCSheetManager& sheetManager, wchar_t szName[]) const
{
	ASSERT(sheetManager.GetSheetIDSize() == 1);
	WString wstrName;
	// IDS_ARROW_FOR_BOTH = "_xZkqqHx_iLkEjHhAjGoOiIpD_xHqqkZx_"
	wstrName.LoadString(IDS_ARROW_FOR_BOTH);
	sheetManager.ModifySheet(0, wstrName.c_str());
	SheetID stidNew;
	// IDS_ARROW_FOR_WIDE_POLY = "_xZkqqHx_jFjNiNeMjApMjAoKjHhAjGoOiIpD_xHqqkZx_"
	wstrName.LoadString(IDS_ARROW_FOR_WIDE_POLY);
	sheetManager.InsertSheet(stidNew, wstrName.c_str(), 1, 1);
	//----- _xZkqqHx_iDfGiBfLiDgH_xHqqkZx_1_xZkqqHx_iCmJiDiMiDeDiDiEiBfL_xHqqkZx_1_xZkqqHx_iCpAjBhNjDpM_xHqqkZx_ -----
	// "_xZkqqHx_iDiMiDeDiDiEiBfL_xHqqkZx_1"_xZkqqHx_iBeC_xHqqkZx_
	WString strName;
	strName.Format(L"%s1", ::GetResWString(IDS_UNTITLED_LAYER));
	sheetManager.GetSheet(1)->InsertLayer(1, strName, FDOZ_ON_ALL);
	sheetManager.GetSheet(1)->SetCurrentLayerIdx(1);
	//----- _xZkqqHx_iDfGiBfLiDgHiDhNiDgMiBfLiDfHiDiDiCmJiDeBiDiNiBfLjFjEjFgJiCpAjAnNjCoI_xHqqkZx_ -----
	if (m_pictArrowRec.m_objpPictArrowMaster1 != NULL)
		sheetManager.GetSheet(0)->AppendToLZOrder(m_pictArrowRec.m_objpPictArrowMaster1);
	if (m_pictArrowRec.m_objpPictArrowMaster2 != NULL)
		sheetManager.GetSheet(1)->AppendToLZOrder(m_pictArrowRec.m_objpPictArrowMaster2);
	// IDS_UNTITLED_PICT_ARROW = "_xZkqqHx_jGlDjBoIjGoOiIpD_xHqqkZx_"
	if (wcslen(m_pictArrowRec.m_szName) != 0)
		wcscpy(szName, m_pictArrowRec.m_szName);
	else
		wcscpy(szName, GetResWString(IDS_UNTITLED_PICT_ARROW));
} // CFCDlgPictArrowModify::SetRecToSheet.

BEGIN_MESSAGE_MAP(CFCDlgPictArrowModify, BASE_CLASS)
	//{{AFX_MSG_MAP(CFCDlgPictArrowModify)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFCDlgPictArrowModify _xZkqqHx_iDiBiDgCiDfKiBfLiDfH_xHqqkZx_ _xZkqqHx_iDgOiDjDiDgIiDiJ_xHqqkZx_

