// DynamicDrawDoc.cpp : _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgFiBfLiDfGiDiHiDjD_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

#include "stdafx.h"
#include <float.h>				// For DBL_MAX.
#include <io.h>					// For _topen.
#include <fcntl.h>				// For _O_RDWR.
#include <share.h>				// For _SH_DENYWR.
#include "DynamicDraw.h"
#include "Env.h"				// For g_pEnv.
#include "UtilMisc.h"			// For FdtimeToFdsec.
#include "UtilStr.h"			// For FormatResString.
#include "UtilErr.h"			// For FMessageBox.etc.
#include "UtilFile.h"			// For FFMakeUniqTmpFileName.etc.
#include "UtilWin.h"			// For ExecMolipDraw.
#include "UtilRepair.h"			// For BackupRepairDocName.etc.
#include "RegData.h"			// For SaveRepairDocName.etc.
#include "HiCommandTable.h"	// For m_pGate->XXX.
#include "DynamicDb.h"		// For g_pFileServer.
#include "DynamicDrawView.h"	// For g_pView.
#include "FrameWnd.h"			// For FFGetMainWnd().
#include "DynamicDrawDoc.h"		// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// Superclass_xZkqqHx_iCmMjCoIiLgAiBeC_xHqqkZx_

// _xZkqqHx_iDhEiDiJiDgCiDfGiDiFiCpAiClHiCoJiOjOiKnEiCmMiNmFiPkMjCgMiBeCjFgCjAjEiBeCiClBiClBiCpAiCoNiClEiCmGiNiCiCkNiClFiCmEiDgFiDfIiDgHiBeC_xHqqkZx_
#define FD_THRESHOLD_FLUSH_TIME		5

/////////////////////////////////////////////////////////////////////////////
// CFCDynamicDrawDoc

IMPLEMENT_DYNCREATE(CFCDynamicDrawDoc, CFCCommonDrawDoc)

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDynamicDrawDoc::CFCDynamicDrawDoc
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.12.23 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCDynamicDrawDoc::CFCDynamicDrawDoc ()
{
//----- 06.05.24 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iMlLiNnNiCmMjHjKjHpAiDhEiDeAiDeDiDiLiImKjChFiCpAiDiKiDfKiDgCiDgHiBeC_xHqqkZx_
//	m_fliLastSavedSessionIdx = -1;
//----- 06.05.24 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iDhEiDiJiDgCiDfGiDiFjCiGiCpAiJpAiPjMiBeC_xHqqkZx_
	m_bIsDoingFlushAll = FALSE;
} // CFCDynamicDrawDoc::CFCDynamicDrawDoc.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDynamicDrawDoc::OnRepairDocument
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFlGiPjBiPeDjFjMiPiIjHjNiCpAiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.12.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDynamicDrawDoc::OnRepairDocument ()
{
// 06.02.14 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	AfxDebugBreak();
	// _xZkqqHx_iPeDjFjMiPoOjFpBiCpAiOoGjDlOiBeC_xHqqkZx_
	// _xZkqqHx_iKgFjFmPjAjEiCmMjDoAjHgFiBeC_xHqqkZx_
	// wstrDocFile	_xZkqqHx_iBeGjFnCiPfHjBmOiPnLiCmMjFlGiPjBiDhEiDeAiDeDiDiLjGlMiBeC_xHqqkZx_
	// wstrOrigFile	_xZkqqHx_iBeGjFnCiPfHjBePiCmMjFlGiPjBiDhEiDeAiDeDiDiLiCmMiDfCiDhDiBfLiBeC_xHqqkZx_
	// wstrUndoDir	_xZkqqHx_iBeG_xHqqkZx_Undo_xZkqqHx_iDfCiDhNiDjDiDgIiDgFiBfLiDhFiDiLiCmMiDgHiDgCiDhGiDePiDiLiBfLiDhGiBeC_xHqqkZx_
	//----- _xZkqqHx_jAfGiLeLiNoMjAkMjFnCiPfHiCmFjHiOiClPiClNiPoKiNiH_xHqqkZx_ -----
	// wstrDocFile  = ""
	// wstrOrigFile = "C:\DOCUME~1\FUKUSH~1\LOCALS~1\Temp\{6B73A07D-1F3A-4502-A920-57CFA19DE990}\_Dyn.udw\doc.mdwk"
	// wstrUndoDir  = "C:\DOCUME~1\FUKUSH~1\LOCALS~1\Temp\{6B73A07D-1F3A-4502-A920-57CFA19DE990}\_Dyn.udw"
	//----- _xZkqqHx_iKpJjBlGjFlGiPjBjFnCiPfHiCmFjHiOiClPiClNiPoKiNiH_xHqqkZx_ -----
	// wstrDocFile  = "C:\Documents and Settings\Fukushiro Masayuki\_xZkqqHx_iDgGiDfIiDeOiDgHiDgCiDhG_xHqqkZx_\Untitled.mdpf"
	// wstrOrigFile = "C:\DOCUME~1\FUKUSH~1\LOCALS~1\Temp\{6B73A07D-1F3A-4502-A920-57CFA19DE990}\_Dyn.udw\doc.mdwk"
	// wstrUndoDir  = "C:\DOCUME~1\FUKUSH~1\LOCALS~1\Temp\{6B73A07D-1F3A-4502-A920-57CFA19DE990}\_Dyn.udw"

	WString wstrDocFile, wstrOrigFile, wstrUndoDir;
	::SeeRepairFileStack(&wstrDocFile, &wstrOrigFile, &wstrUndoDir);
	if (wstrUndoDir.IsEmpty() || wstrOrigFile.IsEmpty())
	//---- Undo_xZkqqHx_iDhEiDeAiDeDiDiLiBeBjFlGiPjBiDhEiDeAiDeDiDiLiCmMiDfCiDhDiBfLiDhEiDeAiDeDiDiLjGlMiCkKiLpDiCmMiPoKiNiH_xHqqkZx_ -----
	{
		//---- Undo_xZkqqHx_iDhEiDeAiDeDiDiLiBeBjFlGiPjBiDhEiDeAiDeDiDiLiCmMiDfCiDhDiBfLiDhEiDeAiDeDiDiLiCmNjFeLjAhL_xHqqkZx_ -----
		if (wstrDocFile.IsEmpty())
		{
			// _xZkqqHx_iDgGiDhEiDeIiDiLiDgHjFlGiPjBjGlMiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
			WString strDefName = FFGetApp()->GetDocString(CDocTemplate::docName);
			// _xZkqqHx_jFnEjAeNiDiBiDgCiDfKiBfLiDfHiCpAjAnNjCoIiBeC_xHqqkZx_
			// IDS_ERR_MSG_NOT_REPAIR_DOC = "_xZkqqHx_jFlGiPjBiBhF_xHqqkZx_%s_xZkqqHx_iBhGiCmNiPeDjFjMiCmFiCkLiCnMiClJiCpB_xHqqkZx_"
			::SaveRepairMessage(FormatResString(IDS_ERR_MSG_NOT_REPAIR_DOC, strDefName.c_str()));
		} else
		{
			// _xZkqqHx_jFnEjAeNiDiBiDgCiDfKiBfLiDfHiCpAjAnNjCoIiBeC_xHqqkZx_
			// IDS_ERR_MSG_NOT_REPAIR_DOC = "_xZkqqHx_jFlGiPjBiBhF_xHqqkZx_%s_xZkqqHx_iBhGiCmNiPeDjFjMiCmFiCkLiCnMiClJiCpB_xHqqkZx_"
			::SaveRepairMessage(FormatResString(IDS_ERR_MSG_NOT_REPAIR_DOC, wstrDocFile.c_str()));
		}
		// _xZkqqHx_iPeDjFjMiPiIjHjNjCoCiOhOjHhGiLiBiCpAjAnNjCoIiBeC_xHqqkZx_
		::SaveRepairFilePtr(flint(-2));
		return;
	}


	try
	{
		// _xZkqqHx_jAfGiLeLiNoMjAkMiPpDjBnEiCkJiCoHiDhEiDeAiDeDiDiLiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
		ImportFile(wstrOrigFile, NULL);
		// _xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHiDhEiDeAiDeDiDiLiCmN_xHqqkZx_ReadOnly_xZkqqHx_iCkJiBeI_xHqqkZx_
		m_bIsReadOnly = FALSE;
		// Undo_xZkqqHx_iDgFiBfLiDhFiDiLiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_

		// Undo_xZkqqHx_iDgFiBfLiDhFiDiLiCmMiDgHiDgCiDhGiDePiDiLiBfLiDhGiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiHiCmNiDeHiDiJiBfLiBeC_xHqqkZx_
		// IDS_ERR_MSG_NOT_OPEN_REPAIR_FILE = "_xZkqqHx_iPeDjFjMiDhEiDeAiDeDiDiLiBhF_xHqqkZx_%s_xZkqqHx_iBhGiCkKiDeJiBfLiDhGiDjDiCmFiCkLiCnMiClJiCpBiBeC_xHqqkZx_"
		if (!g_pFileServer->IsTopGroupExist(HString(wstrUndoDir)))
			FFThrowMiscException(IDS_ERR_MSG_NOT_OPEN_REPAIR_FILE, wstrUndoDir.c_str());

		// _xZkqqHx_iDgHiDgCiDhGiDePiDiLiBfLiDhGiCpAiOoGjDlOiBeC_xHqqkZx_
		FCDbGroup dbTopGroup = g_pFileServer->GetTopGroup(HString(wstrUndoDir));
		// Undo_xZkqqHx_iDgFiBfLiDhFiDiLiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiHiCmNiDeHiDiJiBfLiBeC_xHqqkZx_
		// IDS_ERR_MSG_NOT_OPEN_REPAIR_FILE = "_xZkqqHx_iPeDjFjMiDhEiDeAiDeDiDiLiBhF_xHqqkZx_%s_xZkqqHx_iBhGiCkKiDeJiBfLiDhGiDjDiCmFiCkLiCnMiClJiCpBiBeC_xHqqkZx_"
		if (!dbTopGroup.GetIsSubTableExist(FDHI_COMMAND_TABLE_ID))
			FFThrowMiscException(	IDS_ERR_MSG_NOT_OPEN_REPAIR_FILE,
									dbTopGroup.GetSubTableName(FDHI_COMMAND_TABLE_ID).GetTitle().c_str());
		// Undo_xZkqqHx_iDhEiDeAiDeDiDiLiCmMiPiJiKpKiJlLiBeC_xHqqkZx_
		*m_pGate = dbTopGroup;
		// Undo_xZkqqHx_iDhEiDeAiDeDiDiLiCpA_xHqqkZx_READ_xZkqqHx_iDiNiDgCiDeOiBeC_xHqqkZx_
		FCDbReadLock readLock;
		if (!m_pGate->TryLock(readLock))
			FFThrowMiscException(FFGetDDErrorMessage());
		m_lockBankGate.Append(readLock);
		// Undo_xZkqqHx_iDhEiDeAiDeDiDiLiCpAiNfIjAfGiBeC_xHqqkZx_
		m_pGate->UpdateData(readLock);
	} catch (CException* e)
	//----- _xZkqqHx_iDeHiDiJiBfLiPiIjHjN_xHqqkZx_ -----
	{
		// _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiOoGjDlOiBeC_xHqqkZx_
		WString wstrMsg;
		wstrMsg = FFGetErrorMessage(e);
		e->Delete();
		// _xZkqqHx_jFnEjAeNiDiBiDgCiDfKiBfLiDfHiCpAjAnNjCoIiBeC_xHqqkZx_
		::SaveRepairMessage(wstrMsg);
		// _xZkqqHx_iPeDjFjMiPiIjHjNjCoCiOhOjHhGiLiBiCpAjAnNjCoIiBeC_xHqqkZx_
		::SaveRepairFilePtr(flint(-2));
		return;
	}

	// _xZkqqHx_iPeDjFjMiCmM_xHqqkZx_Undo_xZkqqHx_iDhEiDeAiDeDiDiLiImKjChFiCpAiOoGjDlOiBeCjGkCjAnNjCoIiCmMiPoKiNiHiCmN_xHqqkZx_flint(-1)_xZkqqHx_iBeC_xHqqkZx_
	flint filHistEndIndex = ::LoadRepairFilePtr();
	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiCpAjAgJiCnPiCoJiBeC_xHqqkZx_
	flint filHistIndex = m_pGate->GetNextRecordIndex();
	try
	{
		DWORDSet stObjID;	// _xZkqqHx_iNmFiMoDiCmJjBiAiNoMiClDiCoKiClNjFjEjFgJiDiKiDfIiDgHiBeC_xHqqkZx_
		while (filHistEndIndex == flint(-1) || filHistIndex < filHistEndIndex)
		{
			// Redo_xZkqqHx_jFhDiJmCiCmIiCoHiCmOiPeJjHlJiBeC_xHqqkZx_
			if (!CanRedo()) break;
			// Redo_xZkqqHx_iOmAiNhDiBeC_xHqqkZx_
			m_pGate->MoveSessionNext(DWORDSet());
			// _xZkqqHx_iMlLiNnNiCmM_xHqqkZx_Undo_xZkqqHx_iDhEiDeAiDeDiDiLiImKjChFiCpAiOoGjDlOiBeC_xHqqkZx_
			filHistIndex = m_pGate->GetNextRecordIndex();
			// _xZkqqHx_iPeDjFjMiCmM_xHqqkZx_Undo_xZkqqHx_iDhEiDeAiDeDiDiLiImKjChFiCpAjAnNjCoIiBeCiClBiClBiCnMiCmFiCmN_xHqqkZx_Redo_xZkqqHx_iCmFiCkLiClNiBeC_xHqqkZx_
			::SaveRepairFilePtr(filHistIndex);
			// Redo_xZkqqHx_iCmMiDfCiDhNiDjDiDgIiCmFjAnNjCoIiClDiCoKiCoJiMmFjHeMiDiKiBfLiDfHiDiHiDjDiCpAiJpAiPjMiClHiCoJiBeCiNmFiMoDiCmJiCnMiCmGiCnPiCmEjFgAiJoGiBeC_xHqqkZx_
			g_pView->ClearRgn();
		}
	} catch (CException* e)
	//----- _xZkqqHx_iDeHiDiJiBfLiPiIjHjN_xHqqkZx_ -----
	{
		// Undo_xZkqqHx_iDhEiDeAiDeDiDiLiCkK_xHqqkZx_Redo_xZkqqHx_iCmMiOlIjEhDiCmFiClBiClBiCmJiCkNiCoJiDgOiDfJiBeC_xHqqkZx_
		// _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiOoGjDlOiBeC_xHqqkZx_
	    WString wstrMsg;
	    wstrMsg = FFGetErrorMessage(e);
		e->Delete();
		// _xZkqqHx_jFnEjAeNiDiBiDgCiDfKiBfLiDfHiCpAjAnNjCoIiBeC_xHqqkZx_
		::SaveRepairMessage(wstrMsg);
		// _xZkqqHx_iPeDjFjMiPiIjHjNiCpAiMhAjBlBiClHiCoJiClNiCnPiBeBjCoCiOhOjHhGiLiBiCmNiClFiCmIiCkCiBeC_xHqqkZx_
		return;
	}
//----- 06.02.14 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iPeDjFjMiKkOjHlJiBeC_xHqqkZx_Undo_xZkqqHx_iDgFiBfLiDhFiDiLiCpAjFmCiClGiCoJiBeC_xHqqkZx_
	m_pGate->Clear();
//----- 06.02.14 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	//----- _xZkqqHx_iDgGiDfIiDeOiDgHiDgCiDhGiDhEiDeIiDiLiDfPiCpAiOoGjDlO_xHqqkZx_ -----
//----- 06.05.17 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	LPITEMIDLIST pidl;
//	if(!SUCCEEDED(SHGetSpecialFolderLocation(NULL, CSIDL_DESKTOPDIRECTORY, &pidl)))
//	{
//		// _xZkqqHx_jFnEjAeNiDiBiDgCiDfKiBfLiDfHiCpAjAnNjCoIiBeC_xHqqkZx_
//		// IDS_ERR_MSG_NOT_FOUND_DESKTOP = "_xZkqqHx_iDgGiDfIiDeOiDgHiDgCiDhGiDhEiDeIiDiLiDfPiCkKiMkJiCmCiCkJiCoIiCnMiClJiCpB_xHqqkZx_"
//		::SaveRepairMessage(GetResWString(IDS_ERR_MSG_NOT_FOUND_DESKTOP));
//		// _xZkqqHx_iPeDjFjMiPiIjHjNjCoCiOhOjHhGiLiBiCpAjAnNjCoIiBeC_xHqqkZx_
//		::SaveRepairFilePtr(flint(-2));
//		return;
//	}
//	_TCHAR szDesktop[_MAX_PATH + 1];
//	// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKjGlMiCpAiOoGjDlOiBeC_xHqqkZx_
//	SHGetPathFromIDList(pidl, szDesktop);
//	WString wstrDesktop = TStrToWStr(szDesktop);
//	// Get the shell's allocator to free PIDLs
//	//----- _xZkqqHx_iDiPiBfLiDeOjHmMiIoGiCpAiKeKjFpK_xHqqkZx_ -----
//	LPMALLOC lpMalloc;
//	if (!SHGetMalloc(&lpMalloc) && (lpMalloc != NULL))
//	{
//		lpMalloc->Free(pidl);
//		lpMalloc->Release();
//	}
//----- 06.05.17 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	WString wstrDesktop = FFGetDesktopDirectory();
	if(wstrDesktop.IsEmpty())
	//----- _xZkqqHx_iDgGiDfIiDeOiDgHiDgCiDhGiDhEiDeIiDiLiDfPiCkKiMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jFnEjAeNiDiBiDgCiDfKiBfLiDfHiCpAjAnNjCoIiBeC_xHqqkZx_
		// IDS_ERR_MSG_NOT_FOUND_DESKTOP = "_xZkqqHx_iDgGiDfIiDeOiDgHiDgCiDhGiDhEiDeIiDiLiDfPiCkKiMkJiCmCiCkJiCoIiCnMiClJiCpB_xHqqkZx_"
		::SaveRepairMessage(GetResWString(IDS_ERR_MSG_NOT_FOUND_DESKTOP));
		// _xZkqqHx_iPeDjFjMiPiIjHjNjCoCiOhOjHhGiLiBiCpAjAnNjCoIiBeC_xHqqkZx_
		::SaveRepairFilePtr(flint(-2));
		return;
	}
//----- 06.05.17 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iDgGiDhEiDeIiDiLiDgHjFlGiPjBjGlMiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
	WString strDocName;
	if (wstrDocFile.IsEmpty())
	//----- _xZkqqHx_jFlGiPjBiDhEiDeAiDeDiDiLjGlMiCkKjAnNjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		strDocName = FFGetApp()->GetDocString(CDocTemplate::docName);
		// _xZkqqHx_iDhEiDeAiDeDiDiLjGlMiBgJiKgHjCkDiOhBjGlDiClFiBgKiCpAjCmHiJmBiBeC_xHqqkZx_
		wstrDesktop += L"\\";
		wstrDesktop += strDocName;
	} else
	//----- _xZkqqHx_jFlGiPjBiDhEiDeAiDeDiDiLjGlMiCkKjAnNjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		WString strFile;
		// _xZkqqHx_iDhEiDeAiDeDiDiLjAoCjBmOiDhAiDfIjGlMiCpAiDhAiDfIjFjEjFkKiCmGiDhEiDeAiDeDiDiLjGlMjFjEjFkKiCmJjFkKiJpAiClHiCoJiBeC_xHqqkZx_
		::FFSplitFileName(NULL, &strFile, NULL, wstrDocFile);
		// _xZkqqHx_iDhEiDeAiDeDiDiLjGlMiBgJiKgHjCkDiOhBjGlDiClFiBgKiCpAjCmHiJmBiBeC_xHqqkZx_
		wstrDesktop += L"\\";
		wstrDesktop += strFile;
	}
	try
	{
		// Doc_xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCpAiNoMjAkMiBeC_xHqqkZx_
		::FFMakeUniqFileName(wstrDocFile, wstrDesktop, FD_FILE_EXT_PORTABLE_FORMAT);
	} catch (CException* e)
	//----- _xZkqqHx_iDeHiDiJiBfLiPiIjHjN_xHqqkZx_ -----
	{
		// Doc_xZkqqHx_iDhEiDeAiDeDiDiLjGlMiNoMjAkMiDeHiDiJiBfLiCmMiPoKiNiHiBeC_xHqqkZx_
		// _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiOoGjDlOiBeC_xHqqkZx_
	    WString wstrMsg;
	    wstrMsg = FFGetErrorMessage(e);
		e->Delete();
		// _xZkqqHx_jFnEjAeNiDiBiDgCiDfKiBfLiDfHiCpAjAnNjCoIiBeC_xHqqkZx_
		::SaveRepairMessage(wstrMsg);
		// _xZkqqHx_iPeDjFjMiPiIjHjNjCoCiOhOjHhGiLiBiCpAjAnNjCoIiBeC_xHqqkZx_
		::SaveRepairFilePtr(flint(-2));
		return;
	}
//	AfxDebugBreak();
	// Doc_xZkqqHx_iDhEiDeAiDeDiDiLiCpAiDfKiBfLiDhFiClHiCoJiBeCiDiMiDfHiDfIiDgHiDiKiLeMjIfOiCpAjEpAiCkPiCoJiInHiBeB_xHqqkZx_Superclass_xZkqqHx_iKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
	if (!BASE_CLASS::OnSaveDocument(WStrToTStr(wstrDocFile)))
	{
		// _xZkqqHx_jFnEjAeNiDiBiDgCiDfKiBfLiDfHiCpAjAnNjCoIiBeC_xHqqkZx_
		// IDS_ERR_MSG_FAIL_SAVE_FILE = "_xZkqqHx_iDhEiDeAiDeDiDiLiBhF_xHqqkZx_%s_xZkqqHx_iBhGiCmMjFnLjBlGiCmJiOlIjEhDiClFiCnMiClFiClN_xHqqkZx_"
		::SaveRepairMessage(FormatResString(IDS_ERR_MSG_FAIL_SAVE_FILE, wstrDocFile.c_str()));
		// _xZkqqHx_iPeDjFjMiPiIjHjNjCoCiOhOjHhGiLiBiCpAjAnNjCoIiBeC_xHqqkZx_
		::SaveRepairFilePtr(flint(-2));
		return;
	}
	// _xZkqqHx_jFnEjAeNiDiBiDgCiDfKiBfLiDfHiCpAjAnNjCoIiBeC_xHqqkZx_
	// IDS_MSG_COMPLETE_REPAIR_FILE = "_xZkqqHx_iDhEiDeAiDeDiDiLiBhF_xHqqkZx_%s_xZkqqHx_iBhGiCpAiPeDjFjMiClFiCmEjFnLjBlGiClFiCnMiClFiClN_xHqqkZx_"
	::SaveRepairMessage(FormatResString(IDS_MSG_COMPLETE_REPAIR_FILE, wstrDocFile.c_str()));
	// _xZkqqHx_iPeDjFjMiDhEiDeAiDeDiDiLiDfIiDfOiDgCiDeOiCpAiLpDiCmJiClHiCoJiBeC_xHqqkZx_
	::DeleteRepairFileStack();
	// _xZkqqHx_iPeDjFjMiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiCpAiPmBiLiOiClHiCoJiBeC_xHqqkZx_
	::DeleteRepairFilePtr();
	// Undo_xZkqqHx_iPoOjFpBiCpAiDiMiDfHiDfIiDgHiDiKiCkJiCoHiNoNiPjMiBeC_xHqqkZx_
	::DeleteRepairDocName();
} // CFCDynamicDrawDoc::OnRepairDocument.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDynamicDrawDoc::~CFCDynamicDrawDoc
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.12.23 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCDynamicDrawDoc::~CFCDynamicDrawDoc ()
{
//----- 02.12.03 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// MolipDraw_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjFmPjAjEiBeC_xHqqkZx_
//	g_pMolipDoc = NULL;
//----- 02.12.03 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
} // CFCDynamicDrawDoc::~CFCDynamicDrawDoc.

BEGIN_MESSAGE_MAP(CFCDynamicDrawDoc, BASE_CLASS)
	//{{AFX_MSG_MAP(CFCDynamicDrawDoc)
	ON_COMMAND(ID_FILE_WIN_NEW, OnFileWinNew)
	ON_COMMAND(ID_FILE_CLOSE_OPEN, OnFileCloseOpen)
	ON_UPDATE_COMMAND_UI(ID_FILE_CLOSE_OPEN, OnUpdateFileCloseOpen)
	ON_COMMAND(ID_VIEW_COPY_POSITION, OnViewCopyPosition)
	ON_UPDATE_COMMAND_UI(ID_VIEW_COPY_POSITION, OnUpdateViewCopyPosition)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()
// 06.03.04 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	ON_COMMAND(ID_TEST_TEST_TEST0, OnTestTestTest0)
//	ON_COMMAND(ID_FILE_NEW_LOAD_TMPL, OnFileNewLoadTmpl)

//----- 06.02.26 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	ON_COMMAND(ID_VIEW_PASTE_POSITION, OnViewPastePosition)
//	ON_UPDATE_COMMAND_UI(ID_VIEW_PASTE_POSITION, OnUpdateViewPastePosition)
//----- 06.02.26 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/////////////////////////////////////////////////////////////////////////////
// CFCDynamicDrawDoc _xZkqqHx_iDiGiBfLiDfFiKnGjAjEiBeC_xHqqkZx_

//----- 03.09.21 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDynamicDrawDoc::IsOpenDocWin
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHiCpAiDeJiBfLiDhGiDjDiClHiCoJiOjOiBeBjFmKiDeFiDeCiDjDiDgIiDeFiCmFiDeJiBfLiDhGiDjDiClFiCmIiCkPiCoKiCmO_xHqqkZx_
// *			_xZkqqHx_iCmIiCoHiCmIiCkCiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFmKiDeFiDeCiDjDiDgIiDeFiCmIiCoHiCmO_xHqqkZx_ TRUE_xZkqqHx_iBeBjDkPiDeFiDeCiDjDiDgIiDeFiCmIiCoHiCmO_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	CFCMolipDrawApp_xZkqqHx_iCkJiCoHiOmAiNhDiClDiCoKiCoJiBeCiDhEiDeAiDeDiDiLiDfPiDhFiDiLiDeOiDiKiDgCiDeOiCmFiLeOjDkOiCmM_xHqqkZx_
// *			_xZkqqHx_iPoKiNiHiBeB_xHqqkZx_HistDraw_xZkqqHx_iCmFiCkAiCmBiCmEiCoA_xHqqkZx_MolipDraw_xZkqqHx_iCpAiLeOjDkOiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
// *			_xZkqqHx_iClBiCoKiCmJjBmOiJjOiClHiCoJiClNiCnPiBeBiClBiCmMiKnGjAjEiCkKiCkAiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.02.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL CFCDynamicDrawDoc::IsOpenDocWin ()
//{
//	if (GetIsDocumentOpened())
//	//----- _xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHiCkKiDeJiBfLiDhGiDjDiNmPiCnNiCmMiPoKiNiH_xHqqkZx_ -----
//	{
//		if (GetPathName().IsEmpty())
//		//----- _xZkqqHx_iClBiCoKiCnMiCmFiCkKjAfGiLeLiDgIiDeMiDiFiDiBiDjDiDgHiCmMiPoKiNiH_xHqqkZx_ -----
//		{
//			// _xZkqqHx_jHjKjHpAiCkKiKpJiCmJiPjBiCkLiNjOiCnMiCoKiCmEiCkCiCoJiBgJiPeDjAlDiNmPiCnNiBgKiPoKiNiHiBeC_xHqqkZx_
//			if (m_pGate->IsOpened() && IsModified()) return TRUE;
//		} else
//		//----- _xZkqqHx_iKpJjBlGiDgIiDeMiDiFiDiBiDjDiDgHiDhEiDeAiDeDiDiLiCmMiPoKiNiH_xHqqkZx_ -----
//		{
//			return TRUE;
//		}
//	}
//	return FALSE;
//} // CFCDynamicDrawDoc::IsOpenDocWin.
//----- 03.09.21 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDynamicDrawDoc::IsClosableTemporaryDocument
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iIoKiOjOjDeJiCmIjFlGiPjBiBeBiKiOiCmCiDiGiBfLiDfFiCnGiCmMjGoCiNiHiClJjGlDiClFiCmJjFlGiPjBiCpAjFmCiClGiCoJ_xHqqkZx_
 *			_xZkqqHx_iClBiCmGiCkKiCmFiCkLiCoJiCkJiBeI_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFmCiClGiCoJiClBiCmGiCkKiPgPjHiIiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHiCpAiDeJiBfLiDhGiDjDiClHiCoJiOjOiBeBjFmKiDeFiDeCiDjDiDgIiDeFiCmFiDeJiBfLiDhGiDjDiClFiCmIiCkPiCoKiCmO_xHqqkZx_
 *			_xZkqqHx_iCmIiCoHiCmIiCkCiCkJiCmHiCkEiCkJiCpAjElLjCgGiClHiCoJiNnLiCmJiOgHiCoNiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jFlGiPjBiCkKjAfGiLeLiBgJiIoKiOjOjDeJiBgKiKiOiCmCjGkCiPeDjAlDiCmMiPoKiNiHiBeBiDiGiBfLiDfFiCmMiLjGiJmCjGlDiClFiCmJ_xHqqkZx_
 *			_xZkqqHx_jFmCiClGiCoJiClBiCmGiCkKiPgPjHiIiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jHjKjHpAjFlGiPjBiCmMiPoKiNiHiBeBiDhGiDiNiDfHiDeGiDeOiDgHiCkKjFmCiClGiCmEiCkCiCoJiPoKiNiHiBeBiIoKiOjOjDeJiCmIjFlGiPjB_xHqqkZx_
 *			_xZkqqHx_iBgJiDhGiDiNiDfHiDeGiDeOiDgHiBeFjHjKjHpAjFlGiPjBiBgKiCmFjGkCiPeDjAlDiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.09.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCDynamicDrawDoc::IsClosableTemporaryDocument () const
{
	// _xZkqqHx_jFlGiPjBiCkKjFmCiClGiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
	if (!GetIsDocumentOpened()) return TRUE;

//----- 06.02.27 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// OLE_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHiCmMiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
	if (IsEmbedded()) return FALSE;
//----- 06.02.27 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	//----- _xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHiCkKiDeJiBfLiDhGiDjDiNmPiCnNiCmMiPoKiNiH_xHqqkZx_ -----
	if (GetPathName().IsEmpty())
	//----- _xZkqqHx_jAfGiLeLiDgIiDeMiDiFiDiBiDjDiDgHiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jHjKjHpAiCkKjGkCiNoMjAkMiBgJjBkGiClPjGkCiPeDjAlDiBgKiCmMiPoKiNiHiBeC_xHqqkZx_
		if (!m_pGate->IsOpened()) return TRUE;
	}
	return FALSE;
} // CFCDynamicDrawDoc::IsClosableTemporaryDocument.
//----- 03.09.21 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDynamicDrawDoc::SessionEnd
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiCpAiPeJjHlJiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.05.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDynamicDrawDoc::SessionEnd ()
{
//----- 06.05.24 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	if (m_pGate->GetSessionDepth() == 1)
//	//----- _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDgMiDfIiDgHiCmMjAfLiClDiCkK_xHqqkZx_1_xZkqqHx_iBeBjBkGiClPiDfKiDgCiDfGiDiHiDjDiCkKjFnLjBlGiClDiCoKiClNiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiCpAjFnLjBlGiImKjChFiCoGiCoIjGnPiClFiClNiPpDjBnEiCmFiPeDjAlDiCkKjDpMiCmBiClNiPoKiNiHiBeB_xHqqkZx_
//		// _xZkqqHx_iMlLiNnNiCmMjHjKjHpAiDhEiDeAiDeDiDiLiImKjChFiCpAiDiKiDfKiDgCiDgHiBeC_xHqqkZx_
//		if (GetNextSessionIndex() < m_fliLastSavedSessionIdx)
//			m_fliLastSavedSessionIdx = -1;
//	}
//----- 06.05.24 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	// Superclass_xZkqqHx_iKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::SessionEnd();

	if (m_pGate->GetSessionDepth() == 0)
	//----- _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDgMiDfIiDgHiCmMjAfLiClDiCkK_xHqqkZx_0_xZkqqHx_iBeBjBkGiClPiDfKiDgCiDfGiDiHiDjDiCkKjFnLjBlGiClDiCoKiClNiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iPeDjFjMiPoOjFpBiCmMiNfIjAfGiBeC_xHqqkZx_
		UpdateRepairInfo();
	}
} // CFCDynamicDrawDoc::SessionEnd.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDynamicDrawDoc::OpenUndo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	Undo_xZkqqHx_iDhEiDeAiDeDiDiLiCpAiDeJiBfLiDhGiDjDiClHiCoJiBeC_xHqqkZx_
 *
//----- 03.12.17 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpPathName	:_xZkqqHx_iDeJiBfLiDhGiDjDiClHiCoJjFlGiPjBiCmMiDhEiDeAiDeDiDiLjGlMiBeCjGlDiCkCiPoKiNiHiCmN_xHqqkZx_ NULL _xZkqqHx_iIlNiCkCiCmN_xHqqkZx_
// *						 _xZkqqHx_iLpDjFlGiOjKiCpAiOhHjCoIiBeC_xHqqkZx_
//----- 03.12.17 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDeHiDiJiBfLiOjOiCmNjHoBiKePiCpAjEkNjAlGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jAfGiLeLiNoMjAkMiCmMiPoKiNiHiCmNiBeB_xHqqkZx_wcpPathName == NULL_xZkqqHx_iBeCiDgFiDjDiDhGiDiMiBfLiDgHiOhHjCoIiCmF_xHqqkZx_
 *			_xZkqqHx_jAfGiLeLiNoMjAkMiCmMiPoKiNiHiCmNiBeB_xHqqkZx_wcpPathName _xZkqqHx_iCmJiDgFiDjDiDhGiDiMiBfLiDgHiDhEiDeAiDeDiDiLjGlMiCkK_xHqqkZx_
 *			_xZkqqHx_iOhHjCoIiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.12.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDynamicDrawDoc::OpenUndo ()
{
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OpenUndo();

//----- 06.05.24 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iMlLiNnNiCmMjHjKjHpAiDhEiDeAiDeDiDiLiImKjChFiCpAiDiKiDfKiDgCiDgHiBeC_xHqqkZx_
//	m_fliLastSavedSessionIdx = GetNextSessionIndex();
//----- 06.05.24 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_iPeDjFjMiPoOjFpBiCmNiDhGiDiNiDfKiDfI_xHqqkZx_ID(PID)_xZkqqHx_iCpAiDeMiBfLiCmJiDiMiDfHiDfIiDgHiDiKjDgPjIfOiClDiCoKiCmEiCkCiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iPeDjFjMiPoOjFpBiCkKjDkPiClG_xHqqkZx_PID_xZkqqHx_iCmFiKpJiCmJjDgPjIfOiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiBeBiClLiCoKiCpAiJmLiLpDiCmM_xHqqkZx_
	// PID_xZkqqHx_iCmJiInKjDkOiBeCjDkPiClG_xHqqkZx_PID_xZkqqHx_iCmIiCoHiBeBiNkBiOgHiCoNiCoKiCmEiCkCiCoJjDgPjIfOiCmFiCmNjHeMiCoIjDlOiCmIiCkC_xHqqkZx_
	// _xZkqqHx_iClNiCnPiBeBiInKjDkOiClFiCmEiCoAjGoCjBoIjGlDiCkCiBeC_xHqqkZx_
	::BackupRepairDocName();

	// _xZkqqHx_iKpJjBlGiDhEiDeAiDeDiDiLiCpAiKeKiCkCiClNiPoKiNiHiCmFiCoAiBeBiDhEiDeAiDeDiDiLiCpAiDeDiDjDiDhMiBfLiDgHiClFiClNiPoKiNiHiCmN_xHqqkZx_
	// _xZkqqHx_iKpJjBlGiDhEiDeAiDeDiDiLiCmGiInJiCmIiCoJiDfCiDjDiDgFiDjDiDgDiCkKiPiJiKpKiPpDjBnEiCmGiCmIiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iClBiCmMiClNiCnPiBeBiDeJiDiKiDfHiDgJiDiLiDhEiDeAiDeDiDiLiCpA_xHqqkZx_Copy_xZkqqHx_iClHiCoJjFpLjGeAiCmNiCmGiCoKiCmIiCkCiBeC_xHqqkZx_
	// _xZkqqHx_jBfDiCmEiCmMiPoKiNiHiCmFiPiJiKpKiDhEiDeAiDeDiDiLiNoMjAkMiCmN_xHqqkZx_ExportFile_xZkqqHx_iCpAiOgHiCkEiBeC_xHqqkZx_

	// Undo_xZkqqHx_iDhEiDeAiDeDiDiLiCkKjDpMiCmBiCmEiCkCiCoJiDgGiDeCiDiMiDeOiDgHiDiKiCmJiBeBiMlLiNnNiCmMiDhEiDeAiDeDiDiLiCpAiNoMjAkMiBeC_xHqqkZx_
	const WString wstrCopyName = WString(m_pGate->GetTableName().GetTopDirPath()) + L"\\doc" + FD_FILE_EXT_WORK_FORMAT;
	ExportFile(wstrCopyName, FCHeaderInf::GetStcFileVersionString(), TRUE, TRUE);
	// _xZkqqHx_jFnCiPfHjBePiCmJiDfCiDhDiBfLiClFiClNjFlGiPjBiDhEiDeAiDeDiDiLjGlMiBeC_xHqqkZx_
	m_strDocOrigCopyFile = wstrCopyName;
} // CFCDynamicDrawDoc::OpenUndo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDynamicDrawDoc::CloseUndo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	Undo_xZkqqHx_iDhEiDeAiDeDiDiLiCpAiDeOiDiNiBfLiDfJiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDynamicDrawDoc::CloseUndo ()
{
	// Undo_xZkqqHx_iDhEiDeAiDeDiDiLiCkKjFmCiClGiCmEiCkCiCoKiCmOjFjMiLeBiBeC_xHqqkZx_OnNewDocument_xZkqqHx_iCmMiNmFiPiJiCmF_xHqqkZx_DeleteContents
	// _xZkqqHx_iCkKiOmAiNhDiClDiCoKiCoJiInHiBeC_xHqqkZx_
	if (!m_pGate->IsOpened()) return;

	// _xZkqqHx_iDeJiDiKiDfHiDgJiDiLiDhEiDeAiDeDiDiLiBhF_xHqqkZx_m_strDocOrigCopyFile_xZkqqHx_iBhGiCmN_xHqqkZx_Undo_xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCmM_xHqqkZx_
	// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCmJiNnNiCoJiClNiCnPiBeB_xHqqkZx_BASE_CLASS::CloseUndo() _xZkqqHx_iCmFiPjPiOoIiCmJiNoNiPjMiClDiCoKiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iClBiClBiCmFiNoNiPjMiClFiCmIiCkNiCmEiCoAjHmHiCkCiBeC_xHqqkZx_

	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::CloseUndo();

//----- 06.05.24 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iMlLiNnNiCmMjHjKjHpAiDhEiDeAiDeDiDiLiImKjChFiCpAiDiKiDfKiDgCiDgHiBeC_xHqqkZx_
//	m_fliLastSavedSessionIdx = -1;
//----- 06.05.24 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	// Undo_xZkqqHx_iPoOjFpBiCpAiDiMiDfHiDfIiDgHiDiKiCkJiCoHiNoNiPjMiBeC_xHqqkZx_
	::DeleteRepairDocName();
	m_strDocOrigCopyFile.Empty();	// _xZkqqHx_jFnCiPfHjBePiCmJiDfCiDhDiBfLiClFiClNjFlGiPjBiDhEiDeAiDeDiDiLjGlMiBeC_xHqqkZx_
} // CFCDynamicDrawDoc::CloseUndo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDynamicDrawDoc::OnFrameTimer
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDiMiBfLiDiAiDeFiDeCiDjDiDgIiDeFiCmM_xHqqkZx_OnTimer_xZkqqHx_iCkJiCoHiOmAiNhDiBeCiDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCmM_xHqqkZx_
 *			_xZkqqHx_iDhEiDiJiDgCiDfGiDiFjHhAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.06.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDynamicDrawDoc::OnFrameTimer (UINT nIDEvent)
{
	if (nIDEvent == FDTIMER_FRAME_FLUSH)
	//----- _xZkqqHx_iDhEiDiJiDgCiDfGiDiFiDfOiDeDiDhNiBfLiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jHjKjHpAjFlGiPjBiDhEiDeAiDeDiDiLiCpAiDhEiDiJiDgCiDfGiDiFiClHiCoJiBeC_xHqqkZx_
		if (m_pGate->IsOpened() &&
			!IsReadOnly() &&
			!(g_->appMode & FD_RUNMODE_REPAIR_DOCUMENT))
		{
			if (g_pFileServer->GetFdtimeFromFirstModified() != -1 &&
				FD_THRESHOLD_FLUSH_TIME <= FdtimeToFdsec(g_pFileServer->GetFdtimeFromFirstModified()))
			//----- _xZkqqHx_iPeDjAlDiMoDiCmJiOjOiKnEiCkKiMgPiCmBiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
			{
				// Flush_xZkqqHx_jCiGiCmIiCoHiCmOjFjMiLeBiBeC_xHqqkZx_FlushAll _xZkqqHx_iCmFiDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAiDfPiDeDiDeBiDiNiDePjFfMiOkG_xHqqkZx_
				// _xZkqqHx_iClFiClNiPoKiNiHiCmJiBeBiClBiClBiCkKiMmEiCmOiCoKiCoJiClNiCnPiBeC_xHqqkZx_
				if (m_bIsDoingFlushAll) return;
				// _xZkqqHx_iDhEiDiJiDgCiDfGiDiFjCiGiCpAjAnNjCoIiBeC_xHqqkZx_
				m_bIsDoingFlushAll = TRUE;
				// Undo_xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCpA_xHqqkZx_Flush_xZkqqHx_iClHiCoJiBeC_xHqqkZx_
				// _xZkqqHx_iDgPiDgCiDeOiDeBiDgCiDhGiNlHjFkKiDhEiDeAiDeDiDiLiCpAiNoMjAkMiClFiCmIiCkCiBeC_xHqqkZx_
				if (!g_pFileServer->FlushAll2())
					FFThrowMiscException(FFGetDDErrorMessage());
				// _xZkqqHx_iDhEiDiJiDgCiDfGiDiFjCiGiCpAiJpAiPjMiBeC_xHqqkZx_
				m_bIsDoingFlushAll = FALSE;
			}
		}
	} else
	//----- _xZkqqHx_iDhEiDiJiDgCiDfGiDiFiDfOiDeDiDhNiBfLiImIiKePiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
		BASE_CLASS::OnFrameTimer(nIDEvent);
	}
} // CFCDynamicDrawDoc::OnFrameTimer.

//----- 03.05.23 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDynamicDrawDoc::OpenStdAndPtblDocument
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jCmKiPoNiDhEiDeIiBfLiDhNiDgCiDgHiBeBiDhMiBfLiDfOiDhFiDiLiDhEiDeIiBfLiDhNiDgCiDgHiBeBiDhCiDiFiBfLiDeBiDhEiDeIiBfLiDhNiDgCiDgH_xHqqkZx_
// *			_xZkqqHx_iCmMjFlGiPjBiDhEiDeAiDeDiDiLiCpAiKeKiCkNiBeC_xHqqkZx_
// *			OnOpenDocument _xZkqqHx_iCmMiDfEiDhFiKnGjAjEiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpPathName	:_xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iKeKiCkPiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.05.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL CFCDynamicDrawDoc::OpenStdAndPtblDocument (const wchar_t* wcpPathName)
//{
//	//----- _xZkqqHx_iPiJiKpKiDhEiDeAiDeDiDiLiCpAjFkBiOmKiNoMjAkM_xHqqkZx_ -----
//	// TMP_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCmJiDiGiDgKiBfLiDeOiCmIiDhEiDeAiDeDiDiLjGlMiCmFiDfCiDhDiBfLiClHiCoJiBeC_xHqqkZx_
//	// _xZkqqHx_iDhEiDeAiDeDiDiLjBkOjAkLiCoAiDfCiDhDiBfLiClDiCoKiCoJiBeC_xHqqkZx_
//	WString wstrDestName;	// _xZkqqHx_iDfCiDhDiBfLiClDiCoKiClNiDhEiDeAiDeDiDiLiCmMjGlMjBePiBeC_xHqqkZx_
//do {
//	if (!FFCopyToUniqTmpFile(wstrDestName, wcpPathName, L"_MlpDrw"))
//	{
//		// IDS_ERR_MSG_FAIL_FILE_COPY = "_xZkqqHx_iDhEiDeAiDeDiDiLiBhF_xHqqkZx_%s_xZkqqHx_iBhGiCkJiCoHiBhF_xHqqkZx_%s_xZkqqHx_iBhGiCmMiDfCiDhDiBfLiCpAiOlIjEhDiClFiCnMiClFiClNiBeC_xHqqkZx_"
//		::FFErrorBox(IDS_ERR_MSG_FAIL_FILE_COPY,
//									wcpPathName,
//									wstrDestName.c_str());
//		wstrDestName.Empty();
//		break;
//	}
//
//	//----- Superclass_xZkqqHx_iKnGjAjEiOmAiNhD_xHqqkZx_ -----
//	// _xZkqqHx_iImIiJlKiCmMiPiIjHjNjCiGiCkJiCoH_xHqqkZx_DeleteContents_xZkqqHx_iCpAiOmAiNhDiBeC_xHqqkZx_
//	if (!BASE_CLASS::OnOpenDocument(WStrToTStr(wstrDestName)))
//	{
//		break;
//	}
//
//	//----- _xZkqqHx_iDeJiDiKiDfHiDgJiDiLiDhEiDeAiDeDiDiLiCpAiDeJiBfLiDhGiDjD_xHqqkZx_ -----
//	BOOL bIsReadOnly = FALSE;
//	m_iFileHandle = mywsopen(wcpPathName, _O_RDWR, _SH_DENYWR);
//	if (m_iFileHandle == -1)
//	{
//		m_iFileHandle = mywsopen(wcpPathName, _O_RDONLY, _SH_DENYNO);
//		bIsReadOnly = TRUE;
//	}
//	if (m_iFileHandle == -1)
//	{
//		break;
//	}
//
//	if (m_bIsReadOnly != bIsReadOnly)
//	//----- _xZkqqHx_jFkBiOmKiOjOiCmGiDeJiDiKiDfHiDgJiDiLiDhEiDeAiDeDiDiLiDeJiBfLiDhGiDjDiOjOiCmMjBkOjAkLiCkKiInJiCmIiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		break;
//	}
//	//----- _xZkqqHx_iMlLiNnNiCmMiDgGiDeCiDiMiDeOiDgHiDiKiCpAjFmPiNfIiClHiCoJ_xHqqkZx_ -----
//	// _xZkqqHx_iDhEiDeAiDeDiDiLiDhAiDfIjGlMiCkJiCoHiDhAiDfIjFjEjFkKiCpAjFkKjHkDiClHiCoJiBeC_xHqqkZx_
//	WString strDirPath;
//	::FFSplitFileName(&strDirPath, NULL, NULL, wcpPathName);
//	// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
//	::FFSetCurrentDirectory(strDirPath);
//	// _xZkqqHx_iDeJiDiKiDfHiDgJiDiLiDhEiDeAiDeDiDiLjGlMiCpAjAnNjCoIiBeCiDgPiDgCiDeOiDeBiDgCiDhGiCmMiOkJjDkOjFnLjBlGjHhAiBeC_xHqqkZx_
//	m_strDocOrigCopyFile = wstrDestName;
//	return TRUE;
//} while (FALSE);
//
//	if (m_iFileHandle != -1)
//	{
//		// _xZkqqHx_iDeJiDiKiDfHiDgJiDiLiDhEiDeAiDeDiDiLjFkBiOmKiCkJiCoHiDeJiDiKiDfHiDgJiDiLiDhEiDeAiDeDiDiLiDeJiBfLiDhGiDjD_xHqqkZx_
//		// _xZkqqHx_iCnMiCmFiCmMiCoNiClIiCkJiCmMiOjOiKnEiCmMiKnEiCmJiBeBiDhEiDeAiDeDiDiLjBkOjAkLiCkKjFmPiJlLiClFiClNiBeC_xHqqkZx_
//		_close(m_iFileHandle);
//		m_iFileHandle = -1;
//	}
//	if (!wstrDestName.IsEmpty())
//	{
//		FFDeleteFile(wstrDestName);
//		wstrDestName.Empty();
//	}
//	return FALSE;
//
//} // CFCDynamicDrawDoc::OpenStdAndPtblDocument.
//----- 03.05.23 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 03.05.28 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDynamicDrawDoc::OpenStandardDocument
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jCmKiPoNiDhEiDeIiBfLiDhNiDgCiDgHiCmMjFlGiPjBiDhEiDeAiDeDiDiLiCpAiKeKiCkNiBeC_xHqqkZx_
// *			OnOpenDocument _xZkqqHx_iCmMiDfEiDhFiKnGjAjEiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpPathName	:_xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iKeKiCkPiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.05.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL CFCDynamicDrawDoc::OpenStandardDocument (const wchar_t* wcpPathName)
//{
//	//----- Superclass_xZkqqHx_iKnGjAjEiOmAiNhD_xHqqkZx_ -----
//	// _xZkqqHx_iImIiJlKiCmMiPiIjHjNjCiGiCkJiCoH_xHqqkZx_DeleteContents_xZkqqHx_iCpAiOmAiNhDiBeC_xHqqkZx_
//	if (!BASE_CLASS::OnOpenDocument(WStrToTStr(wcpPathName))) return FALSE;
//	return TRUE;
//} // CFCDynamicDrawDoc::OpenStandardDocument.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDynamicDrawDoc::OpenPortableDocument
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhMiBfLiDfOiDhFiDiLiDhEiDeIiBfLiDhNiDgCiDgHiBeBiDhCiDiFiBfLiDeBiDhEiDeIiBfLiDhNiDgCiDgHiCmMjFlGiPjBiDhEiDeAiDeDiDiLiCpAiKeKiCkNiBeC_xHqqkZx_
// *			OnOpenDocument _xZkqqHx_iCmMiDfEiDhFiKnGjAjEiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpPathName	:_xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iKeKiCkPiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.05.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL CFCDynamicDrawDoc::OpenPortableDocument (const wchar_t* wcpPathName)
//{
//	//----- Superclass_xZkqqHx_iKnGjAjEiOmAiNhD_xHqqkZx_ -----
//	// _xZkqqHx_iImIiJlKiCmMiPiIjHjNjCiGiCkJiCoH_xHqqkZx_DeleteContents_xZkqqHx_iCpAiOmAiNhDiBeC_xHqqkZx_
//	if (!BASE_CLASS::OnOpenDocument(WStrToTStr(wcpPathName))) return FALSE;
//	return TRUE;
//} // CFCDynamicDrawDoc::OpenPortableDocument.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDynamicDrawDoc::OpenTemplateFile
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDjDiDhGiDiMiBfLiDgHiDhEiDeIiBfLiDhNiDgCiDgHiCmMiDhEiDeAiDeDiDiLiCpAiKeKiCkNiBeC_xHqqkZx_
// *			OnOpenDocument _xZkqqHx_iCmMiDfEiDhFiKnGjAjEiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpPathName	:_xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iKeKiCkPiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.05.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL CFCDynamicDrawDoc::OpenTemplateFile (const wchar_t* wcpPathName)
//{
//	return FALSE;
//} // CFCDynamicDrawDoc::OpenTemplateFile.
//----- 03.05.28 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDynamicDrawDoc::UpdateRepairInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPeDjFjMiPoOjFpBiCmMiNfIjAfGiCpAiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	Session_xZkqqHx_iPeJjHlJiOjOiCmJiBeBjFmPiNfIiCkKjDpMiCmBiCmEiCkCiCoJiPoKiNiHiCmNiPeDjFjMiPoOjFpBiCpAiDiMiDfHiDfIiDgHiDiKiCnG_xHqqkZx_
 *			_xZkqqHx_iPjBiCkLiNjOiCnNiBeBjDpMiCmBiCmEiCkCiCmIiCkCiPoKiNiHiCmNiPeDjFjMiPoOjFpBiCpAjGjFiPmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.05.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDynamicDrawDoc::UpdateRepairInfo ()
{
	if (IsModified())
	{
		// _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCmJiDhEiDeAiDeDiDiLiDeJiBfLiDhGiDjDiCpAiLeMjIfOiBeCiDhEiDeAiDeDiDiLiPeDjFjMiCmJjEpFiCkGiCmEiBeC_xHqqkZx_
		// m_strDocOrigCopyFile:_xZkqqHx_jFlGiPjBiDhEiDeAiDeDiDiLiCmMiDfCiDhDiBfL_xHqqkZx_ = "_MlpDrwa1.tmp"
		// m_pGate->GetFilePath():Undo_xZkqqHx_iDhEiDeAiDeDiDiLiBeC_xHqqkZx_
// 06.01.06 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		::SaveRepairDocName(TStrToWStr(GetPathName()), m_strDocOrigCopyFile, m_pGate->GetFilePath());
		::SaveRepairDocName(TStrToWStr(GetPathName()), m_strDocOrigCopyFile, WString(m_pGate->GetTableName().GetTopDirPath()));
	} else
	//----- _xZkqqHx_iPeDjAlDiDhEiDiJiDePiCkKiJpAiPjMiClDiCoKiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// Undo_xZkqqHx_iPoOjFpBiCpAiDiMiDfHiDfIiDgHiDiKiCkJiCoHiNoNiPjMiBeC_xHqqkZx_
		::DeleteRepairDocName();
	}
} // CFCDynamicDrawDoc::UpdateRepairInfo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDynamicDrawDoc::OnReqSyncHiviewToDocument
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	[ID_DREQ_SYNC_HIVIEW_TO_DOCUMENT]_xZkqqHx_iCmMiPiIjHjNiKnGjAjEiBeC_xHqqkZx_
 *			_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiB_xHqqkZx_[_xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAjDkPiKpKiClDiClJiCoJiBeC_xHqqkZx_]_xZkqqHx_iCpAiPiIjHjNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ret		:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCmMiMiLiJmKiCpAjFnEiClHiBeC_xHqqkZx_
 *			arg		:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCnGiCmMiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			reqLock	:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCnGiCmMiDiNiDgCiDeOiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FTDocReqResult CFCDynamicDrawDoc::OnReqSyncHiviewToDocument (FCReqBase& ret, FCReqLock& reqLock)
{
	return FD_DRR_OK;
} // CFCDynamicDrawDoc::OnReqSyncHiviewToDocument.

//----- 06.03.17 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDynamicDrawDoc::OnReqPushCurrentToDsm
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	[ID_DREQ_PUSH_CURRENT_TO_DSM]_xZkqqHx_iCmMiPiIjHjNiKnGjAjEiBeC_xHqqkZx_
// *			_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiB_xHqqkZx_[_xZkqqHx_iMlLiNnNiCmMjHjKjHpAiImKjChFiCpAiLeMjIfOiClHiCoJiBeC_xHqqkZx_]_xZkqqHx_iCpAiPiIjHjNiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ret		:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCmMiMiLiJmKiCpAjFnEiClHiBeC_xHqqkZx_
// *			arg		:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCnGiCmMiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
// *			reqLock	:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiKnGjAjEiCnGiCmMiDiNiDgCiDeOiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//FTDocReqResult CFCDynamicDrawDoc::OnReqPushCurrentToDsm (FCReqBase& ret, FCReqLock& reqLock)
//{
//	return FD_DRR_OK;
//} // CFCDynamicDrawDoc::OnReqPushCurrentToDsm.
//----- 06.03.17 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/////////////////////////////////////////////////////////////////////////////
// CFCDynamicDrawDoc _xZkqqHx_jAgGjCgG_xHqqkZx_

#ifdef _DEBUG
void CFCDynamicDrawDoc::AssertValid() const
{
	BASE_CLASS::AssertValid();
} // CFCDynamicDrawDoc::AssertValid.

void CFCDynamicDrawDoc::Dump(CDumpContext& dc) const
{
	BASE_CLASS::Dump(dc);
} // CFCDynamicDrawDoc::Dump.
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CFCDynamicDrawDoc _xZkqqHx_iDfGiDiKiDeBiDiJiDeDiDfJ_xHqqkZx_

/////////////////////////////////////////////////////////////////////////////
// CFCDynamicDrawDoc _xZkqqHx_iDeJiBfLiDgPiBfLiDiJiDeDiDgIiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDynamicDrawDoc::SetModifiedFlag
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPeDjAlDiDhEiDiJiDePiCmMjAnNjCoIiBeCiPeDjAlDiCkKjDpMiCmBiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCmJiJjOiClGiCmEiBeB_xHqqkZx_
 *			_xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCmMiPeDjFjMiLeMjIfOiCpAjAnNjCoIiClHiCoJiClNiCnPiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bModified	:_xZkqqHx_iPeDjAlDiBeFjGkCiPeDjAlDiCmMjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.02.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDynamicDrawDoc::SetModifiedFlag (BOOL bModified)
{
//----- 03.05.22 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ( )-----
////	AfxDebugBreak();
//	// ReadOnly _xZkqqHx_iIlNiCkCiCmN_xHqqkZx_ _xZkqqHx_iPeDjFjMiDiCiBfLiDgIiCmIiCoHiCmOjFjMiLeBiBeC_xHqqkZx_
//// 00.12.22 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
////	if (IsReadOnly() || (g_->appMode & FD_RUNMODE_REPAIR_DOCUMENT)) return;
//	if (!FFCanEditDocument() || (g_->appMode & FD_RUNMODE_REPAIR_DOCUMENT)) return;
//
////----- 00.09.18 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	if (IsModified() != bModified)
////	//----- _xZkqqHx_iPeDjAlDiPoOjFpBiCkKiBeBiKpJiCmJjAnNjCoIiClDiCoKiCmEiCkCiCoJiCmMiCmGiInJiCmIiCoJiPoKiNiH_xHqqkZx_ -----
////----- 00.09.18 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//	if (!(g_->appMode & FD_RUNMODE_EMBEDDED) && IsModified() != bModified)
//	//----- OLE_xZkqqHx_iLeOjDkOiCmFiCmNiCmIiCkNiBeBiPeDjAlDiPoOjFpBiCkKiKpJiCmJjAnNjCoIiClDiCoKiCmEiCkCiCoJiCmMiCmGiInJiCmIiCoJiPoKiNiH_xHqqkZx_ -----
////----- 00.09.18 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//	{
//		if (bModified)
//		//----- _xZkqqHx_iPeDjAlDiDhEiDiJiDePiCkKjAnNjCoIiClDiCoKiCoJiPoKiNiH_xHqqkZx_ -----
//		{
//			// _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCmJiDhEiDeAiDeDiDiLiDeJiBfLiDhGiDjDiCpAiLeMjIfOiBeCiDhEiDeAiDeDiDiLiPeDjFjMiCmJjEpFiCkGiCmEiBeCiBeC_xHqqkZx_
//			// m_strDocFile:_xZkqqHx_jFlGiPjBiDhEiDeAiDeDiDiL_xHqqkZx_ = "_xZkqqHx_jFlGiPjB_xHqqkZx_1.mdrw"
//			// m_strDocOrigCopyFile:_xZkqqHx_jFlGiPjBiDhEiDeAiDeDiDiLiCmMiDfCiDhDiBfL_xHqqkZx_ = "_MlpDrwa1.tmp"
//			// m_pGate->GetFilePath():Undo_xZkqqHx_iDhEiDeAiDeDiDiLiBeC_xHqqkZx_
//// 03.05.22 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ( )
////			::SaveRepairDocName(m_strDocFile, m_strDocOrigCopyFile, m_pGate->GetFilePath());
//			::SaveRepairDocName(TStrToWStr(GetPathName()), m_strDocOrigCopyFile, m_pGate->GetFilePath());
//		} else
//		//----- _xZkqqHx_iPeDjAlDiDhEiDiJiDePiCkKiJpAiPjMiClDiCoKiCoJiPoKiNiH_xHqqkZx_ -----
//		{
//			// Undo_xZkqqHx_iPoOjFpBiCpAiDiMiDfHiDfIiDgHiDiKiCkJiCoHiNoNiPjMiBeC_xHqqkZx_
//			::DeleteRepairDocName();
//		}
//	}
//	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
//	BASE_CLASS::SetModifiedFlag(bModified);
//----- 03.05.22 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ( )-----
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::SetModifiedFlag(bModified);
	// _xZkqqHx_iPeDjFjMiPoOjFpBiCmMiNfIjAfGiBeC_xHqqkZx_
	UpdateRepairInfo();
//----- 03.05.22 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ( )-----
} // CFCDynamicDrawDoc::SetModifiedFlag.

//----- 06.05.24 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDynamicDrawDoc::IsModified
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPeDjAlDiDhEiDiJiDePiCkKjAnNjCoIiClDiCoKiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPeDjAlDiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	Undo/Redo_xZkqqHx_iOjOiCmJiBeBiNmFiMoDiCmJjFnLjBlGiClDiCoKiClNjHjKjHpAiImKjChFiCmGjEoEiKhCiClFiCmEiBeB_xHqqkZx_
// *			_xZkqqHx_iPeDjAlDiCkJiCmHiCkEiCkJiCpAjElLjCgGiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.08.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL CFCDynamicDrawDoc::IsModified ()
//{
//	// _xZkqqHx_jFiBjCmKiCmJiPeDjAlDiDhEiDiJiDePiCkKjAnNjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
//	if (BASE_CLASS::IsModified()) return TRUE;
//	// _xZkqqHx_iDfCiDhNiDjDiDgIiDgFiBfLiDhFiDiLiCkKiKeKiCkCiCmEiCkCiCmIiCkCiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
//	// _xZkqqHx_iDfCiDhNiDjDiDgIiDgFiBfLiDhFiDiLiCkKiKeKiCkJiCmIiCkCiCmG_xHqqkZx_GetNextSessionIndex()_xZkqqHx_iCmNiOmAiNhDiCmFiCkLiCmIiCkCiBeC_xHqqkZx_
//	if (!m_pGate->IsOpened())
//		return FALSE;
//
//	// _xZkqqHx_iPeDjAlDiDhEiDiJiDePiCkKjAnNjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiHiCmNiBeBjHjKjHpAiImKjChFiCpAjClCiCnHiCoJiBeC_xHqqkZx_
//	// _xZkqqHx_iImIiJlKiCmN_xHqqkZx_FoundDoc_xZkqqHx_iCkJiCoHiInKjDkOiBeC_xHqqkZx_FoundDoc_xZkqqHx_iCmJiCkAiCoJiCmGiBeB_xHqqkZx_HistDrawDoc_xZkqqHx_iCmMiPoKiNiHiCmJ_xHqqkZx_
//	// _xZkqqHx_iCkEiCnMiCkNiNoMjHhAiClFiCmIiCkCiClNiCnPiBeC_xHqqkZx_
//	// _xZkqqHx_jFnLjBlGiMoDiCmJ_xHqqkZx_Undo_xZkqqHx_iClFiClNiPoKiNiHiCmNiBeBiPeDjAlDiDhEiDiJiDePiCkKjHkHiClPiBeB_xHqqkZx_Redo_xZkqqHx_iClFiClNiOjOiCmJ_xHqqkZx_
//	// _xZkqqHx_iPeDjAlDiDhEiDiJiDePiCkKjHiOiClPiCoJiCoGiCkEiCmJiClHiCoJiClNiCnPiCmJiBeBiImIiJlKiCmMiPiIjHjNiCkKiCkAiCoJiBeC_xHqqkZx_
//	return m_fliLastSavedSessionIdx != GetNextSessionIndex();
//} // CFCDynamicDrawDoc::IsModified.
//----- 06.05.24 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDynamicDrawDoc::OnNewDocument
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	[_xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_]->[_xZkqqHx_jAfGiLeLiNoMjAkM_xHqqkZx_]_xZkqqHx_iDfCiDhNiDjDiDgIiCmJiCoGiCmBiCmEiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_SDI_xZkqqHx_iDeBiDhGiDiKiCmFiCmN_xHqqkZx_
 *			_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHiDeJiDhFiDfHiDeGiDeOiDgHiCmN_xHqqkZx_[_xZkqqHx_jAfGiLeLiNoMjAkM_xHqqkZx_]_xZkqqHx_iDfCiDhNiDjDiDgIiCmMjDhIiCmJiNoMiCoIjClMiClDiCoKiCoJ_xHqqkZx_
 *			_xZkqqHx_iClBiCmGjGlDiCkNiBeBiOgHiCkCiCnMiCoNiClFiClDiCoKiCoJiClNiCnPiBeBjGhLiKnGjAjEiCmFiPiJiKpKiJlLiClHiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	: _xZkqqHx_iKnGjAjEiCmMiOmAiNhDiCkKjAkMiMpHiClFiClNiPoKiNiH_xHqqkZx_
 *			FALSE	: _xZkqqHx_iKnGjAjEiCmMiOmAiNhDiCkKiOlIjEhDiClFiClNiPoKiNiH_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.04.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCDynamicDrawDoc::OnNewDocument ()
{
//	AfxDebugBreak();
	// _xZkqqHx_iImIiJlKiCmMiPiIjHjNjCiGiCkJiCoH_xHqqkZx_DeleteContents_xZkqqHx_iCpAiOmAiNhDiBeC_xHqqkZx_
	// OnCloseDocument_xZkqqHx_iCmNiBeBiDeBiDhGiDiKiPeJjHlJiCnMiCmFiOmAiNhDiClDiCoKiCmIiCkCiBeC_xHqqkZx_
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	if (!BASE_CLASS::OnNewDocument())
		return FALSE;
	return TRUE;
} // CFCDynamicDrawDoc::OnNewDocument.

//----- 03.05.28 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDynamicDrawDoc::OnOpenDocument
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHiCpAiDeJiBfLiDhGiDjDiClHiCoJiBeC_xHqqkZx_[_xZkqqHx_iDiBiDgKiDiFiBfL_xHqqkZx_]_xZkqqHx_iBkI_xHqqkZx_[_xZkqqHx_iDhEiDeAiDeDiDiLiDeJiBfLiDhGiDjD_xHqqkZx_]_xZkqqHx_iCmF_xHqqkZx_
// *			_xZkqqHx_iOmAiNhDiClDiCoKiCoJiPoKiNiHiCmGiBeB_xHqqkZx_Windows_xZkqqHx_iCkJiCoHiDhEiDeAiDeDiDiLiDeOiDiKiDgCiDeOiCmJiCoGiCoJjClMjAnKiLeOjDkOiCmF_xHqqkZx_
// *			_xZkqqHx_iMmEiCmOiCoKiCoJiPoKiNiHiCkKiCkAiCoJiBeC_xHqqkZx_
// *			<mdrwpos file="D:\src\DynamicDraw\DynamicDraw_xZkqqHx_iCmMjFlGiPjBiNoMjAkMiOjOiPiIjHjN_xHqqkZx_.mdrw" sheet="0" cposx="136" cposy="154"/>
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lpszPathName	:_xZkqqHx_iDeJiBfLiDhGiDjDiClHiCoJiDhEiDeAiDeDiDiLjGlMiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	: _xZkqqHx_iKnGjAjEiCmMiOmAiNhDiCkKjAkMiMpHiClFiClNiPoKiNiH_xHqqkZx_
// *			FALSE	: _xZkqqHx_iKnGjAjEiCmMiOmAiNhDiCkKiOlIjEhDiClFiClNiPoKiNiH_xHqqkZx_
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	Windows_xZkqqHx_iCkJiCoHiCmMjClMjAnKiLeOjDkOiCmFiCmNiBeB_xHqqkZx_OnNewDocument_xZkqqHx_iCmNiOmAiNhDiClDiCoKiCmIiCkCiClBiCmGiCmJ_xHqqkZx_
// *			_xZkqqHx_jCiNiInD_xHqqkZx_.
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.04.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL CFCDynamicDrawDoc::OnOpenDocument (LPCTSTR lpszPathName)
//{
//	if (lpszPathName == NULL)
//	//----- OLE_xZkqqHx_iLeOjDkOiCmMiPoKiNiH_xHqqkZx_ -----
//	{
//		//----- Superclass_xZkqqHx_iKnGjAjEiOmAiNhD_xHqqkZx_ -----
//		// _xZkqqHx_iImIiJlKiCmMiPiIjHjNjCiGiCkJiCoH_xHqqkZx_DeleteContents_xZkqqHx_iCpAiOmAiNhDiBeC_xHqqkZx_
//		if (!BASE_CLASS::OnOpenDocument(lpszPathName))
//			return FALSE;
//		// TMP_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCmMiJlKiCmJiDiGiDgKiBfLiDeOiCmIiDhEiDeAiDeDiDiLjGlMiCpAiNoMjAkMiBeC_xHqqkZx_
//		WString wstrDestName;	// _xZkqqHx_iDfCiDhDiBfLiClDiCoKiClNiDhEiDeAiDeDiDiLiCmMjGlMjBePiBeC_xHqqkZx_
//		FFMakeUniqTmpFileName(wstrDestName, L"_MlpDrw", L".mdwk");
//		if (!OnSaveDocumentCopyAs(wstrDestName))
//			return FALSE;
//		return TRUE;
//	}
//	//----- OLE_xZkqqHx_iLeOjDkOiCmFiCmNiCmIiCkCiPoKiNiH_xHqqkZx_ -----
//	if (g_->appMode & FD_RUNMODE_REPAIR_DOCUMENT)
//	//----- _xZkqqHx_iPeDjFjMiDiCiBfLiDgIiCmMiPoKiNiH_xHqqkZx_ -----
//	{
//		//----- Superclass_xZkqqHx_iKnGjAjEiOmAiNhD_xHqqkZx_ -----
//		// _xZkqqHx_iImIiJlKiCmMiPiIjHjNjCiGiCkJiCoH_xHqqkZx_DeleteContents_xZkqqHx_iCpAiOmAiNhDiBeC_xHqqkZx_
//		if (!BASE_CLASS::OnOpenDocument(lpszPathName))
//			return FALSE;
//		return TRUE;
//	}
//	//----- _xZkqqHx_iPeDjFjMiDiCiBfLiDgIiCmFiCmNiCmIiCkCiPoKiNiH_xHqqkZx_ -----
//	FTDocumentFormat df = FFFileNameToFormat(TStrToWStr(lpszPathName));
//	switch (df)
//	{
//	case FD_DTP_STANDARD_FORMAT:	// _xZkqqHx_jCmKiPoNiDhEiDeIiBfLiDhNiDgCiDgHiCmMjFlGiPjBiBeC_xHqqkZx_(.mdrw)
//		if (!OpenStandardDocument(TStrToWStr(lpszPathName)))
//			return FALSE;
//		break;
//	case FD_DTP_PORTABLE_FORMAT:	// _xZkqqHx_iDhMiBfLiDfOiDhFiDiLiDhEiDeIiBfLiDhNiDgCiDgHiCmMjFlGiPjBiBeC_xHqqkZx_(.mdpf)
//	case FD_DTP_VIEWER_FORMAT:		// _xZkqqHx_iDhCiDiFiBfLiDeBiDhEiDeIiBfLiDhNiDgCiDgHiCmMjFlGiPjBiBeC_xHqqkZx_(.mdvf)
//	case FD_DTP_WORK_FORMAT:		// _xZkqqHx_iDiPiBfLiDeOiDhEiDeIiBfLiDhNiDgCiDgHiCmMjFlGiPjBiBeC_xHqqkZx_(.mdwk)
//		if (!OpenPortableDocument(TStrToWStr(lpszPathName)))
//			return FALSE;
//		break;
//	case FD_DTP_TEMPLATE_FORMAT:	// _xZkqqHx_iDgFiDjDiDhGiDiMiBfLiDgHiDhEiDeIiBfLiDhNiDgCiDgHiCmMjFlGiPjBiBeC_xHqqkZx_(.mdwt)
//		if (!OpenTemplateFile(TStrToWStr(lpszPathName)))
//			return FALSE;
//		break;
//	default: // FD_DTP_NONE:		// _xZkqqHx_iMfOjGlDiClFiBeC_xHqqkZx_
//		// "_xZkqqHx_iDhEiDeAiDeDiDiLiBhF_xHqqkZx_%s_xZkqqHx_iBhGiCmMiKgHjCkDiOhBiCkKiIoBiCkCiCnMiClH_xHqqkZx_"
//		::FFErrorBox(IDS_ERR_MSG_WRONG_FILE_EXT,
//									(const wchar_t*)TStrToWStr(lpszPathName));
//		return FALSE;
//	}
//	return TRUE;
//
////----- 03.05.22 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//////	AfxDebugBreak();
////	enum {
////		myUNKNOWN_EXT,		// _xZkqqHx_jGkCiDfEiDhMiBfLiDgHiDhEiDeAiDeDiDiLiBeC_xHqqkZx_
////		myTEMPLATE_FORMAT,	// _xZkqqHx_iDgFiDjDiDhGiDiMiBfLiDgHiDhEiDeIiBfLiDhNiDgCiDgHiBeC_xHqqkZx_
////		myDOCUMENT,			// _xZkqqHx_jFlGiPjBiDhEiDeAiDeDiDiLiBeC_xHqqkZx_
////		myREPAIR_MODE,		// _xZkqqHx_iPeDjFjMiDiCiBfLiDgIiBeC_xHqqkZx_
////		myOLE_OBJECT,		// OLE_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
////	} mode;
////	if (lpszPathName != NULL)
////	//----- OLE_xZkqqHx_iLeOjDkOiCmFiCmNiCmIiCkCiPoKiNiH_xHqqkZx_ -----
////	{
////		if (!(g_->appMode & FD_RUNMODE_REPAIR_DOCUMENT))
////		//----- _xZkqqHx_iPeDjFjMiDiCiBfLiDgIiCmFiCmNiCmIiCkCiPoKiNiH_xHqqkZx_ -----
////		{
////			FTDocumentFormat df = FFFileNameToFormat(TStrToWStr(lpszPathName));
////			if (df == FD_DTP_TEMPLATE_FORMAT)
////			//----- _xZkqqHx_iDgFiDjDiDhGiDiMiBfLiDgHiDhEiDeIiBfLiDhNiDgCiDgHiCmMjFlGiPjB_xHqqkZx_ -----
////			{
////				mode = myTEMPLATE_FORMAT;		// _xZkqqHx_iDgFiDjDiDhGiDiMiBfLiDgHiDhEiDeIiBfLiDhNiDgCiDgHiBeC_xHqqkZx_
////			} else
////			if (df == FD_DTP_NONE)
////			//----- _xZkqqHx_jGkCiDfEiDhMiBfLiDgHiDhEiDeIiBfLiDhNiDgCiDgHiCmMjFlGiPjB_xHqqkZx_ -----
////			{
////				mode = myUNKNOWN_EXT;	// _xZkqqHx_jGkCiDfEiDhMiBfLiDgHiDhEiDeAiDeDiDiLiBeC_xHqqkZx_
////			} else
////			//----- _xZkqqHx_iDgFiDjDiDhGiDiMiBfLiDgHiDhEiDeIiBfLiDhNiDgCiDgHiImIiKePiCmMjFlGiPjB_xHqqkZx_ -----
////			{
////				mode = myDOCUMENT;		// _xZkqqHx_jFlGiPjBiDhEiDeAiDeDiDiLiBeC_xHqqkZx_
////			}
////		} else
////		//----- _xZkqqHx_iPeDjFjMiDiCiBfLiDgIiCmMiPoKiNiH_xHqqkZx_ -----
////		{
////			mode = myREPAIR_MODE;	// _xZkqqHx_iPeDjFjMiDiCiBfLiDgIiBeC_xHqqkZx_
////		}
////	} else
////	//----- OLE_xZkqqHx_iLeOjDkOiCmMiPoKiNiH_xHqqkZx_ -----
////	{
////		mode = myOLE_OBJECT;	// OLE_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
////	}
////
////	switch (mode)
////	{
////	case myUNKNOWN_EXT:		// _xZkqqHx_jGkCiDfEiDhMiBfLiDgHiDhEiDeAiDeDiDiLiBeC_xHqqkZx_
////	  {
////		// "_xZkqqHx_iDhEiDeAiDeDiDiLiBhF_xHqqkZx_%s_xZkqqHx_iBhGiCmMiKgHjCkDiOhBiCkKiIoBiCkCiCnMiClH_xHqqkZx_"
////		::FFErrorBox(IDS_ERR_MSG_WRONG_FILE_EXT,
////									(const wchar_t*)TStrToWStr(lpszPathName));
////		 return FALSE;
////	  }
////	case myTEMPLATE_FORMAT:		// _xZkqqHx_iDgFiDjDiDhGiDiMiBfLiDgHiDhEiDeIiBfLiDhNiDgCiDgHiBeC_xHqqkZx_
////	  {
////		FFGetApp()->SetSpecTemplate(TStrToWStr(lpszPathName));
////		AfxGetMainWnd()->SendMessage(WM_COMMAND, ID_FILE_NEW, 0);
////		break;
////	  }
////	case myDOCUMENT:		// _xZkqqHx_jFlGiPjBiDhEiDeAiDeDiDiLiBeC_xHqqkZx_
////		if (!OpenStdAndPtblDocument(TStrToWStr(lpszPathName)))
////			return FALSE;
////		break;
////	case myREPAIR_MODE:	// _xZkqqHx_iPeDjFjMiDiCiBfLiDgIiBeC_xHqqkZx_
////	  {
////		//----- Superclass_xZkqqHx_iKnGjAjEiOmAiNhD_xHqqkZx_ -----
////		// _xZkqqHx_iImIiJlKiCmMiPiIjHjNjCiGiCkJiCoH_xHqqkZx_DeleteContents_xZkqqHx_iCpAiOmAiNhDiBeC_xHqqkZx_
////		if (!BASE_CLASS::OnOpenDocument(lpszPathName))
////			return FALSE;
////		break;
////	  }
////	case myOLE_OBJECT:	// OLE_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
////	  {
////		//----- Superclass_xZkqqHx_iKnGjAjEiOmAiNhD_xHqqkZx_ -----
////		// _xZkqqHx_iImIiJlKiCmMiPiIjHjNjCiGiCkJiCoH_xHqqkZx_DeleteContents_xZkqqHx_iCpAiOmAiNhDiBeC_xHqqkZx_
////		if (!BASE_CLASS::OnOpenDocument(lpszPathName))
////			return FALSE;
////		// TMP_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCmMiJlKiCmJiDiGiDgKiBfLiDeOiCmIiDhEiDeAiDeDiDiLjGlMiCpAiNoMjAkMiBeC_xHqqkZx_
////		WString wstrDestName;	// _xZkqqHx_iDfCiDhDiBfLiClDiCoKiClNiDhEiDeAiDeDiDiLiCmMjGlMjBePiBeC_xHqqkZx_
////		FFMakeUniqTmpFileName(wstrDestName, L"_MlpDrw", L".mdwk");
////		if (!OnSaveDocumentCopyAs(wstrDestName))
////			return FALSE;
////		break;
////	  }
////	}
////	return TRUE;
////----- 03.05.22 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//} // CFCDynamicDrawDoc::OnOpenDocument.
//----- 03.05.28 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDynamicDrawDoc::OnSaveDocument
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	[_xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_] _xZkqqHx_iDiBiDgKiDiFiBfLiCmM_xHqqkZx_ [_xZkqqHx_iPoDiPjBiCkLjFnLjBlG_xHqqkZx_] _xZkqqHx_iCnMiClNiCmN_xHqqkZx_ [_xZkqqHx_jGlMjBePiCpAjFhEiCkPiCmEjFnLjBlG_xHqqkZx_] 
 *			_xZkqqHx_iDfCiDhNiDjDiDgIiCmMiIoKjFjEiCmGiClFiCmEiDhEiDiMiBfLiDiAiDiPiBfLiDeOiCkKiMmEiCnBiPgPiClFiCnMiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lpszPathName	:_xZkqqHx_jFnLjBlGjAoGiCmMiDhEiDeAiDeDiDiLiCmMiDhEiDiLiDhAiDfIjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 OLE_xZkqqHx_iCkJiCoHiLeOjDkOiCmMiPoKiNiHiCmN_xHqqkZx_ NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHiCmMjFnLjBlGiCmJjAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_ 0 _xZkqqHx_iImIiKePjCgMiCpAjFnEiClFiCnMiClHiBeC_xHqqkZx_
 *			_xZkqqHx_iClLiCoKiImIiKePiCmMiPoKiNiHiCmN_xHqqkZx_ 0 _xZkqqHx_iCpAjFnEiClFiCnMiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCDynamicDrawDoc::OnSaveDocument (LPCTSTR lpszPathName)
{
	// _xZkqqHx_iMiLiJmKiBeC_xHqqkZx_
	BOOL bResult = TRUE;
	// _xZkqqHx_iBhFiDeJiDhFiDfHiDeGiDeOiDgHjBhNjDpMiBhGiCmMiBhFiDhEiDeAiDeDiDiLiCpAjBhNjDpMiBhGiCmF_xHqqkZx_DynamicDrawDocument_xZkqqHx_iCpAjBeJjBpAiClFiClN_xHqqkZx_
	// _xZkqqHx_iPoKiNiHiBeBiDhEiDeAiDeDiDiLjBhNjDpMiPiIjHjNjCiGiCmJ_xHqqkZx_OLE_xZkqqHx_iLeOjDkOiBeBiClBiCmMiKnGjAjEiCkKiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
	//----- OLE_xZkqqHx_iLeOjDkOiCmMiPoKiNiHiCmNiBeB_xHqqkZx_Superclass_xZkqqHx_iKnGjAjEiCpAiOmAiNhDiClFiCmEiPeJiCoNiCoIiBeC_xHqqkZx_
	if (lpszPathName == NULL)
	{
		// Superclass_xZkqqHx_iOmAiNhDiMiLiJmKiCpAjFnEiClHiBeC_xHqqkZx_
		bResult = BASE_CLASS::OnSaveDocument(lpszPathName);
	} else
	// Win95_xZkqqHx_iCmMiDhEiDeAiDeDiDiLiDfPiDeDiDeBiDiNiDePiCkK_xHqqkZx_(.mdr)_xZkqqHx_iCpAjFhEiJmBiClFiClNiPoKiNiHiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
	if (!CheckSaveDocName(TStrToWStr(lpszPathName)))
	{
		// "_xZkqqHx_iDhEiDeAiDeDiDiLiBhF_xHqqkZx_%s_xZkqqHx_iBhGiCmMiKgHjCkDiOhBiCkKiIoBiCkCiCnMiClH_xHqqkZx_"
		::FFErrorBox(IDS_ERR_MSG_WRONG_FILE_EXT,
									(const wchar_t*)TStrToWStr(lpszPathName));
		 bResult = FALSE;
	} else
	if (lpszPathName != NULL && GetPathName().CompareNoCase(lpszPathName) != 0)
	//----- OLE_xZkqqHx_iOmAiNhDiCmFiCmNiCmIiCkNiBeBiDhEiDeAiDeDiDiLjGlMiCmJjFmPiNfIiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
		//----- _xZkqqHx_iDhEiDeAiDeDiDiLiPeDjFjMjHhAiCmMiDiMiDfHiDfIiDgHiDiKiLeMjIfOiPiIjHjN_xHqqkZx_ -----
//----- 03.07.29 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//		// _xZkqqHx_jFnCiPfHjCiGiCmMjFlGiPjBiDhEiDeAiDeDiDiLjGlMiCpAjFmPiNfIiBeC_xHqqkZx_
//		m_strDocFile = TStrToWStr(lpszPathName);
//----- 03.07.29 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
		// _xZkqqHx_iNkBiCmMiLeMjIfOiCmNiPmBiLiOiClHiCoJiBeC_xHqqkZx_
		::DeleteRepairDocName();
		// Superclass_xZkqqHx_iKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
		bResult = BASE_CLASS::OnSaveDocument(lpszPathName);
	} else
	if (IsModified())
	//----- _xZkqqHx_iDgGiBfLiDfOiCmJjFmPiNfIiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iNkBiCmMiLeMjIfOiCmNiPmBiLiOiClHiCoJiBeC_xHqqkZx_
		::DeleteRepairDocName();
		// Superclass_xZkqqHx_iKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
//----- 00.09.18 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		BOOL bRet = BASE_CLASS::OnSaveDocument(lpszPathName);
//		// Superclass_xZkqqHx_iOmAiNhDiMiLiJmKiCpAjFnEiClHiBeC_xHqqkZx_
//		return bRet;
//----- 00.09.18 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		// Superclass_xZkqqHx_iOmAiNhDiMiLiJmKiCpAjFnEiClHiBeC_xHqqkZx_
		bResult = BASE_CLASS::OnSaveDocument(lpszPathName);
//----- 00.09.18 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	}
//----- 06.05.24 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	if (bResult)
//	//----- _xZkqqHx_jFnLjBlGiCmMiMiLiJmKiCkKjHmHiCkCiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjCfAjBmMiCmFjHjIjHhAiClHiCoJiPoKiNiHiCmIiCmHiBeBiDfCiDhNiDjDiDgIiDfBiBfLiDgHiCkKiKeKiCkCiCmEiCkCiCmIiCkCiPoKiNiHiCkKiCkAiCoJiBeC_xHqqkZx_
//		// _xZkqqHx_iMlLiNnNiCmMjHjKjHpAiDhEiDeAiDeDiDiLiImKjChFiCpAiDiKiDfKiDgCiDgHiBeC_xHqqkZx_
//		if (m_pGate->IsOpened())
//			m_fliLastSavedSessionIdx = GetNextSessionIndex();
//	}
//----- 06.05.24 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCmJjFmPiNfIiCkKjGlDiCkNiBeBiDgGiBfLiDfOiCmJiPeDjAlDiCoAjGlDiCkCiPoKiNiHiCmNjFnLjBlGiClJiClIjFjMiLeBiBeC_xHqqkZx_
	return bResult;
} // CFCDynamicDrawDoc::OnSaveDocument.

/////////////////////////////////////////////////////////////////////////////
// CFCDynamicDrawDoc _xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDynamicDrawDoc::OnFileWinNew
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFjAfGiLeLiNoMjAkMiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jFmKiDeFiDeCiDjDiDgIiDeFiCmF_xHqqkZx_EXE_xZkqqHx_iCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.12.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDynamicDrawDoc::OnFileWinNew ()
{
//----- 03.09.24 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_jFmKiDeFiDeCiDjDiDgIiDeFiCmFiKeKiCkNiCkJiBeI_xHqqkZx_
//	if (!IsClosableTemporaryDocument())
//	{
//		//----- _xZkqqHx_jFmKiCmI_xHqqkZx_EXE_xZkqqHx_iCpAiLeOjDkOiClHiCoJ_xHqqkZx_ -----
//		if (g_->appMode & FD_RUNMODE_USER_TEMPLATE)
//		//----- _xZkqqHx_iDgFiDjDiDhGiDiMiBfLiDgHiDhEiDeAiDeDiDiLjDpMjHmNiDiCiBfLiDgI_xHqqkZx_ -----
//		{
//			// _xZkqqHx_iDgFiDjDiDhGiDiMiBfLiDgHiDhEiDeAiDeDiDiLiOhHjCoIiCmF_xHqqkZx_Molip Draw_xZkqqHx_iCpAiLeOjDkOiBeC_xHqqkZx_
//			if (!::ExecMolipDraw(L"-usrtmpl")) return;
//			// _xZkqqHx_iDgFiDjDiDhGiDiMiBfLiDgHiDhEiDeAiDeDiDiLjDpMjHmNiDiCiBfLiDgIiCpAiJpAiPjMiBeC_xHqqkZx_
//			g_->appMode &= ~FD_RUNMODE_USER_TEMPLATE;
//		} else
//		{
//			// Molip Draw_xZkqqHx_iCpAiLeOjDkOiBeC_xHqqkZx_
//			if (!::ExecMolipDraw()) return;
//		}
//	} else
//	{
//		// _xZkqqHx_jAfGiLeLiNoMjAkMiDfCiDhNiDjDiDgIiCpAiDhMiDfIiDgHiBeC_xHqqkZx_
//		::PostMessage(AfxGetMainWnd()->GetSafeHwnd(), WM_COMMAND, ID_FILE_NEW, 0);
//	}
//----- 03.09.24 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//----- 03.09.25 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_jAfGiLeLjFlGiPjBiCpAiNoMjAkMiClHiCoJiBeBiCpAjAnNjCoIiBeC_xHqqkZx_
//	PushBackDocRequest(ID_DREQ_NEW_DOCUMENT);
//	// Document_xZkqqHx_jHhGiLiBiCpAiPiIjHjNiBeC_xHqqkZx_
//	ProceedDocRequest();
//----- 03.09.25 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_jFmKiDeFiDeCiDjDiDgIiDeFiCmFiKeKiCkNiCkJiBeI_xHqqkZx_
	if (!IsClosableTemporaryDocument())
	{
		//----- _xZkqqHx_jFmKiCmI_xHqqkZx_EXE_xZkqqHx_iCpAiLeOjDkOiClHiCoJ_xHqqkZx_ -----
		if (!::ExecMolipDraw()) return;
	} else
	{
		// _xZkqqHx_jAfGiLeLiNoMjAkMiDfCiDhNiDjDiDgIiCpAiDhMiDfIiDgHiBeC_xHqqkZx_
		::PostMessage(AfxGetMainWnd()->GetSafeHwnd(), WM_COMMAND, ID_FILE_NEW, 0);
	}
//----- 03.09.25 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//----- 03.09.24 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CFCDynamicDrawDoc::OnFileWinNew.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDynamicDrawDoc::OnFileCloseOpen
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFjFmCiClGiCmEiKeKiCkNiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jFmKiDeFiDeCiDjDiDgIiDeFiCmF_xHqqkZx_EXE_xZkqqHx_iCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.12.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			00.02.02 Fukushiro M. _xZkqqHx_jFmCiClGiCmEiKeKiCkNiPiIjHjNiCmJjFmPiNfIiBeC_xHqqkZx_
 *************************************************************************/
void CFCDynamicDrawDoc::OnFileCloseOpen ()
{
	// _xZkqqHx_jAfGiLeLiNoMjAkMiDfCiDhNiDjDiDgIiCpAiDhMiDfIiDgHiBeC_xHqqkZx_
	(void)::SendMessage(AfxGetMainWnd()->GetSafeHwnd(), WM_COMMAND, ID_FILE_NEW, 0);
	// _xZkqqHx_jFmKiDeFiDeCiDjDiDgIiDeFiCmFiKeKiCkNiCkJiBeI_xHqqkZx_ ID_FILE_NEW_xZkqqHx_iCkKiCkEiCnMiCkNiNhDiCkPiCmOiBeB_xHqqkZx_FALSE _xZkqqHx_iCkKjFnEiCoJiDgOiDfJiBeC_xHqqkZx_
	if (IsClosableTemporaryDocument())
		::PostMessage(AfxGetMainWnd()->GetSafeHwnd(), WM_COMMAND, ID_FILE_OPEN, 0);
} // CFCDynamicDrawDoc::OnFileCloseOpen.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDynamicDrawDoc::OnUpdateFileCloseOpen
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFjFmCiClGiCmEiKeKiCkNiBhGiCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdUI	:_xZkqqHx_iDiBiDgKiDiFiBfLiCmMjFfMiOkGiPpDjBnEiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.07.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDynamicDrawDoc::OnUpdateFileCloseOpen (CCmdUI* pCmdUI)
{
	pCmdUI->Enable(FFCanBasicOperate() && GetIsDocumentOpened());
} // CFCDynamicDrawDoc::OnUpdateFileCloseOpen.

//----- 05.07.31 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDynamicDrawDoc::OnFileNewLoadTmpl
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFiPiJiKpKiJlLiCmGiDgFiDjDiDhGiDiMiBfLiDgHiDhEiDeAiDeDiDiLjDmHiCnNiNjOiCnNiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.12.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void CFCDynamicDrawDoc::OnFileNewLoadTmpl ()
//{
////----- 03.09.25 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////	// _xZkqqHx_jAfGiLeLjFlGiPjBiCpAiNoMjAkMiClHiCoJiBeBiCpAjAnNjCoIiBeC_xHqqkZx_
////	PushBackDocRequest(ID_DREQ_NEW_DOCUMENT);
////----- 03.09.25 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//	// _xZkqqHx_iDgFiDjDiDhGiDiMiBfLiDgHiDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiClHiCoJiBeBiCpAjAnNjCoIiBeC_xHqqkZx_
//	PushBackDocRequest(ID_DREQ_DLG_IMPORT_FILE);
//	// _xZkqqHx_iPpAiMiPiOmAiNhDiBeC_xHqqkZx_
//	PushBackDocRequest(	ID_DREQ_IF,
//						FCReqBase::RETURN, IDOK,
//						FCReqBase::NONE);
//
//		// _xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHiDhEiDeAiDeDiDiLiCpAiKeKiCkNiBeBiCmMiDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiBeC_xHqqkZx_
//		PushBackDocRequest(ID_DREQ_OPEN_DOCUMENT);
//
//	// _xZkqqHx_iPpAiMiPiOmAiNhDiPeJjCfLiBeC_xHqqkZx_
//	PushBackDocRequest(ID_DREQ_END_IF);
//	// _xZkqqHx_iPeJjCfLiCpAjBhNjDpMiBeC_xHqqkZx_
//	PushBackDocRequest(ID_DREQ_END);
//	// Document_xZkqqHx_jHhGiLiBiCpAiPiIjHjNiBeC_xHqqkZx_
//	ProceedDocRequest();
//} // CFCDynamicDrawDoc::OnFileNewLoadTmpl.
//----- 05.07.31 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDynamicDrawDoc::SetTitle
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHiCmMiDfOiDeDiDgHiDiL_xHqqkZx_ (_xZkqqHx_iDhEiDiMiBfLiDiA_xHqqkZx_ _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCmMiDfOiDeDiDgHiDiL_xHqqkZx_ _xZkqqHx_iDgPiBfLiCmJ_xHqqkZx_
 *			_xZkqqHx_jFfMiOkGiClDiCoKiCoJjFlGiOjKjHpB_xHqqkZx_) _xZkqqHx_iCpAjAnNjCoIiClFiCnMiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lpszTitle	:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHiCmMiDfOiDeDiDgHiDiLiCpAjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.06.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDynamicDrawDoc::SetTitle (LPCTSTR lpszTitle)
{
//----- 02.12.03 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iDfOiDeDiDgHiDiLiCmJiOgHiCoNiCoKiCoJiDhEiDeAiDeDiDiLjGlMiCkKiPoNiCmJiDhEiDiLiDhAiDfIiCmFiCkAiCoJiCoGiCkEiCmJjFmPiNfIiClHiCoJiBeC_xHqqkZx_
//	if (!GetPathName().IsEmpty())
//		CFCCommonDrawDoc::SetTitle(GetPathName());
//	else
//		CFCCommonDrawDoc::SetTitle(lpszTitle);
//----- 02.12.03 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iDfOiDeDiDgHiDiLiCmJiOgHiCoNiCoKiCoJiDhEiDeAiDeDiDiLjGlMiCkKiPoNiCmJiDhEiDiLiDhAiDfIiCmFiCkAiCoJiCoGiCkEiCmJjFmPiNfIiClHiCoJiBeC_xHqqkZx_

	// _xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHiCkKiDeJiBfLiDhGiDjD_xHqqkZx_ _xZkqqHx_iKiOiCmCiBeBiDhAiDfIjGlMiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiHiBeC_xHqqkZx_
	// DeleteContents_xZkqqHx_jCiGiCkJiCoHiMmEiCnBiPgPiClFiCmMiPoKiNiHiBeB_xHqqkZx_GetPathName()_xZkqqHx_iCmNiBeBjGkCiClO_xHqqkZx_
	// _xZkqqHx_iOgDiCmBiCmEiCkCiCoJiClNiCnPiBeB_xHqqkZx_GetIsDocumentOpened_xZkqqHx_iCmMiDgAiDeGiDgCiDeOiCkKjFeLjHhGiBeC_xHqqkZx_
	if (GetIsDocumentOpened() && !GetPathName().IsEmpty())
		BASE_CLASS::SetTitle(GetPathName());
	else
		BASE_CLASS::SetTitle(lpszTitle);
//----- 02.12.03 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CFCDynamicDrawDoc::SetTitle.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDynamicDrawDoc::OnViewCopyPosition
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFjFlGiPjBiImKjChFiCpAiDfCiDhDiBfLiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDfCiDhDiBfLiClDiCoKiCoJjFlGiPjBiImKjChFiPoOjFpBiCmNiImIiJlKiCmMiMgAiOkOiBeC_xHqqkZx_
 *		<mdrwpos file="C:\foo\bar\file.mdrw" sheet="0" cposx="78" cposy="114"/>
 *			                  _xZkqqHx_iBkK_xHqqkZx_                   _xZkqqHx_iBkK_xHqqkZx_         _xZkqqHx_iBkK_xHqqkZx_          _xZkqqHx_iBkK_xHqqkZx_
 *			            _xZkqqHx_jFlGiPjBiDhEiDeAiDeDiDiLjGlM_xHqqkZx_           SheetID      mmX        mmY
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.05.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDynamicDrawDoc::OnViewCopyPosition ()
{
	DBLRect mmrt;
	// _xZkqqHx_iDhCiDiFiBfLjCiGjAfDiNmAjFfHiCpAiOfKiPgPiBeC_xHqqkZx_
	g_pView->GetClientRectMM(mmrt);
	const DBLPoint mmpt = mmrt.CenterPoint();
	WString strPos;
	strPos.Format(L"<mdrwpos file=\"%s\" sheet=\"%ld\" cposx=\"%ld\" cposy=\"%ld\"/>",
					(const wchar_t*)TStrToWStr(GetPathName()),
					GetCurrentSheetId(),
					D2L(mmpt.x),
					D2L(mmpt.y));
	CEdit edit;
	edit.Create(0, CRect(0,0,10,10), AfxGetMainWnd(), 100);
	FFSetWindowText(&edit, strPos);
	edit.SetSel(0, -1);	// _xZkqqHx_jBfDjFjEjBeJjBpAiBeC_xHqqkZx_
	edit.Copy();
} // CFCDynamicDrawDoc::OnViewCopyPosition.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDynamicDrawDoc::OnUpdateViewCopyPosition
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFjFlGiPjBiImKjChFiCpAiDfCiDhDiBfLiBhGiCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.05.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDynamicDrawDoc::OnUpdateViewCopyPosition (CCmdUI* pCmdUI)
{
	pCmdUI->Enable(FFCanBasicOperate() && GetIsDocumentOpened() && !GetPathName().IsEmpty());
} // CFCDynamicDrawDoc::OnUpdateViewCopyPosition.

//----- 06.02.26 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDynamicDrawDoc::OnViewPastePosition
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFiDfCiDhDiBfLiClDiCoKiClNjFlGiPjBiImKjChFiCmJiInKjDkOiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhJiBfLiDfIiDgHiClDiCoKiCoJjFlGiPjBiImKjChFiPoOjFpBiCmNiImIiJlKiCmMiMgAiOkOiBeC_xHqqkZx_
// *		<mdrwpos file="C:\foo\bar\file.mdrw" sheet="0" cpos="78,114"/>
// *			                  _xZkqqHx_iBkK_xHqqkZx_                   _xZkqqHx_iBkK_xHqqkZx_        _xZkqqHx_iBkK_xHqqkZx_  _xZkqqHx_iBkK_xHqqkZx_
// *			            _xZkqqHx_jFlGiPjBiDhEiDeAiDeDiDiLjGlM_xHqqkZx_           SheetID     mmX mmY
// *
// *		<mdrwpos file="C:\foo\bar\file.mdrw" sheet="0" cposx="78" cposy="114"/>
// *			                  _xZkqqHx_iBkK_xHqqkZx_                   _xZkqqHx_iBkK_xHqqkZx_         _xZkqqHx_iBkK_xHqqkZx_          _xZkqqHx_iBkK_xHqqkZx_
// *			            _xZkqqHx_jFlGiPjBiDhEiDeAiDeDiDiLjGlM_xHqqkZx_           SheetID      mmX        mmY
// *
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.05.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void CFCDynamicDrawDoc::OnViewPastePosition ()
//{
//	//----- _xZkqqHx_iDeOiDiKiDgCiDhGiDhLiBfLiDgIiCkJiCoHjHjKjHpAjFlGiPjBiImKjChFiPoOjFpBiCpAiOoGiCoIiPgPiClH_xHqqkZx_ -----
//	WString strPos;
//	CEdit edit;
//	edit.Create(WS_CHILD|ES_MULTILINE|ES_AUTOHSCROLL|ES_AUTOVSCROLL, CRect(0,0,10,10), AfxGetMainWnd(), 100);
//	edit.SetSel(0, 0);
//	edit.Paste();
//	FFGetWindowText(&edit, strPos);
//
//	//---- _xZkqqHx_iCnMiClIiBeB_xHqqkZx_"<mdrwpos "_xZkqqHx_iImIjBePiCpAiPjMiLiOiClHiCoJ_xHqqkZx_ -----
//	int iPos = strPos.Find(L"<mdrwpos");
//	if (iPos == -1) return;
//	strPos.Delete(0, iPos + wcslen(L"<mdrwpos"));
//	strPos.TrimLeft();
//
//	//---- ">"_xZkqqHx_iImIiNhOiCpAiPjMiLiOiClHiCoJ_xHqqkZx_ -----
//	iPos = strPos.Find(L'>');
//	if (iPos == -1) return;
//	strPos.Delete(iPos, strPos.GetLength() - iPos);
//	strPos.TrimRight();
//
//	//----- _xZkqqHx_iOoGjDlOiClHiCoJiCnHiCkLjCgMiCmMjFmPjAjE_xHqqkZx_ -----
//	WString strDocFile;					// _xZkqqHx_jFlGiPjBiDhEiDeAiDeDiDiLjGlMiBeC_xHqqkZx_
//	SheetID stid = FD_SHEET_UNSPECIFY;	// _xZkqqHx_iDfGiBfLiDgH_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
//	mmetol mmX = 0;						// _xZkqqHx_jCiGjAfDiNmAjFfHiBeC_xHqqkZx_
//	mmetol mmY = 0;						// _xZkqqHx_jCiGjAfDiNmAjFfHiBeC_xHqqkZx_
//
//	for (;;)
//	{
//		//----- "="_xZkqqHx_iCmMiNlGjBkEiCpAiOoGjDlO_xHqqkZx_ -----
//		iPos = strPos.Find(L'=');
//		if (iPos == -1) break;
//		WString strName = strPos.Left(iPos);
//		strName.TrimLeft();
//		strName.TrimRight();
//		strPos.Delete(0, iPos + 1);
//
//		//----- "="_xZkqqHx_iCmMiJeFjBkEiCpAiOoGjDlO_xHqqkZx_ -----
//		iPos = strPos.Find(L'"');
//		strPos.Delete(0, iPos + 1);
//		iPos = strPos.Find(L'"');
//		WString strValue = strPos.Left(iPos);
//		strValue.TrimLeft();
//		strValue.TrimRight();
//		strPos.Delete(0, iPos + 1);
//
//		if (strName.CompareNoCase(L"file") == 0)
//		{
//			strDocFile = strValue;
//		} else
//		if (strName.CompareNoCase(L"sheet") == 0)
//		{
//			stid = wcstoul(strValue, NULL, 10);
//		} else
//		if (strName.CompareNoCase(L"cposx") == 0)
//		{
//			mmX = wcstod(strValue, NULL);
//		} else
//		if (strName.CompareNoCase(L"cposy") == 0)
//		{
//			mmY = wcstod(strValue, NULL);
//		} else
//		if (strName.CompareNoCase(L"cpos") == 0)
//		{
//			WString strX = ::FFExtractUntil(strValue, L",");
//			WString strY = ::FFExtractUntil(strValue, L",");
//			mmX = wcstod(strX, NULL);
//			mmY = wcstod(strY, NULL);
//		}
//	}
//
//do {
//	// _xZkqqHx_jFlGiPjBiDhEiDeAiDeDiDiLjGlMiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
//	if (strDocFile.IsEmpty()) break;
//	// _xZkqqHx_iDfGiBfLiDgH_xHqqkZx_ID_xZkqqHx_iCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
//	if (stid == FD_SHEET_UNSPECIFY) break;
//
//	// _xZkqqHx_iIoKiOjOjDeJiCmIjFlGiPjBiCmMiPoKiNiHiCmNiBeBiOhHjCoIiCmMiDhEiDeAiDeDiDiLiCpAiKeKiCkNiBeC_xHqqkZx_
//	if (IsClosableTemporaryDocument())
//		FFGetApp()->OpenDocumentFile(WStrToTStr(strDocFile));
//	if (strDocFile.CompareNoCase(TStrToWStr(GetPathName())) == 0)
//	//----- _xZkqqHx_iMlLiNnNiCmMiDhEiDeAiDeDiDiLiCmGiKeKiCkNiCnHiCkLiDhEiDeAiDeDiDiLiCkKiIoKjChGiClHiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iOoGjDlOiClFiClNiNmAjFfHiCkKjCiGjAfDiCmJiCkNiCoJiCoGiCkEiCmJiDfIiDeOiDiNiBfLiDiLiBeC_xHqqkZx_
//		PushBackDocRequest(	ID_DREQ_CHANGE_SHEET_ZOOM_CENTER,
//							FCReqBase::MM_X, mmX,
//							FCReqBase::MM_Y, mmY,
//							FCReqBase::SHEET_ID, stid,
//							FCReqBase::NONE);
//		// _xZkqqHx_iPeJjCfLiCpAjBhNjDpMiBeC_xHqqkZx_
//		PushBackDocRequest(ID_DREQ_END);
//		// Document_xZkqqHx_jHhGiLiBiCpAiPiIjHjNiBeC_xHqqkZx_
//		ProceedDocRequest();
//	} else
//	//----- _xZkqqHx_iMlLiNnNiCmMiDhEiDeAiDeDiDiLiCmGiKeKiCkNiCnHiCkLiDhEiDeAiDeDiDiLiCkKiInJiCmIiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_jDkPiClGjFlGiPjBiDhEiDeAiDeDiDiLjGlMiCmMiDeFiDeCiDjDiDgIiDeFiCpAjCfEiClHiBeC_xHqqkZx_
//		HWND hwnd = ::FFFindDdDocumentWindow(strDocFile);
//		//----- _xZkqqHx_iDfGiBfLiDgHiBeBiDeMiDiDiDjDiDgPiDfIiImKjChFiCpAjFmPiNfIiCmMiDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBjFlGiOjKjHpBiCpAiNoMjAkM_xHqqkZx_ -----
//		FCReqBaseAutoVector vDocRequest;
//		FFInsertDocRequest(vDocRequest, -1,
//						ID_DREQ_CHANGE_SHEET_ZOOM_CENTER,
//						FCReqBase::MM_X, mmX,
//						FCReqBase::MM_Y, mmY,
//						FCReqBase::SHEET_ID, stid,
//						FCReqBase::VIEW_ZOOM_256, 256,
//						FCReqBase::NONE);
//		if (hwnd != NULL)
//		//----- _xZkqqHx_iOhHiOkGiClDiCoKiClNiDhEiDeAiDeDiDiLiCpAiKeKiCkCiCmEiCkCiCoJ_xHqqkZx_Dynamic Draw_xZkqqHx_iCkKiMkJiCmCiCkJiCmBiClNiPoKiNiH_xHqqkZx_ -----
//		{
//			// _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiCmMiDeBiDhGiDiKiCpAiDhEiDeIiDeBiDePiDiJiDjDiDgIiCmJiBeC_xHqqkZx_
//			::SetForegroundWindow(hwnd);
//			// _xZkqqHx_jBiKiOoIjAoGiDeBiDhGiDiKiCmJiDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCpAjBjHjFhEiBeC_xHqqkZx_
//			FFSendDocRequest(hwnd, NULL, vDocRequest);
//		} else
//		//----- _xZkqqHx_iOhHiOkGiClDiCoKiClNiDhEiDeAiDeDiDiLiCpAiKeKiCkCiCmEiCkCiCoJ_xHqqkZx_Dynamic Draw_xZkqqHx_iCkKiMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiH_xHqqkZx_ -----
//		{
//			// Dynamic Draw _xZkqqHx_iCpAiLeOjDkOiBeC_xHqqkZx_
//			FFExecSpecDocRequest(NULL, vDocRequest, strDocFile);
//		}
//	}
//} while (FALSE);
//} // CFCDynamicDrawDoc::OnViewPastePosition.
//----- 06.02.26 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 06.02.26 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDynamicDrawDoc::OnUpdateViewPastePosition
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFiDfCiDhDiBfLiClDiCoKiClNjFlGiPjBiImKjChFiCmJiInKjDkOiBhGiCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.05.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void CFCDynamicDrawDoc::OnUpdateViewPastePosition (CCmdUI* pCmdUI)
//{
//	pCmdUI->Enable(FFCanBasicOperate() && IsClipboardFormatAvailable(CF_TEXT));
//} // CFCDynamicDrawDoc::OnUpdateViewPastePosition.
//----- 06.02.26 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 06.03.04 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//void CFCDynamicDrawDoc::OnTestTestTest0 ()
//{
//----- 06.03.04 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//----- 05.07.22 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	TRACE(_T("%s\n"), GetPathName());
//	return;
//
//	// _xZkqqHx_iLeMjIfOiDfKiDgCiDfGiDiHiDjDiKeKiOgOiKnGjAjEiOmAiNhDiBeC_xHqqkZx_
//	g_pDoc->SessionBegin();
////	for (int i = 0; i < 10; i++)
//	{
//		CmdNop(10000000);
//	}
//	// _xZkqqHx_iLeMjIfOiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
//	g_pDoc->SessionEnd();
//
////----- 02.01.25 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////	// _xZkqqHx_jBeJjBpAjFjEjFgJiCmMiMmFjHeMiDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
////	g_pView->AppendToLastRgn(g_pView->SelectObjVector());
////	// _xZkqqHx_iMmFjHeMiDiKiBfLiDfHiDiHiDjDiCpAiNmEjFgAiJoGiBeC_xHqqkZx_
////	g_pView->SendRgnRedraw();
////----- 02.01.25 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
////	TRACE(_T("Test %s\r\n"), (const _TCHAR*)_i64towcs(4300000000 - m_pGate->GetFileLength(), 10));
//	if (m_pGate->GetFileLength() < flint(4300000000))
//	{
//		::PostMessage(AfxGetMainWnd()->GetSafeHwnd(), WM_COMMAND, ID_TEST_TEST_TEST0, 0);
//	} else
//	{
//		// _xZkqqHx_jBeJjBpAjFjEjFgJiCmMiMmFjHeMiDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
//		g_pView->SetClientToRgn();
//		// _xZkqqHx_iMmFjHeMiDiKiBfLiDfHiDiHiDjDiCpAiNmEjFgAiJoGiBeC_xHqqkZx_
//		g_pView->SendRgnRedraw();
//	}
//----- 05.07.22 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//----- 06.03.04 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	ShellExecute(0, _T("open"), _T("x1.wmv"), NULL, NULL, SW_SHOW);
//} // CFCDynamicDrawDoc::OnTestTestTest0.
//----- 06.03.04 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----


