#ifndef __FileConv_h
#define __FileConv_h

//;----- <EXPORT TO SDK> -----;

//----- 06.05.12 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
typedef HRESULT (WINAPI *FuncAnalyzeVersion) (WString& wstrVersion, const wchar_t* wcpFilePath);
typedef HRESULT (WINAPI *FuncDoConvert) (	const wchar_t* wcpTypeFrom,
											const wchar_t* wcpVersionFrom,
											void* pStorageFrom,
											const wchar_t* wcpTypeTo,
											const wchar_t* wcpVersionTo,
											void* pStorageTo,
											const BYTE* pImageData,
											long lImageSize,
											const CSize& szImage);
//----- 06.05.12 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

//----- 06.05.12 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//struct FCFileConvInfo
//{
//	FCFileConvInfo () {}
//	FCFileConvInfo (const wchar_t* wcpTypeFrom,
//					const wchar_t* wcpVersionFrom,
//					const wchar_t* wcpTypeNameFrom,
//					const wchar_t* wcpTypeTo,
//					const wchar_t* wcpVersionTo,
//					const wchar_t* wcpTypeNameTo,
//					long lLoss,
//					const wchar_t* wcpLossMessage)
//		:wstrTypeFrom(wcpTypeFrom),
//		 wstrVersionFrom(wcpVersionFrom),
//		 wstrTypeNameFrom(wcpTypeNameFrom),
//		 wstrTypeTo(wcpTypeTo),
//		 wstrVersionTo(wcpVersionTo),
//		 wstrTypeNameTo(wcpTypeNameTo),
//		 lLossPoint(lLoss),
//		 wstrLossMessage(wcpLossMessage) {}
//
//	WString		wstrTypeFrom;		// _xZkqqHx_jFmPiKlHiMlDiCmMiDhEiDeAiDeDiDiLiDfOiDeDiDhGiBeCiDfCiDeBiMgAiOkOiCmMiPoKiNiHiCmN_xHqqkZx_"*"_xZkqqHx_iCpAjAoGjDkKiCmJiBeBiClLiCoKiImIiKePiCmM_xHqqkZx_
//									// _xZkqqHx_iPoKiNiHiCmNiDhEiDeAiDeDiDiLiKgHjCkDiOhBiCpAiOhHjCoIiBeC_xHqqkZx_
//									// "*fcore"	:_xZkqqHx_iDhEiDiJiDgCiDgHiDfCiDeBiMgAiOkO_xHqqkZx_
//									// "*ccore"	:_xZkqqHx_jFkBiNiHiDfCiDeBiMgAiOkO_xHqqkZx_
//									// ".mdrw"	:DynamicDraw_xZkqqHx_jCmKiPoNiDhEiDeAiDeDiDiLiBgJiIoKjHoBiBgK_xHqqkZx_
//									// ".mdwt"	:DynamicDraw_xZkqqHx_iDgFiDjDiDhGiDiMiBfLiDgHiDhEiDeAiDeDiDiLiBgJiIoKjHoBiBgK_xHqqkZx_
//	WString		wstrVersionFrom;	// _xZkqqHx_jFmPiKlHiMlDiCmMiDgPiBfLiDfHiDiHiDjDiBeCjHoBiBeG_xHqqkZx_"3.0"
//	WString		wstrTypeNameFrom;	// _xZkqqHx_jFmPiKlHiMlDiCmMiDgIiDeMiDiFiDiBiDjDiDgHiDfOiDeDiDhGjGlMiBeCjHoBiBeG_xHqqkZx_"Dynamic Draw Standard Format"
//	WString		wstrTypeTo;			// _xZkqqHx_jFmPiKlHjAoGiCmMiDhEiDeAiDeDiDiLiDfOiDeDiDhGiBeC_xHqqkZx_wstrTypeFrom_xZkqqHx_iCmMjAoAjGlOiCpAiOfBiPmGiBeC_xHqqkZx_
//	WString		wstrVersionTo;		// _xZkqqHx_jFmPiKlHjAoGiCmMiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_wstrVersionFrom_xZkqqHx_iCmMjAoAjGlOiCpAiOfBiPmGiBeC_xHqqkZx_
//	WString		wstrTypeNameTo;		// _xZkqqHx_jFmPiKlHjAoGiCmMiDgIiDeMiDiFiDiBiDjDiDgHiDfOiDeDiDhGjGlMiBeC_xHqqkZx_wstrTypeNameFrom_xZkqqHx_iCmMjAoAjGlOiCpAiOfBiPmGiBeC_xHqqkZx_
//	long		lLossPoint;			// _xZkqqHx_jFmPiKlHiCmJjElKiCkEiPoOjFpBiPmBiOlIiCmMiDhMiDeDiDjDiDgHjAjEiBeC_xHqqkZx_[0_xZkqqHx_iBgA_xHqqkZx_3]_xZkqqHx_iCmMiCfDjCgJiKeLiCpAiOhHjCoIiBeC_xHqqkZx_
//									// 0:_xZkqqHx_iDiNiDfIiDiMiDfIiBeC_xHqqkZx_
//									// 1:_xZkqqHx_iDgDiBfLiDiLiCmMjBiAiNoMiPoOjFpBiBeBiPiJiKpKjFfMiOkGiImKjChFjDjJiBeBjFjEjFgJiCmJiKnGiMfHiClFiCmIiCkCiPoOjFpBiCmMiPmBiOlIiBeC_xHqqkZx_
//									// 2:_xZkqqHx_iDiKiDjDiDeOiBeB_xHqqkZx_OLE_xZkqqHx_iDgGiBfLiDfOiBeBiDePiDiLiBfLiDhGiPoOjFpBjDjJiBeBjFfMiOkGiCmJiKnGiMfHiClFiCmIiCkCjFjEjFgJiPoOjFpBiCmMiPmBiOlIiBeC_xHqqkZx_
//									// 3:_xZkqqHx_jFfMiOkGiCmJiKnGiMfHiClHiCoJjFjEjFgJiPoOjFpBiCmMiPmBiOlIiBeC_xHqqkZx_
//	WString		wstrLossMessage;	// _xZkqqHx_jFmPiKlHiCmJjElKiCkEiPoOjFpBiPmBiOlIiCmMjDoAjHgFiDiBiDgCiDfKiBfLiDfHiBeC_xHqqkZx_
//}; // struct FCFileConvInfo.
//----- 06.05.12 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
struct FCFileConvInfo
{
	const wchar_t*	wcpTypeFrom;		// _xZkqqHx_jFmPiKlHiMlDiCmMiDhEiDeAiDeDiDiLiDfOiDeDiDhGiBeCiDfCiDeBiMgAiOkOiCmMiPoKiNiHiCmN_xHqqkZx_"*"_xZkqqHx_iCpAjAoGjDkKiCmJiBeBiClLiCoKiImIiKePiCmM_xHqqkZx_
										// _xZkqqHx_iPoKiNiHiCmNiDhEiDeAiDeDiDiLiKgHjCkDiOhBiCpAiOhHjCoIiBeC_xHqqkZx_
										// "*fcore"	:_xZkqqHx_iDhEiDiJiDgCiDgHiDfCiDeBiMgAiOkO_xHqqkZx_
										// "*ccore"	:_xZkqqHx_jFkBiNiHiDfCiDeBiMgAiOkO_xHqqkZx_
										// ".mdrw"	:DynamicDraw_xZkqqHx_jCmKiPoNiDhEiDeAiDeDiDiLiBgJiIoKjHoBiBgK_xHqqkZx_
										// ".mdwt"	:DynamicDraw_xZkqqHx_iDgFiDjDiDhGiDiMiBfLiDgHiDhEiDeAiDeDiDiLiBgJiIoKjHoBiBgK_xHqqkZx_
	const wchar_t*	wcpVersionFrom;		// _xZkqqHx_jFmPiKlHiMlDiCmMiDgPiBfLiDfHiDiHiDjDiBeCjHoBiBeG_xHqqkZx_"3.0"
	const wchar_t*	wcpTypeNameFrom;	// _xZkqqHx_jFmPiKlHiMlDiCmMiDgIiDeMiDiFiDiBiDjDiDgHiDfOiDeDiDhGjGlMiBeCjHoBiBeG_xHqqkZx_"Dynamic Draw Standard Format"
	const wchar_t*	wcpTypeTo;			// _xZkqqHx_jFmPiKlHjAoGiCmMiDhEiDeAiDeDiDiLiDfOiDeDiDhGiBeC_xHqqkZx_wcpTypeFrom_xZkqqHx_iCmMjAoAjGlOiCpAiOfBiPmGiBeC_xHqqkZx_
	const wchar_t*	wcpVersionTo;		// _xZkqqHx_jFmPiKlHjAoGiCmMiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_wcpVersionFrom_xZkqqHx_iCmMjAoAjGlOiCpAiOfBiPmGiBeC_xHqqkZx_
	const wchar_t*	wcpTypeNameTo;		// _xZkqqHx_jFmPiKlHjAoGiCmMiDgIiDeMiDiFiDiBiDjDiDgHiDfOiDeDiDhGjGlMiBeC_xHqqkZx_wcpTypeNameFrom_xZkqqHx_iCmMjAoAjGlOiCpAiOfBiPmGiBeC_xHqqkZx_
	long			lLossPoint;			// _xZkqqHx_jFmPiKlHiCmJjElKiCkEiPoOjFpBiPmBiOlIiCmMiDhMiDeDiDjDiDgHjAjEiBeC_xHqqkZx_[0_xZkqqHx_iBgA_xHqqkZx_3]_xZkqqHx_iCmMiCfDjCgJiKeLiCpAiOhHjCoIiBeC_xHqqkZx_
										// 0:_xZkqqHx_iDiNiDfIiDiMiDfIiBeC_xHqqkZx_
										// 1:_xZkqqHx_iDgDiBfLiDiLiCmMjBiAiNoMiPoOjFpBiBeBiPiJiKpKjFfMiOkGiImKjChFjDjJiBeBjFjEjFgJiCmJiKnGiMfHiClFiCmIiCkCiPoOjFpBiCmMiPmBiOlIiBeC_xHqqkZx_
										// 2:_xZkqqHx_iDiKiDjDiDeOiBeB_xHqqkZx_OLE_xZkqqHx_iDgGiBfLiDfOiBeBiDePiDiLiBfLiDhGiPoOjFpBjDjJiBeBjFfMiOkGiCmJiKnGiMfHiClFiCmIiCkCjFjEjFgJiPoOjFpBiCmMiPmBiOlIiBeC_xHqqkZx_
										// 3:_xZkqqHx_jFfMiOkGiCmJiKnGiMfHiClHiCoJjFjEjFgJiPoOjFpBiCmMiPmBiOlIiBeC_xHqqkZx_
	const wchar_t*	wcpLossMessage;		// _xZkqqHx_jFmPiKlHiCmJjElKiCkEiPoOjFpBiPmBiOlIiCmMjDoAjHgFiDiBiDgCiDfKiBfLiDfHiBeC_xHqqkZx_
}; // struct FCFileConvInfo.
//----- 06.05.12 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

interface IMpgFileConv
{
	virtual void RegisterConvertInfo (GUID clsidPlugIn, const FCFileConvInfo* pFileConvInfo, long lFileConvInfoSize) const;
}; // interface IMpgFileConv.

//;----- </EXPORT TO SDK> -----;

interface IMpgPlugInFileConv;
interface IMpgMolipMain;
class FCUndoArchive;

//----- 05.05.26 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//class FCIMolipMain;
//class FCFileConvManager;
//----- 05.05.26 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 05.05.26 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//typedef void (WINAPI *McvFuncInitializeConv) (IMpgMolipMain* pIMain);
//typedef void (WINAPI *McvFuncTerminateConv) ();
//typedef BOOL (WINAPI *McvFuncAnalyzeVersion) (WString& wstrVersion,
//											const wchar_t* wcpFilePath);
//typedef void (WINAPI *McvFuncDoConvert) (const wchar_t* wcpTypeFrom,
//										const wchar_t* wcpVerFrom,
//										const wchar_t* wcpTypeTo,
//										const wchar_t* wcpVerTo,
////----- 03.06.28 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////										FCUndoArchiveExp* arFrom,
////										FCUndoArchiveExp* arTo,
////----- 03.06.28 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//										FCUndoArchive* arFrom,
//										FCUndoArchive* arTo,
////----- 03.06.28 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//										LPSTORAGE pStorage,
//										BOOL bSameAsLoad,
//										const BYTE* pImageData,
//										long lImageSize,
//										const CSize& szImage);
//----- 05.05.26 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

struct FCConvNode
{
	FCConvNode (const wchar_t* wcpType,
				const wchar_t* wcpVersion,
				const wchar_t* wcpTypeName);

	void	operator = (const FCConvNode& cn);
	void	FindLinkPath (	longVector& vGoodPath,
							long& lGoodLoss,
							const wchar_t* wcpTypeGoal,
							const wchar_t* wcpVersionGoal,
							longVector& vPath,
							long& lLoss);
	void	EnumConvertableTo (longSet& stNodeIdFrom);
	void	EnumConvertableFrom (longSet& stNodeIdTo);

	WString		m_wstrType;			// _xZkqqHx_iDfOiDeDiDhGiBeCjHoBiBeG_xHqqkZx_".mdrw" "*fcore"
	WString		m_wstrVersion;		// _xZkqqHx_iDgPiBfLiDfHiDiHiDjDiBeCjHoBiBeG_xHqqkZx_"3.0"
	WString		m_wstrTypeName;		// _xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHiDfOiDeDiDhGjGlMiBeCjHoBiBeG_xHqqkZx_"Dynamic Draw Standard Format"

	BOOL		m_bPassed;			// Find(_xZkqqHx_iDiLiBfLiDgHiMjPiNpF_xHqqkZx_)_xZkqqHx_iOjOiCmJiOgHjHhAiBeCiKpJiCmJjCmKiJnPiClFiClNiCkJiBeI_xHqqkZx_
	longSet		m_stInflowLinkId;	// _xZkqqHx_iClBiCmMiDgNiBfLiDgIiCnGjDpMiCmBiCmEiCkNiCoJiDiKiDjDiDeOiCmM_xHqqkZx_ID_xZkqqHx_iCmMiPfHiNiHiBeC_xHqqkZx_
	longSet		m_stOutflowLinkId;	// _xZkqqHx_iClBiCmMiDgNiBfLiDgIiCkJiCoHiPgPiCmEiNhDiCkNiDiKiDjDiDeOiCmM_xHqqkZx_ID_xZkqqHx_iCmMiPfHiNiHiBeC_xHqqkZx_
}; // struct FCConvNode.

typedef auto_ptr<FCConvNode>	FCConvNodeAuto;

struct FCConvLink
{
	FCConvLink (long lNodeFrom, long lNodeTo, const GUID& clsidPlugIn,
				long lLoss, const wchar_t* wcpLoss);
	void	Warning () const;
	void	operator = (const FCConvLink& cl);

	long	m_lNodeFrom;
	long	m_lNodeTo;
// 05.05.24 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	WString	m_wstrConvPath;
	GUID	m_clsidPlugIn;
	long	m_lLoss;
	WString	m_wstrLoss;
}; // struct FCConvLink.

class FCFileConvManager
{
public:
	FCFileConvManager ();
	~FCFileConvManager ();

	static void	EnumConvertableTo (	longSet& stNodeIdFrom,
								const wchar_t* wcpTypeGoal,
								const wchar_t* wcpVersionGoal);
	static void	EnumConvertableFrom (longSet& stNodeIdTo,
								const wchar_t* wcpTypeStart,
								const wchar_t* wcpVersionStart);
	BOOL	AnalyzeVersion (WString& wstrVersion, const wchar_t* wcpFilePath);

	void	DoConvert (	const wchar_t* wcpTypeStart,
						const wchar_t* wcpVersionStart,
						void* pStorageStart,
						const wchar_t* wcpTypeGoal,
						const wchar_t* wcpVersionGoal,
						void* pStorageGoal,
						BOOL bShowConvWarnning,
						const BYTE* pImageData = NULL,
						long lImageSize = 0,
						CSize szImage = CSize(0,0));

	static void	GetFileDialogFilterString (	CString& strFilter,
											vector<FCConvNode>& vConvNode,
											BOOL bIsSave,
											WString* wstrpExtPriority,
											long lExtPrioritySize,
											WString* wstrpVerPriority,
											long lVerPrioritySize);

	static FCConvNode* IdToNode (long lNodeId);

	static const FCConvLink&	IdToConvLink (long lId);

//----- 06.03.04 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	static WString	SelectCore (const wchar_t* pStartCore[],
								long lStartCoreSize,
								const wchar_t* wcpVersionStart,
								const wchar_t* wcpTypeGoal,
								const wchar_t* wcpVersionGoal);
//----- 06.03.04 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

friend interface IMpgFileConv;
protected:
	static long	TypeVersionToNodeId (const wchar_t* wcpType,
									const wchar_t* wcpVersion);
	static void	SetTypeVersionToNodeId (const wchar_t* wcpType,
										const wchar_t* wcpVersion,
										long lNodeId);

	static void	RegisterConvertInfo (GUID clsidPlugIn, const FCFileConvInfo* pFileConvInfo, long lFileConvInfoSize);

	IMpgPlugInFileConv* LoadConverter (const GUID& clsidPlugIn);
//----- 06.05.12 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	FuncAnalyzeVersion LoadFuncAnalyzeVersion (const GUID& clsidPlugIn);
//	FuncDoConvert LoadFuncDoConvert (const GUID& clsidPlugIn);
//----- 06.05.12 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	void				FreeAllConverter ();
	static void	FindLinkPath (	longVector& vGoodPath,
								const wchar_t* wcpTypeStart,
								const wchar_t* wcpVersionStart,
								const wchar_t* wcpTypeGoal,
								const wchar_t* wcpVersionGoal);

protected:
	set<GUID>	m_stLoadedPlugIn;
// 06.05.12 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	map<WString, HINSTANCE>	m_mpConvPathToInstance;

protected:
	static vector<FCConvNodeAuto>			s_vNode;
	static map<WString, long>				s_mpTypVerToNodeId;
	static vector<FCConvLink>				s_vConvLink;
}; // class FCFileConvManager.

#endif//__FileConv_h
