#ifndef __FileDialogBase_h
#define __FileDialogBase_h

#include "DbFileDialog.h"	// For Baseclass.

#ifdef SUPER_CLASS
#undef SUPER_CLASS
#endif
#define SUPER_CLASS FCDbFileDialog

class FCFileDialogBase : public SUPER_CLASS
{
protected:
typedef SUPER_CLASS BASE_CLASS;

public:
	FCFileDialogBase (	BOOL bOpenFileDialog,
						const wchar_t* wcpDefExt = NULL,
						const wchar_t* wcpFileName = NULL,
						DWORD dwFlags = OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,
						const wchar_t* wcpFilter = NULL,
						HWND hwndParent = NULL,
						const wchar_t* wcpTitle = NULL);
	virtual void	SetHelpID (DWORD dwId);

protected:
	virtual BOOL	OnInitDialog ();
	virtual void	OnHelp ();
	virtual HBRUSH	OnCtlColor (HDC hDC, HWND hWnd, UINT nCtlColor);
	virtual HBRUSH	OnCtlColor (CDC* pDC, CWnd* pWnd, UINT nCtlColor);
	virtual CWnd*	GetDlgItem (int nID) const;
	virtual CWnd*	GetParent () const;
	virtual void	DDXControl (DWORD dwControlId, CWnd& wndControl);

protected:
	DWORD		m_dwHelpId;
}; // class FCFileDialogBase.

#endif//__FileDialogBase_h
