#include "stdafx.h"
#include "resource.h"			// For IDS_XXX.
#include "UtilMisc.h"			// For FdsecToFiletime.
#include "UtilStr.h"			// For FFLoadString.
#include "UtilErr.h"			// For CFCDDFileException.
#include "UtilStdLib.h"			// For m1_for.
#include "DbLock.h"				// For FCDbReadLock.
#include "HiSummaryTable.h"		// For DHistoryIndex.
#include "HiForkTable.h"		// For FCHiForkTable.
#include "RegData.h"			// For InitRegFont.
#include "HTreeManager.h"		// For m_pHTreeMng.
#include "HiTerminateTable.h"	// For FCHiTerminateTable.
#include "DynamicDb.h"			// For g_pFileServer.
#include "HTreeRec.h"			// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// _xZkqqHx_jHjKjHpAjGnIiCmMjClHiClDiCmMjAkHiMmAjCgMiBgJiDhDiDeOiDfKiDiLiBgKiBeC_xHqqkZx_
// _xZkqqHx_jHjKjHpAjGnIjBfDjBmMiCmMjClHiClDiBgJiKlCiCmMiMlDiCkJiCoHiIoKjEnEjClHiCkCiOhNiCmMjAoGjCfLiCnMiCmFiBgKiCmFiCkAiCoJiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
const long FD_MAX_TREE_LEN = 40000;
const long FD_MIN_TREE_LEN = 200;

// _xZkqqHx_jHjKjHpAjGnIiCmMiCfAiCmCiCmMiOhNiCmMjClHiClDiCmMjAkHiMmAjCgMiBgJiDhDiDeOiDfKiDiLiBgKiBeC_xHqqkZx_
const long FD_MAX_TREE_LIFE_LEN = 20000;
const long FD_MIN_TREE_LIFE_LEN = 20;
const long FD_MAX_BRANCH_LIFE_LEN = 20000;
const long FD_MIN_BRANCH_LIFE_LEN = 40;

// GetZoomLimitTree_xZkqqHx_iBeB_xHqqkZx_GetZoomLimitBranch_xZkqqHx_iCmFjDeLjDjGiCmIiDfJiBfLiDiAjCgMiCpAiMhGiOfKiClHiCoJiNnLiCmJ_xHqqkZx_
// _xZkqqHx_jBoFiCkLiCkNiCmIiCoIiJnPiCkMiCmIiCkCiCoGiCkEiCmJiClHiCoJjAkHiMmAjCgMiBeC_xHqqkZx_
const double FD_MAX_FIT_ZOOM = 8.0;

/////////////////////////////////////////////////////////////////////////////

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	HTRTimeRec::HTRTimeRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.05.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
HTRTimeRec::HTRTimeRec (flint fliSessionIdx,
						const GUID& guidUserId,
						FDSECTIME fdst)
		 :	m_fliSessionIdx(fliSessionIdx),
			m_guidUserId(guidUserId),
			m_fdstTime(fdst), m_y(0)
{
} // HTRTimeRec::HTRTimeRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	HTRTimeRec::GetHintText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhMiDgCiDhGiDhBiDjDiDgHiCmJjFfMiOkGiClHiCoJiCmMiCmJjDeLjDjGiCmIiDiBiDgCiDfKiBfLiDfHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.05.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString HTRTimeRec::GetHintText (const FCHTreeManager* pHtreeManager) const
{
	// _xZkqqHx_iOjOiKnEiDfGiDePiDgJiDiLiCmMiOjOiKnEiBeC_xHqqkZx_
	COleDateTime otmDate = FdsecToFiletime(m_fdstTime);
	// _xZkqqHx_jHoBiBeG_xHqqkZx_2004_xZkqqHx_jEeO_xHqqkZx_8_xZkqqHx_iMiO_xHqqkZx_19_xZkqqHx_jDpK_xHqqkZx_ 0_xZkqqHx_iOjO_xHqqkZx_15_xZkqqHx_jFkK_xHqqkZx_
	// IDS_FORM_DATE_TIME_LONG = "%#Y_xZkqqHx_jEeO_xHqqkZx_%#m_xZkqqHx_iMiO_xHqqkZx_%#d %#H:%#M"
	WString wstrDate = TStrToWStr(otmDate.Format(FFLoadString(IDS_FORM_DATE_TIME_LONG)));
	// IDS_FORM_HTREE_PROPERTY_D =
	//		_xZkqqHx_jDpKiOjO_xHqqkZx_:%s\r\n
	//		_xZkqqHx_iImKjChF_xHqqkZx_:%I64d_xZkqqHx_iDfKiDgCiDfGiDiHiDjD_xHqqkZx_
	return FormatResString(	IDS_FORM_HTREE_PROPERTY_D,
							wstrDate.c_str(),				// _xZkqqHx_jDpKiOjOiBeC_xHqqkZx_
							pHtreeManager->UserIdToUserName(m_guidUserId).c_str(),	// _xZkqqHx_iNoMjAkMiOnCiBeC_xHqqkZx_
							m_fliSessionIdx);				// _xZkqqHx_iImKjChFiBeC_xHqqkZx_
} // HTRTimeRec::GetHintText.

/////////////////////////////////////////////////////////////////////////////

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiLabelRec::FCHiLabelRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fliSessionId	:_xZkqqHx_jHjKjHpAiDhEiDeAiDeDiDiLjCiGiCmMiImKjChFiBeC_xHqqkZx_
 *			guidUserId		:_xZkqqHx_iNoMjAkMiOnCiCpAiOhHjCoIiBeC_xHqqkZx_
 *			fdstCreateTime	:_xZkqqHx_iNoMjAkMiOjOiKnEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			tcpLabel		:_xZkqqHx_iDiJiDhIiDiLjFlGiOjKjHpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCHiLabelRec::FCHiLabelRec (BOOL bIsCreate,
							flint fliSessionIdx,
							const GUID& guidUserId,
							FDSECTIME fdstCreateTime,
							DWORD dwObjectId,
							const wchar_t* tcpLabel)
{
	m_bIsCreate = bIsCreate;			// _xZkqqHx_iNoMjAkMiBeIiNoNiPjMiBeI_xHqqkZx_
	m_fliSessionIndex = fliSessionIdx;	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
	m_guidUserId = guidUserId;			// _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	m_fdstCreateTime = fdstCreateTime;	// _xZkqqHx_iNoMjAkMiOjOiKnEiBeC_xHqqkZx_
	m_dwObjectId = dwObjectId;			// _xZkqqHx_jFjEjFgJ_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	m_strLabel = tcpLabel;				// _xZkqqHx_iDiJiDhIiDiLjFlGiOjKjHpBiBeC_xHqqkZx_
} // FCHiLabelRec::FCHiLabelRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiLabelRec::GetIsCreate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiJiDhIiDiLiNoMjAkMiCmMiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeBiNoNiPjMiCmMiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiJiDhIiDiLiNoMjAkMiCmMiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeBiNoNiPjMiCmMiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCHiLabelRec::GetIsCreate () const
{
	return m_bIsCreate;		// _xZkqqHx_iNoMjAkMiBeIiNoNiPjMiBeI_xHqqkZx_
} // FCHiLabelRec::GetIsCreate.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiLabelRec::GetSessionIndex
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.03.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
flint FCHiLabelRec::GetSessionIndex () const
{
	return m_fliSessionIndex;	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
} // FCHiLabelRec::GetSessionIndex.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiLabelRec::GetLabelString
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiJiDhIiDiLjFlGiOjKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiJiDhIiDiLjFlGiOjKjHpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.01.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FCHiLabelRec::GetLabelString () const
{
	return m_strLabel;
} // FCHiLabelRec::GetLabelString.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiLabelRec::GetObjectId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiJiDhIiDiLjFjEjFgJiCmMjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiJiDhIiDiLjFjEjFgJiCmMjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD FCHiLabelRec::GetObjectId () const
{
	return m_dwObjectId;
} // FCHiLabelRec::GetObjectId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiLabelRec::GetHintText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhMiDgCiDhGiDhBiDjDiDgHiCmJjFfMiOkGiClHiCoJiCmMiCmJjDeLjDjGiCmIiDiBiDgCiDfKiBfLiDfHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.05.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FCHiLabelRec::GetHintText (const FCHTreeManager* pHtreeManager) const
{
	// _xZkqqHx_jDoAjHgFiBeC_xHqqkZx_
	WString wstrContents = GetLabelString();
	// _xZkqqHx_iNmFiMoDiCmMiJpMiNhDiBeFiLpDjEjCjDjJiCpAiPjMiCkNiBeCiJpMiNhDiCmNjFeLiClIjDpMiCmBiCmEiCkCiCoJiBeC_xHqqkZx_
	wstrContents.TrimRight();
	// _xZkqqHx_iNoMjAkMjDpKiOjOiBeC_xHqqkZx_
	COleDateTime otmDate = FdsecToFiletime(m_fdstCreateTime);
	// _xZkqqHx_jHoBiBeG_xHqqkZx_2004_xZkqqHx_jEeO_xHqqkZx_8_xZkqqHx_iMiO_xHqqkZx_19_xZkqqHx_jDpK_xHqqkZx_ 0_xZkqqHx_iOjO_xHqqkZx_15_xZkqqHx_jFkK_xHqqkZx_
	// IDS_FORM_DATE_TIME_LONG = "%#Y_xZkqqHx_jEeO_xHqqkZx_%#m_xZkqqHx_iMiO_xHqqkZx_%#d %#H:%#M"
	const WString wstrDate = TStrToWStr(otmDate.Format(FFLoadString(IDS_FORM_DATE_TIME_LONG)));

	// IDS_FORM_HTREE_PROPERTY_E =
	//		_xZkqqHx_iOoNjFmK_xHqqkZx_:_xZkqqHx_iDiJiDhIiDiLjFjEjFgJ_xHqqkZx_\r\n
	//		_xZkqqHx_jDoAjHgF_xHqqkZx_:%s\r\n
	//		_xZkqqHx_iNoMjAkMjDpKiOjO_xHqqkZx_:%s\r\n
	//		_xZkqqHx_iNoMjAkMiOnC_xHqqkZx_:%s\r\n
	//		_xZkqqHx_iImKjChF_xHqqkZx_:%I64d_xZkqqHx_iDfKiDgCiDfGiDiHiDjD_xHqqkZx_
	return FormatResString(	IDS_FORM_HTREE_PROPERTY_E,
							wstrContents.c_str(),									// _xZkqqHx_jDoAjHgFiBeC_xHqqkZx_
							wstrDate.c_str(),										// _xZkqqHx_iNoMjAkMjDpKiOjOiBeC_xHqqkZx_
							pHtreeManager->UserIdToUserName(m_guidUserId).c_str(),	// _xZkqqHx_iNoMjAkMiOnCiBeC_xHqqkZx_
							m_fliSessionIndex);										// _xZkqqHx_iImKjChFiBeC_xHqqkZx_
} // FCHiLabelRec::GetHintText.

/////////////////////////////////////////////////////////////////////////////

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiForkTagRec::FCHiForkTagRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fliSessionIndex	:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			guidUserId		:_xZkqqHx_iNoMjAkMiOnCiCpAiOhHjCoIiBeC_xHqqkZx_
 *			fdstCreateTime	:_xZkqqHx_iNoMjAkMjDpKiOjOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpTitle		:_xZkqqHx_iDfOiDeDiDgHiDiLjFlGiOjKiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpComment		:_xZkqqHx_iDfCiDiBiDjDiDgHjFlGiOjKiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCHiForkTagRec::FCHiForkTagRec (FCHTreeRec* pHtreeRec,
								flint fliSessionIndex,
								const GUID& guidUserId,
								FDSECTIME fdstCreateTime,
								const wchar_t* wcpTitle,
								const wchar_t* wcpComment,
								double dHtreeScore)
{
	m_pHtreeRec = pHtreeRec;
	m_fliSessionIndex = fliSessionIndex;
	m_guidUserId = guidUserId;			// _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	m_fdstCreateTime = fdstCreateTime;
	m_wstrTitle = wcpTitle;
	m_wstrComment = wcpComment;
	m_dHtreeScore = dHtreeScore;
} // FCHiForkTagRec::FCHiForkTagRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiForkTagRec::GetSessionIndex
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
flint FCHiForkTagRec::GetSessionIndex () const
{
	return m_fliSessionIndex;
} // FCHiForkTagRec::GetSessionIndex.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiForkTagRec::GetUserId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOjOiKnEiDiJiDhIiDiLiNoMjAkMiOnCiCmMiDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOjOiKnEiDiJiDhIiDiLiNoMjAkMiOnCiCmMiDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.10.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
GUID FCHiForkTagRec::GetUserId () const
{
	return m_guidUserId;
} // FCHiForkTagRec::GetUserId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiForkTagRec::GetCreateTime
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCmMiNoMjAkMiOjOiKnEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCmMiNoMjAkMiOjOiKnEiBgJjCfAiImKiBeGjFgCiBgK_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.10.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FDSECTIME FCHiForkTagRec::GetCreateTime () const
{
	return m_fdstCreateTime;
} // FCHiForkTagRec::GetCreateTime.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiForkTagRec::GetTitleString
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfOiDeDiDgHiDiLjFlGiOjKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfOiDeDiDgHiDiLjFlGiOjKjHpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FCHiForkTagRec::GetTitleString () const
{
	return m_wstrTitle;
} // FCHiForkTagRec::GetTitleString.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiForkTagRec::GetCommentString
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDiBiDjDiDgHjFlGiOjKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfCiDiBiDjDiDgHjFlGiOjKjHpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FCHiForkTagRec::GetCommentString () const
{
	return m_wstrComment;
} // FCHiForkTagRec::GetCommentString.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiForkTagRec::GetHtreeScore
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAiDfIiDfCiDeBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jHjKjHpAiDfIiDfCiDeBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
double FCHiForkTagRec::GetHtreeScore () const
{
	return m_dHtreeScore;
} // FCHiForkTagRec::GetHtreeScore.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHiForkTagRec::GetHintText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhMiDgCiDhGiDhBiDjDiDgHiCmJjFfMiOkGiClHiCoJiCmMiCmJjDeLjDjGiCmIiDiBiDgCiDfKiBfLiDfHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FCHiForkTagRec::GetHintText (const FCHTreeManager* pHtreeManager)
{
	COleDateTime otmDateCreate = FdsecToFiletime(m_fdstCreateTime);
	// _xZkqqHx_jHoBiBeG_xHqqkZx_2004_xZkqqHx_jEeO_xHqqkZx_8_xZkqqHx_iMiO_xHqqkZx_19_xZkqqHx_jDpK_xHqqkZx_ 0_xZkqqHx_iOjO_xHqqkZx_15_xZkqqHx_jFkK_xHqqkZx_
	// IDS_FORM_DATE_TIME_LONG = "%#Y_xZkqqHx_jEeO_xHqqkZx_%#m_xZkqqHx_iMiO_xHqqkZx_%#d %#H:%#M"
	WString wstrDateCreate = TStrToWStr(otmDateCreate.Format(FFLoadString(IDS_FORM_DATE_TIME_LONG)));
	// IDS_FORM_HTREE_PROPERTY_F =
	//		_xZkqqHx_iOoNjFmK_xHqqkZx_:_xZkqqHx_jFkKiKpCiDfOiDeP_xHqqkZx_\r\n
	//		_xZkqqHx_iDfOiDeDiDgHiDiL_xHqqkZx_:%s\r\n
	//		_xZkqqHx_jDoAjHgF_xHqqkZx_:%s\r\n
	//		_xZkqqHx_iNoMjAkMjDpKiOjO_xHqqkZx_:%s\r\n
	//		_xZkqqHx_iNoMjAkMiOnC_xHqqkZx_:%s\r\n
	//		_xZkqqHx_iImKjChF_xHqqkZx_:%I64d_xZkqqHx_iDfKiDgCiDfGiDiHiDjD_xHqqkZx_\r\n
	//		_xZkqqHx_iDfIiDfCiDeB_xHqqkZx_:%f\r\n
	//		_xZkqqHx_jHnNjAmPiDfIiDfCiDeB_xHqqkZx_:%f
	return FormatResString(	IDS_FORM_HTREE_PROPERTY_F,
							GetTitleString().c_str(),							// _xZkqqHx_iDfOiDeDiDgHiDiLiBeC_xHqqkZx_
							GetCommentString().c_str(),							// _xZkqqHx_iDfCiDiBiDjDiDgHiBeC_xHqqkZx_
							wstrDateCreate.c_str(),								// _xZkqqHx_iNoMjAkMjDpKiOjOiBeC_xHqqkZx_
							pHtreeManager->UserIdToUserName(m_guidUserId).c_str(),	// _xZkqqHx_iNoMjAkMiOnCiBeC_xHqqkZx_
							GetSessionIndex(),									// _xZkqqHx_iImKjChFiBeC_xHqqkZx_
							GetHtreeScore(),									// _xZkqqHx_iDfIiDfCiDeBiBeC_xHqqkZx_
							m_pHtreeRec->GetAccumulatedHtreeScore(GetSessionIndex() + 1));	// _xZkqqHx_jHnNjAmPjHjKjHpAiDfIiDfCiDeBiBeC_xHqqkZx_
} // FCHiForkTagRec::GetHintText.

/////////////////////////////////////////////////////////////////////////////

//----- 05.09.14 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCTimeLabelRec::FCTimeLabelRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fliSessionIndex	:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lTimeLabelId	:_xZkqqHx_iOjOiKnEiDiJiDhIiDiLjFjEjFgJiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			guidUserId		:_xZkqqHx_iNoMjAkMiOnCiCpAiOhHjCoIiBeC_xHqqkZx_
 *			fdstCreateTime	:_xZkqqHx_iNoMjAkMjDpKiOjOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpContents		:_xZkqqHx_iDfCiDiBiDjDiDgHjFlGiOjKiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCTimeLabelRec::FCTimeLabelRec (flint fliSessionIndex,
								long lTimeLabelId,
								const GUID& guidUserId,
								FDSECTIME fdstCreateTime,
								const wchar_t* wcpContents)
{
	m_fliSessionIndex = fliSessionIndex;
	m_lTimeLabelId = lTimeLabelId;
	m_guidUserId = guidUserId;			// _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	m_fdstCreateTime = fdstCreateTime;
	m_wstrContents = wcpContents;
} // FCTimeLabelRec::FCTimeLabelRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCTimeLabelRec::GetSessionIndex
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
flint FCTimeLabelRec::GetSessionIndex () const
{
	return m_fliSessionIndex;
} // FCTimeLabelRec::GetSessionIndex.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCTimeLabelRec::GetTimeLabelId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOjOiKnEiDiJiDhIiDiLjFjEjFgJiCmM_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOjOiKnEiDiJiDhIiDiLjFjEjFgJiCmM_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCTimeLabelRec::GetTimeLabelId () const
{
	return m_lTimeLabelId;
} // FCTimeLabelRec::GetTimeLabelId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCTimeLabelRec::GetUserId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOjOiKnEiDiJiDhIiDiLiNoMjAkMiOnCiCmMiDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOjOiKnEiDiJiDhIiDiLiNoMjAkMiOnCiCmMiDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
GUID FCTimeLabelRec::GetUserId () const
{
	return m_guidUserId;
} // FCTimeLabelRec::GetUserId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCTimeLabelRec::GetCreateTime
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCmMiNoMjAkMiOjOiKnEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCmMiNoMjAkMiOjOiKnEiBgJjCfAiImKiBeGjFgCiBgK_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FDSECTIME FCTimeLabelRec::GetCreateTime () const
{
	return m_fdstCreateTime;
} // FCTimeLabelRec::GetCreateTime.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCTimeLabelRec::GetContentsText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDgFiDjDiDgDjFlGiOjKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDgFiDjDiDgDjFlGiOjKjHpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FCTimeLabelRec::GetContentsText () const
{
	return m_wstrContents;
} // FCTimeLabelRec::GetContentsText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCTimeLabelRec::GetHintText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhMiDgCiDhGiDhBiDjDiDgHiCmJjFfMiOkGiClHiCoJiCmMiCmJjDeLjDjGiCmIiDiBiDgCiDfKiBfLiDfHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FCTimeLabelRec::GetHintText (const FCHTreeManager* pHtreeManager) const
{
	COleDateTime otmDateCreate = FdsecToFiletime(m_fdstCreateTime);
	// _xZkqqHx_jHoBiBeG_xHqqkZx_2004_xZkqqHx_jEeO_xHqqkZx_8_xZkqqHx_iMiO_xHqqkZx_19_xZkqqHx_jDpK_xHqqkZx_ 0_xZkqqHx_iOjO_xHqqkZx_15_xZkqqHx_jFkK_xHqqkZx_
	// IDS_FORM_DATE_TIME_LONG = "%#Y_xZkqqHx_jEeO_xHqqkZx_%#m_xZkqqHx_iMiO_xHqqkZx_%#d %#H:%#M"
	WString wstrDateCreate = TStrToWStr(otmDateCreate.Format(FFLoadString(IDS_FORM_DATE_TIME_LONG)));

	// IDS_FORM_HTREE_PROPERTY_G =
	//		_xZkqqHx_iOoNjFmK_xHqqkZx_:_xZkqqHx_iOjOiKnEiDiJiDhIiDiL_xHqqkZx_\r\n
	//		_xZkqqHx_jDoAjHgF_xHqqkZx_:%s\r\n
	//		_xZkqqHx_iNoMjAkMjDpKiOjO_xHqqkZx_:%s\r\n
	//		_xZkqqHx_iNoMjAkMiOnC_xHqqkZx_:%s\r\n
	//		_xZkqqHx_iImKjChF_xHqqkZx_:%I64d_xZkqqHx_iDfKiDgCiDfGiDiHiDjD_xHqqkZx_
	return FormatResString(	IDS_FORM_HTREE_PROPERTY_G,
							GetContentsText().c_str(),							// _xZkqqHx_iDfCiDjDiDgFiDjDiDgDiBeC_xHqqkZx_
							wstrDateCreate.c_str(),								// _xZkqqHx_iNoMjAkMjDpKiOjOiBeC_xHqqkZx_
							pHtreeManager->UserIdToUserName(m_guidUserId).c_str(),	// _xZkqqHx_iNoMjAkMiOnCiBeC_xHqqkZx_
							m_fliSessionIndex);									// _xZkqqHx_iImKjChFiBeC_xHqqkZx_
} // FCTimeLabelRec::GetHintText.
//----- 05.09.14 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

/////////////////////////////////////////////////////////////////////////////

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::Create
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	FCHTreeRec_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jHjKjHpAiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAjDmHiCnNiNjOiCnNiBeB_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiDeJiDhFiDfHiDeGiDeOiDgHiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pHTreeMng	:TreeManager_xZkqqHx_iCpAiOhHjCoIiBeCjFlGiOjKjHpBiKmHjHjNjDjJiCpAiNhDiCkEiBeC_xHqqkZx_
 *			lDocId		:_xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	FCHTreeRec_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAjFnEiClHiBeCiDhEiDeAiDeDiDiLiDiNiDgCiDeOiCmJiOlIjEhDiClFiClNiPoKiNiHiBeB_xHqqkZx_
			_xZkqqHx_iDhEiDeAiDeDiDiLjEgKjBlJiOjOjDjJiCmNiDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAjFfMiOkGiClFiClNiMoDiBeB_xHqqkZx_NULL _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static _xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.03.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCHTreeRec* FCHTreeRec::Create (FCHTreeManager* pHTreeMng,
								long lDocId)
{
	FCHTreeRec* pRec = new FCHTreeRec();
	// FCHTreeManager_xZkqqHx_iCmGiDhEiDeAiDeDiDiLjGlMiCpAjAnNjCoIiBeC_xHqqkZx_
	pRec->m_pHTreeMng = pHTreeMng;
	pRec->m_lDocId = lDocId;
//----- 06.01.30 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	pRec->m_autoLockSummaryRead.SetTable(HString(pHTreeMng->GetProjectPath()), lDocId, FDHI_SUMMARY_TABLE_ID);
//	pRec->m_autoLockTerminateRead.SetTable(HString(pHTreeMng->GetProjectPath()), lDocId, FDHI_TERMINATE_TABLE_ID);
//	pRec->m_autoLockForkRead.SetTable(HString(pHTreeMng->GetProjectPath()), lDocId, FDHI_FORK_TABLE_ID);
//----- 06.01.30 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	return pRec;
} // FCHTreeRec::Create.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::~FCHTreeRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCHTreeRec::~FCHTreeRec ()
{
	m_vHiLabelRecAuto.clear();
//----- 04.11.06 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	if (m_mmapSessionToNode != NULL)
	//----- _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiImKjChF_xHqqkZx_->_xZkqqHx_iDiJiDhIiDiLiBeFjHjKjHpAiNkMiNnNiDgOiDgCiDfGiDiFiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiImKjChF_xHqqkZx_->_xZkqqHx_iDiJiDhIiDiLiBeFjHjKjHpAiNkMiNnNiDgOiDgCiDfGiDiFiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
		delete m_mmapSessionToNode;
		m_mmapSessionToNode = NULL;
	}
//----- 04.11.06 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
} // FCHTreeRec::~FCHTreeRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::SetRootPoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjGnIiNfMjBkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCmJiCkIiCkPiCoJiDhLiDgCiDeOiDfIiCmMjAnKjBlBiImKjChFiNmAjFfHiCpA_xHqqkZx_
 *			_xZkqqHx_jAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pt	:_xZkqqHx_iImKjChFiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.01.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHTreeRec::SetRootPoint (const CPoint& pt)
{
	m_ptRoot = pt;
} // FCHTreeRec::SetRootPoint.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::GetRootPoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjGnIiNfMjBkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCmJiCkIiCkPiCoJiDhLiDgCiDeOiDfIiCmMjAnKjBlBiImKjChFiNmAjFfHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iImKjChFiNmAjFfHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	m_ptRoot _xZkqqHx_iCmNiBeBiImIiJlKiBeC_xHqqkZx_
 *
 *    m_ptRoot
 *     _xZkqqHx_iEkA_xHqqkZx_
 *     _xZkqqHx_iBkL_xHqqkZx_
 *      _xZkqqHx_iEkKiEkKiEkKiEkKiEkKiEkKiEkN_xHqqkZx_
 *                  _xZkqqHx_iEkL_xHqqkZx_
 *                  _xZkqqHx_iEkL_xHqqkZx_
 *                  _xZkqqHx_iEkL_xHqqkZx_
 *          _xZkqqHx_iEkMiEkKiEkKiEkKiElDiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkN_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_                      _xZkqqHx_iEkL_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_                      _xZkqqHx_iEkL_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_                      _xZkqqHx_iEkL_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_                      _xZkqqHx_iEkL_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_                      _xZkqqHx_iEkL_xHqqkZx_
 *          _xZkqqHx_iEkPiEkKiEkKiEkN_xHqqkZx_  _xZkqqHx_iEkMiEkKiEkKiEkKiEkKiEkKiEkKiEkO_xHqqkZx_
 *                _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_
 *                _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_
 *                _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_
 *                _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_
 *              _xZkqqHx_iEkMiEkO_xHqqkZx_  _xZkqqHx_iEkPiEkN_xHqqkZx_
 *               _xZkqqHx_iBfP_xHqqkZx_    _xZkqqHx_iBfO_xHqqkZx_
 *                 _xZkqqHx_iBfPiBfO_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.01.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const CPoint& FCHTreeRec::GetRootPoint () const
{
	return m_ptRoot;
} // FCHTreeRec::GetRootPoint.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::GetZoomLimitTree
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jGnIiDiMiDeDiDeBiDeFiDgHiOjOiCmMiDfJiBfLiDiAiCmMiNmFjBoFjCgMiBeBiNmFiPkMjCgMiCpAiMhGiOfKiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dZoomMin	:_xZkqqHx_iDfJiBfLiDiAiNmFiPkMjCgMiCpAjFnEiClHiBeC_xHqqkZx_
 *			dZoomMax	:_xZkqqHx_iDfJiBfLiDiAiNmFjBoFjCgMiCpAjFnEiClHiBeC_xHqqkZx_
 *			dZoomFit	:_xZkqqHx_jDeLjDjGiCmIiDfJiBfLiDiAjCgMiCpAjFnEiClHiBeC_xHqqkZx_
 *			lClientHeight	:_xZkqqHx_iDeOiDiJiDeDiDeBiDjDiDgHjHmMiIoGiCmMiNiCiClDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lLevel		:_xZkqqHx_iClBiCmMjHjKjHpAiOhNiCmMiDiMiDhIiDiLiCpAiOhHjCoIiBeCiNmFiPiJiCmMjHjKjHpAiOhNiCmMiDiMiDhIiDiLiCmN_xHqqkZx_0_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iClBiCmMiOhNiCkJiCoHiJlKiCmJiMhBiCkKiCoJiOhNiCmMiDfJiBfLiDiAiNmEiLeBjDeJiCmJiMhGiOfKiClFiBeBiClLiCmMiNmFjBoFjCgMiCmG_xHqqkZx_
 *			_xZkqqHx_iNmFiPkMjCgMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.06.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHTreeRec::GetZoomLimitTree (	double& dZoomMin,
									double& dZoomMax,
									double& dZoomFit,
									long lClientHeight,
									long lLevel)
{
	// _xZkqqHx_jHjKjHpAjApMiCkKiPmBjEoPiClHiCoJiNiCiClDiCmMiDiNiDfIjFkKiCpAiMhGiOfKiBeC_xHqqkZx_
	// _xZkqqHx_jHjKjHpAiCmMiDiMiDhIiDiLiCkKiCfAiPoDiCkKiCoJiClCiCmGiCmJiBeBiBgJjDlBjDpMjApMiCmMiNiCiClDiBhLjHjKjHpAjFfMiOkGiDhLiDgCiDeOiDfIiCmMiNiCiClDiBgK_xHqqkZx_
	// _xZkqqHx_iCkKiPmBjEoPiClDiCoKiCoJiBeCiCnMiClNiBeBjGoOiIpDiCmMiNiCiClDiBeBiPoDiJlKiCmMjHjKjHpAiDhCiDiFiBfLiCmMiOpMiImNiCmMiDeNiDiDiDgCiDhG_xHqqkZx_ _xZkqqHx_iCoA_xHqqkZx_
	// _xZkqqHx_iPmBjEoPiClDiCoKiCoJiBeC_xHqqkZx_
	long lLossHeight = (lLevel + 1) * (GetHTreeManager()->GetHtBoxIntroY() + m_pHTreeMng->GetHistBoxSize().cy) + GetHTreeManager()->GetHtArwHeight() + (2 * FD_HTREE_VIEW_GAP);

	// FD_MIN_TREE_LEN _xZkqqHx_iCmFiDfKiDgCiDfGiDiHiDjDjClHiCmMiMhGiOfKiCpAjAkHiMmAiBeC_xHqqkZx_
	// _xZkqqHx_jAkHiMmAiClFiCmIiCkCiCmGiBeB_xHqqkZx_dZoomMin=200_xZkqqHx_iCmGjBoFiCkLiCkNiCmIiCmBiCmEiClFiCnMiCkCiBeB_xHqqkZx_
	// _xZkqqHx_iDfJiBfLiDiAjCgMiCmMiNmFiPkMjCgMiCkK_xHqqkZx_20000%_xZkqqHx_iCmJiCmIiCmBiCmEiClFiCnMiCkEiBeC_xHqqkZx_
	if (GetEndSessionIndex() < FD_MIN_TREE_LEN)
	//----- _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiPeJjCfLiCkKiPkMiClDiCkCiPoKiNiH_xHqqkZx_ -----
	{
		dZoomMin = double(FD_MIN_TREE_LEN) / FD_MIN_TREE_LEN;
		dZoomMax = double(FD_MAX_TREE_LEN) / FD_MIN_TREE_LEN;
	} else
	//----- _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiPeJjCfLiCkKiPfMjFkKjBoFiCkLiCkCiPoKiNiH_xHqqkZx_ -----
	{
		dZoomMin = double(FD_MIN_TREE_LEN) / GetEndSessionIndex();
		dZoomMax = double(FD_MAX_TREE_LEN) / GetEndSessionIndex();
	}
	if (GetEndSessionIndex() == 0)
		dZoomFit = FD_MAX_FIT_ZOOM;
	else
		dZoomFit = double(lClientHeight - lLossHeight) / GetEndSessionIndex();

	longVector::const_iterator iR;
	for (iR = GetSubTreeDocIdVector().begin(); iR != GetSubTreeDocIdVector().end(); iR++)
	{
		FCHTreeRec* pRec = GetHTreeManager()->DocumentIdToHTreeRec(*iR);
		if (pRec == NULL) continue;
		double dMin, dMax, dFit;
		pRec->GetZoomLimitTree(dMin, dMax, dFit, lClientHeight, lLevel + 1);
		if (dMin < dZoomMin) dZoomMin = dMin;
		if (dMax < dZoomMax) dZoomMax = dMax;
		if (dFit < dZoomFit) dZoomFit = dFit;
	}
	if (dZoomFit < dZoomMin) dZoomFit = dZoomMin;
	if (dZoomMax < dZoomFit) dZoomFit = dZoomMax;
	// _xZkqqHx_jBoFiCkLiCkNiCmIiCoIiJnPiCkMiCmIiCkCiCoGiCkEiCmJiClHiCoJjAkHiMmAjCgMiBeC_xHqqkZx_
	if (FD_MAX_FIT_ZOOM < dZoomFit) dZoomFit = FD_MAX_FIT_ZOOM;
} // FCHTreeRec::GetZoomLimitTree.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::GetZoomLimitBranch
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhNiDiMiDeDiDeBiDeFiDgHiOjOiCmMiDfJiBfLiDiAiCmMiNmFjBoFjCgMiBeBiNmFiPkMjCgMiCpAiMhGiOfKiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dZoomMin	:_xZkqqHx_iDfJiBfLiDiAiNmFiPkMjCgMiCpAjFnEiClHiBeC_xHqqkZx_
 *			dZoomMax	:_xZkqqHx_iDfJiBfLiDiAiNmFjBoFjCgMiCpAjFnEiClHiBeC_xHqqkZx_
 *			dZoomFit	:_xZkqqHx_jDeLjDjGiCmIiDfJiBfLiDiAjCgMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.06.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHTreeRec::GetZoomLimitBranch (double& dZoomMin,
									 double& dZoomMax,
									 double& dZoomFit,
									 const CSize& szClient)
{
	// FD_MIN_TREE_LEN _xZkqqHx_iCmFiDfKiDgCiDfGiDiHiDjDjClHiCmMiMhGiOfKiCpAjAkHiMmAiBeC_xHqqkZx_
	// _xZkqqHx_jAkHiMmAiClFiCmIiCkCiCmGiBeB_xHqqkZx_dZoomMin=200_xZkqqHx_iCmGjBoFiCkLiCkNiCmIiCmBiCmEiClFiCnMiCkCiBeB_xHqqkZx_
	// _xZkqqHx_iDfJiBfLiDiAjCgMiCmMiNmFiPkMjCgMiCkK_xHqqkZx_20000%_xZkqqHx_iCmJiCmIiCmBiCmEiClFiCnMiCkEiBeC_xHqqkZx_
	if (GetSessionIndexLength() < FD_MIN_TREE_LEN)
	//----- _xZkqqHx_iDfKiDgCiDfGiDiHiDjDjClHiCkKiPkMiClDiCkCiPoKiNiH_xHqqkZx_ -----
	{
		dZoomMin = double(FD_MIN_TREE_LEN) / FD_MIN_TREE_LEN;
		dZoomMax = double(FD_MAX_TREE_LEN) / FD_MIN_TREE_LEN;
//----- 04.10.08 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//		dZoomMin = 1.0;
//		dZoomMax = 1.0;
//----- 04.10.08 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	} else
	//----- _xZkqqHx_iDfKiDgCiDfGiDiHiDjDjClHiCkKiPfMjFkKjBoFiCkLiCkCiPoKiNiH_xHqqkZx_ -----
	{
		dZoomMin = double(FD_MIN_TREE_LEN) / double(GetSessionIndexLength());
		dZoomMax = double(FD_MAX_TREE_LEN) / double(GetSessionIndexLength());
	}
	if (GetSessionIndexLength() == 0)
		dZoomFit = FD_MAX_FIT_ZOOM;
	else
		dZoomFit = double(szClient.cy - (2 * FD_HTREE_VIEW_GAP) - m_pHTreeMng->GetHistBoxSize().cy - GetHTreeManager()->GetHtArwHeight()) / double(GetSessionIndexLength());

	// _xZkqqHx_jBoFiCkLiCkNiCmIiCoIiJnPiCkMiCmIiCkCiCoGiCkEiCmJiClHiCoJjAkHiMmAjCgMiBeC_xHqqkZx_
	if (FD_MAX_FIT_ZOOM < dZoomFit) dZoomFit = FD_MAX_FIT_ZOOM;
} // FCHTreeRec::GetZoomLimitBranch.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::CalcLayoutTree
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDeJiDhFiDfHiDeGiDeOiDgHiImIiJlKiCmMjHjKjHpAjGnIiCmMiDiMiDeDiDeBiDeFiDgHiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dZoom		:_xZkqqHx_iDfJiBfLiDiAiCmMjCgMiBeC_xHqqkZx_dZoom = 1.0_xZkqqHx_iCmMiOjOiBeB_xHqqkZx_100%_xZkqqHx_iBeC_xHqqkZx_
 *			rtvOccupied	:_xZkqqHx_jAoIjHeMiClDiCoKiCmEiCkCiCoJiLoJiMgAjHmMiIoGiBeCiDiMiDeDiDeBiDeFiDgHiMhGiOfKiCmFiOgHjHhAiBeC_xHqqkZx_
 *						 _xZkqqHx_iImIiJlKiCmMiLoJiMgAiCkKjDgPjIfOiClDiCoKiCoJiBeC_xHqqkZx_
 *						 _xZkqqHx_iBeFjFfMiOkGiDhLiDgCiDeOiDfIiCmMjHmMiIoGiBeC_xHqqkZx_
 *						 _xZkqqHx_iBeFjGoOiIpDjAoGjDkKjFjEjFkKiCmMiLoJiMgAiBeC_xHqqkZx_
 *						 _xZkqqHx_iBeFjFkKiKpCjDfPiCmMiOpMiImNiCmMiLoJiMgAiBeC_xHqqkZx_
 *			slvOccupied	:_xZkqqHx_jAoIjHeMiClDiCoKiCmEiCkCiCoJjApMjFkKiBeCiDiMiDeDiDeBiDeFiDgHiMhGiOfKiCmFiOgHjHhAiBeC_xHqqkZx_
 *						 _xZkqqHx_iImIiJlKiCmMjApMjFkKiCkKjDgPjIfOiClDiCoKiCoJiBeC_xHqqkZx_
 *						 _xZkqqHx_iBeFjHjKjHpAjApMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iClBiCmMiOhNiImIiJlKiCmMiOhNjBfDiCmEiCmJiKePjAnKiClHiCoJiLoJiMgAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iClBiCmMjHjKjHpAiCmGiBeBiClLiCoKiCmJiMhBiCkKiCoJiJlKiCmMjHjKjHpAjGnIjBfDiCmEiCmMiDiMiDeDiDeBiDeFiDgHiCpA_xHqqkZx_
 *			_xZkqqHx_iNmEiLeBjDeJiCmJiMhGiOfKiClHiCoJiBeC_xHqqkZx_HTreeRec.doc_xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *			_xZkqqHx_iImIiJlKiCmMiCoGiCkEiCmIjAhNiCmMiDiMiDeDiDeBiDeFiDgHiCpAiMhGiOfKiBeC_xHqqkZx_
 *
 *
 *            m_ptRoot
 *             _xZkqqHx_iEkA_xHqqkZx_
 *             _xZkqqHx_iBkL_xHqqkZx_
 *              _xZkqqHx_iEkKiEkKiEkKiEkKiEkKiEkKiEkN_xHqqkZx_
 *                          _xZkqqHx_iEkL_xHqqkZx_
 *       GetHTreeManager()->GetHtBoxWidthL()  _xZkqqHx_iEkL_xHqqkZx_
 *                _xZkqqHx_iBkIiEkJiEjPiEjPiEjPiElHiBkJ_xHqqkZx_
 *                  _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkL_xHqqkZx_
 *                  _xZkqqHx_iEkMiEkKiEkKiEkKiElDiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkN_xHqqkZx_
 *                  _xZkqqHx_iEkL_xHqqkZx_      _xZkqqHx_iBkK_xHqqkZx_              _xZkqqHx_iEkL_xHqqkZx_
 *                  _xZkqqHx_iEkL_xHqqkZx_     m_ptBox          _xZkqqHx_iEkL_xHqqkZx_
 *                  _xZkqqHx_iEkL_xHqqkZx_                      _xZkqqHx_iEkL_xHqqkZx_
 *                  _xZkqqHx_iEkL_xHqqkZx_                      _xZkqqHx_iEkL_xHqqkZx_
 *                  _xZkqqHx_iEkL_xHqqkZx_                      _xZkqqHx_iEkL_xHqqkZx_
 *                  _xZkqqHx_iEkPiEkKiEkKiEkN_xHqqkZx_  _xZkqqHx_iEkMiEkKiEkKiEkKiEkKiEkKiEkKiEkO_xHqqkZx_
 *                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_
 *                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_
 *                        _xZkqqHx_iEkLiEkAiEkL_xHqqkZx_ GetHTreeManager()->GetHtInterLineX()
 *                        _xZkqqHx_iEkLiEkFiBkJiEjPiEjPiEjPiEjPiEjPiBkIiEkH_xHqqkZx_
 *                        _xZkqqHx_iEkLiEkAiEkL_xHqqkZx_            _xZkqqHx_iEkA_xHqqkZx_
 *                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iElAiEkKiEkKiEkKiEkKiEkKiEkKiEkNiEjPiEkG_xHqqkZx_
 *                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iBkK_xHqqkZx_
 *                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_GetHTreeManager()->GetHtBoxIntroY()
 *                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iBkL_xHqqkZx_
 *                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkMiEkKiEkKiEkKiElDiEkKiElIiEkKiEkKiEkKiEkKiEkKiEkNiEjPiEkG_xHqqkZx_
 *                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_                      _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iBkK_xHqqkZx_
 *                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_                      _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_                      _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_m_pHTreeMng->GetHistBoxSize().cy
 *                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_                      _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_                      _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iBkL_xHqqkZx_
 *                      _xZkqqHx_iEkMiEkO_xHqqkZx_  _xZkqqHx_iEkPiEkN_xHqqkZx_  _xZkqqHx_iEkPiEkKiEkKiEkN_xHqqkZx_  _xZkqqHx_iEkMiEkKiEkKiEkKiEkKiEkKiEkKiEkOiEjPiEkI_xHqqkZx_
 *                       _xZkqqHx_iBfP_xHqqkZx_    _xZkqqHx_iBfO_xHqqkZx_   _xZkqqHx_iEkA_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_            _xZkqqHx_iEkA_xHqqkZx_
 *                         _xZkqqHx_iBfPiBfO_xHqqkZx_     _xZkqqHx_iEkFiBkJiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiBkIiEkH_xHqqkZx_
 *                                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_ m_pHTreeMng->GetHistBoxSize().cx
 *                                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_
 *                                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_
 *                                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_
 *                                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_GetHTreeManager()->GetHtIntroGapY()
 *                                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iBkL_xHqqkZx_
 *                                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iElAiEkKiEkKiElJiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkK_xHqqkZx_
 *                                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
 *                                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkA_xHqqkZx_
 *                                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iElAiEkKiEkKiElJiEkKiEkKiEkKiEkN_xHqqkZx_
 *                                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iBkK_xHqqkZx_
 *                                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_
 *                                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_
 *                                        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_
 *                                      _xZkqqHx_iEkMiEkO_xHqqkZx_  _xZkqqHx_iEkPiEkN_xHqqkZx_
 *                                       _xZkqqHx_iBfP_xHqqkZx_    _xZkqqHx_iBfO_xHqqkZx_
 *                                         _xZkqqHx_iBfPiBfO_xHqqkZx_
 *
 *
 *              _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_
 *              _xZkqqHx_iEkL_xHqqkZx_        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_
 *              _xZkqqHx_iEkL_xHqqkZx_        _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iBkL_xHqqkZx_GetHTreeManager()->GetHtBoxGapY()
 *              _xZkqqHx_iEkL_xHqqkZx_        _xZkqqHx_iEkPiEkKiEkOiEjPiEjPiEkJ_xHqqkZx_
 *              _xZkqqHx_iEkL_xHqqkZx_                  _xZkqqHx_iEkA_xHqqkZx_
 *      _xZkqqHx_iEkMiEkKiEkKiEkKiElDiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkNiEjPiEkI_xHqqkZx_
 *      _xZkqqHx_iEkL_xHqqkZx_                      _xZkqqHx_iEkL_xHqqkZx_
 *      _xZkqqHx_iEkL_xHqqkZx_                      _xZkqqHx_iEkL_xHqqkZx_
 *      _xZkqqHx_iEkL_xHqqkZx_                      _xZkqqHx_iEkL_xHqqkZx_
 *      _xZkqqHx_iEkL_xHqqkZx_                      _xZkqqHx_iEkL_xHqqkZx_
 *      _xZkqqHx_iEkL_xHqqkZx_                      _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iBkL_xHqqkZx_GetHTreeManager()->GetHtBoxGapY()
 *      _xZkqqHx_iEkPiEkKiEkKiEkN_xHqqkZx_  _xZkqqHx_iEkMiEkKiEkKiEkKiEkKiEkKiEkKiEkOiEjPiEkJ_xHqqkZx_
 *            _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_                _xZkqqHx_iEkA_xHqqkZx_
 *            _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_      _xZkqqHx_iEkMiEkKiEkNiEjPiEjPiEkI_xHqqkZx_
 *            _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_      _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_  
 *            _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkMiEkO_xHqqkZx_  _xZkqqHx_iEkPiEkN_xHqqkZx_
 *            _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_     _xZkqqHx_iBfP_xHqqkZx_    _xZkqqHx_iBfO_xHqqkZx_ 
 *            _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_       _xZkqqHx_iBfPiBfO_xHqqkZx_   
 *            _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_
 *            _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_
 *
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iClBiCmMiKnGjAjEiCpAiOmAiNhDiClHiCoJjBePiCmJiBeB_xHqqkZx_SetRootPoint_xZkqqHx_iKnGjAjEiCmFiDiLiBfLiDgHiNmAjFfHiCpAjAnNjCoIiClFiCmE_xHqqkZx_
 *			_xZkqqHx_iCkIiCkNjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.02.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			03.03.27 Fukushiro M. _xZkqqHx_jFmPiNfI_xHqqkZx_
 *************************************************************************/
CRect FCHTreeRec::CalcLayoutTree (	double dZoom,
									CRectVector& rtvOccupied,
									VSLineVector& slvOccupied)
{
	// _xZkqqHx_jFfMiOkGiDhLiDgCiDeOiDfIiCmMjHjKjHpAjApMiCkJiCoHiJeFiCmGiBeBiNiCiClDiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
	const CSize szHistBox = m_pHTreeMng->GetHistBoxSize();
	// _xZkqqHx_jFfMiOkGiDhLiDgCiDeOiDfIiCmMiKoOiPiAjDfPiBeC_xHqqkZx_
	CPoint ptBox(GetRootPoint().x, GetRootPoint().y + GetHTreeManager()->GetHtBoxIntroY());
	// _xZkqqHx_jHjKjHpAjApMiCmMjClHiClDiBeC_xHqqkZx_
	long lLife;
	// _xZkqqHx_jFfMiOkGiDhLiDgCiDeOiDfIjHmMiIoGiBeC_xHqqkZx_
	CRect rtVBox;
	// _xZkqqHx_jGoOiIpDiCmJiKePjAnKiClHiCoJiLoJiMgAiBeC_xHqqkZx_
	CRect rtArw;
	for (;;)
	{
		// _xZkqqHx_jHjKjHpAjApMiCpAiJeFiCnGiInKjDkOiBeC_xHqqkZx_ptBox_xZkqqHx_iNmAjFfHiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
		ptBox.x += GetHTreeManager()->GetHtInterLineX();
		// _xZkqqHx_jHjKjHpAjApMiCmMiPiJiKpKiImKjChFiCpAjAnNjCoIiBeC_xHqqkZx_
		ptBox.y = GetRootPoint().y + GetHTreeManager()->GetHtBoxIntroY();

		//----- lLife_xZkqqHx_iCpAiOfKiPgPiBeCjClHiClHiCkMiCoJ_xHqqkZx_/_xZkqqHx_jCfKiClHiCkMiCoJiPoKiNiHiCpAjClCjAkO_xHqqkZx_ -----
		lLife = D2L(GetSessionIndexLength() * dZoom);
		if (lLife < FD_MIN_TREE_LIFE_LEN)
			lLife = FD_MIN_TREE_LIFE_LEN;
		else if (FD_MAX_TREE_LIFE_LEN < lLife)
			lLife = FD_MAX_TREE_LIFE_LEN;

		// _xZkqqHx_jHjKjHpAjApMiCkKjBlMiCmMjApMiCmGiPgEiCmIiCmBiCmEiCkCiCoKiCmOiBeBjHjKjHpAjApMiCpAiJeFiCnGiInKjDkOiBeC_xHqqkZx_
		// _xZkqqHx_jHjKjHpAjApMiCmNiImIiNhOiCmMiMhGiOfKiCmFjAeMiCnBiCoJiCmMiCmFiBeBiMhGiOfKiCmMiMoDiBeBiCoAiCkEiIoKjDhIiPgEiCmIiCoIiCpAjClCiCnHiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
		if (IsOverLine(	ptBox.x, GetRootPoint().y,
						ptBox.y + szHistBox.cy + lLife + GetHTreeManager()->GetHtArwHeight(),
						slvOccupied.begin(), slvOccupied.size())) continue;

		//----- _xZkqqHx_jFfMiOkGiDhLiDgCiDeOiDfIjHmMiIoGiCpAiBeBjBlMiCmMiDhLiDgCiDeOiDfIiCmGiPgEiCmIiCoHiCmIiCkCjHgMiCmJjAnNjCoI_xHqqkZx_ -----
		for (;;)
		{
			rtVBox.SetRect(	ptBox.x - GetHTreeManager()->GetHtBoxWidthL(),
							ptBox.y,
							ptBox.x  - GetHTreeManager()->GetHtBoxWidthL() + szHistBox.cx,
							ptBox.y + szHistBox.cy);
			// _xZkqqHx_iDhLiDgCiDeOiDfIiCmMiPgEiCmIiCoIjHmMiIoGiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
			const long lCross = GetCrossBox(rtVBox,
											rtvOccupied.begin(), rtvOccupied.size());
			if (lCross == 0) break;
			ptBox.y += lCross;
		}
		// ptFrom_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
		CPoint ptFrom(ptBox.x, ptBox.y + szHistBox.cy);
		//----- _xZkqqHx_iPeJjCfLjGoOiIpDiCkKjFfMiOkGiDhLiDgCiDeOiDfIiCmJiPgEiCmIiCoHiCmIiCkCjHgMiCmJ_xHqqkZx_lLife_xZkqqHx_iCpAjClCjAkO_xHqqkZx_ -----
		for (;;)
		{
			rtArw.SetRect(	ptFrom.x - GetHTreeManager()->GetHtArwWidthH(),
							ptFrom.y + lLife,
							ptFrom.x + GetHTreeManager()->GetHtArwWidthH(),
							ptFrom.y + lLife + GetHTreeManager()->GetHtArwHeight());
			// _xZkqqHx_iDhLiDgCiDeOiDfIiCmMiPgEiCmIiCoIjHmMiIoGiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
			const long lCross = GetCrossBox(rtArw,
										rtvOccupied.begin(), rtvOccupied.size());
			if (lCross == 0) break;
			lLife += lCross;
		}
		// _xZkqqHx_jHjKjHpAjApMiCkKjBlMiCmMjApMiCmGiPgEiCmIiCmBiCmEiCkCiCoKiCmOiBeBjHjKjHpAjApMiCpAiJeFiCnGiInKjDkOiBeC_xHqqkZx_
		if (IsOverLine(ptBox.x, GetRootPoint().y, rtArw.bottom,
						slvOccupied.begin(), slvOccupied.size())) continue;

		// m_fliEndSessionIndex_xZkqqHx_iCmG_xHqqkZx_lLife_xZkqqHx_iCmMjEoEjHkG_xHqqkZx_ df _xZkqqHx_iCpAiOfKiPgPiBeC_xHqqkZx_
		double dRatio = 0.0;
		if (GetSessionIndexLength() != 0)
			dRatio = double(lLife) / double(GetSessionIndexLength());

		//----- _xZkqqHx_jFkKiKpCjDfPiCmMiNmAjFfHiCpAiMhGiOfK_xHqqkZx_ -----
		long  lPrevRootY = 0;				// _xZkqqHx_jBePiJpBiCmMjFkKiKpCiNmAjFfH_xHqqkZx_(Y_xZkqqHx_iNmAjFfH_xHqqkZx_)_xZkqqHx_iBeC_xHqqkZx_
		flint fliPrevRootIdx = flint(-1);	// _xZkqqHx_jBePiJpBiCmMjFkKiKpCiImKjChF_xHqqkZx_(_xZkqqHx_iDfKiDgCiDfGiDiHiDjD_xHqqkZx_)_xZkqqHx_iBeC_xHqqkZx_
		longVector::const_iterator iR;
		for (iR = GetSubTreeDocIdVector().begin(); iR != GetSubTreeDocIdVector().end(); iR++)
		{
			FCHTreeRec* pRec = GetHTreeManager()->DocumentIdToHTreeRec(*iR);
			if (pRec == NULL) continue;
			if (pRec->GetFirstSessionIndex() != fliPrevRootIdx)
			//----- _xZkqqHx_jBePiJpBiCmMjFkKiKpCiImKjChFiCmGiBeBiNkBiJpBiCmMjFkKiKpCiImKjChFiCkKiInJiCmIiCoJiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_jAfGiClFiCkCjFkKiKpCiNmAjFfHiBeC_xHqqkZx_
				long lY = D2L(dRatio * (pRec->GetFirstSessionIndex() - GetFirstSessionIndex())) + ptFrom.y;
				// _xZkqqHx_jBePiJpBiCmMjFkKiKpCiNmAjFfHiCkJiCoHiPkNiCmIiCkNiCmGiCoA_xHqqkZx_ GetHTreeManager()->GetHtIntroGapY() _xZkqqHx_jCpGjHkDiClHiPiIjHjNiBeC_xHqqkZx_
				if (lY < lPrevRootY + GetHTreeManager()->GetHtIntroGapY())
					lY = lPrevRootY + GetHTreeManager()->GetHtIntroGapY();
				// _xZkqqHx_jFkKiKpCjFjEjFkKiCkKjBlMiCmMjFfMiOkGiDhLiDgCiDeOiDfIiCmMiJgFiCmJiJeCiCoKiCmIiCkCjHgMiCmJiInKjDkOiClHiCoJiPiIjHjNiBeC_xHqqkZx_
				for (;;)
				{
					// _xZkqqHx_jAoIjHeMiClDiCoKiCmEiCkCiCoJiLoJiMgAiCmJ_xHqqkZx_ _xZkqqHx_jDfP_xHqqkZx_(ptBox.x, lY)_xZkqqHx_iCkKjDpMiCmBiCmEiCkCiCmIiCkCiCkJiDgAiDeGiDgCiDeOiClHiCoJiBeC_xHqqkZx_
					const long lCross = GetCrossBox(CRect(ptBox.x, lY, ptBox.x + 1, lY + 1),
													rtvOccupied.begin(), rtvOccupied.size());
					if (lCross == 0) break;
					lY += lCross;
				}
				// _xZkqqHx_jFkKiKpCjGnIiCmMjFkKiKpCjDfPiNmAjFfHiBgJ_xHqqkZx_m_ptRoot_xZkqqHx_iBgKiCpAjAnNjCoIiBeC_xHqqkZx_
				pRec->SetRootPoint(CPoint(ptBox.x, lY));
				// _xZkqqHx_jBePiJpBiCmMjFmPjAjEjCgMiCpAiNfIjAfGiBeC_xHqqkZx_
				lPrevRootY = lY;
				fliPrevRootIdx = pRec->GetFirstSessionIndex();
			} else
			//----- _xZkqqHx_jBePiJpBiCmMjFkKiKpCiImKjChFiCmGiBeBiNkBiJpBiCmMjFkKiKpCiImKjChFiCkKjDkPiClGiBgJjBkGiClPiBeBjDkPiClGiImKjChFiCkJiCoHjFkKiKpCiClFiCmEiCkCiCoJiBgKiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_jBePiJpBiCmMjCgMiCpAiBeBjFkKiKpCjGnIiCmMjFkKiKpCjDfPiNmAjFfHiBgJ_xHqqkZx_m_ptRoot_xZkqqHx_iBgKiCmGiClFiCmEjAnNjCoIiBeC_xHqqkZx_
				pRec->SetRootPoint(CPoint(ptBox.x, lPrevRootY));
			}
		}
		long lLifeNew = -1;
		// _xZkqqHx_iNmFiMoDiCmMjFkKiKpCiCkKjHjKjHpAjGjGjCfL_xHqqkZx_ _xZkqqHx_iKiOiCmC_xHqqkZx_ _xZkqqHx_jFkKiKpCiNmAjFfHiCkKiPeJjDfPjGoOiIpDiCpAiJhKiCkGiClNiPoKiNiHiBeC_xHqqkZx_
		if (fliPrevRootIdx == GetEndSessionIndex() && rtArw.top < lPrevRootY)
			// _xZkqqHx_iPeJjDfPjGoOiIpDiCpAiNmFiMoDiCmMjFkKiKpCjDfPiCmJiInKjDkOiBeC_xHqqkZx_
			lLifeNew = lPrevRootY - ptFrom.y;
		// _xZkqqHx_iNmFiMoDiCmMjFkKiKpCiCkKjHjKjHpAjGjGjCfLiCoGiCoIiPkMiClDiCkN_xHqqkZx_ _xZkqqHx_iKiOiCmC_xHqqkZx_ _xZkqqHx_jFkKiKpCiNmAjFfHiBhL_xHqqkZx_LINE_GAP_xZkqqHx_iCkKiPeJjDfPjGoOiIpDiCpAiJhKiCkGiClNiPoKiNiHiBeC_xHqqkZx_
		else if (fliPrevRootIdx != GetEndSessionIndex() && rtArw.top < lPrevRootY + GetHTreeManager()->GetHtIntroGapY())
			// _xZkqqHx_iPeJjDfPjGoOiIpDiCpAiNmFiMoDiCmMjFkKiKpCjDfP_xHqqkZx_+LINE_GAP_xZkqqHx_iCmJiInKjDkOiBeC_xHqqkZx_
			lLifeNew = lPrevRootY + GetHTreeManager()->GetHtIntroGapY() - ptFrom.y;

		if (lLifeNew != -1)
		//----- _xZkqqHx_jHjKjHpAjApMiCkKiJiEjClHiClDiCoKiClNiPoKiNiH_xHqqkZx_ -----
		{
			lLife = lLifeNew;
			//----- _xZkqqHx_iPeJjCfLjGoOiIpDiCkKjFfMiOkGiDhLiDgCiDeOiDfIiCmJiPgEiCmIiCoHiCmIiCkCjHgMiCmJ_xHqqkZx_lLife_xZkqqHx_iCpAjClCjAkO_xHqqkZx_ -----
			for (;;)
			{
				rtArw.SetRect(	ptFrom.x - GetHTreeManager()->GetHtArwWidthH(),
								ptFrom.y + lLife,
								ptFrom.x + GetHTreeManager()->GetHtArwWidthH(),
								ptFrom.y + lLife + GetHTreeManager()->GetHtArwHeight());
				// _xZkqqHx_iDhLiDgCiDeOiDfIiCmMiPgEiCmIiCoIjHmMiIoGiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
				const long lCross = GetCrossBox(rtArw,
											rtvOccupied.begin(), rtvOccupied.size());
				if (lCross == 0) break;
				lLife += lCross;
			}
		}

		// _xZkqqHx_jHjKjHpAjFkKiKpCiCmMiCkEiClPiBeBjGjGjCfLiCmMiCoAiCmMiClOiCkPiCpAiPeJjCfLjGoOiIpDiCmJiNiHiCoNiClJiCoJiBeC_xHqqkZx_
		longVector::const_reverse_iterator ri;
		for (ri = GetSubTreeDocIdVector().rbegin(); ri != GetSubTreeDocIdVector().rend(); ri++)
		{
			FCHTreeRec* pRec = GetHTreeManager()->DocumentIdToHTreeRec(*ri);
			if (pRec == NULL) continue;
			// _xZkqqHx_jFkKiKpCiImKjChFiCkKjHjKjHpAjGjGjCfLiCmFiCmIiCkCiPoKiNiHiCmNiDiLiBfLiDhGiCpAjElCiCkPiCoJiBeC_xHqqkZx_
			if (pRec->GetFirstSessionIndex() != GetEndSessionIndex()) break;
			// _xZkqqHx_jFkKiKpCjAoGiCmMjHjKjHpAiDiMiDfCiBfLiDgIiCmJiPeJjDfPjGoOiIpDiImKjChFiCpA_xHqqkZx_m_ptRoot_xZkqqHx_iCmGiClFiCmEjAnNjCoIiBeC_xHqqkZx_
			pRec->SetRootPoint(CPoint(ptBox.x, rtArw.top));
		}

		// _xZkqqHx_jHjKjHpAjApMiCkKjBlMiCmMjApMiCmGiPgEiCmIiCmBiCmEiCkCiCoKiCmOiBeBjHjKjHpAjApMiCpAiJeFiCnGiInKjDkOiBeC_xHqqkZx_
		if (IsOverLine(ptBox.x, GetRootPoint().y, rtArw.bottom,
						slvOccupied.begin(), slvOccupied.size())) continue;
		break;
	}
	// m_ptBox _xZkqqHx_iCmMjAnNjCoIiBeC_xHqqkZx_
	m_ptBox = ptBox;
	// m_lLife _xZkqqHx_iCmMjAnNjCoIiBeC_xHqqkZx_
	m_lLife = lLife;

	// _xZkqqHx_jFfMiOkGiDhLiDgCiDeOiDfIiCmMjHmMiIoGiCpAjDgPjIfOiBeC_xHqqkZx_
	RegisterBox(rtvOccupied, rtVBox);
	// _xZkqqHx_jGoOiIpDjAoGjDkKjFjEjFkKiCpAjDgPjIfOiBeC_xHqqkZx_
	RegisterBox(rtvOccupied, rtArw);
	// _xZkqqHx_jHjKjHpAjApMiCpAjDgPjIfOiBeC_xHqqkZx_
	RegisterLine(slvOccupied, GetBoxPoint().x,
				GetRootPoint().y, rtArw.bottom);
	// _xZkqqHx_jFkKiKpCjDfPiCpAjDgPjIfOiBeC_xHqqkZx_
	longVector::const_reverse_iterator ri;
	for (ri = GetSubTreeDocIdVector().rbegin(); ri != GetSubTreeDocIdVector().rend(); ri++)
	{
		FCHTreeRec* pRec = GetHTreeManager()->DocumentIdToHTreeRec(*ri);
		if (pRec == NULL) continue;
		CPoint ptRootSub = pRec->GetRootPoint();
		RegisterBox(rtvOccupied,
					CRect(	ptRootSub.x,
							ptRootSub.y,
							ptRootSub.x + 1,
							ptRootSub.y + 1));
	}

	// _xZkqqHx_iClBiCmMiOhNiCoGiCoIiJlKiCpAiKnMiCnPiCmEiBeBiDgHiBfLiDfOiDiLiCmMiKePjAnKiLoJiMgAiBeC_xHqqkZx_
	CRect rtFrame(GetRootPoint().x, GetRootPoint().y, rtVBox.right, rtArw.bottom);
	// _xZkqqHx_jFkKiKpCjAoGjHjKjHpAiCmMjBoFiCkLiCkCjFpLiCkJiCoHiBeBiNmEiLeBjDeJiCmJiDiMiDeDiDeBiDeFiDgHiPiIjHjNiCpAiOmAiNhDiBeC_xHqqkZx_
	for (ri = GetSubTreeDocIdVector().rbegin(); ri != GetSubTreeDocIdVector().rend(); ri++)
	{
		FCHTreeRec* pRec = GetHTreeManager()->DocumentIdToHTreeRec(*ri);
		if (pRec == NULL) continue;
		rtFrame |= pRec->CalcLayoutTree(dZoom, rtvOccupied, slvOccupied);
	}
	// _xZkqqHx_iKePjAnKiLoJiMgAiCpAjFnEiClHiBeC_xHqqkZx_
	return rtFrame;
} // FCHTreeRec::CalcLayoutTree.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::CalcLayoutBranch
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDeJiDhFiDfHiDeGiDeOiDgHiCmMjHjKjHpAiCmMiDiMiDeDiDeBiDeFiDgHiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dZoom	:_xZkqqHx_iDfJiBfLiDiAiCmMjCgMiBeC_xHqqkZx_dZoom = 1.0_xZkqqHx_iCmMiOjOiBeB_xHqqkZx_100%_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iClBiCmMiOhNiCmJiKePjAnKiClHiCoJiLoJiMgAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iClBiCmMjHjKjHpAjGnIiCmMiDiMiDeDiDeBiDeFiDgHiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_HTreeRec.doc_xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *			_xZkqqHx_iImIiJlKiCmMiCoGiCkEiCmIjAhNiCmMiDiMiDeDiDeBiDeFiDgHiCpAiMhGiOfKiBeC_xHqqkZx_
 *			_xZkqqHx_iBkA_xHqqkZx_
 *			_xZkqqHx_iEkA_xHqqkZx_
 *			_xZkqqHx_iEkFiBkA_xHqqkZx_
 *			_xZkqqHx_iEkA_xHqqkZx_
 *			_xZkqqHx_iEkFiBkA_xHqqkZx_
 *			_xZkqqHx_iBkL_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iClBiCmMiKnGjAjEiCpAiOmAiNhDiClHiCoJjBePiCmJiBeB_xHqqkZx_SetRootPoint_xZkqqHx_iKnGjAjEiCmFiDiLiBfLiDgHiNmAjFfHiCpAjAnNjCoIiClFiCmE_xHqqkZx_
 *			_xZkqqHx_iCkIiCkNjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CRect FCHTreeRec::CalcLayoutBranch (double dZoom)
{
	// _xZkqqHx_jFfMiOkGiDhLiDgCiDeOiDfIiCmMjFjNiBeBiNiCiClDiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
	const CSize szHistBox = m_pHTreeMng->GetHistBoxSize();
	// _xZkqqHx_jFfMiOkGiDhLiDgCiDeOiDfIiCmMiKoOiPiAjDfPiBeC_xHqqkZx_
	CPoint ptBox;
	// _xZkqqHx_jHjKjHpAjApMiCmMjClHiClDiBeC_xHqqkZx_
	long lLife;
	// _xZkqqHx_iClBiCmMiOhNiCmMiKePjAnKiLoJiMgAiBeC_xHqqkZx_
	CRect rtFrame;
	// ptBox_xZkqqHx_iCmMiPiJiKpKiJlLiBeC_xHqqkZx_
	ptBox.x = GetRootPoint().x + GetHTreeManager()->GetHtBoxWidthL();
	ptBox.y = GetRootPoint().y - szHistBox.cy / 2;
	//----- lLife_xZkqqHx_iCpAiOfKiPgPiBeCjClHiClHiCkMiCoJ_xHqqkZx_/_xZkqqHx_jCfKiClHiCkMiCoJiPoKiNiHiCpAjClCjAkO_xHqqkZx_ -----
	lLife = static_cast<long>(GetSessionIndexLength() * dZoom);
	if (lLife < FD_MIN_BRANCH_LIFE_LEN)
		lLife = FD_MIN_BRANCH_LIFE_LEN;
	else if (FD_MAX_BRANCH_LIFE_LEN < lLife)
		lLife = FD_MAX_BRANCH_LIFE_LEN;
	// ptFrom_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
	CPoint ptFrom(ptBox.x, ptBox.y + szHistBox.cy);
	// m_fliEndSessionIndex_xZkqqHx_iCmG_xHqqkZx_lLife_xZkqqHx_iCmMjEoEjHkG_xHqqkZx_ df _xZkqqHx_iCpAiOfKiPgPiBeC_xHqqkZx_
	double dRatio = 0.0;
	if (GetSessionIndexLength() != 0)
		dRatio = double(lLife) / double(GetSessionIndexLength());
	// _xZkqqHx_iKePjAnKiDhEiDiMiBfLiDiAiCpAjAnNjCoIiBeC_xHqqkZx_
	rtFrame.SetRect(ptBox.x - GetHTreeManager()->GetHtBoxWidthL(),
					ptBox.y,
					ptBox.x - GetHTreeManager()->GetHtBoxWidthL() + szHistBox.cx,
					ptFrom.y + lLife + GetHTreeManager()->GetHtArwHeight());
	//----- _xZkqqHx_jFkKiKpCjDfPiCmMiNmAjFfHiCpAiMhGiOfK_xHqqkZx_ -----
	const int iHBY = szHistBox.cy / 4;
	CPoint ptPrev(0,0);
	long lPrevY = 0;

	FTSessionToNodeMmap::iterator iN;
	for (iN = GetSessionToNodeMmapW().begin();
		 iN != GetSessionToNodeMmapW().end(); iN++)
	{
		// _xZkqqHx_jAfGiClFiCkCjFkKiKpCiCmMiChIiNmAjFfHiCpAiMhGiOfKiBeC_xHqqkZx_
		long lY = D2L(dRatio * ((*iN).first - GetFirstSessionIndex())) + ptFrom.y;
		if (lY <= lPrevY + iHBY)
		//----- _xZkqqHx_jBePiJpBiCmMiChIiNmAjFfHiCmGjDjJiClFiCkCiPoKiNiHiBgJjFkKiKpCiCmMiLoJiMgAiCkKiIoKjChGiClHiCoJiPoKiNiHiBgK_xHqqkZx_-----
		{
			// _xZkqqHx_iJeFiJlKiCmJiClIiCoHiClHiBeC_xHqqkZx_
			ptPrev += CSize(16,16);
			(*iN).second.m_ptRoot = ptPrev;
		} else
		//----- _xZkqqHx_jBePiJpBiCmMiChIiNmAjFfHiCmGiInJiCmIiCoJiPoKiNiHiBgJjFkKiKpCiCmMiLoJiMgAiCkKiIoKjChGiClFiCmIiCkCiPoKiNiHiBgK_xHqqkZx_-----
		{
			lPrevY = lY;
			ptPrev = CPoint(ptBox.x + GetHTreeManager()->GetHtLineIntroX(), lY);
			(*iN).second.m_ptRoot = ptPrev;
		}
		// _xZkqqHx_iKePjAnKiDhEiDiMiBfLiDiAiCmMiJeFiJlKiCmMiNmAjFfHiCpAiNfIjAfGiBeC_xHqqkZx_
		if (rtFrame.right < ptPrev.x + szHistBox.cx)
			rtFrame.right = ptPrev.x + szHistBox.cx;
		if (rtFrame.bottom < ptPrev.y + szHistBox.cy / 2)
			rtFrame.bottom = ptPrev.y + szHistBox.cy / 2;
	}
	//----- _xZkqqHx_iOjOiKnEiDfGiDePiDgJiDiLiCmMiNmAjFfHiCpAiMhGiOfK_xHqqkZx_ -----
	HTRTimeRecVector::iterator iT;
	for (iT = GetTimeRecVectorW().begin(); iT != GetTimeRecVectorW().end(); iT++)
	{
		(*iT).m_y = D2L(dRatio * ((*iT).m_fliSessionIdx - GetFirstSessionIndex())) + ptFrom.y;
	}

	// m_ptBox _xZkqqHx_iCmMjAnNjCoIiBeC_xHqqkZx_
	m_ptBox = ptBox;
	// m_lLife _xZkqqHx_iCmMjAnNjCoIiBeC_xHqqkZx_
	m_lLife = lLife;
	// _xZkqqHx_iKePjAnKiDhEiDiMiBfLiDiAiCpAjFnEiClHiBeC_xHqqkZx_
	return rtFrame;
} // FCHTreeRec::CalcLayoutBranch.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::GetDocumentId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.05.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCHTreeRec::GetDocumentId () const
{
	return m_lDocId;
} // FCHTreeRec::GetDocumentId.

//----- 06.02.06 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::CheckSummaryUpdated
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCkKiBeBjBePiJpBiCmMjDmHiCnNiNjOiCnNiCkJiCoHiNfIjAfGiClDiCoKiCmEiCkCiCoJ_xHqqkZx_
// *			_xZkqqHx_iCkJiCmHiCkEiCkJiCpAiDgAiDeGiDgCiDeOiClHiCoJiBeCiNfIjAfGiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiBeBiNfIjAfGiClDiCoKiClNiClBiCmGiCpA_xHqqkZx_
// *			_xZkqqHx_iDhEiDiJiDePiCmJiLeMjIfOiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_jHjKjHpAiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCmNiBeBjDmHiCnNiNjOiCnNiDiNiDgCiDeOiClDiCoKiCoJiBeC_xHqqkZx_
// *			_xZkqqHx_iMoDiCmFiBeBjBfDiCmEiDiNiDgCiDeOiCpAiJpAjFpKiClHiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.01.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCHTreeRec::CheckSummaryUpdated (const FCDbReadLock& readLock)
//{
////----- 06.01.30 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	if (m_autoLockSummaryRead.TryLock())
////	//----- _xZkqqHx_iDhEiDeAiDeDiDiLiCkKiDiNiDgCiDeOiCmFiCkLiClNiPoKiNiH_xHqqkZx_ -----
////	{
////		// _xZkqqHx_iNfIjAfGiDeKiDeFiDjDiDfOiCmGjEoEiKhCiBeCiNfIjAfGiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiBeBiDeKiDeFiDjDiDfOiCmJ_xHqqkZx_DWORD(-1)_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
////		if (m_dwSummaryLastDeleteIdentifier != m_autoLockSummaryRead.GetLockDeleteIdentifier())
////			m_dwSummaryLastDeleteIdentifier = DWORD(-1);
////		if (m_dwSummaryLastAppendIdentifier != m_autoLockSummaryRead.GetLockAppendIdentifier())
////			m_dwSummaryLastAppendIdentifier = DWORD(-1);
////	} else
////	{
////		// _xZkqqHx_iDeHiDiJiBfLiCpAiDfIiDiNiBfLiBeC_xHqqkZx_
////		FFThrowMiscUserException(g_pFileServer->GetErrorCode(), g_pFileServer->GetErrorMessage());
////	}
////----- 06.01.30 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//	ASSERT(readLock.IsLocked());
//	ASSERT(readLock.GetTableName().GetLast() == FDHI_SUMMARY_TABLE_ID);
//
//	if (m_guidSummaryTable != readLock.GetLockedTableGuid())
//	//----- _xZkqqHx_iDgFiBfLiDhFiDiLiCkKiInJiCmIiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		m_dwSummaryLastDeleteIdentifier = DWORD(-1);
//		m_dwSummaryLastAppendIdentifier = DWORD(-1);
//	} else
//	//----- _xZkqqHx_iDgFiBfLiDhFiDiLiCmNjDkPiClGiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iNfIjAfGiDeKiDeFiDjDiDfOiCmGjEoEiKhCiBeCiNfIjAfGiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiBeBiDeKiDeFiDjDiDfOiCmJ_xHqqkZx_DWORD(-1)_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
//		if (m_dwSummaryLastDeleteIdentifier != readLock.GetLockDeleteIdentifier())
//			m_dwSummaryLastDeleteIdentifier = DWORD(-1);
//		if (m_dwSummaryLastAppendIdentifier != readLock.GetLockAppendIdentifier())
//			m_dwSummaryLastAppendIdentifier = DWORD(-1);
//	}
////----- 06.01.30 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//} // FCHTreeRec::CheckSummaryUpdated.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::CheckTerminateUpdated
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAiPeJjCfLiDgFiBfLiDhFiDiLiCkKiBeBjBePiJpBiCmMjDmHiCnNiNjOiCnNiCkJiCoHiNfIjAfGiClDiCoKiCmEiCkCiCoJ_xHqqkZx_
// *			_xZkqqHx_iCkJiCmHiCkEiCkJiCpAiDgAiDeGiDgCiDeOiClHiCoJiBeCiNfIjAfGiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiBeBiNfIjAfGiClDiCoKiClNiClBiCmGiCpA_xHqqkZx_
// *			_xZkqqHx_iDhEiDiJiDePiCmJiLeMjIfOiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_jHjKjHpAiPeJjCfLiDgFiBfLiDhFiDiLiCmNiBeBjDmHiCnNiNjOiCnNiDiNiDgCiDeOiClDiCoKiCoJiBeC_xHqqkZx_
// *			_xZkqqHx_iMoDiCmFiBeBjBfDiCmEiDiNiDgCiDeOiCpAiJpAjFpKiClHiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.01.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCHTreeRec::CheckTerminateUpdated (const FCDbReadLock& readLock)
//{
////----- 06.01.30 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	// _xZkqqHx_jFeLiClI_xHqqkZx_ m_autoLockTerminateRead.TryLockShared _xZkqqHx_iCpAiOmAiNhDiClHiCoJ_xHqqkZx_
////	// _xZkqqHx_jFeLjHhGiCkKiCkAiCoJiClNiCnPiBeB_xHqqkZx_IsTerminateUpdated()_xZkqqHx_iCmFiDgAiDeGiDgCiDeOiNmPiCnNiCkJ_xHqqkZx_
////	// _xZkqqHx_jClCiCnHiCmIiCkCiBeC_xHqqkZx_
////
////	if (m_autoLockTerminateRead.TryLock())
////	//----- _xZkqqHx_iDhEiDeAiDeDiDiLiCkKiDiNiDgCiDeOiCmFiCkLiClNiPoKiNiH_xHqqkZx_ -----
////	{
////		// _xZkqqHx_iNfIjAfGiDeKiDeFiDjDiDfOiCmGjEoEiKhCiBeCiNfIjAfGiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiBeBiDeKiDeFiDjDiDfOiCmJ_xHqqkZx_DWORD(-1)_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
////		if (m_dwTerminateLastDeleteIdentifier != m_autoLockTerminateRead.GetLockDeleteIdentifier())
////			m_dwTerminateLastDeleteIdentifier = DWORD(-1);
////		if (m_dwTerminateLastAppendIdentifier != m_autoLockTerminateRead.GetLockAppendIdentifier())
////			m_dwTerminateLastAppendIdentifier = DWORD(-1);
////	} else
////	{
////		// _xZkqqHx_iDeHiDiJiBfLiCpAiDfIiDiNiBfLiBeC_xHqqkZx_
////		FFThrowMiscUserException(g_pFileServer->GetErrorCode(), g_pFileServer->GetErrorMessage());
////	}
////----- 06.01.30 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//	ASSERT(readLock.IsLocked());
//	ASSERT(readLock.GetTableName().GetLast() == FDHI_TERMINATE_TABLE_ID);
//
//	if (m_guidTerminateTable != readLock.GetLockedTableGuid())
//	//----- _xZkqqHx_iDgFiBfLiDhFiDiLiCkKiInJiCmIiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		m_dwTerminateLastDeleteIdentifier = DWORD(-1);
//		m_dwTerminateLastAppendIdentifier = DWORD(-1);
//	} else
//	//----- _xZkqqHx_iDgFiBfLiDhFiDiLiCmNjDkPiClGiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iNfIjAfGiDeKiDeFiDjDiDfOiCmGjEoEiKhCiBeCiNfIjAfGiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiBeBiDeKiDeFiDjDiDfOiCmJ_xHqqkZx_DWORD(-1)_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
//		if (m_dwTerminateLastDeleteIdentifier != readLock.GetLockDeleteIdentifier())
//			m_dwTerminateLastDeleteIdentifier = DWORD(-1);
//		if (m_dwTerminateLastAppendIdentifier != readLock.GetLockAppendIdentifier())
//			m_dwTerminateLastAppendIdentifier = DWORD(-1);
//	}
////----- 06.01.30 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//} // FCHTreeRec::CheckTerminateUpdated.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::CheckForkUpdated
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCkKiBeBjBePiJpBiCmMjDmHiCnNiNjOiCnNiCkJiCoHiNfIjAfGiClDiCoKiCmEiCkCiCoJ_xHqqkZx_
// *			_xZkqqHx_iCkJiCmHiCkEiCkJiCpAiDgAiDeGiDgCiDeOiClHiCoJiBeCiNfIjAfGiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiBeBiNfIjAfGiClDiCoKiClNiClBiCmGiCpA_xHqqkZx_
// *			_xZkqqHx_iDhEiDiJiDePiCmJiLeMjIfOiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_jHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCmNiBeBjDmHiCnNiNjOiCnNiDiNiDgCiDeOiClDiCoKiCoJiBeC_xHqqkZx_
// *			_xZkqqHx_iMoDiCmFiBeBjBfDiCmEiDiNiDgCiDeOiCpAiJpAjFpKiClHiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.01.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCHTreeRec::CheckForkUpdated (const FCDbReadLock& readLock)
//{
////----- 06.01.30 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	if (m_autoLockForkRead.TryLock())
////	//----- _xZkqqHx_iDhEiDeAiDeDiDiLiCkKiDiNiDgCiDeOiCmFiCkLiClNiPoKiNiH_xHqqkZx_ -----
////	{
////		// _xZkqqHx_iNfIjAfGiDeKiDeFiDjDiDfOiCmGjEoEiKhCiBeCiNfIjAfGiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiBeBiDeKiDeFiDjDiDfOiCmJ_xHqqkZx_DWORD(-1)_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
////		if (m_dwForkLastDeleteIdentifier != m_autoLockForkRead.GetLockDeleteIdentifier())
////			m_dwForkLastDeleteIdentifier = DWORD(-1);
////		if (m_dwForkLastAppendIdentifier != m_autoLockForkRead.GetLockAppendIdentifier())
////			m_dwForkLastAppendIdentifier = DWORD(-1);
////	} else
////	{
////		// _xZkqqHx_iDeHiDiJiBfLiCpAiDfIiDiNiBfLiBeC_xHqqkZx_
////		FFThrowMiscUserException(g_pFileServer->GetErrorCode(), g_pFileServer->GetErrorMessage());
////	}
////----- 06.01.30 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//	ASSERT(readLock.IsLocked());
//	ASSERT(readLock.GetTableName().GetLast() == FDHI_FORK_TABLE_ID);
//
//	if (m_guidForkTable != readLock.GetLockedTableGuid())
//	//----- _xZkqqHx_iDgFiBfLiDhFiDiLiCkKiInJiCmIiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		m_dwForkLastDeleteIdentifier = DWORD(-1);
//		m_dwForkLastAppendIdentifier = DWORD(-1);
//	} else
//	//----- _xZkqqHx_iDgFiBfLiDhFiDiLiCmNjDkPiClGiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iNfIjAfGiDeKiDeFiDjDiDfOiCmGjEoEiKhCiBeCiNfIjAfGiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiBeBiDeKiDeFiDjDiDfOiCmJ_xHqqkZx_DWORD(-1)_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
//		if (m_dwForkLastDeleteIdentifier != readLock.GetLockDeleteIdentifier())
//			m_dwForkLastDeleteIdentifier = DWORD(-1);
//		if (m_dwForkLastAppendIdentifier != readLock.GetLockAppendIdentifier())
//			m_dwForkLastAppendIdentifier = DWORD(-1);
//	}
////----- 06.01.30 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//} // FCHTreeRec::CheckForkUpdated.
//----- 06.02.06 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 06.02.06 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::IsSummaryOverwrited
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCkKiBeBjBlMiCmMiDeBiDhGiDiKiCmFiPoDiPjBiCkLiClDiCoKiCmEiCkCiCoJiCkJ_xHqqkZx_
// *			_xZkqqHx_iCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPoDiPjBiCkLiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	_xZkqqHx_jAkLjEfMiCpAiMpMiPoDiClDiClJiCoJiClNiCnPiBeBiDhEiDeAiDeDiDiLiDgAiDeGiDgCiDeOiCmNiOkJjDkOjDeJiCmJiNhDiCoNiClIiBeB_xHqqkZx_
// *			CheckHistoryIndexAndTerminateUpdated _xZkqqHx_iCmFiNhDiCkEiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.01.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCHTreeRec::IsSummaryOverwrited () const
//{
//	return (m_dwSummaryLastDeleteIdentifier == DWORD(-1));
//} // FCHTreeRec::IsSummaryOverwrited.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::IsSummaryAppended
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCkKiBeBjBlMiCmMiDeBiDhGiDiKiCmFjCmHiJmBiClDiCoKiCmEiCkCiCoJiCkJ_xHqqkZx_
// *			_xZkqqHx_iCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jCmHiJmBiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	_xZkqqHx_jAkLjEfMiCpAiMpMiPoDiClDiClJiCoJiClNiCnPiBeBiDhEiDeAiDeDiDiLiDgAiDeGiDgCiDeOiCmNiOkJjDkOjDeJiCmJiNhDiCoNiClIiBeB_xHqqkZx_
// *			CheckHistoryIndexAndTerminateUpdated _xZkqqHx_iCmFiNhDiCkEiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.01.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCHTreeRec::IsSummaryAppended () const
//{
//	return (m_dwSummaryLastAppendIdentifier == DWORD(-1));
//} // FCHTreeRec::IsSummaryAppended.
//----- 06.02.06 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::IsSummaryOverwrited
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCkKiBeBjBlMiCmMiDeBiDhGiDiKiCmFiPoDiPjBiCkLiClDiCoKiCmEiCkCiCoJiCkJ_xHqqkZx_
 *			_xZkqqHx_iCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	readLock	:_xZkqqHx_iDgFiBfLiDhFiDiLiCmMiDiNiDgCiDeOiNmPiCnNjFmPjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPoDiPjBiCkLiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCHTreeRec::IsSummaryOverwrited (const FCDbReadLock& readLock)
{
	ASSERT(readLock.IsLocked());
	ASSERT(readLock.GetTableName().GetLast() == FDHI_SUMMARY_TABLE_ID);
	FCDbTable dbTable(readLock.GetTableName());
	// _xZkqqHx_iDfEiDhNiDiKiBfLiDgFiBfLiDhFiDiLiCmMiDgFiBfLiDhFiDiL_xHqqkZx_GUID_xZkqqHx_iBeC_xHqqkZx_
	if (m_guidSummaryTable != dbTable.GetTableGuid())
		return TRUE;
	if (dbTable.GetRecordCount() < m_dwSummaryLastEndIndex)
		return TRUE;
	if (m_dwSummaryLastEndIndex == 0)
		return FALSE;
	if (dbTable.GetRecordAppendIdentifier(m_dwSummaryLastEndIndex - 1) != m_dwSummaryLastAppendIdentifier)
		return TRUE;
	return FALSE;
} // FCHTreeRec::IsSummaryOverwrited.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::IsSummaryAppended
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCkKiBeBjBlMiCmMiDeBiDhGiDiKiCmFjCmHiJmBiClDiCoKiCmEiCkCiCoJiCkJ_xHqqkZx_
 *			_xZkqqHx_iCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	readLock	:_xZkqqHx_iDgFiBfLiDhFiDiLiCmMiDiNiDgCiDeOiNmPiCnNjFmPjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jCmHiJmBiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCHTreeRec::IsSummaryAppended (const FCDbReadLock& readLock)
{
	ASSERT(readLock.IsLocked());
	ASSERT(readLock.GetTableName().GetLast() == FDHI_SUMMARY_TABLE_ID);
	FCDbTable dbTable(readLock.GetTableName());
	// _xZkqqHx_iDfEiDhNiDiKiBfLiDgFiBfLiDhFiDiLiCmMiDgFiBfLiDhFiDiL_xHqqkZx_GUID_xZkqqHx_iBeC_xHqqkZx_
	if (m_guidSummaryTable != dbTable.GetTableGuid())
		return TRUE;
	if (dbTable.GetRecordCount() <= m_dwSummaryLastEndIndex)
		return FALSE;
	if (m_dwSummaryLastEndIndex == 0)
		return TRUE;
	if (dbTable.GetRecordAppendIdentifier(m_dwSummaryLastEndIndex - 1) == m_dwSummaryLastAppendIdentifier)
		return TRUE;
	return FALSE;
} // FCHTreeRec::IsSummaryAppended.
//----- 06.02.06 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::IsTerminateOverwrited
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAiPeJjCfLiDgFiBfLiDhFiDiLiCkKiBeBjBlMiCmMiDeBiDhGiDiKiCmFiPoDiPjBiCkLiClDiCoKiCmEiCkCiCoJiCkJ_xHqqkZx_
 *			_xZkqqHx_iCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	readLock	:_xZkqqHx_iDgFiBfLiDhFiDiLiCmMiDiNiDgCiDeOiNmPiCnNjFmPjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPoDiPjBiCkLiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCHTreeRec::IsTerminateOverwrited (const FCDbReadLock& readLock)
{
	ASSERT(readLock.IsLocked());
	ASSERT(readLock.GetTableName().GetLast() == FDHI_TERMINATE_TABLE_ID);
	FCDbTable dbTable(readLock.GetTableName());
	// _xZkqqHx_iDfEiDhNiDiKiBfLiDgFiBfLiDhFiDiLiCmMiDgFiBfLiDhFiDiL_xHqqkZx_GUID_xZkqqHx_iBeC_xHqqkZx_
	if (m_guidTerminateTable != dbTable.GetTableGuid())
		return TRUE;
	if (dbTable.GetRecordCount() < m_dwTerminateLastEndIndex)
		return TRUE;
	if (m_dwTerminateLastEndIndex == 0)
		return FALSE;
	if (dbTable.GetRecordAppendIdentifier(m_dwTerminateLastEndIndex - 1) != m_dwTerminateLastAppendIdentifier)
		return TRUE;
	return FALSE;
} // FCHTreeRec::IsTerminateOverwrited.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::IsTerminateAppended
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAiPeJjCfLiDgFiBfLiDhFiDiLiCkKiBeBjBlMiCmMiDeBiDhGiDiKiCmFjCmHiJmBiClDiCoKiCmEiCkCiCoJiCkJ_xHqqkZx_
 *			_xZkqqHx_iCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	readLock	:_xZkqqHx_iDgFiBfLiDhFiDiLiCmMiDiNiDgCiDeOiNmPiCnNjFmPjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jCmHiJmBiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCHTreeRec::IsTerminateAppended (const FCDbReadLock& readLock)
{
	ASSERT(readLock.IsLocked());
	ASSERT(readLock.GetTableName().GetLast() == FDHI_TERMINATE_TABLE_ID);
	FCDbTable dbTable(readLock.GetTableName());
	// _xZkqqHx_iDfEiDhNiDiKiBfLiDgFiBfLiDhFiDiLiCmMiDgFiBfLiDhFiDiL_xHqqkZx_GUID_xZkqqHx_iBeC_xHqqkZx_
	if (m_guidTerminateTable != dbTable.GetTableGuid())
		return TRUE;
	if (dbTable.GetRecordCount() <= m_dwTerminateLastEndIndex)
		return FALSE;
	if (m_dwTerminateLastEndIndex == 0)
		return TRUE;
	if (dbTable.GetRecordAppendIdentifier(m_dwTerminateLastEndIndex - 1) == m_dwTerminateLastAppendIdentifier)
		return TRUE;
	return FALSE;
} // FCHTreeRec::IsTerminateAppended.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::IsForkOverwrited
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCkKiBeBjBlMiCmMiDeBiDhGiDiKiCmFiPoDiPjBiCkLiClDiCoKiCmEiCkCiCoJiCkJ_xHqqkZx_
 *			_xZkqqHx_iCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	readLock	:_xZkqqHx_iDgFiBfLiDhFiDiLiCmMiDiNiDgCiDeOiNmPiCnNjFmPjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPoDiPjBiCkLiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCHTreeRec::IsForkOverwrited (const FCDbReadLock& readLock)
{
	ASSERT(readLock.IsLocked());
	ASSERT(readLock.GetTableName().GetLast() == FDHI_FORK_TABLE_ID);
	FCDbTable dbTable(readLock.GetTableName());
	// _xZkqqHx_iDfEiDhNiDiKiBfLiDgFiBfLiDhFiDiLiCmMiDgFiBfLiDhFiDiL_xHqqkZx_GUID_xZkqqHx_iBeC_xHqqkZx_
	if (m_guidForkTable != dbTable.GetTableGuid())
		return TRUE;
	if (dbTable.GetRecordCount() < m_dwForkLastEndIndex)
		return TRUE;
	if (m_dwForkLastEndIndex == 0)
		return FALSE;
	if (dbTable.GetRecordAppendIdentifier(m_dwForkLastEndIndex - 1) != m_dwForkLastAppendIdentifier)
		return TRUE;
	return FALSE;
} // FCHTreeRec::IsForkOverwrited.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::IsForkAppended
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCkKiBeBjBlMiCmMiDeBiDhGiDiKiCmFjCmHiJmBiClDiCoKiCmEiCkCiCoJiCkJ_xHqqkZx_
 *			_xZkqqHx_iCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	readLock	:_xZkqqHx_iDgFiBfLiDhFiDiLiCmMiDiNiDgCiDeOiNmPiCnNjFmPjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jCmHiJmBiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCHTreeRec::IsForkAppended (const FCDbReadLock& readLock)
{
	ASSERT(readLock.IsLocked());
	ASSERT(readLock.GetTableName().GetLast() == FDHI_FORK_TABLE_ID);
	FCDbTable dbTable(readLock.GetTableName());
	// _xZkqqHx_iDfEiDhNiDiKiBfLiDgFiBfLiDhFiDiLiCmMiDgFiBfLiDhFiDiL_xHqqkZx_GUID_xZkqqHx_iBeC_xHqqkZx_
	if (m_guidForkTable != dbTable.GetTableGuid())
		return TRUE;
	if (dbTable.GetRecordCount() <= m_dwForkLastEndIndex)
		return FALSE;
	if (m_dwForkLastEndIndex == 0)
		return TRUE;
	if (dbTable.GetRecordAppendIdentifier(m_dwForkLastEndIndex - 1) == m_dwForkLastAppendIdentifier)
		return TRUE;
	return FALSE;
} // FCHTreeRec::IsForkAppended.

//----- 06.02.06 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::IsTerminateUpdated
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAiPeJjCfLiDgFiBfLiDhFiDiLiCkKiBeBjBlMiCmMiDeBiDhGiDiKiCmFiNfIjAfGiClDiCoKiCmEiCkCiCoJiCkJ_xHqqkZx_
// *			_xZkqqHx_iCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNfIjAfGiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	_xZkqqHx_jAkLjEfMiCpAiMpMiPoDiClDiClJiCoJiClNiCnPiBeBiDhEiDeAiDeDiDiLiDgAiDeGiDgCiDeOiCmNiOkJjDkOjDeJiCmJiNhDiCoNiClIiBeB_xHqqkZx_
// *			CheckHistoryIndexAndTerminateUpdated _xZkqqHx_iCmFiNhDiCkEiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.01.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCHTreeRec::IsTerminateUpdated () const
//{
//	return ((m_dwTerminateLastDeleteIdentifier == DWORD(-1)) ||
//			(m_dwTerminateLastAppendIdentifier == DWORD(-1)));
//} // FCHTreeRec::IsTerminateUpdated.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::IsForkUpdated
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCkKiBeBjBlMiCmMiDeBiDhGiDiKiCmFiNfIjAfGiClDiCoKiCmEiCkCiCoJiCkJ_xHqqkZx_
// *			_xZkqqHx_iCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNfIjAfGiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	_xZkqqHx_jAkLjEfMiCpAiMpMiPoDiClDiClJiCoJiClNiCnPiBeBiDhEiDeAiDeDiDiLiDgAiDeGiDgCiDeOiCmNiOkJjDkOjDeJiCmJiNhDiCoNiClIiBeB_xHqqkZx_
// *			CheckForkUpdated _xZkqqHx_iCmFiNhDiCkEiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.01.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCHTreeRec::IsForkUpdated () const
//{
//	return ((m_dwForkLastDeleteIdentifier == DWORD(-1)) ||
//			(m_dwForkLastAppendIdentifier == DWORD(-1)));
//} // FCHTreeRec::IsForkUpdated.
//----- 06.02.06 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 05.11.21 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::SetIsTerminateUpdated
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAiPeJjCfLiDgFiBfLiDhFiDiLiCmMiNfIjAfGiDhEiDiJiDePiCpAiCgOiCgNiCmJiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	_xZkqqHx_iDfEiDhNiDiKiBfLiDgFiBfLiDhFiDiLiCmJiNfIjAfGiCkKjDpMiCmBiClNiPoKiNiHiBeBjHjKjHpAiPeJjCfLiImKjChFiCmJiCmN_xHqqkZx_
// *			_xZkqqHx_jFeLiClIiNfIjAfGiCkKjDpMiCoJiBeC_xHqqkZx_
// *			_xZkqqHx_jAkLjEfMiCpAiMpMiPoDiClDiClJiCoJiClNiCnPiBeBiDfEiDhNiDiKiBfLiDgFiBfLiDhFiDiLiCmJiNfIjAfGiCkKjDpMiCmBiClNiPoKiNiH_xHqqkZx_
// *			_xZkqqHx_iClBiCmMiKnGjAjEiCmFiDhEiDiJiDePiCpAiDgNiBfLiDgAiDeGiDgCiDeOiCmFiCgOiCgNiCmJiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.01.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCHTreeRec::SetIsTerminateUpdated ()
//{
//	m_dwTerminateLastDeleteIdentifier = DWORD(-1);
//	m_dwTerminateLastAppendIdentifier = DWORD(-1);
//} // FCHTreeRec::SetIsTerminateUpdated.
//----- 05.11.21 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 06.01.30 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::UnlockAll
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDoAjFjEiCmFiDiNiDgCiDeOiClDiCoKiCmEiCkCiCoJiDhEiDeAiDeDiDiLiCpAiJpAjFpKiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.01.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCHTreeRec::UnlockAll ()
//{
//	m_autoLockSummaryRead.UnlockAll();
//	m_autoLockTerminateRead.UnlockAll();
//	m_autoLockForkRead.UnlockAll();
//} // FCHTreeRec::UnlockAll.
//----- 06.01.30 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::LoadSummary
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAjDmHiCnNiNjOiCnNiBeBjFmPjAjEiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	_xZkqqHx_iImIiJlKiCmMjFmPjAjEiCkKiNfIjAfGiClDiCoKiCoJiBeC_xHqqkZx_
 *			m_vHiLabelRecAuto	_xZkqqHx_iDiJiDhIiDiLiLeMjIfOiCmMiDiKiDfIiDgHiBeC_xHqqkZx_
 *			m_vTimeRec			_xZkqqHx_iNfIjAfGiOjOiKnEiLeMjIfOiCmMiDiKiDfIiDgHiBeC_xHqqkZx_
 *			m_mmapSessionToNode	_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiImKjChF_xHqqkZx_->_xZkqqHx_iDiJiDhIiDiLiBeFjHjKjHpAiNkMiNnNiDgOiDgCiDfGiDiFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_jHjKjHpAiPeJjCfLiDgFiBfLiDhFiDiLiCmNiBeBjDmHiCnNiNjOiCnNiDiNiDgCiDeOiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iMoDiCmFiBeBjBfDiCmEiDiNiDgCiDeOiCpAiJpAjFpKiClHiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.01.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHTreeRec::LoadSummary (const FCDbReadLock& readLock)
{
	// _xZkqqHx_jBePiJpBjHjKjHpAiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCmMjDmHiCnNiNjOiCpBiClOiImKjChFiCpAiDiKiDfKiDgCiDgHiBeC_xHqqkZx_
	m_dwSummaryLastEndIndex = 0;
	// _xZkqqHx_iDiJiDhIiDiLiLeMjIfOiCmMiDiKiDfIiDgHiBeC_xHqqkZx_
	m_vHiLabelRecAuto.clear();
	// _xZkqqHx_iNfIjAfGiOjOiKnEiLeMjIfOiCmMiDiKiDfIiDgHiBeC_xHqqkZx_
	m_vTimeRec.clear();
	// _xZkqqHx_jCmHiJmBjDmHiCnNiNjOiCnNiKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
	AppendSummary(readLock);
} // FCHTreeRec::LoadSummary.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::AppendSummary
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAjCmHiJmBiCmFjDmHiCnNiNjOiCnNiBeBjFmPjAjEiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	_xZkqqHx_iImIiJlKiCmMjFmPjAjEiCkKiNfIjAfGiClDiCoKiCoJiBeC_xHqqkZx_
 *			m_vHiLabelRecAuto	_xZkqqHx_iDiJiDhIiDiLiLeMjIfOiCmMiDiKiDfIiDgHiBeC_xHqqkZx_
 *			m_vTimeRec				_xZkqqHx_iNfIjAfGiOjOiKnEiLeMjIfOiCmMiDiKiDfIiDgHiBeC_xHqqkZx_
 *			m_mmapSessionToNode		_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiImKjChF_xHqqkZx_->_xZkqqHx_iDiJiDhIiDiLiBeFjHjKjHpAiNkMiNnNiDgOiDgCiDfGiDiFiBeC_xHqqkZx_
 *			m_dwSummaryLastEndIndex
 *									_xZkqqHx_jBePiJpBjHjKjHpAiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCmMjDmHiCnNiNjOiCpBiClOiImKjChF_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_jHjKjHpAiPeJjCfLiDgFiBfLiDhFiDiLiCmNiBeBjDmHiCnNiNjOiCnNiDiNiDgCiDeOiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iMoDiCmFiBeBjBfDiCmEiDiNiDgCiDeOiCpAiJpAjFpKiClHiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.01.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHTreeRec::AppendSummary (const FCDbReadLock& readLock)
{
//----- 06.01.30 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// CheckSummaryUpdated_xZkqqHx_iKnGjAjEiCpAiMmEiCpBiClOiMoDiCmJiOmAiNhDiClDiCoKiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
//	if (!m_autoLockSummaryRead.IsLocked())
//		FFThrowMiscUnknown();
//	// _xZkqqHx_jHjKjHpAiDeDiDjDiDgGiDgCiDeOiDfIiCpAiDeJiBfLiDhGiDjDiBeC_xHqqkZx_
//	FCHiSummaryTable hiSummaryTable;
//	hiSummaryTable.OpenExisting(*GetHTreeManager()->GetProject(), GetDocumentId());
//	// _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiDfEiDeDiDfJiCpAiOoGjDlOiBeC_xHqqkZx_
//	const flint fliHistoryIndexLength = hiSummaryTable.GetLength();
//	// _xZkqqHx_jHjKjHpAiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAjBePiJpBjDmHiCnNiNjOiCpBiClOiImKjChFiCnGiInKjDkOiBeC_xHqqkZx_
//	hiSummaryTable.SeekToSessionIndex(m_dwSummaryLastEndIndex, FILE_BEGIN);
//	flint fliSessionIndex;
//	GUID guidUserId;
//	FDSECTIME fdstCreateTime;
//	DWORD dwObjId;
//	WString wstrLabel;
//	while (hiSummaryTable.GetPosition() < fliHistoryIndexLength)
//	{
//		// _xZkqqHx_jHjKjHpAiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCmMiMlLiNnNiCmMiImKjChFiCmMiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCkK_xHqqkZx_
//		// _xZkqqHx_iPeJjDfPiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAjClEiCkGiCoJiPoKiNiHiCoAiCkAiCoJiBeC_xHqqkZx_
//		// Undo_xZkqqHx_iCpAiClFiClNiPoKiNiHiCmIiCmHiBeCiPeJjDfPiCpAiJhKiCkGiCmEiCoAjBfDiCmEiCpAjDmHiCnNiPgPiClHjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
////----- 05.11.21 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////		// _xZkqqHx_jDmHiCnNiCmGiCmBiClNjHjKjHpAiDhEiDeAiDeDiDiLiImKjChFiCkKiBeBiPeJjDfPiImKjChFiCoGiCoIjBoFiCkLiCkPiCoKiCmOiPeJjHlJiBeC_xHqqkZx_
////		if (GetEndSessionIndex() < hiSummaryTable.SeeNextSessionIndex() + 1) break;
////----- 05.11.21 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//		switch (hiSummaryTable.SeeCodeNext())
//		{
//		case FDHI_LABEL_CREATE:		// _xZkqqHx_iDiJiDhIiDiLiNoMjAkMiDiMiDfCiBfLiDgIiBeC_xHqqkZx_
//			// _xZkqqHx_iKeKiOgOiDiJiDhIiDiLiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
//			hiSummaryTable.LoadLabelCreate(	fliSessionIndex,
//										guidUserId,
//										fdstCreateTime,
//										dwObjId,
//										wstrLabel);
//			// _xZkqqHx_iDiJiDhIiDiLiDiKiDfIiDgHiCmJiDiJiDhIiDiLiPoOjFpBiCpAjCmHiJmBiBeC_xHqqkZx_
//			m_vHiLabelRecAuto.push_back(
//// 05.11.04 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
////					FCHiLabelRecAuto(new FCHiLabelRec(	fliSessionIndex,
//					FCHiLabelRecAuto(new FCHiLabelRec(	fliSessionIndex + 1,
//																guidUserId,
//																fdstCreateTime,
//																dwObjId,
//																wstrLabel)));
//			break;
//		case FDHI_LABEL_DELETE:		// _xZkqqHx_iDiJiDhIiDiLiNoNiPjMiDiMiDfCiBfLiDgIiBeC_xHqqkZx_
//			hiSummaryTable.SkipSession();
//			break;
//		case FDHI_ABS_TIME:			// _xZkqqHx_jAoCjBmOiOjOiKnEiDiMiDfCiBfLiDgIiBeC_xHqqkZx_
//			hiSummaryTable.LoadAbsTime(fliSessionIndex, guidUserId, fdstCreateTime);
//// 05.11.04 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
////			m_vTimeRec.push_back(HTRTimeRec(fliSessionIndex, fdstCreateTime));
//			m_vTimeRec.push_back(HTRTimeRec(fliSessionIndex + 1, fdstCreateTime));
//			break;
//		default:
//			// "_xZkqqHx_iDhEiDeAiDeDiDiLiBhF_xHqqkZx_%s_xZkqqHx_iBhGiCmNjEgKjBlJiClFiCmEiCkCiCnMiClHiBeCiPeDjFjMiDgDiBfLiDiLiCmFiPeDjFjMiClFiCmEiCkNiClOiClDiCkC_xHqqkZx_"
//			FFThrowMiscException(IDS_ERR_MSG_REPAIR_DAMAGED_FILE,
//									(const wchar_t*)hiSummaryTable.GetFilePath());
//		}
//	}
//	// _xZkqqHx_jHjKjHpAiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCmMjDmHiCnNiNjOiCpBiClOiImKjChFiCpAiLeMjIfOiClFiCmEiCkIiCkNiBeC_xHqqkZx_
//	m_dwSummaryLastEndIndex = hiSummaryTable.GetPosition();
//	// _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAjFmCiClGiCoJiBeC_xHqqkZx_
//	hiSummaryTable.Close();
//
//	if (m_mmapSessionToNode != NULL)
//	//----- _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiImKjChF_xHqqkZx_->_xZkqqHx_iDiJiDhIiDiLiBeFjHjKjHpAiNkMiNnNiDgOiDgCiDfGiDiFiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiImKjChF_xHqqkZx_->_xZkqqHx_iDiJiDhIiDiLiBeFjHjKjHpAiNkMiNnNiDgOiDgCiDfGiDiFiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
//		delete m_mmapSessionToNode;
//		m_mmapSessionToNode = NULL;
//	}
//	// _xZkqqHx_iNfIjAfGiDeKiDeFiDjDiDfOiCpAjAnNjCoIiBeC_xHqqkZx_
//	m_dwSummaryLastDeleteIdentifier = m_autoLockSummaryRead.GetLockDeleteIdentifier();
//	m_dwSummaryLastAppendIdentifier = m_autoLockSummaryRead.GetLockAppendIdentifier();
//----- 06.01.30 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_jHjKjHpAiDeDiDjDiDgGiDgCiDeOiDfIiCpAiDeJiBfLiDhGiDjDiBeC_xHqqkZx_
	FCHiSummaryTable summaryTable;
	summaryTable.Set(readLock.GetTableName());
	summaryTable.UpdateData(readLock);

	// _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiDfEiDeDiDfJiCpAiOoGjDlOiBeC_xHqqkZx_
	const DWORD dwSummaryCount = summaryTable.GetRecordCount();

	// _xZkqqHx_jHjKjHpAiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAjBePiJpBjDmHiCnNiNjOiCpBiClOiImKjChFiCnGiInKjDkOiBeC_xHqqkZx_
	DWORD dwIndex;
	for (dwIndex = m_dwSummaryLastEndIndex;
		 dwIndex != dwSummaryCount; dwIndex++)
	{
		// _xZkqqHx_jHjKjHpAiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCmMiMlLiNnNiCmMiImKjChFiCmMiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCkK_xHqqkZx_
		// _xZkqqHx_iPeJjDfPiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAjClEiCkGiCoJiPoKiNiHiCoAiCkAiCoJiBeC_xHqqkZx_
		// Undo_xZkqqHx_iCpAiClFiClNiPoKiNiHiCmIiCmHiBeCiPeJjDfPiCpAiJhKiCkGiCmEiCoAjBfDiCmEiCpAjDmHiCnNiPgPiClHjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_

		flint fliSessionIndex;
		GUID guidUserId;
		FDSECTIME fdstCreateTime;
		BOOL bIsAbsTime;
		FCStLabelOperateVector vLabelOperate;
		summaryTable.LoadRecord(&fliSessionIndex,
								&guidUserId,
								&fdstCreateTime,
								&bIsAbsTime,
								&vLabelOperate,
								FALSE,
								dwIndex);
		// _xZkqqHx_iOjOiKnEiPoOjFpBiCpAjCmHiJmBiBeC_xHqqkZx_
		if (bIsAbsTime)
			m_vTimeRec.push_back(HTRTimeRec(fliSessionIndex + 1, guidUserId, fdstCreateTime));

//----- 06.04.07 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		// _xZkqqHx_iDiJiDhIiDiLiNoMjAkMiPoOjFpBiCpAjCmHiJmBiBeC_xHqqkZx_
//		mdef_const_iterator(FCStLabelOperateVector, iLop);
//		m1_for (iLop, vLabelOperate)
//		{
//			if (iLop->m_bIsCreate)
//			//----- _xZkqqHx_iDiJiDhIiDiLiNoMjAkMiCmMiPoKiNiH_xHqqkZx_ -----
//			{
//				// _xZkqqHx_iDiJiDhIiDiLiDiKiDfIiDgHiCmJiDiJiDhIiDiLiPoOjFpBiCpAjCmHiJmBiBeC_xHqqkZx_
//				m_vHiLabelRecAuto.push_back(
//						FCHiLabelRecAuto(new FCHiLabelRec(	fliSessionIndex + 1,
//																	guidUserId,
//																	fdstCreateTime,
//																	iLop->m_dwLabelId,
//																	iLop->m_wstrLabelText)));
//			}
//		}
//----- 06.04.07 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		// _xZkqqHx_iDiJiDhIiDiLiCpAjFkBiOmKiClFiCmEiNoMjAkMiClFiCmEiBeBiOjPiCmMiDfKiDgCiDfGiDiHiDjDiCmFjDoAjHgFiCpAiPeDjAlDiClHiCoJiPoKiNiHiBeB_xHqqkZx_
		// _xZkqqHx_iBhFiDiJiDhIiDiLiNoMjAkMiBhGiBeBiBhFiDiJiDhIiDiLiNoNiPjMiBhGiBjFiBhFiDiJiDhIiDiLiNoMjAkMiBhGiCmGiBeBiDfCiDhNiDjDiDgIiCkK_xHqqkZx_
		// _xZkqqHx_jHnHiCoIiNiHiCkEiDfKiDgCiDfGiDiHiDjDiCmFjIeBjBlBiClFiCmEiClFiCnMiCkEiBeC_xHqqkZx_
		// _xZkqqHx_iClBiCoKiCpAjHjKjHpAiNfMjBkCiDhCiDiFiBfLiCmJiCkCiClPiCkCiClPjFfMiOkGiClHiCoJiCmGiCkEiClEiCmBiClNiCkCiCmMiCmFiBeB_xHqqkZx_
		// _xZkqqHx_iNmFiPiJiCmMiNoMjAkMiBjFiNoNiPjMiCmNjDgPjIfOiClFiCmIiCkCiClBiCmGiCmJiClHiCoJiBeC_xHqqkZx_

		// _xZkqqHx_iDiJiDhIiDiLiNoMjAkMiPoOjFpBiCmMjCmHiJmBiBeC_xHqqkZx_
		mdef_const_iterator(FCStLabelOperateVector, iLop);
		m1_for (iLop, vLabelOperate)
		{
			if (iLop->m_bIsCreate && 1 < m_vHiLabelRecAuto.size())
			//----- _xZkqqHx_iDiJiDhIiDiLiPoOjFpBiCkKiCfBiCmCiImIiPoDiCkAiCoJiPoKiNiH_xHqqkZx_ -----
			{
				if ((m_vHiLabelRecAuto[m_vHiLabelRecAuto.size() - 1]->GetIsCreate() == FALSE) &&
					(m_vHiLabelRecAuto[m_vHiLabelRecAuto.size() - 2]->GetIsCreate() == TRUE) &&
					(m_vHiLabelRecAuto[m_vHiLabelRecAuto.size() - 1]->GetObjectId() == iLop->m_dwLabelId) &&
					(m_vHiLabelRecAuto[m_vHiLabelRecAuto.size() - 2]->GetObjectId() == iLop->m_dwLabelId) &&
					(m_vHiLabelRecAuto[m_vHiLabelRecAuto.size() - 1]->GetSessionIndex() == fliSessionIndex + 1) &&
					(m_vHiLabelRecAuto[m_vHiLabelRecAuto.size() - 2]->GetSessionIndex() == fliSessionIndex))
				//----- _xZkqqHx_jDkPiClGiDiJiDhIiDiL_xHqqkZx_ID_xZkqqHx_iCkKiBeBiBhFiNoMjAkMiBhGiBeBiBhFiNoNiPjMiBhGiBjFiBhFiNoMjAkMiBhGiCmGjBlBiCkNiPoKiNiH_xHqqkZx_ -----
				{
					m_vHiLabelRecAuto.pop_back();
					m_vHiLabelRecAuto.pop_back();
				}
			}
			// _xZkqqHx_iDiJiDhIiDiLiDiKiDfIiDgHiCmJiDiJiDhIiDiLiPoOjFpBiCpAjCmHiJmBiBeC_xHqqkZx_
			m_vHiLabelRecAuto.push_back(
					FCHiLabelRecAuto(new FCHiLabelRec(	iLop->m_bIsCreate,
														fliSessionIndex + 1,
														guidUserId,
														fdstCreateTime,
														iLop->m_dwLabelId,
														iLop->m_wstrLabelText)));
		}
//----- 06.04.07 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	}

	if (m_mmapSessionToNode != NULL)
	//----- _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiImKjChF_xHqqkZx_->_xZkqqHx_iDiJiDhIiDiLiBeFjHjKjHpAiNkMiNnNiDgOiDgCiDfGiDiFiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiImKjChF_xHqqkZx_->_xZkqqHx_iDiJiDhIiDiLiBeFjHjKjHpAiNkMiNnNiDgOiDgCiDfGiDiFiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
		delete m_mmapSessionToNode;
		m_mmapSessionToNode = NULL;
	}
	//----- _xZkqqHx_iNfIjAfGiDeKiDeFiDjDiDfOiCpAjAnNjCoI_xHqqkZx_ -----
	m_guidSummaryTable = summaryTable.GetTableGuid();
	m_dwSummaryLastEndIndex = summaryTable.GetRecordCount();
	if (m_dwSummaryLastEndIndex != 0)
		m_dwSummaryLastAppendIdentifier = summaryTable.GetRecordAppendIdentifier(m_dwSummaryLastEndIndex - 1);
	else
		m_dwSummaryLastAppendIdentifier = DWORD(-1);
//----- 06.01.30 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCHTreeRec::AppendSummary.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::LoadTerminateFile
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAiPeJjCfLiDgFiBfLiDhFiDiLiCpAjDmHiCnNiNjOiCnNiBeBjFmPjAjEiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	_xZkqqHx_iImIiJlKiCmMjFmPjAjEiCkKiNfIjAfGiClDiCoKiCoJiBeC_xHqqkZx_
// 04.11.12 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
// *			m_fliFirstSessionIndex	_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiPiJiKpKjCgMiBeC_xHqqkZx_
 *			m_fliEndSessionIndex	_xZkqqHx_jHjKjHpAiPeJjCfLiImKjChFiBeC_xHqqkZx_
 *			m_lLife;				_xZkqqHx_jHjKjHpAjApMiCmMjClHiClDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_jHjKjHpAiPeJjCfLiDgFiBfLiDhFiDiLiCmNiBeBjDmHiCnNiNjOiCnNiDiNiDgCiDeOiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iMoDiCmFiBeBjBfDiCmEiDiNiDgCiDeOiCpAiJpAjFpKiClHiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.01.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHTreeRec::LoadTerminateFile (const FCDbReadLock& readLock)
{
//----- 06.01.30 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// CheckTerminateUpdated_xZkqqHx_iKnGjAjEiCpAiMmEiCpBiClOiMoDiCmJiOmAiNhDiClDiCoKiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
//	if (!m_autoLockTerminateRead.IsLocked())
//		FFThrowMiscUnknown();
//	// _xZkqqHx_jHjKjHpAjApMiCmMjClHiClDiCpAiDeOiDiKiDeBiBeCjCgMiCmMjAnNjCoIiCmNiBeBiClBiClBiCmFiCmNiNhDiCoNiCmIiCkCiBeC_xHqqkZx_
//	m_lLife = -1;
//	//----- _xZkqqHx_jHjKjHpAiDhEiDeAiDeDiDiLiCmMiPeJjCfLiLeMjIfOiDeOiDiJiDfIiCpAiDeJiBfLiDhGiDjDiBjFjDmHiCnNiNjOiCnN_xHqqkZx_ -----
//	FCHiTerminateTable cmdTermFile;
//	cmdTermFile.Set(m_autoLockTerminateRead.GetTableName());
//	cmdTermFile.UpdateData(m_autoLockTerminateRead);
//	// _xZkqqHx_jHjKjHpAiPeJjCfLiImKjChFiCpAiOoGjDlOiBeC_xHqqkZx_
//	m_fliEndSessionIndex = cmdTermFile.SeeEndSessionIndex();
//	cmdTermFile.Close();
//
//	// _xZkqqHx_iPeJjCfLiCkKjCfKiCkNiCmIiCoJiPoKiNiHiCmNiBeB_xHqqkZx_m_mmapSessionToNode _xZkqqHx_iCmMiPeJiCoNiCoIiCkKiNoNiPjMiClDiCoKiCoJiBeC_xHqqkZx_
//	if (m_mmapSessionToNode != NULL)
//	//----- _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiImKjChF_xHqqkZx_->_xZkqqHx_iDiJiDhIiDiLiBeFjHjKjHpAiNkMiNnNiDgOiDgCiDfGiDiFiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiImKjChF_xHqqkZx_->_xZkqqHx_iDiJiDhIiDiLiBeFjHjKjHpAiNkMiNnNiDgOiDgCiDfGiDiFiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
//		delete m_mmapSessionToNode;
//		m_mmapSessionToNode = NULL;
//	}
//
//	// _xZkqqHx_iNfIjAfGiDeKiDeFiDjDiDfOiCpAjAnNjCoIiBeC_xHqqkZx_
//	m_dwTerminateLastDeleteIdentifier = m_autoLockTerminateRead.GetLockDeleteIdentifier();
//	m_dwTerminateLastAppendIdentifier = m_autoLockTerminateRead.GetLockAppendIdentifier();
//----- 06.01.30 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_jHjKjHpAjApMiCmMjClHiClDiCpAiDeOiDiKiDeBiBeCjCgMiCmMjAnNjCoIiCmNiBeBiClBiClBiCmFiCmNiNhDiCoNiCmIiCkCiBeC_xHqqkZx_
	m_lLife = -1;
	//----- _xZkqqHx_jHjKjHpAiDhEiDeAiDeDiDiLiCmMiPeJjCfLiLeMjIfOiDeOiDiJiDfIiCpAiDeJiBfLiDhGiDjDiBjFjDmHiCnNiNjOiCnN_xHqqkZx_ -----
	FCHiTerminateTable cmdTermFile;
	cmdTermFile.Set(readLock.GetTableName());
	cmdTermFile.UpdateData(readLock);
	// _xZkqqHx_jHjKjHpAiPeJjCfLiImKjChFiCpAiOoGjDlOiBeC_xHqqkZx_
	m_fliEndSessionIndex = cmdTermFile.SeeEndSessionIndex();

	// _xZkqqHx_iPeJjCfLiCkKjCfKiCkNiCmIiCoJiPoKiNiHiCmNiBeB_xHqqkZx_m_mmapSessionToNode _xZkqqHx_iCmMiPeJiCoNiCoIiCkKiNoNiPjMiClDiCoKiCoJiBeC_xHqqkZx_
	if (m_mmapSessionToNode != NULL)
	//----- _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiImKjChF_xHqqkZx_->_xZkqqHx_iDiJiDhIiDiLiBeFjHjKjHpAiNkMiNnNiDgOiDgCiDfGiDiFiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiImKjChF_xHqqkZx_->_xZkqqHx_iDiJiDhIiDiLiBeFjHjKjHpAiNkMiNnNiDgOiDgCiDfGiDiFiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
		delete m_mmapSessionToNode;
		m_mmapSessionToNode = NULL;
	}

//----- 06.02.06 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iNfIjAfGiDeKiDeFiDjDiDfOiCpAjAnNjCoIiBeC_xHqqkZx_
//	m_guidTerminateTable = readLock.GetLockedTableGuid();
//	m_dwTerminateLastDeleteIdentifier = readLock.GetLockDeleteIdentifier();
//	m_dwTerminateLastAppendIdentifier = readLock.GetLockAppendIdentifier();
//----- 06.02.06 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	//----- _xZkqqHx_iNfIjAfGiDeKiDeFiDjDiDfOiCpAjAnNjCoI_xHqqkZx_ -----
	m_guidTerminateTable = cmdTermFile.GetTableGuid();
	m_dwTerminateLastEndIndex = cmdTermFile.GetRecordCount();
	if (m_dwTerminateLastEndIndex != 0)
		m_dwTerminateLastAppendIdentifier = cmdTermFile.GetRecordAppendIdentifier(m_dwTerminateLastEndIndex - 1);
	else
		m_dwTerminateLastAppendIdentifier = DWORD(-1);
//----- 06.02.06 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//----- 06.01.30 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCHTreeRec::LoadTerminateFile.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::LoadForkFile
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCpAjDmHiCnNiNjOiCnNiBeBjFmPjAjEiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	_xZkqqHx_iImIiJlKiCmMjFmPjAjEiCkKiNfIjAfGiClDiCoKiCoJiBeC_xHqqkZx_
 *			m_fliFromSessionIndex	_xZkqqHx_iPoDiImKjHjKjHpAiCmMiBeBiClBiCmMjHjKjHpAiCkKiCmCiCmIiCkKiCoJiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_ 
 *			m_vSubTreeDocId			_xZkqqHx_iDfEiDhFiCmMjHjKjHpAjFlGiPjBiDiKiDfIiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_jHjKjHpAiPeJjCfLiDgFiBfLiDhFiDiLiCmNiBeBjDmHiCnNiNjOiCnNiDiNiDgCiDeOiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iMoDiCmFiBeBjBfDiCmEiDiNiDgCiDeOiCpAiJpAjFpKiClHiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.01.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHTreeRec::LoadForkFile (const FCDbReadLock& readLock)
{
//----- 06.01.30 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// CheckForkUpdated_xZkqqHx_iKnGjAjEiCpAiMmEiCpBiClOiMoDiCmJiOmAiNhDiClDiCoKiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
//	if (!m_autoLockForkRead.IsLocked())
//		FFThrowMiscUnknown();
//
//	//----- _xZkqqHx_jFkKiKpCjAoGiCmMjHjKjHpAiCpAjAnNjCoI_xHqqkZx_ -----
//	FCHiForkTable forkFile;
//	forkFile.Set(m_autoLockForkRead.GetTableName());
//	forkFile.UpdateData(m_autoLockForkRead);
//	forkFile.GetSuperInfo(&m_fliFirstSessionIndex, NULL);
//	//----- _xZkqqHx_iDfEiDhFiCmMjHjKjHpAjFlGiPjBiDiKiDfIiDgHiCpAiOoGjDlOiBjFjAnNjCoI_xHqqkZx_ -----
//	// _xZkqqHx_iDfEiDhFiCmMjHjKjHpAjFlGiPjBiDiKiDfIiDgHiBeC_xHqqkZx_
//	m_vSubTreeDocId.clear();
//	forkFile.GetSortedDocumentId(m_vSubTreeDocId);
//
//	//----- _xZkqqHx_iDfEiDhFiCmMjHjKjHpAjFkKiKpCiDfOiDePiDiKiDfIiDgHiCpAiOoGjDlOiBjFjAnNjCoI_xHqqkZx_ -----
//	m_vHiForkTagRecAuto.clear();
//
//	FCHiForkTagConstIterator iHtcm;
//	for (iHtcm = forkFile.GetFirstHiForkTag(); !iHtcm.IsEnd(); iHtcm++)
//	{
//		// _xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiDiKiDfIiDgHiCmJjCmHiJmBiBeC_xHqqkZx_
//		m_vHiForkTagRecAuto.push_back(
//					FCHiForkTagRecAuto(new FCHiForkTagRec(	this,
//															iHtcm.GetSessionIndex(),
//															iHtcm.GetUserId(),
//															iHtcm.GetCreateTime(),
//															iHtcm.GetTitle(),
//															iHtcm.GetComment(),
//															iHtcm.GetHtreeScore())));
//	}
//
//	//----- _xZkqqHx_iDfEiDhFiCmMiOjOiKnEiDiJiDhIiDiLiDiKiDfIiDgHiCpAiOoGjDlOiBjFjAnNjCoI_xHqqkZx_ -----
//	m_vTimeLabelRecAuto.clear();
//
//	FCTimeLabelConstIterator iTml;
//	for (iTml = forkFile.GetFirstTimeLabel(); !iTml.IsEnd(); iTml++)
//	{
//		// _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiDiKiDfIiDgHiCmJjCmHiJmBiBeC_xHqqkZx_
//		m_vTimeLabelRecAuto.push_back(
//					FCTimeLabelRecAuto(new FCTimeLabelRec(	iTml.GetSessionIndex(),
//															iTml.GetTimeLabelId(),
//															iTml.GetUserId(),
//															iTml.GetCreateTime(),
//															iTml.GetLabelText())));
//	}
//
//	if (m_mmapSessionToNode != NULL)
//	//----- _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiImKjChF_xHqqkZx_->_xZkqqHx_iDiJiDhIiDiLiBeFjHjKjHpAiNkMiNnNiDgOiDgCiDfGiDiFiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiImKjChF_xHqqkZx_->_xZkqqHx_iDiJiDhIiDiLiBeFjHjKjHpAiNkMiNnNiDgOiDgCiDfGiDiFiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
//		delete m_mmapSessionToNode;
//		m_mmapSessionToNode = NULL;
//	}
//
//	// _xZkqqHx_iNfIjAfGiDeKiDeFiDjDiDfOiCpAjAnNjCoIiBeC_xHqqkZx_
//	m_dwForkLastDeleteIdentifier = m_autoLockForkRead.GetLockDeleteIdentifier();
//	m_dwForkLastAppendIdentifier = m_autoLockForkRead.GetLockAppendIdentifier();
//----- 06.01.30 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----

	//----- _xZkqqHx_jFkKiKpCjAoGiCmMjHjKjHpAiCpAjAnNjCoI_xHqqkZx_ -----
	FCHiForkTable forkFile;
	forkFile.Set(readLock.GetTableName());
	forkFile.UpdateData(readLock);
	forkFile.GetSuperInfo(&m_fliFirstSessionIndex, NULL);
	//----- _xZkqqHx_iDfEiDhFiCmMjHjKjHpAjFlGiPjBiDiKiDfIiDgHiCpAiOoGjDlOiBjFjAnNjCoI_xHqqkZx_ -----
	// _xZkqqHx_iDfEiDhFiCmMjHjKjHpAjFlGiPjBiDiKiDfIiDgHiBeC_xHqqkZx_
	m_vSubTreeDocId.clear();
	forkFile.GetSortedDocumentId(m_vSubTreeDocId);

	//----- _xZkqqHx_iDfEiDhFiCmMjHjKjHpAjFkKiKpCiDfOiDePiDiKiDfIiDgHiCpAiOoGjDlOiBjFjAnNjCoI_xHqqkZx_ -----
	m_vHiForkTagRecAuto.clear();

	FCHiForkTagConstIterator iHtcm;
	for (iHtcm = forkFile.GetFirstHiForkTag(); !iHtcm.IsEnd(); iHtcm++)
	{
		// _xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiDiKiDfIiDgHiCmJjCmHiJmBiBeC_xHqqkZx_
		m_vHiForkTagRecAuto.push_back(
					FCHiForkTagRecAuto(new FCHiForkTagRec(	this,
															iHtcm.GetSessionIndex(),
															iHtcm.GetUserId(),
															iHtcm.GetCreateTime(),
															iHtcm.GetTitle(),
															iHtcm.GetComment(),
															iHtcm.GetHtreeScore())));
	}

	//----- _xZkqqHx_iDfEiDhFiCmMiOjOiKnEiDiJiDhIiDiLiDiKiDfIiDgHiCpAiOoGjDlOiBjFjAnNjCoI_xHqqkZx_ -----
	m_vTimeLabelRecAuto.clear();

	FCTimeLabelConstIterator iTml;
	for (iTml = forkFile.GetFirstTimeLabel(); !iTml.IsEnd(); iTml++)
	{
		// _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiDiKiDfIiDgHiCmJjCmHiJmBiBeC_xHqqkZx_
		m_vTimeLabelRecAuto.push_back(
					FCTimeLabelRecAuto(new FCTimeLabelRec(	iTml.GetSessionIndex(),
															iTml.GetTimeLabelId(),
															iTml.GetUserId(),
															iTml.GetCreateTime(),
															iTml.GetLabelText())));
	}

	if (m_mmapSessionToNode != NULL)
	//----- _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiImKjChF_xHqqkZx_->_xZkqqHx_iDiJiDhIiDiLiBeFjHjKjHpAiNkMiNnNiDgOiDgCiDfGiDiFiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiImKjChF_xHqqkZx_->_xZkqqHx_iDiJiDhIiDiLiBeFjHjKjHpAiNkMiNnNiDgOiDgCiDfGiDiFiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
		delete m_mmapSessionToNode;
		m_mmapSessionToNode = NULL;
	}

//----- 06.02.06 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iNfIjAfGiDeKiDeFiDjDiDfOiCpAjAnNjCoIiBeC_xHqqkZx_
//	m_guidForkTable = readLock.GetLockedTableGuid();
//	m_dwForkLastDeleteIdentifier = readLock.GetLockDeleteIdentifier();
//	m_dwForkLastAppendIdentifier = readLock.GetLockAppendIdentifier();
//----- 06.02.06 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	//----- _xZkqqHx_iNfIjAfGiDeKiDeFiDjDiDfOiCpAjAnNjCoI_xHqqkZx_ -----
	m_guidForkTable = forkFile.GetTableGuid();
	m_dwForkLastEndIndex = forkFile.GetRecordCount();
	if (m_dwForkLastEndIndex != 0)
		m_dwForkLastAppendIdentifier = forkFile.GetRecordAppendIdentifier(m_dwForkLastEndIndex - 1);
	else
		m_dwForkLastAppendIdentifier = DWORD(-1);
//----- 06.02.06 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//----- 06.01.30 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCHTreeRec::LoadForkFile.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::GetSubTreeDocId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMjHjKjHpAjGnIiImIiJlKiBgJiClBiCmMjHjKjHpAjGnIiCpAiKnMiCnOiBgKiCmMiBeBjBfDiCmEiCmMjHjKjHpAjGnIiCmMjHjKjHpAjFlGiPjB_xHqqkZx_ID
 *			_xZkqqHx_iCmMiPfHiNiHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vDocId	:_xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCmMiPfHiNiHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	vDocId_xZkqqHx_iCmNiPiJiKpKiJlLiClDiCoKiCmIiCkCiClBiCmGiCmJjCiNiInDiBeCiMmEiCnEjBePiCmJiLpDiCmJiClFiCmEiCkIiCkNiClBiCmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.04.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHTreeRec::GetSubTreeDocId (longVector& vDocId)
{
	// _xZkqqHx_iClBiCmMjHjKjHpAjGnIiCmMjHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAjAnNjCoIiBeCjGnIiCmMiKeLjBhHiCmFiPlIiPiHiBgJiPoDiCkJiCoHiPiHiBgKiCmJ_xHqqkZx_
	// _xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAjAmPiCnOiClNiCnPiCmJiBeBiNmFiPiJiCmJjBhNjDpMiClHiCoJiBeC_xHqqkZx_
	vDocId.push_back(GetDocumentId());
	longVector::const_iterator iR;
	for (iR = GetSubTreeDocIdVector().begin(); iR != GetSubTreeDocIdVector().end(); iR++)
	{
		FCHTreeRec* pRec = GetHTreeManager()->DocumentIdToHTreeRec(*iR);
		if (pRec == NULL) continue;
		// _xZkqqHx_iNmEiLeBjDeJiCmJiOmAiNhDiClHiCoJiBeC_xHqqkZx_
		pRec->GetSubTreeDocId(vDocId);
	}
} // FCHTreeRec::GetSubTreeDocId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::GetSessionToNodeMmap
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMmCjFmKjHjKjHpAiOhNiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIjFfMiOkGiDiMiDeDiDeBiDeFiDgHjHhAiDfKiDgCiDfGiDiHiDjDiImKjChF_xHqqkZx_->
 *			_xZkqqHx_iDiJiDhIiDiLiBeFjHjKjHpAiNkMiNnNiDgOiDgCiDfGiDiF_xHqqkZx_ _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMmCjFmKjHjKjHpAiOhNiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIjFfMiOkGiDiMiDeDiDeBiDeFiDgHjHhAiDfKiDgCiDfGiDiHiDjDiImKjChF_xHqqkZx_->
 *			_xZkqqHx_iDiJiDhIiDiLiBeFjHjKjHpAiNkMiNnNiDgOiDgCiDfGiDiF_xHqqkZx_ 
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.01.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const FTSessionToNodeMmap& FCHTreeRec::GetSessionToNodeMmap ()
{
	return GetSessionToNodeMmapW();
} // FCHTreeRec::GetSessionToNodeMmap.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::GetSessionIndexLength
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCmMjClHiClDiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCmMjClHiClDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
flint FCHTreeRec::GetSessionIndexLength ()
{
	return (GetEndSessionIndex() - GetFirstSessionIndex());
} // FCHTreeRec::GetSessionIndexLength.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::GetDocumentTitle
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFlGiPjBjGlMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFlGiPjBjGlMjFlGiOjKjHpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.01.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FCHTreeRec::GetDocumentTitle ()
{
	return GetHTreeManager()->GetDocRecExtData(GetDocumentId())->GetDocTitle();
} // FCHTreeRec::GetDocumentTitle.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::GetVersionString
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgPiBfLiDfHiDiHiDjDiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgPiBfLiDfHiDiHiDjDjFlGiOjKjHpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.01.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FCHTreeRec::GetVersionString ()
{
	return GetHTreeManager()->GetDocRecExtData(GetDocumentId())->GetVersion();
} // FCHTreeRec::GetVersionString.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::GetCreationDate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjFlGiPjBiCmMiNoMjAkMiOjOiKnEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjFlGiPjBiCmMiNoMjAkMiOjOiKnEiBeC_xHqqkZx_1601_xZkqqHx_jEeO_xHqqkZx_1_xZkqqHx_iMiO_xHqqkZx_1_xZkqqHx_jDpKiCkJiCoHiCmMjFgCjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.05.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FDSECTIME FCHTreeRec::GetCreationDate ()
{
	return GetHTreeManager()->GetDocRecExtData(GetDocumentId())->GetDate();
} // FCHTreeRec::GetCreationDate.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::GetUserName
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjFlGiPjBiCmMiNoMjAkMiOnCiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjFlGiPjBiCmMiNoMjAkMiOnCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FCHTreeRec::GetUserName ()
{
	return GetHTreeManager()->UserIdToUserName(
				GetHTreeManager()->GetDocRecExtData(GetDocumentId())->GetUserId());
} // FCHTreeRec::GetUserName.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::GetComment
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjFlGiPjBiCmMiDfCiDiBiDjDiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjFlGiPjBiCmMiDfCiDiBiDjDiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.05.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FCHTreeRec::GetComment ()
{
	return GetHTreeManager()->GetDocRecExtData(GetDocumentId())->GetComment();
} // FCHTreeRec::GetComment.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::GetFirstSessionIndex
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCmMiPiJiKpKjCgMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCmMiPiJiKpKjCgMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.01.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
// 05.11.18 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//flint FCHTreeRec::GetFirstSessionIndex ()
flint FCHTreeRec::GetFirstSessionIndex () const
{
//----- 05.11.18 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_jHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCkKiNfIjAfGiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNjDmHiCnNiNjOiCnNiBeC_xHqqkZx_
//	if (IsForkUpdated()) LoadForkFile();
//----- 05.11.18 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	return m_fliFirstSessionIndex;
} // FCHTreeRec::GetFirstSessionIndex.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::GetEndSessionIndex
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCmMiPeJjCfLjCgMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCmMiPeJjCfLjCgMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.01.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
// 05.11.18 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//flint FCHTreeRec::GetEndSessionIndex ()
flint FCHTreeRec::GetEndSessionIndex () const
{
//----- 05.11.18 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_jHjKjHpAiPeJjCfLiDgFiBfLiDhFiDiLiCkKiNfIjAfGiClDiCoKiCmEiCkCiCoJiCmIiCoHjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
//	if (IsTerminateUpdated()) LoadTerminateFile();
//----- 05.11.18 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	return m_fliEndSessionIndex;
} // FCHTreeRec::GetEndSessionIndex.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::GetTimeRecVector
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAoCjBmOiOjOiKnEiDiMiDfCiBfLiDgIiCmMjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAoCjBmOiOjOiKnEiDiMiDfCiBfLiDgIiCmMjEhKjHpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.01.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const HTRTimeRecVector& FCHTreeRec::GetTimeRecVector ()
{
	return GetTimeRecVectorW();
} // FCHTreeRec::GetTimeRecVector.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::GetLife
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjApMiCmMjClHiClDiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjApMiCmMjClHiClDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.01.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCHTreeRec::GetLife () const
{
// 06.02.06 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	ASSERT(!IsTerminateUpdated());
	return m_lLife;
} // FCHTreeRec::GetLife.

//----- 04.06.18 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::SetBoxPoint
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFfMiOkGiDhLiDgCiDeOiDfIiCmMiKoOiPiAjDfPiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pt	:_xZkqqHx_jFfMiOkGiDhLiDgCiDeOiDfIiCmMiKoOiPiAjDfPiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.01.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCHTreeRec::SetBoxPoint (const CPoint& pt)
//{
//	m_ptBox = pt;
//} // FCHTreeRec::SetBoxPoint.
//----- 04.06.18 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::GetBoxPoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFfMiOkGiDhLiDgCiDeOiDfIiCmMiKoOiPiAjDfPiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFfMiOkGiDhLiDgCiDeOiDfIiCmMiKoOiPiAjDfPiNmAjFfHiBeC_xHqqkZx_
 *
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	m_ptBox _xZkqqHx_iCmNiBeBiImIiJlKiBeC_xHqqkZx_
 *
 *      _xZkqqHx_iEkKiEkKiEkKiEkKiEkKiEkKiEkN_xHqqkZx_
 *                  _xZkqqHx_iEkL_xHqqkZx_
 *                  _xZkqqHx_iEkL_xHqqkZx_
 *                  _xZkqqHx_iEkL_xHqqkZx_
 *          _xZkqqHx_iEkMiEkKiEkKiEkKiElDiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkN_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_      _xZkqqHx_iBkK_xHqqkZx_              _xZkqqHx_iEkL_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_     m_ptBox          _xZkqqHx_iEkL_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_                      _xZkqqHx_iEkL_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_                      _xZkqqHx_iEkL_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_                      _xZkqqHx_iEkL_xHqqkZx_
 *          _xZkqqHx_iEkPiEkKiEkKiEkN_xHqqkZx_  _xZkqqHx_iEkMiEkKiEkKiEkKiEkKiEkKiEkKiEkO_xHqqkZx_
 *                _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_
 *                _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_
 *                _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_
 *                _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_
 *              _xZkqqHx_iEkMiEkO_xHqqkZx_  _xZkqqHx_iEkPiEkN_xHqqkZx_
 *               _xZkqqHx_iBfP_xHqqkZx_    _xZkqqHx_iBfO_xHqqkZx_
 *                 _xZkqqHx_iBfPiBfO_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.01.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CPoint FCHTreeRec::GetBoxPoint () const
{
	return m_ptBox;
} // FCHTreeRec::GetBoxPoint.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::GetLifeArrowRect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjApMiCmMjAoGjCfLiCmMjGoOiIpDiCmJiKePjAnKiClHiCoJiLoJiMgAiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iKePjAnKiLoJiMgAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iJlKjAhNiCmMiLoJiMgAiCpAjFnEiClHiBeC_xHqqkZx_
 *
 *                  _xZkqqHx_iEkL_xHqqkZx_      _xZkqqHx_iEkL_xHqqkZx_
 *              _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_      _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_
 *              _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_      _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_
 *          _xZkqqHx_iBgDiBgDiEkMiEkKiEkOiBgDiBgDiBgDiEkPiEkKiEkNiBgDiBgD_xHqqkZx_
 *               _xZkqqHx_iBfP_xHqqkZx_            _xZkqqHx_iBfO_xHqqkZx_ 
 *              _xZkqqHx_iBeG_xHqqkZx_ _xZkqqHx_iBfP_xHqqkZx_        _xZkqqHx_iBfO_xHqqkZx_ _xZkqqHx_iBeG_xHqqkZx_
 *              _xZkqqHx_iBeG_xHqqkZx_   _xZkqqHx_iBfP_xHqqkZx_    _xZkqqHx_iBfO_xHqqkZx_   _xZkqqHx_iBeG_xHqqkZx_
 *              _xZkqqHx_iBeG_xHqqkZx_     _xZkqqHx_iBfPiBfO_xHqqkZx_     _xZkqqHx_iBeG_xHqqkZx_
 *          _xZkqqHx_iBgDiBgDiEkJiBgDiBgDiBgDiBgDiBgDiBgDiBgDiEkJiBgDiBgD_xHqqkZx_
 *              _xZkqqHx_iBeG_xHqqkZx_              _xZkqqHx_iBeG_xHqqkZx_
 *              _xZkqqHx_iBeG_xHqqkZx_              _xZkqqHx_iBeG_xHqqkZx_
 *
 *           _xZkqqHx_iKePjAnKiLoJiMgAiCmNiBeBiImIiJlKiCmMjCoIjAjEiCkJiCoHiMhGiOfKiClDiCoKiCoJiBeC_xHqqkZx_
 *
 *              GetHTreeManager()->GetHtArwWidthH()
 *              _xZkqqHx_iEkFiBkJiEjPiBkIiEkH_xHqqkZx_
 *              _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *              _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_
 *              _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_
 *              _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_      _xZkqqHx_iEkL_xHqqkZx_
 *              _xZkqqHx_iEkMiEkKiEkO_xHqqkZx_      _xZkqqHx_iEkPiEkKiEkNiEjPiEjPiEkG_xHqqkZx_
 *               _xZkqqHx_iBfP_xHqqkZx_            _xZkqqHx_iBfO_xHqqkZx_     _xZkqqHx_iBkK_xHqqkZx_
 *                 _xZkqqHx_iBfP_xHqqkZx_        _xZkqqHx_iBfO_xHqqkZx_       _xZkqqHx_iEkA_xHqqkZx_GetHTreeManager()->GetHtArwHeight()
 *                   _xZkqqHx_iBfP_xHqqkZx_    _xZkqqHx_iBfO_xHqqkZx_         _xZkqqHx_iEkA_xHqqkZx_
 *                     _xZkqqHx_iBfPiBfO_xHqqkZx_           _xZkqqHx_iBkL_xHqqkZx_
 *                        _xZkqqHx_iBfAiBfAiBfAiBfAiBfAiBfAiBfA_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CRect FCHTreeRec::GetLifeArrowRect () const
{
	const CRect rtLife = GetLifeLineRect();
	const long lCenterX = (rtLife.left + rtLife.right) / 2;
	return CRect(lCenterX - GetHTreeManager()->GetHtArwWidthH(),
				 rtLife.bottom,
				 lCenterX + GetHTreeManager()->GetHtArwWidthH(),
				 rtLife.bottom + GetHTreeManager()->GetHtArwHeight());
} // FCHTreeRec::GetLifeArrowRect.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::GetLifeLineRect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjApMiBgJjAoGjCfLiCmMjGoOiIpDiCpAiPjMiCkNiBgKiCmJiKePjAnKiClHiCoJiLoJiMgAiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iKePjAnKiLoJiMgAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iJlKjAhNiCmMiLoJiMgAiCpAjFnEiClHiBeC_xHqqkZx_
 *
 *                      _xZkqqHx_iEkL_xHqqkZx_
 *            _xZkqqHx_iEkMiEkKiEkKiEkKiEkKiElDiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkN_xHqqkZx_
 *            _xZkqqHx_iEkL_xHqqkZx_                          _xZkqqHx_iEkL_xHqqkZx_
 *            _xZkqqHx_iEkL_xHqqkZx_                          _xZkqqHx_iEkL_xHqqkZx_
 *            _xZkqqHx_iEkL_xHqqkZx_                          _xZkqqHx_iEkL_xHqqkZx_
 *            _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iBeG_xHqqkZx_      _xZkqqHx_iBeG_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_
 *            _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iBeG_xHqqkZx_      _xZkqqHx_iBeG_xHqqkZx_            _xZkqqHx_iEkL_xHqqkZx_
 *            _xZkqqHx_iEkPiEkKiBgDiEkJiBgDiBgDiBgDiEkJiBgDiEkKiEkKiEkKiEkKiEkKiEkO_xHqqkZx_
 *                  _xZkqqHx_iBeG_xHqqkZx_      _xZkqqHx_iBeG_xHqqkZx_
 *                  _xZkqqHx_iEkL_xHqqkZx_      _xZkqqHx_iEkL_xHqqkZx_
 *                  _xZkqqHx_iEkL_xHqqkZx_      _xZkqqHx_iEkL_xHqqkZx_
 *                  _xZkqqHx_iEkL_xHqqkZx_      _xZkqqHx_iEkL_xHqqkZx_
 *                  _xZkqqHx_iEkL_xHqqkZx_      _xZkqqHx_iEkL_xHqqkZx_
 *                  _xZkqqHx_iEkL_xHqqkZx_      _xZkqqHx_iEkL_xHqqkZx_
 *                  _xZkqqHx_iEkL_xHqqkZx_      _xZkqqHx_iEkL_xHqqkZx_
 *                  _xZkqqHx_iEkL_xHqqkZx_      _xZkqqHx_iEkL_xHqqkZx_
 *                  _xZkqqHx_iEkL_xHqqkZx_      _xZkqqHx_iEkL_xHqqkZx_
 *                  _xZkqqHx_iEkL_xHqqkZx_      _xZkqqHx_iEkL_xHqqkZx_
 *                  _xZkqqHx_iEkL_xHqqkZx_      _xZkqqHx_iEkL_xHqqkZx_
 *                  _xZkqqHx_iEkL_xHqqkZx_      _xZkqqHx_iEkL_xHqqkZx_
 *                  _xZkqqHx_iEkL_xHqqkZx_      _xZkqqHx_iEkL_xHqqkZx_
 *                  _xZkqqHx_iBeG_xHqqkZx_      _xZkqqHx_iBeG_xHqqkZx_
 *              _xZkqqHx_iEkMiBgDiEkOiBgDiBgDiBgDiEkPiBgDiEkN_xHqqkZx_
 *               _xZkqqHx_iBfP_xHqqkZx_ _xZkqqHx_iBeG_xHqqkZx_      _xZkqqHx_iBeG_xHqqkZx_ _xZkqqHx_iBfO_xHqqkZx_
 *                  _xZkqqHx_iBeG_xHqqkZx_      _xZkqqHx_iBeG_xHqqkZx_
 *
 *
 *           _xZkqqHx_iKePjAnKiLoJiMgAiCmNiBeBiImIiJlKiCmMjCoIjAjEiCkJiCoHiMhGiOfKiClDiCoKiCoJiBeC_xHqqkZx_
 *
 *              GetHTreeManager()->GetHtLifeWidthH()
 *                _xZkqqHx_iBkIiEkJiEjPiEkJiBkJ_xHqqkZx_
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *                      _xZkqqHx_iEkA_xHqqkZx_
 *                  _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_
 *                  _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_
 *                  _xZkqqHx_iEkL_xHqqkZx_      _xZkqqHx_iEkL_xHqqkZx_
 *
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CRect FCHTreeRec::GetLifeLineRect () const
{
	return CRect(GetBoxPoint().x - GetHTreeManager()->GetHtLifeWidthH(),
				 GetBoxPoint().y + m_pHTreeMng->GetHistBoxSize().cy,
				 GetBoxPoint().x + GetHTreeManager()->GetHtLifeWidthH(),
				 GetBoxPoint().y + m_pHTreeMng->GetHistBoxSize().cy + GetLife());
} // FCHTreeRec::GetLifeLineRect.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::GetNodeBoxRect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjFfMiOkGiDhLiDgCiDeOiDfIiCmMiLoJiMgAiCpAiMhGiOfKiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjFfMiOkGiDhLiDgCiDeOiDfIiCmMiLoJiMgAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CRect FCHTreeRec::GetNodeBoxRect () const
{
	return CRect(GetBoxPoint().x - GetHTreeManager()->GetHtBoxWidthL(),
				 GetBoxPoint().y,
				 GetBoxPoint().x + m_pHTreeMng->GetHistBoxSize().cx - GetHTreeManager()->GetHtBoxWidthL(),
				 GetBoxPoint().y + m_pHTreeMng->GetHistBoxSize().cy);
} // FCHTreeRec::GetNodeBoxRect.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::SessionIndexToYTree
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCkJiCoHiChIiNmAjFfHiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fliSessionIndex	:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iChIiNmAjFfHjCgMiBeCiIpIjAjEiCmFiOhHjCoIiClDiCoKiClNiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCkKiPoDiMmAiCpAjClEiCkGiCoJ_xHqqkZx_
 *			_xZkqqHx_iPoKiNiHiCmNiPoDiMmAjCgMiBeBiJlKiMmAiCpAjClEiCkGiCoJiPoKiNiHiCmNiJlKiMmAjCgMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jHjKjHpAjGnIiNfMjBkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCmFiLeAjEfMiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiImKjChFiCmNiBeBiChIiNmAjFfHiCmJjBmOiClFiCmEjApMiMgAiCmFiCmNiCmIiCkNiBeBjFjEjFkKjFjEjFkKiCmFjEoEjHkGiCkK_xHqqkZx_
 *			_xZkqqHx_iInJiCmIiCoJiBeC_xHqqkZx_
 *
 *                  _xZkqqHx_iEkL_xHqqkZx_
 *                  _xZkqqHx_iEkL_xHqqkZx_
 *                  _xZkqqHx_iEkL_xHqqkZx_
 *                  _xZkqqHx_iEkL_xHqqkZx_
 *          _xZkqqHx_iEkMiEkKiEkKiEkKiElDiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkN_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_                      _xZkqqHx_iEkL_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_                      _xZkqqHx_iEkL_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_                      _xZkqqHx_iEkL_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_                      _xZkqqHx_iEkL_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_                      _xZkqqHx_iEkL_xHqqkZx_
 *          _xZkqqHx_iEkPiEkKiEkKiEkN_xHqqkZx_  _xZkqqHx_iEkMiEkKiEkKiEkKiEkKiEkKiEkKiEkO_xHqqkZx_
 *                _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_
 *                _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_
 *                _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iElAiEkKiEkKiEkKiEkKiEkKiEkN_xHqqkZx_  _xZkqqHx_iEjPiEjPiEkGiEjP_xHqqkZx_ _xZkqqHx_iCgA_xHqqkZx_
 *                _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_          _xZkqqHx_iEkL_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *                _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_          _xZkqqHx_iEkL_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *                _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_          _xZkqqHx_iBeG_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *                _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_                  _xZkqqHx_iEkA_xHqqkZx_
 *                _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_                  _xZkqqHx_iEkA_xHqqkZx_
 *                _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_                  _xZkqqHx_iEkA_xHqqkZx_
 *                _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkLiBkJiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkJiEjP_xHqqkZx_ _xZkqqHx_iCgK_xHqqkZx_i
 *                _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_                  _xZkqqHx_iEkA_xHqqkZx_
 *                _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_                  _xZkqqHx_iEkA_xHqqkZx_
 *                _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_                  _xZkqqHx_iEkA_xHqqkZx_
 *                _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_                  _xZkqqHx_iEkA_xHqqkZx_
 *                _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iElAiEkKiEkKiEkKiEkKiEkKiEkN_xHqqkZx_  _xZkqqHx_iEjPiEjPiEkIiEjP_xHqqkZx_ _xZkqqHx_iCgB_xHqqkZx_
 *                _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_          _xZkqqHx_iEkL_xHqqkZx_
 *                _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_          _xZkqqHx_iEkL_xHqqkZx_
 *                _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_          _xZkqqHx_iBeG_xHqqkZx_
 *              _xZkqqHx_iEkMiEkO_xHqqkZx_  _xZkqqHx_iEkPiEkN_xHqqkZx_
 *               _xZkqqHx_iBfP_xHqqkZx_    _xZkqqHx_iBfO_xHqqkZx_
 *                 _xZkqqHx_iBfPiBfO_xHqqkZx_
 *
 *			_xZkqqHx_jHoBiCkGiCmOiBeBiCgAiCmGiCgBiCmMiKnEiCmMiDfKiDgCiDfGiDiHiDjDiImKjChFiBgJiCgK_xHqqkZx_i_xZkqqHx_iBgKiCpAjClCiCnHiCoGiCkEiCmGiClHiCoJiPoKiNiHiBeB_xHqqkZx_
 *			_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCgB_xHqqkZx_i_xZkqqHx_iCmGiCgK_xHqqkZx_i_xZkqqHx_iBeBiCgA_xHqqkZx_i_xZkqqHx_iCmGiCgK_xHqqkZx_i_xZkqqHx_iCmMjEoEjHkGiCkJiCoHiBeBiChIiNmAjFfHiCgB_xHqqkZx_y_xZkqqHx_iCmGiCgK_xHqqkZx_y_xZkqqHx_iBeB_xHqqkZx_
 *			_xZkqqHx_iCgA_xHqqkZx_y_xZkqqHx_iCmGiCgK_xHqqkZx_y_xZkqqHx_iCmMiKnGiMfHiCpAiMlDiCmJiCgK_xHqqkZx_i_xZkqqHx_iCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.07.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCHTreeRec::SessionIndexToYTree (flint fliSessionIndex)
{
	// _xZkqqHx_jHjKjHpAjGnIiNfMjBkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
	ASSERT(GetHTreeManager()->GetViewMode() == FDHT_VMODE_TREE);
	const CRect rtLifeLine = GetLifeLineRect();
	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCkKiCmNiCnNiPgPiClFiCmEiCkCiCoJiPoKiNiHiCmNiPoDiMmAiBeFiJlKiMmAiCpAjFnEiClHiBeC_xHqqkZx_
	if (fliSessionIndex < GetFirstSessionIndex()) return rtLifeLine.top;
	if (GetEndSessionIndex() < fliSessionIndex) return rtLifeLine.bottom;

	long lY;
	flint fliBi = GetFirstSessionIndex();
	long lBy = rtLifeLine.top;
	longVector::const_iterator iR = GetSubTreeDocIdVector().begin();
	for (;;)
	{
		flint fliAi = fliBi;
		long lAy = lBy;

		// Ai,Bi,Ay,By_xZkqqHx_iCpAiOfKiPgPiBeC_xHqqkZx_
		if (iR != GetSubTreeDocIdVector().end())
		{
			FCHTreeRec* pRec = GetHTreeManager()->DocumentIdToHTreeRec(*iR);
			if (pRec == NULL) continue;
			fliBi = pRec->GetFirstSessionIndex();
			lBy = pRec->GetRootPoint().y;
		} else
		{
			fliBi = GetEndSessionIndex();
			lBy = rtLifeLine.bottom;
		}

		if (fliSessionIndex <= fliBi)
		{
			if (fliBi != fliAi)
				lY = D2L((double(fliSessionIndex - fliAi) / double(fliBi - fliAi)) * double(lBy - lAy)) + lAy;
			else
				lY = lBy;
			break;
		}
		ASSERT(iR != GetSubTreeDocIdVector().end());
		iR++;
	}
	return lY;
} // FCHTreeRec::SessionIndexToYTree.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::YToSessionIndexTree
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iChIiNmAjFfHiCkJiCoHiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lY	:_xZkqqHx_iChIiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIjCgMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jHjKjHpAjGnIiNfMjBkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCmFiLeAjEfMiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiImKjChFiCmNiBeBiChIiNmAjFfHiCmJjBmOiClFiCmEjApMiMgAiCmFiCmNiCmIiCkNiBeBjFjEjFkKjFjEjFkKiCmFjEoEjHkGiCkK_xHqqkZx_
 *			_xZkqqHx_iInJiCmIiCoJiBeC_xHqqkZx_
 *
 *                  _xZkqqHx_iEkL_xHqqkZx_
 *                  _xZkqqHx_iEkL_xHqqkZx_
 *                  _xZkqqHx_iEkL_xHqqkZx_
 *          _xZkqqHx_iEkMiEkKiEkKiEkKiElDiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkN_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_                      _xZkqqHx_iEkL_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_                      _xZkqqHx_iEkL_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_                      _xZkqqHx_iEkL_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_                      _xZkqqHx_iEkL_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_                      _xZkqqHx_iEkL_xHqqkZx_
 *          _xZkqqHx_iEkPiEkKiEkKiEkN_xHqqkZx_  _xZkqqHx_iEkMiEkKiEkKiEkKiEkKiEkKiEkKiEkO_xHqqkZx_
 *                _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_
 *                _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_
 *                _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iElAiEkKiEkKiEkKiEkKiEkKiEkN_xHqqkZx_  _xZkqqHx_iEjPiEjPiEkGiEjP_xHqqkZx_ _xZkqqHx_iCgA_xHqqkZx_
 *                _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_          _xZkqqHx_iEkL_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *                _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_          _xZkqqHx_iEkL_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *                _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_          _xZkqqHx_iBeG_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *                _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_                  _xZkqqHx_iEkA_xHqqkZx_
 *                _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_                  _xZkqqHx_iEkA_xHqqkZx_
 *                _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_                  _xZkqqHx_iEkA_xHqqkZx_
 *                _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkLiBkJiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkJiEjP_xHqqkZx_ _xZkqqHx_iCgK_xHqqkZx_y
 *                _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_                  _xZkqqHx_iEkA_xHqqkZx_
 *                _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_                  _xZkqqHx_iEkA_xHqqkZx_
 *                _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_                  _xZkqqHx_iEkA_xHqqkZx_
 *                _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_                  _xZkqqHx_iEkA_xHqqkZx_
 *                _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iElAiEkKiEkKiEkKiEkKiEkKiEkN_xHqqkZx_  _xZkqqHx_iEjPiEjPiEkIiEjP_xHqqkZx_ _xZkqqHx_iCgB_xHqqkZx_
 *                _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_          _xZkqqHx_iEkL_xHqqkZx_
 *                _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_          _xZkqqHx_iEkL_xHqqkZx_
 *                _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_          _xZkqqHx_iBeG_xHqqkZx_
 *              _xZkqqHx_iEkMiEkO_xHqqkZx_  _xZkqqHx_iEkPiEkN_xHqqkZx_
 *               _xZkqqHx_iBfP_xHqqkZx_    _xZkqqHx_iBfO_xHqqkZx_
 *                 _xZkqqHx_iBfPiBfO_xHqqkZx_
 *
 *			_xZkqqHx_jHoBiCkGiCmOiBeBiCgAiCmGiCgBiCmMiKnEiCmMiChIiNmAjFfHiBgJiCgK_xHqqkZx_y_xZkqqHx_iBgKiCpAjClCiCnHiCoGiCkEiCmGiClHiCoJiPoKiNiHiBeB_xHqqkZx_
 *			_xZkqqHx_iChIiNmAjFfHiCgB_xHqqkZx_y_xZkqqHx_iCmGiCgK_xHqqkZx_y_xZkqqHx_iBeBiCgA_xHqqkZx_y_xZkqqHx_iCmGiCgK_xHqqkZx_y_xZkqqHx_iCmMjEoEjHkGiCkJiCoHiBeBiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCgB_xHqqkZx_i_xZkqqHx_iCmGiCgK_xHqqkZx_i_xZkqqHx_iBeB_xHqqkZx_
 *			_xZkqqHx_iCgA_xHqqkZx_i_xZkqqHx_iCmGiCgK_xHqqkZx_i_xZkqqHx_iCmMiKnGiMfHiCpAiMlDiCmJiCgK_xHqqkZx_i_xZkqqHx_iCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.07.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
flint FCHTreeRec::YToSessionIndexTree (long lY)
{
	// _xZkqqHx_jHjKjHpAjGnIiNfMjBkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
	ASSERT(GetHTreeManager()->GetViewMode() == FDHT_VMODE_TREE);

	const CRect rtLifeLine = GetLifeLineRect();
	// _xZkqqHx_iChIiNmAjFfHiCkKiCmNiCnNiPgPiClFiCmEiCkCiCoJiPoKiNiHiCmNjFoCjAlDiBeC_xHqqkZx_
	if (lY < rtLifeLine.top) lY = rtLifeLine.top;
	if (rtLifeLine.bottom < lY) lY = rtLifeLine.bottom;
	flint fliKi;
	flint fliBi = GetFirstSessionIndex();
	long lBy = rtLifeLine.top;
	longVector::const_iterator iR = GetSubTreeDocIdVector().begin();
	for (;;)
	{
		flint fliAi = fliBi;
		long lAy = lBy;

		// Ai,Bi,Ay,By_xZkqqHx_iCpAiOfKiPgPiBeC_xHqqkZx_
		if (iR != GetSubTreeDocIdVector().end())
		{
			FCHTreeRec* pRec = GetHTreeManager()->DocumentIdToHTreeRec(*iR);
			if (pRec == NULL) continue;
			fliBi = pRec->GetFirstSessionIndex();
			lBy = pRec->GetRootPoint().y;
		} else
		{
			fliBi = GetEndSessionIndex();
			lBy = rtLifeLine.bottom;
		}

		if (lY <= lBy)
		{
			if (lAy != lBy)
				fliKi = D2LL((double(lY - lAy) / double(lBy - lAy)) * double(fliBi - fliAi)) + fliAi;
			else
				fliKi = fliAi;
			break;
		}
		ASSERT(iR != GetSubTreeDocIdVector().end());
		iR++;
	}
	return fliKi;
} // FCHTreeRec::YToSessionIndexTree.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::SessionIndexToYBranch
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCkJiCoHiChIiNmAjFfHiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fliSessionIndex	:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iChIiNmAjFfHjCgMiBeCiIpIjAjEiCmFiOhHjCoIiClDiCoKiClNiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCkKiPoDiMmAiCpAjClEiCkGiCoJ_xHqqkZx_
 *			_xZkqqHx_iPoKiNiHiCmNiPoDiMmAjCgMiBeBiJlKiMmAiCpAjClEiCkGiCoJiPoKiNiHiCmNiJlKiMmAjCgMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iMmCjFmKjHjKjHpAiOhNiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCmFiLeAjEfMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCHTreeRec::SessionIndexToYBranch (flint fliSessionIndex)
{
	double dRat = 1.0;
	if (GetSessionIndexLength() != 0)
		dRat = double(fliSessionIndex - GetFirstSessionIndex()) / double(GetSessionIndexLength());
	// _xZkqqHx_iPoDiMmAiCpAjClEiCkGiClNiPoKiNiHiCmNjFoCjAlDiBeC_xHqqkZx_
	if (1.0 < dRat) dRat = 1.0;
	// _xZkqqHx_jHjKjHpAjApMiCmMiLoJiMgAiCpAiOfKiPgPiBeC_xHqqkZx_
	const CRect rtLifeLine = GetLifeLineRect();
	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiImKjChFiCmMiNmAjFfHiCpAiOfKiPgPiBeC_xHqqkZx_
	return rtLifeLine.top + D2L(dRat * (double)rtLifeLine.Height());
} // FCHTreeRec::SessionIndexToYBranch.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::YToSessionIndexBranch
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iChIiNmAjFfHiCkJiCoHiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lY	:_xZkqqHx_iChIiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIjCgMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iMmCjFmKjHjKjHpAiOhNiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCmFiLeAjEfMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
flint FCHTreeRec::YToSessionIndexBranch (long lY)
{
	return D2LL((double(lY - GetLifeLineRect().top) / double(GetLife())) * GetSessionIndexLength()) +
			GetFirstSessionIndex();
} // FCHTreeRec::YToSessionIndexBranch.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::GetHiLabelRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDiJiDhIiDiLiDiMiDfCiBfLiDgI_xHqqkZx_ID_xZkqqHx_iCmMiDiJiDhIiDiLiDiMiDfCiBfLiDgIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lId	:_xZkqqHx_iDiJiDhIiDiLiDiMiDfCiBfLiDgI_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiJiDhIiDiLiDiMiDfCiBfLiDgIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.01.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const FCHiLabelRec* FCHTreeRec::GetHiLabelRec (long lId)
{
	if (lId < 0 || GetHiLabelRecVector().size() <= lId) return NULL;
	return GetHiLabelRecVector()[lId].get();
} // FCHTreeRec::GetHiLabelRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::GetHiForkTagRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMjHjKjHpAjFkKiKpCiDfOiDePiDiMiDfCiBfLiDgI_xHqqkZx_ID_xZkqqHx_iCmMjHjKjHpAjFkKiKpCiDfOiDePiDiMiDfCiBfLiDgIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lId	:_xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiDiMiDfCiBfLiDgI_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiDiMiDfCiBfLiDgIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCHiForkTagRec* FCHTreeRec::GetHiForkTagRec (long lId)
{
	if (lId < 0 || GetHiForkTagRecVector().size() <= lId) return NULL;
	return GetHiForkTagRecVector()[lId].get();
} // FCHTreeRec::GetHiForkTagRec.

//----- 05.09.14 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::GetTimeLabelRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiOjOiKnEiDiJiDhIiDiLiDiMiDfCiBfLiDgI_xHqqkZx_ID_xZkqqHx_iCmMiOjOiKnEiDiJiDhIiDiLiDiMiDfCiBfLiDgIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lId	:_xZkqqHx_iOjOiKnEiDiJiDhIiDiLiDiMiDfCiBfLiDgI_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOjOiKnEiDiJiDhIiDiLiDiMiDfCiBfLiDgIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const FCTimeLabelRec* FCHTreeRec::GetTimeLabelRec (long lId)
{
	if (lId < 0 || GetTimeLabelRecVector().size() <= lId) return NULL;
	return GetTimeLabelRecVector()[lId].get();
} // FCHTreeRec::GetTimeLabelRec.
//----- 05.09.14 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::GetTimeRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDfOiDeDiDiAiDfGiDePiDgJiDiLiDiMiDfCiBfLiDgI_xHqqkZx_ID_xZkqqHx_iCmMiDfOiDeDiDiAiDfGiDePiDgJiDiLiDiMiDfCiBfLiDgIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lId	:_xZkqqHx_iDfOiDeDiDiAiDfGiDePiDgJiDiLiDiMiDfCiBfLiDgI_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfOiDeDiDiAiDfGiDePiDgJiDiLiDiMiDfCiBfLiDgIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.05.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const HTRTimeRec* FCHTreeRec::GetTimeRec (long lId)
{
	if (lId < 0 || GetTimeRecVector().size() <= lId) return NULL;
	return &(GetTimeRecVector()[lId]);
} // FCHTreeRec::GetTimeRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::GetHintText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhMiDgCiDhGiDhBiDjDiDgHiCmJjFfMiOkGiClHiCoJiCmMiCmJjDeLjDjGiCmIiDiBiDgCiDfKiBfLiDfHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fliSessionIndex	:_xZkqqHx_iMlLiNnNiCmMiDfKiDgCiDfGiDiHiDjDiImKjChFiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.05.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FCHTreeRec::GetHintText (flint fliSessionIndex)
{
	COleDateTime otmDate = FdsecToFiletime(GetCreationDate());
	// _xZkqqHx_jHoBiBeG_xHqqkZx_2004_xZkqqHx_jEeO_xHqqkZx_8_xZkqqHx_iMiO_xHqqkZx_19_xZkqqHx_jDpK_xHqqkZx_ 0_xZkqqHx_iOjO_xHqqkZx_15_xZkqqHx_jFkK_xHqqkZx_
	// IDS_FORM_DATE_TIME_LONG = "%#Y_xZkqqHx_jEeO_xHqqkZx_%#m_xZkqqHx_iMiO_xHqqkZx_%#d %#H:%#M"
	WString wstrDate = TStrToWStr(otmDate.Format(FFLoadString(IDS_FORM_DATE_TIME_LONG)));
	// IDS_FORM_HTREE_PROPERTY_C =
	//		_xZkqqHx_iOoNjFmK_xHqqkZx_:_xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_\r\n
	//		_xZkqqHx_iDfOiDeDiDgHiDiL_xHqqkZx_:%s\r\n
	//		_xZkqqHx_iDgPiBfLiDfHiDiHiDjD_xHqqkZx_:%s\r\n
	//		_xZkqqHx_iNoMjAkMjDpKiOjO_xHqqkZx_:%s\r\n
	//		_xZkqqHx_iNoMjAkMiOnC_xHqqkZx_:%s\r\n
	//		_xZkqqHx_iKeKiOgOiImKjChF_xHqqkZx_:%I64d_xZkqqHx_iDfKiDgCiDfGiDiHiDjD_xHqqkZx_\r\n
	//		_xZkqqHx_iPeJjHlJiImKjChF_xHqqkZx_:%I64d_xZkqqHx_iDfKiDgCiDfGiDiHiDjD_xHqqkZx_\r\n
	//		_xZkqqHx_iMlLiNnNiImKjChF_xHqqkZx_:%I64d_xZkqqHx_iDfKiDgCiDfGiDiHiDjD_xHqqkZx_\r\n
	//		_xZkqqHx_iDfIiDfCiDeB_xHqqkZx_:%f\r\n
	//		_xZkqqHx_jHnNjAmPiDfIiDfCiDeB_xHqqkZx_:%f\r\n
	//		_xZkqqHx_iDfCiDiBiDjDiDgH_xHqqkZx_:%s
	return FormatResString(	IDS_FORM_HTREE_PROPERTY_C,
							GetDocumentTitle().c_str(),		// _xZkqqHx_jFlGiPjBjGlMiBeC_xHqqkZx_
							GetVersionString().c_str(),		// _xZkqqHx_iDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
							wstrDate.c_str(),				// _xZkqqHx_iNoMjAkMjDpKiOjOiBeC_xHqqkZx_
							GetUserName().c_str(),			// _xZkqqHx_iNoMjAkMiOnCiBeC_xHqqkZx_
							GetFirstSessionIndex(),			// _xZkqqHx_iKeKiOgOiImKjChFiBeC_xHqqkZx_
							GetEndSessionIndex(),			// _xZkqqHx_iPeJjHlJiImKjChFiBeC_xHqqkZx_
							fliSessionIndex,				// _xZkqqHx_iMlLiNnNiImKjChFiBeC_xHqqkZx_
							GetHtreeScore(),				// _xZkqqHx_jHjKjHpAiDfIiDfCiDeBiBeC_xHqqkZx_
							GetAccumulatedHtreeScore(fliSessionIndex),	// _xZkqqHx_jHnNjAmPjHjKjHpAiDfIiDfCiDeBiBeC_xHqqkZx_
							GetComment().c_str());			// _xZkqqHx_iDfCiDiBiDjDiDgHiBeC_xHqqkZx_
} // FCHTreeRec::GetHintText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::GetHTreeManager
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjGnIiKmHjHjNiDeOiDiJiDfIiDeJiDhFiDfHiDeGiDeOiDgH_xHqqkZx_ FCHTreeManager _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjGnIiKmHjHjNiDeOiDiJiDfIiDeJiDhFiDfHiDeGiDeOiDgH_xHqqkZx_ FCHTreeManager_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.01.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCHTreeManager* FCHTreeRec::GetHTreeManager ()
{
	return m_pHTreeMng;
} // FCHTreeRec::GetHTreeManager.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::GetHTreeManager
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjGnIiKmHjHjNiDeOiDiJiDfIiDeJiDhFiDfHiDeGiDeOiDgH_xHqqkZx_ FCHTreeManager _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjGnIiKmHjHjNiDeOiDiJiDfIiDeJiDhFiDfHiDeGiDeOiDgH_xHqqkZx_ FCHTreeManager_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.05.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const FCHTreeManager* FCHTreeRec::GetHTreeManager () const
{
	return m_pHTreeMng;
} // FCHTreeRec::GetHTreeManager.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::GetHtreeScore
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMjHjKjHpAjFlGiPjBiCmMjHjKjHpAiDfIiDfCiDeBiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jHjKjHpAiDfIiDfCiDeBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
double FCHTreeRec::GetHtreeScore ()
{
	return GetHTreeManager()->GetDocRecExtData(GetDocumentId())->GetHtreeScore();
} // FCHTreeRec::GetHtreeScore.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::GetAccumulatedHtreeScore
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDfKiDgCiDfGiDiHiDjDiImKjChFiCnMiCmFiCmMjHnNjAmPiCmMjHjKjHpAiDfIiDfCiDeBiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fliSessionIndex	:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_-1 _xZkqqHx_iCpAiOhHjCoIiClHiCoJiCmG_xHqqkZx_
 *							 _xZkqqHx_iClBiCmMjHjKjHpAjFlGiPjBiCmMiDgHiDgCiDhGiCmMjHnNjAmPiDfIiDfCiDeBiCkKjFnEiCoJiBeC_xHqqkZx_
 *							 _xZkqqHx_iPfMjFkKjBoFiCkLiCkCjCgMiCpAiOhHjCoIiClHiCoJiCmGiBeBiClBiCmMjHjKjHpAjFlGiPjBiCmM_xHqqkZx_
 *							 _xZkqqHx_iDhLiDgHiDiAiCmMjHnNjAmPiDfIiDfCiDeBiCkKjFnEiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jHnNjAmPjHjKjHpAiDfIiDfCiDeBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
double FCHTreeRec::GetAccumulatedHtreeScore (flint fliSessionIndex)
{
	double dHtreeScore = GetHtreeScore();
	long lSuperDocId = GetHTreeManager()->GetDocRecExtData(GetDocumentId())->GetSuperDocId();
	if (lSuperDocId != -1)
	{
		FCHTreeRec* pSuperRec = GetHTreeManager()->DocumentIdToHTreeRec(lSuperDocId);
		dHtreeScore *= pSuperRec->GetAccumulatedHtreeScore(GetFirstSessionIndex());
	}
	const FCHiForkTagRecAutoVector& vHiForkTag = GetHiForkTagRecVector();
	FCHiForkTagRecAutoVector::const_iterator iFt;
	for (iFt = vHiForkTag.begin(); iFt != vHiForkTag.end(); iFt++)
	{
		if (fliSessionIndex <= (*iFt)->GetSessionIndex()) break;
		dHtreeScore *= (*iFt)->GetHtreeScore();
	}
	return dHtreeScore;
} // FCHTreeRec::GetAccumulatedHtreeScore.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::GetAccumulatedHtreeScore
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfKiDgCiDfGiDiHiDjDjEmNiImNiCmGiBeBiClLiCmMjEmNiImNiCmMjHjKjHpAiDfIiDfCiDeBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vSessionHtreeScore :_xZkqqHx_iDfKiDgCiDfGiDiHiDjDjEmNiImNiCmGiBeBiClLiCmMjEmNiImNiCmMjHjKjHpAiDfIiDfCiDeBiCpA_xHqqkZx_
								_xZkqqHx_jFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHTreeRec::GetAccumulatedHtreeScore (vector<FCSessionHtreeScoreRec>& vSessionHtreeScore)
{
	vSessionHtreeScore.clear();
	double dHtreeScore = GetHtreeScore();
	long lSuperDocId = GetHTreeManager()->GetDocRecExtData(GetDocumentId())->GetSuperDocId();
	if (lSuperDocId != -1)
	{
		FCHTreeRec* pSuperRec = GetHTreeManager()->DocumentIdToHTreeRec(lSuperDocId);
		dHtreeScore *= pSuperRec->GetAccumulatedHtreeScore(GetFirstSessionIndex());
	}
	const FCHiForkTagRecAutoVector& vHiForkTag = GetHiForkTagRecVector();
	flint fliFromSessionIndex = GetFirstSessionIndex();
	FCHiForkTagRecAutoVector::const_iterator iFt;
	for (iFt = vHiForkTag.begin(); iFt != vHiForkTag.end(); iFt++)
	{
		vSessionHtreeScore.push_back(FCSessionHtreeScoreRec(fliFromSessionIndex,
															(*iFt)->GetSessionIndex(),
															dHtreeScore));
		dHtreeScore *= (*iFt)->GetHtreeScore();
		fliFromSessionIndex = (*iFt)->GetSessionIndex();
	}
	vSessionHtreeScore.push_back(FCSessionHtreeScoreRec(fliFromSessionIndex,
														GetEndSessionIndex(),
														dHtreeScore));
} // FCHTreeRec::GetAccumulatedHtreeScore.

//----- 05.09.17 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::GetFromSessionIndex
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPoDiImKjHjKjHpAiCmMiBeBiClBiCmMjHjKjHpAiCkKiCmCiCmIiCkKiCoJiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.01.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//flint FCHTreeRec::GetFromSessionIndex ()
//{
////----- 04.11.12 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	// _xZkqqHx_jHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCkKiNfIjAfGiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNjDmHiCnNiNjOiCnNiBeC_xHqqkZx_
////	if (IsForkUpdated()) LoadForkFile();
////	return m_fliFromSessionIndex;
////----- 04.11.12 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//	return GetFirstSessionIndex();
////----- 04.11.12 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//} // FCHTreeRec::GetFromSessionIndex.
//----- 05.09.17 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::GetSubTreeDocIdVector
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfEiDhFiCmMjHjKjHpAjFlGiPjBiCmMiDiMiDfCiBfLiDgI_xHqqkZx_ID_xZkqqHx_iCmMjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfEiDhFiCmMjHjKjHpAjFlGiPjBjEhKjHpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.01.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
// 05.11.18 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//const longVector& FCHTreeRec::GetSubTreeDocIdVector ()
const longVector& FCHTreeRec::GetSubTreeDocIdVector () const
{
//----- 05.11.18 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_jHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCkKiNfIjAfGiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNjDmHiCnNiNjOiCnNiBeC_xHqqkZx_
//	if (IsForkUpdated()) LoadForkFile();
//----- 05.11.18 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	return m_vSubTreeDocId;
} // FCHTreeRec::GetSubTreeDocIdVector.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::GetHiLabelRecVector
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiJiDhIiDiLiDiMiDfCiBfLiDgIiCmMjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiJiDhIiDiLiDiMiDfCiBfLiDgIiCmMjEhKjHpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.01.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const FCHiLabelRecAutoVector& FCHTreeRec::GetHiLabelRecVector () const
{
//----- 05.11.18 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	if (IsSummaryOverwrited())
//		LoadSummary();		// _xZkqqHx_jDmHiCnNiNjOiCnNiKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
//	else
//	if (IsSummaryAppended())
//		AppendSummary();	// _xZkqqHx_jCmHiJmBjDmHiCnNiNjOiCnNiKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
//----- 05.11.18 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_jHjKjHpAiPeJjCfLiDgFiBfLiDhFiDiLiCkKiNfIjAfGiClDiCoKiCmEiCkCiCoJ_xHqqkZx_(IsTerminateUpdated)_xZkqqHx_iPoKiNiHiBeB_xHqqkZx_
	// m_vHiLabelRecAuto_xZkqqHx_iCmNiNmEiNfMjChKiClHiCoJjFeLjHhGiCmNiCmIiCkCiBeC_xHqqkZx_
	// m_vHiLabelRecAuto_xZkqqHx_iCmNjHjKjHpAiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCmJ_xHqqkZx_
	// _xZkqqHx_iLeMjIfOiClDiCoKiCmEiCkCiCoJiDiJiDhIiDiLiCpAjBfDiCmEjFkBiOmKiClHiCoJiClNiCnPiBeC_xHqqkZx_

	return m_vHiLabelRecAuto;
} // FCHTreeRec::GetHiLabelRecVector.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::GetHiForkTagRecVector
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiDiMiDfCiBfLiDgIiCmMjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiDiMiDfCiBfLiDgIiCmMjEhKjHpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
// 05.11.18 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//const FCHiForkTagRecAutoVector& FCHTreeRec::GetHiForkTagRecVector ()
const FCHiForkTagRecAutoVector& FCHTreeRec::GetHiForkTagRecVector () const
{
//----- 05.11.18 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_jHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCkKiNfIjAfGiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNjDmHiCnNiNjOiCnNiBeC_xHqqkZx_
//	if (IsForkUpdated())
//		LoadForkFile();
//----- 05.11.18 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	return m_vHiForkTagRecAuto;
} // FCHTreeRec::GetHiForkTagRecVector.

//----- 05.09.14 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::GetTimeLabelRecVector
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOjOiKnEiDiJiDhIiDiLiDiMiDfCiBfLiDgIiCmMjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOjOiKnEiDiJiDhIiDiLiDiMiDfCiBfLiDgIiCmMjEhKjHpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
// 05.11.18 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//const FCTimeLabelRecAutoVector& FCHTreeRec::GetTimeLabelRecVector ()
const FCTimeLabelRecAutoVector& FCHTreeRec::GetTimeLabelRecVector () const
{
//----- 05.11.18 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_jHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCkKiNfIjAfGiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNjDmHiCnNiNjOiCnNiBeC_xHqqkZx_
//	if (IsForkUpdated())
//		LoadForkFile();
//----- 05.11.18 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	return m_vTimeLabelRecAuto;
} // FCHTreeRec::GetTimeLabelRecVector.
//----- 05.09.14 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::GetSessionToNodeMmapW
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMmCjFmKjHjKjHpAiOhNiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIjFfMiOkGiDiMiDeDiDeBiDeFiDgHjHhAiDfKiDgCiDfGiDiHiDjDiImKjChF_xHqqkZx_->
 *			_xZkqqHx_iDiJiDhIiDiLiBeFjHjKjHpAiNkMiNnNiDgOiDgCiDfGiDiF_xHqqkZx_ _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMmCjFmKjHjKjHpAiOhNiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIjFfMiOkGiDiMiDeDiDeBiDeFiDgHjHhAiDfKiDgCiDfGiDiHiDjDiImKjChF_xHqqkZx_->
 *			_xZkqqHx_iDiJiDhIiDiLiBeFjHjKjHpAiNkMiNnNiDgOiDgCiDfGiDiF_xHqqkZx_ 
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.01.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FTSessionToNodeMmap& FCHTreeRec::GetSessionToNodeMmapW ()
{
//----- 05.11.18 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	if (IsSummaryOverwrited())
//		LoadSummary();		// _xZkqqHx_jDmHiCnNiNjOiCnNiKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
//	else
//	if (IsSummaryAppended())
//		AppendSummary();	// _xZkqqHx_jCmHiJmBjDmHiCnNiNjOiCnNiKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
//----- 05.11.18 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 05.11.18 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_jHjKjHpAjFkKiKpCiDgFiBfLiDhFiDiLiCkKiNfIjAfGiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNjDmHiCnNiNjOiCnNiBeC_xHqqkZx_
//	if (IsForkUpdated())
//		LoadForkFile();
//----- 05.11.18 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiImKjChF_xHqqkZx_->_xZkqqHx_iDiJiDhIiDiLiBeFjHjKjHpAiNkMiNnNiDgOiDgCiDfGiDiFiCkKjBlGiNnNiClHiCoJiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (m_mmapSessionToNode != NULL)
		return *m_mmapSessionToNode;

	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiImKjChF_xHqqkZx_->_xZkqqHx_iDiJiDhIiDiLiBeFjHjKjHpAiNkMiNnNiDgOiDgCiDfGiDiFiCpAiNoMjAkMiBeC_xHqqkZx_
	m_mmapSessionToNode = new FTSessionToNodeMmap;

	//----- _xZkqqHx_jFkKiKpCiDiMiDfCiBfLiDgIiCpAjCmHiJmB_xHqqkZx_ -----
	for (longVector::const_iterator iR = GetSubTreeDocIdVector().begin();
		 iR != GetSubTreeDocIdVector().end(); iR++)
	{
		FCHTreeRec* pRec = GetHTreeManager()->DocumentIdToHTreeRec(*iR);
		if (pRec == NULL) continue;
		m_mmapSessionToNode->insert(pair<flint, FCHLabelHtreeRec>(
									pRec->GetFirstSessionIndex(),
									FCHLabelHtreeRec(FDTR_HTREE_REC, *iR)));
	}
	//----- _xZkqqHx_iDiJiDhIiDiLiDiMiDfCiBfLiDgIiCpAjCmHiJmB_xHqqkZx_ -----
	long lIndex;
	for (lIndex = 0;
		 lIndex != GetHiLabelRecVector().size();
		 lIndex++)
	{
//----- 06.04.07 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		// _xZkqqHx_iDiJiDhIiDiLiCmNjHjKjHpAiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCmJiLeMjIfOiClDiCoKiCoJiCkKiBeBjHjKjHpAiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCmN_xHqqkZx_
//		// _xZkqqHx_iPeJjCfLiCpAiJhKiCkGiCmEjDmHiCnNiNjOiCnMiCoKiCoJiPoKiNiHiCkKiCkAiCoJiBeCiClBiCmMiClNiCnPiBeBiPeJjCfLiDfKiDgCiDfGiDiHiDjDiImKjChFiCpA_xHqqkZx_
//		// _xZkqqHx_jClEiCkGiClNjFjEjFkKiCmN_xHqqkZx_m_mmapSessionToNode _xZkqqHx_iCmJiLeMjIfOiClFiCmIiCkCiCoGiCkEiCmJiClHiCoJiBeC_xHqqkZx_
//		if (GetHiLabelRecVector().at(lIndex)->GetSessionIndex() <= GetEndSessionIndex())
//			m_mmapSessionToNode->insert(pair<flint, FCHLabelHtreeRec>(
//										GetHiLabelRecVector().at(lIndex)->GetSessionIndex(),
//										FCHLabelHtreeRec(FDTR_LABEL_REC, lIndex)));
//----- 06.04.07 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		// _xZkqqHx_iDiJiDhIiDiLiCmNjHjKjHpAiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCmJiLeMjIfOiClDiCoKiCoJiCkKiBeBjHjKjHpAiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCmN_xHqqkZx_
		// _xZkqqHx_iPeJjCfLiCpAiJhKiCkGiCmEjDmHiCnNiNjOiCnMiCoKiCoJiPoKiNiHiCkKiCkAiCoJiBeCiClBiCmMiClNiCnPiBeBiPeJjCfLiDfKiDgCiDfGiDiHiDjDiImKjChFiCpA_xHqqkZx_
		// _xZkqqHx_jClEiCkGiClNjFjEjFkKiCmN_xHqqkZx_m_mmapSessionToNode _xZkqqHx_iCmJiLeMjIfOiClFiCmIiCkCiCoGiCkEiCmJiClHiCoJiBeC_xHqqkZx_
		if (GetEndSessionIndex() < GetHiLabelRecVector().at(lIndex)->GetSessionIndex())
			break;
		if (GetHiLabelRecVector().at(lIndex)->GetIsCreate())
			m_mmapSessionToNode->insert(pair<flint, FCHLabelHtreeRec>(
										GetHiLabelRecVector().at(lIndex)->GetSessionIndex(),
										FCHLabelHtreeRec(FDTR_LABEL_REC, lIndex)));
//----- 06.04.07 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	}

	//----- _xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiDiMiDfCiBfLiDgIiCpAjCmHiJmB_xHqqkZx_ -----
	for (lIndex = 0;
		 lIndex != GetHiForkTagRecVector().size();
		 lIndex++)
	{
		m_mmapSessionToNode->insert(pair<flint, FCHLabelHtreeRec>(
									GetHiForkTagRecVector().at(lIndex)->GetSessionIndex(),
									FCHLabelHtreeRec(FDTR_HI_FORK_TAG_REC, lIndex)));
	}

//----- 05.09.14 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	//----- _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiDiMiDfCiBfLiDgIiCpAjCmHiJmB_xHqqkZx_ -----
	for (lIndex = 0;
		 lIndex != GetTimeLabelRecVector().size();
		 lIndex++)
	{
		m_mmapSessionToNode->insert(pair<flint, FCHLabelHtreeRec>(
									GetTimeLabelRecVector().at(lIndex)->GetSessionIndex(),
									FCHLabelHtreeRec(FDTR_TIME_LABEL_REC, lIndex)));
	}
//----- 05.09.14 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	return *m_mmapSessionToNode;
} // FCHTreeRec::GetSessionToNodeMmapW.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::GetTimeRecVectorW
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAoCjBmOiOjOiKnEiDiMiDfCiBfLiDgIiCmMjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAoCjBmOiOjOiKnEiDiMiDfCiBfLiDgIiCmMjEhKjHpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.01.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
HTRTimeRecVector& FCHTreeRec::GetTimeRecVectorW ()
{
//----- 05.11.18 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	if (IsSummaryOverwrited())
//		LoadSummary();		// _xZkqqHx_jDmHiCnNiNjOiCnNiKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
//	else
//	if (IsSummaryAppended())
//		AppendSummary();	// _xZkqqHx_jCmHiJmBjDmHiCnNiNjOiCnNiKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
//----- 05.11.18 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	return m_vTimeRec;
} // FCHTreeRec::GetTimeRecVectorW.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::GetCrossBox
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	RegisterBox_xZkqqHx_iKnGjAjEiCmFjDgPjIfOiClDiCoKiClNjAoIjHeMjHmMiIoGiCmMiCkEiClPiBeBiOhHjCoIiCmMiLoJiMgAiCmG_xHqqkZx_
 *			_xZkqqHx_iPgEiCmIiCoJjHmMiIoGiCpAjClCiCnHiBeBiPgEiCmIiCmBiClNjHmMiIoGiCpAiJpAiPmBiClHiCoJiClNiCnPiCmJiBeB_xHqqkZx_
 *			rt_xZkqqHx_iCpAiJlKjFpLiCnGiInKjDkOiClHiCoJiNmFiPkMiLjHjHkDiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	rt				:_xZkqqHx_iMjPiNlIiClHiCoJjHmMiIoGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			rtaOccupied		:_xZkqqHx_jAoIjHeMiClDiCoKiCmEiCkCiCoJjHmMiIoGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lOccupiedCount	:rtaOccupied_xZkqqHx_iCmMjEhKjHpBjHhGjBgGjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPgEiCmIiCmBiClNjHmMiIoGiCpAiJpAiPmBiClHiCoJiClNiCnPiCmJiBeB_xHqqkZx_rt_xZkqqHx_iCpAiJlKjFpLiCnGiInKjDkOiClHiCoJiNmFiPkMiLjHjHkDiCpAjFnEiClHiBeC_xHqqkZx_
 *			_xZkqqHx_iPgEiCmIiCoIiCkKjGlDiCkCiPoKiNiHiCmN_xHqqkZx_0_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iImIiJlKiCmMiCfDiCmCiCmMiPoKiNiHiCkKiCkAiCoIiCkGiCoJiBeC_xHqqkZx_
 *
 *                         rtaOccupied[n]
 *          rt    _xZkqqHx_iEkMiEkKiEkKiEkKiEkKiEkN_xHqqkZx_
 *          _xZkqqHx_iEkMiEkKiEkKiElEiEkKiEkNiEjPiEjPiElOiEjPiEkG_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkAiInKjDkOiLjHjHkD_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iBkL_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkPiEkKiElEiEkKiEkKiEkOiEjPiEkI_xHqqkZx_
 *          _xZkqqHx_iEkPiEkKiEkKiEkKiEkKiEkO_xHqqkZx_
 *
 *
 *                         rtaOccupied[n]
 *          rt    _xZkqqHx_iEkMiEkKiEkKiEkKiEkKiEkN_xHqqkZx_
 *          _xZkqqHx_iEkMiEkKiEkKiElEiEkKiEkNiEjPiEjPiElOiEjPiEkG_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkAiInKjDkOiLjHjHkD_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkPiEkKiEkKiElEiEkKiEkO_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iBkL_xHqqkZx_
 *                _xZkqqHx_iEkPiEkKiEkKiEkKiEkKiEkOiEjPiEkI_xHqqkZx_
 *
 *
 *          rt             rtaOccupied[n]
 *          _xZkqqHx_iEkMiEkKiEkKiEkKiEkKiEkNiEjPiEjPiEjPiEjPiEkG_xHqqkZx_  
 *          _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkMiEkKiElEiEkKiEkKiEkN_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkAiInKjDkOiLjHjHkD_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iBkL_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkPiEkKiElEiEkKiEkKiEkOiEjPiEkI_xHqqkZx_
 *          _xZkqqHx_iEkPiEkKiEkKiEkKiEkKiEkO_xHqqkZx_
 *
 *
 *          rt             rtaOccupied[n]
 *          _xZkqqHx_iEkMiEkKiEkKiEkKiEkKiEkNiEjPiEjPiEjPiEjPiEkG_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkMiEkKiElEiEkKiEkKiEkN_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkAiInKjDkOiLjHjHkD_xHqqkZx_
 *          _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkL_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkPiEkKiEkKiElEiEkKiEkO_xHqqkZx_    _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iBkL_xHqqkZx_
 *                _xZkqqHx_iEkPiEkKiEkKiEkKiEkKiEkOiEjPiEkI_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.06.12 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *			03.03.25 Fukushiro M. _xZkqqHx_iClBiClBiCnGiInKjDkOiBjFjFmPiNfI_xHqqkZx_
 *			04.07.03 Fukushiro M. _xZkqqHx_iNoMiCoIjFmPiCkG_xHqqkZx_
 *************************************************************************/
long FCHTreeRec::GetCrossBox (	CRect rt,
								const CRect rtaOccupied[],
								long lOccupiedCount) const
{
//----- 04.07.03 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	CRect rtCross;
//	for (long lC = 0; lC < lOccupiedCount; lC++)
//	{
//		if (rtCross.IntersectRect(rtaOccupied[lC], rt))
//			return rtCross;
//	}
//	return CRect(0, 0, 0, 0);
//----- 04.07.03 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_jHmMiIoGiCmGiCmMiNmFjCoBiLjHjHkDiBgJ_xHqqkZx_GetHTreeManager()->GetHtInterBoxX(), GetHTreeManager()->GetHtInterBoxY()_xZkqqHx_iBgKiCpAjHfMiCnPiKgHjCkDiClFiCmEiCkIiCkNiBeC_xHqqkZx_
	rt.InflateRect(GetHTreeManager()->GetHtInterBoxX(), GetHTreeManager()->GetHtInterBoxY());
	const long lTopOrg = rt.top;
	long lC;
	for (lC = 0; lC < lOccupiedCount;)
	{
		if (CRect().IntersectRect(rtaOccupied[lC], rt))
		//----- _xZkqqHx_jAoIjHeMjHmMiIoGiCmG_xHqqkZx_rt_xZkqqHx_iCkKiMpAiCoNiCmBiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// rt_xZkqqHx_iCpAiJlKjFpLiCmJiInKjDkOiClFiCmEiBeBjAoIjHeMjHmMiIoGiCmMiNmFiPiJiCkJiCoHjClCiCnHiCmIiCkIiClHiBeC_xHqqkZx_
			const long lMove = rtaOccupied[lC].bottom - rt.top;
			rt += CSize(0, lMove);
			lC = 0;
		} else
		//----- _xZkqqHx_jAoIjHeMjHmMiIoGiCmG_xHqqkZx_rt_xZkqqHx_iCkKiMpAiCoNiCmBiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			lC++;
		}
	}
	// _xZkqqHx_iInKjDkOiLjHjHkDiCpAjFnEiClHiBeC_xHqqkZx_
	return (rt.top - lTopOrg);
//----- 04.07.03 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCHTreeRec::GetCrossBox.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::IsOverLine
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	RegisterLine_xZkqqHx_iKnGjAjEiCmFjDgPjIfOiClDiCoKiClNjApMjFkKiDiKiDfIiDgHjCiGiCmJiBeBiOhHjCoIiCmMjApMjFkKiCmG_xHqqkZx_
 *			_xZkqqHx_iPgEiCmIiCoJjApMjFkKiCkKiCkAiCoJiCkJiCmHiCkEiCkJiCpAiMjPiNlIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lx		:_xZkqqHx_iMjPiNlIiClHiCoJjApMjFkKiCmM_xHqqkZx_x_xZkqqHx_iNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lyFrom	:_xZkqqHx_iMjPiNlIiClHiCoJjApMjFkKiCmM_xHqqkZx_y_xZkqqHx_iNmAjFfHiKeKiOgOiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lyTo	:_xZkqqHx_iMjPiNlIiClHiCoJjApMjFkKiCmM_xHqqkZx_y_xZkqqHx_iNmAjFfHiPeJjHlJiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			slaOccupied		:_xZkqqHx_jAoIjHeMiClDiCoKiCmEiCkCiCoJjApMjFkKiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lOccupiedCount	:slaOccupied_xZkqqHx_iCmMjEhKjHpBjHhGjBgGjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
  *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPgEiCmIiCoJjApMjFkKiCkKiCkAiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.06.12 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *			03.03.25 Fukushiro M. _xZkqqHx_iClBiClBiCnGiInKjDkOiBjFjFmPiNfI_xHqqkZx_
 *************************************************************************/
BOOL FCHTreeRec::IsOverLine (	long lx, long lyFrom, long lyTo,
								const VShortLine slaOccupied[],
								long lOccupiedCount) const
{
	// lyFrom, lyTo _xZkqqHx_iCpAiBeBjApMjFkKiKnEiCmMiNmFjCoBiLjHjHkD_xHqqkZx_ GetHTreeManager()->GetHtInterLineY() _xZkqqHx_iClOiCkPiNeMiClAiCmEiCkIiCkNiBeC_xHqqkZx_
	lyFrom -= GetHTreeManager()->GetHtInterLineY();
	lyTo += GetHTreeManager()->GetHtInterLineY();
	long lp, lq;
	for (long lC = 0; lC < lOccupiedCount; lC++)
	{
		if (slaOccupied[lC].lx == lx &&
			LinearOverlap(lp, lq, slaOccupied[lC].lyFrom,
						slaOccupied[lC].lyTo, lyFrom, lyTo))
			return TRUE;
	}
	return FALSE;
} // FCHTreeRec::IsOverLine.

//----- 04.07.03 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::GetPtInY
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	RegisterBox_xZkqqHx_iKnGjAjEiCmFjDgPjIfOiClDiCoKiClNjAoIjHeMjHmMiIoGiCmMiCkEiClPiBeBiOhHjCoIiCmMjDfPiCpAjDoAjFjEiCmJ_xHqqkZx_
// *			_xZkqqHx_iOjNiCmCiLoJiMgAjHmMiIoGiCkKiCkAiCoJiPoKiNiHiCmNiBeBiOhHjCoIiCmMjDfPiCkJiCoHiLoJiMgAjHmMiIoGiCmMjCoKiCnMiCmFiCmM_xHqqkZx_
// *			_xZkqqHx_iLjHjHkDiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pt	:_xZkqqHx_iMjPiNlIiClHiCoJjDfPiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jDfPiCkJiCoHiLoJiMgAjCoKiCnMiCmFiCmMiLjHjHkDiCpAjFnEiClHiBeCiPgEiCmIiCoHiCmIiCkCiPoKiNiHiCmN_xHqqkZx_0_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.06.12 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
// *			03.03.25 Fukushiro M. _xZkqqHx_iClBiClBiCnGiInKjDkOiBjFjFmPiNfI_xHqqkZx_
// *************************************************************************/
//long FCHTreeRec::GetPtInY (const CPoint& pt,
//								const CRect rtaOccupied[],
//								long lOccupiedCount)
//{
//	for (long lC = 0; lC < lOccupiedCount; lC++)
//	{
//		if (rtaOccupied[lC].PtInRect(pt))
//			return rtaOccupied[lC].bottom - pt.y;
//	}
//	return 0;
//} // FCHTreeRec::GetPtInY.
//----- 04.07.03 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::RegisterBox
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiPoDiCmFiBeBiLoJiMgAiCkKjAoIjHeMiClHiCoJjHmMiIoGiCpAjDgPjIfOiBeCjFfMiOkGiDhLiDgCiDeOiDfIiBeB_xHqqkZx_
 *			_xZkqqHx_jGoOiIpDjAoGjCfLiBeBjFkKiKpCjDfPiOpMiImNjDjJiCpAjDgPjIfOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	rt	:_xZkqqHx_jDgPjIfOiClHiCoJiLoJiMgAjHmMiIoGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.06.12 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *			03.03.25 Fukushiro M. _xZkqqHx_iClBiClBiCnGiInKjDkOiBjFjFmPiNfI_xHqqkZx_
 *************************************************************************/
void FCHTreeRec::RegisterBox (CRectVector& rtvOccupied, const CRect& rt)
{
	rtvOccupied.push_back(rt);
} // FCHTreeRec::RegisterBox.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::RegisterLine
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiPoDiCmFiBeBjHjKjHpAjApMiCkKjAoIjHeMiClHiCoJjApMjHmMiIoGiCpAjDgPjIfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lx		:_xZkqqHx_jApMjFkKiCmM_xHqqkZx_x_xZkqqHx_iNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lyFrom	:_xZkqqHx_jApMjFkKiCmM_xHqqkZx_y_xZkqqHx_iNmAjFfHiKeKiOgOiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lyTo	:_xZkqqHx_jApMjFkKiCmM_xHqqkZx_y_xZkqqHx_iNmAjFfHiPeJjHlJiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.06.12 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *			03.03.25 Fukushiro M. _xZkqqHx_iClBiClBiCnGiInKjDkOiBjFjFmPiNfI_xHqqkZx_
 *************************************************************************/
void FCHTreeRec::RegisterLine (	VSLineVector& slvOccupied,
								long lx, long lyFrom, long lyTo)
{
	slvOccupied.push_back(VShortLine(lx, lyFrom, lyTo));
} // FCHTreeRec::RegisterLine.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHTreeRec::FCHTreeRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	FCHTreeRec::Create _xZkqqHx_iCmFiCmMiCnNiNoMjAkMiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.03.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCHTreeRec::FCHTreeRec () // : FCHistNode(flint(-1), CPoint(0,0))
{
	m_pHTreeMng = NULL;						// HTreeManager_xZkqqHx_iBeC_xHqqkZx_
	m_lDocId = -1;							// _xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
// 04.11.12 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	m_fliFromSessionIndex = flint(-1);		// _xZkqqHx_iPoDiImKjHjKjHpAiCmMiBeBiClBiCmMjHjKjHpAiCkKiCmCiCmIiCkKiCoJiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_ 
	m_ptRoot = CPoint(0, 0);				// _xZkqqHx_jHjKjHpAjGnIiNfMjBkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCmJiCkIiCkPiCoJiDhLiDgCiDeOiDfIiCmMjAnKjBlBiImKjChFiNmAjFfHiBeC_xHqqkZx_

	m_fliFirstSessionIndex = 0;				// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiPiJiKpKjCgMiBeC_xHqqkZx_
	m_fliEndSessionIndex = 0;				// _xZkqqHx_jHjKjHpAiPeJjCfLiImKjChFiBeC_xHqqkZx_

	m_mmapSessionToNode = NULL;				// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiImKjChF_xHqqkZx_->_xZkqqHx_iDiJiDhIiDiLiBeFjHjKjHpAiNkMiNnNiDgOiDgCiDfGiDiFiBeC_xHqqkZx_

	m_lLife = -1;							// _xZkqqHx_jHjKjHpAjApMiCmMjClHiClDiBeC_xHqqkZx_
	m_ptBox = CPoint(0,0);					// _xZkqqHx_jFfMiOkGiDhLiDgCiDeOiDfIiCmMiKoOiPiAjDfPiBeC_xHqqkZx_

//----- 06.02.06 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	m_dwSummaryLastEndIndex = DWORD(-1);	// _xZkqqHx_jHjKjHpAiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCmMjDmHiCnNiNjOiCpBiClOiImKjChFiCpAiLeMjIfOiClFiCmEiCkIiCkNiBeC_xHqqkZx_
//
//	m_guidSummaryTable = GUID_NULL;					// _xZkqqHx_iDfEiDhNiDiKiBfLiDgFiBfLiDhFiDiLiCmMiDgFiBfLiDhFiDiL_xHqqkZx_GUID_xZkqqHx_iBeC_xHqqkZx_
//	m_dwSummaryLastDeleteIdentifier = DWORD(-1);	// _xZkqqHx_iDfEiDhNiDiKiBfLiDgFiBfLiDhFiDiLiCmMiNfIjAfGiDeKiDeFiDjDiDfOiBeC_xHqqkZx_
//	m_dwSummaryLastAppendIdentifier = DWORD(-1);	// _xZkqqHx_iDfEiDhNiDiKiBfLiDgFiBfLiDhFiDiLiCmMiNfIjAfGiDeKiDeFiDjDiDfOiBeC_xHqqkZx_
//
//	m_guidTerminateTable = GUID_NULL;				// _xZkqqHx_jHjKjHpAiPeJjCfLiImKjChFiCmMiDgFiBfLiDhFiDiL_xHqqkZx_GUID_xZkqqHx_iBeC_xHqqkZx_
//	m_dwTerminateLastDeleteIdentifier = DWORD(-1);	// _xZkqqHx_jHjKjHpAiPeJjCfLiImKjChFiCmMiNfIjAfGiDeKiDeFiDjDiDfOiBeC_xHqqkZx_
//	m_dwTerminateLastAppendIdentifier = DWORD(-1);		// _xZkqqHx_jHjKjHpAiPeJjCfLiImKjChFiCmMiNfIjAfGiDeKiDeFiDjDiDfOiBeC_xHqqkZx_
//
//	m_guidForkTable = GUID_NULL;					// _xZkqqHx_jHjKjHpAjFkKiKpCiCmMiDgFiBfLiDhFiDiL_xHqqkZx_GUID_xZkqqHx_iBeC_xHqqkZx_
//	m_dwForkLastDeleteIdentifier = DWORD(-1);		// _xZkqqHx_jHjKjHpAjFkKiKpCiCmMiNfIjAfGiDeKiDeFiDjDiDfOiBeC_xHqqkZx_
//	m_dwForkLastAppendIdentifier = DWORD(-1);			// _xZkqqHx_jHjKjHpAjFkKiKpCiCmMiNfIjAfGiDeKiDeFiDjDiDfOiBeC_xHqqkZx_
//----- 06.02.06 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	m_guidSummaryTable = GUID_NULL;					// _xZkqqHx_iDfEiDhNiDiKiBfLiDgFiBfLiDhFiDiLiCmMiDgFiBfLiDhFiDiL_xHqqkZx_GUID_xZkqqHx_iBeC_xHqqkZx_
	m_dwSummaryLastEndIndex = DWORD(-1);			// _xZkqqHx_iDfEiDhNiDiKiBfLiDgFiBfLiDhFiDiLiCmMiNfIjAfGiDeKiDeFiDjDiDfOiBeC_xHqqkZx_
	m_dwSummaryLastAppendIdentifier = DWORD(-1);	// _xZkqqHx_iDfEiDhNiDiKiBfLiDgFiBfLiDhFiDiLiCmMiNfIjAfGiDeKiDeFiDjDiDfOiBeC_xHqqkZx_

	m_guidTerminateTable = GUID_NULL;				// _xZkqqHx_jHjKjHpAiPeJjCfLiImKjChFiCmMiDgFiBfLiDhFiDiL_xHqqkZx_GUID_xZkqqHx_iBeC_xHqqkZx_
	m_dwTerminateLastEndIndex = DWORD(-1);			// _xZkqqHx_jHjKjHpAiPeJjCfLiImKjChFiCmMiNfIjAfGiDeKiDeFiDjDiDfOiBeC_xHqqkZx_
	m_dwTerminateLastAppendIdentifier = DWORD(-1);	// _xZkqqHx_jHjKjHpAiPeJjCfLiImKjChFiCmMiNfIjAfGiDeKiDeFiDjDiDfOiBeC_xHqqkZx_

	m_guidForkTable = GUID_NULL;					// _xZkqqHx_jHjKjHpAjFkKiKpCiCmMiDgFiBfLiDhFiDiL_xHqqkZx_GUID_xZkqqHx_iBeC_xHqqkZx_
	m_dwForkLastEndIndex = DWORD(-1);				// _xZkqqHx_jHjKjHpAjFkKiKpCiCmMiNfIjAfGiDeKiDeFiDjDiDfOiBeC_xHqqkZx_
	m_dwForkLastAppendIdentifier = DWORD(-1);		// _xZkqqHx_jHjKjHpAjFkKiKpCiCmMiNfIjAfGiDeKiDeFiDjDiDfOiBeC_xHqqkZx_
//----- 06.02.06 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCHTreeRec::FCHTreeRec.

