// HeapBuffer.cpp : _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgFiBfLiDfGiDiHiDjD_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

#include "stdafx.h"
#include "UtilErr.h"	// For FFThrowMiscUnknown.
#include "UtilFile.h"	// For FFMakeUniqTmpFileName.
#include "UtilMisc.h"	// For FFVersionInfo().
#include "HeapBuffer.h"	// This header.

//----- 05.12.24 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//#ifdef _DEBUG
//#define new DEBUG_NEW
//#undef THIS_FILE
//static char THIS_FILE[] = __FILE__;
//#endif
//----- 05.12.24 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

// _xZkqqHx_iDiBiDiCiDiKiBfLiDfOiDeDiDhGiCmMiDgPiDgCiDhEiDeAiDfEiDeDiDfJiBgJiMmFjCoIiBgKiBeC_xHqqkZx_
static const DWORD FD_MEMORY_HEAP_SIZE = 0x0000f000;
// _xZkqqHx_iDhEiDeAiDeDiDiLiDfOiDeDiDhGiCmMiDgPiDgCiDhEiDeAiDfEiDeDiDfJiBgJiJmCjFmPiBeBiNmFjBoFjCgMiBgK_xHqqkZx_
static const DWORD FD_FILE_HEAP_MAX = 0x7f000000;
// _xZkqqHx_iDhEiDeAiDeDiDiLiDfOiDeDiDhGiCmMiDgPiDgCiDhEiDeAiDfEiDeDiDfJiCmMiKgHjBoFjCfAiImKiBeC_xHqqkZx_
static const DWORD FD_FILE_HEAP_UNIT = 0x100000;

// _xZkqqHx_iDfKiDePiDiBiDjDiDgHiDfEiDeDiDfJiBeC_xHqqkZx_
#define FD_HEAP_SIZE_SIZE		sizeof(DWORD)
// _xZkqqHx_iOfBiPmGiDeKiDeFiDjDiDfOiDfEiDeDiDfJiBeC_xHqqkZx_
#define FD_HEAP_REF_COUNT_SIZE	sizeof(DWORD)
// _xZkqqHx_iDgGiBfLiDfO_xHqqkZx_ID_xZkqqHx_iDfEiDeDiDfJiBeC_xHqqkZx_
#define FD_HEAP_DATA_ID_SIZE	sizeof(DWORD)

// _xZkqqHx_iDhEiDeAiDeDiDiLiDfOiDeDiDhGiDgPiDgCiDhEiDeAiCmMiDgOiDjDiDgIiDiLiBeC_xHqqkZx_
struct FileTypeRec
{
	HANDLE	m_hFile;			// _xZkqqHx_iDhEiDeAiDeDiDiLiDgOiDjDiDgIiDiLiBeC_xHqqkZx_
	DWORD	m_dwBufferSize;		// _xZkqqHx_iDgPiDgCiDhEiDeAiDfEiDeDiDfJiBeC_xHqqkZx_
	wchar_t	m_wcpFilePath[1];	// _xZkqqHx_iDhEiDeAiDeDiDiLiDhAiDfIiBeC_xHqqkZx_
}; // struct FileTypeRec.

/////////////////////////////////////////////////////////////////////////////
//
// _xZkqqHx_iDhEiDeAiDeDiDiLiDhBiBfLiDhGiDgPiDgCiDhEiDeAiCmMiNfMjBkC_xHqqkZx_
//
//  m_pHeapBuffer
//        _xZkqqHx_iEkA_xHqqkZx_
//        _xZkqqHx_iBkL_xHqqkZx_
//        _xZkqqHx_iEkBiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
//        _xZkqqHx_iEkA_xHqqkZx_hFile _xZkqqHx_iEkA_xHqqkZx_BufSiz_xZkqqHx_iEkA_xHqqkZx_ File Path  _xZkqqHx_iEkA_xHqqkZx_
//        _xZkqqHx_iEkEiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_
//            _xZkqqHx_iEkA_xHqqkZx_
//            _xZkqqHx_iBkL_xHqqkZx_
//          HeapTop                                                         LastSegmentEnd
//            _xZkqqHx_iEkA_xHqqkZx_                                                                  _xZkqqHx_iEkA_xHqqkZx_    HeapEnd
//            _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEjPiEjP_xHqqkZx_1Segment_xZkqqHx_iEjPiEjPiEjPiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEjPiEjPiEjP_xHqqkZx_1Segment_xZkqqHx_iEjPiEjPiEjPiEjPiEjPiEjPiEkH_xHqqkZx_      _xZkqqHx_iBkL_xHqqkZx_
//            _xZkqqHx_iEkBiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiBgD_xHqqkZx_  _xZkqqHx_iBgDiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiBgD_xHqqkZx_  _xZkqqHx_iBgDiEkGiEjPiEjPiEjPiEkGiBgD_xHqqkZx_  _xZkqqHx_iBgDiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
//            _xZkqqHx_iEkA_xHqqkZx_Size1 _xZkqqHx_iEkA_xHqqkZx_RefCnt_xZkqqHx_iEkA_xHqqkZx_DataId_xZkqqHx_iEkA_xHqqkZx_  Data  _xZkqqHx_iEkA_xHqqkZx_Size2 _xZkqqHx_iEkA_xHqqkZx_RefCnt_xZkqqHx_iEkA_xHqqkZx_DataId_xZkqqHx_iEkA_xHqqkZx_  Data  _xZkqqHx_iEkA_xHqqkZx_  0   _xZkqqHx_iEkA_xHqqkZx_        JUNK    _xZkqqHx_iEkA_xHqqkZx_
//            _xZkqqHx_iEkEiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiBgD_xHqqkZx_  _xZkqqHx_iBgDiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiBgD_xHqqkZx_  _xZkqqHx_iBgDiEkIiEjPiEjPiEjPiEkIiBgD_xHqqkZx_  _xZkqqHx_iBgDiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_
//            _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_                _xZkqqHx_iEkA_xHqqkZx_
//            _xZkqqHx_iEkF_xHqqkZx_DWORD _xZkqqHx_iEkJ_xHqqkZx_DWORD _xZkqqHx_iEkJ_xHqqkZx_DWORD _xZkqqHx_iEkJiEjPiEjPiEjPiEjPiEkJ_xHqqkZx_DWORD _xZkqqHx_iEkJ_xHqqkZx_DWORD _xZkqqHx_iEkJ_xHqqkZx_DWORD _xZkqqHx_iEkJiEjPiEjPiEjPiEjPiEkJ_xHqqkZx_DWORD _xZkqqHx_iEkH_xHqqkZx_                _xZkqqHx_iEkA_xHqqkZx_
//            _xZkqqHx_iEkA_xHqqkZx_                                _xZkqqHx_iEkA_xHqqkZx_                                _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_                _xZkqqHx_iEkA_xHqqkZx_
//            _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEjPiEjP_xHqqkZx_Size1 _xZkqqHx_iEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEjPiEjPiEjP_xHqqkZx_Size2 _xZkqqHx_iEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkH_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_                _xZkqqHx_iEkA_xHqqkZx_
//            _xZkqqHx_iEkA_xHqqkZx_                                                                          _xZkqqHx_iEkA_xHqqkZx_                _xZkqqHx_iEkA_xHqqkZx_
//            _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjP_xHqqkZx_ BufSiz _xZkqqHx_iEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkH_xHqqkZx_                _xZkqqHx_iEkA_xHqqkZx_
//            _xZkqqHx_iEkA_xHqqkZx_                                                                                            _xZkqqHx_iEkA_xHqqkZx_
//            _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjP_xHqqkZx_ File Size -_xZkqqHx_iEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
//
//
// _xZkqqHx_iDiBiDiCiDiKiBfLiDhBiBfLiDhGiDgPiDgCiDhEiDeAiCmMiNfMjBkC_xHqqkZx_
//
//          m_pHeapBuffer
//                _xZkqqHx_iEkA_xHqqkZx_
//                _xZkqqHx_iBkL_xHqqkZx_
//              HeapTop                                                         LastSegmentEnd
//                _xZkqqHx_iEkA_xHqqkZx_                                                                  _xZkqqHx_iEkA_xHqqkZx_    HeapEnd
//                _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEjPiEjP_xHqqkZx_1Segment_xZkqqHx_iEjPiEjPiEjPiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEjPiEjPiEjP_xHqqkZx_1Segment_xZkqqHx_iEjPiEjPiEjPiEjPiEjPiEjPiEkH_xHqqkZx_      _xZkqqHx_iBkL_xHqqkZx_
//        _xZkqqHx_iEkBiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiBgD_xHqqkZx_  _xZkqqHx_iBgDiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiBgD_xHqqkZx_  _xZkqqHx_iBgDiEkGiEjPiEjPiEjPiEkGiBgD_xHqqkZx_  _xZkqqHx_iBgDiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
//        _xZkqqHx_iEkA_xHqqkZx_BufSiz_xZkqqHx_iEkA_xHqqkZx_Size1 _xZkqqHx_iEkA_xHqqkZx_RefCnt_xZkqqHx_iEkA_xHqqkZx_DataId_xZkqqHx_iEkA_xHqqkZx_  Data  _xZkqqHx_iEkA_xHqqkZx_Size2 _xZkqqHx_iEkA_xHqqkZx_RefCnt_xZkqqHx_iEkA_xHqqkZx_DataId_xZkqqHx_iEkA_xHqqkZx_  Data  _xZkqqHx_iEkA_xHqqkZx_  0   _xZkqqHx_iEkA_xHqqkZx_        JUNK    _xZkqqHx_iEkA_xHqqkZx_
//        _xZkqqHx_iEkEiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiBgD_xHqqkZx_  _xZkqqHx_iBgDiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiBgD_xHqqkZx_  _xZkqqHx_iBgDiEkIiEjPiEjPiEjPiEkIiBgD_xHqqkZx_  _xZkqqHx_iBgDiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_
//        _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_                _xZkqqHx_iEkA_xHqqkZx_
//        _xZkqqHx_iEkF_xHqqkZx_DWORD _xZkqqHx_iEkJ_xHqqkZx_DWORD _xZkqqHx_iEkJ_xHqqkZx_DWORD _xZkqqHx_iEkJ_xHqqkZx_DWORD _xZkqqHx_iEkJiEjPiEjPiEjPiEjPiEkJ_xHqqkZx_DWORD _xZkqqHx_iEkJ_xHqqkZx_DWORD _xZkqqHx_iEkJ_xHqqkZx_DWORD _xZkqqHx_iEkJiEjPiEjPiEjPiEjPiEkJ_xHqqkZx_DWORD _xZkqqHx_iEkH_xHqqkZx_                _xZkqqHx_iEkA_xHqqkZx_
//                _xZkqqHx_iEkA_xHqqkZx_                                _xZkqqHx_iEkA_xHqqkZx_                                _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_                _xZkqqHx_iEkA_xHqqkZx_
//                _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEjPiEjP_xHqqkZx_Size1 _xZkqqHx_iEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEjPiEjPiEjP_xHqqkZx_Size2 _xZkqqHx_iEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkH_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_                _xZkqqHx_iEkA_xHqqkZx_
//                _xZkqqHx_iEkA_xHqqkZx_                                                                          _xZkqqHx_iEkA_xHqqkZx_                _xZkqqHx_iEkA_xHqqkZx_
//                _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjP_xHqqkZx_ BufSiz _xZkqqHx_iEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkH_xHqqkZx_                _xZkqqHx_iEkA_xHqqkZx_
//                _xZkqqHx_iEkA_xHqqkZx_                                                                                            _xZkqqHx_iEkA_xHqqkZx_
//                _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjP_xHqqkZx_ FD_MEMORY_HEAP_SIZE -_xZkqqHx_iEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
//
//

//----- 06.04.10 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///////////////////////////////////////////////////////////////////////////////
//// FCTmpDir
//
///*************************************************************************
// * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCTmpDir
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhBiBfLiDhGiCmFiCmNiDiPiBfLiDeOiDhEiDeAiDeDiDiLiCpAjFkBjAjEiNoMjAkMiClHiCoJiCkKiBeBiClLiCmMiDiPiBfLiDeOiDhEiDeAiDeDiDiLiCpA_xHqqkZx_
// *			_xZkqqHx_iCnMiCmGiCnPiCmEiIoKiCmCiCmMiDgGiDeCiDiMiDeOiDgHiDiKiCmFiKmHjHjNiClHiCoJiClNiCnPiCmJiBeBiDiPiBfLiDeOiDgGiDeCiDiMiDeOiDgHiDiK_xHqqkZx_
// *			_xZkqqHx_iCpAiIoKiCmCiNoMjAkMiBeFiNoNiPjMiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//class FCTmpDir
//{
//public:
//	FCTmpDir ();
//	~FCTmpDir ();
//	const WString& GetTmpDir () const;
//
//protected:
//	WString	m_wstrTmpDir;
//	HANDLE	m_hFile;
//}; // FCTmpDir.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCTmpDir::FCTmpDir
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//FCTmpDir::FCTmpDir ()
//		:m_hFile(INVALID_HANDLE_VALUE)
//{
//	for (int i = 0;i != 10; i++)
//	{
//		WString wstrUniqPath;
//		FFMakeUniqTmpFileName(wstrUniqPath, L"_Dyn", FD_FILE_EXT_HEAP);
//		if (FFRecursiveCreateDirectory(NULL, wstrUniqPath))
//		{
//			m_wstrTmpDir = wstrUniqPath;
//			break;
//		}
//	}
//	if (m_wstrTmpDir.IsEmpty())
//		FFThrowMiscUnknown();
//
//	if (FFVersionInfo().dwPlatformId == VER_PLATFORM_WIN32_NT)
//	//----- WindowsNT_xZkqqHx_iMgOiCmMiPoKiNiH_xHqqkZx_ ------
//	{
//		// _xZkqqHx_iNoMjAkMiClDiCoKiCoJiDgGiDeCiDiMiDeOiDgHiDiKiCpAiKeKiCkNiBeC_xHqqkZx_
//		// FILE_SHARE_DELETE _xZkqqHx_iCpAjAnNjCoIiClFiCmIiCkCiCmMiCmFiBeBiDgGiDeCiDiMiDeOiDgHiDiKiCmMiNoNiPjMiCkKiCmFiCkLiCmIiCkCiBeC_xHqqkZx_
//		m_hFile = ::CreateFile(	WStrToTStr(m_wstrTmpDir),
//								FILE_LIST_DIRECTORY,					// _xZkqqHx_iDeBiDeOiDfKiDfIiBgJ_xHqqkZx_ _xZkqqHx_jDmHiCnNiPjBiCkLiBgKiDiCiBfLiDgI_xHqqkZx_
//								FILE_SHARE_READ|FILE_SHARE_WRITE,		// _xZkqqHx_iLkEjHeMiDiCiBfLiDgI_xHqqkZx_
//								NULL,									// _xZkqqHx_iDfKiDeMiDiFiDiKiDgFiDeCiLeMiPhBiOhB_xHqqkZx_
//								OPEN_EXISTING,							// _xZkqqHx_iNoMjAkMjFpLjGeA_xHqqkZx_
//								FILE_FLAG_BACKUP_SEMANTICS,				// _xZkqqHx_iDhEiDeAiDeDiDiLjBkOjAkL_xHqqkZx_
//								NULL);									// _xZkqqHx_iDfCiDhDiBfLiClHiCoJiDhEiDeAiDeDiDiLiCmGjBkOjAkL_xHqqkZx_
//		if (m_hFile == INVALID_HANDLE_VALUE)
//			FFThrowMiscUnknown();
//	} else
//	//----- Windows95_xZkqqHx_iMgOiCmMiPoKiNiH_xHqqkZx_ -----
//	{
//		// 95_xZkqqHx_iMgO_xHqqkZx_OS_xZkqqHx_iCmFiCmNiDgGiDeCiDiMiDeOiDgHiDiKiCpAiKeKiCkNiClBiCmGiCmNiPgPjHiIiCmIiCkCiBeC_xHqqkZx_
//		// _xZkqqHx_jBoDiCoNiCoIiCmJ_xHqqkZx_ .lock _xZkqqHx_iDhEiDeAiDeDiDiLiCpAiNoMjAkMiClFiCmEjEpBiLkEjHeMiCmFiKeKiCkNiBeC_xHqqkZx_
//		m_hFile = ::CreateFile(	WStrToTStr(m_wstrTmpDir + L"\\.lock"),
//								GENERIC_READ|GENERIC_WRITE,				// _xZkqqHx_iDeBiDeOiDfKiDfIiBgJ_xHqqkZx_ _xZkqqHx_jDmHiCnNiPjBiCkLiBgKiDiCiBfLiDgI_xHqqkZx_
//								0,										// _xZkqqHx_iLkEjHeMiDiCiBfLiDgI_xHqqkZx_
//								NULL,									// _xZkqqHx_iDfKiDeMiDiFiDiKiDgFiDeCiLeMiPhBiOhB_xHqqkZx_
//								CREATE_NEW,								// _xZkqqHx_iNoMjAkMjFpLjGeA_xHqqkZx_
//								FILE_ATTRIBUTE_NORMAL,					// _xZkqqHx_iDhEiDeAiDeDiDiLjBkOjAkL_xHqqkZx_
//								NULL);									// _xZkqqHx_iDfCiDhDiBfLiClHiCoJiDhEiDeAiDeDiDiLiCmGjBkOjAkL_xHqqkZx_
//		if (m_hFile == INVALID_HANDLE_VALUE)
//			FFThrowMiscUnknown();
//	}
//} // FCTmpDir::FCTmpDir.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCTmpDir::~FCTmpDir
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//FCTmpDir::~FCTmpDir ()
//{
//	// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCmMiDgOiDjDiDgIiDiLiCpAjFmCiClGiCoJiBeC_xHqqkZx_
//	::CloseHandle(m_hFile);
//	m_hFile = INVALID_HANDLE_VALUE;
//	FFRecursiveRemoveDirectory(m_wstrTmpDir);
//} // FCTmpDir::~FCTmpDir.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCTmpDir::GetTmpDir
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiPiBfLiDeOjHhAiDgGiDeCiDiMiDeOiDgHiDiKiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiPiBfLiDeOjHhAiDgGiDeCiDiMiDeOiDgHiDiKiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiPiBfLiDeOjHhAiDgGiDeCiDiMiDeOiDgHiDiKiCmNiBeB_xHqqkZx_TMP_xZkqqHx_iKmCiLkLjFmPjAjEiCmFiOhHjCoIiClDiCoKiClNiDgGiDeCiDiMiDeOiDgHiDiKiCmJ_xHqqkZx_
// *			_xZkqqHx_iNoMjAkMiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//const WString& FCTmpDir::GetTmpDir () const
//{
//	return m_wstrTmpDir;
//} // FCTmpDir::GetTmpDir.
//----- 06.04.10 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

struct S_HEAPBUFFER
{
	S_HEAPBUFFER () : s_TmpDir(FD_FILE_EXT_HEAP) {}
	FCWorkDir s_TmpDir;
}; // struct S_HEAPBUFFER.

typedef FCCsAreaRead<S_HEAPBUFFER>		s0_read;
typedef FCCsAreaWrite<S_HEAPBUFFER>		s0_write;
typedef FCCsAreaReadWrite<S_HEAPBUFFER>	s0_readwrite;

static FCCsAreaDef<S_HEAPBUFFER> s_0;

/////////////////////////////////////////////////////////////////////////////
// FCHeapBuffer

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHeapBuffer::FCHeapBuffer
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	byHeapBufferType	:_xZkqqHx_iDhBiBfLiDhGiDgPiDgCiDhEiDeAiCmMiDfOiDeDiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
 *				FD_BUFFER_TYPE_MEMORY	:_xZkqqHx_iDiBiDiCiDiKiBfLiDfOiDeDiDhGiCmMiDhBiBfLiDhGiDgPiDgCiDhEiDeAiBeC_xHqqkZx_
 *				FD_BUFFER_TYPE_FILE		:_xZkqqHx_iDhEiDeAiDeDiDiLiDfOiDeDiDhGiCmMiDhBiBfLiDhGiDgPiDgCiDhEiDeAiBeC_xHqqkZx_
 *			pHeapBuffer			:_xZkqqHx_iDhBiBfLiDhGiDgPiDgCiDhEiDeAiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCHeapBuffer::FCHeapBuffer (BYTE byHeapBufferType, void* pHeapBuffer)
{
//----- 05.12.14 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if (byHeapBufferType == FD_BUFFER_TYPE_MEMORY)
//	//----- _xZkqqHx_iDiBiDiCiDiKiBfLiDgPiDgCiDhEiDeAiCmMiPoKiNiH_xHqqkZx_ -----
//	{
//		GetMemoryBuffer() = (BYTE*)pHeapBuffer;
//		m_hFileBuffer = INVALID_HANDLE_VALUE;
//	} else
//	//----- _xZkqqHx_iDhEiDeAiDeDiDiLiDgPiDgCiDhEiDeAiCmMiPoKiNiH_xHqqkZx_ -----
//	{
//		GetMemoryBuffer() = NULL;
//		FileTypeRec* my = (FileTypeRec*)pHeapBuffer;
//		m_hFileBuffer = my->m_hFile;
//	}
//----- 05.12.14 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	m_byHeapBufferType = byHeapBufferType;
	m_pHeapBuffer = pHeapBuffer;
//----- 05.12.14 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCHeapBuffer::FCHeapBuffer.

//----- 05.12.14 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHeapBuffer::~FCHeapBuffer
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//FCHeapBuffer::~FCHeapBuffer ()
//{
//	GetMemoryBuffer() = NULL;
//	m_hFileBuffer = INVALID_HANDLE_VALUE;
//} // FCHeapBuffer::~FCHeapBuffer.
//----- 05.12.14 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHeapBuffer::GetHeapBufferType
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgPiDgCiDhEiDeAiDfOiDeDiDhGiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgPiDgCiDhEiDeAiDfOiDeDiDhGiBeC_xHqqkZx_
 *				FD_BUFFER_TYPE_MEMORY	:_xZkqqHx_iDiBiDiCiDiKiBfLiDfOiDeDiDhGiCmMiDhBiBfLiDhGiDgPiDgCiDhEiDeAiBeC_xHqqkZx_
 *				FD_BUFFER_TYPE_FILE		:_xZkqqHx_iDhEiDeAiDeDiDiLiDfOiDeDiDhGiCmMiDhBiBfLiDhGiDgPiDgCiDhEiDeAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BYTE FCHeapBuffer::GetHeapBufferType () const
{
//----- 05.12.14 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if (GetMemoryBuffer() != NULL)
//		return FD_BUFFER_TYPE_MEMORY;
//	else
//		return FD_BUFFER_TYPE_FILE;
//----- 05.12.14 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	return m_byHeapBufferType;
//----- 05.12.14 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCHeapBuffer::GetHeapBufferType.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHeapBuffer::GetRestBufferSize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgPiDgCiDhEiDeAiCmMiOgDiCoIiDfEiDeDiDfJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgPiDgCiDhEiDeAiCmMiOgDiCoIiDfEiDeDiDfJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD FCHeapBuffer::GetRestBufferSize ()
{
	// _xZkqqHx_iNmFjBoFiCmMiDgPiDgCiDhEiDeAiDfEiDeDiDfJiCkJiCoHiBeBiMlLiNnNiCmMiDgPiDgCiDhEiDeAiDfEiDeDiDfJiCpAiPjMiCkNiBeC_xHqqkZx_
	return GetMaxBufferSize(GetHeapBufferType()) - GetBufferSize();
} // FCHeapBuffer::GetRestBufferSize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHeapBuffer::GetRestDataSize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgPiDgCiDhEiDeAiCmFiBeBiNoMjAkMiClFjDlOiCoJiDgGiBfLiDfOiCmMiNmFjBoFiDfEiDeDiDfJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNmFjBoFiDfEiDeDiDfJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD FCHeapBuffer::GetRestDataSize ()
{
	// _xZkqqHx_iOgDiCoIiDgPiDgCiDhEiDeAiDfEiDeDiDfJiCkJiCoHiDhHiDgCiDfPjFjEjFkKiCpAiPjMiCkCiClNiDfEiDeDiDfJiBeC_xHqqkZx_
	// _xZkqqHx_jCeBiClFiBeBiOgDiCoIiDgPiDgCiDhEiDeAiDfEiDeDiDfJiCkKiDhHiDgCiDfPjFjEjFkKiCoGiCoIiPkMiClDiCkCiPoKiNiHiCmNiCePiCpAjFnEiClHiBeC_xHqqkZx_
	if (GetRestBufferSize() < (FD_HEAP_SIZE_SIZE + FD_HEAP_REF_COUNT_SIZE + FD_HEAP_DATA_ID_SIZE))
		return 0;
	else
		return GetRestBufferSize() - (FD_HEAP_SIZE_SIZE + FD_HEAP_REF_COUNT_SIZE + FD_HEAP_DATA_ID_SIZE);
} // FCHeapBuffer::GetRestDataSize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHeapBuffer::IsEmpty
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgPiDgCiDhEiDeAiCkKiLpDiCkJiCmHiCkEiCkJjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iLpDiCmMiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCHeapBuffer::IsEmpty ()
{
	return (GetBufferSize() == FD_HEAP_SIZE_SIZE);
} // FCHeapBuffer::IsEmpty.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHeapBuffer::AllocateSegment
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iLpDiCmMiDfKiDePiDiBiDjDiDgHiCpAiIoKiCmCiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwDataSize	:_xZkqqHx_iDfKiDePiDiBiDjDiDgHiCmJjFnLjBlGiClHiCoJiDgGiBfLiDfOiCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfKiDePiDiBiDjDiDgHiImKjChFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDfKiDePiDiBiDjDiDgHiCmNiJlKjAhNiCmMiNfMjBkCiCpAiClFiCmEiCkCiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iNoMjAkMiClDiCoKiClNiDfKiDePiDiBiDjDiDgHiCmMjAoGjDkKiImKjChFiBgJiDgPiDgCiDhEiDeAjAoGjDkKiCkJiCoHiCmMiDeJiDhEiDfKiDgCiDgHiBgK_xHqqkZx_
 *			_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 *         _xZkqqHx_iDfKiDePiDiBiDjDiDgHiImKjChF_xHqqkZx_
 *             _xZkqqHx_iEkA_xHqqkZx_
 *             _xZkqqHx_iEkJiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiBgD_xHqqkZx_  _xZkqqHx_iBgDiEkG_xHqqkZx_
 *             _xZkqqHx_iEkA_xHqqkZx_Size1 _xZkqqHx_iEkA_xHqqkZx_RefCnt_xZkqqHx_iEkA_xHqqkZx_DataId_xZkqqHx_iEkA_xHqqkZx_  Data  _xZkqqHx_iEkA_xHqqkZx_
 *             _xZkqqHx_iEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiBgD_xHqqkZx_  _xZkqqHx_iBgDiEkI_xHqqkZx_
 *             _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
 *             _xZkqqHx_iEkF_xHqqkZx_DWORD _xZkqqHx_iEkJ_xHqqkZx_DWORD _xZkqqHx_iEkJ_xHqqkZx_DWORD _xZkqqHx_iEkJiEjPiEjPiEjPiEjPiEkJ_xHqqkZx_
 *             _xZkqqHx_iEkA_xHqqkZx_                                _xZkqqHx_iEkA_xHqqkZx_
 *             _xZkqqHx_iEkJiEjPiEjPiEjPiEjPiEjPiEjP_xHqqkZx_Size1 _xZkqqHx_iEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkJ_xHqqkZx_
 *  
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD FCHeapBuffer::AllocateSegment (DWORD dwDataSize)
{
	// _xZkqqHx_iOhHjCoIiClDiCoKiClNiDgGiBfLiDfOiDfEiDeDiDfJiCmJiDhHiDgCiDfPiDfEiDeDiDfJiCpAiJmBiOfKiClFiBeBiDfKiDePiDiBiDjDiDgHiCmF_xHqqkZx_
	// _xZkqqHx_jFeLjHhGiCmIiDfEiDeDiDfJiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
	const DWORD dwSegmentSize = dwDataSize + (FD_HEAP_SIZE_SIZE + FD_HEAP_REF_COUNT_SIZE + FD_HEAP_DATA_ID_SIZE);
	// _xZkqqHx_iPeJjCfLiDfKiDePiDiBiDjDiDgHiCmMiImKjChFiCpAiOfKiPgPiBeC_xHqqkZx_
	const DWORD dwLastSegmentPosition = GetBufferSize() - FD_HEAP_SIZE_SIZE;
	// _xZkqqHx_iDgPiDgCiDhEiDeAiDfEiDeDiDfJiCpAiKgHjCkDiClHiCoJiBeC_xHqqkZx_
	SetBufferSize(GetBufferSize() + dwSegmentSize);
	// _xZkqqHx_iNmFiMoDiCmMiDfKiDePiDiBiDjDiDgHiCmJiBeBiDfKiDePiDiBiDjDiDgHiDfEiDeDiDfJiCpAjAnNjCoIiBeC_xHqqkZx_
	SetSegmentSize(dwLastSegmentPosition, dwSegmentSize);
	// _xZkqqHx_iNmFiMoDiCmMiDfKiDePiDiBiDjDiDgHiCmJiBeBiOfBiPmGiDeKiDeFiDjDiDfOiCpAjAnNjCoIiBeC_xHqqkZx_
	SetReferenceCount(dwLastSegmentPosition, 0);
	// _xZkqqHx_iPeJjCfLiDfKiDePiDiBiDjDiDgHiCpAjAnNjCoIiBeC_xHqqkZx_
	SetSegmentSize(dwLastSegmentPosition + dwSegmentSize, 0);
	return dwLastSegmentPosition;
} // FCHeapBuffer::AllocateSegment.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHeapBuffer::FreeSegment
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDfKiDePiDiBiDjDiDgHiCpAiJpAjFpKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDfKiDePiDiBiDjDiDgHiJpAjFpKiCmNiBeBiOfBiPmGiDeKiDeFiDjDiDfOiCpAiCePiCmJiClHiCoJiClOiCkPiBeC_xHqqkZx_
 *			_xZkqqHx_iDgPiDgCiDhEiDeAiCmMiPeJiCoNiCoIiCnMiCmFiDfKiDePiDiBiDjDiDgHiCkKiLpDiCmIiCoHiCmOiBeBiDgPiDgCiDhEiDeAiDfEiDeDiDfJiCpA_xHqqkZx_
 *			_xZkqqHx_iPgLiPkMiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDgPiDgCiDhEiDeAjDhCjCiGiCmMiDfKiDePiDiBiDjDiDgHiCpAiJpAjFpKiCmMiPoKiNiHiBeBiDgPiDgCiDhEiDeAiDfEiDeDiDfJiCpAiPgLiPkM_xHqqkZx_
 *			_xZkqqHx_iClHiCoJiCmJiCmNiBeB_xHqqkZx_Reduce_xZkqqHx_iKnGjAjEiCpAiOgHiCkEjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHeapBuffer::FreeSegment (DWORD dwSegmentPosition)
{
	// _xZkqqHx_iOfBiPmGiDeKiDeFiDjDiDfOiCpAiCePiCmJiBeC_xHqqkZx_
	SetReferenceCount(dwSegmentPosition, 0);
	// _xZkqqHx_iDgPiDgCiDhEiDeAiNmFiMoDiCnMiCmFiLpDiCmMiDfKiDePiDiBiDjDiDgHiCkKjBlBiCkCiCmEiCkCiCoJiCkJjClCiCnHiCoJiBeC_xHqqkZx_
	// _xZkqqHx_jBlBiCkCiCmEiCkCiCoJiPoKiNiHiCmNiBeBiDgPiDgCiDhEiDeAiDfEiDeDiDfJiCpAiPgLiPkMiClHiCoJiBeC_xHqqkZx_
	DWORD dwNextSegmentPosition = dwSegmentPosition;
	BOOL bNotRefered = TRUE;
	while (GetNextSegment(dwNextSegmentPosition) && bNotRefered)
		bNotRefered = (GetReferenceCount(dwNextSegmentPosition) == 0);
	if (bNotRefered)
	//----- _xZkqqHx_jHmMiIoGiNmFiMoDiCnMiCmFiDfKiDePiDiBiDjDiDgHiCmNiLpDiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// dwSegmentPosition_xZkqqHx_iImKjChFiCmJiPeJjCfLiCpAjAnNjCoIiBeC_xHqqkZx_
		SetSegmentSize(dwSegmentPosition, 0);
		// _xZkqqHx_iDgPiDgCiDhEiDeAiDfEiDeDiDfJiCpAjAnNjCoIiBeC_xHqqkZx_
		SetBufferSize(dwSegmentPosition + FD_HEAP_SIZE_SIZE);
	}
} // FCHeapBuffer::FreeSegment.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHeapBuffer::Reduce
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgPiDgCiDhEiDeAiCmJiCkIiCkCiCmEiBeBiOhHjCoIiClDiCoKiClNiDfKiDePiDiBiDjDiDgHiImIiNhOiBgJiClLiCoKiCpAiKnMiCnOiBgK_xHqqkZx_
 *			_xZkqqHx_iCmMiDfKiDePiDiBiDjDiDgHiCmFiOgHiCoNiCoKiCmEiCkCiCmIiCkCiCoAiCmMiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwSegmentPosition	:_xZkqqHx_iDfKiDePiDiBiDjDiDgHiPgLiPkMiCmMiKeKiOgOiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iOfBiPmGiDeKiDeFiDjDiDfOiBiBiCePiCmMiDfKiDePiDiBiDjDiDgHiCpAiPgLiPkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHeapBuffer::Reduce (DWORD dwSegmentPosition)
{
	// _xZkqqHx_iDfCiDhDiBfLjAoGiCmMiDfKiDePiDiBiDjDiDgHiImKjChFiBeC_xHqqkZx_
	DWORD dwSegmentTo = dwSegmentPosition;
	// _xZkqqHx_iDfKiDePiDiBiDjDiDgHiImKjChFiCpAiBeBiOfBiPmGiDeKiDeFiDjDiDfOiBiBiBiBiCePiCmMiDfKiDePiDiBiDjDiDgHiCnMiCmFjBjHiCoJiBeC_xHqqkZx_
	for (;;)
	{
		// _xZkqqHx_iDfKiDePiDiBiDjDiDgHiCmMiOfBiPmGiDeKiDeFiDjDiDfOiBiBiBiBiCePiCmIiCoHiCmOiDiLiBfLiDhGiCpAjElCiCkPiCoJiBeC_xHqqkZx_
		if (GetReferenceCount(dwSegmentTo) == 0) break;
		// _xZkqqHx_iDfKiDePiDiBiDjDiDgHiCpAiOjPiCnGiBeCiPeJjCfLiCmJjCeCiClFiClNiPoKiNiHiCmNiPiIjHjNiCpAiPeJjHlJiBeC_xHqqkZx_
		if (!GetNextSegment(dwSegmentTo))
			return;
	}

	// _xZkqqHx_iDfCiDhDiBfLiMlDiCmMiDfKiDePiDiBiDjDiDgHiImKjChFiBeC_xHqqkZx_
	DWORD dwSegmentFrom = dwSegmentTo;
	for (;;)
	{
		// _xZkqqHx_iDfCiDhDiBfLiMlDiCmMiDfKiDePiDiBiDjDiDgHiImKjChFiCpAiBeBiOfBiPmGiDeKiDeFiDjDiDfOiBeJiBiBiCePiCmM_xHqqkZx_
		// _xZkqqHx_iDfKiDePiDiBiDjDiDgHiCnMiCmFjBjHiCoJiBeC_xHqqkZx_
		for (;;)
		{
			// _xZkqqHx_iDfCiDhDiBfLiMlDiDfKiDePiDiBiDjDiDgHiCkKiPeJjCfLiCmJjCeCiClFiClNiPoKiNiHiCmN_xHqqkZx_
			// _xZkqqHx_iDiLiBfLiDhGiCpAjElCiCkPiCoJiBeC_xHqqkZx_
			if (GetSegmentSize(dwSegmentFrom) == 0)
			{
				dwSegmentFrom = DWORD(-1);
				break;
			}
			// _xZkqqHx_iDfCiDhDiBfLiMlDiDfKiDePiDiBiDjDiDgHiCmMiOfBiPmGiDeKiDeFiDjDiDfOiBeJiBiBiCePiCmIiCoHiCmO_xHqqkZx_
			// _xZkqqHx_iDiLiBfLiDhGiCpAjElCiCkPiCoJiBeC_xHqqkZx_
			if (GetReferenceCount(dwSegmentFrom) != 0) break;
			// _xZkqqHx_iDfCiDhDiBfLiMlDiDfKiDePiDiBiDjDiDgHiCpAiOjPiCnGiBeC_xHqqkZx_
			GetNextSegment(dwSegmentFrom);
		}
		// _xZkqqHx_iDfCiDhDiBfLiMlDiDfKiDePiDiBiDjDiDgHiCkKiPeJjCfLiCmJjCeCiClFiClNiPoKiNiHiCmNiDiLiBfLiDhGiCpAjElCiCkPiCoJiBeC_xHqqkZx_
		if (dwSegmentFrom == DWORD(-1))
			break;
		//----- _xZkqqHx_iDfCiDhDiBfLiMlDiDfKiDePiDiBiDjDiDgHiCkKiPeJjCfLiCmJjCeCiClFiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		// _xZkqqHx_iCfAiDfKiDePiDiBiDjDiDgHiCpAiDfCiDhDiBfLiBeC_xHqqkZx_
		DWORD dwSegmentSize = CopySegment(dwSegmentTo, dwSegmentFrom);
		// _xZkqqHx_iDfCiDhDiBfLiMlDiBeBiDfCiDhDiBfLjAoGiCmMiImKjChFiCpAiClIiCoHiClHiBeC_xHqqkZx_
		dwSegmentFrom += dwSegmentSize;
		dwSegmentTo += dwSegmentSize;
	}
	// _xZkqqHx_iPeJjCfLiDfKiDePiDiBiDjDiDgHiCpAjAnNjCoIiBeC_xHqqkZx_
	SetSegmentSize(dwSegmentTo, 0);
	// _xZkqqHx_iDgPiDgCiDhEiDeAiDfEiDeDiDfJiCpAjAnNjCoIiBeC_xHqqkZx_
	SetBufferSize(dwSegmentTo + FD_HEAP_SIZE_SIZE);
} // FCHeapBuffer::Reduce.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHeapBuffer::GetNextSegment
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDfKiDePiDiBiDjDiDgHiImKjChFiCmMiOjPiCmMiDfKiDePiDiBiDjDiDgHiImKjChFiCpAiOfKiPgPiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwSegmentPosition	:_xZkqqHx_iDfKiDePiDiBiDjDiDgHiImKjChFiCpAiOhHjCoIiBeCiOjPiCmMiImKjChFiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPeJjCfLiCmJjCeCiClFiClNiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCHeapBuffer::GetNextSegment (DWORD& dwSegmentPosition)
{
	DWORD dwSegmentSize = GetSegmentSize(dwSegmentPosition);
	if (dwSegmentSize == 0)
	//----- _xZkqqHx_iKpJiCmJiPeJjCfLiCmJiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
		return FALSE;
	} else
	//----- _xZkqqHx_jGkCiClOiPeJjCfLiCmFiCmNiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		dwSegmentPosition += dwSegmentSize;
		// _xZkqqHx_iPeJjCfLiCmJjCeCiClFiClNiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
		return (GetSegmentSize(dwSegmentPosition) != 0);
	}
} // FCHeapBuffer::GetNextSegment.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHeapBuffer::GetBufferSize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgPiDgCiDhEiDeAiCmMiDfEiDeDiDfJiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgPiDgCiDhEiDeAiCmMiDfEiDeDiDfJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD FCHeapBuffer::GetBufferSize ()
{
	if (GetHeapBufferType() == FD_BUFFER_TYPE_MEMORY)
	//----- _xZkqqHx_iDiBiDiCiDiKiBfLiDgPiDgCiDhEiDeAiCmMiPoKiNiH_xHqqkZx_ -----
	{
		DWORD dwBufferSize;
		memcpy(&dwBufferSize, GetMemoryBuffer() - sizeof(DWORD), sizeof(dwBufferSize));
		return dwBufferSize;
	} else
	//----- _xZkqqHx_iDhEiDeAiDeDiDiLiDgPiDgCiDhEiDeAiCmMiPoKiNiH_xHqqkZx_ -----
	{
//----- 05.12.14 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		return GetFileSize(GetFileBuffer(), NULL);
//----- 05.12.14 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		FileTypeRec* my = (FileTypeRec*)m_pHeapBuffer;
		return my->m_dwBufferSize;
//----- 05.12.14 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	}
} // FCHeapBuffer::GetBufferSize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHeapBuffer::GetSegmentSize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDfKiDePiDiBiDjDiDgHiCmMiDfEiDeDiDfJiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwSegmentPosition	:_xZkqqHx_iDfKiDePiDiBiDjDiDgHiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfKiDePiDiBiDjDiDgHiDfEiDeDiDfJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD FCHeapBuffer::GetSegmentSize (DWORD dwSegmentPosition) const
{
	DWORD dwSegmentSize;
	Read(dwSegmentPosition, &dwSegmentSize, sizeof(dwSegmentSize));
	return dwSegmentSize;
} // FCHeapBuffer::GetSegmentSize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHeapBuffer::GetReferenceCount
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOfBiPmGiDeKiDeFiDjDiDfOiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwSegmentPosition	:_xZkqqHx_iDfKiDePiDiBiDjDiDgHiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOfBiPmGiDeKiDeFiDjDiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD FCHeapBuffer::GetReferenceCount (DWORD dwSegmentPosition)
{
	DWORD dwReferenceCount;
	Read(dwSegmentPosition + FD_HEAP_SIZE_SIZE, &dwReferenceCount, sizeof(dwReferenceCount));
	return dwReferenceCount;
} // FCHeapBuffer::GetReferenceCount.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHeapBuffer::SetReferenceCount
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOfBiPmGiDeKiDeFiDjDiDfOiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwSegmentPosition	:_xZkqqHx_iDfKiDePiDiBiDjDiDgHiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwReferenceCount	:_xZkqqHx_jAnNjCoIiClHiCoJiOfBiPmGiDeKiDeFiDjDiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHeapBuffer::SetReferenceCount (DWORD dwSegmentPosition, DWORD dwReferenceCount)
{
	Write(dwSegmentPosition + FD_HEAP_SIZE_SIZE, &dwReferenceCount, sizeof(dwReferenceCount));
} // FCHeapBuffer::SetReferenceCount.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHeapBuffer::GetDataId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiBfLiDfO_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwSegmentPosition	:_xZkqqHx_iDfKiDePiDiBiDjDiDgHiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgGiBfLiDfO_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD FCHeapBuffer::GetDataId (DWORD dwSegmentPosition)
{
	DWORD dwDataId;
	Read(dwSegmentPosition + FD_HEAP_SIZE_SIZE + FD_HEAP_REF_COUNT_SIZE, &dwDataId, sizeof(dwDataId));
	return dwDataId;
} // FCHeapBuffer::GetDataId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHeapBuffer::SetDataId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiBfLiDfO_xHqqkZx_ID_xZkqqHx_iCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwSegmentPosition	:_xZkqqHx_iDfKiDePiDiBiDjDiDgHiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwDataId			:_xZkqqHx_jAnNjCoIiClHiCoJiDgGiBfLiDfO_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHeapBuffer::SetDataId (DWORD dwSegmentPosition, DWORD dwDataId)
{
	Write(dwSegmentPosition + FD_HEAP_SIZE_SIZE + FD_HEAP_REF_COUNT_SIZE, &dwDataId, sizeof(dwDataId));
} // FCHeapBuffer::SetDataId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHeapBuffer::GetDataSize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiBfLiDfOiDfEiDeDiDfJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwSegmentPosition	:_xZkqqHx_iDfKiDePiDiBiDjDiDgHiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgGiBfLiDfOiDfEiDeDiDfJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD FCHeapBuffer::GetDataSize (DWORD dwSegmentPosition) const
{
	return GetSegmentSize(dwSegmentPosition) - (FD_HEAP_SIZE_SIZE + FD_HEAP_REF_COUNT_SIZE + FD_HEAP_DATA_ID_SIZE);
} // FCHeapBuffer::GetDataSize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHeapBuffer::GetData
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiBfLiDfOiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwSegmentPosition	:_xZkqqHx_iDfKiDePiDiBiDjDiDgHiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pDataBuffer			:_xZkqqHx_iDgGiBfLiDfOiCpAiOpDiCkPiOoGiCoJiDgPiDgCiDhEiDeAiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwBuffSize			:_xZkqqHx_iDgPiDgCiDhEiDeAiDfEiDeDiDfJiCpAiOhHjCoIiBeCjBfDiCmEiCmMiDgGiBfLiDfOiCpA_xHqqkZx_
 *								 _xZkqqHx_iOoGjDlOiClHiCoJiPoKiNiHiCmN_xHqqkZx_ DOWRD(-1) _xZkqqHx_iCpAiOhHjCoIiClFiCmEiCoAjHmHiCkCiBeC_xHqqkZx_
 *			dwStartOffset		:_xZkqqHx_iDgGiBfLiDfOiCpAjDmHiCnNiPgPiClHiKeKiOgOiImKjChFiCpAiOhHjCoIiBeCjHoBiCkGiCmO_xHqqkZx_0_xZkqqHx_iCpA_xHqqkZx_
 *								 _xZkqqHx_iOhHjCoIiClFiClNiPoKiNiHiCmNiDgPiDgCiDhEiDeAiNmFiPiJiCkJiCoHjDmHiCnNiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jDmHiCnNiPgPiClDiCoKiClNiDgGiBfLiDfOiDfEiDeDiDfJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD FCHeapBuffer::GetData (DWORD dwSegmentPosition, void* pDataBuffer, DWORD dwBuffSize, DWORD dwStartOffset)
{
	DWORD dwDataSize = GetDataSize(dwSegmentPosition) - dwStartOffset;
	if (dwBuffSize < dwDataSize)
		dwDataSize = dwBuffSize;
	Read(dwSegmentPosition + FD_HEAP_SIZE_SIZE + FD_HEAP_REF_COUNT_SIZE + FD_HEAP_DATA_ID_SIZE + dwStartOffset,
		pDataBuffer, dwDataSize);
	return dwDataSize;
} // FCHeapBuffer::GetData.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHeapBuffer::SetData
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiBfLiDfOiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwSegmentPosition	:_xZkqqHx_iDfKiDePiDiBiDjDiDgHiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pData				:_xZkqqHx_iDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwDataSize			:_xZkqqHx_iDgGiBfLiDfOiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHeapBuffer::SetData (DWORD dwSegmentPosition, const void* pData)
{
	DWORD dwDataSize = GetDataSize(dwSegmentPosition);
	Write(dwSegmentPosition + FD_HEAP_SIZE_SIZE + FD_HEAP_REF_COUNT_SIZE + FD_HEAP_DATA_ID_SIZE,
		pData, dwDataSize);
} // FCHeapBuffer::SetData.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHeapBuffer::Append
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgPiDgCiDhEiDeAiCpAiBeBiClBiCmMiDgPiDgCiDhEiDeAiCmMiPeJjCfLiCmJjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	heapBuffer	:_xZkqqHx_iDgPiDgCiDhEiDeAiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iJlKjAhNiCmMiCoGiCkEiCmJjDfNjBjHiClHiCoJiBeC_xHqqkZx_
 *
 *                    HeapTop                                                         dwWritePosition
 *                      _xZkqqHx_iBkL_xHqqkZx_                                                                  _xZkqqHx_iBkL_xHqqkZx_
 *                      _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjP_xHqqkZx_ GetBufferSize()_xZkqqHx_iEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *                      _xZkqqHx_iEkBiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiBgD_xHqqkZx_  _xZkqqHx_iBgDiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiBgD_xHqqkZx_  _xZkqqHx_iBgDiEkGiEjPiEjPiEjPiEkC_xHqqkZx_
 *      _xZkqqHx_jDfNjBjHjAoGiCmMiDgPiDgCiDhEiDeAiEkA_xHqqkZx_Size1 _xZkqqHx_iEkA_xHqqkZx_RefCnt_xZkqqHx_iEkA_xHqqkZx_DataId_xZkqqHx_iEkA_xHqqkZx_  Data  _xZkqqHx_iEkA_xHqqkZx_Size2 _xZkqqHx_iEkA_xHqqkZx_RefCnt_xZkqqHx_iEkA_xHqqkZx_DataId_xZkqqHx_iEkA_xHqqkZx_  Data  _xZkqqHx_iEkA_xHqqkZx_  0   _xZkqqHx_iEkA_xHqqkZx_
 *                      _xZkqqHx_iEkEiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiBgD_xHqqkZx_  _xZkqqHx_iBgDiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiBgD_xHqqkZx_  _xZkqqHx_iBgDiEkIiEjPiEjPiEjPiEkD_xHqqkZx_
 *                                                                                          _xZkqqHx_iBkK_xHqqkZx_
 *                      _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_
 *                      _xZkqqHx_iEkA_xHqqkZx_
 *                      _xZkqqHx_iEkBiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiBgD_xHqqkZx_  _xZkqqHx_iBgDiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkGiEjPiBgD_xHqqkZx_  _xZkqqHx_iBgDiEkGiEjPiEjPiEjPiEkC_xHqqkZx_
 *      _xZkqqHx_jDfNjBjHiMlDiCmMiDgPiDgCiDhEiDeAiEkA_xHqqkZx_Size1 _xZkqqHx_iEkA_xHqqkZx_RefCnt_xZkqqHx_iEkA_xHqqkZx_DataId_xZkqqHx_iEkA_xHqqkZx_  Data  _xZkqqHx_iEkA_xHqqkZx_Size2 _xZkqqHx_iEkA_xHqqkZx_RefCnt_xZkqqHx_iEkA_xHqqkZx_DataId_xZkqqHx_iEkA_xHqqkZx_  Data  _xZkqqHx_iEkA_xHqqkZx_  0   _xZkqqHx_iEkA_xHqqkZx_
 *                      _xZkqqHx_iEkEiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiBgD_xHqqkZx_  _xZkqqHx_iBgDiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkIiEjPiBgD_xHqqkZx_  _xZkqqHx_iBgDiEkIiEjPiEjPiEjPiEkD_xHqqkZx_
 *                      _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjP_xHqqkZx_ dwRemain _xZkqqHx_iEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *                      _xZkqqHx_iBkK_xHqqkZx_                                                                          _xZkqqHx_iBkK_xHqqkZx_
 *                 dwReadPosition                                                                 HeapEnd
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHeapBuffer::Append (FCHeapBuffer& heapBuffer)
{
	// _xZkqqHx_jDfNjBjHiMlDiCmMiImKjChFiBeC_xHqqkZx_
	DWORD dwReadPosition = 0;
	// _xZkqqHx_jDfNjBjHjAoGiCmMiImKjChFiBeCiPeJjCfLiDfKiDePiDiBiDjDiDgHiCmMiImKjChFiCpAjAnNjCoIiBeC_xHqqkZx_
	DWORD dwWritePosition = GetBufferSize() - FD_HEAP_SIZE_SIZE;
	// _xZkqqHx_jDfNjBjHiClHiCoJiDfEiDeDiDfJiCpAiOoGjDlOiBeC_xHqqkZx_
	DWORD dwRemain = heapBuffer.GetBufferSize();
	// _xZkqqHx_iDgPiDgCiDhEiDeAiDfEiDeDiDfJiCpAiKgHjCkDiClHiCoJiBeC_xHqqkZx_
	SetBufferSize(dwWritePosition + dwRemain);
	// _xZkqqHx_iDiPiBfLiDeOiDgPiDgCiDhEiDeAiBeC_xHqqkZx_
	BYTE buff[1000];
	while (dwRemain != 0)
	//----- _xZkqqHx_jBfDiCmEiCmMjDfNjBjHiCkKiPeJjHlJiClHiCoJiCnMiCmFiDiLiBfLiDhG_xHqqkZx_ -----
	{
		// _xZkqqHx_iIoKiJpBiCmFjDfNjBjHiClHiCoJiDfEiDeDiDfJiCpAiOfKiPgPiBeC_xHqqkZx_
		const DWORD dwReadSize = (sizeof(buff) < dwRemain) ? sizeof(buff) : dwRemain;
		// _xZkqqHx_jDfNjBjHiMlDiCkJiCoHiDiPiBfLiDeOiDgPiDgCiDhEiDeAiCmJjDmHiCnNiPgPiClHiBeC_xHqqkZx_
		heapBuffer.Read(dwReadPosition, buff, dwReadSize);
		// _xZkqqHx_jDfNjBjHiMlDiCmMiImKjChFiCpAiInKjDkOiBeC_xHqqkZx_
		dwReadPosition += dwReadSize;
		// _xZkqqHx_jDfNjBjHjAoGiCmJiDiPiBfLiDeOiDgPiDgCiDhEiDeAiCmMjDoAjHgFiCpAiPjBiCkLiNjOiCnOiBeC_xHqqkZx_
		Write(dwWritePosition, buff, dwReadSize);
		// _xZkqqHx_jDfNjBjHjAoGiCmMiImKjChFiCpAiInKjDkOiBeC_xHqqkZx_
		dwWritePosition += dwReadSize;
		// _xZkqqHx_iOgDiCoIiCmMjDfNjBjHiDfEiDeDiDfJiCpAiMlIiOfKiBeC_xHqqkZx_
		dwRemain -= dwReadSize;
	}
} // FCHeapBuffer::Append.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHeapBuffer::GetMaxBufferSize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiMgAiOkOiCmMiDgPiDgCiDhEiDeAiCmFiOoGiCoIjDlOiCoJiNmFjBoFiCmMiDgPiDgCiDhEiDeAiDfEiDeDiDfJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	byHeapBufferType	:_xZkqqHx_iDhBiBfLiDhGiDgPiDgCiDhEiDeAiCmMiDfOiDeDiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
 *				FD_BUFFER_TYPE_MEMORY	:_xZkqqHx_iDiBiDiCiDiKiBfLiDfOiDeDiDhGiCmMiDhBiBfLiDhGiDgPiDgCiDhEiDeAiBeC_xHqqkZx_
 *				FD_BUFFER_TYPE_FILE		:_xZkqqHx_iDhEiDeAiDeDiDiLiDfOiDeDiDhGiCmMiDhBiBfLiDhGiDgPiDgCiDhEiDeAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgPiDgCiDhEiDeAiDfEiDeDiDfJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD FCHeapBuffer::GetMaxBufferSize (BYTE byHeapBufferType)
{
	if (byHeapBufferType == FD_BUFFER_TYPE_MEMORY)
		return FD_MEMORY_HEAP_SIZE;
	else
		return FD_FILE_HEAP_MAX;
} // FCHeapBuffer::GetMaxBufferSize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHeapBuffer::CreateHeapBuffer
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiMgAiOkOiCmFiBeBiDhBiBfLiDhGiDgPiDgCiDhEiDeAiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	byHeapBufferType	:_xZkqqHx_iDhBiBfLiDhGiDgPiDgCiDhEiDeAiCmMiDfOiDeDiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
 *				FD_BUFFER_TYPE_MEMORY	:_xZkqqHx_iDiBiDiCiDiKiBfLiDfOiDeDiDhGiCmMiDhBiBfLiDhGiDgPiDgCiDhEiDeAiBeC_xHqqkZx_
 *				FD_BUFFER_TYPE_FILE		:_xZkqqHx_iDhEiDeAiDeDiDiLiDfOiDeDiDhGiCmMiDhBiBfLiDhGiDgPiDgCiDhEiDeAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhBiBfLiDhGiDgPiDgCiDhEiDeAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void* FCHeapBuffer::CreateHeapBuffer (BYTE byHeapBufferType)
{
	const DWORD dw0 = 0;
	if (byHeapBufferType == FD_BUFFER_TYPE_MEMORY)
	//----- _xZkqqHx_iDiBiDiCiDiKiBfLiDgPiDgCiDhEiDeAiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDgPiDgCiDhEiDeAjHmMiIoGiCpAiNoMjAkMiBeC_xHqqkZx_
		BYTE* pBuff = new BYTE[FD_MEMORY_HEAP_SIZE + sizeof(DWORD)];
		// _xZkqqHx_iDgPiDgCiDhEiDeAiDfEiDeDiDfJiCpAjAoGjDkKiCmJiLeMjIfOiBeC_xHqqkZx_
		const DWORD dwBufferSize = FD_HEAP_SIZE_SIZE;
		memcpy(pBuff, &dwBufferSize, sizeof(dwBufferSize));
		// _xZkqqHx_iDgPiDgCiDhEiDeAiPeJjCfLiCpAiLeMjIfOiBeC_xHqqkZx_
		pBuff += sizeof(dwBufferSize);
		memcpy(pBuff, &dw0, sizeof(dw0));
		return (void*)pBuff;
	} else
	//----- _xZkqqHx_iDhEiDeAiDeDiDiLiDgPiDgCiDhEiDeAiCmMiPoKiNiH_xHqqkZx_ -----
	{
		HANDLE hFile = INVALID_HANDLE_VALUE;
		WString wstrFilePath;
		for (int i = 0; i != 10; i++)
		{
			// _xZkqqHx_iDiGiDgKiBfLiDeOiCmIiDhEiDeAiDeDiDiLjGlMiCmFiDhEiDeAiDeDiDiLiCpAiNoMjAkMiBeC_xHqqkZx_
			FFMakeUniqFileName(	wstrFilePath, 
								s0_read(s_0)->s_TmpDir.GetWorkDir() + L"\\x", L".tmp");
			hFile = ::CreateFile(	WStrToTStr(wstrFilePath),
									GENERIC_READ|GENERIC_WRITE,
									0,
									NULL,
									CREATE_NEW,
									FILE_ATTRIBUTE_NORMAL,
									NULL);
			if (hFile != INVALID_HANDLE_VALUE) break;
		}
		if (hFile == INVALID_HANDLE_VALUE)
			FFThrowMiscUnknown();
		// _xZkqqHx_iPeJjCfLiCpAiLeMjIfOiBeC_xHqqkZx_
		DWORD dwNumberOfBytesWritten;
		WriteFile(hFile, &dw0, sizeof(dw0), &dwNumberOfBytesWritten, NULL);
		// _xZkqqHx_iDiBiDiCiDiKiBfLiCmJiDhEiDeAiDeDiDiLiDgOiDjDiDgIiDiLiCmGiDhEiDeAiDeDiDiLjGlMiCpAiLeMjIfOiClHiCoJiBeC_xHqqkZx_
		FileTypeRec* my = (FileTypeRec*)(new BYTE[sizeof(FileTypeRec) + (wstrFilePath.GetLength() * sizeof(wchar_t))]);
		my->m_hFile = hFile;
		my->m_dwBufferSize = sizeof(dw0);
		wcscpy(my->m_wcpFilePath, wstrFilePath);
		return (void*)my;
	}
} // FCHeapBuffer::CreateHeapBuffer.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHeapBuffer::DeleteHeapBuffer
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhBiBfLiDhGiDgPiDgCiDhEiDeAiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	byHeapBufferType	:_xZkqqHx_iDhBiBfLiDhGiDgPiDgCiDhEiDeAiCmMiDfOiDeDiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
 *				FD_BUFFER_TYPE_MEMORY	:_xZkqqHx_iDiBiDiCiDiKiBfLiDfOiDeDiDhGiCmMiDhBiBfLiDhGiDgPiDgCiDhEiDeAiBeC_xHqqkZx_
 *				FD_BUFFER_TYPE_FILE		:_xZkqqHx_iDhEiDeAiDeDiDiLiDfOiDeDiDhGiCmMiDhBiBfLiDhGiDgPiDgCiDhEiDeAiBeC_xHqqkZx_
 *			pHeapBuffer	:_xZkqqHx_iDhBiBfLiDhGiDgPiDgCiDhEiDeAiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHeapBuffer::DeleteHeapBuffer (BYTE byHeapBufferType, void* pHeapBuffer)
{
	if (byHeapBufferType == FD_BUFFER_TYPE_MEMORY)
	//----- _xZkqqHx_iDiBiDiCiDiKiBfLiDgPiDgCiDhEiDeAiCmMiPoKiNiH_xHqqkZx_ -----
	{
		delete[] ((BYTE*)pHeapBuffer - sizeof(DWORD));
	} else
	//----- _xZkqqHx_iDhEiDeAiDeDiDiLiDgPiDgCiDhEiDeAiCmMiPoKiNiH_xHqqkZx_ -----
	{
		FileTypeRec* my = (FileTypeRec*)pHeapBuffer;
		// _xZkqqHx_iDgOiDjDiDgIiDiLiCpAjFmCiClGiCoJiBeC_xHqqkZx_
		CloseHandle(my->m_hFile);
		// _xZkqqHx_iDhEiDeAiDeDiDiLiCpAiNoNiPjMiBeC_xHqqkZx_
		FFDeleteFile(my->m_wcpFilePath);
		delete[] (BYTE*)my;
	}
} // FCHeapBuffer::DeleteHeapBuffer.

//----- 05.12.13 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHeapBuffer::GetMaxBufferSize
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgPiDgCiDhEiDeAiCmFiOoGiCoIjDlOiCoJiNmFjBoFiCmMiDgPiDgCiDhEiDeAiDfEiDeDiDfJiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgPiDgCiDhEiDeAiDfEiDeDiDfJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//DWORD FCHeapBuffer::GetMaxBufferSize () const
//{
//	if (GetHeapBufferType() == FD_BUFFER_TYPE_MEMORY)
//	//----- _xZkqqHx_iDiBiDiCiDiKiBfLiDgPiDgCiDhEiDeAiCmMiPoKiNiH_xHqqkZx_ -----
//	{
//		return GetMaxBufferSize(FD_BUFFER_TYPE_MEMORY);
//	} else
//	//----- _xZkqqHx_iDhEiDeAiDeDiDiLiDgPiDgCiDhEiDeAiCmMiPoKiNiH_xHqqkZx_ -----
//	{
//		return GetMaxBufferSize(FD_BUFFER_TYPE_FILE);
//	}
//} // FCHeapBuffer::GetMaxBufferSize.
//----- 05.12.13 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHeapBuffer::GetMemoryBuffer
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDiCiDiKiBfLiDfOiDeDiDhGiCmMiDgPiDgCiDhEiDeAiCmMiPoKiNiHiBeBiDgPiDgCiDhEiDeAiCmMiDeBiDgIiDiMiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgPiDgCiDhEiDeAiCmMiDeBiDgIiDiMiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BYTE* FCHeapBuffer::GetMemoryBuffer ()
{
	return (BYTE*)m_pHeapBuffer;
} // FCHeapBuffer::GetMemoryBuffer.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHeapBuffer::GetMemoryBuffer
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDiCiDiKiBfLiDfOiDeDiDhGiCmMiDgPiDgCiDhEiDeAiCmMiPoKiNiHiBeBiDgPiDgCiDhEiDeAiCmMiDeBiDgIiDiMiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgPiDgCiDhEiDeAiCmMiDeBiDgIiDiMiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const BYTE* FCHeapBuffer::GetMemoryBuffer () const
{
	return (const BYTE*)m_pHeapBuffer;
} // FCHeapBuffer::GetMemoryBuffer.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHeapBuffer::GetFileBuffer
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiDfOiDeDiDhGiCmMiDgPiDgCiDhEiDeAiCmMiPoKiNiHiBeBiDgPiDgCiDhEiDeAiCmMiDhEiDeAiDeDiDiLiDgOiDjDiDgIiDiLiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgPiDgCiDhEiDeAiCmMiDhEiDeAiDeDiDiLiDgOiDjDiDgIiDiLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
HANDLE FCHeapBuffer::GetFileBuffer () const
{
	FileTypeRec* my = (FileTypeRec*)m_pHeapBuffer;
	return my->m_hFile;
} // FCHeapBuffer::GetFileBuffer.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHeapBuffer::GetFilePath
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiDfOiDeDiDhGiCmMiDgPiDgCiDhEiDeAiCmMiPoKiNiHiBeBiDhEiDeAiDeDiDiLiDhAiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgPiDgCiDhEiDeAiCmMiDhEiDeAiDeDiDiLiDhAiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const wchar_t* FCHeapBuffer::GetFilePath () const
{
	FileTypeRec* my = (FileTypeRec*)m_pHeapBuffer;
	return my->m_wcpFilePath;
} // FCHeapBuffer::GetFilePath.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHeapBuffer::Read
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhBiBfLiDhGiDgPiDgCiDhEiDeAiCkJiCoHiDgGiBfLiDfOiCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwPosition	:_xZkqqHx_iDhBiBfLiDhGiDgPiDgCiDhEiDeAiCmMjDmHiCnNiPgPiClHiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pBuff		:_xZkqqHx_jDmHiCnNiPgPiClFiClNiDgGiBfLiDfOiCpAiLeMjIfOiClHiCoJiDgPiDgCiDhEiDeAiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwSize		:_xZkqqHx_jDmHiCnNiPgPiClHiDgGiBfLiDfOiDgPiDeDiDgHjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHeapBuffer::Read (DWORD dwPosition, void* pBuff, DWORD dwSize) const
{
	if (GetHeapBufferType() == FD_BUFFER_TYPE_MEMORY)
	//----- _xZkqqHx_iDiBiDiCiDiKiBfLiDgPiDgCiDhEiDeAiCmMiPoKiNiH_xHqqkZx_ -----
	{
		memcpy(pBuff, GetMemoryBuffer() + dwPosition, dwSize);
	} else
	//----- _xZkqqHx_iDhEiDeAiDeDiDiLiDgPiDgCiDhEiDeAiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iMlLiNnNiCmMiDhEiDeAiDeDiDiLiImKjChFiCpAiInKjDkOiBeC_xHqqkZx_
		SetFilePointer(GetFileBuffer(), dwPosition, NULL, FILE_BEGIN);
		// _xZkqqHx_jDmHiCnNiPgPiClHiBeC_xHqqkZx_
		DWORD dwNumberOfBytesRead;
		ReadFile(GetFileBuffer(), pBuff, dwSize, &dwNumberOfBytesRead, NULL);
	}
} // FCHeapBuffer::Read.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHeapBuffer::Write
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhBiBfLiDhGiDgPiDgCiDhEiDeAiCmJiDgGiBfLiDfOiCpAiPjBiCkLiNjOiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwPosition	:_xZkqqHx_iDhBiBfLiDhGiDgPiDgCiDhEiDeAiCmMiPjBiCkLiNjOiCnOiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pBuff		:_xZkqqHx_iPjBiCkLiNjOiCnOiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwSize		:pBuff_xZkqqHx_iCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHeapBuffer::Write (DWORD dwPosition, const void* pBuff, DWORD dwSize)
{
	if (GetHeapBufferType() == FD_BUFFER_TYPE_MEMORY)
	//----- _xZkqqHx_iDiBiDiCiDiKiBfLiDgPiDgCiDhEiDeAiCmMiPoKiNiH_xHqqkZx_ -----
	{
		memcpy(GetMemoryBuffer() + dwPosition, pBuff, dwSize);
	} else
	//----- _xZkqqHx_iDhEiDeAiDeDiDiLiDgPiDgCiDhEiDeAiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iMlLiNnNiCmMiDhEiDeAiDeDiDiLiImKjChFiCpAiInKjDkOiBeC_xHqqkZx_
		SetFilePointer(GetFileBuffer(), dwPosition, NULL, FILE_BEGIN);
		// _xZkqqHx_iPjBiCkLiNjOiCnOiBeC_xHqqkZx_
		DWORD dwNumberOfBytesWritten;
		WriteFile(GetFileBuffer(), pBuff, dwSize, &dwNumberOfBytesWritten, NULL);
	}
} // FCHeapBuffer::Write.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHeapBuffer::SetSegmentSize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDfKiDePiDiBiDjDiDgHiCmMiDfEiDeDiDfJiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwSegmentPosition	:_xZkqqHx_iDfKiDePiDiBiDjDiDgHiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwSegmentSize		:_xZkqqHx_iDfKiDePiDiBiDjDiDgHiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHeapBuffer::SetSegmentSize (DWORD dwSegmentPosition, DWORD dwSegmentSize)
{
	Write(dwSegmentPosition, &dwSegmentSize, sizeof(dwSegmentSize));
} // FCHeapBuffer::SetSegmentSize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHeapBuffer::SetBufferSize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgPiDgCiDhEiDeAiDfEiDeDiDfJiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwBufferSize	:_xZkqqHx_iDgPiDgCiDhEiDeAiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHeapBuffer::SetBufferSize (DWORD dwBufferSize)
{
	if (GetHeapBufferType() == FD_BUFFER_TYPE_MEMORY)
	//----- _xZkqqHx_iDiBiDiCiDiKiBfLiDgPiDgCiDhEiDeAiCmMiPoKiNiH_xHqqkZx_ -----
	{
		memcpy(GetMemoryBuffer() - sizeof(DWORD), &dwBufferSize, sizeof(dwBufferSize));
	} else
	//----- _xZkqqHx_iDhEiDeAiDeDiDiLiDgPiDgCiDhEiDeAiCmMiPoKiNiH_xHqqkZx_ -----
	{
//----- 05.12.14 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		// _xZkqqHx_iDhEiDeAiDeDiDiLiMlLiNnNiImKjChFiCpAiBeBjAfGiClFiCkCiDhEiDeAiDeDiDiLjClHiImKjChFiCmJjAnNjCoIiBeC_xHqqkZx_
//		// _xZkqqHx_iMlLiNnNiCmMiDhEiDeAiDeDiDiLjClHiCpAjClEiCkGiCmEiCkCiCmEiCoAjDkOiNoMiClHiCoJiBeC_xHqqkZx_
//		SetFilePointer(GetFileBuffer(), dwBufferSize, NULL, FILE_BEGIN);
//		// _xZkqqHx_iDhEiDeAiDeDiDiLiPeJjCfLiCpAiMlLiNnNiImKjChFiCmJjAnNjCoIiBeC_xHqqkZx_
//		SetEndOfFile(GetFileBuffer());
//----- 05.12.14 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		if (GetFileSize(GetFileBuffer(), NULL) < dwBufferSize)
		//----- _xZkqqHx_iMlLiNnNiCmMiDhEiDeAiDeDiDiLiDfEiDeDiDfJiCpAiJhKiCkGiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDhEiDeAiDeDiDiLiDfEiDeDiDfJiCpAiKgHjCkDiBeC_xHqqkZx_
			DWORD dwFileSize = FD_FILE_HEAP_UNIT * ((dwBufferSize / FD_FILE_HEAP_UNIT) + 1);
			// _xZkqqHx_iDhEiDeAiDeDiDiLiMlLiNnNiImKjChFiCpAiBeBjAfGiClFiCkCiDhEiDeAiDeDiDiLjClHiImKjChFiCmJjAnNjCoIiBeC_xHqqkZx_
			// _xZkqqHx_iMlLiNnNiCmMiDhEiDeAiDeDiDiLjClHiCpAjClEiCkGiCmEiCkCiCmEiCoAjDkOiNoMiClHiCoJiBeC_xHqqkZx_
			SetFilePointer(GetFileBuffer(), dwFileSize, NULL, FILE_BEGIN);
			// _xZkqqHx_iDhEiDeAiDeDiDiLiPeJjCfLiCpAiMlLiNnNiImKjChFiCmJjAnNjCoIiBeC_xHqqkZx_
			SetEndOfFile(GetFileBuffer());
		}
		FileTypeRec* my = (FileTypeRec*)m_pHeapBuffer;
		my->m_dwBufferSize = dwBufferSize;
//----- 05.12.14 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	}
} // FCHeapBuffer::SetBufferSize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHeapBuffer::CopySegment
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfKiDePiDiBiDjDiDgHiCpAiOhHjCoIiClDiCoKiClNiImKjChFiCmJjFkBiOmKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwSegmentTo		:_xZkqqHx_jFkBiOmKjAoGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwSegmentFrom	:_xZkqqHx_jFkBiOmKiMlDiCmMiDfKiDePiDiBiDjDiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iInKjDkOiClFiClNiDfKiDePiDiBiDjDiDgHiCmMiDfEiDeDiDfJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jDkPiClGiDgPiDgCiDhEiDeAiPoDiCmMiInJiCmIiCoJiImKjChFiKnEiCmFiDfKiDePiDiBiDjDiDgHiCpAjFkBiOmKiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iJlKjAhNiCmMiCoGiCkEiCmIiPoKiNiHiCmNiBeBjFkBiOmKiMlDiCmGjFkBiOmKjAoGiCmFiPgEiCmIiCoJjFjEjFkKiCkKiCkAiCoJiClNiCnP_xHqqkZx_
 *			_xZkqqHx_jCiNiInDiCkKjFeLjHhGiBeC_xHqqkZx_
 *
 *                    dwSegTo   dwSegFrom                    
 *                       _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkFiEjPiEjP_xHqqkZx_- Segment _xZkqqHx_iEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *                 _xZkqqHx_iBgDiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiBgD_xHqqkZx_
 *          _xZkqqHx_jFkBiOmKjBeP_xHqqkZx_       _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkAiChHiChHiChHiChHiChHiChHiChHiChHiChHiChHiChHiEkA_xHqqkZx_      
 *                 _xZkqqHx_iBgDiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkIiEjPiEjPiEjPiBgD_xHqqkZx_
 *                                 _xZkqqHx_iEkF_xHqqkZx_ _xZkqqHx_iPgEiCmIiCoJjFjEjFkK_xHqqkZx_ _xZkqqHx_iEkH_xHqqkZx_
 *                 _xZkqqHx_iBgDiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiBgD_xHqqkZx_
 *          _xZkqqHx_jFkBiOmKiMoD_xHqqkZx_       _xZkqqHx_iEkAiChHiChHiChHiChHiChHiChHiChHiChHiChHiChHiChHiEkA_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_      
 *                 _xZkqqHx_iBgDiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEkIiEjPiEjPiEjPiBgD_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD FCHeapBuffer::CopySegment (DWORD dwSegmentTo, DWORD dwSegmentFrom)
{
	const DWORD dwSegmentSize = GetSegmentSize(dwSegmentFrom);
	if (GetHeapBufferType() == FD_BUFFER_TYPE_MEMORY)
	//----- _xZkqqHx_iDiBiDiCiDiKiBfLiDgPiDgCiDhEiDeAiCmMiPoKiNiH_xHqqkZx_ -----
	{
		memmove(GetMemoryBuffer() + dwSegmentTo,
				GetMemoryBuffer() + dwSegmentFrom,
				dwSegmentSize);
	} else
	//----- _xZkqqHx_iDhEiDeAiDeDiDiLiDgPiDgCiDhEiDeAiCmMiPoKiNiH_xHqqkZx_ -----
	{
		BYTE* pBuff = new BYTE[dwSegmentSize];
		Read(dwSegmentFrom, pBuff, dwSegmentSize);
		Write(dwSegmentTo, pBuff, dwSegmentSize);
		delete[] pBuff;
	}
	return dwSegmentSize;
} // FCHeapBuffer::CopySegment.

